import{g as yt}from"./_commonjsHelpers-725317a4.js";var ft={exports:{}};/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2023 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 9.10.2
 * @date    2023-05-15
 */(function(Ct,bt){(function(Ye,at){Ct.exports=at()})(self,function(){return at={897:function(ce,g,D){D.d(g,{x:function(){return X}});var U=D(2602),k=D(9791),M=D(7907);function K(G){return(K=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(L){return typeof L}:function(L){return L&&typeof Symbol=="function"&&L.constructor===Symbol&&L!==Symbol.prototype?"symbol":typeof L})(G)}function j(G,L){for(var A=0;A<L.length;A++){var f=L[A];f.enumerable=f.enumerable||!1,f.configurable=!0,"value"in f&&(f.writable=!0),Object.defineProperty(G,function(T){return T=function(I,m){if(K(I)!=="object"||I===null)return I;var h=I[Symbol.toPrimitive];if(h===void 0)return(m==="string"?String:Number)(I);if(h=h.call(I,m||"default"),K(h)!=="object")return h;throw new TypeError("@@toPrimitive must return a primitive value.")}(T,"string"),K(T)==="symbol"?T:String(T)}(f.key),f)}}var X=function(){function G(f,m){if(!(this instanceof G))throw new TypeError("Cannot call a class as a function");this.dom={};var I=this,a=this.dom,m=(this.anchor=void 0,this.items=f,this.eventListeners={},this.selection=void 0,this.onClose=m?m.close:void 0,this.limitHeight=!!m&&m.limitHeight,document.createElement("div")),h=(m.className="jsoneditor-contextmenu-root",a.root=m,document.createElement("div")),m=(h.className="jsoneditor-contextmenu",a.menu=h,m.appendChild(h),document.createElement("ul")),h=(m.className="jsoneditor-menu",h.appendChild(m),a.list=m,a.items=[],document.createElement("button")),a=(h.type="button",a.focusButton=h,document.createElement("li"));a.style.overflow="hidden",a.style.height="0",a.appendChild(h),m.appendChild(a),function l(t,r,e){e.forEach(function(n){var s,o,i,c,d,C;n.type==="separator"?((d=document.createElement("div")).className="jsoneditor-separator",(o=document.createElement("li")).appendChild(d),t.appendChild(o)):(s={},d=document.createElement("li"),t.appendChild(d),(o=document.createElement("button")).type="button",o.className=n.className,s.button=o,n.title&&(o.title=n.title),n.click&&(o.onclick=function(p){p.preventDefault(),I.hide(),n.click()}),d.appendChild(o),n.submenu?((c=document.createElement("div")).className="jsoneditor-icon",o.appendChild(c),(c=document.createElement("div")).className="jsoneditor-text"+(n.click?"":" jsoneditor-right-margin"),c.appendChild(document.createTextNode(n.text)),o.appendChild(c),(i=n.click?(o.className+=" jsoneditor-default",(c=document.createElement("button")).type="button",(s.buttonExpand=c).className="jsoneditor-expand",(C=document.createElement("div")).className="jsoneditor-expand",c.appendChild(C),d.appendChild(c),n.submenuTitle&&(c.title=n.submenuTitle),c):((C=document.createElement("div")).className="jsoneditor-expand",o.appendChild(C),o)).onclick=function(p){p.preventDefault(),I._onExpandItem(s),i.focus()},s.subItems=c=[],C=document.createElement("ul"),(s.ul=C).className="jsoneditor-menu",C.style.height="0",d.appendChild(C),l(C,c,n.submenu)):((d=document.createElement("div")).className="jsoneditor-icon",o.appendChild(d),(C=document.createElement("div")).className="jsoneditor-text",C.appendChild(document.createTextNode((0,M.Iu)(n.text))),o.appendChild(C)),r.push(s))})}(m,this.dom.items,f),this.maxHeight=0,f.forEach(function(l){l=24*(f.length+(l.submenu?l.submenu.length:0)),I.maxHeight=Math.max(I.maxHeight,l)})}var L,A;return L=G,(A=[{key:"_getVisibleButtons",value:function(){var f=[],T=this;return this.dom.items.forEach(function(I){f.push(I.button),I.buttonExpand&&f.push(I.buttonExpand),I.subItems&&I===T.expandedItem&&I.subItems.forEach(function(m){f.push(m.button),m.buttonExpand&&f.push(m.buttonExpand)})}),f}},{key:"show",value:function(f,r,I){this.hide();var m=!0,a=f.parentNode,h=f.getBoundingClientRect(),a=a.getBoundingClientRect(),l=r.getBoundingClientRect(),t=this,r=(this.dom.absoluteAnchor=(0,U.w)(f,r,function(){t.hide()}),h.bottom+this.maxHeight<l.bottom||h.top-this.maxHeight>l.top&&(m=!1),I?0:h.top-a.top);m?(I=f.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=r+I+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px"),this.limitHeight&&(a=m?l.bottom-h.bottom-10:h.top-l.top-10,this.dom.list.style.maxHeight=a+"px",this.dom.list.style.overflowY="auto"),this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=(0,k.getSelection)(),this.anchor=f,setTimeout(function(){t.dom.focusButton.focus()},0),G.visibleMenu&&G.visibleMenu.hide(),G.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose)&&this.onClose(),G.visibleMenu===this&&(G.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(f){var T,I=this,m=f===this.expandedItem,h=this.expandedItem;h&&(h.ul.style.height="0",h.ul.style.padding="",setTimeout(function(){I.expandedItem!==h&&(h.ul.style.display="",k.removeClassName)(h.ul.parentNode,"jsoneditor-selected")},300),this.expandedItem=void 0),m||((T=f.ul).style.display="block",T.clientHeight,setTimeout(function(){if(I.expandedItem===f){for(var a=0,l=0;l<T.childNodes.length;l++)a+=T.childNodes[l].clientHeight;T.style.height=a+"px",T.style.padding="5px 10px"}},0),(0,k.addClassName)(T.parentNode,"jsoneditor-selected"),this.expandedItem=f)}},{key:"_onKeyDown",value:function(f){var T,I,m,h,a=f.target,l=f.which,t=!1;l===27?(this.selection&&(0,k.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),t=!0):l===9?f.shiftKey?(I=(T=this._getVisibleButtons()).indexOf(a))===0&&(T[T.length-1].focus(),t=!0):(I=(T=this._getVisibleButtons()).indexOf(a))===T.length-1&&(T[0].focus(),t=!0):l===37?(a.className==="jsoneditor-expand"&&(I=(T=this._getVisibleButtons()).indexOf(a),m=T[I-1])&&m.focus(),t=!0):l===38?(I=(T=this._getVisibleButtons()).indexOf(a),(m=(m=(m=T[I-1])&&m.className==="jsoneditor-expand"?T[I-2]:m)||T[T.length-1])&&m.focus(),t=!0):l===39?(I=(T=this._getVisibleButtons()).indexOf(a),(h=T[I+1])&&h.className==="jsoneditor-expand"&&h.focus(),t=!0):l===40&&(I=(T=this._getVisibleButtons()).indexOf(a),(h=(h=(h=T[I+1])&&h.className==="jsoneditor-expand"?T[I+2]:h)||T[0])&&(h.focus(),t=!0),t=!0),t&&(f.stopPropagation(),f.preventDefault())}}])&&j(L.prototype,A),Object.defineProperty(L,"prototype",{writable:!1}),G}();X.visibleMenu=void 0},6436:function(ce,g,D){function U(K){return(U=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(j){return typeof j}:function(j){return j&&typeof Symbol=="function"&&j.constructor===Symbol&&j!==Symbol.prototype?"symbol":typeof j})(K)}function k(K,j){for(var X=0;X<j.length;X++){var G=j[X];G.enumerable=G.enumerable||!1,G.configurable=!0,"value"in G&&(G.writable=!0),Object.defineProperty(K,function(L){return L=function(A,f){if(U(A)!=="object"||A===null)return A;var T=A[Symbol.toPrimitive];if(T===void 0)return(f==="string"?String:Number)(A);if(T=T.call(A,f||"default"),U(T)!=="object")return T;throw new TypeError("@@toPrimitive must return a primitive value.")}(L,"string"),U(L)==="symbol"?L:String(L)}(G.key),G)}}D.d(g,{Q:function(){return M}});var M=function(){function K(L){if(!(this instanceof K))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=L.errorTableVisible,this.onToggleVisibility=L.onToggleVisibility,this.onFocusLine=L.onFocusLine||function(){},this.onChangeHeight=L.onChangeHeight,this.dom={};var L=document.createElement("div"),A=(L.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=L,document.createElement("div")),L=(A.style.display="none",A.className="jsoneditor-additional-errors fadein",A.textContent="Scroll for more ▿",this.dom.additionalErrorsIndication=A,L.appendChild(A),document.createElement("span")),A=(L.className="jsoneditor-validation-error-icon",L.style.display="none",this.dom.validationErrorIcon=L,document.createElement("span"));A.className="jsoneditor-validation-error-count",A.style.display="none",this.dom.validationErrorCount=A,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}var j,X;return j=K,(X=[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(G,L){var A,f,T=this,I=(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<G.length?((I=document.createElement("div")).className="jsoneditor-validation-errors",(f=document.createElement("table")).className="jsoneditor-text-errors",I.appendChild(f),A=document.createElement("tbody"),f.appendChild(A),G.forEach(function(m){isNaN(m.line)?m.dataPath&&(a=L.find(function(r){return r.path===m.dataPath}))&&(h=a.line+1):h=m.line;var h,a=document.createElement("tr"),l=(a.className=isNaN(h)?"":"jump-to-line",m.type==="error"?a.className+=" parse-error":a.className+=" validation-error",document.createElement("td")),t=document.createElement("button"),t=(t.className="jsoneditor-schema-error",l.appendChild(t),a.appendChild(l),document.createElement("td"));t.style="white-space: nowrap;",t.textContent=isNaN(h)?"":"Ln "+h,a.appendChild(t),typeof m=="string"?((l=document.createElement("td")).colSpan=2,(t=document.createElement("pre")).appendChild(document.createTextNode(m)),l.appendChild(t),a.appendChild(l)):((t=document.createElement("td")).appendChild(document.createTextNode(m.dataPath||"")),a.appendChild(t),l=document.createElement("td"),(t=document.createElement("pre")).appendChild(document.createTextNode(m.message.replace(/<br>/gi,`
`))),l.appendChild(t),a.appendChild(l)),a.onclick=function(){T.onFocusLine(h)},A.appendChild(a)}),this.dom.validationErrors=I,this.dom.validationErrorsContainer.appendChild(I),this.dom.additionalErrorsIndication.title=G.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){T.dom.additionalErrorsIndication.style.display=0<T.dom.validationErrorsContainer.clientHeight&&T.dom.validationErrorsContainer.scrollTop===0?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0,f=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0),this.onChangeHeight(f)):this.onChangeHeight(0),G.filter(function(m){return m.type!=="error"}).length);0<I?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=I,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=I+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),G.some(function(m){return m.type==="error"})?(f=G[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(f)?"parse error - check that the json is valid":"parse error on line "+f,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}])&&k(j.prototype,X),Object.defineProperty(j,"prototype",{writable:!1}),K}()},2474:function(ce,g,D){function U(K){return(U=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(j){return typeof j}:function(j){return j&&typeof Symbol=="function"&&j.constructor===Symbol&&j!==Symbol.prototype?"symbol":typeof j})(K)}function k(K,j){for(var X=0;X<j.length;X++){var G=j[X];G.enumerable=G.enumerable||!1,G.configurable=!0,"value"in G&&(G.writable=!0),Object.defineProperty(K,function(L){return L=function(A,f){if(U(A)!=="object"||A===null)return A;var T=A[Symbol.toPrimitive];if(T===void 0)return(f==="string"?String:Number)(A);if(T=T.call(A,f||"default"),U(T)!=="object")return T;throw new TypeError("@@toPrimitive must return a primitive value.")}(L,"string"),U(L)==="symbol"?L:String(L)}(G.key),G)}}D.d(g,{R:function(){return M}});var M=function(){function K(G){if(!(this instanceof K))throw new TypeError("Cannot call a class as a function");if(this.target=G.target||null,!this.target)throw new Error('FocusTracker constructor called without a "target" to track.');this.onFocus=typeof G.onFocus=="function"?G.onFocus:null,this.onBlur=typeof G.onBlur=="function"?G.onBlur:null,this._onClick=this._onEvent.bind(this),this._onKeyUp=(function(L){L.which!==9&&L.keyCode!==9||this._onEvent(L)}).bind(this),this._onBlur=this._onEvent.bind(this),this.focusFlag=!1,this.firstEventFlag=!0,(this.onFocus||this.onBlur)&&(document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp),document.addEventListener("blur",this._onBlur))}var j,X;return j=K,(X=[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick),document.removeEventListener("keyup",this._onKeyUp),document.removeEventListener("blur",this._onBlur),this._onEvent({target:document.body})}},{key:"_onEvent",value:function(G){G=G.target,G=G===this.target||!(!this.target.contains(G)&&!this.target.contains(document.activeElement)),G?this.focusFlag||(this.onFocus&&this.onFocus({type:"focus",target:this.target}),this.focusFlag=!0):(this.focusFlag||this.firstEventFlag)&&(this.onBlur&&this.onBlur({type:"blur",target:this.target}),this.focusFlag=!1,this.firstEventFlag)&&(this.firstEventFlag=!1)}}])&&k(j.prototype,X),Object.defineProperty(j,"prototype",{writable:!1}),K}()},3161:function(ce,g,D){var U=D(8170),k=D(8037),M=D(8038).treeModeMixins,K=D(8458).textModeMixins,j=D(341).previewModeMixins,T=D(9791),X=T.clear,G=T.extend,L=T.getInnerText,A=T.getInternetExplorerVersion,f=T.parse,T=D(2744).tryRequireAjv,I=D(2558).showTransformModal,m=D(6210).showSortModal,h=T();function a(l,t,r){if(!(this instanceof a))throw new Error('JSONEditor constructor called without "new".');var e=A();if(e!==-1&&e<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&(t.mode==="text"||t.mode==="code"||t.modes&&(t.modes.indexOf("text")!==-1||t.modes.indexOf("code")!==-1))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),t)&&Object.keys(t).forEach(function(n){a.VALID_OPTIONS.indexOf(n)===-1&&console.warn('Unknown option "'+n+'". This option will be ignored')}),arguments.length&&this._create(l,t,r)}typeof Promise>"u"&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),a.modes={},a.prototype.DEBOUNCE_INTERVAL=150,a.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onExpand","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","onFocus","onBlur","colorPicker","onColorPicker","timestampTag","timestampFormat","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","limitDragging","maxVisibleChilds","onValidationError","modalAnchor","popupAnchor","createQuery","executeQuery","queryDescription","allowSchemaSuggestions","showErrorTable"],a.prototype._create=function(l,t,r){this.container=l,this.options=t||{},this.json=r||{},l=this.options.mode||this.options.modes&&this.options.modes[0]||"tree",this.setMode(l)},a.prototype.destroy=function(){},a.prototype.set=function(l){this.json=l},a.prototype.get=function(){return this.json},a.prototype.setText=function(l){this.json=f(l)},a.prototype.getText=function(){return JSON.stringify(this.json)},a.prototype.setName=function(l){this.options||(this.options={}),this.options.name=l},a.prototype.getName=function(){return this.options&&this.options.name},a.prototype.setMode=function(l){if(l!==this.options.mode||!this.create){var t=this.container,r=G({},this.options),e=r.mode,n=(r.mode=l,a.modes[l]);if(!n)throw new Error('Unknown mode "'+r.mode+'"');var s=n.data==="text",o=this.getName(),i=this[s?"getText":"get"]();if(this.destroy(),X(this),G(this,n.mixin),this.create(t,r),this.setName(o),this[s?"setText":"set"](i),typeof n.load=="function")try{n.load.call(this)}catch(c){console.error(c)}if(typeof r.onModeChange=="function"&&l!==e)try{r.onModeChange(l,e)}catch(c){console.error(c)}}},a.prototype.getMode=function(){return this.options.mode},a.prototype._onError=function(l){this.options&&typeof this.options.onError=="function"?this.options.onError(l):window.alert(l.toString())},a.prototype.setSchema=function(l,t){if(l){var r;try{this.options.ajv?r=this.options.ajv:((r=h({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(D(7171)),r.addMetaSchema(D(6273)))}catch{console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(r){if(t){for(var e in t)r.removeSchema(e),t[e]&&r.addSchema(t[e],e);this.options.schemaRefs=t}this.validateSchema=r.compile(l),this.options.schema=l,this.options.schemaRefs=t,this.validate()}}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate();this.refresh(),typeof this._onSchemaChange=="function"&&this._onSchemaChange(l,t)},a.prototype.validate=function(){},a.prototype.refresh=function(){},(a.registerMode=function(l){var t;if(Array.isArray(l))for(n=0;n<l.length;n++)a.registerMode(l[n]);else{if(!("mode"in l))throw new Error('Property "mode" missing');if(!("mixin"in l))throw new Error('Property "mixin" missing');if(!("data"in l))throw new Error('Property "data" missing');var r=l.mode;if(r in a.modes)throw new Error('Mode "'+r+'" already registered');if(typeof l.mixin.create!="function")throw new Error('Required function "create" missing on mixin');for(var e=["setMode","registerMode","modes"],n=0;n<e.length;n++)if((t=e[n])in l.mixin)throw new Error('Reserved property "'+t+'" not allowed in mixin');a.modes[r]=l}})(M),a.registerMode(K),a.registerMode(j),a.ace=U,a.Ajv=h,a.VanillaPicker=k,a.showTransformModal=I,a.showSortModal=m,a.getInnerText=L,ce.exports=a.default=a},6617:function(ce,g,D){D.d(g,{x:function(){return j}});var U=D(897),k=D(7907);function M(X){return(M=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(G){return typeof G}:function(G){return G&&typeof Symbol=="function"&&G.constructor===Symbol&&G!==Symbol.prototype?"symbol":typeof G})(X)}function K(X,G){for(var L=0;L<G.length;L++){var A=G[L];A.enumerable=A.enumerable||!1,A.configurable=!0,"value"in A&&(A.writable=!0),Object.defineProperty(X,function(f){return f=function(T,I){if(M(T)!=="object"||T===null)return T;var m=T[Symbol.toPrimitive];if(m===void 0)return(I==="string"?String:Number)(T);if(m=m.call(T,I||"default"),M(m)!=="object")return m;throw new TypeError("@@toPrimitive must return a primitive value.")}(f,"string"),M(f)==="symbol"?f:String(f)}(A.key),A)}}var j=function(){function X(A,f,T,I){if(!(this instanceof X))throw new TypeError("Cannot call a class as a function");for(var m={code:{text:(0,k.Iu)("modeCodeText"),title:(0,k.Iu)("modeCodeTitle"),click:function(){I("code")}},form:{text:(0,k.Iu)("modeFormText"),title:(0,k.Iu)("modeFormTitle"),click:function(){I("form")}},text:{text:(0,k.Iu)("modeTextText"),title:(0,k.Iu)("modeTextTitle"),click:function(){I("text")}},tree:{text:(0,k.Iu)("modeTreeText"),title:(0,k.Iu)("modeTreeTitle"),click:function(){I("tree")}},view:{text:(0,k.Iu)("modeViewText"),title:(0,k.Iu)("modeViewTitle"),click:function(){I("view")}},preview:{text:(0,k.Iu)("modePreviewText"),title:(0,k.Iu)("modePreviewTitle"),click:function(){I("preview")}}},h=[],a=0;a<f.length;a++){var l=f[a],t=m[l];if(!t)throw new Error('Unknown mode "'+l+'"');t.className="jsoneditor-type-modes"+(T===l?" jsoneditor-selected":""),h.push(t)}var e=m[T];if(!e)throw new Error('Unknown mode "'+T+'"');var e=e.text,r=document.createElement("button"),e=(r.type="button",r.className="jsoneditor-modes jsoneditor-separator",r.textContent=e+" ▾",r.title=(0,k.Iu)("modeEditorTitle"),r.onclick=function(){new U.x(h).show(r,A)},document.createElement("div"));e.className="jsoneditor-modes",e.style.position="relative",e.appendChild(r),A.appendChild(e),this.dom={container:A,box:r,frame:e}}var G,L;return G=X,(L=[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}])&&K(G.prototype,L),Object.defineProperty(G,"prototype",{writable:!1}),X}()},8170:function(ce,g,D){var U;if(window.ace)U=window.ace;else try{U=D(6225),D(4091),D(3330),D(4317);var k=D(7923);U.config.setModuleUrl("ace/mode/json_worker",k)}catch{}ce.exports=U},4864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(ce,g,D){g.isDark=!1,g.cssClass="ace-jsoneditor",g.cssText=`.ace-jsoneditor .ace_gutter {
background: #ebebeb;
color: #333
}

.ace-jsoneditor.ace_editor {
line-height: 1.3;
background-color: #fff;
}
.ace-jsoneditor .ace_print-margin {
width: 1px;
background: #e8e8e8
}
.ace-jsoneditor .ace_scroller {
background-color: #FFFFFF
}
.ace-jsoneditor .ace_text-layer {
color: gray
}
.ace-jsoneditor .ace_variable {
color: #1a1a1a
}
.ace-jsoneditor .ace_cursor {
border-left: 2px solid #000000
}
.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {
border-left: 0px;
border-bottom: 1px solid #000000
}
.ace-jsoneditor .ace_marker-layer .ace_selection {
background: lightgray
}
.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {
box-shadow: 0 0 3px 0px #FFFFFF;
border-radius: 2px
}
.ace-jsoneditor .ace_marker-layer .ace_step {
background: rgb(255, 255, 0)
}
.ace-jsoneditor .ace_marker-layer .ace_bracket {
margin: -1px 0 0 -1px;
border: 1px solid #BFBFBF
}
.ace-jsoneditor .ace_marker-layer .ace_active-line {
background: #FFFBD1
}
.ace-jsoneditor .ace_gutter-active-line {
background-color : #dcdcdc
}
.ace-jsoneditor .ace_marker-layer .ace_selected-word {
border: 1px solid lightgray
}
.ace-jsoneditor .ace_invisible {
color: #BFBFBF
}
.ace-jsoneditor .ace_keyword,
.ace-jsoneditor .ace_meta,
.ace-jsoneditor .ace_support.ace_constant.ace_property-value {
color: #AF956F
}
.ace-jsoneditor .ace_keyword.ace_operator {
color: #484848
}
.ace-jsoneditor .ace_keyword.ace_other.ace_unit {
color: #96DC5F
}
.ace-jsoneditor .ace_constant.ace_language {
color: darkorange
}
.ace-jsoneditor .ace_constant.ace_numeric {
color: red
}
.ace-jsoneditor .ace_constant.ace_character.ace_entity {
color: #BF78CC
}
.ace-jsoneditor .ace_invalid {
color: #FFFFFF;
background-color: #FF002A;
}
.ace-jsoneditor .ace_fold {
background-color: #AF956F;
border-color: #000000
}
.ace-jsoneditor .ace_storage,
.ace-jsoneditor .ace_support.ace_class,
.ace-jsoneditor .ace_support.ace_function,
.ace-jsoneditor .ace_support.ace_other,
.ace-jsoneditor .ace_support.ace_type {
color: #C52727
}
.ace-jsoneditor .ace_string {
color: green
}
.ace-jsoneditor .ace_comment {
color: #BCC8BA
}
.ace-jsoneditor .ace_entity.ace_name.ace_tag,
.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {
color: #606060
}
.ace-jsoneditor .ace_markup.ace_underline {
text-decoration: underline
}
.ace-jsoneditor .ace_indent-guide {
background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y
}`,ce("../lib/dom").importCssString(g.cssText,g.cssClass)})},6589:function(ce,g){(D={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(U,k,M,K,j,X,G){var L=X.length-1;switch(j){case 1:this.$=U.replace(/\\(\\|")/g,"$1").replace(/\\n/g,`
`).replace(/\\r/g,"\r").replace(/\\t/g,"	").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(U);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=X[L-1];case 13:this.$={};break;case 14:this.$=X[L-1];break;case 15:this.$=[X[L-2],X[L]];break;case 16:this.$={},this.$[X[L][0]]=X[L][1];break;case 17:this.$=X[L-2],X[L-2][X[L][0]]=X[L][1];break;case 18:this.$=[];break;case 19:this.$=X[L-1];break;case 20:this.$=[X[L]];break;case 21:this.$=X[L-2],X[L-2].push(X[L])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(U,k){throw new Error(U)},parse:function(U){var k=this,M=[0],K=[null],j=[],X=this.table,G="",L=0,A=0,f=0,T=(this.lexer.setInput(U),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,this.lexer.yylloc===void 0&&(this.lexer.yylloc={}),this.lexer.yylloc);function I(){var c=k.lexer.lex()||1;return c=typeof c!="number"&&k.symbols_[c]||c}j.push(T),typeof this.yy.parseError=="function"&&(this.parseError=this.yy.parseError);for(var m,h,a,l,t,r,e,n,s,o={};;){if(a=M[M.length-1],(l=this.defaultActions[a]||(m==null&&(m=I()),X[a]&&X[a][m]))===void 0||!l.length||!l[0]){if(!f){for(t in n=[],X[a])this.terminals_[t]&&2<t&&n.push("'"+this.terminals_[t]+"'");var i="",i=this.lexer.showPosition?"Parse error on line "+(L+1)+`:
`+this.lexer.showPosition()+`
Expecting `+n.join(", ")+", got '"+this.terminals_[m]+"'":"Parse error on line "+(L+1)+": Unexpected "+(m==1?"end of input":"'"+(this.terminals_[m]||m)+"'");this.parseError(i,{text:this.lexer.match,token:this.terminals_[m]||m,line:this.lexer.yylineno,loc:T,expected:n})}if(f==3){if(m==1)throw new Error(i||"Parsing halted.");A=this.lexer.yyleng,G=this.lexer.yytext,L=this.lexer.yylineno,T=this.lexer.yylloc,m=I()}for(;!(2 .toString()in X[a]);){if(a==0)throw new Error(i||"Parsing halted.");s=1,M.length=M.length-2*s,K.length=K.length-s,j.length=j.length-s,a=M[M.length-1]}h=m,m=2,l=X[a=M[M.length-1]]&&X[a][2],f=3}if(l[0]instanceof Array&&1<l.length)throw new Error("Parse Error: multiple actions possible at state: "+a+", token: "+m);switch(l[0]){case 1:M.push(m),K.push(this.lexer.yytext),j.push(this.lexer.yylloc),M.push(l[1]),m=null,h?(m=h,h=null):(A=this.lexer.yyleng,G=this.lexer.yytext,L=this.lexer.yylineno,T=this.lexer.yylloc,0<f&&f--);break;case 2:if(r=this.productions_[l[1]][1],o.$=K[K.length-r],o._$={first_line:j[j.length-(r||1)].first_line,last_line:j[j.length-1].last_line,first_column:j[j.length-(r||1)].first_column,last_column:j[j.length-1].last_column},(e=this.performAction.call(o,G,A,L,this.yy,l[1],K,j))!==void 0)return e;r&&(M=M.slice(0,-1*r*2),K=K.slice(0,-1*r),j=j.slice(0,-1*r)),M.push(this.productions_[l[1]][0]),K.push(o.$),j.push(o._$),e=X[M[M.length-2]][M[M.length-1]],M.push(e);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(U,k){if(!this.yy.parseError)throw new Error(U);this.yy.parseError(U,k)},setInput:function(U){return this._input=U,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var U=this._input[0];return this.yytext+=U,this.yyleng++,this.match+=U,this.matched+=U,U.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),U},unput:function(U){return this._input=U+this._input,this},more:function(){return this._more=!0,this},less:function(U){this._input=this.match.slice(U)+this._input},pastInput:function(){var U=this.matched.substr(0,this.matched.length-this.match.length);return(20<U.length?"...":"")+U.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var U=this.match;return U.length<20&&(U+=this._input.substr(0,20-U.length)),(U.substr(0,20)+(20<U.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var U=this.pastInput(),k=new Array(U.length+1).join("-");return U+this.upcomingInput()+`
`+k+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var U,k,M,K,j=this._currentRules(),X=0;X<j.length&&(!(k=this._input.match(this.rules[j[X]]))||U&&!(k[0].length>U[0].length)||(U=k,M=X,this.options.flex));X++);return U?((K=U[0].match(/\n.*/g))&&(this.yylineno+=K.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:K?K[K.length-1].length-1:this.yylloc.last_column+U[0].length},this.yytext+=U[0],this.match+=U[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(U[0].length),this.matched+=U[0],K=this.performAction.call(this,this.yy,this,j[M],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),K||void 0):this._input===""?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+`. Unrecognized text.
`+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var U=this.next();return U!==void 0?U:this.lex()},begin:function(U){this.conditionStack.push(U)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(U){this.begin(U)},options:{},performAction:function(U,k,M,K){switch(M){case 0:break;case 1:return 6;case 2:return k.yytext=k.yytext.substr(1,k.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}};var D;g.parser=D,g.parse=D.parse.bind(D)},3879:function(ce){function g(){}g.prototype={on:function(L,A){this._events=this._events||{},this._events[L]=this._events[L]||[],this._events[L].push(A)},off:function(L,A){this._events=this._events||{},L in this._events&&this._events[L].splice(this._events[L].indexOf(A),1)},emit:function(L){if(this._events=this._events||{},L in this._events)for(var A=0;A<this._events[L].length;A++)this._events[L][A].apply(this,Array.prototype.slice.call(arguments,1))}},g.mixin=function(L){for(var A=["on","off","emit"],f=0;f<A.length;f++)typeof L=="function"?L.prototype[A[f]]=g.prototype[A[f]]:L[A[f]]=g.prototype[A[f]];return L};var D={escapeRegExp:function(L){var A=/[\\^$.*+?()[\]{}|]/g,f=new RegExp(A.source);return L&&f.test(L)?L.replace(A,"\\$&"):L},extend:function(L,A){for(var f in A){var T;A.hasOwnProperty(f)&&((T=A[f])&&Object.prototype.toString.call(T)==="[object Object]"?(L[f]=L[f]||{},D.extend(L[f],T)):L[f]=T)}return L},each:function(L,A,f){if(Object.prototype.toString.call(L)==="[object Object]")for(var T in L)Object.prototype.hasOwnProperty.call(L,T)&&A.call(f,T,L[T],L);else for(var I=0,m=L.length;I<m;I++)A.call(f,I,L[I],L)},createElement:function(L,A){var f,T=document.createElement(L);if(A&&Object.prototype.toString.call(A)==="[object Object]")for(f in A)f in T?T[f]=A[f]:f==="html"?T.innerHTML=A[f]:T.setAttribute(f,A[f]);return T},hasClass:function(L,A){if(L)return L.classList?L.classList.contains(A):!!L.className&&!!L.className.match(new RegExp("(\\s|^)"+A+"(\\s|$)"))},addClass:function(L,A){D.hasClass(L,A)||(L.classList?L.classList.add(A):L.className=L.className.trim()+" "+A)},removeClass:function(L,A){D.hasClass(L,A)&&(L.classList?L.classList.remove(A):L.className=L.className.replace(new RegExp("(^|\\s)"+A.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(L,A){return L&&L!==document.body&&(A(L)?L:D.closest(L.parentNode,A))},isInt:function(L){return typeof L=="number"&&isFinite(L)&&Math.floor(L)===L},debounce:function(L,A,f){var T;return function(){var I=this,m=arguments,h=f&&!T;clearTimeout(T),T=setTimeout(function(){T=null,f||L.apply(I,m)},A),h&&L.apply(I,m)}},rect:function(T,m){var f=window,T=T.getBoundingClientRect(),I=m?f.pageXOffset:0,m=m?f.pageYOffset:0;return{bottom:T.bottom+m,height:T.height,left:T.left+I,right:T.right+I,top:T.top+m,width:T.width}},includes:function(L,A){return-1<L.indexOf(A)},startsWith:function(L,A){return L.substr(0,A.length)===A},truncate:function(L){for(;L.firstChild;)L.removeChild(L.firstChild)}};function U(L,A){return L.hasOwnProperty(A)&&(L[A]===!0||L[A].length)}function k(L,A,f){L.parentNode?L.parentNode.parentNode||A.appendChild(L.parentNode):A.appendChild(L),D.removeClass(L,"excluded"),f||(L.textContent=L.textContent)}function M(){var L,A;this.items.length&&(L=document.createDocumentFragment(),this.config.pagination?(A=this.pages.slice(0,this.pageIndex),D.each(A,function(f,T){D.each(T,function(I,m){k(m,L,this.customOption)},this)},this)):D.each(this.items,function(f,T){k(T,L,this.customOption)},this),L.childElementCount&&(D.removeClass(this.items[this.navIndex],"active"),this.navIndex=(L.querySelector(".selectr-option.selected")||L.querySelector(".selectr-option")).idx,D.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(L))}function K(L,A){A=A||L;var f={class:"selectr-option",role:"treeitem","aria-selected":!1};return this.customOption?f.html=this.config.renderOption(A):f.textContent=L.textContent,(A=D.createElement("li",f)).idx=L.idx,this.items.push(A),L.defaultSelected&&this.defaultSelected.push(L.idx),L.disabled&&(A.disabled=!0,D.addClass(A,"disabled")),A}function j(){var L,A=this.tree,f=A.scrollTop;A.scrollHeight-A.offsetHeight<=f&&this.pageIndex<this.pages.length&&(L=document.createDocumentFragment(),D.each(this.pages[this.pageIndex],function(T,I){k(I,L,this.customOption)},this),A.appendChild(L),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length}))}function X(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&D.removeClass(this.inputContainer,"active"),D.hasClass(this.container,"notice")&&(D.removeClass(this.container,"notice"),D.addClass(this.container,"open"),this.input.focus()),D.each(this.items,function(L,A){D.removeClass(A,"excluded"),this.customOption||(A.textContent=A.textContent)},this))}function G(L,A){if(!L)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if(typeof(this.el=L)=="string"&&(this.el=document.querySelector(L)),this.el===null)throw new Error("The element you passed to Selectr can not be found.");if(this.el.nodeName.toLowerCase()!=="select")throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(A)}G.prototype.render=function(L){var A;this.rendered||((this.el.selectr=this).config=D.extend({defaultSelected:!0,width:"auto",disabled:!1,disabledMobile:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,nativeKeyboard:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag...",messages:{noResults:"No results.",noOptions:"No options available.",maxSelections:"A maximum of {max} items can be selected.",tagDuplicate:"That tag is already in use.",searchPlaceholder:"Search options..."}},L),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=U(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,!this.config.disabledMobile&&/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&typeof this.config.renderOption=="function",this.customSelected=this.config.hasOwnProperty("renderSelection")&&typeof this.config.renderSelection=="function",this.supportsEventPassiveOption=this.detectEventPassiveOption(),g.mixin(this),(function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,U(this.config,"width")&&(D.isInt(this.config.width)?this.width=this.config.width+"px":this.config.width==="auto"?this.width="100%":D.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=D.createElement("div",{class:"selectr-container"}),this.config.customClass&&D.addClass(this.container,this.config.customClass),this.mobileDevice?D.addClass(this.container,"selectr-mobile"):D.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?D.addClass(this.el,"selectr-visible"):D.addClass(this.el,"selectr-hidden"),this.selected=D.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:0,"aria-expanded":!1}),this.label=D.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var f=D.createElement("div",{class:"selectr-options-container"});if(this.tree=D.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=D.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple?(D.addClass(this.label,"selectr-tags"),D.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.config.defaultSelected?this.getSelectedProperties("value"):[],this.selectedIndexes=this.getSelectedProperties("idx")):(this.selectedValue=null,this.selectedIndex=-1),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=D.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),D.addClass(this.container,"clearable")),this.config.taggable){var T=D.createElement("li",{class:"input-tag"});if(this.input=D.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),T.appendChild(this.input),this.label.appendChild(T),D.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators){this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators);for(var I=[],m=0;m<this.tagSeperators.length;m++)I.push(D.escapeRegExp(this.tagSeperators[m]));this.tagSeperatorsRegex=new RegExp(I.join("|"),"i")}else this.tagSeperatorsRegex=new RegExp(",","i")}this.config.searchable&&(this.input=D.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search",placeholder:this.config.messages.searchPlaceholder}),this.inputClear=D.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=D.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),f.appendChild(this.inputContainer)),f.appendChild(this.notice),f.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var h,a,l,t=!1,r=0;this.el.children.length&&D.each(this.el.children,function(n,s){s.nodeName==="OPTGROUP"?(t=D.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+s.label+"</li>"}),D.each(s.children,function(o,i){i.idx=r,t.appendChild(K.call(this,i,t)),r++},this)):(s.idx=r,K.call(this,s),r++)},this),this.config.data&&Array.isArray(this.config.data)&&(h=!(this.data=[]),t=!1,r=0,D.each(this.config.data,function(n,s){U(s,"children")?(h=D.createElement("optgroup",{label:s.text}),t=D.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+s.text+"</li>"}),D.each(s.children,function(o,i){(a=new Option(i.text,i.value,!1,i.hasOwnProperty("selected")&&i.selected===!0)).disabled=U(i,"disabled"),this.options.push(a),h.appendChild(a),a.idx=r,t.appendChild(K.call(this,a,i)),this.data[r]=i,r++},this),this.el.appendChild(h)):((a=new Option(s.text,s.value,!1,s.hasOwnProperty("selected")&&s.selected===!0)).disabled=U(s,"disabled"),this.options.push(a),a.idx=r,K.call(this,a,s),this.data[r]=s,r++)},this)),this.setSelected(!0);for(var e=this.navIndex=0;e<this.items.length;e++)if(l=this.items[e],!D.hasClass(l,"disabled")){D.addClass(l,"active"),this.navIndex=e;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(f),this.placeEl=D.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}).call(this),this.bindEvents(),this.update(),this.optsRect=D.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex),A=this,setTimeout(function(){A.emit("selectr.init")},20))},G.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},G.prototype.getSelectedProperties=function(L){var A=this.getSelected();return[].slice.call(A).map(function(f){return f[L]}).filter(function(f){return f!=null})},G.prototype.detectEventPassiveOption=function(){var L=!1;try{var A=Object.defineProperty({},"passive",{get:function(){L=!0}});window.addEventListener("test",null,A)}catch{}return L},G.prototype.bindEvents=function(){var L,A=this;this.events={},this.events.dismiss=(function(f){f=f.target,this.container.contains(f)||!this.opened&&!D.hasClass(this.container,"notice")||this.close()}).bind(this),this.events.navigate=(function(f){if(f=f||window.event,this.items.length&&this.opened&&D.includes([13,38,40],f.which)){if(f.preventDefault(),f.which===13)return!(this.noResults||this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var T,I=this.items[this.navIndex],m=this.navIndex;switch(f.which){case 38:(T=0)<this.navIndex&&this.navIndex--;break;case 40:this.navIndex<this.items.length-(T=1)&&this.navIndex++}for(this.navigating=!0;D.hasClass(this.items[this.navIndex],"disabled")||D.hasClass(this.items[this.navIndex],"excluded");){if(!(0<this.navIndex&&this.navIndex<this.items.length-1)){this.navIndex=m;break}if(T?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}}f=D.rect(this.items[this.navIndex]),T?(this.navIndex===0?this.tree.scrollTop=0:f.top+f.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(f.top+f.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&j.call(this)):this.navIndex===0?this.tree.scrollTop=0:f.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(f.top-this.optsRect.top)),I&&D.removeClass(I,"active"),D.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}).bind(this),this.events.reset=this.reset.bind(this),(this.config.nativeDropdown||this.mobileDevice)&&(this.container.addEventListener("touchstart",function(f){f.changedTouches[0].target===A.el&&A.toggle()},!!this.supportsEventPassiveOption&&{passive:!0}),this.container.addEventListener("click",function(f){f.target===A.el&&A.toggle()}),this.el.addEventListener("change",function(f){f.__selfTriggered||(A.el.multiple?(f=A.getSelectedProperties("idx"),f=function(T,I){for(var m,h=[],a=T.slice(0),l=0;l<I.length;l++)-1<(m=a.indexOf(I[l]))?a.splice(m,1):h.push(I[l]);return[h,a]}(A.selectedIndexes,f),D.each(f[0],function(T,I){A.select(I)},A),D.each(f[1],function(T,I){A.deselect(I)},A)):-1<A.el.selectedIndex&&A.select(A.el.selectedIndex))})),this.config.nativeDropdown&&this.container.addEventListener("keydown",function(f){f.key==="Enter"&&A.selected===document.activeElement&&(A.toggle(),setTimeout(function(){A.el.focus()},200))}),this.selected.addEventListener("click",function(f){A.disabled||A.toggle(),f.preventDefault()}),this.config.nativeKeyboard&&(L="",this.selected.addEventListener("keydown",function(f){var T;A.disabled||A.selected!==document.activeElement||f.altKey||f.ctrlKey||f.metaKey||(f.key===" "||!A.opened&&-1<["Enter","ArrowUp","ArrowDown"].indexOf(f.key)?(A.toggle(),f.preventDefault(),f.stopPropagation()):f.key.length<=2&&String[String.fromCodePoint?"fromCodePoint":"fromCharCode"](f.key[String.codePointAt?"codePointAt":"charCodeAt"](0))===f.key&&(A.config.multiple?(A.open(),A.config.searchable&&(A.input.value=f.key,A.input.focus(),A.search(null,!0))):(L+=f.key,(T=A.search(L,!0))&&T.length&&(A.clear(),A.setValue(T[0].value)),setTimeout(function(){L=""},1e3)),f.preventDefault(),f.stopPropagation()))}),this.container.addEventListener("keyup",function(f){A.opened&&f.key==="Escape"&&(A.close(),f.stopPropagation(),A.selected.focus())})),this.label.addEventListener("click",function(f){D.hasClass(f.target,"selectr-tag-remove")&&A.deselect(f.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(f){f.preventDefault()}),this.tree.addEventListener("click",function(f){var T=D.closest(f.target,function(I){return I&&D.hasClass(I,"selectr-option")});T&&!D.hasClass(T,"disabled")&&(D.hasClass(T,"selected")?(A.el.multiple||!A.el.multiple&&A.config.allowDeselect)&&A.deselect(T.idx):A.select(T.idx),A.opened&&!A.el.multiple)&&A.close(),f.preventDefault(),f.stopPropagation()}),this.tree.addEventListener("mouseover",function(f){!D.hasClass(f.target,"selectr-option")||D.hasClass(f.target,"disabled")||(D.removeClass(A.items[A.navIndex],"active"),D.addClass(f.target,"active"),A.navIndex=[].slice.call(A.items).indexOf(f.target))}),this.config.searchable&&(this.input.addEventListener("focus",function(f){A.searching=!0}),this.input.addEventListener("blur",function(f){A.searching=!1}),this.input.addEventListener("keyup",function(f){A.search(),A.config.taggable||(this.value.length?D.addClass(this.parentNode,"active"):D.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(f){A.input.value=null,X.call(A),A.tree.childElementCount||M.call(A)})),this.config.taggable&&this.input.addEventListener("keyup",function(f){var T,I;A.search(),A.config.taggable&&this.value.length&&(T=this.value.trim()).length&&(f.which===13||A.tagSeperatorsRegex.test(T))&&(f=T.replace(A.tagSeperatorsRegex,""),(I=(f=(f=D.escapeRegExp(f)).trim()).length?A.add({value:f,textContent:f,selected:!0},!0):I)?(A.close(),X.call(A)):(this.value="",A.setMessage(A.config.messages.tagDuplicate)))}),this.update=D.debounce(function(){A.opened&&A.config.closeOnScroll&&A.close(),A.width&&(A.container.style.width=A.width),A.invert()},50),this.requiresPagination&&(this.paginateItems=D.debounce(function(){j.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.on("selectr.destroy",function(){document.removeEventListener("click",this.events.dismiss),window.removeEventListener("keydown",this.events.navigate),window.removeEventListener("resize",this.update),window.removeEventListener("scroll",this.update)}),this.el.form&&(this.el.form.addEventListener("reset",this.events.reset),this.on("selectr.destroy",function(){this.el.form.removeEventListener("reset",this.events.reset)}))},G.prototype.setSelected=function(L){var A;this.config.data||this.el.multiple||!this.el.options.length||(this.el.selectedIndex!==0||this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&this.originalType==="select-one"&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),D.each(this.options,function(f,T){T.selected&&T.defaultSelected&&this.select(T.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data&&(!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&0<this.config.data.length&&this.select(0),A=0,D.each(this.config.data,function(f,T){U(T,"children")?D.each(T.children,function(I,m){m.hasOwnProperty("selected")&&m.selected===!0&&this.select(A),A++},this):(T.hasOwnProperty("selected")&&T.selected===!0&&this.select(A),A++)},this))},G.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),this.originalType==="select-one"&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),D.removeClass(this.el,"selectr-hidden"),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1,delete this.el.selectr)},G.prototype.change=function(L){var A=this.items[L],f=this.options[L];f.disabled||(f.selected&&D.hasClass(A,"selected")?this.deselect(L):this.select(L),this.opened&&!this.el.multiple&&this.close())},G.prototype.select=function(L){var A=this.items[L],f=[].slice.call(this.el.options),T=this.options[L];if(this.el.multiple){if(D.includes(this.selectedIndexes,L))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage(this.config.messages.maxSelections.replace("{max}",this.config.maxSelections),!0),!1;this.selectedValues.push(T.value),this.selectedIndexes.push(L),(function(m){var h,a=this,l=document.createDocumentFragment(),t=this.options[m.idx],r=this.data?this.data[m.idx]:t,e={class:"selectr-tag"},r=(this.customSelected?e.html=this.config.renderSelection(r):e.textContent=t.textContent,D.createElement("li",e)),e=D.createElement("button",{class:"selectr-tag-remove",type:"button"});r.appendChild(e),r.idx=m.idx,r.tag=t.value,this.tags.push(r),this.config.sortSelected?(e=this.tags.slice(),h=function(n,s){n.replace(/(\d+)|(\D+)/g,function(o,i,c){s.push([i||1/0,c||""])})},e.sort(function(n,s){var o,i,c=[],d=[];for(a.config.sortSelected===!0?(o=n.tag,i=s.tag):a.config.sortSelected==="text"&&(o=n.textContent,i=s.textContent),h(o,c),h(i,d);c.length&&d.length;){var p=c.shift(),C=d.shift(),p=p[0]-C[0]||p[1].localeCompare(C[1]);if(p)return p}return c.length-d.length}),D.each(e,function(n,s){l.appendChild(s)}),this.label.innerHTML=""):l.appendChild(r),this.config.taggable?this.label.insertBefore(l,this.input.parentNode):this.label.appendChild(l)}).call(this,A)}else{var I=this.data?this.data[L]:T;this.customSelected?this.label.innerHTML=this.config.renderSelection(I):this.label.textContent=T.textContent,this.selectedValue=T.value,this.selectedIndex=L,D.each(this.options,function(m,h){var a=this.items[m];m!==L&&(a&&D.removeClass(a,"selected"),h.selected=!1,h.removeAttribute("selected"))},this)}D.includes(f,T)||this.el.add(T),A.setAttribute("aria-selected",!0),D.addClass(A,"selected"),D.addClass(this.container,"has-selected"),T.selected=!0,T.setAttribute("selected",""),this.emit("selectr.change",T),this.emit("selectr.select",T),"createEvent"in document?((I=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),I.__selfTriggered=!0,this.el.dispatchEvent(I)):this.el.fireEvent("onchange")},G.prototype.deselect=function(L,A){var f=this.items[L],T=this.options[L];if(this.el.multiple){var I=this.selectedIndexes.indexOf(L),I=(this.selectedIndexes.splice(I,1),this.selectedValues.indexOf(T.value));this.selectedValues.splice(I,1),(function(m){var h=!1;D.each(this.tags,function(a,l){l.idx===m.idx&&(h=l)},this),h&&(this.label.removeChild(h),this.tags.splice(this.tags.indexOf(h),1))}).call(this,f),this.tags.length||D.removeClass(this.container,"has-selected")}else{if(!A&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,D.removeClass(this.container,"has-selected")}this.items[L].setAttribute("aria-selected",!1),D.removeClass(this.items[L],"selected"),T.selected=!1,T.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",T),"createEvent"in document?((I=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),I.__selfTriggered=!0,this.el.dispatchEvent(I)):this.el.fireEvent("onchange")},G.prototype.setValue=function(L){var A=Array.isArray(L);if(A||(L=L.toString().trim()),!this.el.multiple&&A)return!1;D.each(this.options,function(f,T){(A&&-1<L.indexOf(T.value)||T.value===L)&&this.change(T.idx)},this)},G.prototype.getValue=function(L,A){var f,T;return this.el.multiple?L?this.selectedIndexes.length&&(T={values:[]},D.each(this.selectedIndexes,function(I,m){m=this.options[m],T.values[I]={value:m.value,text:m.textContent}},this)):T=this.selectedValues.slice():T=L?{value:(f=this.options[this.selectedIndex]).value,text:f.textContent}:this.selectedValue,T=L&&A?JSON.stringify(T):T},G.prototype.add=function(L,A){if(L){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(L))D.each(L,function(I,m){this.add(m,A)},this);else if(Object.prototype.toString.call(L)==="[object Object]"){if(A){var f=!1;if(D.each(this.options,function(I,m){m.value.toLowerCase()===L.value.toLowerCase()&&(f=!0)}),f)return!1}var T=D.createElement("option",L);return this.data.push(L),this.mobileDevice&&this.el.add(T),this.options.push(T),T.idx=0<this.options.length?this.options.length-1:0,K.call(this,T),L.selected&&this.select(T.idx),this.setPlaceholder(),T}return this.config.pagination&&this.paginate(),!0}},G.prototype.remove=function(L){var A,f=[];Array.isArray(L)?D.each(L,function(T,I){D.isInt(I)?f.push(this.getOptionByIndex(I)):typeof I=="string"&&f.push(this.getOptionByValue(I))},this):D.isInt(L)?f.push(this.getOptionByIndex(L)):typeof L=="string"&&f.push(this.getOptionByValue(L)),f.length&&(D.each(f,function(T,I){A=I.idx,this.el.remove(I),this.options.splice(A,1),I=this.items[A].parentNode,I&&I.removeChild(this.items[A]),this.items.splice(A,1),D.each(this.options,function(m,h){h.idx=m,this.items[m].idx=m},this)},this),this.setPlaceholder(),this.config.pagination)&&this.paginate()},G.prototype.removeAll=function(){this.clear(!0),D.each(this.el.options,function(L,A){this.el.remove(A)},this),D.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},G.prototype.search=function(L,A){var f,T,I,m,h;if(!this.navigating)return f=!1,L||(L=this.input.value,f=!0,this.removeMessage(),D.truncate(this.tree)),T=[],I=document.createDocumentFragment(),0<(L=L.trim().toLowerCase()).length?(m=A?D.startsWith:D.includes,D.each(this.options,function(a,l){var t,r,e,n,s=this.items[l.idx];m(l.textContent.trim().toLowerCase(),L)&&!l.disabled?(T.push({text:l.textContent,value:l.value}),f&&(k(s,I,this.customOption),D.removeClass(s,"excluded"),!this.customOption)&&(t=L,e=(l=l).textContent,t=new RegExp(t,"ig"),n=t.exec(e))&&(l.innerHTML="",(r=document.createElement("span")).classList.add("selectr-match"),r.textContent=n[0],l.appendChild(document.createTextNode(e.substring(0,n.index))),l.appendChild(r),l.appendChild(document.createTextNode(e.substring(t.lastIndex))))):f&&D.addClass(s,"excluded")},this),f&&(I.childElementCount?(A=this.items[this.navIndex],h=I.querySelector(".selectr-option:not(.excluded)"),this.noResults=!1,D.removeClass(A,"active"),this.navIndex=h.idx,D.addClass(h,"active")):this.config.taggable||(this.noResults=!0,this.setMessage(this.config.messages.noResults)),this.tree.appendChild(I))):M.call(this),T},G.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},G.prototype.open=function(){var L=this;if(!this.options.length)return!1;this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(D.addClass(this.container,"native-open"),this.config.data&&D.each(this.options,function(A,f){this.el.add(f)},this)):(D.addClass(this.container,"open"),M.call(this),this.invert(),this.tree.scrollTop=0,D.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),this.config.searchable&&!this.config.taggable&&setTimeout(function(){L.input.focus(),L.input.tabIndex=0},10))},G.prototype.close=function(){var L;this.opened&&this.emit("selectr.close"),this.opened=!1,this.navigating=!1,this.mobileDevice||this.config.nativeDropdown?D.removeClass(this.container,"native-open"):(L=D.hasClass(this.container,"notice"),this.config.searchable&&!L&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),L&&(D.removeClass(this.container,"notice"),this.notice.textContent=""),D.removeClass(this.container,"open"),D.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),D.truncate(this.tree),X.call(this))},G.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&D.each(this.tags,function(L,A){A.lastElementChild.tabIndex=0}),D.removeClass(this.container,"selectr-disabled")},G.prototype.disable=function(L){L||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&D.each(this.tags,function(A,f){f.lastElementChild.tabIndex=-1}),this.disabled=!0,D.addClass(this.container,"selectr-disabled")},G.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),D.each(this.defaultSelected,function(L,A){this.select(A)},this),this.emit("selectr.reset"))},G.prototype.clear=function(L,A){var f;this.el.multiple?this.selectedIndexes.length&&(f=this.selectedIndexes.slice(),A?this.deselect(f.slice(-1)[0]):D.each(f,function(T,I){this.deselect(I)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,L),this.emit("selectr.clear")},G.prototype.serialise=function(L){var A=[];return D.each(this.options,function(f,T){var I={value:T.value,text:T.textContent};T.selected&&(I.selected=!0),T.disabled&&(I.disabled=!0),A[f]=I}),L?JSON.stringify(A):A},G.prototype.serialize=function(L){return this.serialise(L)},G.prototype.setPlaceholder=function(L){L=L||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(L=this.config.messages.noOptions),this.placeEl.innerHTML=L},G.prototype.paginate=function(){var L;if(this.items.length)return(L=this).pages=this.items.map(function(A,f){return f%L.config.pagination==0?L.items.slice(f,f+L.config.pagination):null}).filter(function(A){return A}),this.pages},G.prototype.setMessage=function(L,A){A&&this.close(),D.addClass(this.container,"notice"),this.notice.textContent=L},G.prototype.removeMessage=function(){D.removeClass(this.container,"notice"),this.notice.innerHTML=""},G.prototype.invert=function(){var L=D.rect(this.selected),A=this.tree.parentNode.offsetHeight,f=window.innerHeight;L.top+L.height+A>f?(D.addClass(this.container,"inverted"),this.isInverted=!0):(D.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=D.rect(this.tree)},G.prototype.getOptionByIndex=function(L){return this.options[L]},G.prototype.getOptionByValue=function(L){for(var A=!1,f=0,T=this.options.length;f<T;f++)if(this.options[f].value.trim()===L.toString().trim()){A=this.options[f];break}return A},ce.exports=G},4188:function(ce,g,D){D.d(g,{EX:function(){return k},WF:function(){return M},oW:function(){return K},qD:function(){return U}});var U=document.body,k=10485760,M=2e4,K=2147483648},2602:function(ce,g,D){D.d(g,{w:function(){return k}});var U=D(9791);function k(M,K,j){var X,G=3<arguments.length&&arguments[3]!==void 0&&arguments[3],L=typeof(f=M).getRootNode=="function"?f.getRootNode():window,A={},f=M.getBoundingClientRect(),T=K.getBoundingClientRect(),I=document.createElement("div");function m(){if(I&&I.parentNode){for(var a in I.parentNode.removeChild(I),A)l=a,Object.prototype.hasOwnProperty.call(A,l)&&((l=A[a])&&(0,U.removeEventListener)(L,a,l),delete A[a]);typeof j=="function"&&j(M)}var l}function h(a){(a=a.target)===I||(0,U.isChildOf)(a,I)||m()}return I.className="jsoneditor-anchor",I.style.position="absolute",I.style.left=f.left-T.left+"px",I.style.top=f.top-T.top+"px",I.style.width=f.width-2+"px",I.style.height=f.height-2+"px",I.style.boxSizing="border-box",K.appendChild(I),A.mousedown=(0,U.addEventListener)(L,"mousedown",h),A.mousewheel=(0,U.addEventListener)(L,"mousewheel",h),G&&(X=null,I.onmouseover=function(){clearTimeout(X),X=null},I.onmouseout=function(){X=X||setTimeout(m,200)}),I.destroy=m,I}},7923:function(ce){ce.exports="data:application/javascript;base64,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"},7907:function(ce,g,D){D.d(g,{Iu:function(){return L},cC:function(){return G},m0:function(){return X}}),D(4987);var U={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:`Click to expand/collapse this field (Ctrl+E). 
Ctrl+Click to expand/collapse including all childs.`,formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},es:{array:"Matriz",auto:"Auto",appendText:"Agregar",appendTitle:"Agregue un nuevo campo con el tipo 'auto' después de este campo (Ctrl + Shift + Ins)",appendSubmenuTitle:"Seleccione el tipo de campo que se agregará",appendTitleAuto:"Agregue un nuevo campo con el tipo 'auto' (Ctrl + Shift + Ins)",ascending:"Ascendente",ascendingTitle:"Ordene los elementos secundarios de este ${type} en orden ascendente",actionsMenu:"Haga clic para abrir el menú de acciones (Ctrl + M)",cannotParseFieldError:"No se puede parsear el campo en JSON",cannotParseValueError:"No se puede parsear el valor en JSON",collapseAll:"Contraer todos los campos",compactTitle:"Compactar datos JSON, eliminar todos los espacios en blanco (Ctrl + Shift + I)",descending:"Descendente",descendingTitle:"Ordene los hijos de este ${type} en orden descendente",drag:"Arrastre para mover este campo (Alt + Mayús + Flechas)",duplicateKey:"llave duplicada",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos seleccionados (Ctrl + D)",duplicateField:"Duplicar este campo (Ctrl + D)",duplicateFieldError:"Nombre de campo duplicado",empty:"vacio",expandAll:"Expandir todos los campos",expandTitle:`Haga clic para expandir/contraer este campo (Ctrl + E). 
  Ctrl+Clic para expandir/contraer incluyendo todos los niños.`,formatTitle:"Formatee los datos JSON, con la sangría y los avances de línea adecuados (Ctrl + I)",insert:"Insertar",insertTitle:"Inserte un nuevo campo con el tipo 'auto' antes de este campo (Ctrl + Ins)",insertSub:"Seleccione el tipo de campo a insertar",object:"Objeto",ok:"Ok",redo:"Rehacer (Ctrl+Mayús+Z)",removeText:"Eliminar",removeTitle:"Eliminar campos seleccionados (Ctrl+Supr)",removeField:"Eliminar este campo (Ctrl+Supr)",repairTitle:"Reparar JSON: corrija comillas y caracteres de escape, elimine comentarios y notación JSONP, convierta objetos JavaScript en JSON.",searchTitle:"Campos de búsqueda y valores",searchNextResultTitle:"Siguiente resultado (Entrar)",searchPreviousResultTitle:"Resultado anterior (Shift + Enter)",selectNode:"Seleccione un nodo...",showAll:"mostrar todo",showMore:"mostrar más",showMoreStatus:"mostrando ${visibleChilds} de ${totalChilds} elementos.",sort:"Ordenar",sortTitle:"Ordene los hijos de este ${type}",sortTitleShort:"Ordenar contenidos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dirección:",sortFieldTitle:"Seleccione el campo anidado por el cual ordenar la matriz u objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar el campo seleccionado en orden ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar por el campo seleccionado, en orden descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar o transformar los hijos de este ${type}",transformTitleShort:"Filtrar, ordenar o transformar contenidos",extract:"Extraer",extractTitle:"Extrae este ${type}",transformQueryTitle:"Ingrese una consulta JMESPath",transformWizardLabel:"Wizard",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Seleccione un campo",transformQueryLabel:"Consulta",transformPreviewLabel:"Vista Previa",type:"Tipo",typeTitle:"Cambiar el tipo de campo",openUrl:"Ctrl+Click o Ctrl+Enter para abrir la URL en una nueva ventana",undo:"Deshacer la última acción (Ctrl+Z)",validationCannotMove:"No se puede mover un campo a un hijo de sí mismo.",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Tipo de campo "objeto".  Un objeto contiene un conjunto desordenado de pares clave/valor.',arrayType:'Tipo de campo "matriz".  Una matriz contiene una colección ordenada de valores.',stringType:'Tipo de campo "cadena".  El tipo de campo no se determina a partir del valor,  pero siempre se devuelve como una cadena.',modeEditorTitle:"Cambiar modo de editor",modeCodeText:"Codigo",modeCodeTitle:"Cambiar al resaltador de código",modeFormText:"Formulario",modeFormTitle:"Cambiar al editor de formularios",modeTextText:"Texto",modeTextTitle:"Cambiar al editor de texto sin formato",modeTreeText:"Arbol",modeTreeTitle:"Cambiar al editor de árbol",modeViewText:"Vista",modeViewTitle:"Cambiar a la vista de árbol",modePreviewText:"Vista Previa",modePreviewTitle:"Cambiar al modo de vista previa",examples:"Ejemplos",default:"Predeterminado",containsInvalidProperties:"Contiene propiedades no validas",containsInvalidItems:"Contiene items no validos"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",collapseAll:"缩进所有字段",compactTitle:"压缩JSON数据，删除所有空格 (Ctrl+Shift+I)",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",empty:"清空",expandAll:"展开所有字段",expandTitle:`点击 展开/收缩 该字段(Ctrl+E). 
Ctrl+Click 展开/收缩 包含所有子节点.`,formatTitle:"使用适当的缩进和换行符格式化JSON数据 (Ctrl+I)",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",repairTitle:"修复JSON：修复引号和转义符，删除注释和JSONP表示法，将JavaScript对象转换为JSON。",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省",containsInvalidProperties:"包含无效的属性",containsInvalidItems:"包含无效项目"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espaços em branco (Ctrl+Shift+I)",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:`Clique para expandir/encolher este campo (Ctrl+E). 
Ctrl+Click para expandir/encolher incluindo todos os filhos.`,formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova comentários e notação JSONP, transforme objetos JavaScript em JSON.",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia",containsInvalidProperties:"Contém propriedades inválidas",containsInvalidItems:"Contém itens inválidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:`Bu alanı açmak/kapatmak için tıkla (Ctrl+E). 
Alt alanlarda dahil tüm alanları açmak için Ctrl+Click `,insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan",containsInvalidProperties:"Geçersiz özellikler içeriyor",containsInvalidItems:"Geçersiz öğeler içeriyor"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:`クリックしてフィールドを展開/折りたたむ (Ctrl+E). 
Ctrl+Click ですべての子要素を展開/折りたたむ`,insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト",containsInvalidProperties:"無効なプロパティが含まれています",containsInvalidItems:"無効なアイテムが含まれています"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:`Étendre/regrouper ce champ (Ctrl+E). 
Ctrl+Click pour étendre/regrouper avec tous les champs.`,insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:`Champ de type "chaîne". Ce type de champ n'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.`,modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut",containsInvalidProperties:"Contient des propriétés non valides",containsInvalidItems:"Contient des éléments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anhängen",appendTitle:"Fügen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",appendSubmenuTitle:"Wählen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzufügen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum Öffnen des Aktionsmenüs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schlüssel",duplicateText:"Duplikat",duplicateTitle:"Ausgewählte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:`Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). 
Strg+Klicken Sie, um dieses Feld einschließlich aller Elemente zu erweitern/zu kollabieren.`,formatTitle:"JSON-Daten mit korrekter Einrückung und Zeilenvorschüben formatieren (Strg+\\)",insert:"einfügen",insertTitle:"Fügen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"Wählen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgewählte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anführungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",searchTitle:"Suchfelder und Werte",searchNextResultTitle:"Nächstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"Wählen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"Wählen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgewählte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgewählte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder auswählen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"Ändern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu öffnen",undo:"Letzte Aktion rückgängig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enthält eine ungeordnete Menge von Schlüssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enthält eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zurückgegeben.',modeEditorTitle:"Editor-Modus umschalten",modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor für einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele",default:"Standardmäßig",containsInvalidProperties:"Enthält ungültige Eigenschaften",containsInvalidItems:"Enthält ungültige Elemente"},ru:{array:"Массив",auto:"Авто",appendText:"Добавить",appendTitle:"Добавить новое поле с типом 'авто' после этого поля (Ctrl+Shift+Ins)",appendSubmenuTitle:"Выбрать тип поля для добавления",appendTitleAuto:"Добавить новое поле с типом 'авто' (Ctrl+Shift+Ins)",ascending:"По возрастанию",ascendingTitle:"Сортировать ${type} по возрастанию",actionsMenu:"Нажмите для открытия меню действий (Ctrl+M)",cannotParseFieldError:"Невозможно преобразовать поле в JSON",cannotParseValueError:"Невозможно преобразовать значение в JSON",collapseAll:"Свернуть все",compactTitle:"Минификация JSON (Ctrl+Shift+I)",descending:"По убыванию",descendingTitle:"Сортировать ${type} по убыванию",drag:"Потяните для перемещения этого поля (Alt+Shift+Arrows)",duplicateKey:"повторяющийся ключ",duplicateText:"Дублировать",duplicateTitle:"Дублирование полей (Ctrl+D)",duplicateField:"Дублировать поле (Ctrl+D)",duplicateFieldError:"Дублирование названия поля",empty:"пустой",expandAll:"Развернуть все",expandTitle:`Нажмите для раскрытия/скрытия поля (Ctrl+E)
или Ctrl+Click для раскрытия/скрытия всех потомков.`,formatTitle:"Форматирование JSON (Ctrl+I)",insert:"Вставить",insertTitle:"Вставить новое поле с типом 'авто' перед этим полем (Ctrl+Ins)",insertSub:"Выбрать тип поля для вставки",object:"Объект",ok:"ОК",redo:"Повторить (Ctrl+Shift+Z)",removeText:"Удалить",removeTitle:"Удалить выбранные поля (Ctrl+Del)",removeField:"Удалить поле (Ctrl+Del)",repairTitle:"Восстановите JSON: исправьте кавычки и escape-символы, удалите комментарии и нотацию JSONP, модифицируйте объекты JavaScript в JSON.",searchTitle:"Поиск",searchNextResultTitle:"Следующий результат (Enter)",searchPreviousResultTitle:"Предыдущий результат (Shift + Enter)",selectNode:"Выбор узла...",showAll:"показать все",showMore:"больше",showMoreStatus:"${visibleChilds} из ${totalChilds}",sort:"Сортировка",sortTitle:"Сортировка потомков типа ${type}",sortTitleShort:"Сортировка содержимого",sortFieldLabel:"Поле:",sortDirectionLabel:"Направление:",sortFieldTitle:"Выберите поле для сортировки массива или объекта",sortAscending:"По возрастанию",sortAscendingTitle:"Сортировка выбранного поря по возрастанию",sortDescending:"По убыванию",sortDescendingTitle:"Сортировка выбранного поря по убыванию",string:"Строка",transform:"Модификация",transformTitle:"Фильтрация, сортировка или модификация данных типа ${type}",transformTitleShort:"Фильтрация, сортировка или модификация данных",extract:"Извлечение",extractTitle:"Извлечь тип ${type}",transformQueryTitle:"Введите JMESpath запрос",transformWizardLabel:"Мастер",transformWizardFilter:"Фильтр",transformWizardSortBy:"Сортировка",transformWizardSelectFields:"Поля",transformQueryLabel:"Запрос",transformPreviewLabel:"Просмотр",type:"Тип",typeTitle:"Изменить тип этого поля",openUrl:"Ctrl+Click или Ctrl+Enter для открытия url в новом окне",undo:"Отменить (Ctrl+Z)",validationCannotMove:"Поле не может быть перемещено в потомка",autoType:"Тип поля автоматически определяется по значению и может быть строкой, числом, логическим значением или null.",objectType:"Объект содержит неупорядоченный набор пар ключ/значение.",arrayType:"Массив содержит упорядоченный набор значений.",stringType:"Тип поля не определяется из значения, но всегда возвращается как строка.",modeEditorTitle:"Переключение режима редактора",modeCodeText:"Код",modeCodeTitle:"Переключить в режим редактора кода",modeFormText:"Форма",modeFormTitle:"Переключить в режим формы",modeTextText:"Текст",modeTextTitle:"Переключить в режим редактора текста",modeTreeText:"Дерево",modeTreeTitle:"Переключить в режим редактора дерева",modeViewText:"Просмотр дерева",modeViewTitle:"Переключить в режим просмотра дерева",modePreviewText:"Просмотр",modePreviewTitle:"Переключить в режим просмотра",examples:"Примеры",default:"По умолчанию",containsInvalidProperties:"Содержит недопустимые свойства",containsInvalidItems:"Содержит недопустимые элементы"},ko:{array:"배열",auto:"자동",appendText:"추가",appendTitle:'선택한 요소 아래에 "자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',appendSubmenuTitle:"추가할 요소의 유형을 선택해주세요.",appendTitleAuto:'"자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',ascending:"오름차순",ascendingTitle:"선택한 ${type}의 하위 요소를 오름차순 정렬합니다.",actionsMenu:"메뉴 열기 (Ctrl + M)",cannotParseFieldError:"JSON의 요소를 해석할 수 없습니다.",cannotParseValueError:"JSON의 값을 해석할 수 없습니다.",collapseAll:"모두 접기",compactTitle:"모든 공백을 제거하여 JSON 데이터를 작게 만듭니다. (Ctrl + Shift + I)",descending:"내림차순",descendingTitle:"선택한 ${type}의 하위 요소를 내림차순으로 정렬",drag:"드래그하여 요소를 이동합니다. (Alt + Shift + Arrows)",duplicateKey:"복제키",duplicateText:"복제",duplicateTitle:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateField:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateFieldError:"요소 이름이 중복되었습니다.",empty:"비어있음",expandAll:"모두 열기",expandTitle:`클릭하여 요소를 열거나 닫습니다. (Ctrl + E) 
Ctrl + Click으로 모든 하위 요소를 열거나 닫습니다.`,formatTitle:"적절한 들여쓰기 및 줄바꿈으로 JSON 데이터를 정형화합니다. (Ctrl + I)",insert:"삽입",insertTitle:"선택한 요소 위에 새요소를 삽입합니다. (Ctrl + Ins)",insertSub:"삽입할 요소의 유형을 선택해주세요.",object:"객체",ok:"확인",redo:"다시 실행 (Ctrl + Shift + Z)",removeText:"삭제",removeTitle:"선택한 요소를 삭제합니다. (Ctrl + Del)",removeField:"선택한 요소를 삭제합니다. (Ctrl + Del)",repairTitle:"JSON 교정: JSON 내의 주석과 JSONP 표기법을 지우고 따옴표와 이스케이프 문자를 수정합니다.",searchTitle:"요소 또는 값 찾기",searchNextResultTitle:"다음으로 찾기 (Enter)",searchPreviousResultTitle:"이전으로 찾기 (Shift + Enter)",selectNode:"요소를 선택해주세요...",showAll:"모두보기",showMore:"더보기",showMoreStatus:"${totalChilds} 개의 항목 중 ${visibleChilds} 개를 표시합니다.",sort:"정렬",sortTitle:"선택한 ${type}의 하위 요소를 정렬합니다.",sortTitleShort:"정렬",sortFieldLabel:"요소:",sortDirectionLabel:"순서:",sortFieldTitle:"배열이나 객체를 정렬하는 요소를 선택해주세요.",sortAscending:"오름차순",sortAscendingTitle:"선택한 요소를 오름차순으로 정렬합니다.",sortDescending:"내림차순",sortDescendingTitle:"선택한 요소를 내림차순으로 정렬합니다.",string:"문자",transform:"변환",transformTitle:"선택한 ${type}의 하위 요소를 필터하거나 정렬 또는 변환합니다.",transformTitleShort:"내용을 필터하거나 정렬 또는 변환합니다.",extract:"추출",extractTitle:"선택한 ${type}의 값을 최상위에 위치시킵니다.",transformQueryTitle:"JMESPath 쿼리를 입력해주세요.",transformWizardLabel:"마법사",transformWizardFilter:"필터",transformWizardSortBy:"정렬",transformWizardSelectFields:"요소를 선택해주세요.",transformQueryLabel:"쿼리",transformPreviewLabel:"미리보기",type:"유형",typeTitle:"선택한 요소의 유형을 변경합니다.",openUrl:"Ctrl + Click 또는 Ctrl + Enter로 새 창에서 URL 열기",undo:"실행 취소 (Ctrl + Z)",validationCannotMove:"하위 요소로 이동할 수 없습니다.",autoType:"자동: 요소의 형식이 값의 유형으로 결정됩니다. 문자, 숫자, 부울, 또는 null만 허용됩니다.",objectType:"객체: 순서대로 나열되지 않은 이름/값 쌍으로 이루어진 집합입니다.",arrayType:"배열: 순서대로 나열된 값의 집합입니다.",stringType:"문자: 요소의 유형이 값에서 결정되지 않지만 항상 문자로 반환됩니다.",modeEditorTitle:"편집기 유형 변경",modeCodeText:"코드",modeCodeTitle:"형식 교정을 도와주는 기능이 포함된 문자 편집기",modeFormText:"입력 양식",modeFormTitle:"정해진 요소에 값을 입력하는 편집기",modeTextText:"문자",modeTextTitle:"단순 문자 편집기",modeTreeText:"트리",modeTreeTitle:"트리 구조로 표시되는 편집기",modeViewText:"보기",modeViewTitle:"읽기전용 트리 구조로 JSON을 표시",modePreviewText:"미리보기",modePreviewTitle:"읽기전용 문자로 JSON을 표시",examples:"예제",default:"기본값",containsInvalidProperties:"잘못된 속성이 포함되어 있습니다.",containsInvalidItems:"잘못된 항목이 포함되어 있습니다"}},k=Object.keys(U),M="en",K=typeof navigator<"u"?navigator.language||navigator.userLanguage:void 0,j=k.find(function(A){return A===K})||M;function X(A){var f;A&&((f=k.find(function(T){return T===A}))?j=f:console.error("Language not found"))}function G(A){if(A)for(var f in A)(function(T){k.find(function(I){return I===T})||k.push(T),U[T]=Object.assign({},U[M],U[T],A[T])})(f)}function L(A,f,T){var I=U[T=T||j][A]||U[M][A]||A;if(f)for(var m in f)I=I.replace("${"+m+"}",f[m]);return I}},6056:function(ce,U,D){D.d(U,{J:function(){return j},r:function(){return K}});var U=D(5156),k=D.n(U),M=D(9791);function K(X,T){var L,A=T.sort,f=T.filter,T=T.projection,I="";return f?(L=f.field!=="@"?["0"].concat((0,M.parsePath)("."+f.field)):["0"],L=typeof(0,M.get)(X,L)=="string"?f.value:(0,M.parseString)(f.value),I+="[? "+f.field+" "+f.relation+" `"+JSON.stringify(L)+"`]"):I+=Array.isArray(X)?"[*]":"@",A&&(A.direction==="desc"?I+=" | reverse(sort_by(@, &"+A.field+"))":I+=" | sort_by(@, &"+A.field+")"),T&&(I[I.length-1]!=="]"&&(I+=" | [*]"),T.fields.length===1?I+="."+T.fields[0]:1<T.fields.length&&(I+=".{"+T.fields.map(function(m){var h=m.split(".");return h[h.length-1]+": "+m}).join(", ")+"}")),I}function j(X,G){return k().search(X,G)}},4987:function(){function ce(g){g===void 0||"remove"in g||Object.defineProperty(g,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){this.parentNode!==void 0&&this.parentNode.removeChild(this)}})}typeof Element<"u"&&(window.Element!==void 0&&ce(window.Element.prototype),window.CharacterData!==void 0&&ce(window.CharacterData.prototype),window.DocumentType!==void 0)&&ce(window.DocumentType.prototype),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(g){for(var D=0;D<this.length;D++){var U=this[D];if(g.call(this,U,D,this))return D}return-1},configurable:!0,writable:!0}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(g){return g=this.findIndex(g),this[g]},configurable:!0,writable:!0}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(ce,a,h){h.r(a),h.d(a,{previewModeMixins:function(){return l}});var U=h(1262),k=h(4188),M=h(6436),K=h(2474);function j(t){return(j=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(r){return typeof r}:function(r){return r&&typeof Symbol=="function"&&r.constructor===Symbol&&r!==Symbol.prototype?"symbol":typeof r})(t)}function X(t,r){for(var e=0;e<r.length;e++){var n=r[e];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,function(s){return s=function(o,i){if(j(o)!=="object"||o===null)return o;var c=o[Symbol.toPrimitive];if(c===void 0)return(i==="string"?String:Number)(o);if(c=c.call(o,i||"default"),j(c)!=="object")return c;throw new TypeError("@@toPrimitive must return a primitive value.")}(s,"string"),j(s)==="symbol"?s:String(s)}(n.key),n)}}var G=function(){function t(n,s,o){if(!(this instanceof t))throw new TypeError("Cannot call a class as a function");this.onChange=n,this.calculateItemSize=s||function(){return 1},this.limit=o,this.items=[],this.index=-1}var r,e;return r=t,(e=[{key:"add",value:function(n){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(n),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var n=this.calculateItemSize,s=0;return this.items.forEach(function(o){s+=n(o)}),s}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}])&&X(r.prototype,e),Object.defineProperty(r,"prototype",{writable:!1}),t}(),L=h(7907),A=h(6056),f=h(6617),T=h(6210),I=h(2558),a=h(8458),m=h(9791),h=a.textModeMixins[0].mixin,a={create:function(n){var r=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},e=(r.statusBar===void 0&&(r.statusBar=!0),r.mainMenuBar=r.mainMenuBar!==!1,r.enableSort=r.enableSort!==!1,r.enableTransform=r.enableTransform!==!1,r.createQuery=r.createQuery||A.r,r.executeQuery=r.executeQuery||A.J,typeof(this.options=r).indentation=="number"?this.indentation=Number(r.indentation):this.indentation=2,(0,L.cC)(this.options.languages),(0,L.m0)(this.options.language),this.mode="preview",this),n=(this.container=n,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=(0,m.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=n.clientWidth,this.height=n.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(s){s.preventDefault()},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),n=(this.frameFocusTracker=new K.R(n),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.textContent="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar&&((0,m.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(n=document.createElement("button")).type="button",n.className="jsoneditor-format",n.title=(0,L.Iu)("formatTitle"),this.menu.appendChild(n),n.onclick=function(){e.executeWithBusyMessage(function(){try{e.format()}catch(s){e._onError(s)}},"formatting...")},(n=document.createElement("button")).type="button",n.className="jsoneditor-compact",n.title=(0,L.Iu)("compactTitle"),this.menu.appendChild(n),n.onclick=function(){e.executeWithBusyMessage(function(){try{e.compact()}catch(s){e._onError(s)}},"compacting...")},this.options.enableSort&&((n=document.createElement("button")).type="button",n.className="jsoneditor-sort",n.title=(0,L.Iu)("sortTitleShort"),n.onclick=function(){e._showSortModal()},this.menu.appendChild(n)),this.options.enableTransform&&((n=document.createElement("button")).type="button",n.title=(0,L.Iu)("transformTitleShort"),n.className="jsoneditor-transform",n.onclick=function(){e._showTransformModal()},this.dom.transform=n,this.menu.appendChild(n)),(n=document.createElement("button")).type="button",n.className="jsoneditor-repair",n.title=(0,L.Iu)("repairTitle"),this.menu.appendChild(n),!(n.onclick=function(){e.json===void 0&&e.executeWithBusyMessage(function(){try{e.repair()}catch(s){e._onError(s)}},"repairing...")})!==this.options.history&&(this.history=new G(function(){e.dom.undo.disabled=!e.history.canUndo(),e.dom.redo.disabled=!e.history.canRedo()},function(s){return 2*s.text.length},k.oW),(n=document.createElement("button")).type="button",n.className="jsoneditor-undo jsoneditor-separator",n.title=(0,L.Iu)("undo"),n.onclick=function(){var s=e.history.undo();s&&e._applyHistory(s)},this.menu.appendChild(n),this.dom.undo=n,(n=document.createElement("button")).type="button",n.className="jsoneditor-redo",n.title=(0,L.Iu)("redo"),n.onclick=function(){var s=e.history.redo();s&&e._applyHistory(s)},this.menu.appendChild(n),this.dom.redo=n,this.history.onChange()),this.options)&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new f.x(this.menu,this.options.modes,this.options.mode,function(s){try{e.setMode(s),e.modeSwitcher.focus()}catch(o){e._onError(o)}})),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):this.options.showErrorTable===!0);this.errorTable=new M.Q({errorTableVisible:n,onToggleVisibility:function(){e.validate()},onFocusLine:null,onChangeHeight:function(s){s=s+(e.dom.statusBar?e.dom.statusBar.clientHeight:0)+1,e.content.style.marginBottom=-s+"px",e.content.style.paddingBottom=s+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),r.statusBar&&((0,m.addClassName)(this.content,"has-status-bar"),n=document.createElement("div"),(this.dom.statusBar=n).className="jsoneditor-statusbar",this.frame.appendChild(n),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",n.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",n.appendChild(this.dom.arrayInfo),n.appendChild(this.errorTable.getErrorCounter()),n.appendChild(this.errorTable.getWarningIcon()),n.appendChild(this.errorTable.getErrorIcon())),this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var t=this.getText();this.dom.previewText.nodeValue=(0,m.limitCharacters)(t,k.WF),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,m.formatSize)(t.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(t){console.error("Error in onChange callback: ",t)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(t){console.error("Error in onChangeJSON callback: ",t)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(t){console.error("Error in onChangeText callback: ",t)}}},l=(a._showSortModal=function(){var t=this;this.executeWithBusyMessage(function(){var r=t.options.modalAnchor||k.qD,e=t.get();t._renderPreview(),(0,T.showSortModal)(r,e,function(n){t.executeWithBusyMessage(function(){var s,o,i;s=e,o=n,Array.isArray(s)&&(i=(0,m.sort)(s,o.path,o.direction),t.sortedBy=o,t._setAndFireOnChange(i)),(0,m.isObject)(s)&&(i=(0,m.sortObjectKeys)(s,o.direction),t.sortedBy=o,t._setAndFireOnChange(i))},"sorting...")},t.sortedBy)},"parsing...")},a._showTransformModal=function(){var t=this;this.executeWithBusyMessage(function(){var s=t.options,r=s.createQuery,e=s.executeQuery,n=s.modalAnchor,s=s.queryDescription,o=t.get();t._renderPreview(),(0,I.showTransformModal)({container:n||k.qD,json:o,queryDescription:s,createQuery:r,executeQuery:e,onTransform:function(i){t.executeWithBusyMessage(function(){var c=e(o,i);t._setAndFireOnChange(c)},"transforming...")}})},"parsing...")},a.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history&&(this.history.clear(),this.history=null),this.frameFocusTracker.destroy()},a.compact=function(){var t=this.get(),r=JSON.stringify(t);this._setTextAndFireOnChange(r,t)},a.format=function(){var t=this.get(),r=JSON.stringify(t,null,this.indentation);this._setTextAndFireOnChange(r,t)},a.repair=function(){var t=this.getText();try{var r=(0,U.K)(t);this._setTextAndFireOnChange(r)}catch{}},a.focus=function(){this.dom.transform.focus()},a.set=function(t){this.history&&this.history.clear(),this._set(t)},a.update=function(t){this._set(t)},a._set=function(t){this.text=void 0,this.json=t,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},a._setAndFireOnChange=function(t){this._set(t),this._onChange()},a.get=function(){var t;return this.json===void 0&&(t=this.getText(),this.json=(0,m.parse)(t)),this.json},a.getText=function(){return this.text===void 0&&(this.text=JSON.stringify(this.json,null,this.indentation),this.options.escapeUnicode===!0)&&(this.text=(0,m.escapeUnicodeChars)(this.text)),this.text},a.setText=function(t){this.history&&this.history.clear(),this._setText(t)},a.updateText=function(t){this.getText()!==t&&this._setText(t)},a._setText=function(t,r){var e;this.options.escapeUnicode===!0?this.text=(0,m.escapeUnicodeChars)(t):this.text=t,this.json=r,this._renderPreview(),this.json===void 0?(e=this).executeWithBusyMessage(function(){try{e.json=e.get(),e._renderPreview(),e._pushHistory()}catch{}},"parsing..."):this._pushHistory(),this._debouncedValidate()},a._setTextAndFireOnChange=function(t,r){this._setText(t,r),this._onChange()},a._applyHistory=function(t){this.json=t.json,this.text=t.text,this._renderPreview(),this._debouncedValidate()},a._pushHistory=function(){var t;this.history&&(t={text:this.text,json:this.json},this.history.add(t))},a.executeWithBusyMessage=function(t,r){var e;this.getText().length>k.EX?((0,m.addClassName)((e=this).frame,"busy"),e.dom.busyContent.innerText=r,setTimeout(function(){t(),(0,m.removeClassName)(e.frame,"busy"),e.dom.busyContent.innerText=""},100)):t()},a.validate=h.validate,a._renderErrors=h._renderErrors,[{mode:"preview",mixin:a,data:"json"}])},6210:function(ce,U,D){D.r(U),D.d(U,{showSortModal:function(){return j}});var U=D(483),k=D.n(U),M=D(7907),K=D(9791);function j(X,m,L,A){var f=Array.isArray(m)?(0,K.getChildPaths)(m):[""],T=A&&A.path&&(0,K.contains)(f,A.path)?A.path:f[0],I=A&&A.direction||"asc",m='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,M.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,M.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+(0,M.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,M.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,M.Iu)("sortAscending")+'" title="'+(0,M.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,M.Iu)("sortDescending")+'" title="'+(0,M.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,M.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';k()({parent:X,content:m,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(h){var a=h.modalElem().querySelector("form"),l=h.modalElem().querySelector("#ok"),t=h.modalElem().querySelector("#field"),r=h.modalElem().querySelector("#direction");function e(n){r.value=n,r.className="jsoneditor-button-group jsoneditor-button-group-value-"+r.value}f.forEach(function(n){var s,o=document.createElement("option");o.text=(s=n)===""?"@":s[0]==="."?s.slice(1):s,o.value=n,t.appendChild(o)}),t.value=T||f[0],e(I||"asc"),r.onclick=function(n){e(n.target.getAttribute("data-value"))},l.onclick=function(n){n.preventDefault(),n.stopPropagation(),h.close(),L({path:t.value,direction:r.value})},a&&(a.onsubmit=l.onclick)}).afterClose(function(h){h.destroy()}).show()}},2558:function(ce,k,D){D.r(k),D.d(k,{showTransformModal:function(){return T}});var k=D(483),U=D.n(k),k=D(3879),M=D.n(k),K=D(7907);function j(I){return(j=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(m){return typeof m}:function(m){return m&&typeof Symbol=="function"&&m.constructor===Symbol&&m!==Symbol.prototype?"symbol":typeof m})(I)}function X(I,m,h,a){if(typeof I=="boolean"||I instanceof Boolean||I===null||typeof I=="number"||I instanceof Number||typeof I=="string"||I instanceof String||I instanceof Date)return JSON.stringify(I);if(Array.isArray(I)){for(var l=I,t=m,r=h,e=a,n=t?r+t:void 0,s=t?`[
`:"[",o=0;o<l.length;o++){var i=l[o];if(t&&(s+=n),s+=i!==void 0&&typeof i!="function"?X(i,t,n,e):"null",o<l.length-1&&(s+=t?`,
`:","),s.length>e)return s+"..."}return s+=t?`
`+r+"]":"]"}if(I&&j(I)==="object"){var c,d=I,C=m,r=h,p=a,w=C?r+C:void 0,x=!0,$=C?`{
`:"{";if(typeof d.toJSON=="function")return X(d.toJSON(),C,r,p);for(c in d)if(function(Z,u){return Object.prototype.hasOwnProperty.call(Z,u)}(d,c)){var P=d[c];if(x?x=!1:$+=C?`,
`:",",($=($+=C?w+'"'+c+'": ':'"'+c+'":')+X(P,C,w,p)).length>p)return $+"..."}return $+=C?`
`+r+"}":"}"}}function G(I,m){for(var h="";0<m--;)h+=I;return h}var L=D(9791),A=D(4188),f='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';function T(n){var m=n.container,h=n.json,a=n.queryDescription,a=a===void 0?f:a,l=n.createQuery,t=n.executeQuery,r=n.onTransform,e=h,n='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,K.Iu)("transform")+"</div><p>"+a+'</p><div class="jsoneditor-jmespath-label">'+(0,K.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+(0,K.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+(0,K.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+(0,K.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,K.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+(0,K.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,K.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,K.Iu)("ok")+'" autofocus /></div></div>';U()({parent:m,content:n,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(s){var o=s.modalElem(),B=o.querySelector("#wizard"),i=o.querySelector("#ok"),c=o.querySelector("#filterField"),d=o.querySelector("#filterRelation"),C=o.querySelector("#filterValue"),p=o.querySelector("#sortField"),w=o.querySelector("#sortOrder"),x=o.querySelector("#selectFields"),$=o.querySelector("#query"),P=o.querySelector("#preview");Array.isArray(e)||(B.style.fontStyle="italic",B.textContent="(wizard not available for objects, only for arrays)"),(0,L.getChildPaths)(h).forEach(function(Q){var Q=y(Q),z=document.createElement("option"),z=(z.text=Q,z.value=Q,c.appendChild(z),document.createElement("option"));z.text=Q,z.value=Q,p.appendChild(z)});var B=(0,L.getChildPaths)(h,!0).filter(function(Y){return Y!==""}),B=(0<B.length?B.forEach(function(Q){var Q=y(Q),z=document.createElement("option");z.text=Q,z.value=Q,x.appendChild(z)}):(B=o.querySelector("#selectFieldsPart"))&&(B.style.display="none"),new(M())(c,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."})),Z=new(M())(d,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),u=new(M())(p,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),v=new(M())(w,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),N=new(M())(x,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function y(Y){return Y===""?"@":Y[0]==="."?Y.slice(1):Y}B.on("selectr.change",F),Z.on("selectr.change",F),C.oninput=F,u.on("selectr.change",F),v.on("selectr.change",F),N.on("selectr.change",F),o.querySelector(".pico-modal-contents").onclick=function(Y){Y.target.nodeName!=="A"&&Y.preventDefault()};var _=(0,L.debounce)(function(){try{var Y=t(e,$.value);P.className="jsoneditor-transform-preview",P.value=(Q=Y,z=2,te=A.WF,typeof z=="number"?10<z?E=G(" ",10):1<=z&&(E=G(" ",z)):typeof z=="string"&&z!==""&&(E=z),(z=X(Q,E,"",te)).length>te?(Q=z,(typeof(E=te)=="number"?Q.slice(0,E):Q)+"..."):z),i.disabled=!1}catch(H){P.className="jsoneditor-transform-preview jsoneditor-error",P.value=H.toString(),i.disabled=!0}var Q,z,te,E},300);function W(Y,Q){try{$.value=l(Y,Q),i.disabled=!1,_()}catch(z){Y='Error: an error happened when executing "createQuery": '+(z.message||z.toString()),$.value="",i.disabled=!0,P.className="jsoneditor-transform-preview jsoneditor-error",P.value=Y}}function F(){var Y={};if(c.value&&d.value&&C.value&&(Y.filter={field:c.value,relation:d.value,value:C.value}),p.value&&w.value&&(Y.sort={field:p.value,direction:w.value}),x.value){for(var Q,z=[],te=0;te<x.options.length;te++)x.options[te].selected&&(Q=x.options[te].value,z.push(Q));Y.projection={fields:z}}W(h,Y)}$.oninput=_,i.onclick=function(Y){Y.preventDefault(),Y.stopPropagation(),s.close(),r($.value)},W(h,{}),setTimeout(function(){$.select(),$.focus(),$.selectionStart=3,$.selectionEnd=3})}).afterClose(function(s){s.destroy()}).show()}},8458:function(ce,r,D){D.r(r),D.d(r,{textModeMixins:function(){return s}});var U=D(1262),r=D(8170),k=D.n(r),M=D(4188),K=D(6436),j=D(2474),X=D(7907),G=D(6056),L=D(6617),A=D(6210),f=D(2558),T=D(9125),I=D(7026),m=D(9791);function h(o){return(h=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(i){return typeof i}:function(i){return i&&typeof Symbol=="function"&&i.constructor===Symbol&&i!==Symbol.prototype?"symbol":typeof i})(o)}function a(o,i){for(var c=0;c<i.length;c++){var d=i[c];d.enumerable=d.enumerable||!1,d.configurable=!0,"value"in d&&(d.writable=!0),Object.defineProperty(o,function(C){return C=function(p,w){if(h(p)!=="object"||p===null)return p;var x=p[Symbol.toPrimitive];if(x===void 0)return(w==="string"?String:Number)(p);if(x=x.call(p,w||"default"),h(x)!=="object")return x;throw new TypeError("@@toPrimitive must return a primitive value.")}(C,"string"),h(C)==="symbol"?C:String(C)}(d.key),d)}}var l=function(){function o(d,C){if(!(this instanceof o))throw new TypeError("Cannot call a class as a function");this.schema=d,this.schemaRefs=C||{},this.suggestions={},this.suggestionsRefs={},this._buildSuggestions()}var i,c;return i=o,(c=[{key:"_buildSuggestions",value:function(){for(var d in this._handleSchemaEntry("",this.schema,this.suggestions),this.schemaRefs)this.suggestionsRefs[d]={},this._handleSchemaEntry("",this.schemaRefs[d],this.suggestionsRefs[d])}},{key:"_handleRef",value:function(d,C,p){p[d]=p[d]||{},p[d].refs=p[d].refs||[],p[d].refs=(0,m.uniqueMergeArrays)(p[d].refs,[C])}},{key:"_handleSchemaEntry",value:function(d,C,p){if(C)if(C.$ref)this._handleRef(d,C.$ref,p);else{var w=this._checkOfConditon(C);if(w)this._handleOfCondition(d,C[w],p);else switch(C.type){case"object":this._handleObject(d,C,p);break;case"string":case"number":case"integer":this._handlePrimitive(d,C,p);break;case"boolean":this._handleBoolean(d,C,p);break;case"array":this._handleArray(d,C,p)}}else console.error("SchemaTextCompleter: schema node is missing for path",d)}},{key:"_handleObject",value:function(d,C,p){var w,x=this;(0,m.isObject)(C.properties)&&(w=Object.keys(C.properties),p[d]=p[d]||{},p[d].props=p[d].props||[],p[d].props=(0,m.uniqueMergeArrays)(p[d].props,w),w.forEach(function($){(0,m.asyncExec)(function(){x._handleSchemaEntry("".concat(d,"/").concat($),C.properties[$],p)})}))}},{key:"_handlePrimitive",value:function(d,C,p){p[d]=p[d]||{},(0,m.isArray)(C.examples)&&(p[d].examples=p[d].examples||[],p[d].examples=(0,m.uniqueMergeArrays)(p[d].examples,C.examples)),(0,m.isArray)(C.enum)&&(p[d].enum=p[d].enum||[],p[d].enum=(0,m.uniqueMergeArrays)(p[d].enum,C.enum))}},{key:"_handleBoolean",value:function(d,C,p){p[d]||(p[d]={bool:[!0,!1]})}},{key:"_handleArray",value:function(d,C,p){var w=this;C.items&&(0,m.asyncExec)(function(){w._handleSchemaEntry("".concat(d,"/\\d+"),C.items,p)})}},{key:"_handleOfCondition",value:function(d,C,p){var w=this;C&&C.length&&C.forEach(function(x){(0,m.asyncExec)(function(){w._handleSchemaEntry(d,x,p)})})}},{key:"_checkOfConditon",value:function(d){if(d)return d.oneOf?"oneOf":d.anyOf?"anyOf":d.allOf?"allOf":void 0}},{key:"getCompletions",value:function(d,C,p,w,x){var $=this;try{var P=I.parse(C.getValue()).pointers||{},B=function(Z){function u(y){var _,W={props:"property",enum:"enum",bool:"boolean",examples:"examples"};Z&&(_=Z[y])!=null&&_.length&&(v=v.concat(Z[y].map(function(F){return{caption:F+"",meta:"schema [".concat(W[y],"]"),score:N++,value:F+""}})))}var v=[],N=0;u("props"),u("enum"),u("bool"),u("examples"),v.length&&x(null,v)};Object.keys(P).forEach(function(Z){(0,m.asyncExec)(function(){function u(y,_,W){var F,Y=Object.keys(_).reduce(function(E,H){return new RegExp("^".concat(W).concat(H)).test(y)&&(!E||E.length<H.length)?H:E});if(typeof Y=="string"){if((F=_[Y])!=null&&(F=F.refs)!=null&&F.length){var Q,z={};for(Q in _[Y].refs){var te=_[Y].refs[Q];$.suggestionsRefs[te]&&((te=u(y,$.suggestionsRefs[te],"".concat(W).concat(Y)))!=null&&te.enum&&(z.enum=(0,m.uniqueMergeArrays)(z.enum,te.enum)),te!=null&&te.examples&&(z.examples=(0,m.uniqueMergeArrays)(z.examples,te.examples)),te!=null&&te.bool&&(z.bool=(0,m.uniqueMergeArrays)(z.bool,te.bool)),te!=null)&&te.props&&(z.props=(0,m.uniqueMergeArrays)(z.props,te.props))}return z}if(new RegExp("^".concat(W).concat(Y,"$")).test(y))return _[Y]}}var v,N;((N=P[Z].key)==null?void 0:N.line)===p.row&&p.column>=P[Z].key.column&&p.column<=P[Z].keyEnd.column&&(v=Z.slice(0,Z.lastIndexOf("/"))),(v=((N=P[Z].value)==null?void 0:N.line)===p.row&&((N=P[Z].value)==null?void 0:N.line)===((N=P[Z].valueEnd)==null?void 0:N.line)&&p.column>=P[Z].value.column&&p.column<=P[Z].valueEnd.column?Z:v)&&(N=u(v,$.suggestions,""),B(N))})})}catch{}}}])&&a(i.prototype,c),Object.defineProperty(i,"prototype",{writable:!1}),o}();function t(o){return(t=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(i){return typeof i}:function(i){return i&&typeof Symbol=="function"&&i.constructor===Symbol&&i!==Symbol.prototype?"symbol":typeof i})(o)}var r={},e="ace/theme/jsoneditor";function n(){try{this.format()}catch{}}r.create=function(x){var i,c,d,C=this,p=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},$=(p.statusBar===void 0&&(p.statusBar=!0),p.mainMenuBar=p.mainMenuBar!==!1,p.enableSort=p.enableSort!==!1,p.enableTransform=p.enableTransform!==!1,p.createQuery=p.createQuery||G.r,p.executeQuery=p.executeQuery||G.J,p.showErrorTable=p.showErrorTable!==void 0?p.showErrorTable:["text","preview"],typeof(this.options=p).indentation=="number"?this.indentation=Number(p.indentation):this.indentation=2,(0,X.cC)(this.options.languages),(0,X.m0)(this.options.language),p.ace||k()),w=(this.mode=p.mode==="code"?"code":"text",this.mode==="code"&&$===void 0&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=p.theme||e,this.theme===e&&$&&(0,T.O)(),p.onTextSelectionChange&&this.onTextSelectionChange(p.onTextSelectionChange),this),x=(this.container=x,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this.lastSchemaErrors=void 0,this._debouncedValidate=(0,m.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),this.width=x.clientWidth,this.height=x.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(P){P.preventDefault()},this.frame.onkeydown=function(P){w._onKeyDown(P)},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),x=(this.frameFocusTracker=new j.R(x),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar&&((0,m.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(x=document.createElement("button")).type="button",x.className="jsoneditor-format",x.title=(0,X.Iu)("formatTitle"),this.menu.appendChild(x),x.onclick=function(){try{w.format(),w._onChange()}catch(P){w._onError(P)}},(x=document.createElement("button")).type="button",x.className="jsoneditor-compact",x.title=(0,X.Iu)("compactTitle"),this.menu.appendChild(x),x.onclick=function(){try{w.compact(),w._onChange()}catch(P){w._onError(P)}},this.options.enableSort&&((x=document.createElement("button")).type="button",x.className="jsoneditor-sort",x.title=(0,X.Iu)("sortTitleShort"),x.onclick=function(){w._showSortModal()},this.menu.appendChild(x)),this.options.enableTransform&&((x=document.createElement("button")).type="button",x.title=(0,X.Iu)("transformTitleShort"),x.className="jsoneditor-transform",x.onclick=function(){w._showTransformModal()},this.menu.appendChild(x)),(x=document.createElement("button")).type="button",x.className="jsoneditor-repair",x.title=(0,X.Iu)("repairTitle"),this.menu.appendChild(x),x.onclick=function(){try{w.repair(),w._onChange()}catch(P){w._onError(P)}},this.mode==="code"&&((x=document.createElement("button")).type="button",x.className="jsoneditor-undo jsoneditor-separator",x.title=(0,X.Iu)("undo"),x.onclick=function(){C.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(x),this.dom.undo=x,(x=document.createElement("button")).type="button",x.className="jsoneditor-redo",x.title=(0,X.Iu)("redo"),x.onclick=function(){C.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(x),this.dom.redo=x),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new L.x(this.menu,this.options.modes,this.options.mode,function(P){try{w.setMode(P),w.modeSwitcher.focus()}catch(B){w._onError(B)}})),this.mode==="code")&&((i=document.createElement("a")).appendChild(document.createTextNode("powered by ace")),i.href="https://ace.c9.io/",i.target="_blank",i.className="jsoneditor-poweredBy",i.onclick=function(){window.open(i.href,i.target,"noreferrer")},this.menu.appendChild(i)),this.options.onEditable&&t(this.options.onEditable==="function")&&!this.options.onEditable({})),$=(this.frame.appendChild(this.content),this.container.appendChild(this.frame),this.mode==="code"?(this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom),d=($=$.edit(this.editorDom)).getSession(),$.$blockScrolling=1/0,$.setTheme(this.theme),$.setOptions({readOnly:x}),$.setShowPrintMargin(!1),$.setFontSize("14px"),d.setMode("ace/mode/json"),d.setTabSize(this.indentation),d.setUseSoftTabs(!0),d.setUseWrapMode(!0),c=d.setAnnotations,d.setAnnotations=function(P){c.call(this,P&&P.length?P:w.annotations)},$.commands.bindKey("Ctrl-L",null),$.commands.bindKey("Command-L",null),$.commands.bindKey("Ctrl-\\",null),$.commands.bindKey("Command-\\",null),$.commands.bindKey("Ctrl-Shift-\\",null),$.commands.bindKey("Command-Shift-\\",null),(this.aceEditor=$).on("change",this._onChange.bind(this)),$.on("changeSelection",this._onSelect.bind(this))):((d=document.createElement("textarea")).className="jsoneditor-text",d.spellcheck=!1,this.content.appendChild(d),this.textarea=d,this.textarea.readOnly=x,this.textarea.oninput===null?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),d.onselect=this._onSelect.bind(this),d.onmousedown=this._onMouseDown.bind(this),d.onblur=this._onBlur.bind(this)),this._updateHistoryButtons(),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):this.options.showErrorTable===!0);this.errorTable=new K.Q({errorTableVisible:$,onToggleVisibility:function(){w._validateAndCatch()},onFocusLine:function(P){w.isFocused=!0,isNaN(P)||w.setTextSelection({row:P,column:1},{row:P,column:1e3})},onChangeHeight:function(P){P=P+(w.dom.statusBar?w.dom.statusBar.clientHeight:0)+1,w.content.style.marginBottom=-P+"px",w.content.style.paddingBottom=P+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),p.statusBar&&((0,m.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},x=document.createElement("div"),(this.dom.statusBar=x).className="jsoneditor-statusbar",this.frame.appendChild(x),(d=document.createElement("span")).className="jsoneditor-curserinfo-label",d.innerText="Ln:",($=document.createElement("span")).className="jsoneditor-curserinfo-val",$.innerText="1",x.appendChild(d),x.appendChild($),(p=document.createElement("span")).className="jsoneditor-curserinfo-label",p.innerText="Col:",(d=document.createElement("span")).className="jsoneditor-curserinfo-val",d.innerText="1",x.appendChild(p),x.appendChild(d),this.curserInfoElements.colVal=d,this.curserInfoElements.lnVal=$,(p=document.createElement("span")).className="jsoneditor-curserinfo-label",p.innerText="characters selected",p.style.display="none",(d=document.createElement("span")).className="jsoneditor-curserinfo-count",d.innerText="0",d.style.display="none",this.curserInfoElements.countLabel=p,this.curserInfoElements.countVal=d,x.appendChild(d),x.appendChild(p),x.appendChild(this.errorTable.getErrorCounter()),x.appendChild(this.errorTable.getWarningIcon()),x.appendChild(this.errorTable.getErrorIcon())),this.setSchema(this.options.schema,this.options.schemaRefs)},r._onSchemaChange=function(o,i){this.aceEditor&&(this.options.allowSchemaSuggestions&&o?(this.aceEditor.setOption("enableBasicAutocompletion",[new l(o,i)]),this.aceEditor.setOption("enableLiveAutocompletion",!0)):(this.aceEditor.setOption("enableBasicAutocompletion",void 0),this.aceEditor.setOption("enableLiveAutocompletion",!1)))},r._onChange=function(){var o=this;if(!this.onChangeDisabled){if(setTimeout(function(){o._updateHistoryButtons&&o._updateHistoryButtons()}),this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(i){console.error("Error in onChange callback: ",i)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(i){console.error("Error in onChangeText callback: ",i)}}},r._updateHistoryButtons=function(){var o;this.aceEditor&&this.dom.undo&&this.dom.redo&&(o=this.aceEditor.getSession().getUndoManager())&&o.hasUndo&&o.hasRedo&&(this.dom.undo.disabled=!o.hasUndo(),this.dom.redo.disabled=!o.hasRedo())},r._showSortModal=function(){try{var o=this,i=this.options.modalAnchor||M.qD,c=this.get();(0,A.showSortModal)(i,c,function(d){var C;Array.isArray(c)&&(C=(0,m.sort)(c,d.path,d.direction),o.sortedBy=d,o.update(C)),(0,m.isObject)(c)&&(C=(0,m.sortObjectKeys)(c,d.direction),o.sortedBy=d,o.update(C))},o.sortedBy)}catch(d){this._onError(d)}},r._showTransformModal=function(){var o=this;try{var i=this.options,c=i.modalAnchor,d=i.createQuery,C=i.executeQuery,p=i.queryDescription,w=this.get();(0,f.showTransformModal)({container:c||M.qD,json:w,queryDescription:p,createQuery:d,executeQuery:C,onTransform:function(x){x=C(w,x),o.update(x)}})}catch(x){this._onError(x)}},r._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},r._onKeyDown=function(o){var i=!1;(o.which||o.keyCode)===73&&o.ctrlKey&&(o.shiftKey?this.compact():this.format(),this._onChange(),i=!0),i&&(o.preventDefault(),o.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},r._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},r._onBlur=function(){var o=this;setTimeout(function(){o.isFocused||(o._updateCursorInfo(),o._emitSelectionChange()),o.isFocused=!1})},r._updateCursorInfo=function(){var o,i,c,d,C,p=this;function w(){p.curserInfoElements.countVal.innerText!==C&&(p.curserInfoElements.countVal.innerText=C,p.curserInfoElements.countVal.style.display=C?"inline":"none",p.curserInfoElements.countLabel.style.display=C?"inline":"none"),p.curserInfoElements.lnVal.innerText=c,p.curserInfoElements.colVal.innerText=d}this.textarea?setTimeout(function(){var x=(0,m.getInputSelection)(p.textarea);x.startIndex!==x.endIndex&&(C=x.endIndex-x.startIndex),d=(C&&p.cursorInfo&&p.cursorInfo.line===x.end.row&&p.cursorInfo.column===x.end.column?(c=x.start.row,x.start):(c=x.end.row,x.end)).column,p.cursorInfo={line:c,column:d,count:C},p.options.statusBar&&w()},0):this.aceEditor&&this.curserInfoElements&&(o=this.aceEditor.getCursorPosition(),i=this.aceEditor.getSelectedText(),c=o.row+1,d=o.column+1,C=i.length,p.cursorInfo={line:c,column:d,count:C},this.options.statusBar)&&w()},r._emitSelectionChange=function(){var o;this._selectionChangedHandler&&(o=this.getTextSelection(),this._selectionChangedHandler(o.start,o.end,o.text))},r._refreshAnnotations=function(){var o,i=this.aceEditor&&this.aceEditor.getSession();i&&(o=i.getAnnotations().filter(function(c){return c.type==="error"}),i.setAnnotations(o))},r.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null,this.frameFocusTracker.destroy()},r.compact=function(){var o=this.get(),o=JSON.stringify(o);this.updateText(o)},r.format=function(){var o=this.get(),o=JSON.stringify(o,null,this.indentation);this.updateText(o)},r.repair=function(){var o=this.getText();try{var i=(0,U.K)(o);this.updateText(i)}catch{}},r.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},r.resize=function(){this.aceEditor&&this.aceEditor.resize(!1)},r.set=function(o){this.setText(JSON.stringify(o,null,this.indentation))},r.update=function(o){this.updateText(JSON.stringify(o,null,this.indentation))},r.get=function(){var o=this.getText();return(0,m.parse)(o)},r.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},r._setText=function(C,i){var c,d=this,C=this.options.escapeUnicode===!0?(0,m.escapeUnicodeChars)(C):C;this.textarea&&(this.textarea.value=C),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(C,-1),this.onChangeDisabled=!1,i&&(c=this,setTimeout(function(){c.aceEditor&&c.aceEditor.session.getUndoManager().reset()})),setTimeout(function(){d._updateHistoryButtons&&d._updateHistoryButtons()})),this._debouncedValidate()},r.setText=function(o){this._setText(o,!0)},r.updateText=function(o){this.getText()!==o&&this._setText(o,!1)},r.validate=function(){var o,i=this,c=[],d=[];try{var C=this.get(),p=(this.validateSchema&&!this.validateSchema(C)&&(c=this.validateSchema.errors.map(function(x){return x.type="validation",(0,m.improveSchemaError)(x)})),this.validationSequence=(this.validationSequence||0)+1,this),w=this.validationSequence;return function(x,$){if(!$)return Promise.resolve([]);try{var P=$(x);return((0,m.isPromise)(P)?P:Promise.resolve(P)).then(function(B){return Array.isArray(B)?B.filter(function(Z){var u=(0,m.isValidValidationError)(Z);return u||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',Z),u}).map(function(Z){return{dataPath:(0,m.stringifyPath)(Z.path),message:Z.message,type:"customValidation"}}):[]})}catch(B){return Promise.reject(B)}}(C,this.options.onValidate).then(function(x){return w===p.validationSequence&&(x=c.concat(d).concat(x),p._renderErrors(x),typeof i.options.onValidationError=="function"&&(0,m.isValidationErrorChanged)(x,i.lastSchemaErrors)&&i.options.onValidationError.call(i,x),i.lastSchemaErrors=x),i.lastSchemaErrors})}catch(x){return this.getText()&&((C=/\w*line\s*(\d+)\w*/g.exec(x.message))&&(o=+C[1]),d=[{type:"error",message:x.message.replace(/\n/g,"<br>"),line:o}]),this._renderErrors(d),typeof this.options.onValidationError=="function"&&(0,m.isValidationErrorChanged)(d,this.lastSchemaErrors)&&this.options.onValidationError.call(this,d),this.lastSchemaErrors=d,Promise.resolve(this.lastSchemaErrors)}},r._validateAndCatch=function(){this.validate().catch(function(o){console.error("Error running validation:",o)})},r._renderErrors=function(o){var c=this.getText(),i=[],c=(o.reduce(function(d,C){return typeof C.dataPath=="string"&&d.indexOf(C.dataPath)===-1&&d.push(C.dataPath),d},i),(0,m.getPositionForPath)(c,i));this.aceEditor&&(this.annotations=c.map(function(d){var C=o.filter(function(w){return w.dataPath===d.path}),p=C.map(function(w){return w.message}).join(`
`);return p?{row:d.line,column:d.column,text:"Schema validation error"+(C.length!==1?"s":"")+`: 
`+p,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(o,c),this.aceEditor&&this.aceEditor.resize(!1)},r.getTextSelection=function(){var o,i,c,d={};return this.textarea?(c=(0,m.getInputSelection)(this.textarea),this.cursorInfo&&this.cursorInfo.line===c.end.row&&this.cursorInfo.column===c.end.column?(d.start=c.end,d.end=c.start):d=c,{start:d.start,end:d.end,text:this.textarea.value.substring(c.startIndex,c.endIndex)}):this.aceEditor?(c=this.aceEditor.getSelection(),o=this.aceEditor.getSelectedText(),i=c.getRange(),(c=c.getSelectionLead()).row===i.end.row&&c.column===i.end.column?d=i:(d.start=i.end,d.end=i.start),{start:{row:d.start.row+1,column:d.start.column+1},end:{row:d.end.row+1,column:d.end.column+1},text:o}):void 0},r.onTextSelectionChange=function(o){typeof o=="function"&&(this._selectionChangedHandler=(0,m.debounce)(o,this.DEBOUNCE_INTERVAL))},r.setTextSelection=function(o,i){var c,d,C;o&&i&&(this.textarea?(c=(0,m.getIndexForPosition)(this.textarea,o.row,o.column),C=(0,m.getIndexForPosition)(this.textarea,i.row,i.column),-1<c&&-1<C&&(this.textarea.setSelectionRange?(this.textarea.focus(),this.textarea.setSelectionRange(c,C)):this.textarea.createTextRange&&((d=this.textarea.createTextRange()).collapse(!0),d.moveEnd("character",C),d.moveStart("character",c),d.select()),C=(this.textarea.value.match(/\n/g)||[]).length+1,c=this.textarea.scrollHeight/C,d=o.row*c,this.textarea.scrollTop=d>this.textarea.clientHeight?d-this.textarea.clientHeight/2:0)):this.aceEditor&&(C={start:{row:o.row-1,column:o.column-1},end:{row:i.row-1,column:i.column-1}},this.aceEditor.selection.setRange(C),this.aceEditor.scrollToLine(o.row-1,!0)))};var s=[{mode:"text",mixin:r,data:"text",load:n},{mode:"code",mixin:r,data:"text",load:n}]},8038:function(ce,Y,z){z.r(Y),z.d(Y,{treeModeMixins:function(){return te}});var U={start:function(E,H,V){return H.indexOf(E)===0},contain:function(E,H,V){return-1<H.indexOf(E)}},k=z(897),M=z(2474);function K(E){return(K=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(H){return typeof H}:function(H){return H&&typeof Symbol=="function"&&H.constructor===Symbol&&H!==Symbol.prototype?"symbol":typeof H})(E)}function j(E,H){for(var V=0;V<H.length;V++){var b=H[V];b.enumerable=b.enumerable||!1,b.configurable=!0,"value"in b&&(b.writable=!0),Object.defineProperty(E,function(S){return S=function(R,O){if(K(R)!=="object"||R===null)return R;var J=R[Symbol.toPrimitive];if(J===void 0)return(O==="string"?String:Number)(R);if(J=J.call(R,O||"default"),K(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),K(S)==="symbol"?S:String(S)}(b.key),b)}}var X=function(){function E(){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");this.locked=!1}var H,V;return H=E,(V=[{key:"highlight",value:function(b){this.locked||(this.node!==b&&(this.node&&this.node.setHighlight(!1),this.node=b,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){var b;this.locked||(b=this).node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){b.node.setHighlight(!1),b.node=void 0,b.unhighlightTimer=void 0},0))}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}])&&j(H.prototype,V),Object.defineProperty(H,"prototype",{writable:!1}),E}(),G=z(7907),L=z(6056),A=z(6617),Y=z(233),f=z.n(Y),T=z(2602),I=z(9791),m=z(6210),h=z(2558),a=z(4188);function l(E){return function(H){if(Array.isArray(H))return n(H)}(E)||function(H){if(typeof Symbol<"u"&&H[Symbol.iterator]!=null||H["@@iterator"]!=null)return Array.from(H)}(E)||e(E)||function(){throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function t(E,H){return function(V){if(Array.isArray(V))return V}(E)||function(V,b){var S=V==null?null:typeof Symbol<"u"&&V[Symbol.iterator]||V["@@iterator"];if(S!=null){var R,O,J,re,pe=[],me=!0,ye=!1;try{if(J=(S=S.call(V)).next,b===0){if(Object(S)!==S)return;me=!1}else for(;!(me=(R=J.call(S)).done)&&(pe.push(R.value),pe.length!==b);me=!0);}catch(xe){ye=!0,O=xe}finally{try{if(!me&&S.return!=null&&(re=S.return(),Object(re)!==re))return}finally{if(ye)throw O}}return pe}}(E,H)||e(E,H)||function(){throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function r(E,H){var V,b,S,R,O=typeof Symbol<"u"&&E[Symbol.iterator]||E["@@iterator"];if(O)return b=!(V=!0),{s:function(){O=O.call(E)},n:function(){var J=O.next();return V=J.done,J},e:function(J){b=!0,S=J},f:function(){try{V||O.return==null||O.return()}finally{if(b)throw S}}};if(Array.isArray(E)||(O=e(E))||H&&E&&typeof E.length=="number")return O&&(E=O),R=0,{s:H=function(){},n:function(){return R>=E.length?{done:!0}:{done:!1,value:E[R++]}},e:function(J){throw J},f:H};throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}function e(E,H){var V;if(E)return typeof E=="string"?n(E,H):(V=(V=Object.prototype.toString.call(E).slice(8,-1))==="Object"&&E.constructor?E.constructor.name:V)==="Map"||V==="Set"?Array.from(E):V==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(V)?n(E,H):void 0}function n(E,H){(H==null||H>E.length)&&(H=E.length);for(var V=0,b=new Array(H);V<H;V++)b[V]=E[V];return b}function s(E){return(s=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(H){return typeof H}:function(H){return H&&typeof Symbol=="function"&&H.constructor===Symbol&&H!==Symbol.prototype?"symbol":typeof H})(E)}function o(E,H){for(var V=0;V<H.length;V++){var b=H[V];b.enumerable=b.enumerable||!1,b.configurable=!0,"value"in b&&(b.writable=!0),Object.defineProperty(E,function(S){return S=function(R,O){if(s(R)!=="object"||R===null)return R;var J=R[Symbol.toPrimitive];if(J===void 0)return(O==="string"?String:Number)(R);if(J=J.call(R,O||"default"),s(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),s(S)==="symbol"?S:String(S)}(b.key),b)}}var i=function(){function E(b,S){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");this.editor=b,this.dom={},this.expanded=!1,S&&S instanceof Object?(this.setField(S.field,S.fieldEditable),"value"in S&&this.setValue(S.value,S.type),"internalValue"in S&&this.setInternalValue(S.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=(0,I.debounce)(this._onChangeValue.bind(this),E.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=(0,I.debounce)(this._onChangeField.bind(this),E.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}var H,V;return H=E,(V=[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:c}},{key:"_updateEditability",value:function(){var b,S;this.editable={field:!0,value:!0},this.editor&&(this.editable.field=this.editor.options.mode==="tree",this.editable.value=this.editor.options.mode!=="view",this.editor.options.mode!=="tree"&&this.editor.options.mode!=="form"||typeof this.editor.options.onEditable!="function"||(b=this.getValue.bind(this),typeof(S=this.editor.options.onEditable({field:this.field,get value(){return b()},path:this.getPath()}))=="boolean"?(this.editable.field=S,this.editable.value=S):s(S)==="object"&&S!==null?(typeof S.field=="boolean"&&(this.editable.field=S.field),typeof S.value=="boolean"&&(this.editable.value=S.value)):(console.error("Invalid return value for function onEditable.","Actual value:",S,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)))}},{key:"getPath",value:function(){for(var b=this,S=[];b;){var R=b.getName();R!==void 0&&S.unshift(R),b=b.parent}return S}},{key:"getInternalPath",value:function(){for(var b=this,S=[];b;)b.parent&&S.unshift(b.getIndex()),b=b.parent;return S}},{key:"getName",value:function(){return this.parent?this.parent.type!=="array"?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(b){if(b){if(b.length===0)return this;if(b.length&&this.childs&&this.childs.length){for(var S=0;S<this.childs.length;++S)if(""+b[0]==""+this.childs[S].getName())return this.childs[S].findNodeByPath(b.slice(1))}}}},{key:"findNodeByInternalPath",value:function(b){if(b){for(var O=this,S=0;S<b.length&&O;S++)var R=b[S],O=O.childs[R];return O}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(b){for(var S=(0,I.parsePath)(b),R=this;R&&0<S.length;)(function(){var O=S.shift();if(typeof O=="number"){if(R.type!=="array")throw new Error("Cannot get child node at index "+O+": node is no array");R=R.childs[O]}else{if(R.type!=="object")throw new Error("Cannot get child node "+O+": node is no object");R=R.childs.filter(function(J){return J.field===O})[0]}})();return R}},{key:"findParents",value:function(){for(var b=[],S=this.parent;S;)b.unshift(S),S=S.parent;return b}},{key:"setError",value:function(b,S){this.error=b,this.errorChild=S,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var b=this,S=this.fieldError||this.valueError||this.error,R=this.dom.tdError;if(S&&this.dom&&this.dom.tr){(0,I.addClassName)(this.dom.tr,"jsoneditor-validation-error"),R||(R=document.createElement("td"),this.dom.tdError=R,this.dom.tdValue.parentNode.appendChild(R));var O=document.createElement("button"),J=(O.type="button",O.className="jsoneditor-button jsoneditor-schema-error",function(){b.dom.popupAnchor&&b.dom.popupAnchor.destroy()}),re=function(){delete b.dom.popupAnchor},pe=function(Ie){var xe=b.editor.frame,Ie=(b.dom.popupAnchor=(0,T.w)(O,b.editor.getPopupAnchor(),re,Ie),O.getBoundingClientRect()),xe=120<xe.getBoundingClientRect().width-Ie.x?"jsoneditor-above":"jsoneditor-left",Ie=document.createElement("div");Ie.className="jsoneditor-popover "+xe,Ie.appendChild(document.createTextNode(S.message)),b.dom.popupAnchor.appendChild(Ie)},me=(O.onmouseover=function(){b.dom.popupAnchor||pe(!0)},O.onfocus=function(){J(),pe(!1)},O.onblur=function(){J()},this.errorChild);for(me&&(O.onclick=function(){me.findParents().forEach(function(ye){ye.expand(!1)}),me.scrollTo(function(){me.focus()})});R.firstChild;)R.removeChild(R.firstChild);R.appendChild(O)}else this.dom.tr&&(0,I.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),R&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){var b;return this.parent?(b=this.parent.childs.indexOf(this))!==-1?b:null:-1}},{key:"setParent",value:function(b){this.parent=b}},{key:"setField",value:function(b,S){this.field=b,this.previousField=b,this.fieldEditable=S===!0}},{key:"getField",value:function(){return this.field===void 0&&this._getDomField(),this.field}},{key:"setValue",value:function(b,S){var R,O,J,re,pe,me,ye=this.childs;if(this.type=this._getType(b),S&&S!==this.type){if(S!=="string"||this.type!=="auto")throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+S+'"');this.type=S}if(this.type==="array"){for(this.childs||(this.childs=[]),R=0;R<b.length;R++)(pe=b[R])===void 0||pe instanceof Function||(R<this.childs.length?((J=this.childs[R]).fieldEditable=!1,J.index=R,J.setValue(pe)):(J=new E(this.editor,{value:pe}),re=R<this.getMaxVisibleChilds(),this.appendChild(J,re,!1)));for(O=this.childs.length;O>=b.length;O--)this.removeChild(this.childs[O],!1)}else if(this.type==="object"){for(this.childs||(this.childs=[]),O=this.childs.length-1;0<=O;O--)p(b,this.childs[O].field)||this.removeChild(this.childs[O],!1);for(var xe in R=0,b)p(b,xe)&&((pe=b[xe])===void 0||pe instanceof Function||((me=this.findChildByProperty(xe))?(me.setField(xe,!0),me.setValue(pe)):(me=new E(this.editor,{field:xe,value:pe}),xe=R<this.getMaxVisibleChilds(),this.appendChild(me,xe,!1))),R++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=b;Array.isArray(ye)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(b){var S,R,O,J,re,pe=this.childs;if(this.type=b.type,b.type==="array"){for(this.childs||(this.childs=[]),J=0;J<b.childs.length;J++)(S=b.childs[J])===void 0||S instanceof Function||(J<this.childs.length?((R=this.childs[J]).fieldEditable=!1,R.index=J,R.setInternalValue(S)):(R=new E(this.editor,{internalValue:S}),O=J<this.getMaxVisibleChilds(),this.appendChild(R,O,!1)));for(re=this.childs.length;re>=b.childs.length;re--)this.removeChild(this.childs[re],!1)}else if(b.type==="object"){for(this.childs||(this.childs=[]),J=0;J<b.childs.length;J++)(S=b.childs[J])===void 0||S instanceof Function||(J<this.childs.length?(delete(R=this.childs[J]).index,R.setField(S.field,!0),R.setInternalValue(S.value)):(R=new E(this.editor,{field:S.field,internalValue:S.value}),O=J<this.getMaxVisibleChilds(),this.appendChild(R,O,!1)));for(re=this.childs.length;re>=b.childs.length;re--)this.removeChild(this.childs[re],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=b.value;Array.isArray(pe)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){var b;this.dom&&this.dom.tr&&this.dom.tr.parentNode?(b=this._detachFromDom(),this.clearDom(),this._attachToDom(b)):this.clearDom()}},{key:"getValue",value:function(){var b,S;return this.type==="array"?(b=[],this.childs.forEach(function(R){b.push(R.getValue())}),b):this.type==="object"?(S={},this.childs.forEach(function(R){S[R.getField()]=R.getValue()}),S):(this.value===void 0&&this._getDomValue(),this.value)}},{key:"getInternalValue",value:function(){return this.type==="array"?{type:this.type,childs:this.childs.map(function(b){return b.getInternalValue()})}:this.type==="object"?{type:this.type,childs:this.childs.map(function(b){return{field:b.getField(),value:b.getInternalValue()}})}:(this.value===void 0&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var b=this.parent?this.parent.getNodePath():[];return b.push(this),b}},{key:"clone",value:function(){var b,S;return(b=new E(this.editor)).type=this.type,b.field=this.field,b.fieldInnerText=this.fieldInnerText,b.fieldEditable=this.fieldEditable,b.previousField=this.previousField,b.value=this.value,b.valueInnerText=this.valueInnerText,b.previousValue=this.previousValue,b.expanded=this.expanded,b.visibleChilds=this.visibleChilds,this.childs?(S=[],this.childs.forEach(function(R){R=R.clone(),R.setParent(b),S.push(R)}),b.childs=S):b.childs=void 0,b}},{key:"expand",value:function(b){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),b!==!1&&this.childs.forEach(function(S){S.expand(b)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(b){this.childs&&(this.hideChilds(),b!==!1&&this.childs.forEach(function(S){S.collapse(b)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){var b=this.childs;if(b&&this.expanded){var b=this.dom.tr,S=b?b.parentNode:void 0;if(S){for(var R=this.getAppendDom(),O=(R.parentNode||((J=b.nextSibling)?S.insertBefore(R,J):S.appendChild(R)),Math.min(this.childs.length,this.visibleChilds)),J=this._getNextTr(),re=0;re<O;re++){var pe=this.childs[re];pe.getDom().parentNode||S.insertBefore(pe.getDom(),J),pe.showChilds()}b=this.getShowMoreDom(),J=this._getNextTr(),b.parentNode||S.insertBefore(b,J),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(b){var S=this.dom.tr,R=S?S.parentNode:void 0;R&&R.removeChild(S),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(b)}},{key:"hideChilds",value:function(b){var S;this.childs&&this.expanded&&((S=this.getAppendDom()).parentNode&&S.parentNode.removeChild(S),this.childs.forEach(function(R){R.hide()}),(S=this.getShowMoreDom()).parentNode&&S.parentNode.removeChild(S),b&&!b.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds()))}},{key:"_updateCssClassName",value:function(){var b,S;this.dom.field&&this.editor&&this.editor.options&&typeof this.editor.options.onClassName=="function"&&this.dom.tree&&((0,I.removeAllClassNames)(this.dom.tree),b=this.getValue.bind(this),S=this.editor.options.onClassName({path:this.getPath(),field:this.field,get value(){return b()}})||"",(0,I.addClassName)(this.dom.tree,"jsoneditor-values "+S))}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var b=0;b<this.childs.length;b++)this.childs[b].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var b=this.parent;b;)b.expanded||b.expand(),b=b.parent}},{key:"appendChild",value:function(b,S,R){var O,J;this._hasChilds()&&(b.setParent(this),b.fieldEditable=this.type==="object",this.type==="array"&&(b.index=this.childs.length),this.type==="object"&&b.field===void 0&&b.setField(""),this.childs.push(b),this.expanded&&S!==!1&&(S=b.getDom(),J=(O=this._getNextTr())?O.parentNode:void 0,O&&J&&J.insertBefore(S,O),b.showChilds(),this.visibleChilds++),R!==!1)&&(this.updateDom({updateIndexes:!0}),b.updateDom({recurse:!0}))}},{key:"moveBefore",value:function(b,S,R){var O,J,re;this._hasChilds()&&((O=this.dom.tr?this.dom.tr.parentNode:void 0)&&((J=document.createElement("tr")).style.height=O.clientHeight+"px",O.appendChild(J)),b.parent&&b.parent.removeChild(b),S instanceof w||!S?this.childs.length+1>this.visibleChilds?(re=this.childs[this.visibleChilds-1],this.insertBefore(b,re,R)):this.appendChild(b,!0,R):this.insertBefore(b,S,R),O)&&J&&O.removeChild(J)}},{key:"insertBefore",value:function(b,S,R){if(this._hasChilds()){if(this.visibleChilds++,this.type==="object"&&b.field===void 0&&b.setField(""),S===this.append)b.setParent(this),b.fieldEditable=this.type==="object",this.childs.push(b);else{var O=this.childs.indexOf(S);if(O===-1)throw new Error("Node not found");b.setParent(this),b.fieldEditable=this.type==="object",this.childs.splice(O,0,b)}var J;this.expanded&&(O=b.getDom(),J=(S=S.getDom())?S.parentNode:void 0,S&&J&&J.insertBefore(O,S),b.showChilds(),this.showChilds()),R!==!1&&(this.updateDom({updateIndexes:!0}),b.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(b,S){this._hasChilds()&&(S=this.childs.indexOf(S),(S=this.childs[S+1])?this.insertBefore(b,S):this.appendChild(b))}},{key:"search",value:function(b,S){Array.isArray(S)||(S=[]);var R=b?b.toLowerCase():void 0;return delete this.searchField,delete this.searchValue,this.field!==void 0&&S.length<=this.MAX_SEARCH_RESULTS&&(String(this.field).toLowerCase().indexOf(R)!==-1&&(this.searchField=!0,S.push({node:this,elem:"field"})),this._updateDomField()),this._hasChilds()?this.childs&&this.childs.forEach(function(O){O.search(b,S)}):this.value!==void 0&&S.length<=this.MAX_SEARCH_RESULTS&&(String(this.value).toLowerCase().indexOf(R)!==-1&&(this.searchValue=!0,S.push({node:this,elem:"value"})),this._updateDomValue()),S}},{key:"scrollTo",value:function(b){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,b)}},{key:"expandPathToNode",value:function(){for(var b=this;b&&b.parent;){for(var S=b.parent.type==="array"?b.index:b.parent.childs.indexOf(b);b.parent.visibleChilds<S+1;)b.parent.visibleChilds+=this.getMaxVisibleChilds();b.parent.expand(!1),b=b.parent}}},{key:"focus",value:function(b){if(E.focusElement=b,this.dom.tr&&this.dom.tr.parentNode){var S=this.dom;switch(b){case"drag":(S.drag||S.menu).focus();break;case"menu":S.menu.focus();break;case"expand":this._hasChilds()?S.expand.focus():S.field&&this.fieldEditable?(S.field.focus(),(0,I.selectContentEditable)(S.field)):S.value&&!this._hasChilds()?(S.value.focus(),(0,I.selectContentEditable)(S.value)):S.menu.focus();break;case"field":S.field&&this.fieldEditable?(S.field.focus(),(0,I.selectContentEditable)(S.field)):S.value&&!this._hasChilds()?(S.value.focus(),(0,I.selectContentEditable)(S.value)):(this._hasChilds()?S.expand:S.menu).focus();break;default:S.select?S.select.focus():S.value&&!this._hasChilds()?(S.value.focus(),(0,I.selectContentEditable)(S.value)):S.field&&this.fieldEditable?(S.field.focus(),(0,I.selectContentEditable)(S.field)):(this._hasChilds()?S.expand:S.menu).focus()}}}},{key:"containsNode",value:function(b){if(this===b)return!0;var S=this.childs;if(S){for(var R=0,O=S.length;R<O;R++)if(S[R].containsNode(b))return!0}return!1}},{key:"removeChild",value:function(b,S){if(this.childs){var R=this.childs.indexOf(b);if(R!==-1)return R<this.visibleChilds&&this.expanded&&this.visibleChilds--,b.hide(),delete b.searchField,delete b.searchValue,(b=this.childs.splice(R,1)[0]).parent=null,S!==!1&&this.updateDom({updateIndexes:!0}),b}}},{key:"_remove",value:function(b){this.removeChild(b)}},{key:"changeType",value:function(b){var S,R=this.type;R!==b&&(b!=="string"&&b!=="auto"||R!=="string"&&R!=="auto"?(S=this._detachFromDom(),this.clearDom(),(this.type=b)==="object"?(this.childs||(this.childs=[]),this.childs.forEach(function(O){O.clearDom(),delete O.index,O.fieldEditable=!0,O.field===void 0&&(O.field="")}),R!=="string"&&R!=="auto"||(this.expanded=!0)):b==="array"?(this.childs||(this.childs=[]),this.childs.forEach(function(O,J){O.clearDom(),O.fieldEditable=!1,O.index=J}),R!=="string"&&R!=="auto"||(this.expanded=!0)):this.expanded=!1,this._attachToDom(S)):this.type=b,b!=="auto"&&b!=="string"||(this.value=b==="string"?String(this.value):(0,I.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0}))}},{key:"deepEqual",value:function(b){var S;if(this.type==="array"){if(!Array.isArray(b)||this.childs.length!==b.length)return!1;for(S=0;S<this.childs.length;S++)if(!this.childs[S].deepEqual(b[S]))return!1}else if(this.type==="object"){if(s(b)!=="object"||!b)return!1;var R=Object.keys(b);if(this.childs.length!==R.length)return!1;for(S=0;S<R.length;S++){var O=this.childs[S];if(O.field!==R[S]||!O.deepEqual(b[O.field]))return!1}}else if(this.value!==b)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&this.type!=="array"&&this.type!=="object"&&(this.valueInnerText=(0,I.getInnerText)(this.dom.value),this.valueInnerText==="")&&this.dom.value.innerHTML!==""&&(this.dom.value.textContent=""),this.valueInnerText!==void 0)try{var b,S;(S=this.type==="string"?this._unescapeHTML(this.valueInnerText):(b=this._unescapeHTML(this.valueInnerText),(0,I.parseString)(b)))!==this.value&&(this.value=S,this._debouncedOnChangeValue())}catch{this._setValueError((0,G.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(b){this.valueError={message:b},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(b){this.fieldError={message:b},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var b,S=this.editor.getDomSelection(),R=(S.range&&(R=(0,I.textDiff)(String(this.value),String(this.previousValue)),S.range.startOffset=R.start,S.range.endOffset=R.end),this.editor.getDomSelection());R.range&&(b=(0,I.textDiff)(String(this.previousValue),String(this.value)),R.range.startOffset=b.start,R.range.endOffset=b.end),this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:S,newSelection:R}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var b=this.editor.getDomSelection(),S=this.previousField||"",R=(b.range&&(R=(0,I.textDiff)(this.field,S),b.range.startOffset=R.start,b.range.endOffset=R.end),this.editor.getDomSelection());R.range&&(S=(0,I.textDiff)(S,this.field),R.range.startOffset=S.start,R.range.endOffset=S.end),this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:b,newSelection:R}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var b=this.dom.value;if(b){var S=["jsoneditor-value"],R=this.value,O=this.type==="auto"?(0,I.getType)(R):this.type,J=O==="string"&&(0,I.isUrl)(R);if(S.push("jsoneditor-"+O),J&&S.push("jsoneditor-url"),String(this.value)===""&&this.type!=="array"&&this.type!=="object"&&S.push("jsoneditor-empty"),this.searchValueActive&&S.push("jsoneditor-highlight-active"),this.searchValue&&S.push("jsoneditor-highlight"),b.className=S.join(" "),O==="array"||O==="object"?(S=this.childs?this.childs.length:0,b.title=this.type+" containing "+S+" items"):J&&this.editable.value?b.title=(0,G.Iu)("openUrl"):b.title="",O==="boolean"&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value?(this.dom.select||(this.dom.select=document.createElement("select"),this.id=this.field+"_"+new Date().getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,(S=document.createElement("option")).value="",S.textContent="--",this.dom.select.appendChild(S),this._updateEnumOptions(),this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)),this.dom.select.value=this.enum.indexOf(this.value)!==-1?this.value:"",!this.schema||p(this.schema,"oneOf")||p(this.schema,"anyOf")||p(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")):this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML,this.dom.tdValue.appendChild(this.dom.value)),this.editor.options.colorPicker&&typeof R=="string"&&(0,I.isValidColor)(R)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,I.addClassName)(this.dom.value,"jsoneditor-color-value"),(this.editable.value?I.removeClassName:I.addClassName)(this.dom.color,"jsoneditor-color-readonly"),this.dom.color.style.backgroundColor=R):this._deleteDomColor(),this._showTimestampTag()){if(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),J=null,J=typeof this.editor.options.timestampFormat=="function"?this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()}):J){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(J))}else this.dom.date.textContent=new Date(R).toISOString();this.dom.date.title=new Date(R).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,I.stripFormatting)(b),this._updateDomDefault()}}},{key:"_updateEnumOptions",value:function(){if(this.enum&&this.dom.select){this.dom.select.innerHTML="";for(var b=0;b<this.enum.length;b++){var S=document.createElement("option");S.value=this.enum[b],S.textContent=this.enum[b],this.dom.select.appendChild(S)}}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,(0,I.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var b,S=this.dom.field;S&&((b=(0,I.makeFieldTooltip)(this.schema,this.editor.options.language))&&(S.title=b),(String(this.field)===""&&this.parent&&this.parent.type!=="array"?I.addClassName:I.removeClassName)(S,"jsoneditor-empty"),(this.searchFieldActive?I.addClassName:I.removeClassName)(S,"jsoneditor-highlight-active"),(this.searchField?I.addClassName:I.removeClassName)(S,"jsoneditor-highlight"),(0,I.stripFormatting)(S))}},{key:"_getDomField",value:function(b){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,I.getInnerText)(this.dom.field),this.fieldInnerText==="")&&this.dom.field.innerHTML!==""&&(this.dom.field.textContent=""),this.fieldInnerText!==void 0)try{var S=this._unescapeHTML(this.fieldInnerText),R=this.parent.getFieldNames(this);R.indexOf(S)!==-1?b?(S=(0,I.findUniqueName)(S,R))!==this.field&&(this.field=S,this._debouncedOnChangeField()):this._setFieldError((0,G.Iu)("duplicateFieldError")):S!==this.field&&(this.field=S,this._debouncedOnChangeField())}catch{this._setFieldError((0,G.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){var b;this.schema&&this.schema.default!==void 0&&!this._hasChilds()&&(b=this.dom.select||this.dom.value)&&(this.value===this.schema.default?(b.title=(0,G.Iu)("default"),(0,I.addClassName)(b,"jsoneditor-is-default"),I.removeClassName):(b.removeAttribute("title"),(0,I.removeClassName)(b,"jsoneditor-is-default"),I.addClassName))(b,"jsoneditor-is-not-default")}},{key:"_showTimestampTag",value:function(){var b,S;return typeof this.value=="number"&&(typeof(b=this.editor.options.timestampTag)=="function"?typeof(S=b({field:this.field,value:this.value,path:this.getPath()}))=="boolean"?S:(0,I.isTimestamp)(this.field,this.value):b===!0&&(0,I.isTimestamp)(this.field,this.value))}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var b,S,R=this.dom;return R.tr||(this._updateEditability(),R.tr=document.createElement("tr"),(R.tr.node=this).editor.options.mode==="tree"&&(S=document.createElement("td"),this.editable.field&&this.parent&&((b=document.createElement("button")).type="button",(R.drag=b).className="jsoneditor-button jsoneditor-dragarea",b.title=(0,G.Iu)("drag"),S.appendChild(b)),R.tr.appendChild(S),b=document.createElement("td"),(S=document.createElement("button")).type="button",(R.menu=S).className="jsoneditor-button jsoneditor-contextmenu-button",S.title=(0,G.Iu)("actionsMenu"),b.appendChild(R.menu),R.tr.appendChild(b)),S=document.createElement("td"),R.tr.appendChild(S),R.tree=this._createDomTree(),S.appendChild(R.tree),this.updateDom({updateIndexes:!0})),R.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(b){for(var S=this.parent;S;){if(S===b)return!0;S=S.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(b){this.dom.tr&&((b?I.addClassName:I.removeClassName)(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(b),this.childs)&&this.childs.forEach(function(S){S.setHighlight(b)})}},{key:"setSelected",value:function(b,S){this.selected=b,this.dom.tr&&((b?I.addClassName:I.removeClassName)(this.dom.tr,"jsoneditor-selected"),(S?I.addClassName:I.removeClassName)(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(b),this.showMore&&this.showMore.setSelected(b),this.childs)&&this.childs.forEach(function(R){R.setSelected(b)})}},{key:"updateValue",value:function(b){this.value=b,this.previousValue=b,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(b){this.field=b,this.previousField=b,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(b){var S,R=this.dom.tree,R=(R&&(R.style.marginLeft=24*this.getLevel()+"px"),this.dom.field),R=(R&&(this.fieldEditable?(R.contentEditable=this.editable.field,R.spellcheck=!1,R.className="jsoneditor-field"):(R.contentEditable=!1,R.className="jsoneditor-readonly"),S=this.index!==void 0?this.index:this.field!==void 0?this.field:(S=this.editor.options.schema?E._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&S.title?S.title:this._hasChilds()?this.type:"",S=this._escapeHTML(S),document.activeElement!==R&&S!==this._unescapeHTML((0,I.getInnerText)(R))&&(R.innerHTML=S),this._updateSchema(),this._updateEnumOptions()),this.dom.value),R=(R&&(this.type==="array"||this.type==="object"?this.updateNodeName():(S=this._escapeHTML(this.value),document.activeElement!==R&&S!==this._unescapeHTML((0,I.getInnerText)(R))&&(R.innerHTML=S))),this.dom.tr);R&&(this.type==="array"||this.type==="object"?((0,I.addClassName)(R,"jsoneditor-expandable"),this.expanded?((0,I.addClassName)(R,"jsoneditor-expanded"),(0,I.removeClassName)(R,"jsoneditor-collapsed")):((0,I.addClassName)(R,"jsoneditor-collapsed"),(0,I.removeClassName)(R,"jsoneditor-expanded"))):((0,I.removeClassName)(R,"jsoneditor-expandable"),(0,I.removeClassName)(R,"jsoneditor-expanded"),(0,I.removeClassName)(R,"jsoneditor-collapsed"))),this._updateDomField(),this._updateDomValue(),b&&b.updateIndexes===!0&&this._updateDomIndexes(),b&&b.recurse===!0&&this.childs&&this.childs.forEach(function(O){O.updateDom(b)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom(),this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?E._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=E._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var b=this.dom.value,S=this.childs;b&&S&&(this.type==="array"?S.forEach(function(R,O){R.index=O,R=R.dom.field,R&&(R.textContent=O)}):this.type==="object"&&S.forEach(function(R){R.index!==void 0&&(delete R.index,R.field===void 0)&&(R.field="")}))}},{key:"_createDomValue",value:function(){var b;return this.type==="array"?(b=document.createElement("div")).textContent="[...]":this.type==="object"?(b=document.createElement("div")).textContent="{...}":(!this.editable.value&&(0,I.isUrl)(this.value)?(b=document.createElement("a")).href=this.value:((b=document.createElement("div")).contentEditable=this.editable.value,b.spellcheck=!1),b.innerHTML=this._escapeHTML(this.value)),b}},{key:"_createDomExpandButton",value:function(){var b=document.createElement("button");return b.type="button",this._hasChilds()?(b.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",b.title=(0,G.Iu)("expandTitle")):(b.className="jsoneditor-button jsoneditor-invisible",b.title=""),b}},{key:"_createDomTree",value:function(){var b=this.dom,S=document.createElement("table"),O=document.createElement("tbody"),R=(S.style.borderCollapse="collapse",S.className="jsoneditor-values",S.appendChild(O),document.createElement("tr")),O=(O.appendChild(R),document.createElement("td")),O=(O.className="jsoneditor-tree",R.appendChild(O),b.expand=this._createDomExpandButton(),O.appendChild(b.expand),b.tdExpand=O,document.createElement("td")),O=(O.className="jsoneditor-tree",R.appendChild(O),b.field=this._createDomField(),O.appendChild(b.field),b.tdField=O,document.createElement("td")),O=(O.className="jsoneditor-tree",R.appendChild(O),this.type!=="object"&&this.type!=="array"&&(O.appendChild(document.createTextNode(":")),O.className="jsoneditor-separator"),b.tdSeparator=O,document.createElement("td"));return O.className="jsoneditor-tree",R.appendChild(O),b.value=this._createDomValue(),O.appendChild(b.value),b.tdValue=O,S}},{key:"onEvent",value:function(b){var S,R=b.type,O=b.target||b.srcElement,J=this.dom,re=this,pe=this._hasChilds(),me=(O!==J.drag&&O!==J.menu||(R==="mouseover"?this.editor.highlighter.highlight(this):R==="mouseout"&&this.editor.highlighter.unhighlight()),R==="click"&&O===J.menu&&((S=re.editor.highlighter).highlight(re),S.lock(),(0,I.addClassName)(J.menu,"jsoneditor-selected"),this.showContextMenu(J.menu,function(){(0,I.removeClassName)(J.menu,"jsoneditor-selected"),S.unlock(),S.unhighlight()})),R==="click"&&O===J.expand&&pe&&(we=b.ctrlKey,this._onExpand(we)),R!=="click"||b.target!==re.dom.tdColor&&b.target!==re.dom.color||!this.editable.value||this._showColorPicker(),R==="change"&&O===J.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault()),R==="change"&&O===J.select&&(this.dom.value.innerHTML=this._escapeHTML(J.select.value),this._getDomValue(),this._updateDomValue()),J.value);if(O===me)switch(R){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var ye=this._escapeHTML(this.value);ye!==this._unescapeHTML((0,I.getInnerText)(me))&&(me.innerHTML=ye);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":b.ctrlKey&&this.editable.value&&(0,I.isUrl)(this.value)&&(b.preventDefault(),window.open(this.value,"_blank","noreferrer"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){re._getDomValue(),re._updateDomValue()},1)}var xe=J.field;if(O===xe)switch(R){case"blur":this._getDomField(!0),this._updateDomField();var Ie=this._escapeHTML(this.field);Ie!==this._unescapeHTML((0,I.getInnerText)(xe))&&(xe.innerHTML=Ie);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){re._getDomField(),re._updateDomField()},1)}var we=J.tree;we&&O===we.parentNode&&R==="click"&&!b.hasMoved&&((b.offsetX!==void 0?b.offsetX<24*(this.getLevel()+1):b.pageX<(0,I.getAbsoluteLeft)(J.tdSeparator))||pe?xe&&((0,I.setEndOfContentEditable)(xe),xe.focus()):me&&!this.enum&&((0,I.setEndOfContentEditable)(me),me.focus())),(O!==J.tdExpand||pe)&&O!==J.tdField&&O!==J.tdSeparator||R!=="click"||b.hasMoved||xe&&((0,I.setEndOfContentEditable)(xe),xe.focus()),R==="keydown"&&this.onKeyDown(b),typeof this.editor.options.onEvent=="function"&&this._onEvent(b)}},{key:"_onEvent",value:function(b){var R=b.target,S=R===this.dom.field,R=R===this.dom.value||R===this.dom.checkbox||R===this.dom.select;(S||R)&&(S={field:this.getField(),path:this.getPath()},R&&!this._hasChilds()&&(S.value=this.getValue()),this.editor.options.onEvent(S,b))}},{key:"onKeyDown",value:function(b){var S,R,O,J,re,pe,me,ye,xe,Ie,we,Ae,_e,We,ke=b.which||b.keyCode,le=b.target||b.srcElement,fe=b.ctrlKey,be=b.shiftKey,ve=b.altKey,ne=!1,ie=this.editor.options.mode==="tree",ge=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],Se=ge[0],Le=ge[ge.length-1];ke===13?le===this.dom.value?this.editable.value&&!b.ctrlKey||(0,I.isUrl)(this.value)&&(window.open(this.value,"_blank","noreferrer"),ne=!0):le===this.dom.expand&&this._hasChilds()&&(_e=b.ctrlKey,this._onExpand(_e),le.focus(),ne=!0):ke===68?fe&&ie&&(E.onDuplicate(ge),ne=!0):ke===69?fe&&(this._onExpand(be),le.focus(),ne=!0):ke===77&&ie?fe&&(this.showContextMenu(le),ne=!0):ke===46&&ie?fe&&(E.onRemove(ge),ne=!0):ke===45&&ie?fe&&!be?(this._onInsertBefore(),ne=!0):fe&&be&&(this._onInsertAfter(),ne=!0):ke===35?ve&&((_e=this._lastNode())&&_e.focus(E.focusElement||this._getElementName(le)),ne=!0):ke===36?ve&&((_e=this._firstNode())&&_e.focus(E.focusElement||this._getElementName(le)),ne=!0):ke===37?ve&&!be?((_e=this._previousElement(le))&&this.focus(this._getElementName(_e)),ne=!0):ve&&be&&ie&&(_e=Le.expanded?(_e=Le.getAppendDom())?_e.nextSibling:void 0:Le.getDom().nextSibling)&&(we=E.getNodeFromTarget(_e),_e=_e.nextSibling,Ae=E.getNodeFromTarget(_e),we)&&we instanceof w&&Le.parent.childs.length!==1&&Ae&&Ae.parent&&(R=this.editor.getDomSelection(),O=(J=Se.parent).childs[Le.getIndex()+1]||J.append,re=Se.getIndex(),pe=Ae.getIndex(),me=J.getInternalPath(),ye=Ae.parent.getInternalPath(),ge.forEach(function(Be){Ae.parent.moveBefore(Be,Ae)}),this.focus(E.focusElement||this._getElementName(le)),this.editor._onAction("moveNodes",{count:ge.length,fieldNames:ge.map(C),oldParentPath:J.getInternalPath(),newParentPath:Se.parent.getInternalPath(),oldIndex:O.getIndex(),newIndex:Se.getIndex(),oldIndexRedo:re,newIndexRedo:pe,oldParentPathRedo:me,newParentPathRedo:ye,oldSelection:R,newSelection:this.editor.getDomSelection()})):ke===38?ve&&!be?((S=this._previousNode())&&(this.editor.deselect(!0),S.focus(E.focusElement||this._getElementName(le))),ne=!0):!ve&&fe&&be&&ie?((S=this._previousNode())&&((Ie=this.editor.multiselection).start=Ie.start||this,Ie.end=S,xe=this.editor._findTopLevelNodes(Ie.start,Ie.end),this.editor.select(xe),S.focus("field")),ne=!0):ve&&be&&ie&&((S=Se._previousNode())&&S.parent&&(R=this.editor.getDomSelection(),O=(J=Se.parent).childs[Le.getIndex()+1]||J.append,re=Se.getIndex(),pe=S.getIndex(),me=J.getInternalPath(),ye=S.parent.getInternalPath(),ge.forEach(function(Be){S.parent.moveBefore(Be,S)}),this.focus(E.focusElement||this._getElementName(le)),this.editor._onAction("moveNodes",{count:ge.length,fieldNames:ge.map(C),oldParentPath:J.getInternalPath(),newParentPath:Se.parent.getInternalPath(),oldIndex:O.getIndex(),newIndex:Se.getIndex(),oldIndexRedo:re,newIndexRedo:pe,oldParentPathRedo:me,newParentPathRedo:ye,oldSelection:R,newSelection:this.editor.getDomSelection()})),ne=!0):ke===39?ve&&!be?((_e=this._nextElement(le))&&this.focus(this._getElementName(_e)),ne=!0):ve&&be&&ie&&(_e=Se.getDom().previousSibling)&&(S=E.getNodeFromTarget(_e))&&S.parent&&!S.isVisible()&&(R=this.editor.getDomSelection(),O=(J=Se.parent).childs[Le.getIndex()+1]||J.append,re=Se.getIndex(),pe=S.getIndex(),me=J.getInternalPath(),ye=S.parent.getInternalPath(),ge.forEach(function(Be){S.parent.moveBefore(Be,S)}),this.focus(E.focusElement||this._getElementName(le)),this.editor._onAction("moveNodes",{count:ge.length,fieldNames:ge.map(C),oldParentPath:J.getInternalPath(),newParentPath:Se.parent.getInternalPath(),oldIndex:O.getIndex(),newIndex:Se.getIndex(),oldIndexRedo:re,newIndexRedo:pe,oldParentPathRedo:me,newParentPathRedo:ye,oldSelection:R,newSelection:this.editor.getDomSelection()})):ke===40&&(ve&&!be?((we=this._nextNode())&&(this.editor.deselect(!0),we.focus(E.focusElement||this._getElementName(le))),ne=!0):!ve&&fe&&be&&ie?((we=this._nextNode())&&((Ie=this.editor.multiselection).start=Ie.start||this,Ie.end=we,xe=this.editor._findTopLevelNodes(Ie.start,Ie.end),this.editor.select(xe),we.focus("field")),ne=!0):ve&&be&&ie&&((We=(we=(we=(we=Le.expanded?Le.append?Le.append._nextNode():void 0:Le._nextNode())&&!we.isVisible()?we.parent.showMore:we)&&we instanceof w?Le:we)&&(we._nextNode()||we.parent.append))&&We.parent&&(R=this.editor.getDomSelection(),O=(J=Se.parent).childs[Le.getIndex()+1]||J.append,re=Se.getIndex(),pe=We.getIndex(),me=J.getInternalPath(),ye=We.parent.getInternalPath(),ge.forEach(function(Be){We.parent.moveBefore(Be,We)}),this.focus(E.focusElement||this._getElementName(le)),this.editor._onAction("moveNodes",{count:ge.length,fieldNames:ge.map(C),oldParentPath:J.getInternalPath(),newParentPath:Se.parent.getInternalPath(),oldParentPathRedo:me,newParentPathRedo:ye,oldIndexRedo:re,newIndexRedo:pe,oldIndex:O.getIndex(),newIndex:Se.getIndex(),oldSelection:R,newSelection:this.editor.getDomSelection()})),ne=!0)),ne&&(b.preventDefault(),b.stopPropagation())}},{key:"_onExpand",value:function(b){var S,R,O;b&&(O=(R=(S=this.dom.tr.parentNode).parentNode).scrollTop,R.removeChild(S)),this.expanded?this.collapse(b):this.expand(b),b&&(R.appendChild(S),R.scrollTop=O),typeof this.editor.options.onExpand=="function"&&this.editor.options.onExpand({path:this.getPath(),isExpand:this.expanded,recursive:b})}},{key:"_showColorPicker",value:function(){var b,S;typeof this.editor.options.onColorPicker=="function"&&this.dom.color&&((b=this)._deleteDomColor(),b.updateDom(),S=(0,T.w)(this.dom.color,this.editor.getPopupAnchor()),this.editor.options.onColorPicker(S,this.value,function(R){typeof R=="string"&&R!==b.value&&(b._deleteDomColor(),b.value=R,b.updateDom(),b._debouncedOnChangeValue())}))}},{key:"getFieldNames",value:function(b){return this.type==="object"?this.childs.filter(function(S){return S!==b}).map(function(S){return S.field}):[]}},{key:"_onInsertBefore",value:function(J,re,pe){var O=this.editor.getDomSelection(),J=new E(this.editor,{field:J!==void 0?J:"",value:re!==void 0?re:"",type:pe}),re=(J.expand(!0),this.getInternalPath()),pe=(this.parent.insertBefore(J,this),this.editor.highlighter.unhighlight(),J.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertBeforeNodes",{nodes:[J],paths:[J.getInternalPath()],beforePath:re,parentPath:this.parent.getInternalPath(),oldSelection:O,newSelection:pe})}},{key:"_onInsertAfter",value:function(J,re,R){var O=this.editor.getDomSelection(),J=new E(this.editor,{field:J!==void 0?J:"",value:re!==void 0?re:"",type:R}),re=(J.expand(!0),this.parent.insertAfter(J,this),this.editor.highlighter.unhighlight(),J.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertAfterNodes",{nodes:[J],paths:[J.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:O,newSelection:re})}},{key:"_onAppend",value:function(J,re,R){var O=this.editor.getDomSelection(),J=new E(this.editor,{field:J!==void 0?J:"",value:re!==void 0?re:"",type:R}),re=(J.expand(!0),this.parent.appendChild(J),this.editor.highlighter.unhighlight(),J.focus("field"),this.editor.getDomSelection());this.editor._onAction("appendNodes",{nodes:[J],paths:[J.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:O,newSelection:re})}},{key:"_onChangeType",value:function(b){var S,R,O=this.type;b!==O&&(S=this.editor.getDomSelection(),this.changeType(b),R=this.editor.getDomSelection(),this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:O,newType:b,oldSelection:S,newSelection:R}))}},{key:"sort",value:function(b,S){var R,O,J=!(2<arguments.length&&arguments[2]!==void 0)||arguments[2];typeof b=="string"&&(b=(0,I.parsePath)(b)),this._hasChilds()&&(this.hideChilds(),R=this.childs,this.childs=this.childs.concat(),O=S==="desc"?-1:1,this.type==="object"?this.childs.sort(function(re,pe){return O*f()(re.field,pe.field)}):this.childs.sort(function(me,ye){var me=me.getNestedChild(b),ye=ye.getNestedChild(b);return me?ye?(me=me.value,ye=ye.value,typeof me!="string"&&typeof ye!="string"?ye<me?O:me<ye?-O:0:O*f()(me,ye)):-O:O}),this._updateDomIndexes(),this.showChilds(),J===!0)&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:R,newChilds:this.childs})}},{key:"update",value:function(b){var S=this.getInternalValue();this.setValue(b),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:S,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var b=this.dom.tr?this.dom.tr.parentNode:void 0,S=this.expanded?this.getAppendDom():this.getDom(),S=S&&S.parentNode?S.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:b,nextTr:S}}},{key:"_attachToDom",value:function(b){b.table&&(b.nextTr?b.table.insertBefore(this.getDom(),b.nextTr):b.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(b){if(this._hasChilds()){this.hideChilds();try{var S=this.getInternalValue(),R=this.getValue(),O=this.editor.options.executeQuery(R,b),J=(this.setValue(O),this.getInternalValue());this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:S,newValue:J}),this.showChilds()}catch(re){this.showChilds(),this.editor._onError(re)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var b=this.editor.node.getInternalValue(),S=(this.editor._setRoot(this),this.editor.node.getInternalValue());this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:b,newValue:S})}catch(R){this.editor._onError(R)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(b){for(var S=0,R=this;R&&S<b.length;)R=R.findChildByProperty(b[S]),S++;return R}},{key:"findChildByProperty",value:function(b){if(this.type==="object")return this.childs.find(function(S){return S.field===b})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new w(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new $(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var b=this.parent.childs.indexOf(this);return this.parent.childs[b+1]||this.parent.append}},{key:"_previousNode",value:function(){var b=null,S=this.getDom();if(S&&S.parentNode)for(var R=S;R=R.previousSibling,b=E.getNodeFromTarget(R),R&&b&&b instanceof w&&!b.isVisible(););return b}},{key:"_nextNode",value:function(){var b=null,S=this.getDom();if(S&&S.parentNode)for(var R=S;R=R.nextSibling,b=E.getNodeFromTarget(R),R&&b&&b instanceof w&&!b.isVisible(););return b}},{key:"_firstNode",value:function(){var b=null,S=this.getDom();return S&&S.parentNode&&(S=S.parentNode.firstChild,b=E.getNodeFromTarget(S)),b}},{key:"_lastNode",value:function(){var b=null,S=this.getDom();if(S&&S.parentNode)for(var R=S.parentNode.lastChild,b=E.getNodeFromTarget(R);R&&b&&!b.isVisible();)R=R.previousSibling,b=E.getNodeFromTarget(R);return b}},{key:"_previousElement",value:function(b){var S=this.dom;switch(b){case S.value:if(this.fieldEditable)return S.field;case S.field:if(this._hasChilds())return S.expand;case S.expand:return S.menu;case S.menu:if(S.drag)return S.drag;default:return null}}},{key:"_nextElement",value:function(b){var S=this.dom;switch(b){case S.drag:return S.menu;case S.menu:if(this._hasChilds())return S.expand;case S.expand:if(this.fieldEditable)return S.field;case S.field:if(!this._hasChilds())return S.value;default:return null}}},{key:"_getElementName",value:function(b){var S=this;return Object.keys(this.dom).find(function(R){return S.dom[R]===b})}},{key:"_hasChilds",value:function(){return this.type==="array"||this.type==="object"}},{key:"addTemplates",value:function(b,S){var R=this,O=R.editor.options.templates;O!=null&&(O.length&&b.push({type:"separator"}),O.forEach(function(J){b.push({text:J.text,className:J.className||"jsoneditor-type-object",title:J.title,click:(S?function(re,pe){R._onAppend(re,pe)}:function(re,pe){R._onInsertBefore(re,pe)}).bind(this,J.field,J.value)})}))}},{key:"showContextMenu",value:function(b,S){var R,O=this,J=[];this.editable.value&&J.push({text:(0,G.Iu)("type"),title:(0,G.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto"+(this.type==="auto"?" jsoneditor-selected":""),title:(0,G.Iu)("autoType"),click:function(){O._onChangeType("auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array"+(this.type==="array"?" jsoneditor-selected":""),title:(0,G.Iu)("arrayType"),click:function(){O._onChangeType("array")}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object"+(this.type==="object"?" jsoneditor-selected":""),title:(0,G.Iu)("objectType"),click:function(){O._onChangeType("object")}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string"+(this.type==="string"?" jsoneditor-selected":""),title:(0,G.Iu)("stringType"),click:function(){O._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&J.push({text:(0,G.Iu)("sort"),title:(0,G.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){O.showSortModal()}}),this.editor.options.enableTransform&&J.push({text:(0,G.Iu)("transform"),title:(0,G.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){O.showTransformModal()}}),this.parent)&&J.push({text:(0,G.Iu)("extract"),title:(0,G.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){O.extract()}}),this.parent&&this.parent._hasChilds()&&(J.length&&J.push({type:"separator"}),R=O.parent.childs,O===R[R.length-1]&&(R=[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,G.Iu)("autoType"),click:function(){O._onAppend("","","auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array",title:(0,G.Iu)("arrayType"),click:function(){O._onAppend("",[])}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object",title:(0,G.Iu)("objectType"),click:function(){O._onAppend("",{})}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string",title:(0,G.Iu)("stringType"),click:function(){O._onAppend("","","string")}}],O.addTemplates(R,!0),J.push({text:(0,G.Iu)("appendText"),title:(0,G.Iu)("appendTitle"),submenuTitle:(0,G.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){O._onAppend("","","auto")},submenu:R})),R=[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,G.Iu)("autoType"),click:function(){O._onInsertBefore("","","auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array",title:(0,G.Iu)("arrayType"),click:function(){O._onInsertBefore("",[])}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object",title:(0,G.Iu)("objectType"),click:function(){O._onInsertBefore("",{})}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string",title:(0,G.Iu)("stringType"),click:function(){O._onInsertBefore("","","string")}}],O.addTemplates(R,!1),J.push({text:(0,G.Iu)("insert"),title:(0,G.Iu)("insertTitle"),submenuTitle:(0,G.Iu)("insertSub"),className:"jsoneditor-insert",click:function(){O._onInsertBefore("","","auto")},submenu:R}),this.editable.field)&&(J.push({text:(0,G.Iu)("duplicateText"),title:(0,G.Iu)("duplicateField"),className:"jsoneditor-duplicate",click:function(){E.onDuplicate(O)}}),J.push({text:(0,G.Iu)("removeText"),title:(0,G.Iu)("removeField"),className:"jsoneditor-remove",click:function(){E.onRemove(O)}})),this.editor.options.onCreateMenu&&(R=O.getPath(),J=this.editor.options.onCreateMenu(J,{type:"single",path:R,paths:[R]})),new k.x(J,{close:S}).show(b,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var b=this,S=this.editor.options.modalAnchor||a.qD,R=this.getValue();(0,m.showSortModal)(S,R,function(O){var J=O.path,J=(0,I.parsePath)(J);b.sortedBy=O,b.sort(J,O.direction)},b.sortedBy)}},{key:"showTransformModal",value:function(){var b=this,J=this.editor.options,S=J.modalAnchor,R=J.createQuery,O=J.executeQuery,J=J.queryDescription,re=this.getValue();(0,h.showTransformModal)({container:S||a.qD,json:re,queryDescription:J,createQuery:R,executeQuery:O,onTransform:function(pe){b.transform(pe)}})}},{key:"_getType",value:function(b){return b instanceof Array?"array":b instanceof Object?"object":typeof b=="string"&&typeof(0,I.parseString)(b)!="string"?"string":"auto"}},{key:"_escapeHTML",value:function(b){return typeof b!="string"?String(b):(b=String(b).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),b=(b=JSON.stringify(b)).substring(1,b.length-1),this.editor.options.escapeUnicode===!0?(0,I.escapeUnicodeChars)(b):b)}},{key:"_unescapeHTML",value:function(b){return b='"'+this._escapeJSON(b)+'"',(0,I.parse)(b).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(b){for(var S="",R=0;R<b.length;){var O=b.charAt(R);O===`
`?S+="\\n":O==="\\"?(S+=O,R++,(O=b.charAt(R))!==""&&'"\\/bfnrtu'.indexOf(O)!==-1||(S+="\\"),S+=O):S+=O==='"'?'\\"':O,R++}return S}},{key:"updateNodeName",value:function(){var b=this.childs?this.childs.length:0;if(this.type==="object"||this.type==="array"){if(this.editor.options.onNodeName)try{var S=this.getValue.bind(this),R=this.editor.options.onNodeName({path:this.getPath(),size:b,type:this.type,get value(){return S()}})}catch(O){console.error("Error in onNodeName callback: ",O)}this.dom.value.textContent=this.type==="object"?"{"+(R||b)+"}":"["+(R||b)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&(this.updateNodeName(),this.childs!=="undefined"))for(var b in this.childs)this.childs[b].recursivelyUpdateNodeName()}}])&&o(H.prototype,V),Object.defineProperty(H,"prototype",{writable:!1}),E}(),c=(i.prototype.DEBOUNCE_INTERVAL=150,i.prototype.MAX_SEARCH_RESULTS=999,100);function d(E){return E.getInternalPath()}function C(E){return E.getField()}function p(E,H){return Object.prototype.hasOwnProperty.call(E,H)}i.focusElement=void 0,i.select=function(E){setTimeout(function(){(0,I.selectContentEditable)(E)},0)},i.onDragStart=function(E,H){if(!Array.isArray(E))return i.onDragStart([E],H);var V,b,S,R,O;E.length!==0&&(V=E[0],b=E[E.length-1],S=V.parent,O=i.getNodeFromTarget(H.target),R=V.editor,O=(0,I.getAbsoluteTop)(O.dom.tr)-(0,I.getAbsoluteTop)(V.dom.tr),R.mousemove||(R.mousemove=(0,I.addEventListener)(H.view,"mousemove",function(J){i.onDrag(E,J)})),R.mouseup||(R.mouseup=(0,I.addEventListener)(H.view,"mouseup",function(J){i.onDragEnd(E,J)})),R.highlighter.lock(),R.drag={oldCursor:document.body.style.cursor,oldSelection:R.getDomSelection(),oldPaths:E.map(d),oldParent:S,oldNextNode:S.childs[b.getIndex()+1]||S.append,oldParentPathRedo:S.getInternalPath(),oldIndexRedo:V.getIndex(),mouseX:H.pageX,offsetY:O,level:V.getLevel()},document.body.style.cursor="move",H.preventDefault())},i.onDrag=function(E,H){if(!Array.isArray(E))return i.onDrag([E],H);if(E.length!==0){var V,b,S,R,O,J=E[0].editor,re=H.pageY-J.drag.offsetY,pe=H.pageX,me=!1,ye=E[0],xe=ye.dom.tr,Ie=(0,I.getAbsoluteTop)(xe),we=xe.offsetHeight;if(re<Ie){for(ke=xe;ke=ke.previousSibling,le=i.getNodeFromTarget(ke),S=ke?(0,I.getAbsoluteTop)(ke):0,ke&&re<S;);(le=le&&!le.parent?void 0:le)||(ke=(xe=xe.parentNode.firstChild)?xe.nextSibling:void 0,(le=i.getNodeFromTarget(ke))===ye&&(le=void 0)),!(le=le&&le.isVisible()&&(S=(ke=le.dom.tr)?(0,I.getAbsoluteTop)(ke):0)+we<re?void 0:le)||J.options.limitDragging!==!1&&le.parent!==E[0].parent||(E.forEach(function(be){le.parent.moveBefore(be,le)}),me=!0)}else{var Ae=E[E.length-1];if(we=(xe=Ae.expanded&&Ae.append?Ae.append.getDom():Ae.dom.tr)?xe.nextSibling:void 0){for(R=(0,I.getAbsoluteTop)(we),V=we;b=i.getNodeFromTarget(V),V&&(O=V.nextSibling?(0,I.getAbsoluteTop)(V.nextSibling):0,O=V?O-R:0,b&&b.parent.childs.length===E.length&&b.parent.childs[E.length-1]===Ae&&(Ie+=27),V=V.nextSibling),V&&Ie+O<re;);if(b&&b.parent){for(var we=pe-J.drag.mouseX,we=Math.round(we/24/2),_e=J.drag.level+we,We=b.getLevel(),ke=b.dom.tr&&b.dom.tr.previousSibling;We<_e&&ke;){var le=i.getNodeFromTarget(ke),fe=E.some(function(ve){return ve===le||le.isDescendantOf(ve)});if(!fe){if(!(le instanceof w)||(fe=le.parent.childs,fe.length===E.length&&fe[E.length-1]===Ae))break;We=(b=i.getNodeFromTarget(ke)).getLevel()}ke=ke.previousSibling}(b=b instanceof w&&!b.isVisible()&&b.parent.showMore.isVisible()?b._nextNode():b)&&(J.options.limitDragging===!1||b.parent===E[0].parent)&&b.dom.tr&&b.dom.tr!==xe.nextSibling&&(E.forEach(function(be){b.parent.moveBefore(be,b)}),me=!0)}}}me&&(J.drag.mouseX=pe,J.drag.level=ye.getLevel()),J.startAutoScroll(re),H.preventDefault()}},i.onDragEnd=function(E,H){if(!Array.isArray(E))return i.onDrag([E],H);var V,b,S,R,O,J,re,pe,me;E.length!==0&&(J=E[0],V=J.editor,J&&J.dom.menu&&J.dom.menu.focus(),b=V.drag.oldParent.getInternalPath(),S=J.parent.getInternalPath(),R=V.drag.oldParent===J.parent,O=V.drag.oldNextNode.getIndex(),J=J.getIndex(),re=V.drag.oldParentPathRedo,pe=V.drag.oldIndexRedo,me=R&&pe<J?J+E.length:J,R&&pe===J||V._onAction("moveNodes",{count:E.length,fieldNames:E.map(C),oldParentPath:b,newParentPath:S,oldIndex:O,newIndex:J,oldIndexRedo:pe,newIndexRedo:me,oldParentPathRedo:re,newParentPathRedo:null,oldSelection:V.drag.oldSelection,newSelection:V.getDomSelection()}),document.body.style.cursor=V.drag.oldCursor,V.highlighter.unlock(),E.forEach(function(ye){ye.updateDom(),H.target!==ye.dom.drag&&H.target!==ye.dom.menu&&V.highlighter.unhighlight()}),delete V.drag,V.mousemove&&((0,I.removeEventListener)(H.view,"mousemove",V.mousemove),delete V.mousemove),V.mouseup&&((0,I.removeEventListener)(H.view,"mouseup",V.mouseup),delete V.mouseup),V.stopAutoScroll(),H.preventDefault())},i._findEnum=function(E){return E.enum?E.enum:(E=E.oneOf||E.anyOf||E.allOf,E&&(E=E.filter(function(H){return H.enum}),0<E.length)?E[0].enum:null)},i._findSchema=function(E,H,V){for(var b=3<arguments.length&&arguments[3]!==void 0?arguments[3]:E,S=V.slice(1,V.length),R=V[0],O=[b],J=0,re=[b.oneOf,b.anyOf,b.allOf];J<re.length;J++){var pe=re[J];Array.isArray(pe)&&(O=O.concat(pe))}var me,ye=r(O);try{for(ye.s();!(me=ye.n()).done;){if("$ref"in(b=me.value)&&typeof b.$ref=="string"){var xe,Ie=b.$ref;if(Ie in H)b=H[Ie];else{if(!Ie.startsWith("#/")){if(((xe=Ie.match(/#\//g))==null?void 0:xe.length)===1){var we,Ae,_e,We=t(Ie.split("#/"),2),ke=We[0],le=We[1];if(ke in H)return we=H[ke],Ae={$ref:"#/".concat(le)},(_e=[]).push(R),0<S.length&&_e.push.apply(_e,l(S)),i._findSchema(we,H,_e,Ae)}throw Error("Unable to resolve reference ".concat(Ie))}var fe,be=Ie.substring(2).split("/"),b=E,ve=r(be);try{for(ve.s();!(fe=ve.n()).done;){var ne=fe.value;if(!(ne in b))throw Error("Unable to resolve reference ".concat(Ie));b=b[ne]}}catch(Se){ve.e(Se)}finally{ve.f()}}}if(R===void 0)return b;if(typeof R=="string"){if(s(b.properties)==="object"&&b.properties!==null&&R in b.properties)return b=b.properties[R],i._findSchema(E,H,S,b);if(s(b.patternProperties)==="object"&&b.patternProperties!==null){for(var ie in b.patternProperties)if(R.match(ie))return b=b.patternProperties[ie],i._findSchema(E,H,S,b)}if(s(b.additionalProperties)==="object")return b=b.additionalProperties,i._findSchema(E,H,S,b)}else if(typeof R=="number"&&s(b.items)==="object"&&b.items!==null)return b=b.items,i._findSchema(E,H,S,b)}}catch(ge){ye.e(ge)}finally{ye.f()}return null},i.onRemove=function(E){if(!Array.isArray(E))return i.onRemove([E]);var H,V,b,S,R,O;E&&0<E.length&&(H=(b=E[0]).parent,V=b.editor,b=b.getIndex(),V.highlighter.unhighlight(),S=V.getDomSelection(),i.blurNodes(E),R=V.getDomSelection(),O=E.map(d),E.forEach(function(J){J.parent._remove(J)}),V._onAction("removeNodes",{nodes:E,paths:O,parentPath:H.getInternalPath(),index:b,oldSelection:S,newSelection:R}))},i.onDuplicate=function(E){if(!Array.isArray(E))return i.onDuplicate([E]);var H,V,b,S,R,O,J;E&&0<E.length&&(H=E[E.length-1],V=H.parent,(b=H.editor).deselect(b.multiselection.nodes),S=b.getDomSelection(),R=H,O=E.map(function(re){var pe,me=re.clone();return re.parent.type==="object"&&(pe=re.parent.getFieldNames(),me.field=(0,I.findUniqueName)(re.field,pe)),V.insertAfter(me,R),R=me}),E.length===1?O[0].parent.type==="object"?(O[0].dom.field.innerHTML=E[0]._escapeHTML(E[0].field),O[0].focus("field")):O[0].focus():b.select(O),J=b.getDomSelection(),b._onAction("duplicateNodes",{paths:E.map(d),clonePaths:O.map(d),afterPath:H.getInternalPath(),parentPath:V.getInternalPath(),oldSelection:S,newSelection:J}))},i.getNodeFromTarget=function(E){for(;E;){if(E.node)return E.node;E=E.parentNode}},i.targetIsColorPicker=function(E){var H=i.getNodeFromTarget(E);if(H)for(var V=E&&E.parentNode;V;){if(V===H.dom.color)return!0;V=V.parentNode}return!1},i.blurNodes=function(E){var H,V;Array.isArray(E)?(H=(V=E[0]).parent,V=V.getIndex(),(H.childs[V+E.length]?H.childs[V+E.length]:H.childs[V-1]||H).focus()):i.blurNodes([E])},(x.prototype=new i).getDom=function(){var E=this.dom;if(E.tr)return E.tr;this._updateEditability();var H=document.createElement("tr"),V=(H.className="jsoneditor-append",H.node=this,E.tr=H,this.editor.options.mode==="tree"&&(E.tdDrag=document.createElement("td"),b=document.createElement("td"),E.tdMenu=b,(V=document.createElement("button")).type="button",V.className="jsoneditor-button jsoneditor-contextmenu-button",V.title="Click to open the actions menu (Ctrl+M)",E.menu=V,b.appendChild(E.menu)),document.createElement("td")),b=document.createElement("div");return b.appendChild(document.createTextNode("("+(0,G.Iu)("empty")+")")),b.className="jsoneditor-readonly",V.appendChild(b),E.td=V,E.text=b,this.updateDom(),H},x.prototype.getPath=function(){return null},x.prototype.getIndex=function(){return null},x.prototype.updateDom=function(E){var H=this.dom,V=H.td,b=(V&&(V.style.paddingLeft=24*this.getLevel()+26+"px"),H.text),b=(b&&(b.firstChild.nodeValue="("+(0,G.Iu)("empty")+" "+this.parent.type+")"),H.tr);this.isVisible()?H.tr.firstChild||(H.tdDrag&&b.appendChild(H.tdDrag),H.tdMenu&&b.appendChild(H.tdMenu),b.appendChild(V)):H.tr.firstChild&&(H.tdDrag&&b.removeChild(H.tdDrag),H.tdMenu&&b.removeChild(H.tdMenu),b.removeChild(V))},x.prototype.isVisible=function(){return this.parent.childs.length===0},x.prototype.showContextMenu=function(E,H){var V,b=this,S=[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,G.Iu)("autoType"),click:function(){b._onAppend("","","auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array",title:(0,G.Iu)("arrayType"),click:function(){b._onAppend("",[])}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object",title:(0,G.Iu)("objectType"),click:function(){b._onAppend("",{})}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string",title:(0,G.Iu)("stringType"),click:function(){b._onAppend("","","string")}}],S=(b.addTemplates(S,!0),[{text:(0,G.Iu)("appendText"),title:(0,G.Iu)("appendTitleAuto"),submenuTitle:(0,G.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){b._onAppend("","","auto")},submenu:S}]);this.editor.options.onCreateMenu&&(V=b.parent.getPath(),S=this.editor.options.onCreateMenu(S,{type:"append",path:V,paths:[V]})),new k.x(S,{close:H}).show(E,this.editor.getPopupAnchor())},x.prototype.onEvent=function(E){var H,V=E.type,b=E.target||E.srcElement,S=this.dom;b===S.menu&&(V==="mouseover"?this.editor.highlighter.highlight(this.parent):V==="mouseout"&&this.editor.highlighter.unhighlight()),V==="click"&&b===S.menu&&((H=this.editor.highlighter).highlight(this.parent),H.lock(),(0,I.addClassName)(S.menu,"jsoneditor-selected"),this.showContextMenu(S.menu,function(){(0,I.removeClassName)(S.menu,"jsoneditor-selected"),H.unlock(),H.unhighlight()})),V==="keydown"&&this.onKeyDown(E)};var w=x;function x(E){this.editor=E,this.dom={}}(P.prototype=new i).getDom=function(){var E,H,V,b,S,R;return this.dom.tr||(this._updateEditability(),this.dom.tr||(H=(E=this).parent,(S=document.createElement("a")).appendChild(document.createTextNode((0,G.Iu)("showMore"))),S.href="#",S.onclick=function(O){return H.visibleChilds=Math.floor(H.visibleChilds/H.getMaxVisibleChilds()+1)*H.getMaxVisibleChilds(),E.updateDom(),H.showChilds(),O.preventDefault(),!1},(R=document.createElement("a")).appendChild(document.createTextNode((0,G.Iu)("showAll"))),R.href="#",R.onclick=function(O){return H.visibleChilds=1/0,E.updateDom(),H.showChilds(),O.preventDefault(),!1},V=document.createElement("div"),b=document.createTextNode(this._getShowMoreText()),V.className="jsoneditor-show-more",V.appendChild(b),V.appendChild(S),V.appendChild(document.createTextNode(". ")),V.appendChild(R),V.appendChild(document.createTextNode(". ")),(S=document.createElement("td")).appendChild(V),R=document.createElement("tr"),this.editor.options.mode==="tree"&&(R.appendChild(document.createElement("td")),R.appendChild(document.createElement("td"))),R.appendChild(S),R.className="jsoneditor-show-more",this.dom.tr=R,this.dom.moreContents=V,this.dom.moreText=b),this.updateDom()),this.dom.tr},P.prototype.updateDom=function(E){var H;this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(H=this.parent._getNextTr())&&H.parentNode.insertBefore(this.dom.tr,H),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},P.prototype._getShowMoreText=function(){return(0,G.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},P.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},P.prototype.onEvent=function(E){E.type==="keydown"&&this.onKeyDown(E)};var $=P;function P(E,H){this.editor=E,this.parent=H,this.dom={}}function B(E){return(B=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(H){return typeof H}:function(H){return H&&typeof Symbol=="function"&&H.constructor===Symbol&&H!==Symbol.prototype?"symbol":typeof H})(E)}function Z(E,H){for(var V=0;V<H.length;V++){var b=H[V];b.enumerable=b.enumerable||!1,b.configurable=!0,"value"in b&&(b.writable=!0),Object.defineProperty(E,function(S){return S=function(R,O){if(B(R)!=="object"||R===null)return R;var J=R[Symbol.toPrimitive];if(J===void 0)return(O==="string"?String:Number)(R);if(J=J.call(R,O||"default"),B(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),B(S)==="symbol"?S:String(S)}(b.key),b)}}var u=function(){function E(b){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");function S(R){return b.node.findNodeByInternalPath(R)}this.editor=b,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(R){S(R.parentPath).childs[R.index].updateField(R.oldValue)},redo:function(R){S(R.parentPath).childs[R.index].updateField(R.newValue)}},editValue:{undo:function(R){S(R.path).updateValue(R.oldValue)},redo:function(R){S(R.path).updateValue(R.newValue)}},changeType:{undo:function(R){S(R.path).changeType(R.oldType)},redo:function(R){S(R.path).changeType(R.newType)}},appendNodes:{undo:function(R){var O=S(R.parentPath);R.paths.map(S).forEach(function(J){O.removeChild(J)})},redo:function(R){var O=S(R.parentPath);R.nodes.forEach(function(J){O.appendChild(J)})}},insertBeforeNodes:{undo:function(R){var O=S(R.parentPath);R.paths.map(S).forEach(function(J){O.removeChild(J)})},redo:function(R){var O=S(R.parentPath),J=S(R.beforePath);R.nodes.forEach(function(re){O.insertBefore(re,J)})}},insertAfterNodes:{undo:function(R){var O=S(R.parentPath);R.paths.map(S).forEach(function(J){O.removeChild(J)})},redo:function(R){var O=S(R.parentPath),J=S(R.afterPath);R.nodes.forEach(function(re){O.insertAfter(re,J),J=re})}},removeNodes:{undo:function(R){var O=S(R.parentPath),J=O.childs[R.index]||O.append;R.nodes.forEach(function(re){O.insertBefore(re,J)})},redo:function(R){var O=S(R.parentPath);R.paths.map(S).forEach(function(J){O.removeChild(J)})}},duplicateNodes:{undo:function(R){var O=S(R.parentPath);R.clonePaths.map(S).forEach(function(J){O.removeChild(J)})},redo:function(R){var O=S(R.parentPath),J=S(R.afterPath);R.paths.map(S).forEach(function(re){var pe,me=re.clone();O.type==="object"&&(pe=O.getFieldNames(),me.field=(0,I.findUniqueName)(re.field,pe)),O.insertAfter(me,J),J=me})}},moveNodes:{undo:function(R){var O=S(R.oldParentPath),J=S(R.newParentPath),re=O.childs[R.oldIndex]||O.append;J.childs.slice(R.newIndex,R.newIndex+R.count).forEach(function(pe,me){pe.field=R.fieldNames[me],O.moveBefore(pe,re)}),R.newParentPathRedo===null&&(R.newParentPathRedo=J.getInternalPath())},redo:function(R){var O=S(R.oldParentPathRedo),J=S(R.newParentPathRedo),re=J.childs[R.newIndexRedo]||J.append;O.childs.slice(R.oldIndexRedo,R.oldIndexRedo+R.count).forEach(function(pe,me){pe.field=R.fieldNames[me],J.moveBefore(pe,re)})}},sort:{undo:function(R){var O=S(R.path);O.hideChilds(),O.childs=R.oldChilds,O.updateDom({updateIndexes:!0}),O.showChilds()},redo:function(R){var O=S(R.path);O.hideChilds(),O.childs=R.newChilds,O.updateDom({updateIndexes:!0}),O.showChilds()}},transform:{undo:function(R){S(R.path).setInternalValue(R.oldValue)},redo:function(R){S(R.path).setInternalValue(R.newValue)}}}}var H,V;return H=E,(V=[{key:"onChange",value:function(){}},{key:"add",value:function(b,S){this.index++,this.history[this.index]={action:b,params:S,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var b=this.history[this.index];if(b){var S=this.actions[b.action];if(S&&S.undo){if(S.undo(b.params),b.params.oldSelection)try{this.editor.setDomSelection(b.params.oldSelection)}catch(R){console.error(R)}}else console.error(new Error('unknown action "'+b.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var b=this.history[this.index];if(b){var S=this.actions[b.action];if(S&&S.redo){if(S.redo(b.params),b.params.newSelection)try{this.editor.setDomSelection(b.params.newSelection)}catch(R){console.error(R)}}else console.error(new Error('unknown action "'+b.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}])&&Z(H.prototype,V),Object.defineProperty(H,"prototype",{writable:!1}),E}();function v(E){return(v=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(H){return typeof H}:function(H){return H&&typeof Symbol=="function"&&H.constructor===Symbol&&H!==Symbol.prototype?"symbol":typeof H})(E)}function N(E,H){for(var V=0;V<H.length;V++){var b=H[V];b.enumerable=b.enumerable||!1,b.configurable=!0,"value"in b&&(b.writable=!0),Object.defineProperty(E,function(S){return S=function(R,O){if(v(R)!=="object"||R===null)return R;var J=R[Symbol.toPrimitive];if(J===void 0)return(O==="string"?String:Number)(R);if(J=J.call(R,O||"default"),v(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),v(S)==="symbol"?S:String(S)}(b.key),b)}}var y=function(){function E(re,O){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");var R=this,re=(this.editor=re,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=O,document.createElement("div")),O=((this.dom.wrapper=re).className="jsoneditor-search",O.appendChild(re),document.createElement("div")),O=((this.dom.results=O).className="jsoneditor-results",re.appendChild(O),document.createElement("div")),re=((this.dom.input=O).className="jsoneditor-frame",O.title=(0,G.Iu)("searchTitle"),re.appendChild(O),document.createElement("button")),J=(re.type="button",re.className="jsoneditor-refresh",O.appendChild(re),document.createElement("input")),re=(J.type="text",(this.dom.search=J).oninput=function(pe){R._onDelayedSearch(pe)},J.onchange=function(pe){R._onSearch()},J.onkeydown=function(pe){R._onKeyDown(pe)},J.onkeyup=function(pe){R._onKeyUp(pe)},re.onclick=function(pe){J.select()},O.appendChild(J),document.createElement("button")),re=(re.type="button",re.title=(0,G.Iu)("searchNextResultTitle"),re.className="jsoneditor-next",re.onclick=function(){R.next()},O.appendChild(re),document.createElement("button"));re.type="button",re.title=(0,G.Iu)("searchPreviousResultTitle"),re.className="jsoneditor-previous",re.onclick=function(){R.previous()},O.appendChild(re)}var H,V;return H=E,(V=[{key:"next",value:function(b){var S;this.results&&((S=this.resultIndex!==null?this.resultIndex+1:0)>this.results.length-1&&(S=0),this._setActiveResult(S,b))}},{key:"previous",value:function(b){var S,R;this.results&&(S=this.results.length-1,R=this.resultIndex!==null?this.resultIndex-1:S,this._setActiveResult(R=R<0?S:R,b))}},{key:"_setActiveResult",value:function(b,S){var R,O,J;this.activeResult&&(R=this.activeResult.node,this.activeResult.elem==="field"?delete R.searchFieldActive:delete R.searchValueActive,R.updateDom()),this.results&&this.results[b]?(this.resultIndex=b,O=this.results[this.resultIndex].node,(J=this.results[this.resultIndex].elem)==="field"?O.searchFieldActive=!0:O.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],O.updateDom(),O.scrollTo(function(){S&&O.focus(J)})):(this.resultIndex=void 0,this.activeResult=void 0)}},{key:"_clearDelay",value:function(){this.timeout!==void 0&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(b){this._clearDelay();var S=this;this.timeout=setTimeout(function(R){S._onSearch()},this.delay)}},{key:"_onSearch",value:function(b){this._clearDelay();var S=this.dom.search.value,S=0<S.length?S:void 0;if(S!==this.lastText||b){this.lastText=S,this.results=this.editor.search(S);var b=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,R=0;if(this.activeResult){for(var O=0;O<this.results.length;O++)if(this.results[O].node===this.activeResult.node){R=O;break}}this._setActiveResult(R,!1),S!==void 0?(S=this.results.length,this.dom.results.textContent=S===0?"no results":S===1?"1 result":b<S?b+"+ results":S+" results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(b){var S=b.which;S===27?(this.dom.search.value="",this._onSearch(),b.preventDefault(),b.stopPropagation()):S===13&&(b.ctrlKey?this._onSearch(!0):b.shiftKey?this.previous():this.next(),b.preventDefault(),b.stopPropagation())}},{key:"_onKeyUp",value:function(b){var S=b.keyCode;S!==27&&S!==13&&this._onDelayedSearch(b)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return this.dom.search.value===""}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}])&&N(H.prototype,V),Object.defineProperty(H,"prototype",{writable:!1}),E}();function _(E){return(_=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(H){return typeof H}:function(H){return H&&typeof Symbol=="function"&&H.constructor===Symbol&&H!==Symbol.prototype?"symbol":typeof H})(E)}function W(E,H){for(var V=0;V<H.length;V++){var b=H[V];b.enumerable=b.enumerable||!1,b.configurable=!0,"value"in b&&(b.writable=!0),Object.defineProperty(E,function(S){return S=function(R,O){if(_(R)!=="object"||R===null)return R;var J=R[Symbol.toPrimitive];if(J===void 0)return(O==="string"?String:Number)(R);if(J=J.call(R,O||"default"),_(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),_(S)==="symbol"?S:String(S)}(b.key),b)}}var F=function(){function E(b,S){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");b&&(this.root=S,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,b.appendChild(this.path),this.reset())}var H,V;return H=E,(V=[{key:"reset",value:function(){this.path.textContent=(0,G.Iu)("selectNode")}},{key:"setPath",value:function(b){var S=this;this.path.textContent="",b&&b.length&&b.forEach(function(R,O){var J,re=document.createElement("span");re.className="jsoneditor-treepath-element",re.innerText=R.name,re.onclick=(function(pe){this.selectionCallback&&this.selectionCallback(pe)}).bind(S,R),S.path.appendChild(re),R.children.length&&((J=document.createElement("span")).className="jsoneditor-treepath-seperator",J.textContent="►",J.onclick=function(){S.contentMenuClicked=!0;var pe=[];R.children.forEach(function(me){pe.push({text:me.name,className:"jsoneditor-type-modes"+(b[O+1]+1&&b[O+1].name===me.name?" jsoneditor-selected":""),click:(function(ye,xe){this.contextMenuCallback&&this.contextMenuCallback(ye,xe)}).bind(S,R,me.name)})}),new k.x(pe,{limitHeight:!0}).show(J,S.root,!0)},S.path.appendChild(J)),O===b.length-1&&(re=(J||re).getBoundingClientRect().right,S.path.offsetWidth<re&&(S.path.scrollLeft=re),S.path.scrollLeft)&&((re=document.createElement("span")).className="jsoneditor-treepath-show-all-btn",re.title="show all path",re.textContent="...",re.onclick=(function(pe){(S.contentMenuClicked=!1,I.addClassName)(S.path,"show-all"),S.path.style.width=S.path.parentNode.getBoundingClientRect().width-10+"px",S.path.onblur=function(){S.contentMenuClicked?(S.contentMenuClicked=!1,S.path.focus()):((0,I.removeClassName)(S.path,"show-all"),S.path.onblur=void 0,S.path.style.width="",S.setPath(pe))}}).bind(S,b),S.path.insertBefore(re,S.path.firstChild))})}},{key:"onSectionSelected",value:function(b){typeof b=="function"&&(this.selectionCallback=b)}},{key:"onContextMenuItemSelected",value:function(b){typeof b=="function"&&(this.contextMenuCallback=b)}}])&&W(H.prototype,V),Object.defineProperty(H,"prototype",{writable:!1}),E}(),Y=z(8037),Q=z.n(Y),z={},te=(z.create=function(E,H){if(!E)throw new Error("No container element provided.");function V(ne){var ie,ge;document.createRange?((ie=document.createRange()).selectNodeContents(ne),ie.collapse(!1),(ge=window.getSelection()).removeAllRanges(),ge.addRange(ie)):document.selection&&((ie=document.body.createTextRange()).moveToElementText(ne),ie.collapse(!1),ie.select())}function b(ne){return re===void 0&&((re=document.createElement("span")).style.visibility="hidden",re.style.position="fixed",re.style.outline="0",re.style.margin="0",re.style.padding="0",re.style.border="0",re.style.left="0",re.style.whiteSpace="pre",re.style.fontSize=me,re.style.fontFamily=ye,re.style.fontWeight="normal",document.body.appendChild(re)),re.textContent=ne,re.getBoundingClientRect().right}function S(){this.style.backgroundColor="#ddd"}function R(){this.style.backgroundColor=""}function O(){ke.hide(),ke.onmouseselection(this.__hint,ke.rs)}var J,re,pe,me,ye,xe,Ie,we,Ae,_e,We,ke,le,fe,be,ve;this.container=E,this.dom={},this.highlighter=new X,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.lastSchemaErrors=void 0,this.node=null,this.focusTarget=null,this._setOptions(H),H.autocomplete&&(this.autocomplete=((J=(J=H.autocomplete)||{}).filter=J.filter||"start",J.trigger=J.trigger||"keydown",J.confirmKeys=J.confirmKeys||[39,35,9],J.caseSensitive=J.caseSensitive||!1,ye=me="",(xe=document.createElement("div")).style.position="relative",xe.style.outline="0",xe.style.border="0",xe.style.margin="0",xe.style.padding="0",(Ie=document.createElement("div")).className="autocomplete dropdown",Ie.style.position="absolute",Ie.style.visibility="hidden",we=Ie,Ae=[],We=-1,fe=ke={rs:le={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:_e=0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:xe,show:function(ne,ie,ge){var Se=this;this.startFrom=ie,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),me===""&&(me=window.getComputedStyle(ne).getPropertyValue("font-size")),ye===""&&(ye=window.getComputedStyle(ne).getPropertyValue("font-family")),Ie.style.marginLeft="0",Ie.style.marginTop=ne.getBoundingClientRect().height+"px",this.options=ge.map(String),this.element!==ne&&(this.element=ne,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=ne.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){Se.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",be),this.element.addEventListener("keydown",be,!1),this.element.removeEventListener("blur",ve),this.element.addEventListener("blur",ve,!1)),xe.appendChild(this.elementHint),xe.appendChild(Ie),ne.parentElement.appendChild(xe),this.repaint(ne)},setText:function(ne){this.element.innerText=ne},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,fe.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(ie){var ie=(ie=ie.innerText).replace(`
`,""),ge=this.options.length,Se=ie.substring(this.startFrom);pe=ie.substring(0,this.startFrom);for(var Le=0;Le<ge;Le++){var Be=this.options[Le];if(!J.caseSensitive&&Be.toLowerCase().indexOf(Se.toLowerCase())===0||J.caseSensitive&&Be.indexOf(Se)===0){this.elementHint.innerText=pe+Se+Be.substring(Se.length),this.elementHint.realInnerText=pe+Be;break}}Ie.style.left=b(pe)+"px",fe.refresh(Se,this.options),this.elementHint.style.width=b(this.elementHint.innerText)+10+"px",Ie.style.visibility!=="hidden"&&(this.elementHint.style.width=b(this.elementHint.innerText)+Ie.clientWidth+"px")}},hide:function(){we.style.visibility="hidden"},refresh:function(ne,ie){we.style.visibility="hidden",_e=0,we.textContent="";var Se=window.innerHeight||document.documentElement.clientHeight,Be=we.parentNode.getBoundingClientRect(),ge=Be.top-6,Se=Se-Be.bottom-6,Le=(Ae=[],typeof J.filter=="function"?J.filter:U[J.filter]),Be=Le?ie.filter(function(ee){return Le(J.caseSensitive?ne:ne.toLowerCase(),J.caseSensitive?ee:ee.toLowerCase(),J)}):[];(Ae=Be.map(function(ee){var ae=document.createElement("div"),he=(ae.className="item",ae.onmouseover=S,ae.onmouseout=R,ae.onmousedown=O,ae.__hint=ee,ae.textContent="",ae.appendChild(document.createTextNode(ee.substring(0,ne.length))),document.createElement("b"));return he.appendChild(document.createTextNode(ee.substring(ne.length))),ae.appendChild(he),we.appendChild(ae),ae})).length===0||Ae.length===1&&(ne.toLowerCase()===Ae[0].__hint.toLowerCase()&&!J.caseSensitive||ne===Ae[0].__hint&&J.caseSensitive)||Ae.length<2||(ke.highlight(0),3*Se<ge?(we.style.maxHeight=ge+"px",we.style.top="",we.style.bottom="100%"):(we.style.top="100%",we.style.bottom="",we.style.maxHeight=Se+"px"),we.style.visibility="visible")},highlight:function(ne){We!==-1&&Ae[We]&&(Ae[We].className="item"),Ae[ne].className="item hover",We=ne},move:function(ne){return we.style.visibility==="hidden"?"":(_e+ne!==-1&&_e+ne!==Ae.length&&(_e+=ne,ke.highlight(_e)),Ae[_e].__hint)},onmouseselection:function(){}},be=(function(ne){var ie=(ne=ne||window.event).keyCode;if(this.elementHint!=null&&ie!==33&&ie!==34)if(ie===27)le.hideDropDown(),le.element.focus(),ne.preventDefault(),ne.stopPropagation();else{var ge,Se=(Se=this.element.innerText).replace(`
`,"");if(0<=J.confirmKeys.indexOf(ie))ie===9&&this.elementHint.innerText.length===0&&le.onTab(),0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,le.hideDropDown(),V(this.element),ie===9)&&(le.element.focus(),ne.preventDefault(),ne.stopPropagation());else if(ie===13)if(this.elementHint.innerText.length===0)le.onEnter();else{var Le=Ie.style.visibility==="hidden";if(fe.hide(),Le)return le.hideDropDown(),le.element.focus(),void le.onEnter();this.element.innerText=this.elementHint.realInnerText,le.hideDropDown(),V(this.element),ne.preventDefault(),ne.stopPropagation()}else ie===40?(Le=Se.substring(this.startFrom),(ge=fe.move(1))===""&&le.onArrowDown(),this.elementHint.innerText=pe+Le+ge.substring(Le.length),this.elementHint.realInnerText=pe+ge,ne.preventDefault(),ne.stopPropagation()):ie===38&&(Le=Se.substring(this.startFrom),(ge=fe.move(-1))===""&&le.onArrowUp(),this.elementHint.innerText=pe+Le+ge.substring(Le.length),this.elementHint.realInnerText=pe+ge,ne.preventDefault(),ne.stopPropagation())}}).bind(le),ve=function(ne){le.hideDropDown()},fe.onmouseselection=function(ne,ie){ie.element.innerText=ie.elementHint.innerText=pe+ne,ie.hideDropDown(),window.setTimeout(function(){ie.element.focus(),V(ie.element)},1)},le)),this.options.history&&this.options.mode!=="view"&&(this.history=new u(this)),this._createFrame(),this._createTable()},z.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.frameFocusTracker.destroy()},z._setOptions=function(E){var H=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(V,b,S){var R;Q()?(R=V.getBoundingClientRect().top,R=(0,I.getWindow)(V).innerHeight-R<300&&300<R,new(Q())({parent:V,color:b,popup:R?"top":"bottom",onDone:function(O){O=O.rgba[3]===1?O.hex.substr(0,7):O.hex,S(O)}}).show()):console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:L.r,executeQuery:L.J,onEvent:null,enableSort:!0,enableTransform:!0},E&&(Object.keys(E).forEach(function(V){H.options[V]=E[V]}),E.limitDragging==null)&&E.schema!=null&&(this.options.limitDragging=!0),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=(0,I.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),E.onSelectionChange&&this.onSelectionChange(E.onSelectionChange),(0,G.cC)(this.options.languages),(0,G.m0)(this.options.language)},z.set=function(E){E instanceof Function||E===void 0?this.clear():(this.content.removeChild(this.table),E={field:this.options.name,value:E},E=new i(this,E),this._setRoot(E),this._validateAndCatch(),this.node.expand(!1),this.content.appendChild(this.table)),this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},z.update=function(E){var H,V;this.node.deepEqual(E)||(H=this.getSelection(),this.onChangeDisabled=!0,this.node.update(E),this.onChangeDisabled=!1,this._validateAndCatch(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),H&&H.start&&H.end&&(E=this.node.findNodeByPath(H.start.path),V=this.node.findNodeByPath(H.end.path),E)&&V?this.setSelection(H.start,H.end):this.setSelection({},{}))},z.get=function(){if(this.node)return this.node.getValue()},z.getText=function(){return JSON.stringify(this.get())},z.setText=function(E){try{this.set((0,I.parse)(E))}catch{E=(0,I.tryJsonRepair)(E),this.set((0,I.parse)(E))}},z.updateText=function(E){try{this.update((0,I.parse)(E))}catch{E=(0,I.tryJsonRepair)(E),this.update((0,I.parse)(E))}},z.setName=function(E){this.options.name=E,this.node&&this.node.updateField(this.options.name)},z.getName=function(){return this.options.name},z.focus=function(){var E=this.scrollableContent.querySelector("[contenteditable=true]");E?E.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(E=this.frame.querySelector("button"))&&E.focus()},z.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},z._setRoot=function(E){this.clear(),(this.node=E).setParent(null),E.setField(this.getName(),!1),delete E.index,this.tbody.appendChild(E.getDom())},z.search=function(E){var H;return this.node?(this.content.removeChild(this.table),H=this.node.search(E),this.content.appendChild(this.table)):H=[],H},z.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},z.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},z.expand=function(E){var H;E&&(H=this.node?this.node.findNodeByPath(E.path):null)&&(E.isExpand?H.expand(E.recursive):H.collapse(E.recursive))},z._onAction=function(E,H){this.history&&this.history.add(E,H),this._onChange()},z._onChange=function(){if(!this.onChangeDisabled){var E;if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath&&((E=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0)?this._updateTreePath(E.getNodePath()):this.treePath.reset()),this.options.onChange)try{this.options.onChange()}catch(H){console.error("Error in onChange callback: ",H)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(H){console.error("Error in onChangeJSON callback: ",H)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(H){console.error("Error in onChangeText callback: ",H)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(H){console.error("Error in onNodeName callback: ",H)}}},z.validate=function(){var E=this,H=this.node;if(H){var V=H.getValue(),b=[];this.validateSchema&&!this.validateSchema(V)&&(b=this.validateSchema.errors.map(function(O){return(0,I.improveSchemaError)(O)}).map(function(O){return{node:H.findNode(O.dataPath),error:O,type:"validation"}}).filter(function(O){return O.node!=null}));try{this.validationSequence++;var S=this,R=this.validationSequence;return this._validateCustom(V).then(function(O){return R===S.validationSequence&&(O=[].concat(b,O||[]),S._renderValidationErrors(O),typeof E.options.onValidationError=="function"&&(0,I.isValidationErrorChanged)(O,E.lastSchemaErrors)&&E.options.onValidationError.call(E,O),E.lastSchemaErrors=O),E.lastSchemaErrors})}catch(O){return Promise.reject(O)}}},z._validateAndCatch=function(){this.validate().catch(function(E){console.error("Error running validation:",E)})},z._renderValidationErrors=function(E){this.errorNodes&&this.errorNodes.forEach(function(V){V.setError(null)});var H=E.reduce(function(V,b){return b.node.findParents().filter(function(S){return!V.some(function(R){return R[0]===S})}).map(function(S){return[S,b.node]}).concat(V)},[]);this.errorNodes=H.map(function(V){return{node:V[0],child:V[1],error:{message:V[0].type==="object"?(0,G.Iu)("containsInvalidProperties"):(0,G.Iu)("containsInvalidItems")}}}).concat(E).map(function(V){return V.node.setError(V.error,V.child),V.node})},z._validateCustom=function(E){try{var H,V;if(this.options.onValidate)return H=this.node,V=this.options.onValidate(E),((0,I.isPromise)(V)?V:Promise.resolve(V)).then(function(b){return Array.isArray(b)?b.filter(function(S){var R=(0,I.isValidValidationError)(S);return R||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',S),R}).map(function(S){var R;try{R=S&&S.path?H.findNodeByPath(S.path):null}catch{}return R||console.warn("Ignoring validation error: node not found. Path:",S.path,"Error:",S),{node:R,error:S,type:"customValidation"}}).filter(function(S){return S&&S.node&&S.error&&S.error.message}):null})}catch(b){return Promise.reject(b)}return Promise.resolve(null)},z.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},z.startAutoScroll=function(E){var H=this,V=this.scrollableContent,b=(0,I.getAbsoluteTop)(V),S=V.clientHeight,R=b+S;E<b+24&&0<V.scrollTop?this.autoScrollStep=(b+24-E)/3:R-24<E&&S+V.scrollTop<V.scrollHeight?this.autoScrollStep=(R-24-E)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){H.autoScrollStep?V.scrollTop-=H.autoScrollStep:H.stopAutoScroll()},50)):this.stopAutoScroll()},z.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},z.setDomSelection=function(E){var H,V,b;E&&("scrollTop"in E&&this.scrollableContent&&(this.scrollableContent.scrollTop=E.scrollTop),E.paths?(H=this,V=E.paths.map(function(S){return H.node.findNodeByInternalPath(S)}),this.select(V)):(b=(V=E.path?this.node.findNodeByInternalPath(E.path):null)&&E.domName?V.dom[E.domName]:null,E.range&&b?(E=Object.assign({},E.range,{container:b}),(0,I.setSelectionOffset)(E)):V&&V.focus()))},z.getDomSelection=function(){var E=i.getNodeFromTarget(this.focusTarget),H=this.focusTarget,V=E?Object.keys(E.dom).find(function(S){return E.dom[S]===H}):null,b=(0,I.getSelectionOffset)();return(b=(b=b&&b.container.nodeName!=="DIV"?null:b)&&b.container!==H?null:b)&&delete b.container,{path:E?E.getInternalPath():null,domName:V,range:b,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(S){return S.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},z.scrollTo=function(E,H){var V,b,S,R,O=this.scrollableContent;O?((V=this).animateTimeout&&(clearTimeout(V.animateTimeout),delete V.animateTimeout),V.animateCallback&&(V.animateCallback(!1),delete V.animateCallback),b=O.clientHeight,S=O.scrollHeight-b,R=Math.min(Math.max(E-b/4,0),S),function J(){var re=O.scrollTop,re=R-re;3<Math.abs(re)?(O.scrollTop+=re/3,V.animateCallback=H,V.animateTimeout=setTimeout(J,50)):(H&&H(!0),O.scrollTop=R,delete V.animateTimeout,delete V.animateCallback)}()):H&&H(!1)},z._createFrame=function(){var E=this,H=(this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer",this);function V(J){H._onEvent&&H._onEvent(J)}var b,S,R,O={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new M.R(O),this.frame.onclick=function(J){var re=J.target;V(J),re.nodeName==="BUTTON"&&J.preventDefault()},this.frame.oninput=V,this.frame.onchange=V,this.frame.onkeydown=V,this.frame.onkeyup=V,this.frame.oncut=V,this.frame.onpaste=V,this.frame.onmousedown=V,this.frame.onmouseup=V,this.frame.onmouseover=V,this.frame.onmouseout=V,(0,I.addEventListener)(this.frame,"focus",V,!0),(0,I.addEventListener)(this.frame,"blur",V,!0),this.frame.onfocusin=V,this.frame.onfocusout=V,this.options.mainMenuBar&&((0,I.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(O=document.createElement("button")).type="button",O.className="jsoneditor-expand-all",O.title=(0,G.Iu)("expandAll"),O.onclick=function(){H.expandAll(),typeof E.options.onExpand=="function"&&E.options.onExpand({path:[],isExpand:!0,recursive:!0})},this.menu.appendChild(O),(O=document.createElement("button")).type="button",O.title=(0,G.Iu)("collapseAll"),O.className="jsoneditor-collapse-all",O.onclick=function(){H.collapseAll(),typeof E.options.onExpand=="function"&&E.options.onExpand({path:[],isExpand:!1,recursive:!0})},this.menu.appendChild(O),this.options.enableSort&&((O=document.createElement("button")).type="button",O.className="jsoneditor-sort",O.title=(0,G.Iu)("sortTitleShort"),O.onclick=function(){H.node.showSortModal()},this.menu.appendChild(O)),this.options.enableTransform&&((O=document.createElement("button")).type="button",O.title=(0,G.Iu)("transformTitleShort"),O.className="jsoneditor-transform",O.onclick=function(){H.node.showTransformModal()},this.menu.appendChild(O)),this.history&&((b=document.createElement("button")).type="button",b.className="jsoneditor-undo jsoneditor-separator",b.title=(0,G.Iu)("undo"),b.onclick=function(){H._onUndo()},this.menu.appendChild(b),this.dom.undo=b,(S=document.createElement("button")).type="button",S.className="jsoneditor-redo",S.title=(0,G.Iu)("redo"),S.onclick=function(){H._onRedo()},this.menu.appendChild(S),this.dom.redo=S,this.history.onChange=function(){b.disabled=!H.history.canUndo(),S.disabled=!H.history.canRedo()},this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&((R=this).modeSwitcher=new A.x(this.menu,this.options.modes,this.options.mode,function(J){try{R.setMode(J),R.modeSwitcher.focus()}catch(re){R._onError(re)}})),this.options.search)&&(this.searchBox=new y(this,this.menu)),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new F(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},z._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},z._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},z._onEvent=function(E){if(!i.targetIsColorPicker(E.target)){var H,V=i.getNodeFromTarget(E.target);if(E.type==="keydown"&&this._onKeyDown(E),V&&E.type==="focus"&&(this.focusTarget=E.target,this.options.autocomplete)&&this.options.autocomplete.trigger==="focus"&&this._showAutoComplete(E.target),E.type==="mousedown"&&this._startDragDistance(E),E.type!=="mousemove"&&E.type!=="mouseup"&&E.type!=="click"||this._updateDragDistance(E),V&&this.options&&this.options.navigationBar&&V&&(E.type==="keydown"||E.type==="mousedown")&&(H=this,setTimeout(function(){H._updateTreePath(V.getNodePath())})),V&&V.selected){if(E.type==="click"){if(E.target===V.dom.menu)return void this.showContextMenu(E.target);E.hasMoved||this.deselect()}E.type==="mousedown"&&i.onDragStart(this.multiselection.nodes,E)}else E.type==="mousedown"&&(0,I.hasParentNode)(E.target,this.content)&&(this.deselect(),V&&E.target===V.dom.drag?i.onDragStart(V,E):V&&(E.target===V.dom.field||E.target===V.dom.value||E.target===V.dom.select)||this._onMultiSelectStart(E));V&&V.onEvent(E)}},z._updateTreePath=function(E){var H;function V(b){return b.parent?b.parent.type==="array"?b.index:b.field:b.field||b.type}E&&E.length?((0,I.removeClassName)(this.navBar,"nav-bar-empty"),H=[],E.forEach(function(b){var S={name:V(b),node:b,children:[]};b.childs&&b.childs.length&&b.childs.forEach(function(R){S.children.push({name:V(R),node:R})}),H.push(S)}),this.treePath.setPath(H)):(0,I.addClassName)(this.navBar,"nav-bar-empty")},z._onTreePathSectionSelected=function(E){E&&E.node&&(E.node.expandTo(),E.node.focus())},z._onTreePathMenuItemSelected=function(E,H){E&&E.children.length&&(E=E.children.find(function(V){return V.name===H}))&&E.node&&(this._updateTreePath(E.node.getNodePath()),E.node.expandTo(),E.node.focus())},z._startDragDistance=function(E){this.dragDistanceEvent={initialTarget:E.target,initialPageX:E.pageX,initialPageY:E.pageY,dragDistance:0,hasMoved:!1}},z._updateDragDistance=function(E){this.dragDistanceEvent||this._startDragDistance(E);var H=E.pageX-this.dragDistanceEvent.initialPageX,V=E.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(H*H+V*V),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,E.dragDistance=this.dragDistanceEvent.dragDistance,E.hasMoved=this.dragDistanceEvent.hasMoved,E.dragDistance},z._onMultiSelectStart=function(E){var H,V=i.getNodeFromTarget(E.target);this.options.mode==="tree"&&this.options.onEditable===void 0&&(this.multiselection={start:V||null,end:null,nodes:[]},this._startDragDistance(E),(H=this).mousemove||(this.mousemove=(0,I.addEventListener)(E.view,"mousemove",function(b){H._onMultiSelect(b)})),this.mouseup||(this.mouseup=(0,I.addEventListener)(E.view,"mouseup",function(b){H._onMultiSelectEnd(b)})),E.preventDefault())},z._onMultiSelect=function(E){var H;E.preventDefault(),this._updateDragDistance(E),E.hasMoved&&((E=i.getNodeFromTarget(E.target))&&(this.multiselection.start==null&&(this.multiselection.start=E),this.multiselection.end=E),this.deselect(),E=this.multiselection.start,H=this.multiselection.end||this.multiselection.start,E)&&H&&(this.multiselection.nodes=this._findTopLevelNodes(E,H),this.multiselection.nodes&&this.multiselection.nodes.length&&(E=this.multiselection.nodes[0],this.multiselection.start===E||this.multiselection.start.isDescendantOf(E)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes))},z._onMultiSelectEnd=function(E){var H=this.multiselection.nodes[0];H&&H.dom.menu&&H.dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&((0,I.removeEventListener)(E.view,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&((0,I.removeEventListener)(E.view,"mouseup",this.mouseup),delete this.mouseup)},z.deselect=function(E){var H=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(V){V.setSelected(!1)}),this.multiselection.nodes=[],E&&(this.multiselection.start=null,this.multiselection.end=null),H&&this._selectionChangedHandler&&this._selectionChangedHandler()},z.select=function(E){if(!Array.isArray(E))return this.select([E]);var H;E&&(this.deselect(),this.multiselection.nodes=E.slice(0),H=E[0],E.forEach(function(V){V.expandPathToNode(),V.setSelected(!0,V===H)}),this._selectionChangedHandler)&&(E=this.getSelection(),this._selectionChangedHandler(E.start,E.end))},z._findTopLevelNodes=function(O,J){for(var V=O.getNodePath(),b=J.getNodePath(),S=0;S<V.length&&V[S]===b[S];)S++;var R,O=V[S-1],J=V[S],re=b[S];return J&&re||(O.parent?O=(re=J=O).parent:(J=O.childs[0],re=O.childs[O.childs.length-1])),O&&J&&re?(J=O.childs.indexOf(J),re=O.childs.indexOf(re),R=Math.min(J,re),J=Math.max(J,re),O.childs.slice(R,J+1)):[]},z._showAutoComplete=function(E){var H,V=i.getNodeFromTarget(E),b="";0<=E.className.indexOf("jsoneditor-value")&&(b="value"),(b=0<=E.className.indexOf("jsoneditor-field")?"field":b)!==""&&(H=this,setTimeout(function(){var S;!V||!(H.options.autocomplete.trigger==="focus"||0<E.innerText.length)||(S=H.options.autocomplete.getOptions(E.innerText,V.getPath(),b,V.editor))===null?H.autocomplete.hideDropDown():typeof S.then=="function"?S.then(function(R){R===null?H.autocomplete.hideDropDown():R.options?H.autocomplete.show(E,R.startFrom,R.options):H.autocomplete.show(E,0,R)}).catch(function(R){console.error(R)}):S.options?H.autocomplete.show(E,S.startFrom,S.options):H.autocomplete.show(E,0,S)},50))},z._onKeyDown=function(E){var H,V=E.which||E.keyCode,b=E.altKey,S=E.ctrlKey,R=E.metaKey,O=E.shiftKey,J=!1,re=this.focusTarget;V===9&&(H=this,setTimeout(function(){H.focusTarget!==re&&(0,I.selectContentEditable)(H.focusTarget)},0)),this.searchBox&&(S&&V===70?(this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),J=!0):(V===114||S&&V===71)&&(O?this.searchBox.previous(!0):this.searchBox.next(!0),J=!0)),this.history&&(S&&!O&&V===90?(this._onUndo(),J=!0):S&&O&&V===90&&(this._onRedo(),J=!0)),!this.options.autocomplete||J||S||b||R||E.key.length!==1&&V!==8&&V!==46||(J=!1,this._showAutoComplete(E.target)),J&&(E.preventDefault(),E.stopPropagation())},z._createTable=function(){var E;this.options.navigationBar&&(0,I.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),this.options.mode==="tree"&&((E=document.createElement("col")).width="24px",this.colgroupContent.appendChild(E)),(E=document.createElement("col")).width="24px",this.colgroupContent.appendChild(E),E=document.createElement("col"),this.colgroupContent.appendChild(E),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},z.showContextMenu=function(E,H){var V,b=[],S=this.multiselection.nodes.slice();b.push({text:(0,G.Iu)("duplicateText"),title:(0,G.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){i.onDuplicate(S)}}),b.push({text:(0,G.Iu)("remove"),title:(0,G.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){i.onRemove(S)}}),this.options.onCreateMenu&&(V=S.map(function(R){return R.getPath()}),b=this.options.onCreateMenu(b,{type:"multiple",path:V[0],paths:V})),new k.x(b,{close:H}).show(E,this.getPopupAnchor())},z.getPopupAnchor=function(){return this.options.popupAnchor||this.frame},z.getSelection=function(){var E,H,V={start:null,end:null};return this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length&&(E=this.multiselection.nodes[0],H=this.multiselection.nodes[this.multiselection.nodes.length-1],this.multiselection.direction==="down"?(V.start=E.serialize(),V.end=H.serialize()):(V.start=H.serialize(),V.end=E.serialize())),V},z.onSelectionChange=function(E){typeof E=="function"&&(this._selectionChangedHandler=(0,I.debounce)(E,this.DEBOUNCE_INTERVAL))},z.setSelection=function(E,H){E&&E.dom&&E.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(E)),E=this._getNodeInstancesByRange(E,H),E.forEach(function(V){V.expandTo()}),this.select(E)},z._getNodeInstancesByRange=function(E,H){E&&E.path&&(V=this.node.findNodeByPath(E.path),H)&&H.path&&(b=this.node.findNodeByPath(H.path));var V,b,S=[];if(V instanceof i)if(b instanceof i&&b!==V)if(V.parent===b.parent){H=V.getIndex()<b.getIndex()?(E=V,b):(E=b,V);var R=E;for(S.push(R);R=R.nextSibling(),S.push(R),R&&R!==H;);}else S=this._findTopLevelNodes(V,b);else S.push(V);return S},z.getNodesByRange=function(V,H){var V=this._getNodeInstancesByRange(V,H),b=[];return V.forEach(function(S){b.push(S.serialize())}),b},[{mode:"tree",mixin:z,data:"json"},{mode:"view",mixin:z,data:"json"},{mode:"form",mixin:z,data:"json"}])},2744:function(ce,g,D){g.tryRequireAjv=function(){try{return D(8903)}catch{}}},9125:function(ce,g,D){g.O=function(){try{D(4864)}catch(U){console.error(U)}}},9791:function(ce,U,D){D.r(U),D.d(U,{addClassName:function(){return d},addEventListener:function(){return Y},asyncExec:function(){return Le},clear:function(){return t},compileJSONPointer:function(){return me},contains:function(){return ie},debounce:function(){return R},escapeUnicodeChars:function(){return h},extend:function(){return l},findUniqueName:function(){return Ae},formatSize:function(){return be},get:function(){return we},getAbsoluteLeft:function(){return i},getAbsoluteTop:function(){return c},getChildPaths:function(){return _e},getColorCSS:function(){return ye},getIndexForPosition:function(){return re},getInnerText:function(){return v},getInputSelection:function(){return J},getInternetExplorerVersion:function(){return _},getPositionForPath:function(){return pe},getSelection:function(){return P},getSelectionOffset:function(){return Z},getType:function(){return r},getWindow:function(){return o},hasParentNode:function(){return y},improveSchemaError:function(){return H},insideRect:function(){return S},isArray:function(){return s},isChildOf:function(){return z},isFirefox:function(){return F},isObject:function(){return ne},isPromise:function(){return V},isTimestamp:function(){return fe},isUrl:function(){return n},isValidColor:function(){return xe},isValidValidationError:function(){return b},isValidationErrorChanged:function(){return ge},limitCharacters:function(){return ve},makeFieldTooltip:function(){return Ie},parse:function(){return I},parsePath:function(){return te},parseString:function(){return le},removeAllClassNames:function(){return C},removeClassName:function(){return p},removeEventListener:function(){return Q},removeReturnsAndSurroundingWhitespace:function(){return N},selectContentEditable:function(){return $},setEndOfContentEditable:function(){return x},setSelection:function(){return B},setSelectionOffset:function(){return u},sort:function(){return We},sortObjectKeys:function(){return ke},stringifyPath:function(){return E},stripFormatting:function(){return w},textDiff:function(){return O},tryJsonRepair:function(){return m},uniqueMergeArrays:function(){return Se},validate:function(){return a}}),D(4987);var U=D(233),k=D.n(U),M=D(1262),K=D(6589),j=D(7026),X=D(7907);function G(ee){return function(ae){if(Array.isArray(ae))return L(ae)}(ee)||function(ae){if(typeof Symbol<"u"&&ae[Symbol.iterator]!=null||ae["@@iterator"]!=null)return Array.from(ae)}(ee)||function(ae,he){var Ce;if(ae)return typeof ae=="string"?L(ae,he):(Ce=(Ce=Object.prototype.toString.call(ae).slice(8,-1))==="Object"&&ae.constructor?ae.constructor.name:Ce)==="Map"||Ce==="Set"?Array.from(ae):Ce==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(Ce)?L(ae,he):void 0}(ee)||function(){throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function L(ee,ae){(ae==null||ae>ee.length)&&(ae=ee.length);for(var he=0,Ce=new Array(ae);he<ae;he++)Ce[he]=ee[he];return Ce}function A(ee){return(A=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(ae){return typeof ae}:function(ae){return ae&&typeof Symbol=="function"&&ae.constructor===Symbol&&ae!==Symbol.prototype?"symbol":typeof ae})(ee)}var f=1e4,T=9466848e5;function I(ee){try{return JSON.parse(ee)}catch(ae){throw a(ee),ae}}function m(ee){try{return(0,M.K)(ee)}catch{return ee}}function h(ee){return ee.replace(/[\u007F-\uFFFF]/g,function(ae){return"\\u"+("0000"+ae.charCodeAt(0).toString(16)).slice(-4)})}function a(ee){(K!==void 0?K:JSON).parse(ee)}function l(ee,ae){for(var he in ae)Be(ae,he)&&(ee[he]=ae[he]);return ee}function t(ee){for(var ae in ee)Be(ee,ae)&&delete ee[ae];return ee}function r(ee){return ee===null?"null":ee===void 0?"undefined":ee instanceof Number||typeof ee=="number"?"number":ee instanceof String||typeof ee=="string"?"string":ee instanceof Boolean||typeof ee=="boolean"?"boolean":ee instanceof RegExp?"regexp":s(ee)?"array":"object"}var e=/^https?:\/\/\S+$/;function n(ee){return(typeof ee=="string"||ee instanceof String)&&e.test(ee)}function s(ee){return Object.prototype.toString.call(ee)==="[object Array]"}function o(ee){return ee.ownerDocument.defaultView}function i(ee){return ee.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function c(ee){return ee.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function d(ee,ae){var he=ee.className.split(" ");he.indexOf(ae)===-1&&(he.push(ae),ee.className=he.join(" "))}function C(ee){ee.className=""}function p(ee,Ce){var he=ee.className.split(" "),Ce=he.indexOf(Ce);Ce!==-1&&(he.splice(Ce,1),ee.className=he.join(" "))}function w(ee){for(var ae=ee.childNodes,he=0,Ce=ae.length;he<Ce;he++){var Re=ae[he],Ee=(Re.style&&Re.removeAttribute("style"),Re.attributes);if(Ee)for(var Ne=Ee.length-1;0<=Ne;Ne--){var Fe=Ee[Ne];Fe.specified===!0&&Re.removeAttribute(Fe.name)}w(Re)}}function x(ee){var ae;document.createRange&&((ae=document.createRange()).selectNodeContents(ee),ae.collapse(!1),(ee=window.getSelection()).removeAllRanges(),ee.addRange(ae))}function $(ee){var ae;ee&&ee.nodeName==="DIV"&&window.getSelection&&document.createRange&&((ae=document.createRange()).selectNodeContents(ee),(ee=window.getSelection()).removeAllRanges(),ee.addRange(ae))}function P(){if(window.getSelection){var ee=window.getSelection();if(ee.getRangeAt&&ee.rangeCount)return ee.getRangeAt(0)}return null}function B(ee){var ae;ee&&window.getSelection&&((ae=window.getSelection()).removeAllRanges(),ae.addRange(ee))}function Z(){var ee=P();return ee&&"startOffset"in ee&&"endOffset"in ee&&ee.startContainer&&ee.startContainer===ee.endContainer?{startOffset:ee.startOffset,endOffset:ee.endOffset,container:ee.startContainer.parentNode}:null}function u(ee){var ae;document.createRange&&window.getSelection&&window.getSelection()&&(ae=document.createRange(),ee.container.firstChild||ee.container.appendChild(document.createTextNode("")),ae.setStart(ee.container.firstChild,ee.startOffset),ae.setEnd(ee.container.firstChild,ee.endOffset),B(ae))}function v(ee,ae){var he;if(ae===void 0&&(ae={_text:"",flush:function(){var Xe=this._text;return this._text="",Xe},set:function(Xe){this._text=Xe}}),ee.nodeValue)return(he=N(ee.nodeValue))!==""?ae.flush()+he:"";if(ee.hasChildNodes()){for(var Ce=ee.childNodes,Re="",Ee=0,Ne=Ce.length;Ee<Ne;Ee++){var Fe,ze=Ce[Ee];ze.nodeName==="DIV"||ze.nodeName==="P"?((Fe=(Fe=Ce[Ee-1])?Fe.nodeName:void 0)&&Fe!=="DIV"&&Fe!=="P"&&Fe!=="BR"&&(Re!==""&&(Re+=`
`),ae.flush()),Re+=v(ze,ae),ae.set(`
`)):ze.nodeName==="BR"?(Re+=ae.flush(),ae.set(`
`)):Re+=v(ze,ae)}return Re}return""}function N(ee){return ee.replace(/(\b|^)\s*(\b|$)/g,function(ae){return/\n/.exec(ae)?"":ae})}function y(ee,ae){for(var he=ee?ee.parentNode:void 0;he;){if(he===ae)return!0;he=he.parentNode}return!1}function _(){var ee;return W===-1&&(ee=-1,typeof navigator<"u"&&navigator.appName==="Microsoft Internet Explorer"&&/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)!=null&&(ee=parseFloat(RegExp.$1)),W=ee),W}var W=-1;function F(){return typeof navigator<"u"&&navigator.userAgent.indexOf("Firefox")!==-1}function Y(ee,ae,he,Ce){return ee.addEventListener?(Ce===void 0&&(Ce=!1),ae==="mousewheel"&&F()&&(ae="DOMMouseScroll"),ee.addEventListener(ae,he,Ce),he):ee.attachEvent?(ee.attachEvent("on"+ae,Ce=function(){return he.call(ee,window.event)}),Ce):void 0}function Q(ee,ae,he,Ce){ee.removeEventListener?(Ce===void 0&&(Ce=!1),ae==="mousewheel"&&F()&&(ae="DOMMouseScroll"),ee.removeEventListener(ae,he,Ce)):ee.detachEvent&&ee.detachEvent("on"+ae,he)}function z(ee,ae){for(var he=ee.parentNode;he;){if(he===ae)return!0;he=he.parentNode}return!1}function te(ee){var ae=[],he=0;function Ce(Ee){for(var Ne="";ee[he]!==void 0&&ee[he]!==Ee;)Ne+=ee[he],he++;if(ee[he]!==Ee)throw new Error("Invalid JSON path: unexpected end, character "+Ee+" expected");return Ne}for(;ee[he]!==void 0;)if(ee[he]===".")he++,ae.push(function(){for(var Ee="";ee[he]!==void 0&&/[\w$]/.test(ee[he]);)Ee+=ee[he],he++;if(Ee==="")throw new Error("Invalid JSON path: property name expected at index "+he);return Ee}());else{if(ee[he]!=="[")throw new Error('Invalid JSON path: unexpected character "'+ee[he]+'" at index '+he);if(ee[++he]==="'"||ee[he]==='"'){var Re=ee[he];if(he++,ae.push(Ce(Re)),ee[he]!==Re)throw new Error("Invalid JSON path: closing quote ' expected at index "+he);he++}else{if(Re=Ce("]").trim(),Re.length===0)throw new Error("Invalid JSON path: array value expected at index "+he);Re=Re==="*"?Re:JSON.parse(Re),ae.push(Re)}if(ee[he]!=="]")throw new Error("Invalid JSON path: closing bracket ] expected at index "+he);he++}return ae}function E(ee){return ee.map(function(ae){return typeof ae=="number"?"["+ae+"]":typeof ae=="string"&&ae.match(/^[A-Za-z0-9_$]+$/)?"."+ae:'["'+ae+'"]'}).join("")}function H(ee){var ae,he;return ee.keyword==="enum"&&Array.isArray(ee.schema)&&(he=ee.schema)&&(5<(he=he.map(function(Ce){return JSON.stringify(Ce)})).length&&(ae=["("+(he.length-5)+" more...)"],(he=he.slice(0,5)).push(ae)),ee.message="should be equal to one of: "+he.join(", ")),ee.keyword==="additionalProperties"&&(ee.message="should NOT have additional property: "+ee.params.additionalProperty),ee}function V(ee){return ee&&typeof ee.then=="function"&&typeof ee.catch=="function"}function b(ee){return A(ee)==="object"&&Array.isArray(ee.path)&&typeof ee.message=="string"}function S(ee,ae,he){return he=he!==void 0?he:0,ae.left-he>=ee.left&&ae.right+he<=ee.right&&ae.top-he>=ee.top&&ae.bottom+he<=ee.bottom}function R(ee,ae,he){var Ce;return function(){var Re=this,Ee=arguments,Ne=he&&!Ce;clearTimeout(Ce),Ce=setTimeout(function(){Ce=null,he||ee.apply(Re,Ee)},ae),Ne&&ee.apply(Re,Ee)}}function O(ee,ae){for(var he=ae.length,Ce=0,Re=ee.length,Ee=ae.length;ae.charAt(Ce)===ee.charAt(Ce)&&Ce<he;)Ce++;for(;ae.charAt(Ee-1)===ee.charAt(Re-1)&&Ce<Ee&&0<Re;)Ee--,Re--;return{start:Ce,end:Ee}}function J(ee){var ae,he,Ce,Re,Ee=0,Ne=0;return typeof ee.selectionStart=="number"&&typeof ee.selectionEnd=="number"?(Ee=ee.selectionStart,Ne=ee.selectionEnd):(Re=document.selection.createRange())&&Re.parentElement()===ee&&(Ce=ee.value.length,ae=ee.value.replace(/\r\n/g,`
`),(he=ee.createTextRange()).moveToBookmark(Re.getBookmark()),(Re=ee.createTextRange()).collapse(!1),-1<he.compareEndPoints("StartToEnd",Re)?Ee=Ne=Ce:(Ee=-he.moveStart("character",-Ce),Ee+=ae.slice(0,Ee).split(`
`).length-1,-1<he.compareEndPoints("EndToEnd",Re)?Ne=Ce:(Ne=-he.moveEnd("character",-Ce),Ne+=ae.slice(0,Ne).split(`
`).length-1))),{startIndex:Ee,endIndex:Ne,start:Fe(Ee),end:Fe(Ne)};function Fe(ze){return ze=ee.value.substring(0,ze),{row:(ze.match(/\n/g)||[]).length+1,column:ze.length-ze.lastIndexOf(`
`)}}}function re(Ce,ae,he){var Ce=Ce.value||"";return 0<ae&&0<he?(Ce=Ce.split(`
`,ae),ae=Math.min(Ce.length,ae),he=Math.min(Ce[ae-1].length,he-1),he=ae===1?he:he+1,Ce.slice(0,ae-1).join(`
`).length+he):-1}function pe(ee,ae){var he,Ce=[];if(ae&&ae.length){try{he=j.parse(ee)}catch{return Ce}ae.forEach(function(Re){var Ee=me(te(Re)),Ee=he.pointers[Ee];Ee&&Ce.push({path:Re,line:Ee.key?Ee.key.line:Ee.value?Ee.value.line:0,column:Ee.key?Ee.key.column:Ee.value?Ee.value.column:0})})}return Ce}function me(ee){return ee.map(function(ae){return"/"+String(ae).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function ye(ee){var ae=document.createElement("div");return ae.style.color=ee,ae.style.color.split(/\s+/).join("").toLowerCase()||null}function xe(ee){return!!ye(ee)}function Ie(ee,ae){var he;return ee?(he="",ee.title&&(he+=ee.title),ee.description&&(0<he.length&&(he+=`
`),he+=ee.description),ee.default&&(0<he.length&&(he+=`

`),he=(he+=(0,X.Iu)("default",void 0,ae)+`
`)+JSON.stringify(ee.default,null,2)),Array.isArray(ee.examples)&&0<ee.examples.length&&(0<he.length&&(he+=`

`),he+=(0,X.Iu)("examples",void 0,ae)+`
`,ee.examples.forEach(function(Ce,Re){he+=JSON.stringify(Ce,null,2),Re!==ee.examples.length-1&&(he+=`
`)})),he):""}function we(ee,ae){for(var he=ee,Ce=0;Ce<ae.length&&he!=null;Ce++)he=he[ae[Ce]];return he}function Ae(ee,ae){for(var he=ee.replace(/ \(copy( \d+)?\)$/,""),Ce=he,Re=1;ae.indexOf(Ce)!==-1;)Ce=he+" ("+("copy"+(1<Re?" "+Re:""))+")",Re++;return Ce}function _e(ee,ae){var he={};if(Array.isArray(ee))for(var Ce=Math.min(ee.length,f),Re=0;Re<Ce;Re++)(function Ee(Ne,Fe,ze,Xe){(Array.isArray(Ne)||ne(Ne))&&!Xe||(Fe[ze||""]=!0),ne(Ne)&&Object.keys(Ne).forEach(function(se){Ee(Ne[se],Fe,ze+"."+se,Xe)})})(ee[Re],he,"",ae);else he[""]=!0;return Object.keys(he).sort()}function We(ee,Ee,he){var Ce=Ee&&Ee!=="."?te(Ee):[],Re=he==="desc"?-1:1,Ee=ee.slice();return Ee.sort(function(Ne,Fe){return Ne=we(Ne,Ce),Fe=we(Fe,Ce),Re*(Fe<Ne?1:Ne<Fe?-1:0)}),Ee}function ke(ee,Ce){var he=Ce==="desc"?-1:1,Ce=Object.keys(ee).sort(function(Ee,Ne){return he*k()(Ee,Ne)}),Re={};return Ce.forEach(function(Ee){Re[Ee]=ee[Ee]}),Re}function le(ee){var ae,he;return ee===""?"":(ae=ee.toLowerCase())==="null"?null:ae==="true"||ae!=="false"&&(ae=Number(ee),he=parseFloat(ee),isNaN(ae)||isNaN(he)?ee:ae)}function fe(ee,ae){return typeof ae=="number"&&T<ae&&isFinite(ae)&&Math.floor(ae)===ae&&!isNaN(new Date(ae).valueOf())}function be(ee){return ee<900?ee.toFixed()+" B":(ee=ee/1e3)<900?ee.toFixed(1)+" KB":(ee=ee/1e3)<900?ee.toFixed(1)+" MB":(ee=ee/1e3)<900?ee.toFixed(1)+" GB":(ee/1e3).toFixed(1)+" TB"}function ve(ee,ae){return ee.length<=ae?ee:ee.slice(0,ae)+"..."}function ne(ee){return A(ee)==="object"&&ee!==null&&!Array.isArray(ee)}function ie(ee,ae){return ee.indexOf(ae)!==-1}function ge(ee,ae){if(ae||ee){if(ae&&!ee||!ae&&ee||ae.length!==ee.length)return!0;for(var he=0;he<ee.length;++he){var Ce=function(Re){var Ee=ee[Re].type==="error"?ae.find(function(Ne){return Ne.line===ee[Re].line}):ae.find(function(Ne){return Ne.dataPath===ee[Re].dataPath&&Ne.schemaPath===ee[Re].schemaPath});if(!Ee)return{v:!0}}(he);if(A(Ce)==="object")return Ce.v}}return!1}function Se(ee,ae){return ee=ee!=null&&ee.length?ee:[],ae=ae!=null&&ae.length?ae:[],G(new Set(ee.concat(ae)))}function Le(ee){setTimeout(ee)}function Be(ee,ae){return Object.prototype.hasOwnProperty.call(ee,ae)}},8037:function(ce,g,D){var U;if(window.Picker)U=window.Picker;else try{U=D(4049)}catch{}ce.exports=U},6225:function(ce,g,D){function U(A,f){var T,I;return f=L(A,f),(A=j.modules[f])||(typeof(A=j.payloads[f])=="function"&&(T={id:f,uri:"",exports:I={},packaged:!0},I=A(function(m,h){return X(f,m,h)},I,T)||T.exports,j.modules[f]=I,delete j.payloads[f]),A=j.modules[f]=I||A),A}var k,M,K,j,X,G,L;ce=D.nmd(ce),(K=function(){return this}())||typeof window>"u"||(K=window),(j=function(A,f,T){typeof A!="string"?j.original?j.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace()):(arguments.length==2&&(T=f),j.modules[A]||(j.payloads[A]=T,j.modules[A]=null))}).modules={},j.payloads={},X=function(A,f,T){if(typeof f=="string"){var I=U(A,f);if(I!=null)return T&&T(),I}else if(Object.prototype.toString.call(f)==="[object Array]"){for(var m=[],h=0,a=f.length;h<a;++h){var l=U(A,f[h]);if(l==null&&G.original)return;m.push(l)}return T&&T.apply(null,m)||!0}},G=function(A,f){var T=X("",A,f);return T==null&&G.original?G.original.apply(this,arguments):T},L=function(A,f){var T;if(f.indexOf("!")!==-1)return T=f.split("!"),L(A,T[0])+"!"+L(A,T[1]);if(f.charAt(0)==".")for(f=A.split("/").slice(0,-1).join("/")+"/"+f;f.indexOf(".")!==-1&&I!=f;){var I=f;f=f.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return f},M=K,(k="ace")&&(K[k]||(K[k]={}),M=K[k]),M.define&&M.define.packaged||(j.original=M.define,M.define=j,M.define.packaged=!0),M.require&&M.require.packaged||(G.original=M.require,M.require=G,M.require.packaged=!0),ace.define("ace/lib/es6-shim",["require","exports","module"],function(A,f,T){function I(m,h,a){Object.defineProperty(m,h,{value:a,enumerable:!1,writable:!0,configurable:!0})}String.prototype.startsWith||I(String.prototype,"startsWith",function(m,h){return this.lastIndexOf(m,h=h||0)===h}),String.prototype.endsWith||I(String.prototype,"endsWith",function(m,h){return(h===void 0||h>this.length)&&(h=this.length),h-=m.length,m=this.indexOf(m,h),m!==-1&&m===h}),String.prototype.repeat||I(String.prototype,"repeat",function(m){for(var h="",a=this;0<m;)1&m&&(h+=a),(m>>=1)&&(a+=a);return h}),String.prototype.includes||I(String.prototype,"includes",function(m,h){return this.indexOf(m,h)!=-1}),Object.assign||(Object.assign=function(m){if(m==null)throw new TypeError("Cannot convert undefined or null to object");for(var h=Object(m),a=1;a<arguments.length;a++){var l=arguments[a];l!=null&&Object.keys(l).forEach(function(t){h[t]=l[t]})}return h}),Object.values||(Object.values=function(m){return Object.keys(m).map(function(h){return m[h]})}),Array.prototype.find||I(Array.prototype,"find",function(m){for(var h=this.length,a=arguments[1],l=0;l<h;l++){var t=this[l];if(m.call(a,t,l,this))return t}}),Array.prototype.findIndex||I(Array.prototype,"findIndex",function(m){for(var h=this.length,a=arguments[1],l=0;l<h;l++){var t=this[l];if(m.call(a,t,l,this))return l}}),Array.prototype.includes||I(Array.prototype,"includes",function(m,h){return this.indexOf(m,h)!=-1}),Array.prototype.fill||I(Array.prototype,"fill",function(m){for(var h=this.length>>>0,l=arguments[1]>>0,a=l<0?Math.max(h+l,0):Math.min(l,h),l=arguments[2],l=l===void 0?h:l>>0,t=l<0?Math.max(h+l,0):Math.min(l,h);a<t;)this[a]=m,a++;return this}),Array.of||I(Array,"of",function(){return Array.prototype.slice.call(arguments)})}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/es6-shim"],function(A,f,T){A("./es6-shim")}),ace.define("ace/lib/lang",["require","exports","module"],function(A,f,T){f.last=function(h){return h[h.length-1]},f.stringReverse=function(h){return h.split("").reverse().join("")},f.stringRepeat=function(h,a){for(var l="";0<a;)1&a&&(l+=h),(a>>=1)&&(h+=h);return l};var I=/^\s\s*/,m=/\s\s*$/;f.stringTrimLeft=function(h){return h.replace(I,"")},f.stringTrimRight=function(h){return h.replace(m,"")},f.copyObject=function(h){var a,l={};for(a in h)l[a]=h[a];return l},f.copyArray=function(h){for(var a=[],l=0,t=h.length;l<t;l++)h[l]&&typeof h[l]=="object"?a[l]=this.copyObject(h[l]):a[l]=h[l];return a},f.deepCopy=function h(a){if(typeof a!="object"||!a)return a;if(Array.isArray(a))for(var l=[],t=0;t<a.length;t++)l[t]=h(a[t]);else{if(Object.prototype.toString.call(a)!=="[object Object]")return a;for(var t in l={},a)l[t]=h(a[t])}return l},f.arrayToMap=function(h){for(var a={},l=0;l<h.length;l++)a[h[l]]=1;return a},f.createMap=function(h){var a,l=Object.create(null);for(a in h)l[a]=h[a];return l},f.arrayRemove=function(h,a){for(var l=0;l<=h.length;l++)a===h[l]&&h.splice(l,1)},f.escapeRegExp=function(h){return h.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},f.escapeHTML=function(h){return(""+h).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},f.getMatchOffsets=function(h,a){var l=[];return h.replace(a,function(t){l.push({offset:arguments[arguments.length-2],length:t.length})}),l},f.deferredCall=function(h){function a(){t=null,h()}function l(r){return l.cancel(),t=setTimeout(a,r||0),l}var t=null;return(l.schedule=l).call=function(){return this.cancel(),h(),l},l.cancel=function(){return clearTimeout(t),t=null,l},l.isPending=function(){return t},l},f.delayedCall=function(h,a){function l(){r=null,h()}function t(e){r==null&&(r=setTimeout(l,e||a))}var r=null;return t.delay=function(e){r&&clearTimeout(r),r=setTimeout(l,e||a)},(t.schedule=t).call=function(){this.cancel(),h()},t.cancel=function(){r&&clearTimeout(r),r=null},t.isPending=function(){return r},t}}),ace.define("ace/lib/useragent",["require","exports","module"],function(A,f,T){f.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},f.getOS=function(){return f.isMac?f.OS.MAC:f.isLinux?f.OS.LINUX:f.OS.WINDOWS};var h=typeof navigator=="object"?navigator:{},I=(/mac|win|linux/i.exec(h.platform)||["other"])[0].toLowerCase(),m=h.userAgent||"",h=h.appName||"";f.isWin=I=="win",f.isMac=I=="mac",f.isLinux=I=="linux",f.isIE=h=="Microsoft Internet Explorer"||0<=h.indexOf("MSAppHost")?parseFloat((m.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((m.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),f.isOldIE=f.isIE&&f.isIE<9,f.isGecko=f.isMozilla=m.match(/ Gecko\/\d+/),f.isOpera=typeof opera=="object"&&Object.prototype.toString.call(window.opera)=="[object Opera]",f.isWebKit=parseFloat(m.split("WebKit/")[1])||void 0,f.isChrome=parseFloat(m.split(" Chrome/")[1])||void 0,f.isEdge=parseFloat(m.split(" Edge/")[1])||void 0,f.isAIR=0<=m.indexOf("AdobeAIR"),f.isAndroid=0<=m.indexOf("Android"),f.isChromeOS=0<=m.indexOf(" CrOS "),f.isIOS=/iPad|iPhone|iPod/.test(m)&&!window.MSStream,f.isIOS&&(f.isMac=!0),f.isMobile=f.isIOS||f.isAndroid}),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(h,f,T){var I,m,h=h("./useragent"),a=(f.buildDom=function r(e,n,s){if(typeof e=="string"&&e)return p=document.createTextNode(e),n&&n.appendChild(p),p;if(!Array.isArray(e))return e&&e.appendChild&&n&&n.appendChild(e),e;if(typeof e[0]!="string"||!e[0]){for(var o=[],i=0;i<e.length;i++){var c=r(e[i],n,s);c&&o.push(c)}return o}for(var d=document.createElement(e[0]),C=e[1],p=1,i=p=C&&typeof C=="object"&&!Array.isArray(C)?2:p;i<e.length;i++)r(e[i],d,s);return p==2&&Object.keys(C).forEach(function(w){var x=C[w];w==="class"?d.className=Array.isArray(x)?x.join(" "):x:typeof x=="function"||w=="value"||w[0]=="$"?d[w]=x:w==="ref"?s&&(s[x]=d):w==="style"?typeof x=="string"&&(d.style.cssText=x):x!=null&&d.setAttribute(w,x)}),n&&n.appendChild(d),d},f.getDocumentHead=function(r){return(r=r||document).head||r.getElementsByTagName("head")[0]||r.documentElement},f.createElement=function(r,e){return document.createElementNS?document.createElementNS(e||"http://www.w3.org/1999/xhtml",r):document.createElement(r)},f.removeChildren=function(r){r.innerHTML=""},f.createTextNode=function(r,e){return(e?e.ownerDocument:document).createTextNode(r)},f.createFragment=function(r){return(r?r.ownerDocument:document).createDocumentFragment()},f.hasCssClass=function(r,e){return(r.className+"").split(/\s+/g).indexOf(e)!==-1},f.addCssClass=function(r,e){f.hasCssClass(r,e)||(r.className+=" "+e)},f.removeCssClass=function(r,e){for(var n=r.className.split(/\s+/g);;){var s=n.indexOf(e);if(s==-1)break;n.splice(s,1)}r.className=n.join(" ")},f.toggleCssClass=function(r,e){for(var n=r.className.split(/\s+/g),s=!0;;){var o=n.indexOf(e);if(o==-1)break;s=!1,n.splice(o,1)}return s&&n.push(e),r.className=n.join(" "),s},f.setCssClass=function(r,e,n){n?f.addCssClass(r,e):f.removeCssClass(r,e)},f.hasCssString=function(r,e){var n,s=0;if(n=(e=e||document).querySelectorAll("style")){for(;s<n.length;)if(n[s++].id===r)return!0}},f.removeElementById=function(r,e){(e=e||document).getElementById(r)&&e.getElementById(r).remove()},[]);function l(){var r=a;a=null,r&&r.forEach(function(e){t(e[0],e[1])})}function t(r,e,n){if(typeof document<"u"){if(a){if(n)l();else if(n===!1)return a.push([r,e])}if(!I){var s=n,n=(s=n&&n.getRootNode&&(s=n.getRootNode())&&s!=n?s:document).ownerDocument||s;if(e&&f.hasCssString(e,s))return null;e&&(r+=`
/*# sourceURL=ace/css/`+e+" */");var o=f.createElement("style");o.appendChild(n.createTextNode(r)),e&&(o.id=e),(s=s==n?f.getDocumentHead(n):s).insertBefore(o,s.firstChild)}}}f.useStrictCSP=function(r){(I=r)==0?l():a=a||[]},f.importCssString=t,f.importCssStylsheet=function(r,e){f.buildDom(["link",{rel:"stylesheet",href:r}],f.getDocumentHead(e))},f.scrollbarWidth=function(s){var e=f.createElement("ace_inner"),n=(e.style.width="100%",e.style.minWidth="0px",e.style.height="200px",e.style.display="block",f.createElement("ace_outer")),i=n.style,s=(i.position="absolute",i.left="-10000px",i.overflow="hidden",i.width="200px",i.minWidth="0px",i.height="150px",i.display="block",n.appendChild(e),s&&s.documentElement||document&&document.documentElement);if(!s)return 0;s.appendChild(n);var o=e.offsetWidth,i=(i.overflow="scroll",e.offsetWidth);return o===i&&(i=n.clientWidth),s.removeChild(n),o-i},f.computedStyle=function(r,e){return window.getComputedStyle(r,"")||{}},f.setStyle=function(r,e,n){r[e]!==n&&(r[e]=n)},f.HAS_CSS_ANIMATION=!1,f.HAS_CSS_TRANSFORMS=!1,f.HI_DPI=!h.isWin||typeof window<"u"&&1.5<=window.devicePixelRatio,h.isChromeOS&&(f.HI_DPI=!1),typeof document<"u"&&(m=document.createElement("div"),f.HI_DPI&&m.style.transform!==void 0&&(f.HAS_CSS_TRANSFORMS=!0),h.isEdge||m.style.animationName===void 0||(f.HAS_CSS_ANIMATION=!0),m=null),f.HAS_CSS_TRANSFORMS?f.translate=function(r,e,n){r.style.transform="translate("+Math.round(e)+"px, "+Math.round(n)+"px)"}:f.translate=function(r,e,n){r.style.top=Math.round(n)+"px",r.style.left=Math.round(e)+"px"}}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(A,f,T){var I=A("./dom");f.get=function(m,h){var a=new XMLHttpRequest;a.open("GET",m,!0),a.onreadystatechange=function(){a.readyState===4&&h(a.responseText)},a.send(null)},f.loadScript=function(m,h){var a=I.getDocumentHead(),l=document.createElement("script");l.src=m,a.appendChild(l),l.onload=l.onreadystatechange=function(t,r){!r&&l.readyState&&l.readyState!="loaded"&&l.readyState!="complete"||(l=l.onload=l.onreadystatechange=null,r)||h()}},f.qualifyURL=function(m){var h=document.createElement("a");return h.href=m,h.href}}),ace.define("ace/lib/oop",["require","exports","module"],function(A,f,T){f.inherits=function(I,m){I.super_=m,I.prototype=Object.create(m.prototype,{constructor:{value:I,enumerable:!1,writable:!0,configurable:!0}})},f.mixin=function(I,m){for(var h in m)I[h]=m[h];return I},f.implement=function(I,m){f.mixin(I,m)}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(A,f,T){function I(){this.propagationStopped=!0}function m(){this.defaultPrevented=!0}var h={};h._emit=h._dispatchEvent=function(a,l){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var t=this._eventRegistry[a]||[],r=this._defaultHandlers[a];if(t.length||r){(l=typeof l=="object"&&l?l:{}).type||(l.type=a),l.stopPropagation||(l.stopPropagation=I),l.preventDefault||(l.preventDefault=m);for(var t=t.slice(),e=0;e<t.length&&(t[e](l,this),!l.propagationStopped);e++);return r&&!l.defaultPrevented?r(l,this):void 0}},h._signal=function(a,l){if(t=(this._eventRegistry||{})[a])for(var t=t.slice(),r=0;r<t.length;r++)t[r](l,this)},h.once=function(a,l){var t=this;if(this.on(a,function r(){t.off(a,r),l.apply(null,arguments)}),!l)return new Promise(function(r){l=r})},h.setDefaultHandler=function(a,l){var t,r,e=this._defaultHandlers;(e=e||(this._defaultHandlers={_disabled_:{}}))[a]&&(r=e[a],(t=e._disabled_[a])||(e._disabled_[a]=t=[]),t.push(r),(r=t.indexOf(l))!=-1)&&t.splice(r,1),e[a]=l},h.removeDefaultHandler=function(a,l){var t,r=this._defaultHandlers;r&&(t=r._disabled_[a],r[a]==l?t&&this.setDefaultHandler(a,t.pop()):t&&(r=t.indexOf(l))!=-1&&t.splice(r,1))},h.on=h.addEventListener=function(a,l,t){this._eventRegistry=this._eventRegistry||{};var r=this._eventRegistry[a];return(r=r||(this._eventRegistry[a]=[])).indexOf(l)==-1&&r[t?"unshift":"push"](l),l},h.off=h.removeListener=h.removeEventListener=function(a,l){this._eventRegistry=this._eventRegistry||{},a=this._eventRegistry[a],a&&(l=a.indexOf(l))!==-1&&a.splice(l,1)},h.removeAllListeners=function(a){a||(this._eventRegistry=this._defaultHandlers=void 0),this._eventRegistry&&(this._eventRegistry[a]=void 0),this._defaultHandlers&&(this._defaultHandlers[a]=void 0)},f.EventEmitter=h}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(h,f,T){var I,m=h("./oop"),h=h("./event_emitter").EventEmitter,a={setOptions:function(e){Object.keys(e).forEach(function(n){this.setOption(n,e[n])},this)},getOptions:function(e){var n,s={};return e?Array.isArray(e)||(s=e,e=Object.keys(s)):(n=this.$options,e=Object.keys(n).filter(function(o){return!n[o].hidden})),e.forEach(function(o){s[o]=this.getOption(o)},this),s},setOption:function(e,n){var s;if(this["$"+e]!==n)return(s=this.$options[e])?s.forwardTo?this[s.forwardTo]&&this[s.forwardTo].setOption(e,n):(s.handlesSet||(this["$"+e]=n),void(s&&s.set&&s.set.call(this,n))):l('misspelled option "'+e+'"')},getOption:function(e){var n=this.$options[e];return n?n.forwardTo?this[n.forwardTo]&&this[n.forwardTo].getOption(e):n&&n.get?n.get.call(this):this["$"+e]:l('misspelled option "'+e+'"')}};function l(e){typeof console<"u"&&console.warn&&console.warn.apply(console,arguments)}r.prototype.defineOptions=function(e,n,s){return e.$options||(this.$defaultOptions[n]=e.$options={}),Object.keys(s).forEach(function(o){var i=s[o];(i=typeof i=="string"?{forwardTo:i}:i).name||(i.name=o),"initialValue"in(e.$options[i.name]=i)&&(e["$"+i.name]=i.initialValue)}),m.implement(e,a),this},r.prototype.resetOptions=function(e){Object.keys(e.$options).forEach(function(n){var s=e.$options[n];"value"in s&&e.setOption(n,s.value)})},r.prototype.setDefaultValue=function(e,n,s){if(!e){for(e in this.$defaultOptions)if(this.$defaultOptions[e][n])break;if(!this.$defaultOptions[e][n])return!1}var o=this.$defaultOptions[e]||(this.$defaultOptions[e]={});o[n]&&(o.forwardTo?this.setDefaultValue(o.forwardTo,n,s):o[n].value=s)},r.prototype.setDefaultValues=function(e,n){Object.keys(n).forEach(function(s){this.setDefaultValue(e,s,n[s])},this)},r.prototype.setMessages=function(e){I=e},r.prototype.nls=function(e,n){return e=I&&I[e]||e,e=n?e.replace(/\$(\$|[\d]+)/g,function(s,o){return o=="$"?"$":n[o]}):e};var t=r;function r(){this.$defaultOptions={}}t.prototype.warn=l,t.prototype.reportError=function(e,n){var s=new Error(e);s.data=n,typeof console=="object"&&console.error&&console.error(s),setTimeout(function(){throw s})},m.implement(t.prototype,h),f.AppConfig=t}),ace.define("ace/theme/textmate.css",["require","exports","module"],function(A,f,T){T.exports=`.ace-tm .ace_gutter {
  background: #f0f0f0;
  color: #333;
}

.ace-tm .ace_print-margin {
  width: 1px;
  background: #e8e8e8;
}

.ace-tm .ace_fold {
    background-color: #6B72E6;
}

.ace-tm {
  background-color: #FFFFFF;
  color: black;
}

.ace-tm .ace_cursor {
  color: black;
}
        
.ace-tm .ace_invisible {
  color: rgb(191, 191, 191);
}

.ace-tm .ace_storage,
.ace-tm .ace_keyword {
  color: blue;
}

.ace-tm .ace_constant {
  color: rgb(197, 6, 11);
}

.ace-tm .ace_constant.ace_buildin {
  color: rgb(88, 72, 246);
}

.ace-tm .ace_constant.ace_language {
  color: rgb(88, 92, 246);
}

.ace-tm .ace_constant.ace_library {
  color: rgb(6, 150, 14);
}

.ace-tm .ace_invalid {
  background-color: rgba(255, 0, 0, 0.1);
  color: red;
}

.ace-tm .ace_support.ace_function {
  color: rgb(60, 76, 114);
}

.ace-tm .ace_support.ace_constant {
  color: rgb(6, 150, 14);
}

.ace-tm .ace_support.ace_type,
.ace-tm .ace_support.ace_class {
  color: rgb(109, 121, 222);
}

.ace-tm .ace_keyword.ace_operator {
  color: rgb(104, 118, 135);
}

.ace-tm .ace_string {
  color: rgb(3, 106, 7);
}

.ace-tm .ace_comment {
  color: rgb(76, 136, 107);
}

.ace-tm .ace_comment.ace_doc {
  color: rgb(0, 102, 255);
}

.ace-tm .ace_comment.ace_doc.ace_tag {
  color: rgb(128, 159, 191);
}

.ace-tm .ace_constant.ace_numeric {
  color: rgb(0, 0, 205);
}

.ace-tm .ace_variable {
  color: rgb(49, 132, 149);
}

.ace-tm .ace_xml-pe {
  color: rgb(104, 104, 91);
}

.ace-tm .ace_entity.ace_name.ace_function {
  color: #0000A2;
}


.ace-tm .ace_heading {
  color: rgb(12, 7, 255);
}

.ace-tm .ace_list {
  color:rgb(185, 6, 144);
}

.ace-tm .ace_meta.ace_tag {
  color:rgb(0, 22, 142);
}

.ace-tm .ace_string.ace_regex {
  color: rgb(255, 0, 0)
}

.ace-tm .ace_marker-layer .ace_selection {
  background: rgb(181, 213, 255);
}
.ace-tm.ace_multiselect .ace_selection.ace_start {
  box-shadow: 0 0 3px 0px white;
}
.ace-tm .ace_marker-layer .ace_step {
  background: rgb(252, 255, 0);
}

.ace-tm .ace_marker-layer .ace_stack {
  background: rgb(164, 229, 101);
}

.ace-tm .ace_marker-layer .ace_bracket {
  margin: -1px 0 0 -1px;
  border: 1px solid rgb(192, 192, 192);
}

.ace-tm .ace_marker-layer .ace_active-line {
  background: rgba(0, 0, 0, 0.07);
}

.ace-tm .ace_gutter-active-line {
    background-color : #dcdcdc;
}

.ace-tm .ace_marker-layer .ace_selected-word {
  background: rgb(250, 250, 255);
  border: 1px solid rgb(200, 200, 250);
}

.ace-tm .ace_indent-guide {
  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;
}

.ace-tm .ace_indent-guide-active {
  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAAZSURBVHjaYvj///9/hivKyv8BAAAA//8DACLqBhbvk+/eAAAAAElFTkSuQmCC") right repeat-y;
}
`}),ace.define("ace/theme/textmate",["require","exports","module","ace/theme/textmate.css","ace/lib/dom"],function(A,f,T){f.isDark=!1,f.cssClass="ace-tm",f.cssText=A("./textmate.css"),f.$id="ace/theme/textmate",A("../lib/dom").importCssString(f.cssText,f.cssClass,!1)}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/net","ace/lib/dom","ace/lib/app_config","ace/theme/textmate"],function(A,f,T){var I=A("./lib/lang"),m=A("./lib/net"),h=A("./lib/dom"),a=A("./lib/app_config").AppConfig,l=(T.exports=f=new a,{packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1,useStrictCSP:null}),t=(f.get=function(e){if(l.hasOwnProperty(e))return l[e];throw new Error("Unknown config key: "+e)},f.set=function(e,n){if(l.hasOwnProperty(e))l[e]=n;else if(this.setDefaultValue("",e,n)==0)throw new Error("Unknown config key: "+e);e=="useStrictCSP"&&h.useStrictCSP(n)},f.all=function(){return I.copyObject(l)},f.$modes={},f.moduleUrl=function(e,n){var s,o,i;return l.$moduleUrls[e]||(e=e.split("/"),s=(n=n||e[e.length-2]||"")=="snippets"?"/":"-",o=e[e.length-1],n=="worker"&&s=="-"&&(i=new RegExp("^"+n+"[\\-_]|[\\-_]"+n+"$","g"),o=o.replace(i,"")),(!o||o==n)&&1<e.length&&(o=e[e.length-2]),(i=l[n+"Path"])==null?i=l.basePath:s=="/"&&(n=s=""),i&&i.slice(-1)!="/"&&(i+="/"),i+n+s+o+this.get("suffix"))},f.setModuleUrl=function(e,n){return l.$moduleUrls[e]=n},function(e,n){return e==="ace/theme/textmate"||e==="./theme/textmate"?n(null,A("./theme/textmate")):console.error("loader is not configured")}),r=(f.setLoader=function(e){t=e},f.dynamicModules=Object.create(null),f.$loading={},f.loadModule=function(e,n){function s(c){if(c&&!f.$loading[e])return n&&n(c);if(f.$loading[e]||(f.$loading[e]=[]),f.$loading[e].push(n),!(1<f.$loading[e].length)){let d=function(){t(e,function(C,p){f._emit("load.module",{name:e,module:p});var w=f.$loading[e];f.$loading[e]=null,w.forEach(function(x){x&&x(p)})})};if(!f.get("packaged"))return d();m.loadScript(f.moduleUrl(e,i),d),r()}}var o,i;if(Array.isArray(e)&&(i=e[0],e=e[1]),f.dynamicModules[e])f.dynamicModules[e]().then(function(c){c.default?s(c.default):s(c)});else{try{o=A(e)}catch{}s(o)}},f.setModuleLoader=function(e,n){f.dynamicModules[e]=n},function(){l.basePath||l.workerPath||l.modePath||l.themePath||Object.keys(l.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),r=function(){})});f.version="1.20.0"}),ace.define("ace/loader_build",["require","exports","module","ace/lib/fixoldbrowsers","ace/config"],function(A,f,T){A("./lib/fixoldbrowsers");var I=A("./config"),m=(I.setLoader(function(a,l){A([a],function(t){l(null,t)})}),function(){return this||typeof window<"u"&&window}());function h(a){if(m&&m.document){I.set("packaged",a||A.packaged||T.packaged||m.define&&D.amdD.packaged);for(var l,t={},r="",a=document.currentScript||document._currentScript,e=a&&a.ownerDocument||document,n=(a&&a.src&&(r=a.src.split(/[?#]/)[0].split("/").slice(0,-1).join("/")||""),e.getElementsByTagName("script")),s=0;s<n.length;s++){var o=n[s],i=o.src||o.getAttribute("src");if(i){for(var c=o.attributes,d=0,C=c.length;d<C;d++){var p=c[d];p.name.indexOf("data-ace-")===0&&(t[p.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(x,$){return $.toUpperCase()})]=p.value)}o=i.match(/^(.*)\/ace([\-.]\w+)?\.js(\?|$)/),o&&(r=o[1])}}for(l in r&&(t.base=t.base||r,t.packaged=!0),t.basePath=t.base,t.workerPath=t.workerPath||t.base,t.modePath=t.modePath||t.base,t.themePath=t.themePath||t.base,delete t.base,t)t[l]!==void 0&&I.set(l,t[l])}}T.exports=function(a){I.init=h,a.require=A,a.define=D.amdD},h(!0)}),ace.define("ace/range",["require","exports","module"],function(A,f,T){m.prototype.isEqual=function(h){return this.start.row===h.start.row&&this.end.row===h.end.row&&this.start.column===h.start.column&&this.end.column===h.end.column},m.prototype.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},m.prototype.contains=function(h,a){return this.compare(h,a)==0},m.prototype.compareRange=function(a){var l=a.end,a=a.start,l=this.compare(l.row,l.column);return l==1?(l=this.compare(a.row,a.column))==1?2:l==0?1:0:l==-1?-2:(l=this.compare(a.row,a.column))==-1?-1:l==1?42:0},m.prototype.comparePoint=function(h){return this.compare(h.row,h.column)},m.prototype.containsRange=function(h){return this.comparePoint(h.start)==0&&this.comparePoint(h.end)==0},m.prototype.intersects=function(h){return h=this.compareRange(h),h==-1||h==0||h==1},m.prototype.isEnd=function(h,a){return this.end.row==h&&this.end.column==a},m.prototype.isStart=function(h,a){return this.start.row==h&&this.start.column==a},m.prototype.setStart=function(h,a){typeof h=="object"?(this.start.column=h.column,this.start.row=h.row):(this.start.row=h,this.start.column=a)},m.prototype.setEnd=function(h,a){typeof h=="object"?(this.end.column=h.column,this.end.row=h.row):(this.end.row=h,this.end.column=a)},m.prototype.inside=function(h,a){return this.compare(h,a)==0&&!this.isEnd(h,a)&&!this.isStart(h,a)},m.prototype.insideStart=function(h,a){return this.compare(h,a)==0&&!this.isEnd(h,a)},m.prototype.insideEnd=function(h,a){return this.compare(h,a)==0&&!this.isStart(h,a)},m.prototype.compare=function(h,a){return this.isMultiLine()||h!==this.start.row?h<this.start.row?-1:h>this.end.row?1:this.start.row===h?a>=this.start.column?0:-1:this.end.row!==h||a<=this.end.column?0:1:a<this.start.column?-1:a>this.end.column?1:0},m.prototype.compareStart=function(h,a){return this.start.row==h&&this.start.column==a?-1:this.compare(h,a)},m.prototype.compareEnd=function(h,a){return this.end.row==h&&this.end.column==a?1:this.compare(h,a)},m.prototype.compareInside=function(h,a){return this.end.row==h&&this.end.column==a?1:this.start.row==h&&this.start.column==a?-1:this.compare(h,a)},m.prototype.clipRows=function(h,a){var l,t;return this.end.row>a?l={row:a+1,column:0}:this.end.row<h&&(l={row:h,column:0}),this.start.row>a?t={row:a+1,column:0}:this.start.row<h&&(t={row:h,column:0}),m.fromPoints(t||this.start,l||this.end)},m.prototype.extend=function(h,a){var l,t,r=this.compare(h,a);return r==0?this:(r==-1?l={row:h,column:a}:t={row:h,column:a},m.fromPoints(l||this.start,t||this.end))},m.prototype.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},m.prototype.isMultiLine=function(){return this.start.row!==this.end.row},m.prototype.clone=function(){return m.fromPoints(this.start,this.end)},m.prototype.collapseRows=function(){return this.end.column==0?new m(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new m(this.start.row,0,this.end.row,0)},m.prototype.toScreenRange=function(l){var a=l.documentToScreenPosition(this.start),l=l.documentToScreenPosition(this.end);return new m(a.row,a.column,l.row,l.column)},m.prototype.moveBy=function(h,a){this.start.row+=h,this.start.column+=a,this.end.row+=h,this.end.column+=a};var I=m;function m(h,a,l,t){this.start={row:h,column:a},this.end={row:l,column:t}}I.fromPoints=function(h,a){return new I(h.row,h.column,a.row,a.column)},I.comparePoints=function(h,a){return h.row-a.row||h.column-a.column},I.comparePoints=function(h,a){return h.row-a.row||h.column-a.column},f.Range=I}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(A,f,T){var I=A("./oop"),m=function(){var h,a,l={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8,control:1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(a in l.PRINTABLE_KEYS[173]="-",l.FUNCTION_KEYS)h=l.FUNCTION_KEYS[a].toLowerCase(),l[h]=parseInt(a,10);for(a in l.PRINTABLE_KEYS)h=l.PRINTABLE_KEYS[a].toLowerCase(),l[h]=parseInt(a,10);I.mixin(l,l.MODIFIER_KEYS),I.mixin(l,l.PRINTABLE_KEYS),I.mixin(l,l.FUNCTION_KEYS),l.enter=l.return,l.escape=l.esc,l.del=l.delete;for(var t=["cmd","ctrl","alt","shift"],r=Math.pow(2,t.length);r--;)l.KEY_MODS[r]=t.filter(function(e){return r&l.KEY_MODS[e]}).join("-")+"-";return l.KEY_MODS[0]="",l.KEY_MODS[-1]="input-",l}();I.mixin(f,m),f.keyCodeToString=function(h){var a=m[h];return(a=typeof a!="string"?String.fromCharCode(h):a).toLowerCase()}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(A,f,T){var I,m=A("./keys"),h=A("./useragent"),a=null,l=0;function t(){if(I==null){I=!1;try{document.createComment("").addEventListener("test",function(){},{get passive(){I={passive:!1}}})}catch{}}return I}function r(d,C,p){this.elem=d,this.type=C,this.callback=p}r.prototype.destroy=function(){o(this.elem,this.type,this.callback),this.elem=this.type=this.callback=void 0};function e(d){return 0|(d.ctrlKey?1:0)|(d.altKey?2:0)|(d.shiftKey?4:0)|(d.metaKey?8:0)}var n,s=f.addListener=function(d,C,p,w){d.addEventListener(C,p,t()),w&&w.$toDestroy.push(new r(d,C,p))},o=f.removeListener=function(d,C,p){d.removeEventListener(C,p,t())};f.stopEvent=function(d){return f.stopPropagation(d),f.preventDefault(d),!1},f.stopPropagation=function(d){d.stopPropagation&&d.stopPropagation()},f.preventDefault=function(d){d.preventDefault&&d.preventDefault()},f.getButton=function(d){return d.type=="dblclick"?0:d.type=="contextmenu"||h.isMac&&d.ctrlKey&&!d.altKey&&!d.shiftKey?2:d.button},f.capture=function(d,C,p){var w=d&&d.ownerDocument||document;function x($){C&&C($),p&&p($),o(w,"mousemove",C),o(w,"mouseup",x),o(w,"dragstart",x)}return s(w,"mousemove",C),s(w,"mouseup",x),s(w,"dragstart",x),x},f.addMouseWheelListener=function(d,C,p){s(d,"wheel",function(w){var x=w.deltaX||0,$=w.deltaY||0;switch(w.deltaMode){case w.DOM_DELTA_PIXEL:w.wheelX=.15*x,w.wheelY=.15*$;break;case w.DOM_DELTA_LINE:w.wheelX=15*x,w.wheelY=15*$;break;case w.DOM_DELTA_PAGE:w.wheelX=150*x,w.wheelY=150*$}C(w)},p)},f.addMultiMouseDownListener=function(d,C,p,w,x){var $,P,B,Z=0,u={2:"dblclick",3:"tripleclick",4:"quadclick"};function v(N){var y;if(f.getButton(N)!==0?Z=0:1<N.detail&&!(4<++Z)||(Z=1),h.isIE&&(y=5<Math.abs(N.clientX-$)||5<Math.abs(N.clientY-P),B&&!y||(Z=1),B&&clearTimeout(B),B=setTimeout(function(){B=null},C[Z-1]||600),Z==1)&&($=N.clientX,P=N.clientY),N._clicks=Z,p[w]("mousedown",N),4<Z)Z=0;else if(1<Z)return p[w](u[Z],N)}(d=Array.isArray(d)?d:[d]).forEach(function(N){s(N,"mousedown",v,x)})};function i(d,C,p){var w=e(C);if(!h.isMac&&a){if(C.getModifierState&&(C.getModifierState("OS")||C.getModifierState("Win"))&&(w|=8),a.altGr){if((3&w)==3)return;a.altGr=0}p!==18&&p!==17||(x="location"in C?C.location:C.keyLocation,p===17&&x===1?a[p]==1&&(l=C.timeStamp):p===18&&w===3&&x===2&&C.timeStamp-l<50&&(a.altGr=!0))}if(p in m.MODIFIER_KEYS&&(p=-1),!w&&p===13){var x="location"in C?C.location:C.keyLocation;if(x===3&&(d(C,w,-p),C.defaultPrevented))return}if(h.isChromeOS&&8&w){if(d(C,w,p),C.defaultPrevented)return;w&=-9}return!!(w||p in m.FUNCTION_KEYS||p in m.PRINTABLE_KEYS)&&d(C,w,p)}function c(){a=Object.create(null)}f.getModifierString=function(d){return m.KEY_MODS[e(d)]},f.addCommandKeyListener=function(d,C,p){var w,x;h.isOldGecko||h.isOpera&&!("KeyboardEvent"in window)?(w=null,s(d,"keydown",function($){w=$.keyCode},p),s(d,"keypress",function($){return i(C,$,w)},p)):(x=null,s(d,"keydown",function($){a[$.keyCode]=(a[$.keyCode]||0)+1;var P=i(C,$,$.keyCode);return x=$.defaultPrevented,P},p),s(d,"keypress",function($){x&&($.ctrlKey||$.altKey||$.shiftKey||$.metaKey)&&(f.stopEvent($),x=null)},p),s(d,"keyup",function($){a[$.keyCode]=null},p),a||(c(),s(window,"focus",c)))},typeof window=="object"&&window.postMessage&&!h.isOldIE&&(n=1,f.nextTick=function(d,C){C=C||window;function p(x){x.data==w&&(f.stopPropagation(x),o(C,"message",p),d())}var w="zero-timeout-message-"+n++;s(C,"message",p),C.postMessage(w,"*")}),f.$idleBlocked=!1,f.onIdle=function(d,C){return setTimeout(function p(){f.$idleBlocked?setTimeout(p,100):d()},C)},f.$idleBlockId=null,f.blockIdle=function(d){f.$idleBlockId&&clearTimeout(f.$idleBlockId),f.$idleBlocked=!0,f.$idleBlockId=setTimeout(function(){f.$idleBlocked=!1},d||100)},f.nextFrame=typeof window=="object"&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),f.nextFrame?f.nextFrame=f.nextFrame.bind(window):f.nextFrame=function(d){setTimeout(d,17)}}),ace.define("ace/clipboard",["require","exports","module"],function(A,f,T){var I;T.exports={lineMode:!1,pasteCancelled:function(){return!!(I&&I>Date.now()-50)||(I=!1)},cancel:function(){I=Date.now()}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/config","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],function(A,f,T){var I=A("../lib/event"),m=A("../config").nls,h=A("../lib/useragent"),a=A("../lib/dom"),l=A("../lib/lang"),t=A("../clipboard"),r=h.isChrome<18,e=h.isIE,n=63<h.isChrome,s=A("../lib/keys"),o=s.KEY_MODS,i=h.isIOS,c=i?/\s/:/\n/,d=h.isMobile;f.TextInput=function(C,p){var w=a.createElement("textarea"),x=(w.className="ace_text-input",w.setAttribute("wrap","off"),w.setAttribute("autocorrect","off"),w.setAttribute("autocapitalize","off"),w.setAttribute("spellcheck",!1),w.style.opacity="0",C.insertBefore(w,C.firstChild),!1),$=!1,P=!1,B=!1,Z="",u=(d||(w.style.fontSize="1px"),!1),v=!1,N="",y=0,_=0,W=0;try{var F=document.activeElement===w}catch{}this.setAriaOptions=function(le){le.activeDescendant?(w.setAttribute("aria-haspopup","true"),w.setAttribute("aria-autocomplete",le.inline?"both":"list"),w.setAttribute("aria-activedescendant",le.activeDescendant)):(w.setAttribute("aria-haspopup","false"),w.setAttribute("aria-autocomplete","both"),w.removeAttribute("aria-activedescendant")),le.role&&w.setAttribute("role",le.role)},this.setAriaLabel=function(){var le;p.session&&p.renderer.enableKeyboardAccessibility?(le=p.session.selection.cursor.row,w.setAttribute("aria-roledescription",m("editor")),w.setAttribute("aria-label",m("Cursor at row $0",[le+1]))):(w.removeAttribute("aria-roledescription"),w.removeAttribute("aria-label"))},this.setAriaOptions({role:"textbox"}),this.setAriaLabel(),I.addListener(w,"blur",function(le){v||(p.onBlur(le),F=!1,d&&!i&&document.removeEventListener("selectionchange",z))},p),I.addListener(w,"focus",function(le){if(!v){if(F=!0,h.isEdge)try{if(!document.hasFocus())return}catch{}p.onFocus(le),h.isEdge?setTimeout(Y):Y(),d&&!i&&document.addEventListener("selectionchange",z)}},p),this.$focusScroll=!1,this.focus=function(){if(this.setAriaLabel(),Z||n||this.$focusScroll=="browser")return w.focus({preventScroll:!0});var le=w.style.top;w.style.position="fixed",w.style.top="0px";try{var fe=w.getBoundingClientRect().top!=0}catch{return}var be=[];if(fe)for(var ve=w.parentElement;ve&&ve.nodeType==1;)be.push(ve),ve.setAttribute("ace_nocontext",!0),ve=!ve.parentElement&&ve.getRootNode?ve.getRootNode().host:ve.parentElement;w.focus({preventScroll:!0}),fe&&be.forEach(function(ne){ne.removeAttribute("ace_nocontext")}),setTimeout(function(){w.style.position="",w.style.top=="0px"&&(w.style.top=le)},0)},this.blur=function(){w.blur()},this.isFocused=function(){return F},p.on("beforeEndOperation",function(){var le=p.curOp,fe=le&&le.command&&le.command.name;fe!="insertstring"&&(fe=fe&&(le.docChanged||le.selectionChanged),P&&fe&&(N=w.value="",pe()),Y())});var Y=i?function(le){var fe;!F||x&&!le||B||((fe=`
 ab`+(le=le||"")+`cde fg
`)!=w.value&&(w.value=N=fe),fe=4+(le.length||(p.selection.isEmpty()?0:1)),y==4&&_==fe||w.setSelectionRange(4,fe),y=4,_=fe)}:function(){if(!P&&!B&&(F||b)){P=!0;var le,fe,be=0,ve=0,ne="",ie=(p.session&&(ie=(le=p.selection).getRange(),le=le.cursor.row,be=ie.start.column,ve=ie.end.column,ne=p.session.getLine(le),ie.start.row!=le?(fe=p.session.getLine(le-1),be=ie.start.row<le-1?0:be,ve+=fe.length+1,ne=fe+`
`+ne):ie.end.row!=le?(fe=p.session.getLine(le+1),ve=ie.end.row>le+1?fe.length:ve,ve+=ne.length+1,ne=ne+`
`+fe):d&&0<le&&(ne=`
`+ne,ve+=1,be+=1),400<ne.length)&&(be<400&&ve<400?ne=ne.slice(0,400):(ne=`
`,be==ve?be=ve=0:(be=0,ve=1))),ne+`

`);if(ie!=N&&(w.value=N=ie,y=_=ie.length),b&&(y=w.selectionStart,_=w.selectionEnd),_!=ve||y!=be||w.selectionEnd!=_)try{w.setSelectionRange(be,ve),y=be,_=ve}catch{}P=!1}},Q=(this.resetSelection=Y,F&&p.onFocus(),function(le){return le.selectionStart===0&&le.selectionEnd>=N.length&&le.value===N&&N&&le.selectionEnd!==_});function z(le){if(w&&w.parentNode||document.removeEventListener("selectionchange",z),!P&&w.selectionStart===w.selectionEnd)for(var fe=w.selectionStart-y,be=_-y,ve=(0<fe?fe=Math.max(fe-be,1):fe===0&&be&&(fe=-1),Math.abs(fe)),ne=0<fe?s.right:s.left,ie=0;ie<ve;ie++)p.onCommandKey({},0,ne)}function te(le){J(le,!0)}function E(le){J(le,!1)}function H(le){var fe=O(le);t.pasteCancelled()||(typeof fe=="string"?(fe&&p.onPaste(fe,le),h.isIE&&setTimeout(Y),I.preventDefault(le)):(w.value="",$=!0))}var V=null,b=(this.setInputHandler=function(le){V=le},!(this.getInputHandler=function(){return V})),S=function(le,fe){if(b=b&&!1,$)return Y(),le&&p.onPaste(le),$=!1,"";for(var be=w.selectionStart,ve=w.selectionEnd,ne=y,ie=N.length-_,ge=le,Se=le.length-be,Le=le.length-ve,Be=0;0<ne&&N[Be]==le[Be];)Be++,ne--;for(ge=ge.slice(Be),Be=1;0<ie&&N.length-Be>y-1&&N[N.length-Be]==le[le.length-Be];)Be++,ie--;Se-=Be-1,Le-=Be-1;var ee=ge.length-Be+1;return ee<0&&(ne=-ee,ee=0),ge=ge.slice(0,ee),fe||ge||Se||ne||ie||Le?(ee=!(B=!0),h.isAndroid&&ge==". "&&(ge="  ",ee=!0),ge&&!ne&&!ie&&!Se&&!Le||u?p.onTextInput(ge):p.onTextInput(ge,{extendLeft:ne,extendRight:ie,restoreStart:Se,restoreEnd:Le}),B=!1,N=le,y=be,_=ve,W=Le,ee?`
`:ge):""},R=function(fe){if(P)return re();if(fe&&fe.inputType){if(fe.inputType=="historyUndo")return p.execCommand("undo");if(fe.inputType=="historyRedo")return p.execCommand("redo")}var fe=w.value,be=S(fe,!0);(500<fe.length||c.test(be)||d&&y<1&&y==_)&&Y()},O=function(le,fe,be){var ve=le.clipboardData||window.clipboardData;if(ve&&!r){var ne=e||be?"Text":"text/plain";try{return fe?ve.setData(ne,fe)!==!1:ve.getData(ne)}catch(ie){if(!be)return O(ie,fe,!0)}}},J=function(le,fe){var be=p.getCopyText();if(!be)return I.preventDefault(le);O(le,be)?(i&&(Y(be),x=be,setTimeout(function(){x=!1},10)),fe?p.onCut():p.onCopy(),I.preventDefault(le)):(x=!0,w.value=be,w.select(),setTimeout(function(){x=!1,Y(),fe?p.onCut():p.onCopy()}))},re=(I.addCommandKeyListener(w,p.onCommandKey.bind(p),p),I.addListener(w,"select",function(le){P||(x?x=!1:Q(w)?(p.selectAll(),Y()):d&&w.selectionStart!=y&&Y())},p),I.addListener(w,"input",R,p),I.addListener(w,"cut",te,p),I.addListener(w,"copy",E,p),I.addListener(w,"paste",H,p),"oncut"in w&&"oncopy"in w&&"onpaste"in w||I.addListener(C,"keydown",function(le){if((!h.isMac||le.metaKey)&&le.ctrlKey)switch(le.keyCode){case 67:E(le);break;case 86:H(le);break;case 88:te(le)}},p),function(){var le;if(P&&p.onCompositionUpdate&&!p.$readOnly)return u?me():void(P.useTextareaForIME?p.onCompositionUpdate(w.value):(le=w.value,S(le),P.markerRange&&(P.context&&(P.markerRange.start.column=P.selectionStart=P.context.compositionStartOffset),P.markerRange.end.column=P.markerRange.start.column+_-P.selectionStart+W)))}),pe=function(le){p.onCompositionEnd&&!p.$readOnly&&(P=!1,p.onCompositionEnd(),p.off("mousedown",me),le)&&R()};function me(){v=!0,w.blur(),w.focus(),v=!1}var ye,xe=l.delayedCall(re,50).schedule.bind(null,null);function Ie(){clearTimeout(ye),ye=setTimeout(function(){Z&&(w.style.cssText=Z,Z=""),p.renderer.$isMousePressed=!1,p.renderer.$keepTextAreaAtCursor&&p.renderer.$moveTextAreaToCursor()},0)}I.addListener(w,"compositionstart",function(le){P||!p.onCompositionStart||p.$readOnly||(P={},u)||(le.data&&(P.useTextareaForIME=!1),setTimeout(re,0),p._signal("compositionStart"),p.on("mousedown",me),(le=p.getSelectionRange()).end.row=le.start.row,le.end.column=le.start.column,P.markerRange=le,P.selectionStart=y,p.onCompositionStart(P),P.useTextareaForIME?(N=w.value="",_=y=0):(w.msGetInputContext&&(P.context=w.msGetInputContext()),w.getInputContext&&(P.context=w.getInputContext())))},p),I.addListener(w,"compositionupdate",re,p),I.addListener(w,"keyup",function(le){le.keyCode==27&&w.value.length<w.selectionStart&&(P||(N=w.value),y=_=-1,Y()),xe()},p),I.addListener(w,"keydown",xe,p),I.addListener(w,"compositionend",pe,p),this.getElement=function(){return w},this.setCommandMode=function(le){u=le,w.readOnly=!1},this.setReadOnly=function(le){u||(w.readOnly=le)},this.setCopyWithEmptySelection=function(le){},this.onContextMenu=function(le){b=!0,Y(),p._emit("nativecontextmenu",{target:p,domEvent:le}),this.moveToMouse(le,!0)},this.moveToMouse=function(le,ve){Z=Z||w.style.cssText,w.style.cssText=(ve?"z-index:100000;":"")+(h.isIE?"opacity:0.1;":"")+"text-indent: -"+(y+_)*p.renderer.characterWidth*.5+"px;";function be(Le){a.translate(w,Le.clientX-ge-2,Math.min(Le.clientY-ie-2,Se))}var ve=p.container.getBoundingClientRect(),ne=a.computedStyle(p.container),ie=ve.top+(parseInt(ne.borderTopWidth)||0),ge=ve.left+(parseInt(ve.borderLeftWidth)||0),Se=ve.bottom-ie-w.clientHeight-2;be(le),le.type=="mousedown"&&(p.renderer.$isMousePressed=!0,clearTimeout(ye),h.isWin)&&I.capture(p.container,be,Ie)},this.onContextMenuClose=Ie;function we(le){p.textInput.onContextMenu(le),Ie()}if(I.addListener(w,"mouseup",we,p),I.addListener(w,"mousedown",function(le){le.preventDefault(),Ie()},p),I.addListener(p.renderer.scroller,"contextmenu",we,p),I.addListener(w,"contextmenu",we,p),i){let le=function(fe){var be,ve,ne,ie;document.activeElement!==_e||ke||P||Ae.$mouseHandler.isMousePressed||x||(be=_e.selectionStart,ve=_e.selectionEnd,ne=null,(ie=0)==be?ne=s.up:be==1?ne=s.home:_<ve&&N[ve]==`
`?ne=s.end:be<y&&N[be-1]==" "?(ne=s.left,ie=o.option):be<y||be==y&&_!=y&&be==ve?ne=s.left:_<ve&&2<N.slice(0,ve).split(`
`).length?ne=s.down:_<ve&&N[ve-1]==" "?(ne=s.right,ie=o.option):(_<ve||ve==_&&_!=y&&be==ve)&&(ne=s.right),be!==ve&&(ie|=o.shift),ne&&(!Ae.onCommandKey({},ie,ne)&&Ae.commands&&(ne=s.keyCodeToString(ne),ie=Ae.commands.findKeyCommand(ie,ne))&&Ae.execCommand(ie),y=be,_=ve,Y("")))};var Ae=p,_e=w,We=null,ke=!1;_e.addEventListener("keydown",function(fe){We&&clearTimeout(We),ke=!0},!0),_e.addEventListener("keyup",function(fe){We=setTimeout(function(){ke=!1},100)},!0),document.addEventListener("selectionchange",le),Ae.on("destroy",function(){document.removeEventListener("selectionchange",le)})}this.destroy=function(){w.parentElement&&w.parentElement.removeChild(w)}},f.$setUserAgentForTests=function(C,p){d=C,i=p}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(m,f,T){var I=m("../lib/useragent"),m=(h.prototype.onMouseDown=function(l){var t=l.inSelection(),r=l.getDocumentPosition(),e=(this.mousedownEvent=l,this.editor),n=l.getButton();if(n!==0)!e.getSelectionRange().isEmpty()&&n!=1||e.selection.moveToPosition(r),n==2&&(e.textInput.onContextMenu(l.domEvent),I.isMozilla||l.preventDefault());else{if(this.mousedownEvent.time=Date.now(),!t||e.isFocused()||(e.focus(),!this.$focusTimeout)||this.$clickSelection||e.inMultiSelectMode)return this.captureMouse(l),this.startSelect(r,1<l.domEvent._clicks),l.preventDefault();this.setState("focusWait"),this.captureMouse(l)}},h.prototype.startSelect=function(l,t){l=l||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var r=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?r.selection.selectToPosition(l):t||r.selection.moveToPosition(l),t||this.select(),r.setStyle("ace_selecting"),this.setState("select"))},h.prototype.select=function(){var l,t=this.editor,r=t.renderer.screenToTextCoordinates(this.x,this.y);this.$clickSelection&&(l=(l=this.$clickSelection.comparePoint(r))==-1?this.$clickSelection.end:l==1?this.$clickSelection.start:(r=(l=a(this.$clickSelection,r)).cursor,l.anchor),t.selection.setSelectionAnchor(l.row,l.column)),t.selection.selectToPosition(r),t.renderer.scrollCursorIntoView()},h.prototype.extendSelectionBy=function(o){var t,r,e,n=this.editor,s=n.renderer.screenToTextCoordinates(this.x,this.y),o=n.selection[o](s.row,s.column);this.$clickSelection&&(r=this.$clickSelection.comparePoint(o.start),t=this.$clickSelection.comparePoint(o.end),r==-1&&t<=0?(e=this.$clickSelection.end,o.end.row==s.row&&o.end.column==s.column||(s=o.start)):t==1&&0<=r?(e=this.$clickSelection.start,o.start.row==s.row&&o.start.column==s.column||(s=o.end)):e=r==-1&&t==1?(s=o.end,o.start):(s=(r=a(this.$clickSelection,s)).cursor,r.anchor),n.selection.setSelectionAnchor(e.row,e.column)),n.selection.selectToPosition(s),n.renderer.scrollCursorIntoView()},h.prototype.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting")},h.prototype.focusWait=function(){e=this.mousedownEvent.x,l=this.mousedownEvent.y,r=this.x,t=this.y;var l,t,r=Math.sqrt(Math.pow(r-e,2)+Math.pow(t-l,2)),e=Date.now();(0<r||e-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},h.prototype.onDoubleClick=function(t){var t=t.getDocumentPosition(),r=this.editor,e=r.session.getBracketRange(t);e?(e.isEmpty()&&(e.start.column--,e.end.column++),this.setState("select")):(e=r.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=e,this.select()},h.prototype.onTripleClick=function(t){var t=t.getDocumentPosition(),r=this.editor,e=(this.setState("selectByLines"),r.getSelectionRange());e.isMultiLine()&&e.contains(t.row,t.column)?(this.$clickSelection=r.selection.getLineRange(e.start.row),this.$clickSelection.end=r.selection.getLineRange(e.end.row).end):this.$clickSelection=r.selection.getLineRange(t.row),this.select()},h.prototype.onQuadClick=function(l){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},h.prototype.onMouseWheel=function(l){var t,r,e,n,s,o,i;if(!l.getAccelKey())return l.getShiftKey()&&l.wheelY&&!l.wheelX&&(l.wheelX=l.wheelY,l.wheelY=0),t=this.editor,this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0}),r=this.$lastScroll,n=(i=(e=l.domEvent.timeStamp)-r.t)?l.wheelX/i:r.vx,s=i?l.wheelY/i:r.vy,i<550&&(n=(n+r.vx)/2,s=(s+r.vy)/2),i=!1,1<=(o=Math.abs(n/s))&&t.renderer.isScrollableBy(l.wheelX*l.speed,0)&&(i=!0),(i=o<=1&&t.renderer.isScrollableBy(0,l.wheelY*l.speed)?!0:i)?r.allowed=e:e-r.allowed<550&&(Math.abs(n)<=1.5*Math.abs(r.vx)&&Math.abs(s)<=1.5*Math.abs(r.vy)?(i=!0,r.allowed=e):r.allowed=0),r.t=e,r.vx=n,r.vy=s,i?(t.renderer.scrollBy(l.wheelX*l.speed,l.wheelY*l.speed),l.stop()):void 0},h);function h(l){l.$clickSelection=null;var t=l.editor;t.setDefaultHandler("mousedown",this.onMouseDown.bind(l)),t.setDefaultHandler("dblclick",this.onDoubleClick.bind(l)),t.setDefaultHandler("tripleclick",this.onTripleClick.bind(l)),t.setDefaultHandler("quadclick",this.onQuadClick.bind(l)),t.setDefaultHandler("mousewheel",this.onMouseWheel.bind(l)),["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(r){l[r]=this[r]},this),l.selectByLines=this.extendSelectionBy.bind(l,"getLineRange"),l.selectByWords=this.extendSelectionBy.bind(l,"getWordRange")}function a(l,t){return(l.start.row==l.end.row?2*t.column-l.start.column-l.end.column:l.start.row!=l.end.row-1||l.start.column||l.end.column?2*t.row-l.start.row-l.end.row:t.column-4)<0?{cursor:l.start,anchor:l.end}:{cursor:l.end,anchor:l.start}}m.prototype.selectEnd=m.prototype.selectByLinesEnd,m.prototype.selectAllEnd=m.prototype.selectByLinesEnd,m.prototype.selectByWordsEnd=m.prototype.selectByLinesEnd,f.DefaultHandlers=m}),ace.define("ace/tooltip",["require","exports","module","ace/lib/dom","ace/range"],function(t,f,T){var I,o=this&&this.__extends||(I=function(c,d){return(I=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(C,p){C.__proto__=p}:function(C,p){for(var w in p)Object.prototype.hasOwnProperty.call(p,w)&&(C[w]=p[w])}))(c,d)},function(c,d){if(typeof d!="function"&&d!==null)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");function C(){this.constructor=c}I(c,d),c.prototype=d===null?Object.create(d):(C.prototype=d.prototype,new C)}),m=this&&this.__values||function(c){var d=typeof Symbol=="function"&&Symbol.iterator,C=d&&c[d],p=0;if(C)return C.call(c);if(c&&typeof c.length=="number")return{next:function(){return{value:(c=c&&p>=c.length?void 0:c)&&c[p++],done:!c}}};throw new TypeError(d?"Object is not iterable.":"Symbol.iterator is not defined.")},h=t("./lib/dom"),a=t("./range").Range,l="ace_tooltip",t=(r.prototype.$init=function(){return this.$element=h.createElement("div"),this.$element.className=l,this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},r.prototype.getElement=function(){return this.$element||this.$init()},r.prototype.setText=function(c){this.getElement().textContent=c},r.prototype.setHtml=function(c){this.getElement().innerHTML=c},r.prototype.setPosition=function(c,d){this.getElement().style.left=c+"px",this.getElement().style.top=d+"px"},r.prototype.setClassName=function(c){h.addCssClass(this.getElement(),c)},r.prototype.setTheme=function(c){this.$element.className=l+" "+(c.isDark?"ace_dark ":"")+(c.cssClass||"")},r.prototype.show=function(c,d,C){c!=null&&this.setText(c),d!=null&&C!=null&&this.setPosition(d,C),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},r.prototype.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.getElement().className=l,this.isOpen=!1)},r.prototype.getHeight=function(){return this.getElement().offsetHeight},r.prototype.getWidth=function(){return this.getElement().offsetWidth},r.prototype.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)},r);function r(c){this.isOpen=!1,this.$element=null,this.$parentNode=c}function e(){this.popups=[]}e.prototype.addPopup=function(c){this.popups.push(c),this.updatePopups()},e.prototype.removePopup=function(c){c=this.popups.indexOf(c),c!==-1&&(this.popups.splice(c,1),this.updatePopups())},e.prototype.updatePopups=function(){this.popups.sort(function(N,y){return y.priority-N.priority});var c,d,C,p,w=[];try{for(var x=m(this.popups),$=x.next();!$.done;$=x.next()){var P=$.value,B=!0;try{C=void 0;for(var Z=m(w),u=Z.next();!u.done;u=Z.next()){var v=u.value;if(this.doPopupsOverlap(v,P)){B=!1;break}}}catch(N){C={error:N}}finally{try{u&&!u.done&&(p=Z.return)&&p.call(Z)}finally{if(C)throw C.error}}B?w.push(P):P.hide()}}catch(N){c={error:N}}finally{try{$&&!$.done&&(d=x.return)&&d.call(x)}finally{if(c)throw c.error}}},e.prototype.doPopupsOverlap=function(c,d){return c=c.getElement().getBoundingClientRect(),d=d.getElement().getBoundingClientRect(),c.left<d.right&&c.right>d.left&&c.top<d.bottom&&c.bottom>d.top};var n,s=new e,o=(f.popupManager=s,f.Tooltip=t,o(i,n=t),i.prototype.addToEditor=function(c){c.on("mousemove",this.onMouseMove),c.on("mousedown",this.hide),c.renderer.getMouseEventTarget().addEventListener("mouseout",this.onMouseOut,!0)},i.prototype.removeFromEditor=function(c){c.off("mousemove",this.onMouseMove),c.off("mousedown",this.hide),c.renderer.getMouseEventTarget().removeEventListener("mouseout",this.onMouseOut,!0),this.timeout&&(clearTimeout(this.timeout),this.timeout=null)},i.prototype.onMouseMove=function(c,p){this.lastEvent=c,this.lastT=Date.now();var C,p=p.$mouseHandler.isMousePressed;this.isOpen&&(C=this.lastEvent&&this.lastEvent.getDocumentPosition(),this.range&&this.range.contains(C.row,C.column)&&!p&&!this.isOutsideOfText(this.lastEvent)||this.hide()),this.timeout||p||(this.lastEvent=c,this.timeout=setTimeout(this.waitForHover,this.idleTime))},i.prototype.waitForHover=function(){this.timeout&&clearTimeout(this.timeout);var c=Date.now()-this.lastT;10<this.idleTime-c?this.timeout=setTimeout(this.waitForHover,this.idleTime-c):(this.timeout=null,this.lastEvent&&!this.isOutsideOfText(this.lastEvent)&&this.$gatherData(this.lastEvent,this.lastEvent.editor))},i.prototype.isOutsideOfText=function(c){var d=c.editor,C=c.getDocumentPosition(),p=d.session.getLine(C.row);return C.column==p.length&&(p=d.renderer.pixelToScreenCoordinates(c.clientX,c.clientY),c=d.session.documentToScreenPosition(C.row,C.column),c.column!=p.column||c.row!=p.row)},i.prototype.setDataProvider=function(c){this.$gatherData=c},i.prototype.showForRange=function(c,d,C,p){var w,x,$;p&&p!=this.lastEvent||this.isOpen&&document.activeElement==this.getElement()||(p=c.renderer,this.isOpen||(s.addPopup(this),this.$registerCloseEvents(),this.setTheme(p.theme)),this.isOpen=!0,this.addMarker(d,c.session),this.range=a.fromPoints(d.start,d.end),(w=this.getElement()).innerHTML="",w.appendChild(C),w.style.display="block",C=p.textToScreenCoordinates(d.start.row,d.start.column),d=c.getCursorPosition(),c=w.clientHeight,x=p.scroller.getBoundingClientRect(),$=!0,this.row>d.row?$=!0:this.row<d.row&&($=!1),C.pageY-c+p.lineHeight<x.top?$=!0:C.pageY+c>x.bottom&&($=!1),$?C.pageY+=p.lineHeight:C.pageY-=c,w.style.maxWidth=x.width-(C.pageX-x.left)+"px",this.setPosition(C.pageX,C.pageY))},i.prototype.addMarker=function(c,d){this.marker&&this.$markerSession.removeMarker(this.marker),this.$markerSession=d,this.marker=d&&d.addMarker(c,"ace_highlight-marker","text")},i.prototype.hide=function(c){!c&&document.activeElement==this.getElement()||c&&c.target&&(c.type!="keydown"||c.ctrlKey||c.metaKey)&&this.$element.contains(c.target)||(this.lastEvent=null,this.timeout&&clearTimeout(this.timeout),this.timeout=null,this.addMarker(null),this.isOpen&&(this.$removeCloseEvents(),this.getElement().style.display="none",this.isOpen=!1,s.removePopup(this)))},i.prototype.$registerCloseEvents=function(){window.addEventListener("keydown",this.hide,!0),window.addEventListener("mousewheel",this.hide,!0),window.addEventListener("mousedown",this.hide,!0)},i.prototype.$removeCloseEvents=function(){window.removeEventListener("keydown",this.hide,!0),window.removeEventListener("mousewheel",this.hide,!0),window.removeEventListener("mousedown",this.hide,!0)},i.prototype.onMouseOut=function(c){this.timeout&&(clearTimeout(this.timeout),this.timeout=null),this.lastEvent=null,!this.isOpen||!c.relatedTarget||c.relatedTarget==this.getElement()||c&&c.currentTarget.contains(c.relatedTarget)||c.relatedTarget.classList.contains("ace_content")||this.hide()},i);function i(d){d===void 0&&(d=document.body);var d=n.call(this,d)||this,C=(d.timeout=void 0,d.lastT=0,d.idleTime=350,d.lastEvent=void 0,d.onMouseOut=d.onMouseOut.bind(d),d.onMouseMove=d.onMouseMove.bind(d),d.waitForHover=d.waitForHover.bind(d),d.hide=d.hide.bind(d),d.getElement());return C.style.whiteSpace="pre-wrap",C.style.pointerEvents="auto",C.addEventListener("mouseout",d.onMouseOut),C.tabIndex=-1,C.addEventListener("blur",(function(){C.contains(document.activeElement)||this.hide()}).bind(d)),d}f.HoverTooltip=o}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/tooltip","ace/config"],function(A,f,T){var I,m=this&&this.__extends||(I=function(o,i){return(I=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(c,d){c.__proto__=d}:function(c,d){for(var C in d)Object.prototype.hasOwnProperty.call(d,C)&&(c[C]=d[C])}))(o,i)},function(o,i){if(typeof i!="function"&&i!==null)throw new TypeError("Class extends value "+String(i)+" is not a constructor or null");function c(){this.constructor=o}I(o,i),o.prototype=i===null?Object.create(i):(c.prototype=i.prototype,new c)}),h=this&&this.__values||function(o){var i=typeof Symbol=="function"&&Symbol.iterator,c=i&&o[i],d=0;if(c)return c.call(o);if(o&&typeof o.length=="number")return{next:function(){return{value:(o=o&&d>=o.length?void 0:o)&&o[d++],done:!o}}};throw new TypeError(i?"Object is not iterable.":"Symbol.iterator is not defined.")},a=A("../lib/dom"),l=A("../lib/event"),t=A("../tooltip").Tooltip,r=A("../config").nls;f.GutterHandler=function(o){var i,c,d=o.editor,C=d.renderer.$gutterLayer,p=new n(d);function w(){i=i&&clearTimeout(i),p.isOpen&&(p.hide(),d._signal("hideGutterTooltip",p),d.off("mousewheel",w))}function x($){p.setPosition($.x,$.y)}o.editor.setDefaultHandler("guttermousedown",function($){if(d.isFocused()&&$.getButton()==0){var P=C.getRegion($);if(P!="foldWidgets"){var P=$.getDocumentPosition().row,B=d.session.selection;if($.getShiftKey())B.selectTo(P,0);else{if($.domEvent.detail==2)return d.selectAll(),$.preventDefault();o.$clickSelection=d.selection.getLineRange(P)}return o.setState("selectByLines"),o.captureMouse($),$.preventDefault()}}}),o.editor.setDefaultHandler("guttermousemove",function($){var P=$.domEvent.target||$.domEvent.srcElement;if(a.hasCssClass(P,"ace_fold-widget"))return w();p.isOpen&&o.$tooltipFollowsMouse&&x($),c=$,i=i||setTimeout(function(){if(i=null,c&&!o.isMousePressed){var B=c.getDocumentPosition().row;if(B==d.session.getLength()){var Z=d.renderer.pixelToScreenCoordinates(0,c.y).row,u=c.$pos;if(Z>d.session.documentToScreenRow(u.row,u.column))return void w()}p.showTooltip(B),d.on("mousewheel",w),o.$tooltipFollowsMouse?x(c):(Z=C.$lines.cells[B].element.querySelector("[class*=ace_icon]").getBoundingClientRect(),(u=p.getElement().style).left=Z.right+"px",u.top=Z.bottom+"px")}else w()},50)}),l.addListener(d.renderer.$gutter,"mouseout",function($){c=null,p.isOpen&&(i=i||setTimeout(function(){i=null,w()},50))},d),d.on("changeSession",w)},m(s,e=t),s.prototype.setPosition=function(o,i){var c=window.innerWidth||document.documentElement.clientWidth,d=window.innerHeight||document.documentElement.clientHeight,C=this.getWidth(),p=this.getHeight();c<(o+=15)+C&&(o-=o+C-c),d<(i+=15)+p&&(i-=20+p),t.prototype.setPosition.call(this,o,i)},Object.defineProperty(s,"annotationLabels",{get:function(){return{error:{singular:r("error"),plural:r("errors")},warning:{singular:r("warning"),plural:r("warnings")},info:{singular:r("information message"),plural:r("information messages")}}},enumerable:!1,configurable:!0}),s.prototype.showTooltip=function(o){var i=this.editor.renderer.$gutterLayer,c=i.$annotations[o],d=c?{text:Array.from(c.text),type:Array.from(c.type)}:{text:[],type:[]},C=i.session.getFoldLine(o);if(C&&i.$showFoldedAnnotations){for(var p,w={error:[],warning:[],info:[]},x=o+1;x<=C.end.row;x++)if(i.$annotations[x])for(var $=0;$<i.$annotations[x].text.length;$++){var P=i.$annotations[x].type[$];w[P].push(i.$annotations[x].text[$]),P==="error"?p="error_fold":P==="warning"&&(p="warning_fold")}p!=="error_fold"&&p!=="warning_fold"||(c="".concat(s.annotationsToSummaryString(w)," in folded code."),d.text.push(c),d.type.push(p))}if(d.text.length===0)return this.hide();for(var B={error:[],warning:[],info:[]},Z=i.$useSvgGutterIcons?"ace_icon_svg":"ace_icon",x=0;x<d.text.length;x++){var u="<span class='ace_".concat(d.type[x]," ").concat(Z,"' aria-label='").concat(s.annotationLabels[d.type[x].replace("_fold","")].singular,"' role=img> </span> ").concat(d.text[x]);B[d.type[x].replace("_fold","")].push(u)}o=[].concat(B.error,B.warning,B.info).join("<br>"),this.setHtml(o),this.setClassName("ace_gutter-tooltip"),this.$element.setAttribute("aria-live","polite"),this.isOpen||this.setTheme(this.editor.renderer.theme),this.editor._signal("showGutterTooltip",this),this.show()},s.annotationsToSummaryString=function(o){var i,c,d=[];try{for(var C=h(["error","warning","info"]),p=C.next();!p.done;p=C.next()){var w,x=p.value;o[x].length&&(w=o[x].length===1?s.annotationLabels[x].singular:s.annotationLabels[x].plural,d.push("".concat(o[x].length," ").concat(w)))}}catch($){i={error:$}}finally{try{p&&!p.done&&(c=C.return)&&c.call(C)}finally{if(i)throw i.error}}return d.join(", ")};var e,n=s;function s(o){var i=e.call(this,o.container)||this;return i.editor=o,i}f.GutterTooltip=n}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(A,f,T){var I=A("../lib/event"),m=A("../lib/useragent");function h(a,l){this.domEvent=a,this.editor=l,this.x=this.clientX=a.clientX,this.y=this.clientY=a.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1}h.prototype.stopPropagation=function(){I.stopPropagation(this.domEvent),this.propagationStopped=!0},h.prototype.preventDefault=function(){I.preventDefault(this.domEvent),this.defaultPrevented=!0},h.prototype.stop=function(){this.stopPropagation(),this.preventDefault()},h.prototype.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},h.prototype.inSelection=function(){var a,l;return this.$inSelection===null&&((a=this.editor.getSelectionRange()).isEmpty()?this.$inSelection=!1:(l=this.getDocumentPosition(),this.$inSelection=a.contains(l.row,l.column))),this.$inSelection},h.prototype.getButton=function(){return I.getButton(this.domEvent)},h.prototype.getShiftKey=function(){return this.domEvent.shiftKey},h.prototype.getAccelKey=function(){return m.isMac?this.domEvent.metaKey:this.domEvent.ctrlKey},f.MouseEvent=h}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(A,f,T){var I=A("../lib/dom"),m=A("../lib/event"),h=A("../lib/useragent");function a(t){var r,e,n,s,o,i,c,d,C,p,w,x=t.editor,$=I.createElement("div"),P=($.style.cssText="top:-100px;position:absolute;z-index:2147483647;opacity:0.5",$.textContent=" ",["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(F){t[F]=this[F]},this),x.on("mousedown",this.onMouseDown.bind(t)),x.container),B=0;function Z(){var F,Y,Q,z,te,E,H,V,b=i;i=x.renderer.screenToTextCoordinates(e,n),Q=i,Y=b,z=Date.now(),F=!Y||Q.row!=Y.row,Y=!Y||Q.column!=Y.column,!p||F||Y?(x.moveCursorToPosition(Q),p=z,w={x:e,y:n}):5<l(w.x,w.y,e,n)?p=null:200<=z-p&&(x.renderer.scrollCursorIntoView(),p=null),F=i,Y=b,Q=Date.now(),z=x.renderer.layerConfig.lineHeight,b=x.renderer.layerConfig.characterWidth,te=x.renderer.scroller.getBoundingClientRect(),te={x:{left:e-te.left,right:te.right-e},y:{top:n-te.top,bottom:te.bottom-n}},E=Math.min(te.x.left,te.x.right),H=Math.min(te.y.top,te.y.bottom),V={row:F.row,column:F.column},E/b<=2&&(V.column+=te.x.left<te.x.right?-3:2),H/z<=1&&(V.row+=te.y.top<te.y.bottom?-1:1),E=F.row!=V.row,b=F.column!=V.column,H=!Y||F.row!=Y.row,E||b&&!H?C?200<=Q-C&&x.renderer.scrollCursorIntoView(V):C=Q:C=null}function u(){o=x.selection.toOrientedRange(),r=x.session.addMarker(o,"ace_selection",x.getSelectionStyle()),x.clearSelection(),x.isFocused()&&x.renderer.$cursorLayer.setBlinking(!1),clearInterval(s),Z(),s=setInterval(Z,20),B=0,m.addListener(document,"mousemove",y)}function v(){clearInterval(s),x.session.removeMarker(r),r=null,x.selection.fromOrientedRange(o),x.isFocused()&&!d&&x.$resetCursorStyle(),B=0,p=C=i=o=null,m.removeListener(document,"mousemove",y)}this.onDragStart=function(F){var Y;if(this.cancelDrag||!P.draggable)return Y=this,setTimeout(function(){Y.startSelect(),Y.captureMouse(F)},0),F.preventDefault();o=x.getSelectionRange();var Q=F.dataTransfer;Q.effectAllowed=x.getReadOnly()?"copy":"copyMove",x.container.appendChild($),Q.setDragImage&&Q.setDragImage($,0,0),setTimeout(function(){x.container.removeChild($)}),Q.clearData(),Q.setData("Text",x.session.getTextRange()),d=!0,this.setState("drag")},this.onDragEnd=function(F){P.draggable=!1,d=!1,this.setState(null),x.getReadOnly()||(F=F.dataTransfer.dropEffect,c||F!="move"||x.session.remove(x.getSelectionRange()),x.$resetCursorStyle()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(F){if(!x.getReadOnly()&&_(F.dataTransfer))return e=F.clientX,n=F.clientY,r||u(),B++,F.dataTransfer.dropEffect=c=W(F),m.preventDefault(F)},this.onDragOver=function(F){if(!x.getReadOnly()&&_(F.dataTransfer))return e=F.clientX,n=F.clientY,r||(u(),B++),N!==null&&(N=null),F.dataTransfer.dropEffect=c=W(F),m.preventDefault(F)},this.onDragLeave=function(F){if(--B<=0&&r)return v(),c=null,m.preventDefault(F)},this.onDrop=function(F){if(i){var Y=F.dataTransfer;if(d)switch(c){case"move":o=o.contains(i.row,i.column)?{start:i,end:i}:x.moveText(o,i);break;case"copy":o=x.moveText(o,i,!0)}else Y=Y.getData("Text"),o={start:i,end:x.session.insert(i,Y)},x.focus(),c=null;return v(),m.preventDefault(F)}},m.addListener(P,"dragstart",this.onDragStart.bind(t),x),m.addListener(P,"dragend",this.onDragEnd.bind(t),x),m.addListener(P,"dragenter",this.onDragEnter.bind(t),x),m.addListener(P,"dragover",this.onDragOver.bind(t),x),m.addListener(P,"dragleave",this.onDragLeave.bind(t),x),m.addListener(P,"drop",this.onDrop.bind(t),x);var N=null;function y(){N==null&&(N=setTimeout(function(){N!=null&&r&&v()},20))}function _(F){return F=F.types,!F||Array.prototype.some.call(F,function(Y){return Y=="text/plain"||Y=="Text"})}function W(F){var Y=["copy","copymove","all","uninitialized"],Q=h.isMac?F.altKey:F.ctrlKey,z="uninitialized";try{z=F.dataTransfer.effectAllowed.toLowerCase()}catch{}var te="none";return Q&&0<=Y.indexOf(z)?te="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(z)?te="move":0<=Y.indexOf(z)&&(te="copy"),te}}function l(t,r,e,n){return Math.sqrt(Math.pow(e-t,2)+Math.pow(n-r,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(t){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var t=this.editor,r=(t.container.draggable=!0,t.renderer.$cursorLayer.setBlinking(!1),t.setStyle("ace_dragging"),h.isWin?"default":"move");t.renderer.setCursorStyle(r),this.setState("dragReady")},this.onMouseDrag=function(t){var r=this.editor.container;h.isIE&&this.state=="dragReady"&&3<l(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&r.dragDrop(),this.state==="dragWait"&&0<l(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(r.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(t){var r,e,n;this.$dragEnabled&&(this.mousedownEvent=t,r=this.editor,e=t.inSelection(),n=t.getButton(),(t.domEvent.detail||1)!==1||n!==0||!e||t.editor.inMultiSelectMode&&(t.getAccelKey()||t.getShiftKey())||(this.mousedownEvent.time=Date.now(),"unselectable"in(n=t.domEvent.target||t.domEvent.srcElement)&&(n.unselectable="on"),r.getDragDelay()?(h.isWebKit&&(this.cancelDrag=!0,r.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(t,this.onMouseDrag.bind(this)),t.defaultPrevented=!0))}}).call(a.prototype),f.DragdropHandler=a}),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/event","ace/lib/dom"],function(A,f,T){var I=A("./mouse_event").MouseEvent,m=A("../lib/event"),h=A("../lib/dom");f.addTouchListeners=function(a,l){var t,r,e,n,s,o,i,c,d,C="scroll",p=0,w=0,x=0,$=0;function P(){function v(_){var W,F=_.target.getAttribute("action");F!="more"&&y?(F=="paste"?N.readText().then(function(Y){l.execCommand(F,Y)}):F&&(F!="cut"&&F!="copy"||(N?N.writeText(l.getCopyText()):document.execCommand("copy")),l.execCommand(F)),d.firstChild.style.display="none",y=!1,F!="openCommandPallete"&&l.focus()):(y=!y,_=l.getCopyText(),W=l.session.getUndoManager().hasUndo(),d.replaceChild(h.buildDom(y?["span",!_&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],_&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],_&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],N&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],W&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Palette"]]:["span"]),d.firstChild))}var N=window.navigator&&window.navigator.clipboard,y=!1;d=h.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(_){C="menu",_.stopPropagation(),_.preventDefault(),l.textInput.focus()},ontouchend:function(_){_.stopPropagation(),_.preventDefault(),v(_)},onclick:v},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],l.container)}function B(){d||P();var v=l.selection.cursor,v=l.renderer.textToScreenCoordinates(v.row,v.column),N=l.renderer.textToScreenCoordinates(0,0).pageX,y=l.renderer.scrollLeft,_=l.container.getBoundingClientRect();d.style.top=v.pageY-_.top-3+"px",v.pageX-_.left<_.width-70?(d.style.left="",d.style.right="10px"):(d.style.right="",d.style.left=N+y-_.left+"px"),d.style.display="",d.firstChild.style.display="none",l.on("input",Z)}function Z(v){d&&(d.style.display="none"),l.off("input",Z)}function u(){s=null,clearTimeout(s);var v=l.selection.getRange(),N=v.contains(i.row,i.column);!v.isEmpty()&&N||(l.selection.moveToPosition(i),l.selection.selectWord()),C="wait",B()}m.addListener(a,"contextmenu",function(v){c&&l.textInput.getElement().focus()},l),m.addListener(a,"touchstart",function(v){var N=v.touches;if(s||1<N.length)clearTimeout(s),s=null,e=-1,C="zoom";else{c=l.$mouseHandler.isMousePressed=!0;var y=l.renderer.layerConfig.lineHeight,_=l.renderer.layerConfig.lineHeight,W=v.timeStamp,F=(n=W,N[0]),Y=F.clientX,F=F.clientY,Y=(Math.abs(t-Y)+Math.abs(r-F)>y&&(e=-1),t=v.clientX=Y,r=v.clientY=F,x=$=0,new I(v,l));if(i=Y.getDocumentPosition(),W-e<500&&N.length==1&&!p)w++,v.preventDefault(),v.button=0,s=null,clearTimeout(s),l.selection.moveToPosition(i),(F=2<=w?l.selection.getLineRange(i.row):l.session.getBracketRange(i))&&!F.isEmpty()?l.selection.setRange(F):l.selection.selectWord(),C="wait";else{w=0;var Y=l.selection.cursor,N=l.selection.isEmpty()?Y:l.selection.anchor,F=l.renderer.$cursorLayer.getPixelPosition(Y,!0),Y=l.renderer.$cursorLayer.getPixelPosition(N,!0),N=l.renderer.scroller.getBoundingClientRect(),Q=l.renderer.layerConfig.offset,z=l.renderer.scrollLeft,te=function(b,S){return(b/=_)*b+(S=S/y-.75)*S};if(v.clientX<N.left)return void(C="zoom");F=te(v.clientX-N.left-F.left+z,v.clientY-N.top-F.top+Q),te=te(v.clientX-N.left-Y.left+z,v.clientY-N.top-Y.top+Q),F<3.5&&te<3.5&&(C=te<F?"cursor":"anchor"),C=te<3.5?"anchor":F<3.5?"cursor":"scroll",s=setTimeout(u,450)}e=W}},l),m.addListener(a,"touchend",function(v){c=l.$mouseHandler.isMousePressed=!1,o&&clearInterval(o),C=="zoom"?(C="",p=0):(s?(l.selection.moveToPosition(i),p=0,B):C=="scroll"?(p+=60,o=setInterval(function(){p--<=0&&(clearInterval(o),o=null),Math.abs(x)<.01&&(x=0),Math.abs($)<.01&&($=0),p<20&&(x*=.9),p<20&&($*=.9);var N=l.session.getScrollTop();l.renderer.scrollBy(10*x,10*$),N==l.session.getScrollTop()&&(p=0)},10),Z):B)(),clearTimeout(s),s=null},l),m.addListener(a,"touchmove",function(v){s&&(clearTimeout(s),s=null);var N=v.touches;if(!(1<N.length||C=="zoom")){var N=N[0],y=t-N.clientX,_=r-N.clientY;if(C=="wait"){if(!(4<y*y+_*_))return v.preventDefault();C="cursor"}t=N.clientX,r=N.clientY,v.clientX=N.clientX,v.clientY=N.clientY;var N=v.timeStamp,W=N-n;n=N,C=="scroll"?((N=new I(v,l)).speed=1,N.wheelX=y,N.wheelY=_,10*Math.abs(y)<Math.abs(_)&&(y=0),10*Math.abs(_)<Math.abs(y)&&(_=0),W!=0&&(x=y/W,$=_/W),l._emit("mousewheel",N),N.propagationStopped||(x=$=0)):(y=new I(v,l).getDocumentPosition(),C=="cursor"?l.selection.moveCursorToPosition(y):C=="anchor"&&l.selection.setSelectionAnchor(y.row,y.column),l.renderer.scrollCursorIntoView(y),v.preventDefault())}},l)}}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],function(e,f,T){var I=e("../lib/event"),m=e("../lib/useragent"),h=e("./default_handlers").DefaultHandlers,a=e("./default_gutter_handler").GutterHandler,l=e("./mouse_event").MouseEvent,t=e("./dragdrop_handler").DragdropHandler,r=e("./touch_handler").addTouchListeners,e=e("../config"),n=(s.prototype.onMouseEvent=function(o,i){this.editor.session&&this.editor._emit(o,new l(i,this.editor))},s.prototype.onMouseMove=function(o,i){var c=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;c&&c.length&&this.editor._emit(o,new l(i,this.editor))},s.prototype.onMouseWheel=function(o,i){var c=new l(i,this.editor);c.speed=2*this.$scrollSpeed,c.wheelX=i.wheelX,c.wheelY=i.wheelY,this.editor._emit(o,c)},s.prototype.setState=function(o){this.state=o},s.prototype.captureMouse=function(o,i){this.x=o.x,this.y=o.y,this.isMousePressed=!0;function c(B){if(B){if(m.isWebKit&&!B.which&&x.releaseMouse)return x.releaseMouse();x.x=B.clientX,x.y=B.clientY,i&&i(B),x.mouseEvent=new l(B,x.editor),x.$mouseMoved=!0}}function d(B){p.off("beforeEndOperation",$),clearInterval(P),p.session&&C(),x[x.state+"End"]&&x[x.state+"End"](B),x.state="",x.isMousePressed=w.$isMousePressed=!1,w.$keepTextAreaAtCursor&&w.$moveTextAreaToCursor(),x.$onCaptureMouseMove=x.releaseMouse=null,B&&x.onMouseEvent("mouseup",B),p.endOperation()}function C(){x[x.state]&&x[x.state](),x.$mouseMoved=!1}var p=this.editor,w=this.editor.renderer,x=(w.$isMousePressed=!0,this);if(m.isOldIE&&o.domEvent.type=="dblclick")return setTimeout(function(){d(o)});var $=function(B){x.releaseMouse&&p.curOp.command.name&&p.curOp.selectionChanged&&(x[x.state+"End"]&&x[x.state+"End"](),x.state="",x.releaseMouse())},P=(p.on("beforeEndOperation",$),p.startOperation({command:{name:"mouse"}}),x.$onCaptureMouseMove=c,x.releaseMouse=I.capture(this.editor.container,c,d),setInterval(C,20))},s.prototype.cancelContextMenu=function(){var o=(function(i){i&&i.domEvent&&i.domEvent.type!="contextmenu"||(this.editor.off("nativecontextmenu",o),i&&i.domEvent&&I.stopEvent(i.domEvent))}).bind(this);setTimeout(o,10),this.editor.on("nativecontextmenu",o)},s.prototype.destroy=function(){this.releaseMouse&&this.releaseMouse()},s);function s(o){function i(p){document.hasFocus&&document.hasFocus()&&(o.isFocused()||document.activeElement!=(o.textInput&&o.textInput.getElement()))||window.focus(),o.focus(),setTimeout(function(){o.isFocused()||o.focus()})}var c=this,d=(this.editor=o,new h(this),new a(this),new t(this),o.renderer.getMouseEventTarget()),C=(I.addListener(d,"click",this.onMouseEvent.bind(this,"click"),o),I.addListener(d,"mousemove",this.onMouseMove.bind(this,"mousemove"),o),I.addMultiMouseDownListener([d,o.renderer.scrollBarV&&o.renderer.scrollBarV.inner,o.renderer.scrollBarH&&o.renderer.scrollBarH.inner,o.textInput&&o.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",o),I.addMouseWheelListener(o.container,this.onMouseWheel.bind(this,"mousewheel"),o),r(o.container,o),o.renderer.$gutter);I.addListener(C,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),o),I.addListener(C,"click",this.onMouseEvent.bind(this,"gutterclick"),o),I.addListener(C,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),o),I.addListener(C,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),o),I.addListener(d,"mousedown",i,o),I.addListener(C,"mousedown",i,o),m.isIE&&o.renderer.scrollBarV&&(I.addListener(o.renderer.scrollBarV.element,"mousedown",i,o),I.addListener(o.renderer.scrollBarH.element,"mousedown",i,o)),o.on("mousemove",function(p){var w,x;c.state||c.$dragDelay||!c.$dragEnabled||(p=o.renderer.screenToTextCoordinates(p.x,p.y),w=o.session.selection.getRange(),x=o.renderer,!w.isEmpty()&&w.insideStart(p.row,p.column)?x.setCursorStyle("default"):x.setCursorStyle(""))},o)}n.prototype.releaseMouse=null,e.defineOptions(n.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:m.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),f.MouseHandler=n}),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(A,f,T){var I=A("../lib/dom");f.FoldHandler=function(m){m.on("click",function(h){var l=h.getDocumentPosition(),a=m.session,l=a.getFoldAt(l.row,l.column,1),l=(l&&(h.getAccelKey()?a.removeFold(l):a.expandFold(l),h.stop()),h.domEvent&&h.domEvent.target);l&&I.hasCssClass(l,"ace_inline_button")&&I.hasCssClass(l,"ace_toggle_wrap")&&(a.setOption("wrap",!a.getUseWrapMode()),m.renderer.scrollCursorIntoView())}),m.on("gutterclick",function(h){var a,l;m.renderer.$gutterLayer.getRegion(h)=="foldWidgets"&&(a=h.getDocumentPosition().row,(l=m.session).foldWidgets&&l.foldWidgets[a]&&m.session.onFoldWidgetClick(a,h),m.isFocused()||m.focus(),h.stop())}),m.on("gutterdblclick",function(h){var a,l,t;m.renderer.$gutterLayer.getRegion(h)=="foldWidgets"&&(t=h.getDocumentPosition().row,(l=(l=(a=m.session).getParentFoldRangeData(t,!0)).range||l.firstRange)&&(t=l.start.row,(t=a.getFoldAt(t,a.getLine(t).length,1))?a.removeFold(t):(a.addFold("...",l),m.renderer.scrollCursorIntoView({row:l.start.row,column:0}))),h.stop())})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(A,f,T){var I=A("../lib/keys"),m=A("../lib/event");function h(a){this.$editor=a,this.$data={editor:a},this.$handlers=[],this.setDefaultHandler(a.commands)}h.prototype.setDefaultHandler=function(a){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=a,this.addKeyboardHandler(a,0)},h.prototype.setKeyboardHandler=function(a){var l=this.$handlers;if(l[l.length-1]!=a){for(;l[l.length-1]&&l[l.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(l[l.length-1]);this.addKeyboardHandler(a,1)}},h.prototype.addKeyboardHandler=function(a,l){var t;a&&(typeof a!="function"||a.handleKeyboard||(a.handleKeyboard=a),(t=this.$handlers.indexOf(a))!=-1&&this.$handlers.splice(t,1),l==null?this.$handlers.push(a):this.$handlers.splice(l,0,a),t==-1)&&a.attach&&a.attach(this.$editor)},h.prototype.removeKeyboardHandler=function(a){var l=this.$handlers.indexOf(a);return l!=-1&&(this.$handlers.splice(l,1),a.detach&&a.detach(this.$editor),!0)},h.prototype.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},h.prototype.getStatusText=function(){var a=this.$data,l=a.editor;return this.$handlers.map(function(t){return t.getStatusText&&t.getStatusText(l,a)||""}).filter(Boolean).join(" ")},h.prototype.$callKeyboardHandlers=function(a,l,t,r){for(var e,n=!1,s=this.$editor.commands,o=this.$handlers.length;o--&&!((e=this.$handlers[o].handleKeyboard(this.$data,a,l,t,r))&&e.command&&((n=e.command=="null"||s.exec(e.command,this.$editor,e.args,r))&&r&&a!=-1&&e.passEvent!=1&&e.command.passEvent!=1&&m.stopEvent(r),n)););return n||a!=-1||(e={command:"insertstring"},n=s.exec("insertstring",this.$editor,l)),n&&this.$editor._signal&&this.$editor._signal("keyboardActivity",e),n},h.prototype.onCommandKey=function(a,l,t){var r=I.keyCodeToString(t);return this.$callKeyboardHandlers(l,r,t,a)},h.prototype.onTextInput=function(a){return this.$callKeyboardHandlers(-1,a)},f.KeyBinding=h}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(A,f,T){var I=0,m=0,h=!1,a=!1,l=!1,t=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],r=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],e=0,n=1,s=2,o=3,i=4,c=5,d=6,C=7,p=8,w=9,x=10,$=11,P=12,B=13,Z=14,u=15,v=16,N=17,y=18,_=[y,y,y,y,y,y,y,y,y,d,c,d,p,c,y,y,y,y,y,y,y,y,y,y,y,y,y,y,c,c,c,d,p,i,i,$,$,$,i,i,i,i,i,x,w,x,w,w,s,s,s,s,s,s,s,s,s,s,w,i,i,i,i,i,i,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,i,i,i,i,i,i,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,i,i,i,i,y,y,y,y,y,y,c,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,w,i,$,$,$,$,i,i,i,i,e,i,i,y,i,i,$,$,s,s,i,e,i,i,i,s,e,i,i,i,i,i],W=[p,p,p,p,p,p,p,p,p,p,p,y,y,y,e,n,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,p,c,B,Z,u,v,N,w,$,$,$,$,$,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,p];function F(z,te,E,H){var V,b,S,R=I?r:t,O=0,J=-1,re=null,pe=null,me=[];if(!H)for(re=0,H=[];re<E;re++)H[re]=Q(z[re]);for(m=I,l=a=h=!1,pe=0;pe<E;pe++){if(S=O,me[pe]=V=function(xe,Ie,we,Ae){var _e,We,ke,le=Ie[Ae];switch(le){case e:case n:h=!1;case i:case o:return le;case s:return h?o:s;case C:return h=!0,n;case p:return i;case w:return Ae<1||Ae+1>=Ie.length||(_e=we[Ae-1])!=s&&_e!=o||(fe=Ie[Ae+1])!=s&&fe!=o?i:(fe=h?o:fe)==_e?fe:i;case x:return(_e=0<Ae?we[Ae-1]:c)==s&&Ae+1<Ie.length&&Ie[Ae+1]==s?s:i;case $:if(0<Ae&&we[Ae-1]==s)return s;if(h)return i;for(ke=Ae+1,We=Ie.length;ke<We&&Ie[ke]==$;)ke++;return ke<We&&Ie[ke]==s?s:i;case P:for(We=Ie.length,ke=Ae+1;ke<We&&Ie[ke]==P;)ke++;if(ke<We){var fe=xe[Ae],fe=1425<=fe&&fe<=2303||fe==64286;if(_e=Ie[ke],fe&&(_e==n||_e==C))return n}return Ae<1||(_e=Ie[Ae-1])==c?i:we[Ae-1];case c:return a=!(h=!1),I;case d:return l=!0,i;case B:case Z:case v:case N:case u:h=!1;case y:return i}}(z,H,me,pe),S=240&(O=R[S][V]),O&=15,te[pe]=b=R[O][5],0<S){if(S==16)for(re=J;re<pe;re++)te[re]=1;J=-1}if(R[O][6])J==-1&&(J=pe);else if(-1<J){for(re=J;re<pe;re++)te[re]=b;J=-1}H[pe]==c&&(te[pe]=0),m|=b}if(l){for(re=0;re<E;re++)if(H[re]==d){te[re]=I;for(var ye=re-1;0<=ye&&H[ye]==p;ye--)te[ye]=I}}}function Y(z,te,E){if(!(m<z))if(z!=1||I!=1||a)for(var H,V,b,S,R=E.length,O=0;O<R;){if(te[O]>=z){for(H=O+1;H<R&&te[H]>=z;)H++;for(V=O,b=H-1;V<b;V++,b--)S=E[V],E[V]=E[b],E[b]=S;O=H}O++}else E.reverse()}function Q(z){var te=z.charCodeAt(0),E=te>>8;return E==0?191<te?e:_[te]:E==5?/[\u0591-\u05f4]/.test(z)?n:e:E==6?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(z)?P:/[\u0660-\u0669\u066b-\u066c]/.test(z)?o:te==1642?$:/[\u06f0-\u06f9]/.test(z)?s:C:E==32&&te<=8287?W[255&te]:E==254&&65136<=te?C:i}f.L=e,f.R=n,f.EN=s,f.ON_R=3,f.AN=4,f.R_H=5,f.B=6,f.RLE=7,f.DOT="·",f.doBidiReorder=function(z,te,E){if(z.length<2)return{};var H=z.split(""),V=new Array(H.length),b=new Array(H.length),S=[];I=E?1:0,F(H,S,H.length,te);for(var R=0;R<V.length;V[R]=R,R++);for(Y(2,S,V),Y(1,S,V),R=0;R<V.length-1;R++)te[R]===o?S[R]=f.AN:S[R]===n&&(te[R]>C&&te[R]<B||te[R]===i||te[R]===y)?S[R]=f.ON_R:0<R&&H[R-1]==="ل"&&/\u0622|\u0623|\u0625|\u0627/.test(H[R])&&(S[R-1]=S[R]=f.R_H,R++);for(H[H.length-1]===f.DOT&&(S[H.length-1]=f.B),H[0]==="‫"&&(S[0]=f.RLE),R=0;R<V.length;R++)b[R]=S[V[R]];return{logicalFromVisual:V,bidiLevels:b}},f.hasBidiCharacters=function(z,te){for(var E=!1,H=0;H<z.length;H++)te[H]=Q(z.charAt(H)),E||te[H]!=n&&te[H]!=C&&te[H]!=o||(E=!0);return E},f.getVisualFromLogicalIdx=function(z,te){for(var E=0;E<te.logicalFromVisual.length;E++)if(te.logicalFromVisual[E]==z)return E;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(A,f,T){var I=A("./lib/bidiutil"),m=A("./lib/lang"),h=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;function a(l){this.session=l,this.bidiMap={},this.currentRow=null,this.bidiUtil=I,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="¶",this.RLE="‫",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=h.test(l.getValue())}a.prototype.isBidiRow=function(l,t,r){return!!this.seenBidi&&(l!==this.currentRow&&(this.currentRow=l,this.updateRowLine(t,r),this.updateBidiMap()),this.bidiMap.bidiLevels)},a.prototype.onChange=function(l){this.seenBidi?this.currentRow=null:l.action=="insert"&&h.test(l.lines.join(`
`))&&(this.seenBidi=!0,this.currentRow=null)},a.prototype.getDocumentRow=function(){var l=0,t=this.session.$screenRowCache;return l=t.length&&0<=(t=this.session.$getRowCacheIndex(t,this.currentRow))?this.session.$docRowCache[t]:l},a.prototype.getSplitIndex=function(){var l=0,t=this.session.$screenRowCache;if(t.length)for(var r,e=this.session.$getRowCacheIndex(t,this.currentRow);0<this.currentRow-l&&(r=this.session.$getRowCacheIndex(t,this.currentRow-l-1))===e;)e=r,l++;else l=this.currentRow;return l},a.prototype.updateRowLine=function(l,t){var r,e=(l=l===void 0?this.getDocumentRow():l)===this.session.getLength()-1?this.EOF:this.EOL,n=(this.wrapIndent=0,this.line=this.session.getLine(l),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,(!this.session.$useWrapMode||(l=this.session.$wrapData[l])&&(0<(t=t===void 0?this.getSplitIndex():t)&&l.length?(this.wrapIndent=l.indent,this.wrapOffset=this.wrapIndent*this.charWidths[I.L],this.line=t<l.length?this.line.substring(l[t-1],l[t]):this.line.substring(l[l.length-1])):this.line=this.line.substring(0,l[t]),t==l.length))&&(this.line+=this.showInvisibles?e:I.DOT),this.session),s=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(o,i){return o==="	"||n.isFullWidth(o.charCodeAt(0))?(r=o==="	"?n.getScreenTabSize(i+s):2,s+=r-1,m.stringRepeat(I.DOT,r)):o}),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==I.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},a.prototype.updateBidiMap=function(){var l=[];I.hasBidiCharacters(this.line,l)||this.isRtlDir?this.bidiMap=I.doBidiReorder(this.line,l,this.isRtlDir):this.bidiMap={}},a.prototype.markAsDirty=function(){this.currentRow=null},a.prototype.updateCharacterWidths=function(l){var t;this.characterWidth!==l.$characterSize.width&&(this.fontMetrics=l,t=this.characterWidth=l.$characterSize.width,l=l.$measureCharWidth("ה"),this.charWidths[I.L]=this.charWidths[I.EN]=this.charWidths[I.ON_R]=t,this.charWidths[I.R]=this.charWidths[I.AN]=l,this.charWidths[I.R_H]=.45*l,this.charWidths[I.B]=this.charWidths[I.RLE]=0,this.currentRow=null)},a.prototype.setShowInvisibles=function(l){this.showInvisibles=l,this.currentRow=null},a.prototype.setEolChar=function(l){this.EOL=l},a.prototype.setContentWidth=function(l){this.contentWidth=l},a.prototype.isRtlLine=function(l){return!!this.$isRtl||(l!=null?this.session.getLine(l).charAt(0)==this.RLE:this.isRtlDir)},a.prototype.setRtlDirection=function(l,t){for(var r=l.getCursorPosition(),e=l.selection.getSelectionAnchor().row;e<=r.row;e++)t||l.session.getLine(e).charAt(0)!==l.session.$bidiHandler.RLE?t&&l.session.getLine(e).charAt(0)!==l.session.$bidiHandler.RLE&&l.session.doc.insert({column:0,row:e},l.session.$bidiHandler.RLE):l.session.doc.removeInLine(e,0,1)},a.prototype.getPosLeft=function(l){l-=this.wrapIndent;var t=this.line.charAt(0)===this.RLE?1:0,r=t<l?this.session.getOverwrite()?l:l-1:t,e=I.getVisualFromLogicalIdx(r,this.bidiMap),n=this.bidiMap.bidiLevels,s=0;!this.session.getOverwrite()&&l<=t&&n[e]%2!=0&&e++;for(var o=0;o<e;o++)s+=this.charWidths[n[o]];return!this.session.getOverwrite()&&t<l&&n[e]%2==0&&(s+=this.charWidths[n[e]]),this.wrapIndent&&(s+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(s+=this.rtlLineOffset),s},a.prototype.getSelections=function(l,t){var r,e=this.bidiMap,n=e.bidiLevels,s=[],o=0,i=Math.min(l,t)-this.wrapIndent,c=Math.max(l,t)-this.wrapIndent,d=!1,C=!1,p=0;this.wrapIndent&&(o+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var w,x=0;x<n.length;x++)w=e.logicalFromVisual[x],r=n[x],(d=i<=w&&w<c)&&!C?p=o:!d&&C&&s.push({left:p,width:o-p}),o+=this.charWidths[r],C=d;if(d&&x===n.length&&s.push({left:p,width:o-p}),this.isRtlDir)for(var $=0;$<s.length;$++)s[$].left+=this.rtlLineOffset;return s},a.prototype.offsetToCol=function(r){this.isRtlDir&&(r-=this.rtlLineOffset);var t=0,r=Math.max(r,0),e=0,n=0,s=this.bidiMap.bidiLevels,o=this.charWidths[s[n]];for(this.wrapIndent&&(r-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);e+o/2<r;){if(e+=o,n===s.length-1){o=0;break}o=this.charWidths[s[++n]]}return(t=0<n&&s[n-1]%2!=0&&s[n]%2==0?(r<e&&n--,this.bidiMap.logicalFromVisual[n]):0<n&&s[n-1]%2==0&&s[n]%2!=0?1+(e<r?this.bidiMap.logicalFromVisual[n]:this.bidiMap.logicalFromVisual[n-1]):this.isRtlDir&&n===s.length-1&&o===0&&s[n-1]%2==0||!this.isRtlDir&&n===0&&s[n]%2!=0?1+this.bidiMap.logicalFromVisual[n]:(0<n&&s[n-1]%2!=0&&o!==0&&n--,this.bidiMap.logicalFromVisual[n]))===0&&this.isRtlDir&&t++,t+this.wrapIndent},f.BidiHandler=a}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(A,f,T){function I(t){this.session=t,this.doc=t.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var r=this;this.cursor.on("change",function(e){r.$cursorChanged=!0,r.$silent||r._emit("changeCursor"),r.$isEmpty||r.$silent||r._emit("changeSelection"),r.$keepDesiredColumnOnChange||e.old.column==e.value.column||(r.$desiredColumn=null)}),this.anchor.on("change",function(){r.$anchorChanged=!0,r.$isEmpty||r.$silent||r._emit("changeSelection")})}var m=A("./lib/oop"),h=A("./lib/lang"),a=A("./lib/event_emitter").EventEmitter,l=A("./range").Range;(function(){m.implement(this,a),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},this.getCursor=function(){return this.lead.getPosition()},this.setAnchor=function(t,r){this.$isEmpty=!1,this.anchor.setPosition(t,r)},this.setSelectionAnchor=this.setAnchor,this.getAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionAnchor=this.getAnchor,this.getSelectionLead=function(){return this.lead.getPosition()},this.isBackwards=function(){var t=this.anchor,r=this.lead;return t.row>r.row||t.row==r.row&&t.column>r.column},this.getRange=function(){var t=this.anchor,r=this.lead;return this.$isEmpty?l.fromPoints(r,r):this.isBackwards()?l.fromPoints(r,t):l.fromPoints(t,r)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},this.setRange=this.setSelectionRange=function(t,n){var e=n?t.end:t.start,n=n?t.start:t.end;this.$setSelection(e.row,e.column,n.row,n.column)},this.$setSelection=function(t,r,e,n){var s,o;!this.$silent&&(s=this.$isEmpty,o=this.inMultiSelectMode,this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(t,r),this.cursor.setPosition(e,n),this.$isEmpty=!l.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),this.$cursorChanged||this.$anchorChanged||s!=this.$isEmpty||o)&&this._emit("changeSelection")},this.$moveSelection=function(t){var r=this.lead;this.$isEmpty&&this.setSelectionAnchor(r.row,r.column),t.call(this)},this.selectTo=function(t,r){this.$moveSelection(function(){this.moveCursorTo(t,r)})},this.selectToPosition=function(t){this.$moveSelection(function(){this.moveCursorToPosition(t)})},this.moveTo=function(t,r){this.clearSelection(),this.moveCursorTo(t,r)},this.moveToPosition=function(t){this.clearSelection(),this.moveCursorToPosition(t)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(t,r){var e;return r===void 0&&(t=(e=t||this.lead).row,r=e.column),this.session.getWordRange(t,r)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var t=this.getCursor(),t=this.session.getAWordRange(t.row,t.column);this.setSelectionRange(t)},this.getLineRange=function(e,r){var e=typeof e=="number"?e:this.lead.row,n=this.session.getFoldLine(e),n=n?(e=n.start.row,n.end.row):e;return r===!0?new l(e,0,n,this.session.getLine(n).length):new l(e,0,n+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(t,r,e){var n=t.column,s=t.column+r;return e<0&&(n=t.column-r,s=t.column),this.session.isTabStop(t)&&this.doc.getLine(t.row).slice(n,s).split(" ").length-1==r},this.moveCursorLeft=function(){var t,r=this.lead.getPosition();(t=this.session.getFoldAt(r.row,r.column,-1))?this.moveCursorTo(t.start.row,t.start.column):r.column===0?0<r.row&&this.moveCursorTo(r.row-1,this.doc.getLine(r.row-1).length):(t=this.session.getTabSize(),this.wouldMoveIntoSoftTab(r,t,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-t):this.moveCursorBy(0,-1))},this.moveCursorRight=function(){var t,r=this.lead.getPosition();(t=this.session.getFoldAt(r.row,r.column,1))?this.moveCursorTo(t.end.row,t.end.column):this.lead.column==this.doc.getLine(this.lead.row).length?this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0):(t=this.session.getTabSize(),r=this.lead,this.wouldMoveIntoSoftTab(r,t,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,t):this.moveCursorBy(0,1))},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,r=this.session.documentToScreenRow(e,t),r=this.session.screenToDocumentPosition(r,0),e=this.session.getDisplayLine(e,null,r.row,r.column).match(/^\s*/);e[0].length==t||this.session.$useEmacsStyleLineStart||(r.column+=e[0].length),this.moveCursorToPosition(r)},this.moveCursorLineEnd=function(){var t,r=this.lead,r=this.session.getDocumentLastRowColumnPosition(r.row,r.column);this.lead.column==r.column&&(t=this.session.getLine(r.row),r.column==t.length)&&0<(t=t.search(/\s+$/))&&(r.column=t),this.moveCursorTo(r.row,r.column)},this.moveCursorFileEnd=function(){var t=this.doc.getLength()-1,r=this.doc.getLine(t).length;this.moveCursorTo(t,r)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var t=this.lead.row,r=this.lead.column,e=this.doc.getLine(t),n=e.substring(r),s=(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.getFoldAt(t,r,1));s?this.moveCursorTo(s.end.row,s.end.column):(this.session.nonTokenRe.exec(n)&&(r+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,n=e.substring(r)),r>=e.length?(this.moveCursorTo(t,e.length),this.moveCursorRight(),t<this.doc.getLength()-1&&this.moveCursorWordRight()):(this.session.tokenRe.exec(n)&&(r+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,r)))},this.moveCursorLongWordLeft=function(){var t,r=this.lead.row,e=this.lead.column;(t=this.session.getFoldAt(r,e,-1))?this.moveCursorTo(t.start.row,t.start.column):((t=this.session.getFoldStringAt(r,e,-1))==null&&(t=this.doc.getLine(r).substring(0,e)),t=h.stringReverse(t),this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(t)&&(e-=this.session.nonTokenRe.lastIndex,t=t.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),e<=0?(this.moveCursorTo(r,0),this.moveCursorLeft(),0<r&&this.moveCursorWordLeft()):(this.session.tokenRe.exec(t)&&(e-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(r,e)))},this.$shortWordEndIndex=function(t){var r,e=0,n=/\s/,s=this.session.tokenRe;if(s.lastIndex=0,this.session.tokenRe.exec(t))e=this.session.tokenRe.lastIndex;else{for(;(r=t[e])&&n.test(r);)e++;if(e<1){for(s.lastIndex=0;(r=t[e])&&!s.test(r);)if(s.lastIndex=0,e++,n.test(r)){if(2<e){e--;break}for(;(r=t[e])&&n.test(r);)e++;if(2<e)break}}}return s.lastIndex=0,e},this.moveCursorShortWordRight=function(){var t=this.lead.row,r=this.lead.column,e=this.doc.getLine(t),n=e.substring(r),s=this.session.getFoldAt(t,r,1);if(s)return this.moveCursorTo(s.end.row,s.end.column);if(r==e.length){for(var o=this.doc.getLength();n=this.doc.getLine(++t),t<o&&/^\s*$/.test(n););/^\s+/.test(n)||(n=""),r=0}s=this.$shortWordEndIndex(n),this.moveCursorTo(t,r+s)},this.moveCursorShortWordLeft=function(){var t=this.lead.row,r=this.lead.column;if(n=this.session.getFoldAt(t,r,-1))return this.moveCursorTo(n.start.row,n.start.column);var e=this.session.getLine(t).substring(0,r);if(r===0){for(;e=this.doc.getLine(--t),0<t&&/^\s*$/.test(e););r=e.length,/\s+$/.test(e)||(e="")}var n=h.stringReverse(e),n=this.$shortWordEndIndex(n);return this.moveCursorTo(t,r-n)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(t,r){var e,n=this.session.documentToScreenPosition(this.lead.row,this.lead.column),s=(r===0&&(t!==0&&(this.session.$bidiHandler.isBidiRow(n.row,this.lead.row)?(e=this.session.$bidiHandler.getPosLeft(n.column),n.column=Math.round(e/this.session.$bidiHandler.charWidths[0])):e=n.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?n.column=this.$desiredColumn:this.$desiredColumn=n.column),t!=0&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]&&(s=this.session.lineWidgets[this.lead.row],t<0?t-=s.rowsAbove||0:0<t&&(t+=s.rowCount-(s.rowsAbove||0))),this.session.screenToDocumentPosition(n.row+t,n.column,e));t!==0&&r===0&&s.row===this.lead.row&&(s.column,this.lead.column),this.moveCursorTo(s.row,s.column+r,r===0)},this.moveCursorToPosition=function(t){this.moveCursorTo(t.row,t.column)},this.moveCursorTo=function(t,r,e){var n=this.session.getFoldAt(t,r,1),n=(n&&(t=n.start.row,r=n.start.column),this.$keepDesiredColumnOnChange=!0,this.session.getLine(t));/[\uDC00-\uDFFF]/.test(n.charAt(r))&&n.charAt(r-1)&&(this.lead.row==t&&this.lead.column==r+1?r-=1:r+=1),this.lead.setPosition(t,r),this.$keepDesiredColumnOnChange=!1,e||(this.$desiredColumn=null)},this.moveCursorToScreen=function(t,r,e){t=this.session.screenToDocumentPosition(t,r),this.moveCursorTo(t.row,t.column,e)},this.detach=function(){this.lead.detach(),this.anchor.detach()},this.fromOrientedRange=function(t){this.setSelectionRange(t,t.cursor==t.start),this.$desiredColumn=t.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(t){var r=this.getRange();return t?(t.start.column=r.start.column,t.start.row=r.start.row,t.end.column=r.end.column,t.end.row=r.end.row):t=r,t.cursor=this.isBackwards()?t.start:t.end,t.desiredColumn=this.$desiredColumn,t},this.getRangeOfMovements=function(t){var r=this.getCursor();try{t(this);var e=this.getCursor();return l.fromPoints(r,e)}catch{return l.fromPoints(r,r)}finally{this.moveCursorToPosition(r)}},this.toJSON=function(){var t;return this.rangeCount?t=this.ranges.map(function(r){var e=r.clone();return e.isBackwards=r.cursor==r.start,e}):(t=this.getRange()).isBackwards=this.isBackwards(),t},this.fromJSON=function(t){if(t.start==null){if(this.rangeList&&1<t.length){this.toSingleRange(t[0]);for(var r=t.length;r--;){var e=l.fromPoints(t[r].start,t[r].end);t[r].isBackwards&&(e.cursor=e.start),this.addRange(e,!0)}return}t=t[0]}this.rangeList&&this.toSingleRange(t),this.setSelectionRange(t,t.isBackwards)},this.isEqual=function(t){if((t.length||this.rangeCount)&&t.length!=this.rangeCount)return!1;if(!t.length||!this.ranges)return this.getRange().isEqual(t);for(var r=this.ranges.length;r--;)if(!this.ranges[r].isEqual(t[r]))return!1;return!0}}).call(I.prototype),f.Selection=I}),ace.define("ace/tokenizer",["require","exports","module","ace/config"],function(I,f,T){var I=I("./config"),m=2e3,h=(a.prototype.$setMaxTokenCount=function(l){m=0|l},a.prototype.$applyToken=function(l){var t=this.splitRegex.exec(l).slice(1),r=this.token.apply(this,t);if(typeof r=="string")return[{type:r,value:l}];for(var e=[],n=0,s=r.length;n<s;n++)t[n]&&(e[e.length]={type:r[n],value:t[n]});return e},a.prototype.$arrayTokens=function(l){if(!l)return[];var t=this.splitRegex.exec(l);if(!t)return"text";for(var r=[],e=this.tokenArray,n=0,s=e.length;n<s;n++)t[n+1]&&(r[r.length]={type:e[n],value:t[n+1]});return r},a.prototype.removeCapturingGroups=function(l){return l.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!<]|(\()/g,function(t,r){return r?"(?:":t})},a.prototype.createSplitterRegexp=function(l,t){var r,e,n;return(l=(l=l.indexOf("(?=")!=-1&&(r=0,e=!1,n={},l.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(s,o,i,c,d,C){return e?e=d!="]":d?e=!0:c?(r==n.stack&&(n.end=C+1,n.stack=-1),r--):i&&(r++,i.length!=1)&&(n.stack=r,n.start=C),s}),n.end!=null)&&/^\)*$/.test(l.substr(n.end))?l.substring(0,n.start)+l.substr(n.end):l).charAt(0)!="^"?"^"+l:l).charAt(l.length-1)!="$"&&(l+="$"),new RegExp(l,(t||"").replace("g",""))},a.prototype.getLineTokens=function(l,t){t&&typeof t!="string"?(t=(r=t.slice(0))[0])==="#tmp"&&(r.shift(),t=r.shift()):r=[];for(var r,e,n=t||"start",s=(s=this.states[n])||this.states[n="start"],o=this.matchMappings[n],i=this.regExps[n],c=[],d=i.lastIndex=0,C=0,p={type:null,value:""};e=i.exec(l);){var w,x=o.defaultToken,$=null,P=e[0],B=i.lastIndex;B-P.length>d&&(w=l.substring(d,B-P.length),p.type==x?p.value+=w:(p.type&&c.push(p),p={type:x,value:w}));for(var Z=0;Z<e.length-2;Z++)if(e[Z+1]!==void 0){x=($=s[o[Z]]).onMatch?$.onMatch(P,n,r,l):$.token,$.next&&(n=typeof $.next=="string"?$.next:$.next(n,r),(s=this.states[n])||(this.reportError("state doesn't exist",n),s=this.states[n="start"]),o=this.matchMappings[n],(i=this.regExps[n]).lastIndex=d=B),$.consumeLineEnd&&(d=B);break}if(P){if(typeof x=="string")$&&$.merge===!1||p.type!==x?(p.type&&c.push(p),p={type:x,value:P}):p.value+=P;else if(x)for(p.type&&c.push(p),p={type:null,value:""},Z=0;Z<x.length;Z++)c.push(x[Z])}if(d==l.length)break;if(d=B,C++>m){for(C>2*l.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:l});d<l.length;)p.type&&c.push(p),p={value:l.substring(d,d+=500),type:"overflow"};n="start",r=[];break}}return p.type&&c.push(p),1<r.length&&r[0]!==n&&r.unshift("#tmp",n),{tokens:c,state:r.length?r:n}},a);function a(l){for(var t in this.states=l,this.regExps={},this.matchMappings={},this.states){for(var r=this.states[t],e=[],n=0,s=this.matchMappings[t]={defaultToken:"text"},o="g",i=[],c=0;c<r.length;c++){var d,C,p=r[c];p.defaultToken&&(s.defaultToken=p.defaultToken),p.caseInsensitive&&o.indexOf("i")===-1&&(o+="i"),p.unicode&&o.indexOf("u")===-1&&(o+="u"),p.regex==null||(p.regex instanceof RegExp&&(p.regex=p.regex.toString().slice(1,-1)),d=p.regex,C=new RegExp("(?:("+d+")|(.))").exec("a").length-2,Array.isArray(p.token)?p.token.length==1||C==1?p.token=p.token[0]:C-1!=p.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:p,groupCount:C-1}),p.token=p.token[0]):(p.tokenArray=p.token,p.token=null,p.onMatch=this.$arrayTokens):typeof p.token!="function"||p.onMatch||(p.onMatch=1<C?this.$applyToken:p.token),1<C&&(d=/\\\d/.test(p.regex)?p.regex.replace(/\\([0-9]+)/g,function(w,x){return"\\"+(parseInt(x,10)+n+1)}):(C=1,this.removeCapturingGroups(p.regex)),p.splitRegex||typeof p.token=="string"||i.push(p)),s[n]=c,n+=C,e.push(d),p.onMatch)||(p.onMatch=null)}e.length||(s[0]=0,e.push("$")),i.forEach(function(w){w.splitRegex=this.createSplitterRegexp(w.regex,o)},this),this.regExps[t]=new RegExp("("+e.join(")|(")+")|($)",o)}}h.prototype.reportError=I.reportError,f.Tokenizer=h}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(A,f,T){function I(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}}var m=A("../lib/lang");(function(){this.addRules=function(l,t){if(t)for(var r in l){for(var e=l[r],n=0;n<e.length;n++){var s=e[n];(s.next||s.onMatch)&&(typeof s.next=="string"&&s.next.indexOf(t)!==0&&(s.next=t+s.next),s.nextState)&&s.nextState.indexOf(t)!==0&&(s.nextState=t+s.nextState)}this.$rules[t+r]=e}else for(var r in l)this.$rules[r]=l[r]},this.getRules=function(){return this.$rules},this.embedRules=function(l,t,r,e,n){if(l=typeof l=="function"?new l().getRules():l,e)for(var s=0;s<e.length;s++)e[s]=t+e[s];else for(var o in e=[],l)e.push(t+o);if(this.addRules(l,t),r)for(var i=Array.prototype[n?"push":"unshift"],s=0;s<e.length;s++)i.apply(this.$rules[e[s]],m.deepCopy(r));this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};function h(l,t){return l=="start"&&!t.length||t.unshift(this.nextState,l),this.nextState}function a(l,t){return t.shift(),t.shift()||"start"}this.normalizeRules=function(){var l=0,t=this.$rules;Object.keys(t).forEach(function r(e){var n=t[e];n.processed=!0;for(var s=0;s<n.length;s++){var o=n[s],i=null,c=(Array.isArray(o)&&(i=o,o={}),!o.regex&&o.start&&(o.regex=o.start,o.next||(o.next=[]),o.next.push({defaultToken:o.token},{token:o.token+".end",regex:o.end||o.start,next:"pop"}),o.token=o.token+".start",o.push=!0),o.next||o.push);if(c&&Array.isArray(c)?((C=o.stateName)||(typeof(C=o.token)!="string"&&(C=C[0]||""),t[C]&&(C+=l++)),t[C]=c,r(o.next=C)):c=="pop"&&(o.next=a),o.push&&(o.nextState=o.next||o.push,o.next=h,delete o.push),o.rules)for(var d in o.rules)t[d]?t[d].push&&t[d].push.apply(t[d],o.rules[d]):t[d]=o.rules[d];var C=typeof o=="string"?o:o.include;C&&(C==="$self"&&(C="start"),i=Array.isArray(C)?C.map(function(p){return t[p]}):t[C]),i&&(c=[s,1].concat(i),o.noEscape&&(c=c.filter(function(p){return!p.next})),n.splice.apply(n,c),s--),o.keywordMap&&(o.token=this.createKeywordMapper(o.keywordMap,o.defaultToken||"text",o.caseInsensitive),delete o.defaultToken)}},this)},this.createKeywordMapper=function(l,t,r,e){var n=Object.create(null);return this.$keywordList=[],Object.keys(l).forEach(function(s){for(var o=l[s].split(e||"|"),i=o.length;i--;){var c=o[i];this.$keywordList.push(c),r&&(c=c.toLowerCase()),n[c]=s}},this),l=null,r?function(s){return n[s.toLowerCase()]||t}:function(s){return n[s]||t}},this.getKeywords=function(){return this.$keywords}}).call(I.prototype),f.TextHighlightRules=I}),ace.define("ace/mode/behaviour",["require","exports","module"],function(A,f,T){function I(){this.$behaviours={}}(function(){this.add=function(m,h,a){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[m]:this.$behaviours[m]={}}this.$behaviours[m][h]=a},this.addBehaviours=function(m){for(var h in m)for(var a in m[h])this.add(h,a,m[h][a])},this.remove=function(m){this.$behaviours&&this.$behaviours[m]&&delete this.$behaviours[m]},this.inherit=function(m,h){m=(typeof m=="function"?new m:m).getBehaviours(h),this.addBehaviours(m)},this.getBehaviours=function(m){if(m){for(var h={},a=0;a<m.length;a++)this.$behaviours[m[a]]&&(h[m[a]]=this.$behaviours[m[a]]);return h}return this.$behaviours}}).call(I.prototype),f.Behaviour=I}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(A,f,T){var I=A("./range").Range;function m(h,a,l){this.$session=h,this.$row=a,this.$rowTokens=h.getTokens(a),h=h.getTokenAt(a,l),this.$tokenIndex=h?h.index:-1}m.prototype.stepBackward=function(){for(--this.$tokenIndex;this.$tokenIndex<0;){if(--this.$row,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},m.prototype.stepForward=function(){var h;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,h=h||this.$session.getLength(),this.$row>=h)return this.$row=h-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},m.prototype.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},m.prototype.getCurrentTokenRow=function(){return this.$row},m.prototype.getCurrentTokenColumn=function(){var h=this.$rowTokens,a=this.$tokenIndex,l=h[a].start;if(l===void 0)for(l=0;0<a;)l+=h[--a].value.length;return l},m.prototype.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},m.prototype.getCurrentTokenRange=function(){var h=this.$rowTokens[this.$tokenIndex],a=this.getCurrentTokenColumn();return new I(this.$row,a,this.$row,a+h.value.length)},f.TokenIterator=m}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(A,f,T){function I(c){var d=-1;if((o=c.multiSelect&&(d=c.selection.index,o.rangeCount!=c.multiSelect.rangeCount)?{rangeCount:c.multiSelect.rangeCount}:o)[d])return a=o[d];a=o[d]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function m(c,d,C,p){var w=c.end.row-c.start.row;return{text:C+d+p,selection:[0,c.start.column+1,w,c.end.column+(w?0:1)]}}function h(c){this.add("braces","insertion",function(d,C,p,w,x){var $=p.getCursorPosition(),P=w.doc.getLine($.row);if(x=="{")return I(p),Z=p.getSelectionRange(),(u=w.doc.getTextRange(Z))!==""&&u!=="{"&&p.getWrapBehavioursEnabled()?m(Z,u,"{","}"):h.isSaneInsertion(p,w)?/[\]\}\)]/.test(P[$.column])||p.inMultiSelectMode||c&&c.braces?(h.recordAutoInsert(p,w,"}"),{text:"{}",selection:[1,1]}):(h.recordMaybeInsert(p,w,"{"),{text:"{",selection:[1,1]}):void 0;if(x=="}"){I(p);var B=P.substring($.column,$.column+1);if(B=="}"&&w.$findOpeningBracket("}",{column:$.column+1,row:$.row})!==null&&h.isAutoInsertedClosing($,P,x))return h.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if(x==`
`||x==`\r
`){I(p);var Z="";if(h.isMaybeInsertedClosing($,P)&&(Z=e.stringRepeat("}",a.maybeInsertedBrackets),h.clearMaybeInsertedClosing()),(B=P.substring($.column,$.column+1))==="}"){var u=w.findMatchingBracket({row:$.row,column:$.column+1},"}");if(!u)return null;var v=this.$getIndent(w.getLine(u.row))}else{if(!Z)return void h.clearMaybeInsertedClosing();v=this.$getIndent(P)}return x=v+w.getTabString(),{text:`
`+x+`
`+v+Z,selection:[1,x.length,1,x.length]}}h.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(d,C,p,w,x){var $=w.doc.getTextRange(x);if(!x.isMultiLine()&&$=="{"){if(I(p),w.doc.getLine(x.start.row).substring(x.end.column,x.end.column+1)=="}")return x.end.column++,x;a.maybeInsertedBrackets--}}),this.add("parens","insertion",function(d,C,p,w,x){if(x=="(")return I(p),$=p.getSelectionRange(),(P=w.doc.getTextRange($))!==""&&p.getWrapBehavioursEnabled()?m($,P,"(",")"):h.isSaneInsertion(p,w)?(h.recordAutoInsert(p,w,")"),{text:"()",selection:[1,1]}):void 0;if(x==")"){I(p);var $=p.getCursorPosition(),P=w.doc.getLine($.row),p=P.substring($.column,$.column+1);if(p==")"&&w.$findOpeningBracket(")",{column:$.column+1,row:$.row})!==null&&h.isAutoInsertedClosing($,P,x))return h.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(d,C,p,w,x){var $=w.doc.getTextRange(x);if(!x.isMultiLine()&&$=="("&&(I(p),w.doc.getLine(x.start.row).substring(x.start.column+1,x.start.column+2)==")"))return x.end.column++,x}),this.add("brackets","insertion",function(d,C,p,w,x){if(x=="[")return I(p),$=p.getSelectionRange(),(P=w.doc.getTextRange($))!==""&&p.getWrapBehavioursEnabled()?m($,P,"[","]"):h.isSaneInsertion(p,w)?(h.recordAutoInsert(p,w,"]"),{text:"[]",selection:[1,1]}):void 0;if(x=="]"){I(p);var $=p.getCursorPosition(),P=w.doc.getLine($.row),p=P.substring($.column,$.column+1);if(p=="]"&&w.$findOpeningBracket("]",{column:$.column+1,row:$.row})!==null&&h.isAutoInsertedClosing($,P,x))return h.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(d,C,p,w,x){var $=w.doc.getTextRange(x);if(!x.isMultiLine()&&$=="["&&(I(p),w.doc.getLine(x.start.row).substring(x.start.column+1,x.start.column+2)=="]"))return x.end.column++,x}),this.add("string_dquotes","insertion",function(d,C,p,w,x){var $=w.$mode.$quotes||i;if(x.length==1&&$[x]&&(!this.lineCommentStart||this.lineCommentStart.indexOf(x)==-1)){I(p);var P=p.getSelectionRange(),B=w.doc.getTextRange(P);if(!(B===""||B.length==1&&$[B])&&p.getWrapBehavioursEnabled())return m(P,B,x,x);if(!B){var $=p.getCursorPosition(),P=w.doc.getLine($.row),B=P.substring($.column-1,$.column),p=P.substring($.column,$.column+1),v=w.getTokenAt($.row,$.column),Z=w.getTokenAt($.row,$.column+1);if(B=="\\"&&v&&/escape/.test(v.type))return null;var u,v=v&&/string|escape/.test(v.type),N=!Z||/string|escape/.test(Z.type);if(p==x)(u=v!==N)&&/string\.end/.test(Z.type)&&(u=!1);else{if(v&&!N||v&&N||(Z=w.$mode.tokenRe,v=(Z.lastIndex=0,Z.test(B)),N=(Z.lastIndex=0,Z.test(p)),w=w.$mode.$pairQuotesAfter,!(w&&w[x]&&w[x].test(B))&&v||N)||p&&!/[\s;,.})\]\\]/.test(p)||(w=P[$.column-2],B==x&&(w==x||Z.test(w))))return null;u=!0}return{text:u?x+x:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(d,C,p,w,x){var $=w.$mode.$quotes||i,P=w.doc.getTextRange(x);if(!x.isMultiLine()&&$.hasOwnProperty(P)&&(I(p),w.doc.getLine(x.start.row).substring(x.start.column+1,x.start.column+2)==P))return x.end.column++,x})}var a,l=A("../../lib/oop"),t=A("../behaviour").Behaviour,r=A("../../token_iterator").TokenIterator,e=A("../../lib/lang"),n=["text","paren.rparen","rparen","paren","punctuation.operator"],s=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],o={},i={'"':'"',"'":"'"};h.isSaneInsertion=function(c,d){var C=c.getCursorPosition(),p=new r(d,C.row,C.column);if(!this.$matchTokenType(p.getCurrentToken()||"text",n)){if(/[)}\]]/.test(c.session.getLine(C.row)[C.column]))return!0;if(c=new r(d,C.row,C.column+1),!this.$matchTokenType(c.getCurrentToken()||"text",n))return!1}return p.stepForward(),p.getCurrentTokenRow()!==C.row||this.$matchTokenType(p.getCurrentToken()||"text",s)},h.$matchTokenType=function(c,d){return-1<d.indexOf(c.type||c)},h.recordAutoInsert=function(c,d,C){c=c.getCursorPosition(),d=d.doc.getLine(c.row),this.isAutoInsertedClosing(c,d,a.autoInsertedLineEnd[0])||(a.autoInsertedBrackets=0),a.autoInsertedRow=c.row,a.autoInsertedLineEnd=C+d.substr(c.column),a.autoInsertedBrackets++},h.recordMaybeInsert=function(c,d,C){c=c.getCursorPosition(),d=d.doc.getLine(c.row),this.isMaybeInsertedClosing(c,d)||(a.maybeInsertedBrackets=0),a.maybeInsertedRow=c.row,a.maybeInsertedLineStart=d.substr(0,c.column)+C,a.maybeInsertedLineEnd=d.substr(c.column),a.maybeInsertedBrackets++},h.isAutoInsertedClosing=function(c,d,C){return 0<a.autoInsertedBrackets&&c.row===a.autoInsertedRow&&C===a.autoInsertedLineEnd[0]&&d.substr(c.column)===a.autoInsertedLineEnd},h.isMaybeInsertedClosing=function(c,d){return 0<a.maybeInsertedBrackets&&c.row===a.maybeInsertedRow&&d.substr(c.column)===a.maybeInsertedLineEnd&&d.substr(0,c.column)==a.maybeInsertedLineStart},h.popAutoInsertedClosing=function(){a.autoInsertedLineEnd=a.autoInsertedLineEnd.substr(1),a.autoInsertedBrackets--},h.clearMaybeInsertedClosing=function(){a&&(a.maybeInsertedBrackets=0,a.maybeInsertedRow=-1)},l.inherits(h,t),f.CstyleBehaviour=h}),ace.define("ace/unicode",["require","exports","module"],function(A,f,T){for(var I=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],m=0,h=[],a=0;a<I.length;a+=2)h.push(m+=I[a]),I[a+1]&&h.push(45,m+=I[a+1]);f.wordChars=String.fromCharCode.apply(null,h)}),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(A,f,T){function I(){this.HighlightRules=a}var m=A("../config"),h=A("../tokenizer").Tokenizer,a=A("./text_highlight_rules").TextHighlightRules,l=A("./behaviour/cstyle").CstyleBehaviour,t=A("../unicode"),r=A("../lib/lang"),e=A("../token_iterator").TokenIterator,n=A("../range").Range;(function(){this.$defaultBehaviour=new l,this.tokenRe=new RegExp("^["+t.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+t.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new h(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(s,o,i,c){var d=o.doc,C=!0,p=!0,w=1/0,x=o.getTabSize(),$=!1;if(this.lineCommentStart){N=Array.isArray(this.lineCommentStart)?(_=this.lineCommentStart.map(r.escapeRegExp).join("|"),this.lineCommentStart[0]):(_=r.escapeRegExp(this.lineCommentStart),this.lineCommentStart),_=new RegExp("^(\\s*)(?:"+_+") ?"),$=o.getUseSoftTabs();var P=function(Q,z){var te,E,H=Q.match(_);H&&(te=H[1].length,E=H[0].length,v(Q,te,E)||H[0][E-1]!=" "||E--,d.removeInLine(z,te,E))},B=N+" ",Z=function(Q,z){C&&!/\S/.test(Q)||(v(Q,w,w)?d.insertInLine({row:z,column:w},B):d.insertInLine({row:z,column:w},N))},u=function(Q,z){return _.test(Q)},v=function(Q,z,te){for(var E=0;z--&&Q.charAt(z)==" ";)E++;if(E%x!=0)return!1;for(E=0;Q.charAt(te++)==" ";)E++;return 2<x?E%x!=x-1:E%x==0}}else{if(!this.blockComment)return!1;var N=this.blockComment.start,y=this.blockComment.end,_=new RegExp("^(\\s*)(?:"+r.escapeRegExp(N)+")"),W=new RegExp("(?:"+r.escapeRegExp(y)+")\\s*$"),Z=function(E,H){u(E,H)||C&&!/\S/.test(E)||(d.insertInLine({row:H,column:E.length},y),d.insertInLine({row:H,column:w},N))},P=function(E,H){var V;(V=E.match(W))&&d.removeInLine(H,E.length-V[0].length,E.length),(V=E.match(_))&&d.removeInLine(H,V[1].length,V[0].length)},u=function(E,H){if(_.test(E))return!0;for(var V=o.getTokens(H),b=0;b<V.length;b++)if(V[b].type==="comment")return!0}}function F(Q){for(var z=i;z<=c;z++)Q(d.getLine(z),z)}var Y=1/0;F(function(Q,z){var te=Q.search(/\S/);te!==-1?(te<w&&(w=te),p&&!u(Q,z)&&(p=!1)):Y>Q.length&&(Y=Q.length)}),w==1/0&&(w=Y,p=C=!1),$&&w%x!=0&&(w=Math.floor(w/x)*x),F(p?P:Z)},this.toggleBlockComment=function(s,o,i,c){var d=this.blockComment;if(d){!d.start&&d[0]&&(d=d[0]);var C,p,w=(Z=new e(o,c.row,c.column)).getCurrentToken(),x=(o.selection,o.selection.toOrientedRange());if(w&&/comment/.test(w.type)){for(;w&&/comment/.test(w.type);){if((u=w.value.indexOf(d.start))!=-1){var $=Z.getCurrentTokenRow(),P=Z.getCurrentTokenColumn()+u,B=new n($,P,$,P+d.start.length);break}w=Z.stepBackward()}for(var Z,u,w=(Z=new e(o,c.row,c.column)).getCurrentToken();w&&/comment/.test(w.type);){if((u=w.value.indexOf(d.end))!=-1){var $=Z.getCurrentTokenRow(),P=Z.getCurrentTokenColumn()+u,v=new n($,P,$,P+d.end.length);break}w=Z.stepForward()}v&&o.remove(v),B&&(o.remove(B),C=B.start.row,p=-d.start.length)}else p=d.start.length,C=i.start.row,o.insert(i.end,d.end),o.insert(i.start,d.start);x.start.row==C&&(x.start.column+=p),x.end.row==C&&(x.end.column+=p),o.selection.fromOrientedRange(x)}},this.getNextLineIndent=function(s,o,i){return this.$getIndent(o)},this.checkOutdent=function(s,o,i){return!1},this.autoOutdent=function(s,o,i){},this.$getIndent=function(s){return s.match(/^\s*/)[0]},this.createWorker=function(s){return null},this.createModeDelegates=function(s){for(var o in this.$embeds=[],this.$modes={},s){var i,c,d;s[o]&&(c=(i=s[o]).prototype.$id,(d=m.$modes[c])||(m.$modes[c]=d=new i),m.$modes[o]||(m.$modes[o]=d),this.$embeds.push(o),this.$modes[o]=d)}for(var C=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],o=0;o<C.length;o++)(function(w){var x=C[o],$=w[x];w[C[o]]=function(){return this.$delegator(x,arguments,$)}})(this)},this.$delegator=function(s,o,i){var c=o[0]||"start";if(typeof c!="string"){if(Array.isArray(c[2])){var d=c[2][c[2].length-1];if(p=this.$modes[d])return p[s].apply(p,[c[1]].concat([].slice.call(o,1)))}c=c[0]||"start"}for(var C=0;C<this.$embeds.length;C++)if(this.$modes[this.$embeds[C]]){var p,w=c.split(this.$embeds[C]);if(!w[0]&&w[1])return o[0]=w[1],(p=this.$modes[this.$embeds[C]])[s].apply(p,o)}return d=i.apply(this,o),i?d:void 0},this.transformAction=function(s,o,i,c,d){if(this.$behaviour){var C,p=this.$behaviour.getBehaviours();for(C in p)if(p[C][o]){var w=p[C][o].apply(this,arguments);if(w)return w}}},this.getKeywords=function(s){if(!this.completionKeywords){var o=this.$tokenizer.rules,i=[];for(p in o)for(var c=o[p],d=0,C=c.length;d<C;d++)if(typeof c[d].token=="string")/keyword|support|storage/.test(c[d].token)&&i.push(c[d].regex);else if(typeof c[d].token=="object")for(var p,w=0,x=c[d].token.length;w<x;w++)/keyword|support|storage/.test(c[d].token[w])&&(p=c[d].regex.match(/\(.+?\)/g)[w],i.push(p.substr(1,p.length-2)));this.completionKeywords=i}return s?i.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(s,o,i,c){return(this.$keywordList||this.$createKeywordList()).map(function(d){return{name:d,value:d,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(I.prototype),f.Mode=I}),ace.define("ace/apply_delta",["require","exports","module"],function(A,f,T){f.applyDelta=function(I,m,h){var a=m.start.row,l=m.start.column,t=I[a]||"";switch(m.action){case"insert":m.lines.length===1?I[a]=t.substring(0,l)+m.lines[0]+t.substring(l):(r=[a,1].concat(m.lines),I.splice.apply(I,r),I[a]=t.substring(0,l)+I[a],I[a+m.lines.length-1]+=t.substring(l));break;case"remove":var r=m.end.column,e=m.end.row;a===e?I[a]=t.substring(0,l)+t.substring(r):I.splice(a,e-a+1,t.substring(0,l)+I[e].substring(r))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(m,f,T){var I=m("./lib/oop"),m=m("./lib/event_emitter").EventEmitter,h=(a.prototype.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},a.prototype.getDocument=function(){return this.document},a.prototype.onChange=function(t){t.start.row==t.end.row&&t.start.row!=this.row||t.start.row>this.row||(t=function(r,e,n){var c=r.action=="insert",s=(c?1:-1)*(r.end.row-r.start.row),o=(c?1:-1)*(r.end.column-r.start.column),i=r.start,c=c?i:r.end;return l(e,i,n)?{row:e.row,column:e.column}:l(c,e,!n)?{row:e.row+s,column:e.column+(e.row==c.row?o:0)}:{row:i.row,column:i.column}}(t,{row:this.row,column:this.column},this.$insertRight),this.setPosition(t.row,t.column,!0))},a.prototype.setPosition=function(t,r,e){e=e?{row:t,column:r}:this.$clipPositionToDocument(t,r),this.row==e.row&&this.column==e.column||(t={row:this.row,column:this.column},this.row=e.row,this.column=e.column,this._signal("change",{old:t,value:e}))},a.prototype.detach=function(){this.document.off("change",this.$onChange)},a.prototype.attach=function(t){this.document=t||this.document,this.document.on("change",this.$onChange)},a.prototype.$clipPositionToDocument=function(t,r){var e={};return t>=this.document.getLength()?(e.row=Math.max(0,this.document.getLength()-1),e.column=this.document.getLine(e.row).length):t<0?(e.row=0,e.column=0):(e.row=t,e.column=Math.min(this.document.getLine(e.row).length,Math.max(0,r))),r<0&&(e.column=0),e},a);function a(t,r,e){this.$onChange=this.onChange.bind(this),this.attach(t),e===void 0?this.setPosition(r.row,r.column):this.setPosition(r,e)}function l(t,r,e){return e=e?t.column<=r.column:t.column<r.column,t.row<r.row||t.row==r.row&&e}h.prototype.$insertRight=!1,I.implement(h.prototype,m),f.Anchor=h}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(t,f,T){var I=t("./lib/oop"),m=t("./apply_delta").applyDelta,h=t("./lib/event_emitter").EventEmitter,a=t("./range").Range,l=t("./anchor").Anchor,t=(r.prototype.setValue=function(e){var n=this.getLength()-1;this.remove(new a(0,0,n,this.getLine(n).length)),this.insert({row:0,column:0},e||"")},r.prototype.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},r.prototype.createAnchor=function(e,n){return new l(this,e,n)},r.prototype.$detectNewLine=function(e){e=e.match(/^.*?(\r\n|\r|\n)/m),this.$autoNewLine=e?e[1]:`
`,this._signal("changeNewLineMode")},r.prototype.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return`\r
`;case"unix":return`
`;default:return this.$autoNewLine||`
`}},r.prototype.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},r.prototype.getNewLineMode=function(){return this.$newLineMode},r.prototype.isNewLine=function(e){return e==`\r
`||e=="\r"||e==`
`},r.prototype.getLine=function(e){return this.$lines[e]||""},r.prototype.getLines=function(e,n){return this.$lines.slice(e,n+1)},r.prototype.getAllLines=function(){return this.getLines(0,this.getLength())},r.prototype.getLength=function(){return this.$lines.length},r.prototype.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},r.prototype.getLinesForRange=function(e){var n,s;return e.start.row===e.end.row?n=[this.getLine(e.start.row).substring(e.start.column,e.end.column)]:((n=this.getLines(e.start.row,e.end.row))[0]=(n[0]||"").substring(e.start.column),s=n.length-1,e.end.row-e.start.row==s&&(n[s]=n[s].substring(0,e.end.column))),n},r.prototype.insertLines=function(e,n){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,n)},r.prototype.removeLines=function(e,n){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,n)},r.prototype.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},r.prototype.insert=function(e,n){return this.getLength()<=1&&this.$detectNewLine(n),this.insertMergedLines(e,this.$split(n))},r.prototype.insertInLine=function(o,n){var s=this.clippedPos(o.row,o.column),o=this.pos(o.row,o.column+n.length);return this.applyDelta({start:s,end:o,action:"insert",lines:[n]},!0),this.clonePos(o)},r.prototype.clippedPos=function(e,n){var s=this.getLength(),s=(e===void 0?e=s:e<0?e=0:s<=e&&(e=s-1,n=void 0),this.getLine(e));return n==null&&(n=s.length),{row:e,column:n=Math.min(Math.max(n,0),s.length)}},r.prototype.clonePos=function(e){return{row:e.row,column:e.column}},r.prototype.pos=function(e,n){return{row:e,column:n}},r.prototype.$clipPosition=function(e){var n=this.getLength();return e.row>=n?(e.row=Math.max(0,n-1),e.column=this.getLine(n-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},r.prototype.insertFullLines=function(e,n){var s=0,s=(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(n=n.concat([""]),0):(n=[""].concat(n),this.$lines[--e].length);this.insertMergedLines({row:e,column:s},n)},r.prototype.insertMergedLines=function(s,n){var s=this.clippedPos(s.row,s.column),o={row:s.row+n.length-1,column:(n.length==1?s.column:0)+n[n.length-1].length};return this.applyDelta({start:s,end:o,action:"insert",lines:n}),this.clonePos(o)},r.prototype.remove=function(s){var n=this.clippedPos(s.start.row,s.start.column),s=this.clippedPos(s.end.row,s.end.column);return this.applyDelta({start:n,end:s,action:"remove",lines:this.getLinesForRange({start:n,end:s})}),this.clonePos(n)},r.prototype.removeInLine=function(e,n,s){return n=this.clippedPos(e,n),e=this.clippedPos(e,s),this.applyDelta({start:n,end:e,action:"remove",lines:this.getLinesForRange({start:n,end:e})},!0),this.clonePos(n)},r.prototype.removeFullLines=function(e,n){e=Math.min(Math.max(0,e),this.getLength()-1);var c=(n=Math.min(Math.max(0,n),this.getLength()-1))==this.getLength()-1&&0<e,o=n<this.getLength()-1,i=c?e-1:e,c=c?this.getLine(i).length:0,s=o?n+1:n,o=o?0:this.getLine(s).length,i=new a(i,c,s,o),c=this.$lines.slice(e,n+1);return this.applyDelta({start:i.start,end:i.end,action:"remove",lines:this.getLinesForRange(i)}),c},r.prototype.removeNewLine=function(e){e<this.getLength()-1&&0<=e&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},r.prototype.replace=function(e,n){return e instanceof a||(e=a.fromPoints(e.start,e.end)),n.length===0&&e.isEmpty()?e.start:n==this.getTextRange(e)?e.end:(this.remove(e),n?this.insert(e.start,n):e.start)},r.prototype.applyDeltas=function(e){for(var n=0;n<e.length;n++)this.applyDelta(e[n])},r.prototype.revertDeltas=function(e){for(var n=e.length-1;0<=n;n--)this.revertDelta(e[n])},r.prototype.applyDelta=function(e,n){var s=e.action=="insert";(s?e.lines.length<=1&&!e.lines[0]:!a.comparePoints(e.start,e.end))||(s&&2e4<e.lines.length?this.$splitAndapplyLargeDelta(e,2e4):(m(this.$lines,e,n),this._signal("change",e)))},r.prototype.$safeApplyDelta=function(e){var n=this.$lines.length;(e.action=="remove"&&e.start.row<n&&e.end.row<n||e.action=="insert"&&e.start.row<=n)&&this.applyDelta(e)},r.prototype.$splitAndapplyLargeDelta=function(e,n){for(var s=e.lines,o=s.length-n+1,i=e.start.row,c=e.start.column,d=0,C=0;d<o;d=C){C+=n-1;var p=s.slice(d,C);p.push(""),this.applyDelta({start:this.pos(i+d,c),end:this.pos(i+C,c=0),action:e.action,lines:p},!0)}e.lines=s.slice(d),e.start.row=i+d,e.start.column=c,this.applyDelta(e,!0)},r.prototype.revertDelta=function(e){this.$safeApplyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:e.action=="insert"?"remove":"insert",lines:e.lines.slice()})},r.prototype.indexToPosition=function(e,n){for(var s=this.$lines||this.getAllLines(),o=this.getNewLineCharacter().length,i=n||0,c=s.length;i<c;i++)if((e-=s[i].length+o)<0)return{row:i,column:e+s[i].length+o};return{row:c-1,column:e+s[c-1].length+o}},r.prototype.positionToIndex=function(e,n){for(var s=this.$lines||this.getAllLines(),o=this.getNewLineCharacter().length,i=0,c=Math.min(e.row,s.length),d=n||0;d<c;++d)i+=s[d].length+o;return i+e.column},r.prototype.$split=function(e){return e.split(/\r\n|\r|\n/)},r);function r(e){this.$lines=[""],e.length===0?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)}t.prototype.$autoNewLine="",t.prototype.$newLineMode="auto",I.implement(t.prototype,h),f.Document=t}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(m,f,T){var I=m("./lib/oop"),m=m("./lib/event_emitter").EventEmitter,h=(a.prototype.setTokenizer=function(l){this.tokenizer=l,this.lines=[],this.states=[],this.start(0)},a.prototype.setDocument=function(l){this.doc=l,this.lines=[],this.states=[],this.stop()},a.prototype.fireUpdateEvent=function(l,t){this._signal("update",{data:{first:l,last:t}})},a.prototype.start=function(l){this.currentLine=Math.min(l||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},a.prototype.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},a.prototype.$updateOnChange=function(l){var t=l.start.row,r=l.end.row-t;r==0?this.lines[t]=null:l.action=="remove"?(this.lines.splice(t,1+r,null),this.states.splice(t,1+r,null)):((l=Array(1+r)).unshift(t,1),this.lines.splice.apply(this.lines,l),this.states.splice.apply(this.states,l)),this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},a.prototype.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},a.prototype.getTokens=function(l){return this.lines[l]||this.$tokenizeRow(l)},a.prototype.getState=function(l){return this.currentLine==l&&this.$tokenizeRow(l),this.states[l]||"start"},a.prototype.$tokenizeRow=function(l){var r=this.doc.getLine(l),t=this.states[l-1],r=this.tokenizer.getLineTokens(r,t,l);return this.states[l]+""!=r.state+""?(this.states[l]=r.state,this.lines[l+1]=null,this.currentLine>l+1&&(this.currentLine=l+1)):this.currentLine==l&&(this.currentLine=l+1),this.lines[l]=r.tokens},a.prototype.cleanup=function(){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.removeAllListeners()},a);function a(l,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=l;var r=this;this.$worker=function(){if(r.running){for(var e=new Date,n=r.currentLine,s=-1,o=r.doc,i=n;r.lines[n];)n++;var c=o.getLength(),d=0;for(r.running=!1;n<c;){for(r.$tokenizeRow(n),s=n;n++,r.lines[n];);if(++d%5==0&&20<new Date-e){r.running=setTimeout(r.$worker,20);break}}r.currentLine=n,i<=(s=s==-1?n:s)&&r.fireUpdateEvent(i,s)}}}I.implement(h.prototype,m),f.BackgroundTokenizer=h}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/range"],function(h,f,T){var I=h("./lib/lang"),m=h("./range").Range,h=(a.prototype.setRegexp=function(l){this.regExp+""!=l+""&&(this.regExp=l,this.cache=[])},a.prototype.update=function(l,t,r,e){if(this.regExp)for(var n=e.firstRow,s=e.lastRow,o={},i=n;i<=s;i++){var c=this.cache[i];c==null&&(c=(c=(c=I.getMatchOffsets(r.getLine(i),this.regExp)).length>this.MAX_RANGES?c.slice(0,this.MAX_RANGES):c).map(function(w){return new m(i,w.offset,i,w.offset+w.length)}),this.cache[i]=c.length?c:"");for(var d=c.length;d--;){var C=c[d].toScreenRange(r),p=C.toString();o[p]||(o[p]=!0,t.drawSingleLineMarker(l,C,this.clazz,e))}}},a);function a(l,t,r){r===void 0&&(r="text"),this.setRegexp(l),this.clazz=t,this.type=r}h.prototype.MAX_RANGES=500,f.SearchHighlight=h}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(A,f,T){var I=A("../range").Range;function m(h,a){this.foldData=h,Array.isArray(a)?this.folds=a:a=this.folds=[a],h=a[a.length-1],this.range=new I(a[0].start.row,a[0].start.column,h.end.row,h.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(l){l.setFoldLine(this)},this)}m.prototype.shiftRow=function(h){this.start.row+=h,this.end.row+=h,this.folds.forEach(function(a){a.start.row+=h,a.end.row+=h})},m.prototype.addFold=function(h){if(h.sameRow){if(h.start.row<this.startRow||h.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(h),this.folds.sort(function(a,l){return-a.range.compareEnd(l.start.row,l.start.column)}),0<this.range.compareEnd(h.start.row,h.start.column)?(this.end.row=h.end.row,this.end.column=h.end.column):this.range.compareStart(h.end.row,h.end.column)<0&&(this.start.row=h.start.row,this.start.column=h.start.column)}else if(h.start.row==this.end.row)this.folds.push(h),this.end.row=h.end.row,this.end.column=h.end.column;else{if(h.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(h),this.start.row=h.start.row,this.start.column=h.start.column}h.foldLine=this},m.prototype.containsRow=function(h){return h>=this.start.row&&h<=this.end.row},m.prototype.walk=function(h,a,l){var t,r,e=0,n=this.folds,s=!0;a==null&&(a=this.end.row,l=this.end.column);for(var o=0;o<n.length;o++){if((r=(t=n[o]).range.compareStart(a,l))==-1)return void h(null,a,l,e,s);if(!h(null,t.start.row,t.start.column,e,s)&&h(t.placeholder,t.start.row,t.start.column,e)||r===0)return;s=!t.sameRow,e=t.end.column}h(null,a,l,e,s)},m.prototype.getNextFoldTo=function(h,a){for(var l,t,r=0;r<this.folds.length;r++){if((t=(l=this.folds[r]).range.compareEnd(h,a))==-1)return{fold:l,kind:"after"};if(t===0)return{fold:l,kind:"inside"}}return null},m.prototype.addRemoveChars=function(h,a,l){var t,r=this.getNextFoldTo(h,a);if(r){if(t=r.fold,r.kind=="inside"&&t.start.column!=a&&t.start.row!=h)window.console&&window.console.log(h,a,t);else if(t.start.row==h){var e,n=(e=this.folds).indexOf(t);for(n===0&&(this.start.column+=l);n<e.length;n++){if((t=e[n]).start.column+=l,!t.sameRow)return;t.end.column+=l}this.end.column+=l}}},m.prototype.split=function(r,a){var l,t,r=this.getNextFoldTo(r,a);return r&&r.kind!="inside"?(a=r.fold,r=this.folds,l=this.foldData,a=r.indexOf(a),t=r[a-1],this.end.row=t.end.row,this.end.column=t.end.column,t=new m(l,r=r.splice(a,r.length-a)),l.splice(l.indexOf(this)+1,0,t),t):null},m.prototype.merge=function(h){for(var a=h.folds,l=0;l<a.length;l++)this.addFold(a[l]);var t=this.foldData;t.splice(t.indexOf(h),1)},m.prototype.toString=function(){var h=[this.range.toString()+": ["];return this.folds.forEach(function(a){h.push("  "+a.toString())}),h.push("]"),h.join(`
`)},m.prototype.idxToPosition=function(h){for(var a=0,l=0;l<this.folds.length;l++){var t=this.folds[l];if((h-=t.start.column-a)<0)return{row:t.start.row,column:t.start.column+h};if((h-=t.placeholder.length)<0)return t.start;a=t.end.column}return{row:this.end.row,column:this.end.column+h}},f.FoldLine=m}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(m,f,T){var I=m("./range").Range.comparePoints,m=(h.prototype.pointIndex=function(a,l,t){for(var r=this.ranges,e=t||0;e<r.length;e++){var n=r[e],s=I(a,n.end);if(!(0<s))return n=I(a,n.start),s===0?l&&n!==0?-e-2:e:0<n||n===0&&!l?e:-e-1}return-e-1},h.prototype.add=function(a){var t=!a.isEmpty(),l=this.pointIndex(a.start,t),t=this.pointIndex(a.end,t,l=l<0?-l-1:l);return t<0?t=-t-1:t++,this.ranges.splice(l,t-l,a)},h.prototype.addList=function(a){for(var l=[],t=a.length;t--;)l.push.apply(l,this.add(a[t]));return l},h.prototype.substractPoint=function(a){if(a=this.pointIndex(a),0<=a)return this.ranges.splice(a,1)},h.prototype.merge=function(){for(var a=[],l=this.ranges,t=(l=l.sort(function(s,o){return I(s.start,o.start)}))[0],r=1;r<l.length;r++){var e=t,t=l[r],n=I(e.end,t.start);n<0||(n!=0||e.isEmpty()||t.isEmpty())&&(I(e.end,t.end)<0&&(e.end.row=t.end.row,e.end.column=t.end.column),l.splice(r,1),a.push(t),t=e,r--)}return this.ranges=l,a},h.prototype.contains=function(a,l){return 0<=this.pointIndex({row:a,column:l})},h.prototype.containsPoint=function(a){return 0<=this.pointIndex(a)},h.prototype.rangeAtPoint=function(a){if(a=this.pointIndex(a),0<=a)return this.ranges[a]},h.prototype.clipRows=function(a,l){var t=this.ranges;if(t[0].start.row>l||t[t.length-1].start.row<a)return[];for(var a=this.pointIndex({row:a,column:0}),r=this.pointIndex({row:l,column:0},a=a<0?-a-1:a),e=(r<0&&(r=-r-1),[]),n=a;n<r;n++)e.push(t[n]);return e},h.prototype.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},h.prototype.attach=function(a){this.session&&this.detach(),this.session=a,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},h.prototype.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},h.prototype.$onChange=function(a){for(var l=a.start,t=a.end,r=l.row,e=t.row,n=this.ranges,s=0,o=n.length;s<o&&!((d=n[s]).end.row>=r);s++);if(a.action=="insert")for(var i=e-r,c=-l.column+t.column;s<o&&!((d=n[s]).start.row>r);s++)d.start.row==r&&d.start.column>=l.column&&(d.start.column==l.column&&this.$bias<=0||(d.start.column+=c,d.start.row+=i)),d.end.row==r&&d.end.column>=l.column&&(d.end.column==l.column&&this.$bias<0||(d.end.column==l.column&&0<c&&s<o-1&&d.end.column>d.start.column&&d.end.column==n[s+1].start.column&&(d.end.column-=c),d.end.column+=c,d.end.row+=i));else for(var d,i=r-e,c=l.column-t.column;s<o&&!((d=n[s]).start.row>e);s++)d.end.row<e&&(r<d.end.row||r==d.end.row&&l.column<d.end.column)?(d.end.row=r,d.end.column=l.column):d.end.row==e?d.end.column<=t.column?(i||d.end.column>l.column)&&(d.end.column=l.column,d.end.row=l.row):(d.end.column+=c,d.end.row+=i):d.end.row>e&&(d.end.row+=i),d.start.row<e&&(r<d.start.row||r==d.start.row&&l.column<d.start.column)?(d.start.row=r,d.start.column=l.column):d.start.row==e?d.start.column<=t.column?(i||d.start.column>l.column)&&(d.start.column=l.column,d.start.row=l.row):(d.start.column+=c,d.start.row+=i):d.start.row>e&&(d.start.row+=i);if(i!=0&&s<o)for(;s<o;s++)(d=n[s]).start.row+=i,d.end.row+=i},h);function h(){this.ranges=[],this.$bias=1}m.prototype.comparePoints=I,f.RangeList=m}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list"],function(h,f,T){var I,m,a=this&&this.__extends||(I=function(e,n){return(I=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(s,o){s.__proto__=o}:function(s,o){for(var i in o)Object.prototype.hasOwnProperty.call(o,i)&&(s[i]=o[i])}))(e,n)},function(e,n){if(typeof n!="function"&&n!==null)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function s(){this.constructor=e}I(e,n),e.prototype=n===null?Object.create(n):(s.prototype=n.prototype,new s)}),h=h("../range_list").RangeList,a=(a(l,m=h),l.prototype.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},l.prototype.setFoldLine=function(e){this.foldLine=e,this.subFolds.forEach(function(n){n.setFoldLine(e)})},l.prototype.clone=function(){var e=new l(this.range.clone(),this.placeholder);return this.subFolds.forEach(function(n){e.subFolds.push(n.clone())}),e.collapseChildren=this.collapseChildren,e},l.prototype.addSubFold=function(e){if(!this.range.isEqual(e)){c=e,d=this.start,t(c.start,d),t(c.end,d);for(var n=e.start.row,s=e.start.column,o=0,i=-1;o<this.subFolds.length&&(i=this.subFolds[o].range.compare(n,s))==1;o++);var c=this.subFolds[o],d=0;if(i==0){if(c.range.containsRange(e))return c.addSubFold(e);d=1}for(var n=e.range.end.row,s=e.range.end.column,C=o,i=-1;C<this.subFolds.length&&(i=this.subFolds[C].range.compare(n,s))==1;C++);i==0&&C++;for(var p=this.subFolds.splice(o,C-o,e),w=i==0?p.length-1:p.length,x=d;x<w;x++)e.addSubFold(p[x]);return e.setFoldLine(this.foldLine),e}},l.prototype.restoreRange=function(e){return e=e,n=this.start,r(e.start,n),void r(e.end,n);var n},l);function l(e,n){var s=m.call(this)||this;return s.foldLine=null,s.placeholder=n,s.range=e,s.start=e.start,s.end=e.end,s.sameRow=e.start.row==e.end.row,s.subFolds=s.ranges=[],s}function t(e,n){e.row-=n.row,e.row==0&&(e.column-=n.column)}function r(e,n){e.row==0&&(e.column+=n.column),e.row+=n.row}f.Fold=a}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator","ace/mouse/mouse_event"],function(A,f,T){var I=A("../range").Range,m=A("./fold_line").FoldLine,h=A("./fold").Fold,a=A("../token_iterator").TokenIterator,l=A("../mouse/mouse_event").MouseEvent;f.Folding=function(){this.getFoldAt=function(t,r,e){var n=this.getFoldLine(t);if(!n)return null;for(var s=n.folds,o=0;o<s.length;o++){var i=s[o].range;if(i.contains(t,r)&&(e!=1||!i.isEnd(t,r)||i.isEmpty())&&(e!=-1||!i.isStart(t,r)||i.isEmpty()))return s[o]}},this.getFoldsInRange=function(t){var r=t.start,e=t.end,n=this.$foldData,s=[];r.column+=1,--e.column;for(var o=0;o<n.length;o++){var i=n[o].range.compareRange(t);if(i!=2){if(i==-2)break;for(var c=n[o].folds,d=0;d<c.length;d++){var C=c[d];if((i=C.range.compareRange(t))==-2)break;if(i!=2){if(i==42)break;s.push(C)}}}}return--r.column,e.column+=1,s},this.getFoldsInRangeList=function(t){var r;return Array.isArray(t)?(r=[],t.forEach(function(e){r=r.concat(this.getFoldsInRange(e))},this)):r=this.getFoldsInRange(t),r},this.getAllFolds=function(){for(var t=[],r=this.$foldData,e=0;e<r.length;e++)for(var n=0;n<r[e].folds.length;n++)t.push(r[e].folds[n]);return t},this.getFoldStringAt=function(t,r,e,n){if(!(n=n||this.getFoldLine(t)))return null;for(var s,o={end:{column:0}},i=0;i<n.folds.length;i++){var c,d=(c=n.folds[i]).range.compareEnd(t,r);if(d==-1){s=this.getLine(c.start.row).substring(o.end.column,c.start.column);break}if(d===0)return null;o=c}return s=s||this.getLine(c.start.row).substring(o.end.column),e==-1?s.substring(0,r-o.end.column):e==1?s.substring(r-o.end.column):s},this.getFoldLine=function(t,r){var e=this.$foldData,n=0;for((n=r?e.indexOf(r):n)==-1&&(n=0);n<e.length;n++){var s=e[n];if(s.start.row<=t&&s.end.row>=t)return s;if(s.end.row>t)return null}return null},this.getNextFoldLine=function(t,r){var e=this.$foldData,n=0;for((n=r?e.indexOf(r):n)==-1&&(n=0);n<e.length;n++){var s=e[n];if(s.end.row>=t)return s}return null},this.getFoldedRowCount=function(t,r){for(var e=this.$foldData,n=r-t+1,s=0;s<e.length;s++){var i=e[s],o=i.end.row,i=i.start.row;if(r<=o){i<r&&(t<=i?n-=r-i:n=0);break}t<=o&&(n-=t<=i?o-i:o-t+1)}return n},this.$addFoldLine=function(t){return this.$foldData.push(t),this.$foldData.sort(function(r,e){return r.start.row-e.start.row}),t},this.addFold=function(i,d){var e,n=this.$foldData,s=!1,o=(i instanceof h?e=i:(e=new h(d,i)).collapseChildren=d.collapseChildren,this.$clipRangeToDocument(e.range),e.start.row),i=e.start.column,c=e.end.row,d=e.end.column,C=this.getFoldAt(o,i,1),p=this.getFoldAt(c,d,-1);if(C&&p==C)return C.addSubFold(e);C&&!C.range.isStart(o,i)&&this.removeFold(C),p&&!p.range.isEnd(c,d)&&this.removeFold(p),i=this.getFoldsInRange(e.range),0<i.length&&(this.removeFolds(i),e.collapseChildren||i.forEach(function(P){e.addSubFold(P)}));for(var w=0;w<n.length;w++){var x=n[w];if(c==x.start.row){x.addFold(e),s=!0;break}if(o==x.end.row){if(x.addFold(e),s=!0,!e.sameRow){var $=n[w+1];if($&&$.start.row==c){x.merge($);break}}break}if(c<=x.start.row)break}return s||(x=this.$addFoldLine(new m(this.$foldData,e))),this.$useWrapMode?this.$updateWrapData(x.start.row,x.start.row):this.$updateRowLengthCache(x.start.row,x.start.row),this.$modified=!0,this._signal("changeFold",{data:e,action:"add"}),e},this.addFolds=function(t){t.forEach(function(r){this.addFold(r)},this)},this.removeFold=function(t){var r=t.foldLine,e=r.start.row,n=r.end.row,s=this.$foldData,o=r.folds;o.length==1?s.splice(s.indexOf(r),1):r.range.isEnd(t.end.row,t.end.column)?(o.pop(),r.end.row=o[o.length-1].end.row,r.end.column=o[o.length-1].end.column):r.range.isStart(t.start.row,t.start.column)?(o.shift(),r.start.row=o[0].start.row,r.start.column=o[0].start.column):t.sameRow?o.splice(o.indexOf(t),1):((o=(s=r.split(t.start.row,t.start.column)).folds).shift(),s.start.row=o[0].start.row,s.start.column=o[0].start.column),this.$updating||(this.$useWrapMode?this.$updateWrapData(e,n):this.$updateRowLengthCache(e,n)),this.$modified=!0,this._signal("changeFold",{data:t,action:"remove"})},this.removeFolds=function(t){for(var r=[],e=0;e<t.length;e++)r.push(t[e]);r.forEach(function(n){this.removeFold(n)},this),this.$modified=!0},this.expandFold=function(t){this.removeFold(t),t.subFolds.forEach(function(r){t.restoreRange(r),this.addFold(r)},this),0<t.collapseChildren&&this.foldAll(t.start.row+1,t.end.row,t.collapseChildren-1),t.subFolds=[]},this.expandFolds=function(t){t.forEach(function(r){this.expandFold(r)},this)},this.unfold=function(t,r){var e;if(t==null)e=new I(0,0,this.getLength(),0),r==null&&(r=!0);else if(typeof t=="number")e=new I(t,0,t,this.getLine(t).length);else if("row"in t)e=I.fromPoints(t,t);else{if(Array.isArray(t))return n=[],t.forEach(function(s){n=n.concat(this.unfold(s))},this),n;e=t}for(var n,t=n=this.getFoldsInRangeList(e);n.length==1&&I.comparePoints(n[0].start,e.start)<0&&0<I.comparePoints(n[0].end,e.end);)this.expandFolds(n),n=this.getFoldsInRangeList(e);if(r!=0?this.removeFolds(n):this.expandFolds(n),t.length)return t},this.isRowFolded=function(t,r){return!!this.getFoldLine(t,r)},this.getRowFoldEnd=function(t,r){return r=this.getFoldLine(t,r),r?r.end.row:t},this.getRowFoldStart=function(t,r){return r=this.getFoldLine(t,r),r?r.start.row:t},this.getFoldDisplayLine=function(t,r,e,n,s){n==null&&(n=t.start.row),s==null&&(s=0),r==null&&(r=t.end.row),e==null&&(e=this.getLine(r).length);var o=this.doc,i="";return t.walk(function(c,d,C,p){if(!(d<n)){if(d==n){if(C<s)return;p=Math.max(s,p)}i+=c??o.getLine(d).substring(p,C)}},r,e),i},this.getDisplayLine=function(t,r,e,n){var s=this.getFoldLine(t);return s?this.getFoldDisplayLine(s,t,r,e,n):(s=this.doc.getLine(t)).substring(n||0,r||s.length)},this.$cloneFoldData=function(){var t=[];return t=this.$foldData.map(function(r){return r=r.folds.map(function(e){return e.clone()}),new m(t,r)})},this.toggleFold=function(t){var r=this.selection.getRange();if(r.isEmpty()){var e,n=r.start;if(e=this.getFoldAt(n.row,n.column))return void this.expandFold(e);(s=this.findMatchingBracket(n))?r.comparePoint(s)==1?r.end=s:(r.start=s,r.start.column++,r.end.column--):(s=this.findMatchingBracket({row:n.row,column:n.column+1}))?(r.comparePoint(s)==1?r.end=s:r.start=s,r.start.column++):r=this.getCommentFoldRange(n.row,n.column)||r}else{var s=this.getFoldsInRange(r);if(t&&s.length)return void this.expandFolds(s);s.length==1&&(e=s[0])}if((e=e||this.getFoldAt(r.start.row,r.start.column))&&e.range.toString()==r.toString())this.expandFold(e);else{if(n="...",!r.isMultiLine()){if((n=this.getTextRange(r)).length<4)return;n=n.trim().substring(0,2)+".."}this.addFold(n,r)}},this.getCommentFoldRange=function(t,r,e){var n=new a(this,t,r),s=n.getCurrentToken(),o=s&&s.type;if(s&&/^comment|string/.test(o)){(o=o.match(/comment|string/)[0])=="comment"&&(o+="|doc-start");var i=new RegExp(o),o=new I;if(e!=1){for(;(s=n.stepBackward())&&i.test(s.type)&&!/^comment.end/.test(s.type););s=n.stepForward()}if(o.start.row=n.getCurrentTokenRow(),o.start.column=n.getCurrentTokenColumn()+(/^comment.start/.test(s.type)?s.value.length:2),n=new a(this,t,r),e!=-1){var c=-1;do if(s=n.stepForward(),c==-1){var d=this.getState(n.$row);i.test(d)||(c=n.$row)}else if(n.$row>c)break;while(s&&i.test(s.type)&&!/^comment.start/.test(s.type));s=n.stepBackward()}else s=n.getCurrentToken();return o.end.row=n.getCurrentTokenRow(),o.end.column=n.getCurrentTokenColumn(),/^comment.end/.test(s.type)||(o.end.column+=s.value.length-2),o}},this.foldAll=function(t,r,e,n){e==null&&(e=1e5);var s=this.foldWidgets;if(s){r=r||this.getLength();for(var o,i=t=t||0;i<r;i++)s[i]==null&&(s[i]=this.getFoldWidget(i)),s[i]!="start"||n&&!n(i)||(o=this.getFoldWidgetRange(i))&&o.isMultiLine()&&o.end.row<=r&&o.start.row>=t&&(i=o.end.row,o.collapseChildren=e,this.addFold("...",o))}},this.foldToLevel=function(t){for(this.foldAll();0<t--;)this.unfold(null,!1)},this.foldAllComments=function(){var t=this;this.foldAll(null,null,null,function(r){for(var e=t.getTokens(r),n=0;n<e.length;n++){var s=e[n];if(s.type!="text"||!/^\s+$/.test(s.value))return!!/comment/.test(s.type)}})},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(t){if(!this.$foldStyles[t])throw new Error("invalid fold style: "+t+"["+Object.keys(this.$foldStyles).join(", ")+"]");this.$foldStyle!=t&&((this.$foldStyle=t)=="manual"&&this.unfold(),t=this.$foldMode,this.$setFolding(null),this.$setFolding(t))},this.$setFolding=function(t){this.$foldMode!=t&&(this.$foldMode=t,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),t&&this.$foldStyle!="manual"?(this.foldWidgets=[],this.getFoldWidget=t.getFoldWidget.bind(t,this,this.$foldStyle),this.getFoldWidgetRange=t.getFoldWidgetRange.bind(t,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(t,r){var e=this.foldWidgets;if(!e||r&&e[t])return{};for(var n=t-1;0<=n;){var s=e[n];if((s=s??(e[n]=this.getFoldWidget(n)))=="start"){var o=this.getFoldWidgetRange(n),i=i||o;if(o&&o.end.row>=t)break}n--}return{range:n!==-1&&o,firstRange:i}},this.onFoldWidgetClick=function(t,r){var e={children:(r=r instanceof l?r.domEvent:r).shiftKey,all:r.ctrlKey||r.metaKey,siblings:r.altKey};this.$toggleFoldWidget(t,e)||(t=r.target||r.srcElement)&&/ace_fold-widget/.test(t.className)&&(t.className+=" ace_invalid")},this.$toggleFoldWidget=function(t,r){var e,n,s,o;if(this.getFoldWidget)return e=this.getFoldWidget(t),n=this.getLine(t),(n=this.getFoldAt(t,(e=e==="end"?-1:1)==-1?0:n.length,e))?(r.children||r.all?this.removeFold(n):this.expandFold(n),n):(e=this.getFoldWidgetRange(t,!0))&&!e.isMultiLine()&&(n=this.getFoldAt(e.start.row,e.start.column,1))&&e.isEqual(n.range)?(this.removeFold(n),n):(r.siblings?((n=this.getParentFoldRangeData(t)).range&&(s=n.range.start.row+1,o=n.range.end.row),this.foldAll(s,o,r.all?1e4:0)):r.children?(o=e?e.end.row:this.getLength(),this.foldAll(t+1,o,r.all?1e4:0)):e&&(r.all&&(e.collapseChildren=1e4),this.addFold("...",e)),e)},this.toggleFoldWidget=function(t){var r,e=this.selection.getCursor().row;e=this.getRowFoldStart(e),!this.$toggleFoldWidget(e,{})&&(r=(r=this.getParentFoldRangeData(e,!0)).range||r.firstRange)&&(e=r.start.row,(e=this.getFoldAt(e,this.getLine(e).length,1))?this.removeFold(e):this.addFold("...",r))},this.updateFoldWidgets=function(t){var r=t.start.row,e=t.end.row-r;e==0?this.foldWidgets[r]=null:t.action=="remove"?this.foldWidgets.splice(r,1+e,null):((t=Array(1+e)).unshift(r,1),this.foldWidgets.splice.apply(this.foldWidgets,t))},this.tokenizerUpdateFoldWidgets=function(t){t=t.data,t.first!=t.last&&this.foldWidgets.length>t.first&&this.foldWidgets.splice(t.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(A,f,T){var I=A("../token_iterator").TokenIterator,m=A("../range").Range;f.BracketMatch=function(){this.findMatchingBracket=function(h,a){return h.column!=0&&(a=a||this.getLine(h.row).charAt(h.column-1))!=""&&(a=a.match(/([\(\[\{])|([\)\]\}])/))?a[1]?this.$findClosingBracket(a[1],h):this.$findOpeningBracket(a[2],h):null},this.getBracketRange=function(h){var a,l,t=this.getLine(h.row),r=!0,e=t.charAt(h.column-1),n=e&&e.match(/([\(\[\{])|([\)\]\}])/);if(n||(e=t.charAt(h.column),h={row:h.row,column:h.column+1},n=e&&e.match(/([\(\[\{])|([\)\]\}])/),r=!1),!n)return null;if(n[1]){if(!(l=this.$findClosingBracket(n[1],h)))return null;a=m.fromPoints(h,l),r||(a.end.column++,a.start.column--),a.cursor=a.end}else{if(!(l=this.$findOpeningBracket(n[2],h)))return null;a=m.fromPoints(l,h),r||(a.start.column++,a.end.column--),a.cursor=a.start}return a},this.getMatchingBracketRanges=function(h,a){var l=this.getLine(h.row),t=/([\(\[\{])|([\)\]\}])/,r=!a&&l.charAt(h.column-1),e=r&&r.match(t);return e||(r=(a===void 0||a)&&l.charAt(h.column),h={row:h.row,column:h.column+1},e=r&&r.match(t)),e?(a=new m(h.row,h.column-1,h.row,h.column),(l=e[1]?this.$findClosingBracket(e[1],h):this.$findOpeningBracket(e[2],h))?[a,new m(l.row,l.column,l.row,l.column+1)]:[a]):null},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(h,a,l){var t=this.$brackets[h],r=1,e=new I(this,a.row,a.column),n=e.getCurrentToken();if(n=n||e.stepForward()){l=l||new RegExp("(\\.?"+n.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)").replace(/-close\b/,"-(close|open)")+")+");for(var s=a.column-e.getCurrentTokenColumn()-2,o=n.value;;){for(;0<=s;){var i=o.charAt(s);if(i==t){if(--r==0)return{row:e.getCurrentTokenRow(),column:s+e.getCurrentTokenColumn()}}else i==h&&(r+=1);--s}for(;(n=e.stepBackward())&&!l.test(n.type););if(n==null)break;s=(o=n.value).length-1}return null}},this.$findClosingBracket=function(h,a,l){var t=this.$brackets[h],r=1,e=new I(this,a.row,a.column),n=e.getCurrentToken();if(n=n||e.stepForward()){l=l||new RegExp("(\\.?"+n.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)").replace(/-open\b/,"-(close|open)")+")+");for(var s=a.column-e.getCurrentTokenColumn();;){for(var o=n.value,i=o.length;s<i;){var c=o.charAt(s);if(c==t){if(--r==0)return{row:e.getCurrentTokenRow(),column:s+e.getCurrentTokenColumn()}}else c==h&&(r+=1);s+=1}for(;(n=e.stepForward())&&!l.test(n.type););if(n==null)break;s=0}return null}},this.getMatchingTags=function(a){var a=new I(this,a.row,a.column),l=this.$findTagName(a);if(l)return a.stepBackward().value==="<"?this.$findClosingTag(a,l):this.$findOpeningTag(a,l)},this.$findTagName=function(h){var a=h.getCurrentToken(),l=!1,t=!1;if(a&&a.type.indexOf("tag-name")===-1)for(;(a=t?h.stepBackward():h.stepForward())&&(a.value==="/>"?t=!0:a.type.indexOf("tag-name")!==-1&&(l=!0)),a&&!l;);return a},this.$findClosingTag=function(h,a){var l=a.value,t=a.value,r=0,e=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+1),n=(a=h.stepForward(),new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+a.value.length)),s=!1;do{var o,i=a;if(a=h.stepForward())if(a.value!==">"||s||(o=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+1),s=!0),a.type.indexOf("tag-name")!==-1){if(t===(l=a.value)){if(i.value==="<")r++;else if(i.value==="</"&&--r<0){h.stepBackward();var c=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+2),d=(a=h.stepForward(),new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+a.value.length));if(!(a=h.stepForward())||a.value!==">")return;var C=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+1)}}}else t===l&&a.value==="/>"&&--r<0&&(C=d=c=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+2),o=new m(n.end.row,n.end.column,n.end.row,n.end.column+1))}while(a&&0<=r);if(e&&o&&c&&C&&n&&d)return{openTag:new m(e.start.row,e.start.column,o.end.row,o.end.column),closeTag:new m(c.start.row,c.start.column,C.end.row,C.end.column),openTagName:n,closeTagName:d}},this.$findOpeningTag=function(h,a){var l,t=h.getCurrentToken(),r=a.value,e=0,n=h.getCurrentTokenRow(),s=h.getCurrentTokenColumn(),o=new m(n,s,n,s+2),i=(h.stepForward(),new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+a.value.length));if((a=h.stepForward())&&a.value===">"){var c=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+1);h.stepBackward(),h.stepBackward();do if(a=t,n=h.getCurrentTokenRow(),l=(s=h.getCurrentTokenColumn())+a.value.length,t=h.stepBackward(),a){if(a.type.indexOf("tag-name")!==-1){if(r===a.value)if(t.value==="<"){if(0<++e){for(var d=new m(n,s,n,l),C=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+1);(a=h.stepForward())&&a.value!==">";);var p=new m(h.getCurrentTokenRow(),h.getCurrentTokenColumn(),h.getCurrentTokenRow(),h.getCurrentTokenColumn()+1)}}else t.value==="</"&&e--}else if(a.value==="/>"){for(var w=0,x=t;x;){if(x.type.indexOf("tag-name")!==-1&&x.value===r){e--;break}if(x.value==="<")break;x=h.stepBackward(),w++}for(var $=0;$<w;$++)h.stepForward()}}while(t&&e<=0);return C&&p&&o&&c&&d&&i?{openTag:new m(C.start.row,C.start.column,p.end.row,p.end.column),closeTag:new m(o.start.row,o.start.column,c.end.row,c.end.column),openTagName:d,closeTagName:i}:void 0}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(A,f,T){var I=A("./lib/oop"),m=A("./lib/lang"),h=A("./bidihandler").BidiHandler,a=A("./config"),l=A("./lib/event_emitter").EventEmitter,t=A("./selection").Selection,r=A("./mode/text").Mode,e=A("./range").Range,n=A("./document").Document,s=A("./background_tokenizer").BackgroundTokenizer,o=A("./search_highlight").SearchHighlight,i=(c.prototype.setDocument=function(u){this.doc&&this.doc.off("change",this.$onChange),(this.doc=u).on("change",this.$onChange,!0),this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},c.prototype.getDocument=function(){return this.doc},c.prototype.$resetRowCache=function(u){var v;u?(v=this.$docRowCache.length,(u=this.$getRowCacheIndex(this.$docRowCache,u)+1)<v&&(this.$docRowCache.splice(u,v),this.$screenRowCache.splice(u,v))):(this.$docRowCache=[],this.$screenRowCache=[])},c.prototype.$getRowCacheIndex=function(u,v){for(var N=0,y=u.length-1;N<=y;){var _=N+y>>1,W=u[_];if(W<v)N=1+_;else{if(!(v<W))return _;y=_-1}}return N-1},c.prototype.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.destroyed||this.bgTokenizer.start(0)},c.prototype.onChangeFold=function(u){u=u.data,this.$resetRowCache(u.start.row)},c.prototype.onChange=function(u){this.$modified=!0,this.$bidiHandler.onChange(u),this.$resetRowCache(u.start.row);var v=this.$updateInternalDataOnChange(u);!this.$fromUndo&&this.$undoManager&&(v&&v.length&&(this.$undoManager.add({action:"removeFolds",folds:v},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(u,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer.$updateOnChange(u),this._signal("change",u)},c.prototype.setValue=function(u){this.doc.setValue(u),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},c.prototype.toString=function(){return this.doc.getValue()},c.prototype.getSelection=function(){return this.selection},c.prototype.getState=function(u){return this.bgTokenizer.getState(u)},c.prototype.getTokens=function(u){return this.bgTokenizer.getTokens(u)},c.prototype.getTokenAt=function(u,v){var N=this.bgTokenizer.getTokens(u),_=0;if(v==null)var y=N.length-1,_=this.getLine(u).length;else for(y=0;y<N.length&&!(v<=(_+=N[y].value.length));y++);return(u=N[y])?(u.index=y,u.start=_-u.value.length,u):null},c.prototype.setUndoManager=function(u){var v;this.$undoManager=u,this.$informUndoManager&&this.$informUndoManager.cancel(),u?(u.addSession(v=this),this.$syncInformUndoManager=function(){v.$informUndoManager.cancel(),v.mergeUndoDeltas=!1},this.$informUndoManager=m.delayedCall(this.$syncInformUndoManager)):this.$syncInformUndoManager=function(){}},c.prototype.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},c.prototype.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},c.prototype.getTabString=function(){return this.getUseSoftTabs()?m.stringRepeat(" ",this.getTabSize()):"	"},c.prototype.setUseSoftTabs=function(u){this.setOption("useSoftTabs",u)},c.prototype.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},c.prototype.setTabSize=function(u){this.setOption("tabSize",u)},c.prototype.getTabSize=function(){return this.$tabSize},c.prototype.isTabStop=function(u){return this.$useSoftTabs&&u.column%this.$tabSize==0},c.prototype.setNavigateWithinSoftTabs=function(u){this.setOption("navigateWithinSoftTabs",u)},c.prototype.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},c.prototype.setOverwrite=function(u){this.setOption("overwrite",u)},c.prototype.getOverwrite=function(){return this.$overwrite},c.prototype.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},c.prototype.addGutterDecoration=function(u,v){this.$decorations[u]||(this.$decorations[u]=""),this.$decorations[u]+=" "+v,this._signal("changeBreakpoint",{})},c.prototype.removeGutterDecoration=function(u,v){this.$decorations[u]=(this.$decorations[u]||"").replace(" "+v,""),this._signal("changeBreakpoint",{})},c.prototype.getBreakpoints=function(){return this.$breakpoints},c.prototype.setBreakpoints=function(u){this.$breakpoints=[];for(var v=0;v<u.length;v++)this.$breakpoints[u[v]]="ace_breakpoint";this._signal("changeBreakpoint",{})},c.prototype.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},c.prototype.setBreakpoint=function(u,v){(v=v===void 0?"ace_breakpoint":v)?this.$breakpoints[u]=v:delete this.$breakpoints[u],this._signal("changeBreakpoint",{})},c.prototype.clearBreakpoint=function(u){delete this.$breakpoints[u],this._signal("changeBreakpoint",{})},c.prototype.addMarker=function(W,v,N,y){var _=this.$markerId++,W={range:W,type:N||"line",renderer:typeof N=="function"?N:null,clazz:v,inFront:!!y,id:_};return y?(this.$frontMarkers[_]=W,this._signal("changeFrontMarker")):(this.$backMarkers[_]=W,this._signal("changeBackMarker")),_},c.prototype.addDynamicMarker=function(u,v){var N;if(u.update)return N=this.$markerId++,u.id=N,u.inFront=!!v,v?(this.$frontMarkers[N]=u,this._signal("changeFrontMarker")):(this.$backMarkers[N]=u,this._signal("changeBackMarker")),u},c.prototype.removeMarker=function(u){var v=this.$frontMarkers[u]||this.$backMarkers[u];v&&(delete(v.inFront?this.$frontMarkers:this.$backMarkers)[u],this._signal(v.inFront?"changeFrontMarker":"changeBackMarker"))},c.prototype.getMarkers=function(u){return u?this.$frontMarkers:this.$backMarkers},c.prototype.highlight=function(u){var v;this.$searchHighlight||(v=new o(null,"ace_selected-word","text"),this.$searchHighlight=this.addDynamicMarker(v)),this.$searchHighlight.setRegexp(u)},c.prototype.highlightLines=function(u,v,N,y){return typeof v!="number"&&(N=v,v=u),N=N||"ace_step",u=new e(u,0,v,1/0),u.id=this.addMarker(u,N,"fullLine",y),u},c.prototype.setAnnotations=function(u){this.$annotations=u,this._signal("changeAnnotation",{})},c.prototype.getAnnotations=function(){return this.$annotations||[]},c.prototype.clearAnnotations=function(){this.setAnnotations([])},c.prototype.$detectNewLine=function(u){u=u.match(/^.*?(\r?\n)/m),this.$autoNewLine=u?u[1]:`
`},c.prototype.getWordRange=function(u,v){var N,y=this.getLine(u),_=!1,W=(N=(_=(_=0<v?!!y.charAt(v-1).match(this.tokenRe):_)||!!y.charAt(v).match(this.tokenRe))?this.tokenRe:/^\s+$/.test(y.slice(v-1,v+1))?/\s/:this.nonTokenRe,v);if(0<W){for(;0<=--W&&y.charAt(W).match(N););W++}for(var F=v;F<y.length&&y.charAt(F).match(N);)F++;return new e(u,W,u,F)},c.prototype.getAWordRange=function(u,v){for(var N=this.getWordRange(u,v),y=this.getLine(N.end.row);y.charAt(N.end.column).match(/[ \t]/);)N.end.column+=1;return N},c.prototype.setNewLineMode=function(u){this.doc.setNewLineMode(u)},c.prototype.getNewLineMode=function(){return this.doc.getNewLineMode()},c.prototype.setUseWorker=function(u){this.setOption("useWorker",u)},c.prototype.getUseWorker=function(){return this.$useWorker},c.prototype.onReloadTokenizer=function(u){var v=u.data;this.bgTokenizer.start(v.first),this._signal("tokenizerUpdate",u)},c.prototype.setMode=function(u,v){if(u&&typeof u=="object"){if(u.getTokenizer)return this.$onChangeMode(u);var N=u,y=N.path}else y=u||"ace/mode/text";this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new r),this.$modes[y]&&!N?(this.$onChangeMode(this.$modes[y]),v&&v()):(this.$modeId=y,a.loadModule(["mode",y],(function(_){if(this.$modeId!==y)return v&&v();this.$modes[y]&&!N?this.$onChangeMode(this.$modes[y]):_&&_.Mode&&(_=new _.Mode(N),N||((this.$modes[y]=_).$id=y),this.$onChangeMode(_)),v&&v()}).bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0))},c.prototype.$onChangeMode=function(u,v){var N,y,_;v||(this.$modeId=u.$id),this.$mode===u||(N=this.$mode,this.$mode=u,this.$stopWorker(),this.$useWorker&&this.$startWorker(),(y=u.getTokenizer()).on!==void 0&&(_=this.onReloadTokenizer.bind(this),y.on("update",_)),this.bgTokenizer.setTokenizer(y),this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=u.tokenRe,this.nonTokenRe=u.nonTokenRe,v)||(u.attachToSession&&u.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(u.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode",{oldMode:N,mode:u}))},c.prototype.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},c.prototype.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(u){a.warn("Could not load worker",u),this.$worker=null}},c.prototype.getMode=function(){return this.$mode},c.prototype.setScrollTop=function(u){this.$scrollTop===u||isNaN(u)||(this.$scrollTop=u,this._signal("changeScrollTop",u))},c.prototype.getScrollTop=function(){return this.$scrollTop},c.prototype.setScrollLeft=function(u){this.$scrollLeft===u||isNaN(u)||(this.$scrollLeft=u,this._signal("changeScrollLeft",u))},c.prototype.getScrollLeft=function(){return this.$scrollLeft},c.prototype.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},c.prototype.getLineWidgetMaxWidth=function(){var u;return this.lineWidgetsWidth!=null?this.lineWidgetsWidth:(u=0,this.lineWidgets.forEach(function(v){v&&v.screenWidth>u&&(u=v.screenWidth)}),this.lineWidgetWidth=u)},c.prototype.$computeWidth=function(u){if(this.$modified||u){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var v=this.doc.getAllLines(),N=this.$rowLengthCache,y=0,_=0,W=this.$foldData[_],F=W?W.start.row:1/0,Y=v.length,Q=0;Q<Y;Q++){if(F<Q){if(Y<=(Q=W.end.row+1))break;F=(W=this.$foldData[_++])?W.start.row:1/0}N[Q]==null&&(N[Q]=this.$getStringScreenWidth(v[Q])[0]),N[Q]>y&&(y=N[Q])}this.screenWidth=y}},c.prototype.getLine=function(u){return this.doc.getLine(u)},c.prototype.getLines=function(u,v){return this.doc.getLines(u,v)},c.prototype.getLength=function(){return this.doc.getLength()},c.prototype.getTextRange=function(u){return this.doc.getTextRange(u||this.selection.getRange())},c.prototype.insert=function(u,v){return this.doc.insert(u,v)},c.prototype.remove=function(u){return this.doc.remove(u)},c.prototype.removeFullLines=function(u,v){return this.doc.removeFullLines(u,v)},c.prototype.undoChanges=function(u,v){if(u.length){this.$fromUndo=!0;for(var N=u.length-1;N!=-1;N--){var y=u[N];y.action=="insert"||y.action=="remove"?this.doc.revertDelta(y):y.folds&&this.addFolds(y.folds)}!v&&this.$undoSelect&&(u.selectionBefore?this.selection.fromJSON(u.selectionBefore):this.selection.setRange(this.$getUndoSelection(u,!0))),this.$fromUndo=!1}},c.prototype.redoChanges=function(u,v){if(u.length){this.$fromUndo=!0;for(var N=0;N<u.length;N++){var y=u[N];y.action!="insert"&&y.action!="remove"||this.doc.$safeApplyDelta(y)}!v&&this.$undoSelect&&(u.selectionAfter?this.selection.fromJSON(u.selectionAfter):this.selection.setRange(this.$getUndoSelection(u,!1))),this.$fromUndo=!1}},c.prototype.setUndoSelect=function(u){this.$undoSelect=u},c.prototype.$getUndoSelection=function(u,v){function N(Y){return v?Y.action!=="insert":Y.action==="insert"}for(var y,_,W=0;W<u.length;W++){var F=u[W];F.start&&(y?N(F)?(_=F.start,y.compare(_.row,_.column)==-1&&y.setStart(_),_=F.end,y.compare(_.row,_.column)==1&&y.setEnd(_)):(_=F.start,y.compare(_.row,_.column)==-1&&(y=e.fromPoints(F.start,F.start))):y=N(F)?e.fromPoints(F.start,F.end):e.fromPoints(F.start,F.start))}return y},c.prototype.replace=function(u,v){return this.doc.replace(u,v)},c.prototype.moveText=function(u,Q,N){var y,_,W,F=this.getTextRange(u),Y=this.getFoldsInRange(u),Q=e.fromPoints(Q,Q);return N||(this.remove(u),_=u.start.row-u.end.row,(W=_?-u.end.column:u.start.column-u.end.column)&&(Q.start.row==u.end.row&&Q.start.column>u.end.column&&(Q.start.column+=W),Q.end.row==u.end.row)&&Q.end.column>u.end.column&&(Q.end.column+=W),_&&Q.start.row>=u.end.row&&(Q.start.row+=_,Q.end.row+=_)),Q.end=this.insert(Q.start,F),Y.length&&(y=u.start,N=Q.start,_=N.row-y.row,W=N.column-y.column,this.addFolds(Y.map(function(z){return(z=z.clone()).start.row==y.row&&(z.start.column+=W),z.end.row==y.row&&(z.end.column+=W),z.start.row+=_,z.end.row+=_,z}))),Q},c.prototype.indentRows=function(u,v,N){N=N.replace(/\t/g,this.getTabString());for(var y=u;y<=v;y++)this.doc.insertInLine({row:y,column:0},N)},c.prototype.outdentRows=function(u){for(var v=u.collapseRows(),N=new e(0,0,0,0),y=this.getTabSize(),_=v.start.row;_<=v.end.row;++_){var W=this.getLine(_);N.start.row=_,N.end.row=_;for(var F=0;F<y&&W.charAt(F)==" ";++F);F<y&&W.charAt(F)=="	"?(N.start.column=F,N.end.column=F+1):(N.start.column=0,N.end.column=F),this.remove(N)}},c.prototype.$moveLines=function(u,v,W){if(u=this.getRowFoldStart(u),v=this.getRowFoldEnd(v),W<0){if((_=this.getRowFoldStart(u+W))<0)return 0;var y=_-u}else if(0<W){if((_=this.getRowFoldEnd(v+W))>this.doc.getLength()-1)return 0;y=_-v}else u=this.$clipRowToDocument(u),y=(v=this.$clipRowToDocument(v))-u+1;var _=new e(u,0,v,Number.MAX_VALUE),_=this.getFoldsInRange(_).map(function(F){return(F=F.clone()).start.row+=y,F.end.row+=y,F}),W=W==0?this.doc.getLines(u,v):this.doc.removeFullLines(u,v);return this.doc.insertFullLines(u+y,W),_.length&&this.addFolds(_),y},c.prototype.moveLinesUp=function(u,v){return this.$moveLines(u,v,-1)},c.prototype.moveLinesDown=function(u,v){return this.$moveLines(u,v,1)},c.prototype.duplicateLines=function(u,v){return this.$moveLines(u,v,0)},c.prototype.$clipRowToDocument=function(u){return Math.max(0,Math.min(u,this.doc.getLength()-1))},c.prototype.$clipColumnToRow=function(u,v){return v<0?0:Math.min(this.doc.getLine(u).length,v)},c.prototype.$clipPositionToDocument=function(u,v){var N;return v=Math.max(0,v),v=u<0?u=0:(N=this.doc.getLength())<=u?this.doc.getLine(u=N-1).length:Math.min(this.doc.getLine(u).length,v),{row:u,column:v}},c.prototype.$clipRangeToDocument=function(u){u.start.row<0?(u.start.row=0,u.start.column=0):u.start.column=this.$clipColumnToRow(u.start.row,u.start.column);var v=this.doc.getLength()-1;return u.end.row>v?(u.end.row=v,u.end.column=this.doc.getLine(v).length):u.end.column=this.$clipColumnToRow(u.end.row,u.end.column),u},c.prototype.setUseWrapMode=function(u){u!=this.$useWrapMode&&(this.$useWrapMode=u,this.$modified=!0,this.$resetRowCache(0),u&&(u=this.getLength(),this.$wrapData=Array(u),this.$updateWrapData(0,u-1)),this._signal("changeWrapMode"))},c.prototype.getUseWrapMode=function(){return this.$useWrapMode},c.prototype.setWrapLimitRange=function(u,v){this.$wrapLimitRange.min===u&&this.$wrapLimitRange.max===v||(this.$wrapLimitRange={min:u,max:v},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},c.prototype.adjustWrapLimit=function(u,y){var N=this.$wrapLimitRange,y=(N.max<0&&(N={min:y,max:y}),this.$constrainWrapLimit(u,N.min,N.max));return y!=this.$wrapLimit&&1<y&&(this.$wrapLimit=y,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},c.prototype.$constrainWrapLimit=function(u,v,N){return v&&(u=Math.max(v,u)),u=N?Math.min(N,u):u},c.prototype.getWrapLimit=function(){return this.$wrapLimit},c.prototype.setWrapLimit=function(u){this.setWrapLimitRange(u,u)},c.prototype.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},c.prototype.$updateInternalDataOnChange=function(u){var v=this.$useWrapMode,N=u.action,y=u.start,_=u.end,W=y.row,F=_.row,Y=F-W,Q=null;if(this.$updating=!0,Y!=0)if(N==="remove"){this[v?"$wrapData":"$rowLengthCache"].splice(W,Y);var z=this.$foldData,Q=this.getFoldsInRange(u);this.removeFolds(Q);var te=0;for((V=this.getFoldLine(_.row))&&(V.addRemoveChars(_.row,_.column,y.column-_.column),V.shiftRow(-Y),(E=this.getFoldLine(W))&&E!==V&&(E.merge(V),V=E),te=z.indexOf(V)+1);te<z.length;te++)(V=z[te]).start.row>=_.row&&V.shiftRow(-Y);F=W}else{var E=Array(Y),H=(E.unshift(W,0),v?this.$wrapData:this.$rowLengthCache),z=(H.splice.apply(H,E),this.$foldData),te=0;for((V=this.getFoldLine(W))&&((H=V.range.compareInside(y.row,y.column))==0?(V=V.split(y.row,y.column))&&(V.shiftRow(Y),V.addRemoveChars(F,0,_.column-y.column)):H==-1&&(V.addRemoveChars(W,0,_.column-y.column),V.shiftRow(Y)),te=z.indexOf(V)+1);te<z.length;te++)(V=z[te]).start.row>=W&&V.shiftRow(Y)}else{var V,Y=Math.abs(u.start.column-u.end.column);N==="remove"&&(Q=this.getFoldsInRange(u),this.removeFolds(Q),Y=-Y),(V=this.getFoldLine(W))&&V.addRemoveChars(W,y.column,Y)}return v&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,v?this.$updateWrapData(W,F):this.$updateRowLengthCache(W,F),Q},c.prototype.$updateRowLengthCache=function(u,v,N){this.$rowLengthCache[u]=null,this.$rowLengthCache[v]=null},c.prototype.$updateWrapData=function(u,v){var N,y,_=this.doc.getAllLines(),W=this.getTabSize(),F=this.$wrapData,Y=this.$wrapLimit,Q=u;for(v=Math.min(v,_.length-1);Q<=v;)(y=this.getFoldLine(Q,y))?(N=[],y.walk((function(z,te,E,H){var V;if(z!=null){(V=this.$getDisplayTokens(z,N.length))[0]=p;for(var b=1;b<V.length;b++)V[b]=w}else V=this.$getDisplayTokens(_[te].substring(H,E),N.length);N=N.concat(V)}).bind(this),y.end.row,_[y.end.row].length+1),F[y.start.row]=this.$computeWrapSplits(N,Y,W),Q=y.end.row+1):(N=this.$getDisplayTokens(_[Q]),F[Q]=this.$computeWrapSplits(N,Y,W),Q++)},c.prototype.$computeWrapSplits=function(u,v,N){if(u.length==0)return[];var y=[],_=u.length,W=0,F=0,Y=this.$wrapAsCode,Q=this.$indentedSoftWrap,z=v<=Math.max(2*N,8)||Q===!1?0:Math.floor(v/2);function te(b){for(var S=b-W,R=W;R<b;R++){var O=u[R];O!==12&&O!==2||--S}y.length||(E=function(){var J=0;if(z===0)return J;if(Q)for(var re=0;re<u.length;re++){var pe=u[re];if(pe==$)J+=1;else if(pe==P)J+=N;else if(pe!=B)break}return Y&&Q!==!1&&(J+=N),Math.min(J,z)}(),y.indent=E),F+=S,y.push(F),W=b}for(var E=0;v-E<_-W;){var H=W+v-E;if(u[H-1]>=$&&u[H]>=$)te(H);else if(u[H]==p||u[H]==w){for(;H!=W-1&&u[H]!=p;H--);if(!(W<H)){for(H=W+v;H<u.length&&u[H]==w;H++);if(H==u.length)break}te(H)}else{for(var V=Math.max(H-(v-(v>>2)),W-1);V<H&&u[H]<p;)H--;if(Y){for(;V<H&&u[H]<p;)H--;for(;V<H&&u[H]==x;)H--}else for(;V<H&&u[H]<$;)H--;V<H?te(++H):(u[H=W+v]==C&&H--,te(H-E))}}return y},c.prototype.$getDisplayTokens=function(u,v){var N,y=[];v=v||0;for(var _=0;_<u.length;_++){var W=u.charCodeAt(_);if(W==9){N=this.getScreenTabSize(y.length+v),y.push(P);for(var F=1;F<N;F++)y.push(B)}else W==32?y.push($):39<W&&W<48||57<W&&W<64?y.push(x):4352<=W&&Z(W)?y.push(d,C):y.push(d)}return y},c.prototype.$getStringScreenWidth=function(u,v,N){if(v==0)return[0,0];var y,_;for(v==null&&(v=1/0),N=N||0,_=0;_<u.length&&((y=u.charCodeAt(_))==9?N+=this.getScreenTabSize(N):4352<=y&&Z(y)?N+=2:N+=1,!(v<N));_++);return[N,_]},c.prototype.getRowLength=function(u){var v=1;return this.lineWidgets&&(v+=this.lineWidgets[u]&&this.lineWidgets[u].rowCount||0),this.$useWrapMode&&this.$wrapData[u]?this.$wrapData[u].length+v:v},c.prototype.getRowLineCount=function(u){return this.$useWrapMode&&this.$wrapData[u]?this.$wrapData[u].length+1:1},c.prototype.getRowWrapIndent=function(u){var v;return this.$useWrapMode&&(u=this.screenToDocumentPosition(u,Number.MAX_VALUE),(v=this.$wrapData[u.row]).length)&&v[0]<u.column?v.indent:0},c.prototype.getScreenLastRowColumn=function(u){return u=this.screenToDocumentPosition(u,Number.MAX_VALUE),this.documentToScreenColumn(u.row,u.column)},c.prototype.getDocumentLastRowColumn=function(u,v){return u=this.documentToScreenRow(u,v),this.getScreenLastRowColumn(u)},c.prototype.getDocumentLastRowColumnPosition=function(u,v){return u=this.documentToScreenRow(u,v),this.screenToDocumentPosition(u,Number.MAX_VALUE/10)},c.prototype.getRowSplitData=function(u){if(this.$useWrapMode)return this.$wrapData[u]},c.prototype.getScreenTabSize=function(u){return this.$tabSize-(u%this.$tabSize|0)},c.prototype.screenToDocumentRow=function(u,v){return this.screenToDocumentPosition(u,v).row},c.prototype.screenToDocumentColumn=function(u,v){return this.screenToDocumentPosition(u,v).column},c.prototype.screenToDocumentPosition=function(u,v,N){if(u<0)return{row:0,column:0};for(var y,_,W,F=0,Y=0,Q=0,z=0,te=this.$screenRowCache,E=this.$getRowCacheIndex(te,u),H=te.length,V=(W=H&&0<=E?(Q=te[E],F=this.$docRowCache[E],u>te[H-1]):!H,this.getLength()-1),b=this.getNextFoldLine(F),S=b?b.start.row:1/0;Q<=u&&!(u<Q+(z=this.getRowLength(F))||V<=F);)Q+=z,S<++F&&(F=b.end.row+1,S=(b=this.getNextFoldLine(F,b))?b.start.row:1/0),W&&(this.$docRowCache.push(F),this.$screenRowCache.push(Q));if(b&&b.start.row<=F)y=this.getFoldDisplayLine(b),F=b.start.row;else{if(Q+z<=u||V<F)return{row:V,column:this.getLine(V).length};y=this.getLine(F),b=null}return E=0,te=Math.floor(u-Q),this.$useWrapMode&&(H=this.$wrapData[F])&&(_=H[te],0<te)&&H.length&&(E=H.indent,Y=H[te-1]||H[H.length-1],y=y.substring(Y)),N!==void 0&&this.$bidiHandler.isBidiRow(Q+te,F,te)&&(v=this.$bidiHandler.offsetToCol(N)),Y+=this.$getStringScreenWidth(y,v-E)[1],this.$useWrapMode&&_<=Y&&(Y=_-1),b?b.idxToPosition(Y):{row:F,column:Y}},c.prototype.documentToScreenPosition=function(u,v){var E=v===void 0?this.$clipPositionToDocument(u.row,u.column):this.$clipPositionToDocument(u,v),N=(u=E.row,v=E.column,0),E=null;(F=this.getFoldAt(u,v,1))&&(u=F.start.row,v=F.start.column);for(var y,_,W=0,F=this.$docRowCache,H=this.$getRowCacheIndex(F,u),Y=F.length,Q=(_=Y&&0<=H?(W=F[H],N=this.$screenRowCache[H],u>F[Y-1]):!Y,this.getNextFoldLine(W)),z=Q?Q.start.row:1/0;W<u;){if(z<=W){if(u<(y=Q.end.row+1))break;z=(Q=this.getNextFoldLine(y,Q))?Q.start.row:1/0}else y=W+1;N+=this.getRowLength(W),W=y,_&&(this.$docRowCache.push(W),this.$screenRowCache.push(N))}var te="",E=Q&&z<=W?(te=this.getFoldDisplayLine(Q,u,v),Q.start.row):(te=this.getLine(u).substring(0,v),u),H=0;if(this.$useWrapMode){var V=this.$wrapData[E];if(V){for(var b=0;te.length>=V[b];)N++,b++;te=te.substring(V[b-1]||0,te.length),H=0<b?V.indent:0}}return this.lineWidgets&&this.lineWidgets[W]&&this.lineWidgets[W].rowsAbove&&(N+=this.lineWidgets[W].rowsAbove),{row:N,column:H+this.$getStringScreenWidth(te)[0]}},c.prototype.documentToScreenColumn=function(u,v){return this.documentToScreenPosition(u,v).column},c.prototype.documentToScreenRow=function(u,v){return this.documentToScreenPosition(u,v).row},c.prototype.getScreenLength=function(){var u=0,v=null;if(this.$useWrapMode)for(var N=this.$wrapData.length,y=0,_=0,W=(v=this.$foldData[_++])?v.start.row:1/0;y<N;){var F=this.$wrapData[y];u+=F?F.length+1:1,W<++y&&(y=v.end.row+1,W=(v=this.$foldData[_++])?v.start.row:1/0)}else for(var u=this.getLength(),Y=this.$foldData,_=0;_<Y.length;_++)u-=(v=Y[_]).end.row-v.start.row;return this.lineWidgets&&(u+=this.$getWidgetScreenLength()),u},c.prototype.$setFontMetrics=function(u){this.$enableVarChar&&(this.$getStringScreenWidth=function(v,N,y){if(N===0)return[0,0];var _,W;for(N=N||1/0,y=y||0,W=0;W<v.length&&!(N<(y+=(_=v.charAt(W))==="	"?this.getScreenTabSize(y):u.getCharacterWidth(_)));W++);return[y,W]})},c.prototype.destroy=function(){this.destroyed||(this.bgTokenizer.setDocument(null),this.bgTokenizer.cleanup(),this.destroyed=!0),this.$stopWorker(),this.removeAllListeners(),this.doc&&this.doc.off("change",this.$onChange),this.selection.detach()},c);function c(u,v){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++c.$uid,this.$foldData.toString=function(){return this.join(`
`)},this.bgTokenizer=new s(new r().getTokenizer(),this);var N=this;this.bgTokenizer.on("update",function(y){N._signal("tokenizerUpdate",y)}),this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),typeof u=="object"&&u.getLine||(u=new n(u)),this.setDocument(u),this.selection=new t(this),this.$bidiHandler=new h(this),a.resetOptions(this),this.setMode(v),a._signal("session",this),this.destroyed=!1}i.$uid=0,i.prototype.$modes=a.$modes,i.prototype.getValue=i.prototype.toString,i.prototype.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},i.prototype.$overwrite=!1,i.prototype.$mode=null,i.prototype.$modeId=null,i.prototype.$scrollTop=0,i.prototype.$scrollLeft=0,i.prototype.$wrapLimit=80,i.prototype.$useWrapMode=!1,i.prototype.$wrapLimitRange={min:null,max:null},i.prototype.lineWidgets=null,i.prototype.isFullWidth=Z,I.implement(i.prototype,l);var d=1,C=2,p=3,w=4,x=9,$=10,P=11,B=12;function Z(u){return!(u<4352)&&(4352<=u&&u<=4447||4515<=u&&u<=4519||4602<=u&&u<=4607||9001<=u&&u<=9002||11904<=u&&u<=11929||11931<=u&&u<=12019||12032<=u&&u<=12245||12272<=u&&u<=12283||12288<=u&&u<=12350||12353<=u&&u<=12438||12441<=u&&u<=12543||12549<=u&&u<=12589||12593<=u&&u<=12686||12688<=u&&u<=12730||12736<=u&&u<=12771||12784<=u&&u<=12830||12832<=u&&u<=12871||12880<=u&&u<=13054||13056<=u&&u<=19903||19968<=u&&u<=42124||42128<=u&&u<=42182||43360<=u&&u<=43388||44032<=u&&u<=55203||55216<=u&&u<=55238||55243<=u&&u<=55291||63744<=u&&u<=64255||65040<=u&&u<=65049||65072<=u&&u<=65106||65108<=u&&u<=65126||65128<=u&&u<=65131||65281<=u&&u<=65376||65504<=u&&u<=65510)}A("./edit_session/folding").Folding.call(i.prototype),A("./edit_session/bracket_match").BracketMatch.call(i.prototype),a.defineOptions(i.prototype,"session",{wrap:{set:function(u){u&&u!="off"?u=="free"?u=!0:u=="printMargin"?u=-1:typeof u=="string"&&(u=parseInt(u,10)||!1):u=!1,this.$wrap!=u&&((this.$wrap=u)?(this.setWrapLimitRange(u=typeof u=="number"?u:null,u),this.setUseWrapMode(!0)):this.setUseWrapMode(!1))},get:function(){return this.getUseWrapMode()?this.$wrap==-1?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(u){(u=u=="auto"?this.$mode.type!="text":u!="text")!=this.$wrapAsCode&&(this.$wrapAsCode=u,this.$useWrapMode)&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(u){this.$useWorker=u,this.$stopWorker(),u&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(u){0<(u=parseInt(u))&&this.$tabSize!==u&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=u,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(u){this.setFoldStyle(u)},handlesSet:!0},overwrite:{set:function(u){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(u){this.doc.setNewLineMode(u)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(u){this.setMode(u)},get:function(){return this.$modeId},handlesSet:!0}}),f.EditSession=i}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(A,f,T){var I=A("./lib/lang"),m=A("./lib/oop"),h=A("./range").Range;function a(){this.$options={}}a.prototype.set=function(l){return m.mixin(this.$options,l),this},a.prototype.getOptions=function(){return I.copyObject(this.$options)},a.prototype.setOptions=function(l){this.$options=l},a.prototype.find=function(e){var t,r=this.$options,e=this.$matchIterator(e,r);return!!e&&(t=null,e.forEach(function(n,s,o,i){return t=new h(n,s,o,i),!(s==i&&r.start&&r.start.start&&r.skipCurrent!=0&&t.isEqual(r.start)&&(t=null,1))}),t)},a.prototype.findAll=function(l){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var r=t.range,e=r?l.getLines(r.start.row,r.end.row):l.doc.getAllLines(),n=[],s=t.re;if(t.$isMultiLine){var o,i=s.length,c=e.length-i;e:for(var d=s.offset||0;d<=c;d++){for(var C=0;C<i;C++)if(e[d+C].search(s[C])==-1)continue e;var p=e[d],w=e[d+i-1],p=p.length-p.match(s[0])[0].length,w=w.match(s[i-1])[0].length;o&&o.end.row===d&&o.end.column>p||(n.push(o=new h(d,p,d+i-1,w)),2<i&&(d=d+i-2))}}else for(var x=0;x<e.length;x++)for(var $=I.getMatchOffsets(e[x],s),C=0;C<$.length;C++){var P=$[C];n.push(new h(x,P.offset,x,P.offset+P.length))}if(r){for(var B=r.start.column,Z=r.end.column,x=0,C=n.length-1;x<C&&n[x].start.column<B&&n[x].start.row==0;)x++;for(var u=r.end.row-r.start.row;x<C&&n[C].end.column>Z&&n[C].end.row==u;)C--;for(n=n.slice(x,C+1),x=0,C=n.length;x<C;x++)n[x].start.row+=r.start.row,n[x].end.row+=r.start.row}return n},a.prototype.replace=function(l,t){var r=this.$options,e=this.$assembleRegExp(r);if(r.$isMultiLine)return t;if(e){var n=e.exec(l);if(!n||n[0].length!=l.length)return null;if(t=l.replace(e,t),r.preserveCase){t=t.split("");for(var s=Math.min(l.length,l.length);s--;){var o=l[s];o&&o.toLowerCase()!=o?t[s]=t[s].toUpperCase():t[s]=t[s].toLowerCase()}t=t.join("")}return t}},a.prototype.$assembleRegExp=function(l,t){if(l.needle instanceof RegExp)return l.re=l.needle;var r,e=l.needle;if(!l.needle)return l.re=!1;function n(i){return/\w/.test(i)||r.regExp?"\\b":""}l.regExp||(e=I.escapeRegExp(e)),l.wholeWord&&(r=l,e=n((s=e)[0])+s+n(s[s.length-1]));var s=l.caseSensitive?"gm":"gmi";if(l.$isMultiLine=!t&&/[\n\r]/.test(e),l.$isMultiLine)return l.re=this.$assembleMultilineRegExp(e,s);try{var o=new RegExp(e,s)}catch{o=!1}return l.re=o},a.prototype.$assembleMultilineRegExp=function(l,t){for(var r=l.replace(/\r\n|\r|\n/g,`$
^`).split(`
`),e=[],n=0;n<r.length;n++)try{e.push(new RegExp(r[n],t))}catch{return!1}return e},a.prototype.$matchIterator=function(l,t){var r,e,n,s,o,i,c,d,C=this.$assembleRegExp(t);return!!C&&(r=t.backwards==1,e=t.skipCurrent!=0,n=t.range,(s=(s=t.start)||(n?n[r?"end":"start"]:l.selection.getRange())).start&&(s=s[e!=r?"end":"start"]),o=n?n.start.row:0,i=n?n.end.row:l.getLength()-1,d=t.$isMultiLine?(c=C.length,function(p,w,x){var $=r?p-c+1:p;if(!($<0||$+c>l.getLength())){var P=l.getLine($),p=P.search(C[0]);if(!(!r&&p<w||p===-1)){for(var B=1;B<c;B++)if((P=l.getLine($+B)).search(C[B])==-1)return;var Z=P.match(C[c-1])[0].length;if(!(r&&w<Z))return!!x($,p,$+c-1,Z)||void 0}}}):r?function(p,w,x){var $,P=l.getLine(p),B=[];for(C.lastIndex=0;$=C.exec(P);){var Z=$[0].length,u=$.index;if(!Z){if(u>=P.length)break;C.lastIndex=u+=1}if($.index+Z>w)break;B.push($.index,Z)}for(var v=B.length-1;0<=v;v-=2){var N=B[v-1];if(x(p,N,p,N+(Z=B[v])))return!0}}:function(p,w,x){var $=l.getLine(p);for(C.lastIndex=w;P=C.exec($);){var P,B=P[0].length;if(x(p,P=P.index,p,P+B))return!0;if(!B&&(C.lastIndex=P+=1,P>=$.length))return!1}},{forEach:r?function(p){var w=s.row;if(!d(w,s.column,p)){for(w--;o<=w;w--)if(d(w,Number.MAX_VALUE,p))return;if(t.wrap!=0){for(w=i,o=s.row;o<=w;w--)if(d(w,Number.MAX_VALUE,p))return}}}:function(p){var w=s.row;if(!d(w,s.column,p)){for(w+=1;w<=i;w++)if(d(w,0,p))return;if(t.wrap!=0){for(w=o,i=s.row;w<=i;w++)if(d(w,0,p))return}}}})},f.Search=a}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(A,f,T){var I=A("../lib/keys"),m=A("../lib/useragent"),h=I.KEY_MODS;function a(t,r){this.platform=r||(m.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(t),this.$singleCommand=!0}function l(t,r){a.call(this,t,r),this.$singleCommand=!1}l.prototype=a.prototype,(function(){function t(r){return typeof r=="object"&&r.bindKey&&r.bindKey.position||(r.isDefault?-100:0)}this.addCommand=function(r){this.commands[r.name]&&this.removeCommand(r),(this.commands[r.name]=r).bindKey&&this._buildKeyHash(r)},this.removeCommand=function(r,e){var n,s=r&&(typeof r=="string"?r:r.name),o=(r=this.commands[s],e||delete this.commands[s],this.commandKeyBinding);for(n in o){var i,c=o[n];c==r?delete o[n]:Array.isArray(c)&&(i=c.indexOf(r))!=-1&&(c.splice(i,1),c.length==1)&&(o[n]=c[0])}},this.bindKey=function(r,e,n){if(typeof r=="object"&&r&&(n==null&&(n=r.position),r=r[this.platform]),r)return typeof e=="function"?this.addCommand({exec:e,bindKey:r,name:e.name||r}):void r.split("|").forEach(function(c){var o="",i=(c.indexOf(" ")!=-1&&(c=(i=c.split(/\s+/)).pop(),i.forEach(function(d){d=this.parseKeys(d),d=h[d.hashId]+d.key,o+=(o?" ":"")+d,this._addCommandToBinding(o,"chainKeys")},this),o+=" "),this.parseKeys(c)),c=h[i.hashId]+i.key;this._addCommandToBinding(o+c,e,n)},this)},this._addCommandToBinding=function(r,e,n){var s=this.commandKeyBinding;if(e)if(!s[r]||this.$singleCommand)s[r]=e;else{Array.isArray(s[r])?(i=s[r].indexOf(e))!=-1&&s[r].splice(i,1):s[r]=[s[r]],typeof n!="number"&&(n=t(e));for(var o=s[r],i=0;i<o.length&&!(n<t(o[i]));i++);o.splice(i,0,e)}else delete s[r]},this.addCommands=function(r){r&&Object.keys(r).forEach(function(e){var n=r[e];if(n){if(typeof n=="string")return this.bindKey(n,e);typeof(n=typeof n=="function"?{exec:n}:n)=="object"&&(n.name||(n.name=e),this.addCommand(n))}},this)},this.removeCommands=function(r){Object.keys(r).forEach(function(e){this.removeCommand(r[e])},this)},this.bindKeys=function(r){Object.keys(r).forEach(function(e){this.bindKey(e,r[e])},this)},this._buildKeyHash=function(r){this.bindKey(r.bindKey,r)},this.parseKeys=function(r){var e=r.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(d){return d}),n=e.pop(),s=I[n];if(I.FUNCTION_KEYS[s])n=I.FUNCTION_KEYS[s].toLowerCase();else{if(!e.length)return{key:n,hashId:-1};if(e.length==1&&e[0]=="shift")return{key:n.toUpperCase(),hashId:-1}}for(var o=0,i=e.length;i--;){var c=I.KEY_MODS[e[i]];if(c==null)return typeof console<"u"&&console.error("invalid modifier "+e[i]+" in "+r),!1;o|=c}return{key:n,hashId:o}},this.findKeyCommand=function(r,e){return r=h[r]+e,this.commandKeyBinding[r]},this.handleKeyboard=function(r,e,n,s){var o,i;if(!(s<0))return o=h[e]+n,i=this.commandKeyBinding[o],r.$keyChain&&(r.$keyChain+=" "+o,i=this.commandKeyBinding[r.$keyChain]||i),!i||i!="chainKeys"&&i[i.length-1]!="chainKeys"?(r.$keyChain&&(e&&e!=4||n.length!=1?(e==-1||0<s)&&(r.$keyChain=""):r.$keyChain=r.$keyChain.slice(0,-o.length-1)),{command:i}):(r.$keyChain=r.$keyChain||o,{command:"null"})},this.getStatusText=function(r,e){return e.$keyChain||""}}).call(a.prototype),f.HashHandler=a,f.MultiHashHandler=l}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(l,f,T){var I,m,t=this&&this.__extends||(I=function(e,n){return(I=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(s,o){s.__proto__=o}:function(s,o){for(var i in o)Object.prototype.hasOwnProperty.call(o,i)&&(s[i]=o[i])}))(e,n)},function(e,n){if(typeof n!="function"&&n!==null)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function s(){this.constructor=e}I(e,n),e.prototype=n===null?Object.create(n):(s.prototype=n.prototype,new s)}),h=l("../lib/oop"),a=l("../keyboard/hash_handler").MultiHashHandler,l=l("../lib/event_emitter").EventEmitter,t=(t(r,m=a),r.prototype.exec=function(e,n,s){if(Array.isArray(e)){for(var o=e.length;o--;)if(this.exec(e[o],n,s))return!0;return!1}var i;return!!(e=typeof e=="string"?this.commands[e]:e)&&!(n&&n.$readOnly&&!e.readOnly||this.$checkCommandState!=0&&e.isAvailable&&!e.isAvailable(n)||((i={editor:n,command:e,args:s}).returnValue=this._emit("exec",i),this._signal("afterExec",i),i.returnValue===!1))},r.prototype.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.off("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=(function(n){this.macro.push([n.command,n.args])}).bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},r.prototype.replay=function(e){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(e);try{this.$inReplay=!0,this.macro.forEach(function(n){typeof n=="string"?this.exec(n,e):this.exec(n[0],e,n[1])},this)}finally{this.$inReplay=!1}}},r.prototype.trimMacro=function(e){return e.map(function(n){return typeof n[0]!="string"&&(n[0]=n[0].name),n=n[1]?n:n[0]})},r);function r(e,n){return n=m.call(this,n,e)||this,n.byName=n.commands,n.setDefaultHandler("exec",function(s){return s.args?s.command.exec(s.editor,s.args,s.event,!1):s.command.exec(s.editor,{},s.event,!0)}),n}h.implement(t.prototype,l),f.CommandManager=t}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(A,f,T){var I=A("../lib/lang"),m=A("../config"),h=A("../range").Range;function a(t,r){return{win:t,mac:r}}f.commands=[{name:"showSettingsMenu",description:"Show settings menu",bindKey:a("Ctrl-,","Command-,"),exec:function(t){m.loadModule("ace/ext/settings_menu",function(r){r.init(t),t.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",description:"Go to next error",bindKey:a("Alt-E","F4"),exec:function(t){m.loadModule("ace/ext/error_marker",function(r){r.showErrorMarker(t,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",description:"Go to previous error",bindKey:a("Alt-Shift-E","Shift-F4"),exec:function(t){m.loadModule("ace/ext/error_marker",function(r){r.showErrorMarker(t,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:a("Ctrl-A","Command-A"),exec:function(t){t.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:a(null,"Ctrl-L"),exec:function(t){t.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:a("Ctrl-L","Command-L"),exec:function(t,r){typeof r!="number"||isNaN(r)||t.gotoLine(r),t.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:a("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(t){t.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:a("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(t){t.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",description:"Toggle fold widget",bindKey:a("F2","F2"),exec:function(t){t.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",description:"Toggle parent fold widget",bindKey:a("Alt-F2","Alt-F2"),exec:function(t){t.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:a(null,"Ctrl-Command-Option-0"),exec:function(t){t.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldAllComments",description:"Fold all comments",bindKey:a(null,"Ctrl-Command-Option-0"),exec:function(t){t.session.foldAllComments()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:a("Alt-0","Command-Option-0"),exec:function(t){t.session.foldAll(),t.session.unfold(t.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:a("Alt-Shift-0","Command-Option-Shift-0"),exec:function(t){t.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:a("Ctrl-K","Command-G"),exec:function(t){t.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:a("Ctrl-Shift-K","Command-Shift-G"),exec:function(t){t.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:a("Alt-K","Ctrl-G"),exec:function(t){t.selection.isEmpty()?t.selection.selectWord():t.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:a("Alt-Shift-K","Ctrl-Shift-G"),exec:function(t){t.selection.isEmpty()?t.selection.selectWord():t.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:a("Ctrl-F","Command-F"),exec:function(t){m.loadModule("ace/ext/searchbox",function(r){r.Search(t)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(t){t.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:a("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(t){t.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:a("Ctrl-Home","Command-Home|Command-Up"),exec:function(t){t.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:a("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(t){t.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:a("Up","Up|Ctrl-P"),exec:function(t,r){t.navigateUp(r.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:a("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(t){t.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:a("Ctrl-End","Command-End|Command-Down"),exec:function(t){t.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:a("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(t){t.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:a("Down","Down|Ctrl-N"),exec:function(t,r){t.navigateDown(r.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:a("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(t){t.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:a("Ctrl-Left","Option-Left"),exec:function(t){t.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:a("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(t){t.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:a("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(t){t.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:a("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(t){t.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:a("Left","Left|Ctrl-B"),exec:function(t,r){t.navigateLeft(r.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:a("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(t){t.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:a("Ctrl-Right","Option-Right"),exec:function(t){t.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:a("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(t){t.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:a("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(t){t.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:a("Shift-Right","Shift-Right"),exec:function(t){t.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:a("Right","Right|Ctrl-F"),exec:function(t,r){t.navigateRight(r.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(t){t.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:a(null,"Option-PageDown"),exec:function(t){t.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:a("PageDown","PageDown|Ctrl-V"),exec:function(t){t.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(t){t.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:a(null,"Option-PageUp"),exec:function(t){t.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(t){t.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:a("Ctrl-Up",null),exec:function(t){t.renderer.scrollBy(0,-2*t.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:a("Ctrl-Down",null),exec:function(t){t.renderer.scrollBy(0,2*t.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(t){t.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(t){t.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:a("Ctrl-Alt-E","Command-Option-E"),exec:function(t){t.commands.toggleRecording(t)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:a("Ctrl-Shift-E","Command-Shift-E"),exec:function(t){t.commands.replay(t)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:a("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(t){t.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:a("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(t){t.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:a("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(t){t.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:a(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(t){},readOnly:!0},{name:"cut",description:"Cut",exec:function(t){var r=t.$copyWithEmptySelection&&t.selection.isEmpty()?t.selection.getLineRange():t.selection.getRange();t._emit("cut",r),r.isEmpty()||t.session.remove(r),t.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(t,r){t.$handlePaste(r)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:a("Ctrl-D","Command-D"),exec:function(t){t.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:a("Ctrl-Shift-D","Command-Shift-D"),exec:function(t){t.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:a("Ctrl-Alt-S","Command-Alt-S"),exec:function(t){t.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:a("Ctrl-/","Command-/"),exec:function(t){t.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:a("Ctrl-Shift-/","Command-Shift-/"),exec:function(t){t.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:a("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(t){t.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:a("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(t){t.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:a("Ctrl-H","Command-Option-F"),exec:function(t){m.loadModule("ace/ext/searchbox",function(r){r.Search(t,!0)})}},{name:"undo",description:"Undo",bindKey:a("Ctrl-Z","Command-Z"),exec:function(t){t.undo()}},{name:"redo",description:"Redo",bindKey:a("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(t){t.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:a("Alt-Shift-Up","Command-Option-Up"),exec:function(t){t.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:a("Alt-Up","Option-Up"),exec:function(t){t.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:a("Alt-Shift-Down","Command-Option-Down"),exec:function(t){t.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:a("Alt-Down","Option-Down"),exec:function(t){t.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:a("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(t){t.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:a("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(t){t.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:a("Shift-Delete",null),exec:function(t){if(!t.selection.isEmpty())return!1;t.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:a("Alt-Backspace","Command-Backspace"),exec:function(t){t.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:a("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(t){t.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:a("Ctrl-Shift-Backspace",null),exec:function(t){var r=t.selection.getRange();r.start.column=0,t.session.remove(r)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:a("Ctrl-Shift-Delete",null),exec:function(t){var r=t.selection.getRange();r.end.column=Number.MAX_VALUE,t.session.remove(r)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:a("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(t){t.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:a("Ctrl-Delete","Alt-Delete"),exec:function(t){t.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:a("Shift-Tab","Shift-Tab"),exec:function(t){t.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:a("Tab","Tab"),exec:function(t){t.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:a("Ctrl-[","Ctrl-["),exec:function(t){t.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:a("Ctrl-]","Ctrl-]"),exec:function(t){t.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(t,r){t.insert(r)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(t,r){t.insert(I.stringRepeat(r.text||"",r.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:a(null,"Ctrl-O"),exec:function(t){t.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:a("Alt-Shift-X","Ctrl-T"),exec:function(t){t.transposeLetters()},multiSelectAction:function(t){t.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:a("Ctrl-U","Ctrl-U"),exec:function(t){t.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:a("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(t){t.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:a(null,null),exec:function(t){t.autoIndent()},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:a("Ctrl-Shift-L","Command-Shift-L"),exec:function(t){var r=t.selection.getRange();r.start.column=r.end.column=0,r.end.row++,t.selection.setRange(r,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"openlink",bindKey:a("Ctrl+F3","F3"),exec:function(t){t.openLink()}},{name:"joinlines",description:"Join lines",bindKey:a(null,null),exec:function(t){for(var n=t.selection.isBackwards(),r=n?t.selection.getSelectionLead():t.selection.getSelectionAnchor(),e=n?t.selection.getSelectionAnchor():t.selection.getSelectionLead(),n=t.session.doc.getLine(r.row).length,s=t.session.doc.getTextRange(t.selection.getRange()).replace(/\n\s*/," ").length,o=t.session.doc.getLine(r.row),i=r.row+1;i<=e.row+1;i++){var c=I.stringTrimLeft(I.stringTrimRight(t.session.doc.getLine(i)));o+=c=c.length!==0?" "+c:c}e.row+1<t.session.doc.getLength()-1&&(o+=t.session.doc.getNewLineCharacter()),t.clearSelection(),t.session.doc.replace(new h(r.row,0,e.row+2,0),o),0<s?(t.selection.moveCursorTo(r.row,r.column),t.selection.selectTo(r.row,r.column+s)):(n=t.session.doc.getLine(r.row).length>n?n+1:n,t.selection.moveCursorTo(r.row,n))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:a(null,null),exec:function(t){var r=t.session.doc.getLength()-1,e=t.session.doc.getLine(r).length,n=t.selection.rangeList.ranges,s=[];n.length<1&&(n=[t.selection.getRange()]);for(var o=0;o<n.length;o++)o!=n.length-1||n[o].end.row===r&&n[o].end.column===e||s.push(new h(n[o].end.row,n[o].end.column,r,e)),o===0?n[o].start.row===0&&n[o].start.column===0||s.push(new h(0,0,n[o].start.row,n[o].start.column)):s.push(new h(n[o-1].end.row,n[o-1].end.column,n[o].start.row,n[o].start.column));for(t.exitMultiSelectMode(),t.clearSelection(),o=0;o<s.length;o++)t.selection.addRange(s[o],!1)},readOnly:!0,scrollIntoView:"none"},{name:"addLineAfter",description:"Add new line after the current line",exec:function(t){t.selection.clearSelection(),t.navigateLineEnd(),t.insert(`
`)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",description:"Add new line before the current line",exec:function(t){t.selection.clearSelection();var r=t.getCursorPosition();t.selection.moveTo(r.row-1,Number.MAX_VALUE),t.insert(`
`),r.row===0&&t.navigateUp()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"openCommandPallete",description:"Open command palette",bindKey:a("F1","F1"),exec:function(t){t.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:a(null,null),exec:function(t){t.prompt({$type:"modes"})},readOnly:!0}];for(var l=1;l<9;l++)f.commands.push({name:"foldToLevel"+l,description:"Fold To Level "+l,level:l,exec:function(t){t.session.foldToLevel(this.level)},scrollIntoView:"center",readOnly:!0})}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/dom"],function(A,f,T){var I=A("./lib/dom");function m(h){this.session=h,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}m.prototype.getRowLength=function(h){var a=this.lineWidgets&&this.lineWidgets[h]&&this.lineWidgets[h].rowCount||0;return this.$useWrapMode&&this.$wrapData[h]?this.$wrapData[h].length+1+a:1+a},m.prototype.$getWidgetScreenLength=function(){var h=0;return this.lineWidgets.forEach(function(a){a&&a.rowCount&&!a.hidden&&(h+=a.rowCount)}),h},m.prototype.$onChangeEditor=function(h){this.attach(h.editor)},m.prototype.attach=function(h){h&&h.widgetManager&&h.widgetManager!=this&&h.widgetManager.detach(),this.editor!=h&&(this.detach(),this.editor=h)&&(h.widgetManager=this,h.renderer.on("beforeRender",this.measureWidgets),h.renderer.on("afterRender",this.renderWidgets))},m.prototype.detach=function(h){var a=this.editor;a&&(this.editor=null,a.widgetManager=null,a.renderer.off("beforeRender",this.measureWidgets),a.renderer.off("afterRender",this.renderWidgets),a=this.session.lineWidgets)&&a.forEach(function(l){l&&l.el&&l.el.parentNode&&(l._inDocument=!1,l.el.parentNode.removeChild(l.el))})},m.prototype.updateOnFold=function(h,a){var l=a.lineWidgets;if(l&&h.action){for(var a=h.data,t=a.start.row,r=a.end.row,e=h.action=="add",n=t+1;n<r;n++)l[n]&&(l[n].hidden=e);l[r]&&(e?l[t]?l[r].hidden=e:l[t]=l[r]:(l[t]==l[r]&&(l[t]=void 0),l[r].hidden=e))}},m.prototype.updateOnChange=function(h){var a,l,t,r=this.session.lineWidgets;r&&(a=h.start.row,(l=h.end.row-a)!=0)&&(h.action=="remove"?(t=r.splice(a+1,l),!r[a]&&t[t.length-1]&&(r[a]=t.pop()),t.forEach(function(e){e&&this.removeLineWidget(e)},this)):(t=new Array(l),r[a]&&r[a].column!=null&&h.start.column>r[a].column&&a++,t.unshift(a,0),r.splice.apply(r,t)),this.$updateRows())},m.prototype.$updateRows=function(){var h,a=this.session.lineWidgets;a&&(h=!0,a.forEach(function(l,t){if(l)for(h=!1,l.row=t;l.$oldWidget;)l.$oldWidget.row=t,l=l.$oldWidget}),h)&&(this.session.lineWidgets=null)},m.prototype.$registerLineWidget=function(h){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var a=this.session.lineWidgets[h.row];return a&&(h.$oldWidget=a).el&&a.el.parentNode&&(a.el.parentNode.removeChild(a.el),a._inDocument=!1),this.session.lineWidgets[h.row]=h},m.prototype.addLineWidget=function(h){var a,l,t;return this.$registerLineWidget(h),h.session=this.session,this.editor&&(a=this.editor.renderer,h.html&&!h.el&&(h.el=I.createElement("div"),h.el.innerHTML=h.html),h.text&&!h.el&&(h.el=I.createElement("div"),h.el.textContent=h.text),h.el&&(I.addCssClass(h.el,"ace_lineWidgetContainer"),h.className&&I.addCssClass(h.el,h.className),h.el.style.position="absolute",h.el.style.zIndex=5,a.container.appendChild(h.el),h._inDocument=!0,h.coverGutter||(h.el.style.zIndex=3),h.pixelHeight==null)&&(h.pixelHeight=h.el.offsetHeight),h.rowCount==null&&(h.rowCount=h.pixelHeight/a.layerConfig.lineHeight),l=this.session.getFoldAt(h.row,0),(h.$fold=l)&&(t=this.session.lineWidgets,h.row!=l.end.row||t[l.start.row]?h.hidden=!0:t[l.start.row]=h),this.session._emit("changeFold",{data:{start:{row:h.row}}}),this.$updateRows(),this.renderWidgets(null,a),this.onWidgetChanged(h)),h},m.prototype.removeLineWidget=function(h){if(h._inDocument=!1,h.session=null,h.el&&h.el.parentNode&&h.el.parentNode.removeChild(h.el),h.editor&&h.editor.destroy)try{h.editor.destroy()}catch{}if(this.session.lineWidgets){var a=this.session.lineWidgets[h.row];if(a==h)this.session.lineWidgets[h.row]=h.$oldWidget,h.$oldWidget&&this.onWidgetChanged(h.$oldWidget);else for(;a;){if(a.$oldWidget==h){a.$oldWidget=h.$oldWidget;break}a=a.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:h.row}}}),this.$updateRows()},m.prototype.getWidgetsAtRow=function(h){for(var a=this.session.lineWidgets,l=a&&a[h],t=[];l;)t.push(l),l=l.$oldWidget;return t},m.prototype.onWidgetChanged=function(h){this.session._changedWidgets.push(h),this.editor&&this.editor.renderer.updateFull()},m.prototype.measureWidgets=function(h,a){var l=this.session._changedWidgets,t=a.layerConfig;if(l&&l.length){for(var r=1/0,e=0;e<l.length;e++){var n=l[e];if(n&&n.el&&n.session==this.session){if(!n._inDocument){if(this.session.lineWidgets[n.row]!=n)continue;n._inDocument=!0,a.container.appendChild(n.el)}n.h=n.el.offsetHeight,n.fixedWidth||(n.w=n.el.offsetWidth,n.screenWidth=Math.ceil(n.w/t.characterWidth));var s=n.h/t.lineHeight;n.coverLine&&(s-=this.session.getRowLineCount(n.row))<0&&(s=0),n.rowCount!=s&&(n.rowCount=s,n.row<r)&&(r=n.row)}}r!=1/0&&(this.session._emit("changeFold",{data:{start:{row:r}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},m.prototype.renderWidgets=function(h,a){var l=a.layerConfig,t=this.session.lineWidgets;if(t){for(var r=Math.min(this.firstRow,l.firstRow),e=Math.max(this.lastRow,l.lastRow,t.length);0<r&&!t[r];)r--;this.firstRow=l.firstRow,this.lastRow=l.lastRow,a.$cursorLayer.config=l;for(var n=r;n<=e;n++){var s,o=t[n];o&&o.el&&(o.hidden?o.el.style.top=-100-(o.pixelHeight||0)+"px":(o._inDocument||(o._inDocument=!0,a.container.appendChild(o.el)),s=a.$cursorLayer.getPixelPosition({row:n,column:0},!0).top,o.coverLine||(s+=l.lineHeight*this.session.getRowLineCount(o.row)),o.el.style.top=s-l.offset+"px",s=o.coverGutter?0:a.gutterWidth,o.fixedWidth||(s-=a.scrollLeft),o.el.style.left=s+"px",o.fullWidth&&o.screenWidth&&(o.el.style.minWidth=l.width+2*l.padding+"px"),o.fixedWidth?o.el.style.right=a.scrollBar.getWidth()+"px":o.el.style.right=""))}}},f.LineWidgets=m}),ace.define("ace/keyboard/gutter_handler",["require","exports","module","ace/lib/keys","ace/mouse/default_gutter_handler"],function(A,f,T){var I=A("../lib/keys"),m=A("../mouse/default_gutter_handler").GutterTooltip;function h(a){this.editor=a,this.gutterLayer=a.renderer.$gutterLayer,this.element=a.renderer.$gutter,this.lines=a.renderer.$gutterLayer.$lines,this.activeRowIndex=null,this.activeLane=null,this.annotationTooltip=new m(this.editor)}h.prototype.addListener=function(){this.element.addEventListener("keydown",this.$onGutterKeyDown.bind(this)),this.element.addEventListener("focusout",this.$blurGutter.bind(this)),this.editor.on("mousewheel",this.$blurGutter.bind(this))},h.prototype.removeListener=function(){this.element.removeEventListener("keydown",this.$onGutterKeyDown.bind(this)),this.element.removeEventListener("focusout",this.$blurGutter.bind(this)),this.editor.off("mousewheel",this.$blurGutter.bind(this))},h.prototype.$onGutterKeyDown=function(a){var l;if(this.annotationTooltip.isOpen)a.preventDefault(),a.keyCode===I.escape&&this.annotationTooltip.hide();else if(a.target===this.element)a.keyCode==I.enter&&(a.preventDefault(),l=this.editor.getCursorPosition().row,this.editor.isRowVisible(l)||this.editor.scrollToLine(l,!0,!0),setTimeout((function(){var n=this.$rowToRowIndex(this.gutterLayer.$cursorCell.row),s=this.$findNearestFoldWidget(n),o=this.$findNearestAnnotation(n);s===null&&o===null||(s===null&&o!==null||(s===null||o!==null)&&Math.abs(o-n)<Math.abs(s-n)?(this.activeRowIndex=o,this.activeLane="annotation",this.$focusAnnotation(this.activeRowIndex)):(this.activeRowIndex=s,this.activeLane="fold",this.$focusFoldWidget(this.activeRowIndex)))}).bind(this),10));else if(a.keyCode===I.tab)a.preventDefault();else if(a.keyCode===I.escape)a.preventDefault(),this.$blurGutter(),this.element.focus(),this.lane=null;else if(a.keyCode===I.up)switch(a.preventDefault(),this.activeLane){case"fold":this.$moveFoldWidgetUp();break;case"annotation":this.$moveAnnotationUp()}else if(a.keyCode===I.down)switch(a.preventDefault(),this.activeLane){case"fold":this.$moveFoldWidgetDown();break;case"annotation":this.$moveAnnotationDown()}else if(a.keyCode===I.left&&(a.preventDefault(),this.$switchLane("annotation")),a.keyCode===I.right&&(a.preventDefault(),this.$switchLane("fold")),a.keyCode===I.enter||a.keyCode===I.space)switch(a.preventDefault(),this.activeLane){case"fold":if(this.gutterLayer.session.foldWidgets[this.$rowIndexToRow(this.activeRowIndex)]==="start"){var t=this.$rowIndexToRow(this.activeRowIndex);this.editor.session.onFoldWidgetClick(this.$rowIndexToRow(this.activeRowIndex),a),setTimeout((function(){this.$rowIndexToRow(this.activeRowIndex)!==t&&(this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=this.$rowToRowIndex(t),this.$focusFoldWidget(this.activeRowIndex))}).bind(this),10);break}if(this.gutterLayer.session.foldWidgets[this.$rowIndexToRow(this.activeRowIndex)]==="end")break;return;case"annotation":var r=this.lines.cells[this.activeRowIndex].element.childNodes[2].getBoundingClientRect(),e=this.annotationTooltip.getElement().style;e.left=r.right+"px",e.top=r.bottom+"px",this.annotationTooltip.showTooltip(this.$rowIndexToRow(this.activeRowIndex))}},h.prototype.$blurGutter=function(){if(this.activeRowIndex!==null)switch(this.activeLane){case"fold":this.$blurFoldWidget(this.activeRowIndex);break;case"annotation":this.$blurAnnotation(this.activeRowIndex)}this.annotationTooltip.isOpen&&this.annotationTooltip.hide()},h.prototype.$isFoldWidgetVisible=function(t){var l=this.editor.isRowFullyVisible(this.$rowIndexToRow(t)),t=this.$getFoldWidget(t).style.display!=="none";return l&&t},h.prototype.$isAnnotationVisible=function(t){var l=this.editor.isRowFullyVisible(this.$rowIndexToRow(t)),t=this.$getAnnotation(t).style.display!=="none";return l&&t},h.prototype.$getFoldWidget=function(a){return this.lines.get(a).element.childNodes[1]},h.prototype.$getAnnotation=function(a){return this.lines.get(a).element.childNodes[2]},h.prototype.$findNearestFoldWidget=function(a){if(this.$isFoldWidgetVisible(a))return a;for(var l=0;0<a-l||a+l<this.lines.getLength()-1;){if(0<=a-++l&&this.$isFoldWidgetVisible(a-l))return a-l;if(a+l<=this.lines.getLength()-1&&this.$isFoldWidgetVisible(a+l))return a+l}return null},h.prototype.$findNearestAnnotation=function(a){if(this.$isAnnotationVisible(a))return a;for(var l=0;0<a-l||a+l<this.lines.getLength()-1;){if(0<=a-++l&&this.$isAnnotationVisible(a-l))return a-l;if(a+l<=this.lines.getLength()-1&&this.$isAnnotationVisible(a+l))return a+l}return null},h.prototype.$focusFoldWidget=function(a){a!=null&&((a=this.$getFoldWidget(a)).classList.add(this.editor.renderer.keyboardFocusClassName),a.focus())},h.prototype.$focusAnnotation=function(a){a!=null&&((a=this.$getAnnotation(a)).classList.add(this.editor.renderer.keyboardFocusClassName),a.setAttribute("role","button"),a.focus())},h.prototype.$blurFoldWidget=function(a){a=this.$getFoldWidget(a),a.classList.remove(this.editor.renderer.keyboardFocusClassName),a.blur()},h.prototype.$blurAnnotation=function(a){a=this.$getAnnotation(a),a.classList.remove(this.editor.renderer.keyboardFocusClassName),a.removeAttribute("role"),a.blur()},h.prototype.$moveFoldWidgetUp=function(){for(var a=this.activeRowIndex;0<a;)if(this.$isFoldWidgetVisible(--a))return this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=a,void this.$focusFoldWidget(this.activeRowIndex)},h.prototype.$moveFoldWidgetDown=function(){for(var a=this.activeRowIndex;a<this.lines.getLength()-1;)if(this.$isFoldWidgetVisible(++a))return this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=a,void this.$focusFoldWidget(this.activeRowIndex)},h.prototype.$moveAnnotationUp=function(){for(var a=this.activeRowIndex;0<a;)if(this.$isAnnotationVisible(--a))return this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=a,void this.$focusAnnotation(this.activeRowIndex)},h.prototype.$moveAnnotationDown=function(){for(var a=this.activeRowIndex;a<this.lines.getLength()-1;)if(this.$isAnnotationVisible(++a))return this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=a,void this.$focusAnnotation(this.activeRowIndex)},h.prototype.$switchLane=function(a){switch(a){case"annotation":this.activeLane!=="annotation"&&(l=this.$findNearestAnnotation(this.activeRowIndex))!=null&&(this.activeLane="annotation",this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=l,this.$focusAnnotation(this.activeRowIndex));break;case"fold":var l;this.activeLane!=="fold"&&(l=this.$findNearestFoldWidget(this.activeRowIndex))!=null&&(this.activeLane="fold",this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=l,this.$focusFoldWidget(this.activeRowIndex))}},h.prototype.$rowIndexToRow=function(a){return a=this.lines.get(a),a?a.row:null},h.prototype.$rowToRowIndex=function(a){for(var l=0;l<this.lines.getLength();l++)if(this.lines.get(l).row==a)return l;return null},f.GutterKeyboardHandler=h}),ace.define("ace/editor",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/line_widgets","ace/keyboard/gutter_handler","ace/config","ace/clipboard","ace/lib/keys"],function(u,f,T){var I=this&&this.__values||function(y){var _=typeof Symbol=="function"&&Symbol.iterator,W=_&&y[_],F=0;if(W)return W.call(y);if(y&&typeof y.length=="number")return{next:function(){return{value:(y=y&&F>=y.length?void 0:y)&&y[F++],done:!y}}};throw new TypeError(_?"Object is not iterable.":"Symbol.iterator is not defined.")},m=u("./lib/oop"),h=u("./lib/dom"),a=u("./lib/lang"),l=u("./lib/useragent"),t=u("./keyboard/textinput").TextInput,r=u("./mouse/mouse_handler").MouseHandler,e=u("./mouse/fold_handler").FoldHandler,n=u("./keyboard/keybinding").KeyBinding,s=u("./edit_session").EditSession,o=u("./search").Search,i=u("./range").Range,c=u("./lib/event_emitter").EventEmitter,d=u("./commands/command_manager").CommandManager,C=u("./commands/default_commands").commands,p=u("./config"),w=u("./token_iterator").TokenIterator,x=u("./line_widgets").LineWidgets,$=u("./keyboard/gutter_handler").GutterKeyboardHandler,P=u("./config").nls,B=u("./clipboard"),Z=u("./lib/keys"),u=(v.prototype.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=a.delayedCall(this.endOperation.bind(this,!0)),this.on("change",(function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}).bind(this),!0),this.on("changeSelection",(function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}).bind(this),!0)},v.prototype.startOperation=function(y){if(this.curOp){if(!y||this.curOp.command)return;this.prevOp=this.curOp}y||(this.previousCommand=null,y={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:y.command||{},args:y.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},v.prototype.endOperation=function(y){if(this.curOp&&this.session){if(y&&y.returnValue===!1||!this.session)return this.curOp=null;if((y!=1||!this.curOp.command||this.curOp.command.name!="mouse")&&(this._signal("beforeEndOperation"),this.curOp)){var y=this.curOp.command,_=y&&y.scrollIntoView;if(_){switch(_){case"center-animate":_="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var W=this.selection.getRange(),F=this.renderer.layerConfig;(W.start.row>=F.lastRow||W.end.row<=F.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}_=="animate"&&this.renderer.animateScrolling(this.curOp.scrollTop)}y=this.selection.toJSON(),this.curOp.selectionAfter=y,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(y),this.prevOp=this.curOp,this.curOp=null}}},v.prototype.$historyTracker=function(y){var _,W,F,Y;this.$mergeUndoDeltas&&(_=this.prevOp,W=this.$mergeableCommands,F=_.command&&y.command.name==_.command.name,y.command.name=="insertstring"?(Y=y.args,this.mergeNextCommand===void 0&&(this.mergeNextCommand=!0),F=F&&this.mergeNextCommand&&(!/\s/.test(Y)||/\s/.test(_.args)),this.mergeNextCommand=!0):F=F&&W.indexOf(y.command.name)!==-1,(F=this.$mergeUndoDeltas!="always"&&2e3<Date.now()-this.sequenceStartTime?!1:F)?this.session.mergeUndoDeltas=!0:W.indexOf(y.command.name)!==-1&&(this.sequenceStartTime=Date.now()))},v.prototype.setKeyboardHandler=function(y,_){var W;y&&typeof y=="string"&&y!="ace"?(this.$keybindingId=y,W=this,p.loadModule(["keybinding",y],function(F){W.$keybindingId==y&&W.keyBinding.setKeyboardHandler(F&&F.handler),_&&_()})):(this.$keybindingId=null,this.keyBinding.setKeyboardHandler(y),_&&_())},v.prototype.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},v.prototype.setSession=function(y){var _,W;this.session!=y&&(this.curOp&&this.endOperation(),this.curOp={},(_=this.session)&&(this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange),(W=this.session.getSelection()).off("changeCursor",this.$onCursorChange),W.off("changeSelection",this.$onSelectionChange)),(this.session=y)?(this.$onDocumentChange=this.onDocumentChange.bind(this),y.on("change",this.$onDocumentChange),this.renderer.setSession(y),this.$onChangeMode=this.onChangeMode.bind(this),y.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),y.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),y.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),y.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),y.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),y.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=y.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(y)),this._signal("changeSession",{session:y,oldSession:_}),this.curOp=null,_&&_._signal("changeEditor",{oldEditor:this}),y&&y._signal("changeEditor",{editor:this}),y)&&!y.destroyed&&y.bgTokenizer.scheduleStart()},v.prototype.getSession=function(){return this.session},v.prototype.setValue=function(y,_){return this.session.doc.setValue(y),_?_==1?this.navigateFileEnd():_==-1&&this.navigateFileStart():this.selectAll(),y},v.prototype.getValue=function(){return this.session.getValue()},v.prototype.getSelection=function(){return this.selection},v.prototype.resize=function(y){this.renderer.onResize(y)},v.prototype.setTheme=function(y,_){this.renderer.setTheme(y,_)},v.prototype.getTheme=function(){return this.renderer.getTheme()},v.prototype.setStyle=function(y){this.renderer.setStyle(y)},v.prototype.unsetStyle=function(y){this.renderer.unsetStyle(y)},v.prototype.getFontSize=function(){return this.getOption("fontSize")||h.computedStyle(this.container).fontSize},v.prototype.setFontSize=function(y){this.setOption("fontSize",y)},v.prototype.$highlightBrackets=function(){var y;this.$highlightPending||((y=this).$highlightPending=!0,setTimeout(function(){y.$highlightPending=!1;var _,W,F,Y,Q=y.session;Q&&!Q.destroyed&&(Q.$bracketHighlight&&(Q.$bracketHighlight.markerIds.forEach(function(z){Q.removeMarker(z)}),Q.$bracketHighlight=null),_=y.getCursorPosition(),W=(W=y.getKeyboardHandler())&&W.$getDirectionForHighlight&&W.$getDirectionForHighlight(y),(W=Q.getMatchingBracketRanges(_,W))||(F=new w(Q,_.row,_.column).getCurrentToken())&&/\b(?:tag-open|tag-name)/.test(F.type)&&(F=Q.getMatchingTags(_))&&(W=[F.openTagName,F.closeTagName]),(W=!W&&Q.$mode.getMatching?Q.$mode.getMatching(y.session):W)&&(Y="ace_bracket",Array.isArray(W)?W.length==1&&(Y="ace_error_bracket"):W=[W],W.length==2&&(i.comparePoints(W[0].end,W[1].start)==0?W=[i.fromPoints(W[0].start,W[1].end)]:i.comparePoints(W[0].start,W[1].end)==0&&(W=[i.fromPoints(W[1].start,W[0].end)])),Q.$bracketHighlight={ranges:W,markerIds:W.map(function(z){return Q.addMarker(z,Y,"text")})}),y.getHighlightIndentGuides())&&y.renderer.$textLayer.$highlightIndentGuide()},50))},v.prototype.focus=function(){this.textInput.focus()},v.prototype.isFocused=function(){return this.textInput.isFocused()},v.prototype.blur=function(){this.textInput.blur()},v.prototype.onFocus=function(y){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",y))},v.prototype.onBlur=function(y){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",y))},v.prototype.$cursorChange=function(){this.renderer.updateCursor(),this.$highlightBrackets(),this.$updateHighlightActiveLine()},v.prototype.onDocumentChange=function(y){var _=this.session.$useWrapMode,W=y.start.row==y.end.row?y.end.row:1/0;this.renderer.updateLines(y.start.row,W,_),this._signal("change",y),this.$cursorChange()},v.prototype.onTokenizerUpdate=function(y){y=y.data,this.renderer.updateLines(y.first,y.last)},v.prototype.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},v.prototype.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},v.prototype.onCursorChange=function(){this.$cursorChange(),this._signal("changeSelection")},v.prototype.$updateHighlightActiveLine=function(){var y,_,W=this.getSession();this.$highlightActiveLine&&(this.$selectionStyle=="line"&&this.selection.isMultiLine()||(y=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(y=!1),!this.renderer.$maxLines||this.session.getLength()!==1||1<this.renderer.$minLines||(y=!1)),W.$highlightLineMarker&&!y?(W.removeMarker(W.$highlightLineMarker.id),W.$highlightLineMarker=null):!W.$highlightLineMarker&&y?((_=new i(y.row,y.column,y.row,1/0)).id=W.addMarker(_,"ace_active-line","screenLine"),W.$highlightLineMarker=_):y&&(W.$highlightLineMarker.start.row=y.row,W.$highlightLineMarker.end.row=y.row,W.$highlightLineMarker.start.column=y.column,W._signal("changeBackMarker"))},v.prototype.onSelectionChange=function(y){var _,W,F=this.session,F=(F.$selectionMarker&&F.removeMarker(F.$selectionMarker),F.$selectionMarker=null,this.selection.isEmpty()?this.$updateHighlightActiveLine():(_=this.selection.getRange(),W=this.getSelectionStyle(),F.$selectionMarker=F.addMarker(_,"ace_selection",W)),this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp());this.session.highlight(F),this._signal("changeSelection")},v.prototype.$getSelectionHighLightRegexp=function(){var y=this.session,_=this.getSelectionRange();if(!_.isEmpty()&&!_.isMultiLine()){var W=_.start.column,F=_.end.column,y=y.getLine(_.start.row),_=y.substring(W,F);if(!(5e3<_.length)&&/[\w\d]/.test(_)&&(_=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:_}),y=y.substring(W-1,F+1),_.test(y)))return _}},v.prototype.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},v.prototype.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},v.prototype.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},v.prototype.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},v.prototype.onChangeMode=function(y){this.renderer.updateText(),this._emit("changeMode",y)},v.prototype.onChangeWrapLimit=function(){this.renderer.updateFull()},v.prototype.onChangeWrapMode=function(){this.renderer.onResize(!0)},v.prototype.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},v.prototype.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},v.prototype.getCopyText=function(){var y=this.getSelectedText(),_=this.session.doc.getNewLineCharacter(),W=!1;if(!y&&this.$copyWithEmptySelection)for(var W=!0,F=this.selection.getAllRanges(),Y=0;Y<F.length;Y++){var Q=F[Y];Y&&F[Y-1].start.row==Q.start.row||(y+=this.session.getLine(Q.start.row)+_)}var z={text:y};return this._signal("copy",z),B.lineMode=!!W&&z.text,z.text},v.prototype.onCopy=function(){this.commands.exec("copy",this)},v.prototype.onCut=function(){this.commands.exec("cut",this)},v.prototype.onPaste=function(y,_){this.commands.exec("paste",this,{text:y,event:_})},v.prototype.$handlePaste=function(W){this._signal("paste",W=typeof W=="string"?{text:W}:W);var _=W.text,W=_===B.lineMode,F=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)W?F.insert({row:this.selection.lead.row,column:0},_):this.insert(_);else if(W)this.selection.rangeList.ranges.forEach(function(E){F.insert({row:E.start.row,column:0},_)});else{var Y=_.split(/\r\n|\r|\n/),Q=this.selection.rangeList.ranges,W=!(Y.length!=2||Y[0]&&Y[1]);if(Y.length!=Q.length||W)return this.commands.exec("insertstring",this,_);for(var z=Q.length;z--;){var te=Q[z];te.isEmpty()||F.remove(te),F.insert(te.start,Y[z])}}},v.prototype.execCommand=function(y,_){return this.commands.exec(y,this,_)},v.prototype.insert=function(y,te){var W,F=this.session,Y=F.getMode(),Q=this.getCursorPosition(),z=(this.getBehavioursEnabled()&&!te&&(W=Y.transformAction(F.getState(Q.row),"insertion",this,F,y))&&(y===W.text||this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1),y=W.text),y=="	"&&(y=this.session.getTabString()),this.selection.isEmpty()?this.session.getOverwrite()&&y.indexOf(`
`)==-1&&((z=new i.fromPoints(Q,Q)).end.column+=y.length,this.session.remove(z)):(z=this.getSelectionRange(),Q=this.session.remove(z),this.clearSelection()),y!=`
`&&y!=`\r
`||(E=F.getLine(Q.row),Q.column>E.search(/\S|$/)&&(te=E.substr(Q.column).search(/\S|$/),F.doc.removeInLine(Q.row,Q.column,Q.column+te))),this.clearSelection(),Q.column),te=F.getState(Q.row),E=F.getLine(Q.row),H=Y.checkOutdent(te,E,y);F.insert(Q,y),W&&W.selection&&(W.selection.length==2?this.selection.setSelectionRange(new i(Q.row,z+W.selection[0],Q.row,z+W.selection[1])):this.selection.setSelectionRange(new i(Q.row+W.selection[0],W.selection[1],Q.row+W.selection[2],W.selection[3]))),this.$enableAutoIndent&&(F.getDocument().isNewLine(y)&&(z=Y.getNextLineIndent(te,E.slice(0,Q.column),F.getTabString()),F.insert({row:Q.row+1,column:0},z)),H)&&Y.autoOutdent(te,F,Q.row)},v.prototype.autoIndent=function(){for(var y,_,W,F,Y,Q=this.session,z=Q.getMode(),te=(W=this.selection.isEmpty()?(_=0,Q.doc.getLength()-1):(_=(y=this.getSelectionRange()).start.row,y.end.row),""),E="",H=Q.getTabString(),V=_;V<=W;V++)0<V&&(te=Q.getState(V-1),F=Q.getLine(V-1),E=z.getNextLineIndent(te,F,H)),F=Q.getLine(V),E!==(Y=z.$getIndent(F))&&(0<Y.length&&(Y=new i(V,0,V,Y.length),Q.remove(Y)),0<E.length)&&Q.insert({row:V,column:0},E),z.autoOutdent(te,Q,V)},v.prototype.onTextInput=function(y,_){if(!_)return this.keyBinding.onTextInput(y);this.startOperation({command:{name:"insertstring"}}),y=this.applyComposition.bind(this,y,_),this.selection.rangeCount?this.forEachSelection(y):y(),this.endOperation()},v.prototype.applyComposition=function(y,_){var W;(_.extendLeft||_.extendRight)&&((W=this.selection.getRange()).start.column-=_.extendLeft,W.end.column+=_.extendRight,W.start.column<0&&(W.start.row--,W.start.column+=this.session.getLine(W.start.row).length+1),this.selection.setRange(W),y||W.isEmpty()||this.remove()),!y&&this.selection.isEmpty()||this.insert(y,!0),(_.restoreStart||_.restoreEnd)&&((W=this.selection.getRange()).start.column-=_.restoreStart,W.end.column-=_.restoreEnd,this.selection.setRange(W))},v.prototype.onCommandKey=function(y,_,W){return this.keyBinding.onCommandKey(y,_,W)},v.prototype.setOverwrite=function(y){this.session.setOverwrite(y)},v.prototype.getOverwrite=function(){return this.session.getOverwrite()},v.prototype.toggleOverwrite=function(){this.session.toggleOverwrite()},v.prototype.setScrollSpeed=function(y){this.setOption("scrollSpeed",y)},v.prototype.getScrollSpeed=function(){return this.getOption("scrollSpeed")},v.prototype.setDragDelay=function(y){this.setOption("dragDelay",y)},v.prototype.getDragDelay=function(){return this.getOption("dragDelay")},v.prototype.setSelectionStyle=function(y){this.setOption("selectionStyle",y)},v.prototype.getSelectionStyle=function(){return this.getOption("selectionStyle")},v.prototype.setHighlightActiveLine=function(y){this.setOption("highlightActiveLine",y)},v.prototype.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},v.prototype.setHighlightGutterLine=function(y){this.setOption("highlightGutterLine",y)},v.prototype.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},v.prototype.setHighlightSelectedWord=function(y){this.setOption("highlightSelectedWord",y)},v.prototype.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},v.prototype.setAnimatedScroll=function(y){this.renderer.setAnimatedScroll(y)},v.prototype.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},v.prototype.setShowInvisibles=function(y){this.renderer.setShowInvisibles(y)},v.prototype.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},v.prototype.setDisplayIndentGuides=function(y){this.renderer.setDisplayIndentGuides(y)},v.prototype.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},v.prototype.setHighlightIndentGuides=function(y){this.renderer.setHighlightIndentGuides(y)},v.prototype.getHighlightIndentGuides=function(){return this.renderer.getHighlightIndentGuides()},v.prototype.setShowPrintMargin=function(y){this.renderer.setShowPrintMargin(y)},v.prototype.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},v.prototype.setPrintMarginColumn=function(y){this.renderer.setPrintMarginColumn(y)},v.prototype.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},v.prototype.setReadOnly=function(y){this.setOption("readOnly",y)},v.prototype.getReadOnly=function(){return this.getOption("readOnly")},v.prototype.setBehavioursEnabled=function(y){this.setOption("behavioursEnabled",y)},v.prototype.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},v.prototype.setWrapBehavioursEnabled=function(y){this.setOption("wrapBehavioursEnabled",y)},v.prototype.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},v.prototype.setShowFoldWidgets=function(y){this.setOption("showFoldWidgets",y)},v.prototype.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},v.prototype.setFadeFoldWidgets=function(y){this.setOption("fadeFoldWidgets",y)},v.prototype.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},v.prototype.remove=function(Y){this.selection.isEmpty()&&(Y=="left"?this.selection.selectLeft():this.selection.selectRight());var _,W,F,Y=this.getSelectionRange();this.getBehavioursEnabled()&&(W=(_=this.session).getState(Y.start.row),W=_.getMode().transformAction(W,"deletion",this,_,Y),Y.end.column===0&&(F=_.getTextRange(Y))[F.length-1]==`
`&&(F=_.getLine(Y.end.row),/^\s+$/.test(F))&&(Y.end.column=F.length),W)&&(Y=W),this.session.remove(Y),this.clearSelection()},v.prototype.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},v.prototype.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},v.prototype.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},v.prototype.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var y=this.getSelectionRange();y.start.column==y.end.column&&y.start.row==y.end.row&&(y.end.column=0,y.end.row++),this.session.remove(y),this.clearSelection()},v.prototype.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var y=this.getCursorPosition();this.insert(`
`),this.moveCursorToPosition(y)},v.prototype.setGhostText=function(y,_){this.session.widgetManager||(this.session.widgetManager=new x(this.session),this.session.widgetManager.attach(this)),this.renderer.setGhostText(y,_)},v.prototype.removeGhostText=function(){this.session.widgetManager&&this.renderer.removeGhostText()},v.prototype.transposeLetters=function(){var y,_,W,F;this.selection.isEmpty()&&(_=(y=this.getCursorPosition()).column)!==0&&(F=_<(F=this.session.getLine(y.row)).length?(W=F.charAt(_)+F.charAt(_-1),new i(y.row,_-1,y.row,_+1)):(W=F.charAt(_-1)+F.charAt(_-2),new i(y.row,_-2,y.row,_)),this.session.replace(F,W),this.session.selection.moveToPosition(F.end))},v.prototype.toLowerCase=function(){var y=this.getSelectionRange(),_=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),W=this.session.getTextRange(_);this.session.replace(_,W.toLowerCase()),this.selection.setSelectionRange(y)},v.prototype.toUpperCase=function(){var y=this.getSelectionRange(),_=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),W=this.session.getTextRange(_);this.session.replace(_,W.toUpperCase()),this.selection.setSelectionRange(y)},v.prototype.indent=function(){var y=this.session,_=this.getSelectionRange();if(!(_.start.row<_.end.row)){if(_.start.column<_.end.column){var W,Q=y.getTextRange(_);if(!/^\s+$/.test(Q))return W=this.$getSelectedRows(),void y.indentRows(W.first,W.last,"	")}var F=y.getLine(_.start.row),Q=_.start,Y=y.getTabSize(),Q=y.documentToScreenColumn(Q.row,Q.column);if(this.session.getUseSoftTabs())var z=Y-Q%Y,te=a.stringRepeat(" ",z);else{for(z=Q%Y;F[_.start.column-1]==" "&&z;)_.start.column--,z--;this.selection.setSelectionRange(_),te="	"}return this.insert(te)}W=this.$getSelectedRows(),y.indentRows(W.first,W.last,"	")},v.prototype.blockIndent=function(){var y=this.$getSelectedRows();this.session.indentRows(y.first,y.last,"	")},v.prototype.blockOutdent=function(){var y=this.session.getSelection();this.session.outdentRows(y.getRange())},v.prototype.sortLines=function(){for(var y=this.$getSelectedRows(),_=this.session,W=[],F=y.first;F<=y.last;F++)W.push(_.getLine(F));W.sort(function(z,te){return z.toLowerCase()<te.toLowerCase()?-1:z.toLowerCase()>te.toLowerCase()?1:0});for(var Y=new i(0,0,0,0),F=y.first;F<=y.last;F++){var Q=_.getLine(F);Y.start.row=F,Y.end.row=F,Y.end.column=Q.length,_.replace(Y,W[F-y.first])}},v.prototype.toggleCommentLines=function(){var y=this.session.getState(this.getCursorPosition().row),_=this.$getSelectedRows();this.session.getMode().toggleCommentLines(y,this.session,_.first,_.last)},v.prototype.toggleBlockComment=function(){var y=this.getCursorPosition(),_=this.session.getState(y.row),W=this.getSelectionRange();this.session.getMode().toggleBlockComment(_,this.session,W,y)},v.prototype.getNumberAt=function(y,_){for(var W=/[\-]?[0-9]+(?:\.[0-9]+)?/g,F=(W.lastIndex=0,this.session.getLine(y));W.lastIndex<_;){var Y=W.exec(F);if(Y.index<=_&&Y.index+Y[0].length>=_)return{value:Y[0],start:Y.index,end:Y.index+Y[0].length}}return null},v.prototype.modifyNumber=function(y){var _,W,F,Y=this.selection.getCursor().row,Q=this.selection.getCursor().column,z=new i(Y,Q-1,Y,Q),z=this.session.getTextRange(z);!isNaN(parseFloat(z))&&isFinite(z)?(z=this.getNumberAt(Y,Q))&&(F=0<=z.value.indexOf(".")?z.start+z.value.indexOf(".")+1:z.end,_=z.start+z.value.length-F,W=parseFloat(z.value),W*=Math.pow(10,_),F!==z.end&&Q<F?y*=Math.pow(10,z.end-Q-1):y*=Math.pow(10,z.end-Q),F=(W=(W+=y)/Math.pow(10,_)).toFixed(_),y=new i(Y,z.start,Y,z.end),this.session.replace(y,F),this.moveCursorTo(Y,Math.max(z.start+1,Q+F.length-z.value.length))):this.toggleWord()},v.prototype.toggleWord=function(){for(var y,_=this.selection.getCursor().row,W=this.selection.getCursor().column,F=(this.selection.selectWord(),this.getSelectedText()),Y=this.selection.getWordRange().start.column,Q=F.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),z=W-Y-1,te=(z<0&&(z=0),0),E=this,H=(F.match(/[A-Za-z0-9_]+/)&&Q.forEach(function(J,re){y=te+J.length,te<=z&&z<=y&&(F=J,E.selection.clearSelection(),E.moveCursorTo(_,te+Y),E.selection.selectTo(_,y+Y)),te=y}),this.$toggleWordPairs),V=0;V<H.length;V++)for(var b=H[V],S=0;S<=1;S++){var R=+!S,O=F.match(new RegExp("^\\s?_?("+a.escapeRegExp(b[S])+")\\s?$","i"));O&&F.match(new RegExp("([_]|^|\\s)("+a.escapeRegExp(O[1])+")($|\\s)","g"))&&(O=F.replace(new RegExp(a.escapeRegExp(b[S]),"i"),function(J){var re=b[R];return J.toUpperCase()==J?re=re.toUpperCase():J.charAt(0).toUpperCase()==J.charAt(0)&&(re=re.substr(0,0)+b[R].charAt(0).toUpperCase()+re.substr(1)),re}),this.insert(O))}},v.prototype.findLinkAt=function(Q,_){var W,F,Y,Q=this.session.getLine(Q).split(/((?:https?|ftp):\/\/[\S]+)/),z=_,te=(z<0&&(z=0),0);try{for(var E=I(Q),H=E.next();!H.done;H=E.next()){var V=H.value,b=te+V.length;if(te<=z&&z<=b&&V.match(/((?:https?|ftp):\/\/[\S]+)/)){Y=V.replace(/[\s:.,'";}\]]+$/,"");break}te=b}}catch(S){W={error:S}}finally{try{H&&!H.done&&(F=E.return)&&F.call(E)}finally{if(W)throw W.error}}return Y},v.prototype.openLink=function(){var y=this.selection.getCursor(),y=this.findLinkAt(y.row,y.column);return y&&window.open(y,"_blank"),y!=null},v.prototype.removeLines=function(){var y=this.$getSelectedRows();this.session.removeFullLines(y.first,y.last),this.clearSelection()},v.prototype.duplicateSelection=function(){var y,_=this.selection,W=this.session,F=_.getRange(),Y=_.isBackwards();F.isEmpty()?(y=F.start.row,W.duplicateLines(y,y)):(y=Y?F.start:F.end,W=W.insert(y,W.getTextRange(F),!1),F.start=y,F.end=W,_.setSelectionRange(F,Y))},v.prototype.moveLinesDown=function(){this.$moveLines(1,!1)},v.prototype.moveLinesUp=function(){this.$moveLines(-1,!1)},v.prototype.moveText=function(y,_,W){return this.session.moveText(y,_,W)},v.prototype.copyLinesUp=function(){this.$moveLines(-1,!0)},v.prototype.copyLinesDown=function(){this.$moveLines(1,!0)},v.prototype.$moveLines=function(y,_){var W=this.selection;if(!W.inMultiSelectMode||this.inVirtualSelectionMode){var F=W.toOrientedRange(),Y=this.$getSelectedRows(F),Q=this.session.$moveLines(Y.first,Y.last,_?0:y);F.moveBy(Q=_&&y==-1?0:Q,0),W.fromOrientedRange(F)}else{for(var z=W.rangeList.ranges,te=(W.rangeList.detach(this.session),this.inVirtualSelectionMode=!0,0),E=0,H=z.length,V=0;V<H;V++){for(var b=V,S=(z[V].moveBy(te,0),(Y=this.$getSelectedRows(z[V])).first),R=Y.last;++V<H;){E&&z[V].moveBy(E,0);var O=this.$getSelectedRows(z[V]);if(_&&O.first!=R||!_&&O.first>R+1)break;R=O.last}for(V--,te=this.session.$moveLines(S,R,_?0:y),_&&y==-1&&(b=V+1);b<=V;)z[b].moveBy(te,0),b++;E+=te=_?te:0}W.fromOrientedRange(W.ranges[0]),W.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},v.prototype.$getSelectedRows=function(y){return y=(y||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(y.start.row),last:this.session.getRowFoldEnd(y.end.row)}},v.prototype.onCompositionStart=function(y){this.renderer.showComposition(y)},v.prototype.onCompositionUpdate=function(y){this.renderer.setCompositionText(y)},v.prototype.onCompositionEnd=function(){this.renderer.hideComposition()},v.prototype.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},v.prototype.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},v.prototype.isRowVisible=function(y){return y>=this.getFirstVisibleRow()&&y<=this.getLastVisibleRow()},v.prototype.isRowFullyVisible=function(y){return y>=this.renderer.getFirstFullyVisibleRow()&&y<=this.renderer.getLastFullyVisibleRow()},v.prototype.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},v.prototype.$moveByPage=function(Q,_){var W=this.renderer,F=this.renderer.layerConfig,Y=Q*Math.floor(F.height/F.lineHeight),Q=(_===!0?this.selection.$moveSelection(function(){this.moveCursorBy(Y,0)}):_===!1&&(this.selection.moveCursorBy(Y,0),this.selection.clearSelection()),W.scrollTop);W.scrollBy(0,Y*F.lineHeight),_!=null&&W.scrollCursorIntoView(null,.5),W.animateScrolling(Q)},v.prototype.selectPageDown=function(){this.$moveByPage(1,!0)},v.prototype.selectPageUp=function(){this.$moveByPage(-1,!0)},v.prototype.gotoPageDown=function(){this.$moveByPage(1,!1)},v.prototype.gotoPageUp=function(){this.$moveByPage(-1,!1)},v.prototype.scrollPageDown=function(){this.$moveByPage(1)},v.prototype.scrollPageUp=function(){this.$moveByPage(-1)},v.prototype.scrollToRow=function(y){this.renderer.scrollToRow(y)},v.prototype.scrollToLine=function(y,_,W,F){this.renderer.scrollToLine(y,_,W,F)},v.prototype.centerSelection=function(){var y=this.getSelectionRange(),y={row:Math.floor(y.start.row+(y.end.row-y.start.row)/2),column:Math.floor(y.start.column+(y.end.column-y.start.column)/2)};this.renderer.alignCursor(y,.5)},v.prototype.getCursorPosition=function(){return this.selection.getCursor()},v.prototype.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},v.prototype.getSelectionRange=function(){return this.selection.getRange()},v.prototype.selectAll=function(){this.selection.selectAll()},v.prototype.clearSelection=function(){this.selection.clearSelection()},v.prototype.moveCursorTo=function(y,_){this.selection.moveCursorTo(y,_)},v.prototype.moveCursorToPosition=function(y){this.selection.moveCursorToPosition(y)},v.prototype.jumpToMatching=function(y,_){var W=this.getCursorPosition(),F=new w(this.session,W.row,W.column),Y=F.getCurrentToken(),Q=0,z=(Y=Y&&Y.type.indexOf("tag-name")!==-1?F.stepBackward():Y)||F.stepForward();if(z){var te,E,H=!1,V={},b=W.column-z.start,S={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do if(z.value.match(/[{}()\[\]]/g)){for(;b<z.value.length&&!H;b++)if(S[z.value[b]])switch(E=S[z.value[b]]+"."+z.type.replace("rparen","lparen"),isNaN(V[E])&&(V[E]=0),z.value[b]){case"(":case"[":case"{":V[E]++;break;case")":case"]":case"}":V[E]--,V[E]===-1&&(te="bracket",H=!0)}}else z.type.indexOf("tag-name")!==-1&&(isNaN(V[z.value])&&(V[z.value]=0),Y.value==="<"&&1<Q?V[z.value]++:Y.value==="</"&&V[z.value]--,V[z.value]===-1)&&(te="tag",H=!0);while(H||(Y=z,Q++,z=F.stepForward(),b=0),z&&!H);if(te){if(te==="bracket")!(O=this.session.getBracketRange(W))&&(J=(O=new i(F.getCurrentTokenRow(),F.getCurrentTokenColumn()+b-1,F.getCurrentTokenRow(),F.getCurrentTokenColumn()+b-1)).start,_||J.row===W.row&&Math.abs(J.column-W.column)<2)&&(O=this.session.getBracketRange(J));else if(te==="tag"){if(!z||z.type.indexOf("tag-name")===-1)return;var R,O,J=(J=(O=new i(F.getCurrentTokenRow(),F.getCurrentTokenColumn()-2,F.getCurrentTokenRow(),F.getCurrentTokenColumn()-2)).compare(W.row,W.column)===0&&(R=this.session.getMatchingTags(W))?R.openTag.contains(W.row,W.column)?(O=R.closeTag).start:(O=R.openTag,R.closeTag.start.row===W.row&&R.closeTag.start.column===W.column?O.end:O.start):J)||O.start}(J=O&&O.cursor||J)&&(y?O&&_?this.selection.setRange(O):O&&O.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(J.row,J.column):this.selection.moveTo(J.row,J.column))}}},v.prototype.gotoLine=function(y,_,W){this.selection.clearSelection(),this.session.unfold({row:y-1,column:_||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(y-1,_||0),this.isRowFullyVisible(y-1)||this.scrollToLine(y-1,!0,W)},v.prototype.navigateTo=function(y,_){this.selection.moveTo(y,_)},v.prototype.navigateUp=function(y){var _;if(this.selection.isMultiLine()&&!this.selection.isBackwards())return _=this.selection.anchor.getPosition(),this.moveCursorToPosition(_);this.selection.clearSelection(),this.selection.moveCursorBy(-y||-1,0)},v.prototype.navigateDown=function(y){var _;if(this.selection.isMultiLine()&&this.selection.isBackwards())return _=this.selection.anchor.getPosition(),this.moveCursorToPosition(_);this.selection.clearSelection(),this.selection.moveCursorBy(y||1,0)},v.prototype.navigateLeft=function(y){if(this.selection.isEmpty())for(y=y||1;y--;)this.selection.moveCursorLeft();else{var _=this.getSelectionRange().start;this.moveCursorToPosition(_)}this.clearSelection()},v.prototype.navigateRight=function(y){if(this.selection.isEmpty())for(y=y||1;y--;)this.selection.moveCursorRight();else{var _=this.getSelectionRange().end;this.moveCursorToPosition(_)}this.clearSelection()},v.prototype.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},v.prototype.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},v.prototype.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},v.prototype.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},v.prototype.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},v.prototype.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},v.prototype.replace=function(y,W){W&&this.$search.set(W);var W=this.$search.find(this.session),F=0;return W&&(this.$tryReplace(W,y)&&(F=1),this.selection.setSelectionRange(W),this.renderer.scrollSelectionIntoView(W.start,W.end)),F},v.prototype.replaceAll=function(y,_){_&&this.$search.set(_);var W=this.$search.findAll(this.session),F=0;if(W.length){_=this.getSelectionRange(),this.selection.moveTo(0,0);for(var Y=W.length-1;0<=Y;--Y)this.$tryReplace(W[Y],y)&&F++;this.selection.setSelectionRange(_)}return F},v.prototype.$tryReplace=function(y,_){var W=this.session.getTextRange(y);return(_=this.$search.replace(W,_))!==null?(y.end=this.session.replace(y,_),y):null},v.prototype.getLastSearchOptions=function(){return this.$search.getOptions()},v.prototype.find=function(Y,_,W){_=_||{},typeof Y=="string"||Y instanceof RegExp?_.needle=Y:typeof Y=="object"&&m.mixin(_,Y);var F=this.selection.getRange(),Y=(_.needle==null&&((Y=this.session.getTextRange(F)||this.$search.$options.needle)||(F=this.session.getWordRange(F.start.row,F.start.column),Y=this.session.getTextRange(F)),this.$search.set({needle:Y})),this.$search.set(_),_.start||this.$search.set({start:F}),this.$search.find(this.session));return _.preventScroll?Y:Y?(this.revealRange(Y,W),Y):(_.backwards?F.start=F.end:F.end=F.start,void this.selection.setRange(F))},v.prototype.findNext=function(y,_){this.find({skipCurrent:!0,backwards:!1},y,_)},v.prototype.findPrevious=function(y,_){this.find(y,{skipCurrent:!0,backwards:!0},_)},v.prototype.revealRange=function(y,_){this.session.unfold(y),this.selection.setSelectionRange(y);var W=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(y.start,y.end,.5),_!==!1&&this.renderer.animateScrolling(W)},v.prototype.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},v.prototype.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},v.prototype.destroy=function(){this.$toDestroy&&(this.$toDestroy.forEach(function(y){y.destroy()}),this.$toDestroy=null),this.$mouseHandler&&this.$mouseHandler.destroy(),this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy(),this._$emitInputEvent&&this._$emitInputEvent.cancel(),this.removeAllListeners()},v.prototype.setAutoScrollEditorIntoView=function(y){var _,W,F,Y,Q,z,te;y&&(F=!1,(W=this).$scrollAnchor||(this.$scrollAnchor=document.createElement("div")),(Y=this.$scrollAnchor).style.cssText="position:absolute",this.container.insertBefore(Y,this.container.firstChild),Q=this.on("changeSelection",function(){F=!0}),z=this.renderer.on("beforeRender",function(){F&&(_=W.renderer.container.getBoundingClientRect())}),te=this.renderer.on("afterRender",function(){var E,H,V;F&&_&&(W.isFocused()||W.searchBox&&W.searchBox.isFocused())&&(E=(H=W.renderer).$cursorLayer.$pixelPos,H=H.layerConfig,V=E.top-H.offset,(F=0<=E.top&&V+_.top<0||!(E.top<H.height&&E.top+_.top+H.lineHeight>window.innerHeight)&&null)!=null&&(Y.style.top=V+"px",Y.style.left=E.left+"px",Y.style.height=H.lineHeight+"px",Y.scrollIntoView(F)),F=_=null)}),this.setAutoScrollEditorIntoView=function(E){E||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",Q),this.renderer.off("afterRender",te),this.renderer.off("beforeRender",z))})},v.prototype.$resetCursorStyle=function(){var y=this.$cursorStyle||"ace",_=this.renderer.$cursorLayer;_&&(_.setSmoothBlinking(/smooth/.test(y)),_.isBlinking=!this.$readOnly&&y!="wide",h.setCssClass(_.element,"ace_slim-cursors",/slim/.test(y)))},v.prototype.prompt=function(y,_,W){var F=this;p.loadModule("ace/ext/prompt",function(Y){Y.prompt(F,y,_,W)})},v);function v(y,_,W){this.$toDestroy=[];var F=y.getContainerElement();this.container=F,this.renderer=y,this.id="editor"+ ++v.$uid,this.commands=new d(l.isMac?"mac":"win",C),typeof document=="object"&&(this.textInput=new t(y.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new r(this),new e(this)),this.keyBinding=new n(this),this.$search=new o().set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=a.delayedCall((function(){this._signal("input",{}),this.session&&!this.session.destroyed&&this.session.bgTokenizer.scheduleStart()}).bind(this)),this.on("change",function(Y,Q){Q._$emitInputEvent.schedule(31)}),this.setSession(_||W&&W.session||new s("")),p.resetOptions(this),W&&this.setOptions(W),p._signal("editor",this)}u.$uid=0,u.prototype.curOp=null,u.prototype.prevOp={},u.prototype.$mergeableCommands=["backspace","del","insertstring"],u.prototype.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],m.implement(u.prototype,c),p.defineOptions(u.prototype,"editor",{selectionStyle:{set:function(y){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:y})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(y){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(y){this.textInput.setReadOnly(y),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(y){this.textInput.setCopyWithEmptySelection(y)},initialValue:!1},cursorStyle:{set:function(y){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},enableAutoIndent:{initialValue:!0},autoScrollEditorIntoView:{set:function(y){this.setAutoScrollEditorIntoView(y)}},keyboardHandler:{set:function(y){this.setKeyboardHandler(y)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(y){this.session.setValue(y)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(y){this.setSession(y)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(y){this.renderer.$gutterLayer.setShowLineNumbers(y),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),y&&this.$relativeLineNumbers?N.attach(this):N.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(y){this.$showLineNumbers&&y?N.attach(this):N.detach(this)}},placeholder:{set:function(y){this.$updatePlaceholder||(this.$updatePlaceholder=(function(){var _=this.session&&(this.renderer.$composition||this.getValue());_&&this.renderer.placeholderNode?(this.renderer.off("afterRender",this.$updatePlaceholder),h.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null):_||this.renderer.placeholderNode?!_&&this.renderer.placeholderNode&&(this.renderer.placeholderNode.textContent=this.$placeholder||""):(this.renderer.on("afterRender",this.$updatePlaceholder),h.addCssClass(this.container,"ace_hasPlaceholder"),(_=h.createElement("div")).className="ace_placeholder",_.textContent=this.$placeholder||"",this.renderer.placeholderNode=_,this.renderer.content.appendChild(this.renderer.placeholderNode))}).bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},enableKeyboardAccessibility:{set:function(y){function _(Y){Y.target==this.renderer.scroller&&Y.keyCode===Z.enter&&(Y.preventDefault(),Y=this.getCursorPosition().row,this.isRowVisible(Y)||this.scrollToLine(Y,!0,!0),this.focus())}var W,F={name:"blurTextInput",description:"Set focus to the editor content div to allow tabbing through the page",bindKey:"Esc",exec:function(Y){Y.blur(),Y.renderer.scroller.focus()},readOnly:!0};y?(this.renderer.enableKeyboardAccessibility=!0,this.renderer.keyboardFocusClassName="ace_keyboard-focus",this.textInput.getElement().setAttribute("tabindex",-1),this.renderer.scroller.setAttribute("tabindex",0),this.renderer.scroller.setAttribute("role","group"),this.renderer.scroller.setAttribute("aria-roledescription",P("editor")),this.renderer.scroller.classList.add(this.renderer.keyboardFocusClassName),this.renderer.scroller.setAttribute("aria-label",P("Editor content, press Enter to start editing, press Escape to exit")),this.renderer.scroller.addEventListener("keyup",_.bind(this)),this.commands.addCommand(F),this.renderer.$gutter.setAttribute("tabindex",0),this.renderer.$gutter.setAttribute("aria-hidden",!1),this.renderer.$gutter.setAttribute("role","group"),this.renderer.$gutter.setAttribute("aria-roledescription",P("editor")),this.renderer.$gutter.setAttribute("aria-label",P("Editor gutter, press Enter to interact with controls using arrow keys, press Escape to exit")),this.renderer.$gutter.classList.add(this.renderer.keyboardFocusClassName),this.renderer.content.setAttribute("aria-hidden",!0),(W=W||new $(this)).addListener()):(this.renderer.enableKeyboardAccessibility=!1,this.textInput.getElement().setAttribute("tabindex",0),this.renderer.scroller.setAttribute("tabindex",-1),this.renderer.scroller.removeAttribute("role"),this.renderer.scroller.removeAttribute("aria-roledescription"),this.renderer.scroller.classList.remove(this.renderer.keyboardFocusClassName),this.renderer.scroller.removeAttribute("aria-label"),this.renderer.scroller.removeEventListener("keyup",_.bind(this)),this.commands.removeCommand(F),this.renderer.content.removeAttribute("aria-hidden"),this.renderer.$gutter.setAttribute("tabindex",-1),this.renderer.$gutter.setAttribute("aria-hidden",!0),this.renderer.$gutter.removeAttribute("role"),this.renderer.$gutter.removeAttribute("aria-roledescription"),this.renderer.$gutter.removeAttribute("aria-label"),this.renderer.$gutter.classList.remove(this.renderer.keyboardFocusClassName),W&&W.removeListener())},initialValue:!1},customScrollbar:"renderer",hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",highlightIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",useResizeObserver:"renderer",useSvgGutterIcons:"renderer",showFoldedAnnotations:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});var N={getText:function(y,_){return(Math.abs(y.selection.lead.row-_)||_+1+(_<9?"·":""))+""},getWidth:function(y,_,W){return Math.max(_.toString().length,(W.lastRow+1).toString().length,2)*W.characterWidth},update:function(y,_){_.renderer.$loop.schedule(_.renderer.CHANGE_GUTTER)},attach:function(y){y.renderer.$gutterLayer.$renderer=this,y.on("changeSelection",this.update),this.update(null,y)},detach:function(y){y.renderer.$gutterLayer.$renderer==this&&(y.renderer.$gutterLayer.$renderer=null),y.off("changeSelection",this.update),this.update(null,y)}};f.Editor=u}),ace.define("ace/undomanager",["require","exports","module","ace/range"],function(A,f,T){m.prototype.addSession=function(i){this.$session=i},m.prototype.add=function(i,c,d){this.$fromUndo||i!=this.$lastDelta&&(this.$keepRedoStack||(this.$redoStack.length=0),c!==!1&&this.lastDeltas||(this.lastDeltas=[],(c=this.$undoStack.length)>this.$undoDepth-1&&this.$undoStack.splice(0,c-this.$undoDepth+1),this.$undoStack.push(this.lastDeltas),i.id=this.$rev=++this.$maxRev),i.action!="remove"&&i.action!="insert"||(this.$lastDelta=i),this.lastDeltas.push(i))},m.prototype.addSelection=function(i,c){this.selections.push({value:i,rev:c||this.$rev})},m.prototype.startNewGroup=function(){return this.lastDeltas=null,this.$rev},m.prototype.markIgnored=function(i,c){c==null&&(c=this.$rev+1);for(var d=this.$undoStack,C=d.length;C--;){var p=d[C][0];if(p.id<=i)break;p.id<c&&(p.ignore=!0)}this.lastDeltas=null},m.prototype.getSelection=function(i,c){for(var d=this.selections,C=d.length;C--;){var p=d[C];if(p.rev<i)return p=c?d[C+1]:p}},m.prototype.getRevision=function(){return this.$rev},m.prototype.getDeltas=function(i,c){c==null&&(c=this.$rev+1);for(var d=this.$undoStack,C=null,p=0,w=d.length;w--;){var x=d[w][0];if(x.id<c&&!C&&(C=w+1),x.id<=i){p=w+1;break}}return d.slice(p,C)},m.prototype.getChangedRanges=function(i,c){c==null&&this.$rev},m.prototype.getChangedLines=function(i,c){c==null&&this.$rev},m.prototype.undo=function(i,c){this.lastDeltas=null;var d,C=this.$undoStack;if(function(p,w){for(var x=w;x--;){var $=p[x];if($&&!$[0].ignore){for(;x<w-1;){var P=function(B,Z){for(var u=B.length;u--;)for(var v=0;v<Z.length;v++)if(!e(B[u],Z[v])){for(;u<B.length;){for(;v--;)e(Z[v],B[u]);v=Z.length,u++}return[B,Z]}return B.selectionBefore=Z.selectionBefore=B.selectionAfter=Z.selectionAfter=null,[Z,B]}(p[x],p[x+1]);p[x]=P[0],p[x+1]=P[1],x++}return 1}}}(C,C.length))return i=i||this.$session,this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0,d=null,(C=C.pop())&&(d=i.undoChanges(C,c),this.$redoStack.push(C),this.$syncRev()),this.$fromUndo=!1,d},m.prototype.redo=function(i,c){if(this.lastDeltas=null,i=i||this.$session,this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev){for(var N=this.getDeltas(this.$redoStackBaseRev,this.$rev+1),d=this.$redoStack,C=N,p=0;p<C.length;p++)for(var w=C[p],x=0;x<w.length;x++){$=void 0,P=void 0,B=void 0,Z=void 0,u=void 0,v=void 0;var $=d,P=w[x];P=function(W){return{start:l(W.start),end:l(W.end),action:W.action,lines:W.lines.slice()}}(P);for(var B=$.length;B--;){for(var Z=$[B],u=0;u<Z.length;u++){var v=function(W,F){var Y,Q,z=W.action=="insert",te=F.action=="insert";if(z&&te)a(W.start,F.start)<0?n(F,W,1):n(W,F,1);else if(z&&!te)0<=a(W.start,F.end)?n(W,F,-1):(a(W.start,F.start)<=0||n(W,h.fromPoints(F.start,W.start),-1),n(F,W,1));else if(!z&&te)0<=a(F.start,W.end)?n(F,W,-1):(a(F.start,W.start)<=0||n(F,h.fromPoints(W.start,F.start),-1),n(W,F,1));else if(!z&&!te)if(0<=a(F.start,W.end))n(F,W,-1);else{if(!(a(F.end,W.start)<=0))return a(W.start,F.start)<0&&(W=o(Y=W,F.start)),0<a(W.end,F.end)&&(Q=o(W,F.end)),s(F.end,W.start,W.end,-1),Q&&!Y&&(W.lines=Q.lines,W.start=Q.start,W.end=Q.end,Q=W),[F,Y,Q].filter(Boolean);n(W,F,-1)}return[F,W]}(Z[u],P);P=v[0],v.length!=2&&(v[2]?(Z.splice(u+1,1,v[1],v[2]),u++):v[1]||(Z.splice(u,1),u--))}Z.length||$.splice(B,1)}}this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach(function(_){_[0].id=++this.$maxRev},this)}var N=this.$redoStack.pop(),y=null;return N&&(y=i.redoChanges(N,c),this.$undoStack.push(N),this.$syncRev()),this.$fromUndo=!1,y},m.prototype.$syncRev=function(){var i=this.$undoStack,i=i[i.length-1],i=i&&i[0].id||0;this.$redoStackBaseRev=i,this.$rev=i},m.prototype.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},m.prototype.canUndo=function(){return 0<this.$undoStack.length},m.prototype.canRedo=function(){return 0<this.$redoStack.length},m.prototype.bookmark=function(i){i==null&&(i=this.$rev),this.mark=i},m.prototype.isAtBookmark=function(){return this.$rev===this.mark},m.prototype.toJSON=function(){},m.prototype.fromJSON=function(){},m.prototype.$prettyPrint=function(i){return i?t(i):t(this.$undoStack)+`
---
`+t(this.$redoStack)};var I=m;function m(){this.$maxRev=0,this.$fromUndo=!1,this.$undoDepth=1/0,this.reset()}I.prototype.hasUndo=I.prototype.canUndo,I.prototype.hasRedo=I.prototype.canRedo,I.prototype.isClean=I.prototype.isAtBookmark,I.prototype.markClean=I.prototype.bookmark;var h=A("./range").Range,a=h.comparePoints;h.comparePoints;function l(i){return{row:i.row,column:i.column}}function t(i){var c;return i=i||this,Array.isArray(i)?i.map(t).join(`
`):(c="",i.action?(c=i.action=="insert"?"+":"-",c+="["+i.lines+"]"):i.value&&(c=Array.isArray(i.value)?i.value.map(r).join(`
`):r(i.value)),i.start&&(c+=r(i)),(i.id||i.rev)&&(c+="	("+(i.id||i.rev)+")"),c)}function r(i){return i.start.row+":"+i.start.column+"=>"+i.end.row+":"+i.end.column}function e(i,c){var d=i.action=="insert",C=c.action=="insert";if(d&&C)if(0<=a(c.start,i.end))n(c,i,-1);else{if(!(a(c.start,i.start)<=0))return;n(i,c,1)}else if(d&&!C)if(0<=a(c.start,i.end))n(c,i,-1);else{if(!(a(c.end,i.start)<=0))return;n(i,c,-1)}else if(!d&&C)if(0<=a(c.start,i.start))n(c,i,1);else{if(!(a(c.start,i.start)<=0))return;n(i,c,1)}else if(!d&&!C)if(0<=a(c.start,i.start))n(c,i,1);else{if(!(a(c.end,i.start)<=0))return;n(i,c,-1)}return 1}function n(i,c,d){s(i.start,c.start,c.end,d),s(i.end,c.start,c.end,d)}function s(i,c,d,C){i.row==(C==1?c:d).row&&(i.column+=C*(d.column-c.column)),i.row+=C*(d.row-c.row)}function o(i,c){var d=i.lines,C=i.end,w=(i.end=l(c),i.end.row-i.start.row),p=d.splice(w,d.length),w=w?c.column:c.column-i.start.column;return d.push(p[0].substring(0,w)),p[0]=p[0].substr(w),{start:l(c),end:C,lines:p,action:i.action}}f.UndoManager=I}),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],function(A,f,T){var I=A("../lib/dom");function m(h,a){this.element=h,this.canvasHeight=a||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0}m.prototype.moveContainer=function(h){I.translate(this.element,0,-(h.firstRowScreen*h.lineHeight%this.canvasHeight)-h.offset*this.$offsetCoefficient)},m.prototype.pageChanged=function(h,a){return Math.floor(h.firstRowScreen*h.lineHeight/this.canvasHeight)!==Math.floor(a.firstRowScreen*a.lineHeight/this.canvasHeight)},m.prototype.computeLineTop=function(h,a,l){var t=a.firstRowScreen*a.lineHeight,t=Math.floor(t/this.canvasHeight);return l.documentToScreenRow(h,0)*a.lineHeight-t*this.canvasHeight},m.prototype.computeLineHeight=function(h,a,l){return a.lineHeight*l.getRowLineCount(h)},m.prototype.getLength=function(){return this.cells.length},m.prototype.get=function(h){return this.cells[h]},m.prototype.shift=function(){this.$cacheCell(this.cells.shift())},m.prototype.pop=function(){this.$cacheCell(this.cells.pop())},m.prototype.push=function(h){if(Array.isArray(h)){this.cells.push.apply(this.cells,h);for(var a=I.createFragment(this.element),l=0;l<h.length;l++)a.appendChild(h[l].element);this.element.appendChild(a)}else this.cells.push(h),this.element.appendChild(h.element)},m.prototype.unshift=function(h){if(Array.isArray(h)){this.cells.unshift.apply(this.cells,h);for(var a=I.createFragment(this.element),l=0;l<h.length;l++)a.appendChild(h[l].element);this.element.firstChild?this.element.insertBefore(a,this.element.firstChild):this.element.appendChild(a)}else this.cells.unshift(h),this.element.insertAdjacentElement("afterbegin",h.element)},m.prototype.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},m.prototype.$cacheCell=function(h){h&&(h.element.remove(),this.cellCache.push(h))},m.prototype.createCell=function(h,a,l,t){var r,e=this.cellCache.pop();return e||(r=I.createElement("div"),t&&t(r),this.element.appendChild(r),e={element:r,text:"",row:h}),e.row=h,e},f.Lines=m}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines","ace/config"],function(r,f,T){var I=r("../lib/dom"),m=r("../lib/oop"),h=r("../lib/lang"),a=r("../lib/event_emitter").EventEmitter,l=r("./lines").Lines,t=r("../config").nls,r=(e.prototype.setSession=function(s){this.session&&this.session.off("change",this.$updateAnnotations),(this.session=s)&&s.on("change",this.$updateAnnotations)},e.prototype.addGutterDecoration=function(s,o){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(s,o)},e.prototype.removeGutterDecoration=function(s,o){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(s,o)},e.prototype.setAnnotations=function(s){this.$annotations=[];for(var o=0;o<s.length;o++){var i=s[o],C=i.row,c=(c=this.$annotations[C])||(this.$annotations[C]={text:[],type:[]}),C=i.text,d=i.type,C=C?h.escapeHTML(C):i.html||"",C=(c.text.indexOf(C)===-1&&(c.text.push(C),c.type.push(d)),i.className);C?c.className=C:d=="error"?c.className=" ace_error":d=="warning"&&c.className!=" ace_error"?c.className=" ace_warning":d!="info"||c.className||(c.className=" ace_info")}},e.prototype.$updateAnnotations=function(s){var o,i;this.$annotations.length&&(o=s.start.row,(i=s.end.row-o)!=0)&&(s.action=="remove"?this.$annotations.splice(o,1+i,null):((s=new Array(1+i)).unshift(o,1),this.$annotations.splice.apply(this.$annotations,s)))},e.prototype.update=function(s){this.config=s;for(var o=this.session,i=s.firstRow,c=Math.min(s.lastRow+s.gutterOffset,o.getLength()-1),d=(this.oldLastRow=c,this.config=s,this.$lines.moveContainer(s),this.$updateCursorRow(),o.getNextFoldLine(i)),C=d?d.start.row:1/0,p=null,w=-1,x=i;;){if(C<x&&(x=d.end.row+1,C=(d=o.getNextFoldLine(x,d))?d.start.row:1/0),c<x){for(;this.$lines.getLength()>w+1;)this.$lines.pop();break}(p=this.$lines.get(++w))?p.row=x:(p=this.$lines.createCell(x,s,this.session,n),this.$lines.push(p)),this.$renderCell(p,s,d,x),x++}this._signal("afterRender"),this.$updateGutterWidth(s)},e.prototype.$updateGutterWidth=function(s){var o=this.session,d=o.gutterRenderer||this.$renderer,c=o.$firstLineNumber,i=this.$lines.last()?this.$lines.last().text:"",c=((this.$fixedWidth||o.$useWrapMode)&&(i=o.getLength()+c-1),d?d.getWidth(o,i,s):i.toString().length*s.characterWidth),d=this.$padding||this.$computePadding();(c+=d.left+d.right)===this.gutterWidth||isNaN(c)||(this.gutterWidth=c,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",c))},e.prototype.$updateCursorRow=function(){var s;this.$highlightGutterLine&&(s=this.session.selection.getCursor(),this.$cursorRow!==s.row)&&(this.$cursorRow=s.row)},e.prototype.updateLineHighlight=function(){if(this.$highlightGutterLine){var s=this.session.selection.cursor.row;if(this.$cursorRow=s,!this.$cursorCell||this.$cursorCell.row!=s){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var o=this.$lines.cells;this.$cursorCell=null;for(var i=0;i<o.length;i++){var c=o[i];if(c.row>=this.$cursorRow){if(c.row>this.$cursorRow){var d=this.session.getFoldLine(this.$cursorRow);if(!(0<i&&d&&d.start.row==o[i-1].row))break;c=o[i-1]}c.element.className="ace_gutter-active-line "+c.element.className,this.$cursorCell=c;break}}}}},e.prototype.scrollLines=function(s){var o=this.config;if(this.config=s,this.$updateCursorRow(),this.$lines.pageChanged(o,s))return this.update(s);this.$lines.moveContainer(s);var i=Math.min(s.lastRow+s.gutterOffset,this.session.getLength()-1),c=this.oldLastRow;if(this.oldLastRow=i,!o||c<s.firstRow)return this.update(s);if(i<o.firstRow)return this.update(s);if(o.firstRow<s.firstRow)for(var d=this.session.getFoldedRowCount(o.firstRow,s.firstRow-1);0<d;d--)this.$lines.shift();if(i<c)for(d=this.session.getFoldedRowCount(i+1,c);0<d;d--)this.$lines.pop();s.firstRow<o.firstRow&&this.$lines.unshift(this.$renderLines(s,s.firstRow,o.firstRow-1)),c<i&&this.$lines.push(this.$renderLines(s,c+1,i)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(s)},e.prototype.$renderLines=function(s,o,i){for(var c=[],d=o,C=this.session.getNextFoldLine(d),p=C?C.start.row:1/0;p<d&&(d=C.end.row+1,p=(C=this.session.getNextFoldLine(d,C))?C.start.row:1/0),!(i<d);){var w=this.$lines.createCell(d,s,this.session,n);this.$renderCell(w,s,C,d),c.push(w),d++}return c},e.prototype.$renderCell=function(s,o,i,c){var d,C=s.element,p=this.session,w=C.childNodes[0],x=C.childNodes[1],$=C.childNodes[2],P=$.firstChild,B=p.$firstLineNumber,Z=p.$breakpoints,u=p.$decorations,F=p.gutterRenderer||this.$renderer,v=this.$showFoldWidgets&&p.foldWidgets,N=i?i.start.row:Number.MAX_VALUE,y=o.lineHeight+"px",_=this.$useSvgGutterIcons?"ace_gutter-cell_svg-icons ":"ace_gutter-cell ",W=this.$useSvgGutterIcons?"ace_icon_svg":"ace_icon",F=(F?F.getText(p,c):c+B).toString();if(this.$highlightGutterLine&&(c==this.$cursorRow||i&&c<this.$cursorRow&&N<=c&&this.$cursorRow<=i.end.row)&&(_+="ace_gutter-active-line ",this.$cursorCell!=s)&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=s),Z[c]&&(_+=Z[c]),u[c]&&(_+=u[c]),this.$annotations[c]&&c!==N&&(_+=this.$annotations[c].className),C.className!=_&&(C.className=_),d=v&&(d=v[c])==null?v[c]=p.getFoldWidget(c):d){if(_="ace_fold-widget ace_"+d,d=="start"&&c==N&&c<i.end.row){_+=" ace_closed";for(var Y,Q=!1,z=c+1;z<=i.end.row;z++)if(this.$annotations[z]){if(this.$annotations[z].className===" ace_error"){Q=!0,Y=" ace_error_fold";break}this.$annotations[z].className===" ace_warning"&&(Q=!0,Y=" ace_warning_fold")}C.className+=Y}else _+=" ace_open";x.className!=_&&(x.className=_),I.setStyle(x.style,"height",y),I.setStyle(x.style,"display","inline-block"),x.setAttribute("role","button"),x.setAttribute("tabindex","-1"),(i=p.getFoldLine(F-1))?(x.setAttribute("aria-label",t("Unfold rows $0 to $1",[F,i.end.row+1])),x.setAttribute("title",t("Unfold code"))):(x.setAttribute("aria-label",t("Fold at row $0",[F])),x.setAttribute("title",t("Fold code")))}else x&&(I.setStyle(x.style,"display","none"),x.setAttribute("tabindex","0"),x.removeAttribute("role"),x.removeAttribute("aria-label"));return Q&&this.$showFoldedAnnotations?($.className="ace_gutter_annotation",P.className=W,P.className+=Y,I.setStyle(P.style,"height",y),I.setStyle($.style,"display","block"),I.setStyle($.style,"height",y),$.setAttribute("aria-label",t("Read annotations row $0",[F])),$.setAttribute("tabindex","-1")):this.$annotations[c]?($.className="ace_gutter_annotation",P.className=W,this.$useSvgGutterIcons?P.className+=this.$annotations[c].className:C.classList.add(this.$annotations[c].className.replace(" ","")),I.setStyle(P.style,"height",y),I.setStyle($.style,"display","block"),I.setStyle($.style,"height",y),$.setAttribute("aria-label",t("Read annotations row $0",[F])),$.setAttribute("tabindex","-1")):(I.setStyle($.style,"display","none"),$.removeAttribute("aria-label"),$.setAttribute("tabindex","0")),F!==w.data&&(w.data=F),I.setStyle(s.element.style,"height",this.$lines.computeLineHeight(c,o,p)+"px"),I.setStyle(s.element.style,"top",this.$lines.computeLineTop(c,o,p)+"px"),s.text=F,$.style.display==="none"&&x.style.display==="none"?s.element.setAttribute("aria-hidden",!0):s.element.setAttribute("aria-hidden",!1),s},e.prototype.setHighlightGutterLine=function(s){this.$highlightGutterLine=s},e.prototype.setShowLineNumbers=function(s){this.$renderer=!s&&{getWidth:function(){return 0},getText:function(){return""}}},e.prototype.getShowLineNumbers=function(){return this.$showLineNumbers},e.prototype.setShowFoldWidgets=function(s){s?I.addCssClass(this.element,"ace_folding-enabled"):I.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=s,this.$padding=null},e.prototype.getShowFoldWidgets=function(){return this.$showFoldWidgets},e.prototype.$computePadding=function(){var s;return this.element.firstChild?(s=I.computedStyle(this.element.firstChild),this.$padding={},this.$padding.left=(parseInt(s.borderLeftWidth)||0)+(parseInt(s.paddingLeft)||0)+1,this.$padding.right=(parseInt(s.borderRightWidth)||0)+(parseInt(s.paddingRight)||0),this.$padding):{left:0,right:0}},e.prototype.getRegion=function(s){var o=this.$padding||this.$computePadding(),i=this.element.getBoundingClientRect();return s.x<o.left+i.left?"markers":this.$showFoldWidgets&&s.x>i.right-o.right?"foldWidgets":void 0},e);function e(s){this.element=I.createElement("div"),this.element.className="ace_layer ace_gutter-layer",s.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new l(this.element),this.$lines.$offsetCoefficient=1}function n(s){var o=document.createTextNode(""),o=(s.appendChild(o),I.createElement("span")),o=(s.appendChild(o),I.createElement("span")),i=(s.appendChild(o),I.createElement("span"));return o.appendChild(i),s}r.prototype.$fixedWidth=!1,r.prototype.$highlightGutterLine=!0,r.prototype.$renderer="",r.prototype.$showLineNumbers=!0,r.prototype.$showFoldWidgets=!0,m.implement(r.prototype,a),f.Gutter=r}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(h,f,T){var I=h("../range").Range,m=h("../lib/dom"),h=(a.prototype.setPadding=function(l){this.$padding=l},a.prototype.setSession=function(l){this.session=l},a.prototype.setMarkers=function(l){this.markers=l},a.prototype.elt=function(l,t){var r=this.i!=-1&&this.element.childNodes[this.i];r?this.i++:(r=document.createElement("div"),this.element.appendChild(r),this.i=-1),r.style.cssText=t,r.className=l},a.prototype.update=function(l){if(l){var t,r;for(r in this.config=l,this.i=0,this.markers){var e,n,s,o=this.markers[r];o.range?(s=o.range.clipRows(l.firstRow,l.lastRow)).isEmpty()||(s=s.toScreenRange(this.session),o.renderer?(e=this.$getTop(s.start.row,l),n=this.$padding+s.start.column*l.characterWidth,o.renderer(t,s,n,e,l)):o.type=="fullLine"?this.drawFullLineMarker(t,s,o.clazz,l):o.type=="screenLine"?this.drawScreenLineMarker(t,s,o.clazz,l):s.isMultiLine()?o.type=="text"?this.drawTextMarker(t,s,o.clazz,l):this.drawMultiLineMarker(t,s,o.clazz,l):this.drawSingleLineMarker(t,s,o.clazz+" ace_start ace_br15",l)):o.update(t,this,this.session,l)}if(this.i!=-1)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},a.prototype.$getTop=function(l,t){return(l-t.firstRowScreen)*t.lineHeight},a.prototype.drawTextMarker=function(l,t,r,e,n){for(var s,o=this.session,i=t.start.row,c=t.end.row,d=i,C=0,p=o.getScreenLastRowColumn(d),w=new I(d,t.start.column,d,C);d<=c;d++)w.start.row=w.end.row=d,w.start.column=d==i?t.start.column:o.getRowWrapIndent(d),w.end.column=p,s=C,C=p,p=d+1<c?o.getScreenLastRowColumn(d+1):d==c?0:t.end.column,this.drawSingleLineMarker(l,w,r+(d==i?" ace_start":"")+" ace_br"+((d==i||d==i+1&&t.start.column?1:0)|(s<C?2:0)|(p<C?4:0)|(d==c?8:0)),e,d==c?0:1,n)},a.prototype.drawMultiLineMarker=function(l,t,r,e,n){var s,o=this.$padding,i=e.lineHeight,c=this.$getTop(t.start.row,e),d=o+t.start.column*e.characterWidth;n=n||"",this.session.$bidiHandler.isBidiRow(t.start.row)?((s=t.clone()).end.row=s.start.row,s.end.column=this.session.getLine(s.start.row).length,this.drawBidiSingleLineMarker(l,s,r+" ace_br1 ace_start",e,null,n)):this.elt(r+" ace_br1 ace_start","height:"+i+"px;right:0;top:"+c+"px;left:"+d+"px;"+(n||"")),this.session.$bidiHandler.isBidiRow(t.end.row)?((s=t.clone()).start.row=s.end.row,s.start.column=0,this.drawBidiSingleLineMarker(l,s,r+" ace_br12",e,null,n)):(c=this.$getTop(t.end.row,e),d=t.end.column*e.characterWidth,this.elt(r+" ace_br12","height:"+i+"px;width:"+d+"px;top:"+c+"px;left:"+o+"px;"+(n||""))),(i=(t.end.row-t.start.row-1)*e.lineHeight)<=0||(c=this.$getTop(t.start.row+1,e),l=(t.start.column?1:0)|(t.end.column?0:8),this.elt(r+(l?" ace_br"+l:""),"height:"+i+"px;right:0;top:"+c+"px;left:"+o+"px;"+(n||"")))},a.prototype.drawSingleLineMarker=function(o,d,r,e,i,s){if(this.session.$bidiHandler.isBidiRow(d.start.row))return this.drawBidiSingleLineMarker(o,d,r,e,i,s);var o=e.lineHeight,i=(d.end.column+(i||0)-d.start.column)*e.characterWidth,c=this.$getTop(d.start.row,e),d=this.$padding+d.start.column*e.characterWidth;this.elt(r,"height:"+o+"px;width:"+i+"px;top:"+c+"px;left:"+d+"px;"+(s||""))},a.prototype.drawBidiSingleLineMarker=function(l,t,r,e,n,s){var o=e.lineHeight,i=this.$getTop(t.start.row,e),c=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach(function(d){this.elt(r,"height:"+o+"px;width:"+(d.width+(n||0))+"px;top:"+i+"px;left:"+(c+d.left)+"px;"+(s||""))},this)},a.prototype.drawFullLineMarker=function(l,t,r,e,n){var s=this.$getTop(t.start.row,e),o=e.lineHeight;t.start.row!=t.end.row&&(o+=this.$getTop(t.end.row,e)-s),this.elt(r,"height:"+o+"px;top:"+s+"px;left:0;right:0;"+(n||""))},a.prototype.drawScreenLineMarker=function(l,t,r,e,n){t=this.$getTop(t.start.row,e),e=e.lineHeight,this.elt(r,"height:"+e+"px;top:"+t+"px;left:0;right:0;"+(n||""))},a);function a(l){this.element=m.createElement("div"),this.element.className="ace_layer ace_marker-layer",l.appendChild(this.element)}h.prototype.$padding=0,f.Marker=h}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter"],function(l,f,T){var I=l("../lib/oop"),m=l("../lib/dom"),h=l("../lib/lang"),a=l("./lines").Lines,l=l("../lib/event_emitter").EventEmitter,t=(r.prototype.$updateEolChar=function(){var e=this.session.doc,e=e.getNewLineCharacter()==`
`&&e.getNewLineMode()!="windows"?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=e)return this.EOL_CHAR=e,!0},r.prototype.setPadding=function(e){this.$padding=e,this.element.style.margin="0 "+e+"px"},r.prototype.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},r.prototype.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},r.prototype.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",(function(n){this._signal("changeCharacterSize",n)}).bind(this)),this.$pollSizeChanges()},r.prototype.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},r.prototype.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},r.prototype.setSession=function(e){(this.session=e)&&this.$computeTabString()},r.prototype.setShowInvisibles=function(e){return this.showInvisibles!=e&&(typeof(this.showInvisibles=e)=="string"?(this.showSpaces=/tab/i.test(e),this.showTabs=/space/i.test(e),this.showEOL=/eol/i.test(e)):this.showSpaces=this.showTabs=this.showEOL=e,this.$computeTabString(),!0)},r.prototype.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},r.prototype.setHighlightIndentGuides=function(e){return this.$highlightIndentGuides!==e&&(this.$highlightIndentGuides=e)},r.prototype.$computeTabString=function(){for(var e,n,s,o,i,c,d=this.session.getTabSize(),C=(this.tabSize=d,this.$tabStrings=[0]),p=1;p<d+1;p++)this.showTabs?((c=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",c.textContent=h.stringRepeat(this.TAB_CHAR,p),C.push(c)):C.push(this.dom.createTextNode(h.stringRepeat(" ",p),this.element));this.displayIndentGuides&&(this.$indentGuideRe=/\s\S| \t|\t |\s$/,e="ace_indent-guide",n=this.showSpaces?" ace_invisible ace_invisible_space":"",s=this.showSpaces?h.stringRepeat(this.SPACE_CHAR,this.tabSize):h.stringRepeat(" ",this.tabSize),o=this.showTabs?" ace_invisible ace_invisible_tab":"",i=this.showTabs?h.stringRepeat(this.TAB_CHAR,this.tabSize):s,(c=this.dom.createElement("span")).className=e+n,c.textContent=s,this.$tabStrings[" "]=c,(c=this.dom.createElement("span")).className=e+o,c.textContent=i,this.$tabStrings["	"]=c)},r.prototype.updateLines=function(e,n,s){if(this.config.lastRow!=e.lastRow||this.config.firstRow!=e.firstRow)return this.update(e);this.config=e;for(var o=Math.max(n,e.firstRow),i=Math.min(s,e.lastRow),c=this.element.childNodes,d=0,C=e.firstRow;C<o;C++){if(p=this.session.getFoldLine(C)){if(p.containsRow(o)){o=p.start.row;break}C=p.end.row}d++}for(var p,w=!1,C=o,x=(p=this.session.getNextFoldLine(C))?p.start.row:1/0;x<C&&(C=p.end.row+1,x=(p=this.session.getNextFoldLine(C,p))?p.start.row:1/0),!(i<C);){var $,P=c[d++];P&&(this.dom.removeChildren(P),this.$renderLine(P,C,C==x&&p),w&&(P.style.top=this.$lines.computeLineTop(C,e,this.session)+"px"),$=e.lineHeight*this.session.getRowLength(C)+"px",P.style.height!=$)&&(w=!0,P.style.height=$),C++}if(w)for(;d<this.$lines.cells.length;){var B=this.$lines.cells[d++];B.element.style.top=this.$lines.computeLineTop(B.row,e,this.session)+"px"}},r.prototype.scrollLines=function(e){var n=this.config;if(this.config=e,this.$lines.pageChanged(n,e))return this.update(e);this.$lines.moveContainer(e);var s=e.lastRow,o=n?n.lastRow:-1;if(!n||o<e.firstRow)return this.update(e);if(s<n.firstRow)return this.update(e);if(!n||n.lastRow<e.firstRow)return this.update(e);if(e.lastRow<n.firstRow)return this.update(e);if(n.firstRow<e.firstRow)for(var i=this.session.getFoldedRowCount(n.firstRow,e.firstRow-1);0<i;i--)this.$lines.shift();if(n.lastRow>e.lastRow)for(i=this.session.getFoldedRowCount(e.lastRow+1,n.lastRow);0<i;i--)this.$lines.pop();e.firstRow<n.firstRow&&this.$lines.unshift(this.$renderLinesFragment(e,e.firstRow,n.firstRow-1)),e.lastRow>n.lastRow&&this.$lines.push(this.$renderLinesFragment(e,n.lastRow+1,e.lastRow)),this.$highlightIndentGuide()},r.prototype.$renderLinesFragment=function(e,n,s){for(var o=[],i=n,c=this.session.getNextFoldLine(i),d=c?c.start.row:1/0;d<i&&(i=c.end.row+1,d=(c=this.session.getNextFoldLine(i,c))?c.start.row:1/0),!(s<i);){var C=this.$lines.createCell(i,e,this.session),p=C.element;this.dom.removeChildren(p),m.setStyle(p.style,"height",this.$lines.computeLineHeight(i,e,this.session)+"px"),m.setStyle(p.style,"top",this.$lines.computeLineTop(i,e,this.session)+"px"),this.$renderLine(p,i,i==d&&c),this.$useLineGroups()?p.className="ace_line_group":p.className="ace_line",o.push(C),i++}return o},r.prototype.update=function(e){this.$lines.moveContainer(e);for(var n=(this.config=e).firstRow,s=e.lastRow,o=this.$lines;o.getLength();)o.pop();o.push(this.$renderLinesFragment(e,n,s))},r.prototype.$renderToken=function(e,n,s,o){for(var i,c,d=this,C=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC\u2066\u2067\u2068\u202A\u202B\u202D\u202E\u202C\u2069]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,p=this.dom.createFragment(this.element),w=0;i=C.exec(o);){var x,$,P=i[1],B=i[2],Z=i[3],u=i[4],v=i[5];!d.showSpaces&&B||(x=w!=i.index?o.slice(w,i.index):"",w=i.index+i[0].length,x&&p.appendChild(this.dom.createTextNode(x,this.element)),P?(x=d.session.getScreenTabSize(n+i.index),p.appendChild(d.$tabStrings[x].cloneNode(!0)),n+=x-1):B?d.showSpaces?(($=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",$.textContent=h.stringRepeat(d.SPACE_CHAR,B.length),p.appendChild($)):p.appendChild(this.com.createTextNode(B,this.element)):Z?(($=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",$.textContent=h.stringRepeat(d.SPACE_CHAR,Z.length),p.appendChild($)):u?(n+=1,($=this.dom.createElement("span")).style.width=2*d.config.characterWidth+"px",$.className=d.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",$.textContent=d.showSpaces?d.SPACE_CHAR:u,p.appendChild($)):v&&(n+=1,($=this.dom.createElement("span")).style.width=2*d.config.characterWidth+"px",$.className="ace_cjk",$.textContent=v,p.appendChild($)))}return p.appendChild(this.dom.createTextNode(w?o.slice(w):o,this.element)),this.$textToken[s.type]?e.appendChild(p):(c="ace_"+s.type.replace(/\./g," ace_"),$=this.dom.createElement("span"),s.type=="fold"&&($.style.width=s.value.length*this.config.characterWidth+"px",$.setAttribute("title","Unfold code")),$.className=c,$.appendChild(p),e.appendChild($)),n+o.length},r.prototype.renderIndentGuide=function(e,n,s){var o=n.search(this.$indentGuideRe);if(!(o<=0||s<=o)){if(n[0]==" "){for(var i=(o-=o%this.tabSize)/this.tabSize,c=0;c<i;c++)e.appendChild(this.$tabStrings[" "].cloneNode(!0));return this.$highlightIndentGuide(),n.substr(o)}if(n[0]=="	"){for(c=0;c<o;c++)e.appendChild(this.$tabStrings["	"].cloneNode(!0));return this.$highlightIndentGuide(),n.substr(o)}this.$highlightIndentGuide()}return n},r.prototype.$highlightIndentGuide=function(){if(this.$highlightIndentGuides&&this.displayIndentGuides){this.$highlightIndentGuideMarker={indentLevel:void 0,start:void 0,end:void 0,dir:void 0};var e=this.session.doc.$lines;if(e){var n=this.session.selection.getCursor(),s=/^\s*/.exec(this.session.doc.getLine(n.row))[0].length,o=Math.floor(s/this.tabSize);if(this.$highlightIndentGuideMarker={indentLevel:o,start:n.row},this.session.$bracketHighlight){for(var i=this.session.$bracketHighlight.ranges,c=0;c<i.length;c++)if(n.row!==i[c].start.row){this.$highlightIndentGuideMarker.end=i[c].start.row,n.row>i[c].start.row?this.$highlightIndentGuideMarker.dir=-1:this.$highlightIndentGuideMarker.dir=1;break}}if(!this.$highlightIndentGuideMarker.end&&e[n.row]!==""&&n.column===e[n.row].length)for(this.$highlightIndentGuideMarker.dir=1,c=n.row+1;c<e.length;c++){var d=e[c],C=/^\s*/.exec(d)[0].length;if(d!==""&&(this.$highlightIndentGuideMarker.end=c,C<=s))break}this.$renderHighlightIndentGuide()}}},r.prototype.$clearActiveIndentGuide=function(){for(var e=this.$lines.cells,n=0;n<e.length;n++){var s=e[n].element.childNodes;if(0<s.length){for(var o=0;o<s.length;o++)if(s[o].classList&&s[o].classList.contains("ace_indent-guide-active")){s[o].classList.remove("ace_indent-guide-active");break}}}},r.prototype.$setIndentGuideActive=function(e,n){this.session.doc.getLine(e.row)!==""&&(e=e.element.childNodes)&&(e=e[n-1])&&e.classList&&e.classList.contains("ace_indent-guide")&&e.classList.add("ace_indent-guide-active")},r.prototype.$renderHighlightIndentGuide=function(){if(this.$lines){var e=this.$lines.cells,n=(this.$clearActiveIndentGuide(),this.$highlightIndentGuideMarker.indentLevel);if(n!==0){if(this.$highlightIndentGuideMarker.dir===1)for(var s=0;s<e.length;s++){var o=e[s];if(this.$highlightIndentGuideMarker.end&&o.row>=this.$highlightIndentGuideMarker.start+1){if(o.row>=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(o,n)}}else for(s=e.length-1;0<=s;s--)if(o=e[s],this.$highlightIndentGuideMarker.end&&o.row<this.$highlightIndentGuideMarker.start){if(o.row<=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(o,n)}}}},r.prototype.$createLineElement=function(e){var n=this.dom.createElement("div");return n.className="ace_line",n.style.height=this.config.lineHeight+"px",n},r.prototype.$renderWrappedLine=function(e,n,s){var o=0,i=0,c=s[0],d=0,C=this.$createLineElement();e.appendChild(C);for(var p=0;p<n.length;p++){var w=n[p],x=w.value;if(p==0&&this.displayIndentGuides){if(o=x.length,!(x=this.renderIndentGuide(C,x,c)))continue;o-=x.length}if(o+x.length<c)d=this.$renderToken(C,d,w,x),o+=x.length;else{for(;o+x.length>=c;)d=this.$renderToken(C,d,w,x.substring(0,c-o)),x=x.substring(c-o),o=c,C=this.$createLineElement(),e.appendChild(C),C.appendChild(this.dom.createTextNode(h.stringRepeat(" ",s.indent),this.element)),d=0,c=s[++i]||Number.MAX_VALUE;x.length!=0&&(o+=x.length,d=this.$renderToken(C,d,w,x))}}s[s.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(C,d,null,"",!0)},r.prototype.$renderSimpleLine=function(e,n){for(var s=0,o=0;o<n.length;o++){var i=n[o],c=i.value;if(o!=0||!this.displayIndentGuides||(c=this.renderIndentGuide(e,c))){if(s+c.length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(e,s,i,c);s=this.$renderToken(e,s,i,c)}}},r.prototype.$renderOverflowMessage=function(e,n,s,o,i){s&&this.$renderToken(e,n,s,o.slice(0,this.MAX_LINE_LENGTH-n)),s=this.dom.createElement("span"),s.className="ace_inline_button ace_keyword ace_toggle_wrap",s.textContent=i?"<hide>":"<click to see more...>",e.appendChild(s)},r.prototype.$renderLine=function(e,n,s){var o,i,c=e;(o=(s=s||s==0?s:this.session.getFoldLine(n))?this.$getFoldLineTokens(n,s):this.session.getTokens(n)).length?(i=this.session.getRowSplitData(n))&&i.length?(this.$renderWrappedLine(e,o,i),c=e.lastChild):(c=e,this.$useLineGroups()&&(c=this.$createLineElement(),e.appendChild(c)),this.$renderSimpleLine(c,o)):this.$useLineGroups()&&(c=this.$createLineElement(),e.appendChild(c)),this.showEOL&&c&&(s&&(n=s.end.row),(i=this.dom.createElement("span")).className="ace_invisible ace_invisible_eol",i.textContent=n==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,c.appendChild(i))},r.prototype.$getFoldLineTokens=function(e,n){var s=this.session,o=[],i=s.getTokens(e);return n.walk(function(c,d,C,p,w){if(c!=null)o.push({type:"fold",value:c});else if((i=w?s.getTokens(d):i).length){for(var x,$=i,P=p,B=C,Z=0,u=0;u+$[Z].value.length<P;)if(u+=$[Z].value.length,++Z==$.length)return;for(u!=P&&((x=$[Z].value.substring(P-u)).length>B-P&&(x=x.substring(0,B-P)),o.push({type:$[Z].type,value:x}),u=P+x.length,Z+=1);u<B&&Z<$.length;)(x=$[Z].value).length+u>B?o.push({type:$[Z].type,value:x.substring(0,B-u)}):o.push($[Z]),u+=x.length,Z+=1}},n.end.row,this.session.getLine(n.end.row).length),o},r.prototype.$useLineGroups=function(){return this.session.getUseWrapMode()},r);function r(e){this.dom=m,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new a(this.element)}t.prototype.$textToken={text:!0,rparen:!0,lparen:!0},t.prototype.EOF_CHAR="¶",t.prototype.EOL_CHAR_LF="¬",t.prototype.EOL_CHAR_CRLF="¤",t.prototype.EOL_CHAR=t.prototype.EOL_CHAR_LF,t.prototype.TAB_CHAR="—",t.prototype.SPACE_CHAR="·",t.prototype.$padding=0,t.prototype.MAX_LINE_LENGTH=1e4,t.prototype.showInvisibles=!1,t.prototype.showSpaces=!1,t.prototype.showTabs=!1,t.prototype.showEOL=!1,t.prototype.displayIndentGuides=!0,t.prototype.$highlightIndentGuides=!0,t.prototype.$tabStrings=[],t.prototype.destroy={},t.prototype.onChangeTabSize=t.prototype.$computeTabString,I.implement(t.prototype,l),f.Text=t}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(m,f,T){var I=m("../lib/dom"),m=(h.prototype.$updateOpacity=function(a){for(var l=this.cursors,t=l.length;t--;)I.setStyle(l[t].style,"opacity",a?"":"0")},h.prototype.$startCssAnimation=function(){for(var a=this.cursors,l=a.length;l--;)a[l].style.animationDuration=this.blinkInterval+"ms";this.$isAnimating=!0,setTimeout((function(){this.$isAnimating&&I.addCssClass(this.element,"ace_animate-blinking")}).bind(this))},h.prototype.$stopCssAnimation=function(){this.$isAnimating=!1,I.removeCssClass(this.element,"ace_animate-blinking")},h.prototype.setPadding=function(a){this.$padding=a},h.prototype.setSession=function(a){this.session=a},h.prototype.setBlinking=function(a){a!=this.isBlinking&&(this.isBlinking=a,this.restartTimer())},h.prototype.setBlinkInterval=function(a){a!=this.blinkInterval&&(this.blinkInterval=a,this.restartTimer())},h.prototype.setSmoothBlinking=function(a){a!=this.smoothBlinking&&(this.smoothBlinking=a,I.setCssClass(this.element,"ace_smooth-blinking",a),this.$updateCursors(!0),this.restartTimer())},h.prototype.addCursor=function(){var a=I.createElement("div");return a.className="ace_cursor",this.element.appendChild(a),this.cursors.push(a),a},h.prototype.removeCursor=function(){var a;if(1<this.cursors.length)return(a=this.cursors.pop()).parentNode.removeChild(a),a},h.prototype.hideCursor=function(){this.isVisible=!1,I.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},h.prototype.showCursor=function(){this.isVisible=!0,I.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},h.prototype.restartTimer=function(){var a,l=this.$updateCursors;clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&(this.$isSmoothBlinking=!1,I.removeCssClass(this.element,"ace_smooth-blinking")),l(!0),this.isBlinking&&this.blinkInterval&&this.isVisible?(this.smoothBlinking&&(this.$isSmoothBlinking=!0,setTimeout((function(){this.$isSmoothBlinking&&I.addCssClass(this.element,"ace_smooth-blinking")}).bind(this))),I.HAS_CSS_ANIMATION?this.$startCssAnimation():(a=(function(){this.timeoutId=setTimeout(function(){l(!1)},.6*this.blinkInterval)}).bind(this),this.intervalId=setInterval(function(){l(!0),a()},this.blinkInterval),a())):this.$stopCssAnimation()},h.prototype.getPixelPosition=function(a,l){if(!this.config||!this.session)return{left:0,top:0};a=a||this.session.selection.getCursor();var t=this.session.documentToScreenPosition(a);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(t.row,a.row)?this.session.$bidiHandler.getPosLeft(t.column):t.column*this.config.characterWidth),top:(t.row-(l?this.config.firstRowScreen:0))*this.config.lineHeight}},h.prototype.isCursorInView=function(a,l){return 0<=a.top&&a.top<l.maxHeight},h.prototype.update=function(a){this.config=a;for(var l=this.session.$selectionMarkers,r=0,t=0,r=0,e=(l=l!==void 0&&l.length!==0?l:[{cursor:null}]).length;r<e;r++){var n,s,o=this.getPixelPosition(l[r].cursor,!0);(o.top>a.height+a.offset||o.top<0)&&1<r||(s=(n=this.cursors[t++]||this.addCursor()).style,this.drawCursor?this.drawCursor(n,o,a,l[r],this.session):this.isCursorInView(o,a)?(I.setStyle(s,"display","block"),I.translate(n,o.left,o.top),I.setStyle(s,"width",Math.round(a.characterWidth)+"px"),I.setStyle(s,"height",a.lineHeight+"px")):I.setStyle(s,"display","none"))}for(;this.cursors.length>t;)this.removeCursor();var i=this.session.getOverwrite();this.$setOverwrite(i),this.$pixelPos=o,this.restartTimer()},h.prototype.$setOverwrite=function(a){a!=this.overwrite&&((this.overwrite=a)?I.addCssClass(this.element,"ace_overwrite-cursors"):I.removeCssClass(this.element,"ace_overwrite-cursors"))},h.prototype.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)},h);function h(a){this.element=I.createElement("div"),this.element.className="ace_layer ace_cursor-layer",a.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),I.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)}m.prototype.$padding=0,m.prototype.drawCursor=null,f.Cursor=m}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(o,f,T){var I,m=this&&this.__extends||(I=function(c,d){return(I=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(C,p){C.__proto__=p}:function(C,p){for(var w in p)Object.prototype.hasOwnProperty.call(p,w)&&(C[w]=p[w])}))(c,d)},function(c,d){if(typeof d!="function"&&d!==null)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");function C(){this.constructor=c}I(c,d),c.prototype=d===null?Object.create(d):(C.prototype=d.prototype,new C)}),e=o("./lib/oop"),h=o("./lib/dom"),a=o("./lib/event"),o=o("./lib/event_emitter").EventEmitter,l=(t.prototype.setVisible=function(c){this.element.style.display=c?"":"none",this.isVisible=c,this.coeff=1},t);function t(c,d){this.element=h.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+d,this.inner=h.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent=" ",this.element.appendChild(this.inner),c.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,a.addListener(this.element,"scroll",this.onScroll.bind(this)),a.addListener(this.element,"mousedown",a.preventDefault)}e.implement(l.prototype,o),m(n,r=l),n.prototype.onScroll=function(){var c;this.skipEvent||(this.scrollTop=this.element.scrollTop,this.coeff!=1&&(c=this.element.clientHeight/this.scrollHeight,this.scrollTop=this.scrollTop*(1-c)/(this.coeff-c)),this._emit("scroll",{data:this.scrollTop})),this.skipEvent=!1},n.prototype.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},n.prototype.setHeight=function(c){this.element.style.height=c+"px"},n.prototype.setScrollHeight=function(c){32768<(this.scrollHeight=c)?(this.coeff=32768/c,c=32768):this.coeff!=1&&(this.coeff=1),this.inner.style.height=c+"px"},n.prototype.setScrollTop=function(c){this.scrollTop!=c&&(this.skipEvent=!0,this.scrollTop=c,this.element.scrollTop=c*this.coeff)};var r,e=n;function n(c,d){var C=r.call(this,c,"-v")||this;return C.scrollTop=0,C.scrollHeight=0,d.$scrollbarWidth=C.width=h.scrollbarWidth(c.ownerDocument),C.inner.style.width=C.element.style.width=(C.width||15)+5+"px",C.$minWidth=0,C}e.prototype.setInnerHeight=e.prototype.setScrollHeight,m(i,s=l),i.prototype.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},i.prototype.getHeight=function(){return this.isVisible?this.height:0},i.prototype.setWidth=function(c){this.element.style.width=c+"px"},i.prototype.setInnerWidth=function(c){this.inner.style.width=c+"px"},i.prototype.setScrollWidth=function(c){this.inner.style.width=c+"px"},i.prototype.setScrollLeft=function(c){this.scrollLeft!=c&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=c)};var s,o=i;function i(c,d){return c=s.call(this,c,"-h")||this,c.scrollLeft=0,c.height=d.$scrollbarWidth,c.inner.style.height=c.element.style.height=(c.height||15)+5+"px",c}f.ScrollBar=e,f.ScrollBarV=e,f.ScrollBarH=o,f.VScrollBar=e,f.HScrollBar=o}),ace.define("ace/scrollbar_custom",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(o,f,T){var I,m=this&&this.__extends||(I=function(c,d){return(I=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(C,p){C.__proto__=p}:function(C,p){for(var w in p)Object.prototype.hasOwnProperty.call(p,w)&&(C[w]=p[w])}))(c,d)},function(c,d){if(typeof d!="function"&&d!==null)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");function C(){this.constructor=c}I(c,d),c.prototype=d===null?Object.create(d):(C.prototype=d.prototype,new C)}),e=o("./lib/oop"),h=o("./lib/dom"),a=o("./lib/event"),o=o("./lib/event_emitter").EventEmitter,l=(h.importCssString(`.ace_editor>.ace_sb-v div, .ace_editor>.ace_sb-h div{
  position: absolute;
  background: rgba(128, 128, 128, 0.6);
  -moz-box-sizing: border-box;
  box-sizing: border-box;
  border: 1px solid #bbb;
  border-radius: 2px;
  z-index: 8;
}
.ace_editor>.ace_sb-v, .ace_editor>.ace_sb-h {
  position: absolute;
  z-index: 6;
  background: none;
  overflow: hidden!important;
}
.ace_editor>.ace_sb-v {
  z-index: 6;
  right: 0;
  top: 0;
  width: 12px;
}
.ace_editor>.ace_sb-v div {
  z-index: 8;
  right: 0;
  width: 100%;
}
.ace_editor>.ace_sb-h {
  bottom: 0;
  left: 0;
  height: 12px;
}
.ace_editor>.ace_sb-h div {
  bottom: 0;
  height: 100%;
}
.ace_editor>.ace_sb_grabbed {
  z-index: 8;
  background: #000;
}`,"ace_scrollbar.css",!1),t.prototype.setVisible=function(c){this.element.style.display=c?"":"none",this.isVisible=c,this.coeff=1},t);function t(c,d){this.element=h.createElement("div"),this.element.className="ace_sb"+d,this.inner=h.createElement("div"),this.inner.className="",this.element.appendChild(this.inner),this.VScrollWidth=12,this.HScrollHeight=12,c.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,a.addMultiMouseDownListener(this.element,[500,300,300],this,"onMouseDown")}e.implement(l.prototype,o),m(n,r=l),n.prototype.onMouseDown=function(c,d){var C,p,w,x,$;if(c==="mousedown"&&a.getButton(d)===0&&d.detail!==2)return d.target===this.inner?(C=this,p=d.clientY,w=d.clientY,x=this.thumbTop,a.capture(this.inner,function(P){p=P.clientY},function(){clearInterval($)}),$=setInterval(function(){var P;p!==void 0&&(P=C.scrollTopFromThumbTop(x+p-w))!==C.scrollTop&&C._emit("scroll",{data:P})},20)):(c=d.clientY-this.element.getBoundingClientRect().top-this.thumbHeight/2,this._emit("scroll",{data:this.scrollTopFromThumbTop(c)})),a.preventDefault(d)},n.prototype.getHeight=function(){return this.height},n.prototype.scrollTopFromThumbTop=function(c){return c=c*(this.pageHeight-this.viewHeight)/(this.slideHeight-this.thumbHeight),(c>>=0)<0?c=0:c>this.pageHeight-this.viewHeight&&(c=this.pageHeight-this.viewHeight),c},n.prototype.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},n.prototype.setHeight=function(c){this.height=Math.max(0,c),this.slideHeight=this.height,this.viewHeight=this.height,this.setScrollHeight(this.pageHeight,!0)},n.prototype.setScrollHeight=function(c,d){(this.pageHeight!==c||d)&&(this.pageHeight=c,this.thumbHeight=this.slideHeight*this.viewHeight/this.pageHeight,this.thumbHeight>this.slideHeight&&(this.thumbHeight=this.slideHeight),this.thumbHeight<15&&(this.thumbHeight=15),this.inner.style.height=this.thumbHeight+"px",this.scrollTop>this.pageHeight-this.viewHeight)&&(this.scrollTop=this.pageHeight-this.viewHeight,this.scrollTop<0&&(this.scrollTop=0),this._emit("scroll",{data:this.scrollTop}))},n.prototype.setScrollTop=function(c){this.scrollTop=c,this.thumbTop=(c=c<0?0:c)*(this.slideHeight-this.thumbHeight)/(this.pageHeight-this.viewHeight),this.inner.style.top=this.thumbTop+"px"};var r,e=n;function n(c,d){var C=r.call(this,c,"-v")||this;return C.scrollTop=0,C.scrollHeight=0,C.parent=c,C.width=C.VScrollWidth,C.renderer=d,C.inner.style.width=C.element.style.width=(C.width||15)+"px",C.$minWidth=0,C}e.prototype.setInnerHeight=e.prototype.setScrollHeight,m(i,s=l),i.prototype.onMouseDown=function(c,d){var C,p,w,x,$;if(c==="mousedown"&&a.getButton(d)===0&&d.detail!==2)return d.target===this.inner?(C=this,p=d.clientX,w=d.clientX,x=this.thumbLeft,a.capture(this.inner,function(P){p=P.clientX},function(){clearInterval($)}),$=setInterval(function(){var P;p!==void 0&&(P=C.scrollLeftFromThumbLeft(x+p-w))!==C.scrollLeft&&C._emit("scroll",{data:P})},20)):(c=d.clientX-this.element.getBoundingClientRect().left-this.thumbWidth/2,this._emit("scroll",{data:this.scrollLeftFromThumbLeft(c)})),a.preventDefault(d)},i.prototype.getHeight=function(){return this.isVisible?this.height:0},i.prototype.scrollLeftFromThumbLeft=function(c){return c=c*(this.pageWidth-this.viewWidth)/(this.slideWidth-this.thumbWidth),(c>>=0)<0?c=0:c>this.pageWidth-this.viewWidth&&(c=this.pageWidth-this.viewWidth),c},i.prototype.setWidth=function(c){this.width=Math.max(0,c),this.element.style.width=this.width+"px",this.slideWidth=this.width,this.viewWidth=this.width,this.setScrollWidth(this.pageWidth,!0)},i.prototype.setScrollWidth=function(c,d){(this.pageWidth!==c||d)&&(this.pageWidth=c,this.thumbWidth=this.slideWidth*this.viewWidth/this.pageWidth,this.thumbWidth>this.slideWidth&&(this.thumbWidth=this.slideWidth),this.thumbWidth<15&&(this.thumbWidth=15),this.inner.style.width=this.thumbWidth+"px",this.scrollLeft>this.pageWidth-this.viewWidth)&&(this.scrollLeft=this.pageWidth-this.viewWidth,this.scrollLeft<0&&(this.scrollLeft=0),this._emit("scroll",{data:this.scrollLeft}))},i.prototype.setScrollLeft=function(c){this.scrollLeft=c,this.thumbLeft=(c=c<0?0:c)*(this.slideWidth-this.thumbWidth)/(this.pageWidth-this.viewWidth),this.inner.style.left=this.thumbLeft+"px"};var s,o=i;function i(c,d){return c=s.call(this,c,"-h")||this,c.scrollLeft=0,c.scrollWidth=0,c.height=c.HScrollHeight,c.inner.style.height=c.element.style.height=(c.height||12)+"px",c.renderer=d,c}o.prototype.setInnerWidth=o.prototype.setScrollWidth,f.ScrollBar=e,f.ScrollBarV=e,f.ScrollBarH=o,f.VScrollBar=e,f.HScrollBar=o}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(A,f,T){var I=A("./lib/event");function m(h,a){this.onRender=h,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=a||window;var l=this;this._flush=function(t){l.pending=!1;var r=l.changes;r&&(I.blockIdle(100),l.changes=0,l.onRender(r)),l.changes?l.$recursionLimit--<0||l.schedule():l.$recursionLimit=2}}m.prototype.schedule=function(h){this.changes=this.changes|h,this.changes&&!this.pending&&(I.nextFrame(this._flush),this.pending=!0)},m.prototype.clear=function(h){var a=this.changes;return this.changes=0,a},f.RenderLoop=m}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],function(t,f,T){var I=t("../lib/oop"),m=t("../lib/dom"),h=t("../lib/lang"),a=t("../lib/event"),l=t("../lib/useragent"),t=t("../lib/event_emitter").EventEmitter,r=typeof ResizeObserver=="function",e=(n.prototype.$setMeasureNodeStyles=function(s,o){s.width=s.height="auto",s.left=s.top="0px",s.visibility="hidden",s.position="absolute",s.whiteSpace="pre",l.isIE<8?s["font-family"]="inherit":s.font="inherit",s.overflow=o?"hidden":"visible"},n.prototype.checkForSizeChanges=function(s){var o;!(s=s===void 0?this.$measureSizes():s)||this.$characterSize.width===s.width&&this.$characterSize.height===s.height||(this.$measureNode.style.fontWeight="bold",o=this.$measureSizes(),this.$measureNode.style.fontWeight="",this.$characterSize=s,this.charSizes=Object.create(null),this.allowBoldFonts=o&&o.width===s.width&&o.height===s.height,this._emit("changeCharacterSize",{data:s}))},n.prototype.$addObserver=function(){var s=this;this.$observer=new window.ResizeObserver(function(o){s.checkForSizeChanges()}),this.$observer.observe(this.$measureNode)},n.prototype.$pollSizeChanges=function(){var s;return this.$pollSizeChangesTimer||this.$observer?this.$pollSizeChangesTimer:(s=this).$pollSizeChangesTimer=a.onIdle(function o(){s.checkForSizeChanges(),a.onIdle(o,500)},500)},n.prototype.setPolling=function(s){s?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},n.prototype.$measureSizes=function(s){return s={height:(s||this.$measureNode).clientHeight,width:(s||this.$measureNode).clientWidth/512},s.width===0||s.height===0?null:s},n.prototype.$measureCharWidth=function(s){return this.$main.textContent=h.stringRepeat(s,512),this.$main.getBoundingClientRect().width/512},n.prototype.getCharacterWidth=function(s){var o=this.charSizes[s];return o=o===void 0?this.charSizes[s]=this.$measureCharWidth(s)/this.$characterSize.width:o},n.prototype.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},n.prototype.$getZoom=function(s){return s&&s.parentElement?(window.getComputedStyle(s).zoom||1)*this.$getZoom(s.parentElement):1},n.prototype.$initTransformMeasureNodes=function(){function s(o,i){return["div",{style:"position: absolute;top:"+o+"px;left:"+i+"px;"}]}this.els=m.buildDom([s(0,0),s(200,0),s(0,200),s(200,200)],this.el)},n.prototype.transformCoordinates=function(s,o){function i(Z,u,v){var N=Z[1]*u[0]-Z[0]*u[1];return[(-u[1]*v[0]+u[0]*v[1])/N,(+Z[1]*v[0]-Z[0]*v[1])/N]}function c(Z,u){return[Z[0]-u[0],Z[1]-u[1]]}function d(Z,u){return[Z[0]+u[0],Z[1]+u[1]]}function C(Z,u){return[Z*u[0],Z*u[1]]}function p(Z){return Z=Z.getBoundingClientRect(),[Z.left,Z.top]}s=s&&C(1/this.$getZoom(this.el),s),this.els||this.$initTransformMeasureNodes();var w,x=p(this.els[0]),P=p(this.els[1]),B=p(this.els[2]),$=p(this.els[3]),$=i(c($,P),c($,B),c(d(P,B),d($,x))),P=C(1+$[0],c(P,x)),B=C(1+$[1],c(B,x));return o?(w=$[0]*o[0]/200+$[1]*o[1]/200+1,o=d(C(o[0],P),C(o[1],B)),d(C(1/w/200,o),x)):(w=c(s,x),o=i(c(P,C($[0],w)),c(B,C($[1],w)),w),C(200,o))},n);function n(s){this.el=m.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=m.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=m.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),s.appendChild(this.el),this.$measureNode.textContent=h.stringRepeat("X",512),this.$characterSize={width:0,height:0},r?this.$addObserver():this.checkForSizeChanges()}e.prototype.$characterSize={width:0,height:0},I.implement(e.prototype,t),f.FontMetrics=e}),ace.define("ace/css/editor.css",["require","exports","module"],function(A,f,T){T.exports=`
.ace_br1 {border-top-left-radius    : 3px;}
.ace_br2 {border-top-right-radius   : 3px;}
.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}
.ace_br4 {border-bottom-right-radius: 3px;}
.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}
.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}
.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}
.ace_br8 {border-bottom-left-radius : 3px;}
.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}
.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}
.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}
.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}


.ace_editor {
    position: relative;
    overflow: hidden;
    padding: 0;
    font: 12px/normal 'Monaco', 'Menlo', 'Ubuntu Mono', 'Consolas', 'Source Code Pro', 'source-code-pro', monospace;
    direction: ltr;
    text-align: left;
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
}

.ace_scroller {
    position: absolute;
    overflow: hidden;
    top: 0;
    bottom: 0;
    background-color: inherit;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    cursor: text;
}

.ace_content {
    position: absolute;
    box-sizing: border-box;
    min-width: 100%;
    contain: style size layout;
    font-variant-ligatures: no-common-ligatures;
}

.ace_keyboard-focus:focus {
    box-shadow: inset 0 0 0 2px #5E9ED6;
    outline: none;
}

.ace_dragging .ace_scroller:before{
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    content: '';
    background: rgba(250, 250, 250, 0.01);
    z-index: 1000;
}
.ace_dragging.ace_dark .ace_scroller:before{
    background: rgba(0, 0, 0, 0.01);
}

.ace_gutter {
    position: absolute;
    overflow : hidden;
    width: auto;
    top: 0;
    bottom: 0;
    left: 0;
    cursor: default;
    z-index: 4;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    contain: style size layout;
}

.ace_gutter-active-line {
    position: absolute;
    left: 0;
    right: 0;
}

.ace_scroller.ace_scroll-left:after {
    content: "";
    position: absolute;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;
    pointer-events: none;
}

.ace_gutter-cell, .ace_gutter-cell_svg-icons {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    padding-left: 19px;
    padding-right: 6px;
    background-repeat: no-repeat;
}

.ace_gutter-cell_svg-icons .ace_gutter_annotation {
    margin-left: -14px;
    float: left;
}

.ace_gutter-cell .ace_gutter_annotation {
    margin-left: -19px;
    float: left;
}

.ace_gutter-cell.ace_error, .ace_icon.ace_error, .ace_icon.ace_error_fold {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: 2px center;
}

.ace_gutter-cell.ace_warning, .ace_icon.ace_warning, .ace_icon.ace_warning_fold {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: 2px center;
}

.ace_gutter-cell.ace_info, .ace_icon.ace_info {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");
    background-repeat: no-repeat;
    background-position: 2px center;
}
.ace_dark .ace_gutter-cell.ace_info, .ace_dark .ace_icon.ace_info {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");
}

.ace_icon_svg.ace_error {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJyZWQiIHNoYXBlLXJlbmRlcmluZz0iZ2VvbWV0cmljUHJlY2lzaW9uIj4KPGNpcmNsZSBmaWxsPSJub25lIiBjeD0iOCIgY3k9IjgiIHI9IjciIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGxpbmUgeDE9IjExIiB5MT0iNSIgeDI9IjUiIHkyPSIxMSIvPgo8bGluZSB4MT0iMTEiIHkxPSIxMSIgeDI9IjUiIHkyPSI1Ii8+CjwvZz4KPC9zdmc+");
    background-color: crimson;
}
.ace_icon_svg.ace_warning {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJkYXJrb3JhbmdlIiBzaGFwZS1yZW5kZXJpbmc9Imdlb21ldHJpY1ByZWNpc2lvbiI+Cjxwb2x5Z29uIHN0cm9rZS1saW5lam9pbj0icm91bmQiIGZpbGw9Im5vbmUiIHBvaW50cz0iOCAxIDE1IDE1IDEgMTUgOCAxIi8+CjxyZWN0IHg9IjgiIHk9IjEyIiB3aWR0aD0iMC4wMSIgaGVpZ2h0PSIwLjAxIi8+CjxsaW5lIHgxPSI4IiB5MT0iNiIgeDI9IjgiIHkyPSIxMCIvPgo8L2c+Cjwvc3ZnPg==");
    background-color: darkorange;
}
.ace_icon_svg.ace_info {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJibHVlIiBzaGFwZS1yZW5kZXJpbmc9Imdlb21ldHJpY1ByZWNpc2lvbiI+CjxjaXJjbGUgZmlsbD0ibm9uZSIgY3g9IjgiIGN5PSI4IiByPSI3IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjxwb2x5bGluZSBwb2ludHM9IjggMTEgOCA4Ii8+Cjxwb2x5bGluZSBwb2ludHM9IjkgOCA2IDgiLz4KPGxpbmUgeDE9IjEwIiB5MT0iMTEiIHgyPSI2IiB5Mj0iMTEiLz4KPHJlY3QgeD0iOCIgeT0iNSIgd2lkdGg9IjAuMDEiIGhlaWdodD0iMC4wMSIvPgo8L2c+Cjwvc3ZnPg==");
    background-color: royalblue;
}

.ace_icon_svg.ace_error_fold {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiIgZmlsbD0ibm9uZSI+CiAgPHBhdGggZD0ibSAxOC45Mjk4NTEsNy44Mjk4MDc2IGMgMC4xNDYzNTMsNi4zMzc0NjA0IC02LjMyMzE0Nyw3Ljc3Nzg0NDQgLTcuNDc3OTEyLDcuNzc3ODQ0NCAtMi4xMDcyNzI2LC0wLjEyODc1IDUuMTE3Njc4LDAuMzU2MjQ5IDUuMDUxNjk4LC03Ljg3MDA2MTggLTAuNjA0NjcyLC04LjAwMzk3MzQ5IC03LjA3NzI3MDYsLTcuNTYzMTE4OSAtNC44NTczLC03LjQzMDM5NTU2IDEuNjA2LC0wLjExNTE0MjI1IDYuODk3NDg1LDEuMjYyNTQ1OTYgNy4yODM1MTQsNy41MjI2MTI5NiB6IiBmaWxsPSJjcmltc29uIiBzdHJva2Utd2lkdGg9IjIiLz4KICA8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0ibSA4LjExNDc1NjIsMi4wNTI5ODI4IGMgMy4zNDkxNjk4LDAgNi4wNjQxMzI4LDIuNjc2ODYyNyA2LjA2NDEzMjgsNS45Nzg5NTMgMCwzLjMwMjExMjIgLTIuNzE0OTYzLDUuOTc4OTIwMiAtNi4wNjQxMzI4LDUuOTc4OTIwMiAtMy4zNDkxNDczLDAgLTYuMDY0MTc3MiwtMi42NzY4MDggLTYuMDY0MTc3MiwtNS45Nzg5MjAyIDAuMDA1MzksLTMuMjk5ODg2MSAyLjcxNzI2NTYsLTUuOTczNjQwOCA2LjA2NDE3NzIsLTUuOTc4OTUzIHogbSAwLC0xLjczNTgyNzE5IGMgLTQuMzIxNDgzNiwwIC03LjgyNDc0MDM4LDMuNDU0MDE4NDkgLTcuODI0NzQwMzgsNy43MTQ3ODAxOSAwLDQuMjYwNzI4MiAzLjUwMzI1Njc4LDcuNzE0NzQ1MiA3LjgyNDc0MDM4LDcuNzE0NzQ1MiA0LjMyMTQ0OTgsMCA3LjgyNDY5OTgsLTMuNDU0MDE3IDcuODI0Njk5OCwtNy43MTQ3NDUyIDAsLTIuMDQ2MDkxNCAtMC44MjQzOTIsLTQuMDA4MzY3MiAtMi4yOTE3NTYsLTUuNDU1MTc0NiBDIDEyLjE4MDIyNSwxLjEyOTk2NDggMTAuMTkwMDEzLDAuMzE3MTU1NjEgOC4xMTQ3NTYyLDAuMzE3MTU1NjEgWiBNIDYuOTM3NDU2Myw4LjI0MDU5ODUgNC42NzE4Njg1LDEwLjQ4NTg1MiA2LjAwODY4MTQsMTEuODc2NzI4IDguMzE3MDAzNSw5LjYwMDc5MTEgMTAuNjI1MzM3LDExLjg3NjcyOCAxMS45NjIxMzgsMTAuNDg1ODUyIDkuNjk2NTUwOCw4LjI0MDU5ODUgMTEuOTYyMTM4LDYuMDA2ODA2NiAxMC41NzMyNDYsNC42Mzc0MzM1IDguMzE3MDAzNSw2Ljg3MzQyOTcgNi4wNjA3NjA3LDQuNjM3NDMzNSA0LjY3MTg2ODUsNi4wMDY4MDY2IFoiIGZpbGw9ImNyaW1zb24iIHN0cm9rZS13aWR0aD0iMiIvPgo8L3N2Zz4=");
    background-color: crimson;
}
.ace_icon_svg.ace_warning_fold {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAyMCAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNC43NzY5IDE0LjczMzdMOC42NTE5MiAyLjQ4MzY5QzguMzI5NDYgMS44Mzg3NyA3LjQwOTEzIDEuODM4NzcgNy4wODY2NyAyLjQ4MzY5TDAuOTYxNjY5IDE0LjczMzdDMC42NzA3NzUgMTUuMzE1NSAxLjA5MzgzIDE2IDEuNzQ0MjkgMTZIMTMuOTk0M0MxNC42NDQ4IDE2IDE1LjA2NzggMTUuMzE1NSAxNC43NzY5IDE0LjczMzdaTTMuMTYwMDcgMTQuMjVMNy44NjkyOSA0LjgzMTU2TDEyLjU3ODUgMTQuMjVIMy4xNjAwN1pNOC43NDQyOSAxMS42MjVWMTMuMzc1SDYuOTk0MjlWMTEuNjI1SDguNzQ0MjlaTTYuOTk0MjkgMTAuNzVWNy4yNUg4Ljc0NDI5VjEwLjc1SDYuOTk0MjlaIiBmaWxsPSIjRUM3MjExIi8+CjxwYXRoIGQ9Ik0xMS4xOTkxIDIuOTUyMzhDMTAuODgwOSAyLjMxNDY3IDEwLjM1MzcgMS44MDUyNiA5LjcwNTUgMS41MDlMMTEuMDQxIDEuMDY5NzhDMTEuNjg4MyAwLjk0OTgxNCAxMi4zMzcgMS4yNzI2MyAxMi42MzE3IDEuODYxNDFMMTcuNjEzNiAxMS44MTYxQzE4LjM1MjcgMTMuMjkyOSAxNy41OTM4IDE1LjA4MDQgMTYuMDE4IDE1LjU3NDVDMTYuNDA0NCAxNC40NTA3IDE2LjMyMzEgMTMuMjE4OCAxNS43OTI0IDEyLjE1NTVMMTEuMTk5MSAyLjk1MjM4WiIgZmlsbD0iI0VDNzIxMSIvPgo8L3N2Zz4=");
    background-color: darkorange;
}

.ace_scrollbar {
    contain: strict;
    position: absolute;
    right: 0;
    bottom: 0;
    z-index: 6;
}

.ace_scrollbar-inner {
    position: absolute;
    cursor: text;
    left: 0;
    top: 0;
}

.ace_scrollbar-v{
    overflow-x: hidden;
    overflow-y: scroll;
    top: 0;
}

.ace_scrollbar-h {
    overflow-x: scroll;
    overflow-y: hidden;
    left: 0;
}

.ace_print-margin {
    position: absolute;
    height: 100%;
}

.ace_text-input {
    position: absolute;
    z-index: 0;
    width: 0.5em;
    height: 1em;
    opacity: 0;
    background: transparent;
    -moz-appearance: none;
    appearance: none;
    border: none;
    resize: none;
    outline: none;
    overflow: hidden;
    font: inherit;
    padding: 0 1px;
    margin: 0 -1px;
    contain: strict;
    -ms-user-select: text;
    -moz-user-select: text;
    -webkit-user-select: text;
    user-select: text;
    /*with \`pre-line\` chrome inserts &nbsp; instead of space*/
    white-space: pre!important;
}
.ace_text-input.ace_composition {
    background: transparent;
    color: inherit;
    z-index: 1000;
    opacity: 1;
}
.ace_composition_placeholder { color: transparent }
.ace_composition_marker { 
    border-bottom: 1px solid;
    position: absolute;
    border-radius: 0;
    margin-top: 1px;
}

[ace_nocontext=true] {
    transform: none!important;
    filter: none!important;
    clip-path: none!important;
    mask : none!important;
    contain: none!important;
    perspective: none!important;
    mix-blend-mode: initial!important;
    z-index: auto;
}

.ace_layer {
    z-index: 1;
    position: absolute;
    overflow: hidden;
    /* workaround for chrome bug https://github.com/ajaxorg/ace/issues/2312*/
    word-wrap: normal;
    white-space: pre;
    height: 100%;
    width: 100%;
    box-sizing: border-box;
    /* setting pointer-events: auto; on node under the mouse, which changes
        during scroll, will break mouse wheel scrolling in Safari */
    pointer-events: none;
}

.ace_gutter-layer {
    position: relative;
    width: auto;
    text-align: right;
    pointer-events: auto;
    height: 1000000px;
    contain: style size layout;
}

.ace_text-layer {
    font: inherit !important;
    position: absolute;
    height: 1000000px;
    width: 1000000px;
    contain: style size layout;
}

.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {
    contain: style size layout;
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
}

.ace_hidpi .ace_text-layer,
.ace_hidpi .ace_gutter-layer,
.ace_hidpi .ace_content,
.ace_hidpi .ace_gutter {
    contain: strict;
}
.ace_hidpi .ace_text-layer > .ace_line, 
.ace_hidpi .ace_text-layer > .ace_line_group {
    contain: strict;
}

.ace_cjk {
    display: inline-block;
    text-align: center;
}

.ace_cursor-layer {
    z-index: 4;
}

.ace_cursor {
    z-index: 4;
    position: absolute;
    box-sizing: border-box;
    border-left: 2px solid;
    /* workaround for smooth cursor repaintng whole screen in chrome */
    transform: translatez(0);
}

.ace_multiselect .ace_cursor {
    border-left-width: 1px;
}

.ace_slim-cursors .ace_cursor {
    border-left-width: 1px;
}

.ace_overwrite-cursors .ace_cursor {
    border-left-width: 0;
    border-bottom: 1px solid;
}

.ace_hidden-cursors .ace_cursor {
    opacity: 0.2;
}

.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {
    opacity: 0;
}

.ace_smooth-blinking .ace_cursor {
    transition: opacity 0.18s;
}

.ace_animate-blinking .ace_cursor {
    animation-duration: 1000ms;
    animation-timing-function: step-end;
    animation-name: blink-ace-animate;
    animation-iteration-count: infinite;
}

.ace_animate-blinking.ace_smooth-blinking .ace_cursor {
    animation-duration: 1000ms;
    animation-timing-function: ease-in-out;
    animation-name: blink-ace-animate-smooth;
}
    
@keyframes blink-ace-animate {
    from, to { opacity: 1; }
    60% { opacity: 0; }
}

@keyframes blink-ace-animate-smooth {
    from, to { opacity: 1; }
    45% { opacity: 1; }
    60% { opacity: 0; }
    85% { opacity: 0; }
}

.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {
    position: absolute;
    z-index: 3;
}

.ace_marker-layer .ace_selection {
    position: absolute;
    z-index: 5;
}

.ace_marker-layer .ace_bracket {
    position: absolute;
    z-index: 6;
}

.ace_marker-layer .ace_error_bracket {
    position: absolute;
    border-bottom: 1px solid #DE5555;
    border-radius: 0;
}

.ace_marker-layer .ace_active-line {
    position: absolute;
    z-index: 2;
}

.ace_marker-layer .ace_selected-word {
    position: absolute;
    z-index: 4;
    box-sizing: border-box;
}

.ace_line .ace_fold {
    box-sizing: border-box;

    display: inline-block;
    height: 11px;
    margin-top: -2px;
    vertical-align: middle;

    background-image:
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");
    background-repeat: no-repeat, repeat-x;
    background-position: center center, top left;
    color: transparent;

    border: 1px solid black;
    border-radius: 2px;

    cursor: pointer;
    pointer-events: auto;
}

.ace_dark .ace_fold {
}

.ace_fold:hover{
    background-image:
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");
}

.ace_tooltip {
    background-color: #f5f5f5;
    border: 1px solid gray;
    border-radius: 1px;
    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
    color: black;
    max-width: 100%;
    padding: 3px 4px;
    position: fixed;
    z-index: 999999;
    box-sizing: border-box;
    cursor: default;
    white-space: pre;
    word-wrap: break-word;
    line-height: normal;
    font-style: normal;
    font-weight: normal;
    letter-spacing: normal;
    pointer-events: none;
}

.ace_tooltip.ace_dark {
    background-color: #636363;
    color: #fff;
}

.ace_tooltip:focus {
    outline: 1px solid #5E9ED6;
}

.ace_icon {
    display: inline-block;
    width: 18px;
    vertical-align: top;
}

.ace_icon_svg {
    display: inline-block;
    width: 12px;
    vertical-align: top;
    -webkit-mask-repeat: no-repeat;
    -webkit-mask-size: 12px;
    -webkit-mask-position: center;
}

.ace_folding-enabled > .ace_gutter-cell, .ace_folding-enabled > .ace_gutter-cell_svg-icons {
    padding-right: 13px;
}

.ace_fold-widget {
    box-sizing: border-box;

    margin: 0 -12px 0 1px;
    display: none;
    width: 11px;
    vertical-align: top;

    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: center;

    border-radius: 3px;
    
    border: 1px solid transparent;
    cursor: pointer;
}

.ace_folding-enabled .ace_fold-widget {
    display: inline-block;   
}

.ace_fold-widget.ace_end {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");
}

.ace_fold-widget.ace_closed {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");
}

.ace_fold-widget:hover {
    border: 1px solid rgba(0, 0, 0, 0.3);
    background-color: rgba(255, 255, 255, 0.2);
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);
}

.ace_fold-widget:active {
    border: 1px solid rgba(0, 0, 0, 0.4);
    background-color: rgba(0, 0, 0, 0.05);
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);
}
/**
 * Dark version for fold widgets
 */
.ace_dark .ace_fold-widget {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");
}
.ace_dark .ace_fold-widget.ace_end {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");
}
.ace_dark .ace_fold-widget.ace_closed {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");
}
.ace_dark .ace_fold-widget:hover {
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);
    background-color: rgba(255, 255, 255, 0.1);
}
.ace_dark .ace_fold-widget:active {
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);
}

.ace_inline_button {
    border: 1px solid lightgray;
    display: inline-block;
    margin: -1px 8px;
    padding: 0 5px;
    pointer-events: auto;
    cursor: pointer;
}
.ace_inline_button:hover {
    border-color: gray;
    background: rgba(200,200,200,0.2);
    display: inline-block;
    pointer-events: auto;
}

.ace_fold-widget.ace_invalid {
    background-color: #FFB4B4;
    border-color: #DE5555;
}

.ace_fade-fold-widgets .ace_fold-widget {
    transition: opacity 0.4s ease 0.05s;
    opacity: 0;
}

.ace_fade-fold-widgets:hover .ace_fold-widget {
    transition: opacity 0.05s ease 0.05s;
    opacity:1;
}

.ace_underline {
    text-decoration: underline;
}

.ace_bold {
    font-weight: bold;
}

.ace_nobold .ace_bold {
    font-weight: normal;
}

.ace_italic {
    font-style: italic;
}


.ace_error-marker {
    background-color: rgba(255, 0, 0,0.2);
    position: absolute;
    z-index: 9;
}

.ace_highlight-marker {
    background-color: rgba(255, 255, 0,0.2);
    position: absolute;
    z-index: 8;
}

.ace_mobile-menu {
    position: absolute;
    line-height: 1.5;
    border-radius: 4px;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    background: white;
    box-shadow: 1px 3px 2px grey;
    border: 1px solid #dcdcdc;
    color: black;
}
.ace_dark > .ace_mobile-menu {
    background: #333;
    color: #ccc;
    box-shadow: 1px 3px 2px grey;
    border: 1px solid #444;

}
.ace_mobile-button {
    padding: 2px;
    cursor: pointer;
    overflow: hidden;
}
.ace_mobile-button:hover {
    background-color: #eee;
    opacity:1;
}
.ace_mobile-button:active {
    background-color: #ddd;
}

.ace_placeholder {
    font-family: arial;
    transform: scale(0.9);
    transform-origin: left;
    white-space: pre;
    opacity: 0.7;
    margin: 0 10px;
}

.ace_ghost_text {
    opacity: 0.5;
    font-style: italic;
    white-space: pre;
}`}),ace.define("ace/layer/decorators",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter"],function(h,f,T){var I=h("../lib/dom"),m=h("../lib/oop"),h=h("../lib/event_emitter").EventEmitter,a=(l.prototype.$updateDecorators=function(t){var r=this.renderer.theme.isDark===!0?this.colors.dark:this.colors.light,e=(t&&(this.maxHeight=t.maxHeight,this.lineHeight=t.lineHeight,this.canvasHeight=t.height,(t.lastRow+1)*this.lineHeight<this.canvasHeight?this.heightRatio=1:this.heightRatio=this.canvasHeight/this.maxHeight),this.canvas.getContext("2d")),n=this.renderer.session.$annotations;if(e.clearRect(0,0,this.canvas.width,this.canvas.height),n)for(var s={info:1,warning:2,error:3},o=(n.forEach(function(x){x.priority=s[x.type]||null}),n=n.sort(function(x,$){return x.priority<$.priority?-1:x.priority>$.priority?1:0}),this.renderer.session.$foldData),i=0;i<n.length;i++){var c,w=n[i].row,d=this.compensateFoldRows(w,o),C=Math.round((w-d)*this.lineHeight*this.heightRatio),p=Math.round((w-d)*this.lineHeight*this.heightRatio),w=Math.round(((w-d)*this.lineHeight+this.lineHeight)*this.heightRatio);w-p<this.minDecorationHeight&&((c=(p+w)/2|0)<this.halfMinDecorationHeight?c=this.halfMinDecorationHeight:c+this.halfMinDecorationHeight>this.canvasHeight&&(c=this.canvasHeight-this.halfMinDecorationHeight),p=Math.round(c-this.halfMinDecorationHeight),w=Math.round(c+this.halfMinDecorationHeight)),e.fillStyle=r[n[i].type]||null,e.fillRect(0,C,this.canvasWidth,w-p)}t=this.renderer.session.selection.getCursor(),t&&(d=this.compensateFoldRows(t.row,o),C=Math.round((t.row-d)*this.lineHeight*this.heightRatio),e.fillStyle="rgba(0, 0, 0, 0.5)",e.fillRect(0,C,this.canvasWidth,2))},l.prototype.compensateFoldRows=function(t,r){var e=0;if(r&&0<r.length)for(var n=0;n<r.length;n++)t>r[n].start.row&&t<r[n].end.row?e+=t-r[n].start.row:t>=r[n].end.row&&(e+=r[n].end.row-r[n].start.row);return e},l);function l(t,r){this.canvas=I.createElement("canvas"),this.renderer=r,this.pixelRatio=1,this.maxHeight=r.layerConfig.maxHeight,this.lineHeight=r.layerConfig.lineHeight,this.canvasHeight=t.parent.scrollHeight,this.heightRatio=this.canvasHeight/this.maxHeight,this.canvasWidth=t.width,this.minDecorationHeight=2*this.pixelRatio|0,this.halfMinDecorationHeight=this.minDecorationHeight/2|0,this.canvas.width=this.canvasWidth,this.canvas.height=this.canvasHeight,this.canvas.style.top="0px",this.canvas.style.right="0px",this.canvas.style.zIndex="7px",this.canvas.style.position="absolute",this.colors={},this.colors.dark={error:"rgba(255, 18, 18, 1)",warning:"rgba(18, 136, 18, 1)",info:"rgba(18, 18, 136, 1)"},this.colors.light={error:"rgb(255,51,51)",warning:"rgb(32,133,72)",info:"rgb(35,68,138)"},t.element.appendChild(this.canvas)}m.implement(a.prototype,h),f.Decorator=a}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/scrollbar_custom","ace/scrollbar_custom","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/css/editor.css","ace/layer/decorators","ace/lib/useragent"],function($,f,T){var I=$("./lib/oop"),m=$("./lib/dom"),h=$("./lib/lang"),a=$("./config"),l=$("./layer/gutter").Gutter,t=$("./layer/marker").Marker,r=$("./layer/text").Text,e=$("./layer/cursor").Cursor,n=$("./scrollbar").HScrollBar,s=$("./scrollbar").VScrollBar,o=$("./scrollbar_custom").HScrollBar,i=$("./scrollbar_custom").VScrollBar,c=$("./renderloop").RenderLoop,d=$("./layer/font_metrics").FontMetrics,C=$("./lib/event_emitter").EventEmitter,p=$("./css/editor.css"),w=$("./layer/decorators").Decorator,x=$("./lib/useragent"),$=(m.importCssString(p,"ace_editor.css",!1),P.prototype.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),m.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},P.prototype.setSession=function(B){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=B)&&this.scrollMargin.top&&B.getScrollTop()<=0&&B.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(B),this.$markerBack.setSession(B),this.$markerFront.setSession(B),this.$gutterLayer.setSession(B),this.$textLayer.setSession(B),B&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},P.prototype.updateLines=function(B,Z,u){if(Z===void 0&&(Z=1/0),this.$changedLines?(this.$changedLines.firstRow>B&&(this.$changedLines.firstRow=B),this.$changedLines.lastRow<Z&&(this.$changedLines.lastRow=Z)):this.$changedLines={firstRow:B,lastRow:Z},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!u)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},P.prototype.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},P.prototype.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},P.prototype.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},P.prototype.updateFull=function(B){B?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},P.prototype.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},P.prototype.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},P.prototype.onResize=function(B,Z,u,v){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=B?1:0;var N=this.container,N=(v=v||N.clientHeight||N.scrollHeight,u=u||N.clientWidth||N.scrollWidth,this.$updateCachedSize(B,Z,u,v));if(this.$resizeTimer&&this.$resizeTimer.cancel(),!this.$size.scrollerHeight||!u&&!v)return this.resizing=0;B&&(this.$gutterLayer.$padding=null),B?this.$renderChanges(N|this.$changes,!0):this.$loop.schedule(N|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.$customScrollbar&&this.$updateCustomScrollbar(!0)}},P.prototype.$updateCachedSize=function(B,Z,u,v){v-=this.$extraHeight||0;var N=0,y=this.$size,_={width:y.width,height:y.height,scrollerHeight:y.scrollerHeight,scrollerWidth:y.scrollerWidth};return v&&(B||y.height!=v)&&(y.height=v,N|=this.CHANGE_SIZE,y.scrollerHeight=y.height,this.$horizScroll&&(y.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.setHeight(y.scrollerHeight),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",N|=this.CHANGE_SCROLL),u&&(B||y.width!=u)&&(N|=this.CHANGE_SIZE,y.width=u,Z==null&&(Z=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=Z,m.setStyle(this.scrollBarH.element.style,"left",Z+"px"),m.setStyle(this.scroller.style,"left",Z+this.margin.left+"px"),y.scrollerWidth=Math.max(0,u-Z-this.scrollBarV.getWidth()-this.margin.h),m.setStyle(this.$gutter.style,"left",this.margin.left+"px"),Z=this.scrollBarV.getWidth()+"px",m.setStyle(this.scrollBarH.element.style,"right",Z),m.setStyle(this.scroller.style,"right",Z),m.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),this.scrollBarH.setWidth(y.scrollerWidth),this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||B)&&(N|=this.CHANGE_FULL),y.$dirty=!u||!v,N&&this._signal("resize",_),N},P.prototype.onGutterResize=function(B){B=this.$showGutter?B:0,B!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,B,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},P.prototype.adjustWrapLimit=function(){var B=this.$size.scrollerWidth-2*this.$padding,B=Math.floor(B/this.characterWidth);return this.session.adjustWrapLimit(B,this.$showPrintMargin&&this.$printMarginColumn)},P.prototype.setAnimatedScroll=function(B){this.setOption("animatedScroll",B)},P.prototype.getAnimatedScroll=function(){return this.$animatedScroll},P.prototype.setShowInvisibles=function(B){this.setOption("showInvisibles",B),this.session.$bidiHandler.setShowInvisibles(B)},P.prototype.getShowInvisibles=function(){return this.getOption("showInvisibles")},P.prototype.getDisplayIndentGuide=function(){return this.getOption("displayIndentGuides")},P.prototype.setDisplayIndentGuides=function(B){this.setOption("displayIndentGuides",B)},P.prototype.getHighlightIndentGuides=function(){return this.getOption("highlightIndentGuides")},P.prototype.setHighlightIndentGuides=function(B){this.setOption("highlightIndentGuides",B)},P.prototype.setShowPrintMargin=function(B){this.setOption("showPrintMargin",B)},P.prototype.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},P.prototype.setPrintMarginColumn=function(B){this.setOption("printMarginColumn",B)},P.prototype.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},P.prototype.getShowGutter=function(){return this.getOption("showGutter")},P.prototype.setShowGutter=function(B){return this.setOption("showGutter",B)},P.prototype.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},P.prototype.setFadeFoldWidgets=function(B){this.setOption("fadeFoldWidgets",B)},P.prototype.setHighlightGutterLine=function(B){this.setOption("highlightGutterLine",B)},P.prototype.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},P.prototype.$updatePrintMargin=function(){var B;(this.$showPrintMargin||this.$printMarginEl)&&(this.$printMarginEl||((B=m.createElement("div")).className="ace_layer ace_print-margin-layer",this.$printMarginEl=m.createElement("div"),this.$printMarginEl.className="ace_print-margin",B.appendChild(this.$printMarginEl),this.content.insertBefore(B,this.content.firstChild)),(B=this.$printMarginEl.style).left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",B.visibility=this.$showPrintMargin?"visible":"hidden",this.session)&&this.session.$wrap==-1&&this.adjustWrapLimit()},P.prototype.getContainerElement=function(){return this.container},P.prototype.getMouseEventTarget=function(){return this.scroller},P.prototype.getTextAreaContainer=function(){return this.container},P.prototype.$moveTextAreaToCursor=function(){var B,Z,u,v,N,y,_;this.$isMousePressed||(B=this.textarea.style,y=this.$composition,this.$keepTextAreaAtCursor||y?(u=this.$cursorLayer.$pixelPos)&&(y&&y.markerRange&&(u=this.$cursorLayer.getPixelPosition(y.markerRange.start,!0)),_=this.layerConfig,Z=u.top,u=u.left,Z-=_.offset,v=y&&y.useTextareaForIME||x.isMobile?this.lineHeight:1,Z<0||Z>_.height-v?m.translate(this.textarea,0,0):(_=1,N=this.$size.height-v,y?y.useTextareaForIME?(y=this.textarea.value,_=this.characterWidth*this.session.$getStringScreenWidth(y)[0]):Z+=this.lineHeight+2:Z+=this.lineHeight,(u-=this.scrollLeft)>this.$size.scrollerWidth-_&&(u=this.$size.scrollerWidth-_),u+=this.gutterWidth+this.margin.left,m.setStyle(B,"height",v+"px"),m.setStyle(B,"width",_+"px"),m.translate(this.textarea,Math.min(u,this.$size.scrollerWidth-_),Math.min(Z,N)))):m.translate(this.textarea,-100,0))},P.prototype.getFirstVisibleRow=function(){return this.layerConfig.firstRow},P.prototype.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(this.layerConfig.offset===0?0:1)},P.prototype.getLastFullyVisibleRow=function(){var B=this.layerConfig,Z=B.lastRow;return this.session.documentToScreenRow(Z,0)*B.lineHeight-this.session.getScrollTop()>B.height-B.lineHeight?Z-1:Z},P.prototype.getLastVisibleRow=function(){return this.layerConfig.lastRow},P.prototype.setPadding=function(B){this.$padding=B,this.$textLayer.setPadding(B),this.$cursorLayer.setPadding(B),this.$markerFront.setPadding(B),this.$markerBack.setPadding(B),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},P.prototype.setScrollMargin=function(B,Z,u,v){var N=this.scrollMargin;N.top=0|B,N.bottom=0|Z,N.right=0|v,N.left=0|u,N.v=N.top+N.bottom,N.h=N.left+N.right,N.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-N.top),this.updateFull()},P.prototype.setMargin=function(B,Z,u,v){var N=this.margin;N.top=0|B,N.bottom=0|Z,N.right=0|v,N.left=0|u,N.v=N.top+N.bottom,N.h=N.left+N.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},P.prototype.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},P.prototype.setHScrollBarAlwaysVisible=function(B){this.setOption("hScrollBarAlwaysVisible",B)},P.prototype.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},P.prototype.setVScrollBarAlwaysVisible=function(B){this.setOption("vScrollBarAlwaysVisible",B)},P.prototype.$updateScrollBarV=function(){var B=this.layerConfig.maxHeight,Z=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(B-=(Z-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>B-Z)&&(B=this.scrollTop+Z,this.scrollBarV.scrollTop=null),this.scrollBarV.setScrollHeight(B+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},P.prototype.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},P.prototype.freeze=function(){this.$frozen=!0},P.prototype.unfreeze=function(){this.$frozen=!1},P.prototype.$renderChanges=function(B,Z){if(this.$changes&&(B|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(B||Z)){if(this.$size.$dirty)return this.$changes|=B,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender",B),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var u,v,Z=this.layerConfig;(B&this.CHANGE_FULL||B&this.CHANGE_SIZE||B&this.CHANGE_TEXT||B&this.CHANGE_LINES||B&this.CHANGE_SCROLL||B&this.CHANGE_H_SCROLL)&&(B|=this.$computeLayerConfig()|this.$loop.clear(),Z.firstRow!=this.layerConfig.firstRow&&Z.firstRowScreen==this.layerConfig.firstRowScreen&&0<(u=this.scrollTop+(Z.firstRow-Math.max(this.layerConfig.firstRow,0))*this.lineHeight)&&(this.scrollTop=u,B=(B|=this.CHANGE_SCROLL)|(this.$computeLayerConfig()|this.$loop.clear())),Z=this.layerConfig,this.$updateScrollBarV(),B&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),m.translate(this.content,-this.scrollLeft,-Z.offset),u=Z.width+2*this.$padding+"px",v=Z.minHeight+"px",m.setStyle(this.content.style,"width",u),m.setStyle(this.content.style,"height",v)),B&this.CHANGE_H_SCROLL&&(m.translate(this.content,-this.scrollLeft,-Z.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller ":"ace_scroller ace_scroll-left ",this.enableKeyboardAccessibility)&&(this.scroller.className+=this.keyboardFocusClassName),B&this.CHANGE_FULL?(this.$changedLines=null,this.$textLayer.update(Z),this.$showGutter&&this.$gutterLayer.update(Z),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(Z),this.$markerBack.update(Z),this.$markerFront.update(Z),this.$cursorLayer.update(Z),this.$moveTextAreaToCursor()):B&this.CHANGE_SCROLL?(this.$changedLines=null,B&this.CHANGE_TEXT||B&this.CHANGE_LINES?this.$textLayer.update(Z):this.$textLayer.scrollLines(Z),this.$showGutter&&(B&this.CHANGE_GUTTER||B&this.CHANGE_LINES?this.$gutterLayer.update(Z):this.$gutterLayer.scrollLines(Z)),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(Z),this.$markerBack.update(Z),this.$markerFront.update(Z),this.$cursorLayer.update(Z),this.$moveTextAreaToCursor()):(B&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(Z),this.$showGutter&&this.$gutterLayer.update(Z),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(Z)):B&this.CHANGE_LINES?((this.$updateLines()||B&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(Z),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(Z)):B&this.CHANGE_TEXT||B&this.CHANGE_GUTTER?(this.$showGutter&&this.$gutterLayer.update(Z),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(Z)):B&this.CHANGE_CURSOR&&(this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(Z),this.$customScrollbar)&&this.$scrollDecorator.$updateDecorators(Z),B&this.CHANGE_CURSOR&&(this.$cursorLayer.update(Z),this.$moveTextAreaToCursor()),B&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(Z),B&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(Z)),this._signal("afterRender",B)}else this.$changes|=B},P.prototype.$autosize=function(){var B=this.session.getScreenLength()*this.lineHeight,Z=this.$maxLines*this.lineHeight,u=Math.min(Z,Math.max((this.$minLines||1)*this.lineHeight,B))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(u+=this.scrollBarH.getHeight()),Z=!((u=this.$maxPixelHeight&&u>this.$maxPixelHeight?this.$maxPixelHeight:u)<=2*this.lineHeight)&&Z<B,u==this.desiredHeight&&this.$size.height==this.desiredHeight&&Z==this.$vScroll||(Z!=this.$vScroll&&(this.$vScroll=Z,this.scrollBarV.setVisible(Z)),B=this.container.clientWidth,this.container.style.height=u+"px",this.$updateCachedSize(!0,this.$gutterWidth,B,u),this.desiredHeight=u,this._signal("autosize"))},P.prototype.$computeLayerConfig=function(){var B,te=this.session,Z=this.$size,Q=Z.height<=2*this.lineHeight,u=this.session.getScreenLength()*this.lineHeight,v=this.$getLongestLine(),F=!Q&&(this.$hScrollBarAlwaysVisible||Z.scrollerWidth-v-2*this.$padding<0),N=this.$horizScroll!==F,F=(N&&(this.$horizScroll=F,this.scrollBarH.setVisible(F)),this.$vScroll),y=(this.$maxLines&&1<this.lineHeight&&this.$autosize(),Z.scrollerHeight+this.lineHeight),_=!this.$maxLines&&this.$scrollPastEnd?(Z.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0,W=(u+=_,this.scrollMargin),Q=(this.session.setScrollTop(Math.max(-W.top,Math.min(this.scrollTop,u-Z.scrollerHeight+W.bottom))),this.session.setScrollLeft(Math.max(-W.left,Math.min(this.scrollLeft,v+2*this.$padding-Z.scrollerWidth+W.right))),!Q&&(this.$vScrollBarAlwaysVisible||Z.scrollerHeight-u+_<0||this.scrollTop>W.top)),_=F!==Q,W=(_&&(this.$vScroll=Q,this.scrollBarV.setVisible(Q)),this.scrollTop%this.lineHeight),F=Math.ceil(y/this.lineHeight)-1,F=(Q=Math.max(0,Math.round((this.scrollTop-W)/this.lineHeight)))+F,Y=this.lineHeight,Q=te.screenToDocumentRow(Q,0),z=te.getFoldLine(Q),te=(z&&(Q=z.start.row),z=te.documentToScreenRow(Q,0),B=te.getRowLength(Q)*Y,F=Math.min(te.screenToDocumentRow(F,0),te.getLength()-1),y=Z.scrollerHeight+te.getRowLength(F)*Y+B,W=this.scrollTop-z*Y,0);return this.layerConfig.width==v&&!N||(te=this.CHANGE_H_SCROLL),(N||_)&&(te|=this.$updateCachedSize(!0,this.gutterWidth,Z.width,Z.height),this._signal("scrollbarVisibilityChanged"),_)&&(v=this.$getLongestLine()),this.layerConfig={width:v,padding:this.$padding,firstRow:Q,firstRowScreen:z,lastRow:F,lineHeight:Y,characterWidth:this.characterWidth,minHeight:y,maxHeight:u,offset:W,gutterOffset:Y?Math.max(0,Math.ceil((W+Z.height-Z.scrollerHeight)/Y)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(v-this.$padding),te},P.prototype.$updateLines=function(){if(this.$changedLines){var B=this.$changedLines.firstRow,Z=this.$changedLines.lastRow,u=(this.$changedLines=null,this.layerConfig);if(!(B>u.lastRow+1||Z<u.firstRow)){if(Z!==1/0)return this.$textLayer.updateLines(u,B,Z),!0;this.$showGutter&&this.$gutterLayer.update(u),this.$textLayer.update(u)}}},P.prototype.$getLongestLine=function(){var B=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(B+=1),this.$textLayer&&B>this.$textLayer.MAX_LINE_LENGTH&&(B=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(B*this.characterWidth))},P.prototype.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},P.prototype.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},P.prototype.addGutterDecoration=function(B,Z){this.$gutterLayer.addGutterDecoration(B,Z)},P.prototype.removeGutterDecoration=function(B,Z){this.$gutterLayer.removeGutterDecoration(B,Z)},P.prototype.updateBreakpoints=function(B){this.$loop.schedule(this.CHANGE_GUTTER)},P.prototype.setAnnotations=function(B){this.$gutterLayer.setAnnotations(B),this.$loop.schedule(this.CHANGE_GUTTER)},P.prototype.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},P.prototype.hideCursor=function(){this.$cursorLayer.hideCursor()},P.prototype.showCursor=function(){this.$cursorLayer.showCursor()},P.prototype.scrollSelectionIntoView=function(B,Z,u){this.scrollCursorIntoView(B,u),this.scrollCursorIntoView(Z,u)},P.prototype.scrollCursorIntoView=function(B,Z,u){var v,N,y;this.$size.scrollerHeight!==0&&(v=(B=this.$cursorLayer.getPixelPosition(B)).left,B=B.top,N=u&&u.top||0,u=u&&u.bottom||0,this.$scrollAnimation&&(this.$stopAnimation=!0),B<(y=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop)+N?(Z&&y+N>B+this.lineHeight&&(B-=Z*this.$size.scrollerHeight),B===0&&(B=-this.scrollMargin.top),this.session.setScrollTop(B)):y+this.$size.scrollerHeight-u<B+this.lineHeight&&(Z&&y+this.$size.scrollerHeight-u<B-this.lineHeight&&(B+=Z*this.$size.scrollerHeight),this.session.setScrollTop(B+this.lineHeight+u-this.$size.scrollerHeight)),N=this.scrollLeft,v-(y=2*this.layerConfig.characterWidth)<N?((v-=y)<this.$padding+y&&(v=-this.scrollMargin.left),this.session.setScrollLeft(v)):N+this.$size.scrollerWidth<(v+=y)+this.characterWidth?this.session.setScrollLeft(Math.round(v+this.characterWidth-this.$size.scrollerWidth)):N<=this.$padding&&v-N<this.characterWidth&&this.session.setScrollLeft(0))},P.prototype.getScrollTop=function(){return this.session.getScrollTop()},P.prototype.getScrollLeft=function(){return this.session.getScrollLeft()},P.prototype.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},P.prototype.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},P.prototype.scrollToRow=function(B){this.session.setScrollTop(B*this.lineHeight)},P.prototype.alignCursor=function(v,Z){var v=this.$cursorLayer.getPixelPosition(v=typeof v=="number"?{row:v,column:0}:v),u=this.$size.scrollerHeight-this.lineHeight,v=v.top-u*(Z||0);return this.session.setScrollTop(v),v},P.prototype.$calcSteps=function(B,Z){for(var u,v,_=0,N=this.STEPS,y=[],_=0;_<N;++_)y.push((u=_/this.STEPS,(Z-(v=B))*(Math.pow(u-1,3)+1)+v));return y},P.prototype.scrollToLine=function(B,Z,u,v){B=this.$cursorLayer.getPixelPosition({row:B,column:0}).top,Z&&(B-=this.$size.scrollerHeight/2),Z=this.scrollTop,this.session.setScrollTop(B),u!==!1&&this.animateScrolling(Z,v)},P.prototype.animateScrolling=function(B,Z){var u=this.scrollTop;if(this.$animatedScroll){var v=this;if(B!=u){if(this.$scrollAnimation){var N=this.$scrollAnimation.steps;if(N.length&&(B=N[0])==u)return}var y=v.$calcSteps(B,u);this.$scrollAnimation={from:B,to:u,steps:y},clearInterval(this.$timer),v.session.setScrollTop(y.shift()),v.session.$scrollTop=u,this.$timer=setInterval(function(){if(!v.$stopAnimation)return v.session?void(y.length?(v.session.setScrollTop(y.shift()),v.session.$scrollTop=u):u!=null?(v.session.$scrollTop=-1,v.session.setScrollTop(u),u=null):_()):clearInterval(v.$timer);_()},10)}}function _(){v.$timer=clearInterval(v.$timer),v.$scrollAnimation=null,v.$stopAnimation=!1,Z&&Z()}},P.prototype.scrollToY=function(B){this.scrollTop!==B&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=B)},P.prototype.scrollToX=function(B){this.scrollLeft!==B&&(this.scrollLeft=B),this.$loop.schedule(this.CHANGE_H_SCROLL)},P.prototype.scrollTo=function(B,Z){this.session.setScrollTop(Z),this.session.setScrollLeft(B)},P.prototype.scrollBy=function(B,Z){Z&&this.session.setScrollTop(this.session.getScrollTop()+Z),B&&this.session.setScrollLeft(this.session.getScrollLeft()+B)},P.prototype.isScrollableBy=function(B,Z){return Z<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||0<Z&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||B<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||0<B&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0},P.prototype.pixelToScreenCoordinates=function(v,N){this.$hasCssTransforms?(y={top:0,left:0},v=(u=this.$fontMetrics.transformCoordinates([v,N]))[1]-this.gutterWidth-this.margin.left,N=u[0]):y=this.scroller.getBoundingClientRect();var u=v+this.scrollLeft-y.left-this.$padding,v=u/this.characterWidth,N=Math.floor((N+this.scrollTop-y.top)/this.lineHeight),y=this.$blockCursor?Math.floor(v):Math.round(v);return{row:N,column:y,side:0<v-y?1:-1,offsetX:u}},P.prototype.screenToTextCoordinates=function(N,y){this.$hasCssTransforms?(u={top:0,left:0},N=(v=this.$fontMetrics.transformCoordinates([N,y]))[1]-this.gutterWidth-this.margin.left,y=v[0]):u=this.scroller.getBoundingClientRect();var u,v=N+this.scrollLeft-u.left-this.$padding,N=v/this.characterWidth,N=this.$blockCursor?Math.floor(N):Math.round(N),y=Math.floor((y+this.scrollTop-u.top)/this.lineHeight);return this.session.screenToDocumentPosition(y,Math.max(N,0),v)},P.prototype.textToScreenCoordinates=function(v,N){var u=this.scroller.getBoundingClientRect(),N=this.session.documentToScreenPosition(v,N),v=this.$padding+(this.session.$bidiHandler.isBidiRow(N.row,v)?this.session.$bidiHandler.getPosLeft(N.column):Math.round(N.column*this.characterWidth)),N=N.row*this.lineHeight;return{pageX:u.left+v-this.scrollLeft,pageY:u.top+N-this.scrollTop}},P.prototype.visualizeFocus=function(){m.addCssClass(this.container,"ace_focus")},P.prototype.visualizeBlur=function(){m.removeCssClass(this.container,"ace_focus")},P.prototype.showComposition=function(B){(this.$composition=B).cssText||(B.cssText=this.textarea.style.cssText),B.useTextareaForIME==null&&(B.useTextareaForIME=this.$useTextareaForIME),this.$useTextareaForIME?(m.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):B.markerId=this.session.addMarker(B.markerRange,"ace_composition_marker","text")},P.prototype.setCompositionText=function(B){var Z=this.session.selection.cursor;this.addToken(B,"composition_placeholder",Z.row,Z.column),this.$moveTextAreaToCursor()},P.prototype.hideComposition=function(){var B;this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),m.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,B=this.session.selection.cursor,this.removeExtraToken(B.row,B.column),this.$composition=null,this.$cursorLayer.element.style.display="")},P.prototype.setGhostText=function(B,u){var v=this.session.selection.cursor,u=u||{row:v.row,column:v.column},v=(this.removeGhostText(),B.split(`
`));this.addToken(v[0],"ghost_text",u.row,u.column),this.$ghostText={text:B,position:{row:u.row,column:u.column}},1<v.length&&(this.$ghostTextWidget={text:v.slice(1).join(`
`),row:u.row,column:u.column,className:"ace_ghost_text"},this.session.widgetManager.addLineWidget(this.$ghostTextWidget))},P.prototype.removeGhostText=function(){var B;this.$ghostText&&(B=this.$ghostText.position,this.removeExtraToken(B.row,B.column),this.$ghostTextWidget&&(this.session.widgetManager.removeLineWidget(this.$ghostTextWidget),this.$ghostTextWidget=null),this.$ghostText=null)},P.prototype.addToken=function(B,Z,u,v){var N=this.session,y=(N.bgTokenizer.lines[u]=null,{type:Z,value:B}),_=N.getTokens(u);if(v!=null&&_.length)for(var W=0,F=0;F<_.length;F++){var Y=_[F];if(v<=(W+=Y.value.length)){var z=Y.value.length-(W-v),Q=Y.value.slice(0,z),z=Y.value.slice(z);_.splice(F,1,{type:Y.type,value:Q},y,{type:Y.type,value:z});break}}else _.push(y);this.updateLines(u,u)},P.prototype.removeExtraToken=function(B,Z){this.session.bgTokenizer.lines[B]=null,this.updateLines(B,B)},P.prototype.setTheme=function(B,Z){var u,v=this;function N(y){if(v.$themeId!=B)return Z&&Z();if(!y||!y.cssClass)throw new Error("couldn't load module "+B+" or it didn't call define");y.$id&&(v.$themeId=y.$id),m.importCssString(y.cssText,y.cssClass,v.container),v.theme&&m.removeCssClass(v.container,v.theme.cssClass);var _="padding"in y?y.padding:"padding"in(v.theme||{})?4:v.$padding;v.$padding&&_!=v.$padding&&v.setPadding(_),v.$theme=y.cssClass,v.theme=y,m.addCssClass(v.container,y.cssClass),m.setCssClass(v.container,"ace_dark",y.isDark),v.$size&&(v.$size.width=0,v.$updateSizeAsync()),v._dispatchEvent("themeLoaded",{theme:y}),Z&&Z()}this.$themeId=B,v._dispatchEvent("themeChange",{theme:B}),B&&typeof B!="string"?N(B):(u=B||this.$options.theme.initialValue,a.loadModule(["theme",u],N))},P.prototype.getTheme=function(){return this.$themeId},P.prototype.setStyle=function(B,Z){m.setCssClass(this.container,B,Z!==!1)},P.prototype.unsetStyle=function(B){m.removeCssClass(this.container,B)},P.prototype.setCursorStyle=function(B){m.setStyle(this.scroller.style,"cursor",B)},P.prototype.setMouseCursor=function(B){m.setStyle(this.scroller.style,"cursor",B)},P.prototype.attachToShadowRoot=function(){m.importCssString(p,"ace_editor.css",this.container)},P.prototype.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy(),this.removeAllListeners(),this.container.textContent="",this.setOption("useResizeObserver",!1)},P.prototype.$updateCustomScrollbar=function(B){var Z=this;this.$horizScroll=this.$vScroll=null,this.scrollBarV.element.remove(),this.scrollBarH.element.remove(),this.$scrollDecorator&&delete this.$scrollDecorator,B===!0?(this.scrollBarV=new i(this.container,this),this.scrollBarH=new o(this.container,this),this.scrollBarV.setHeight(this.$size.scrollerHeight),this.scrollBarH.setWidth(this.$size.scrollerWidth),this.scrollBarV.addEventListener("scroll",function(u){Z.$scrollAnimation||Z.session.setScrollTop(u.data-Z.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(u){Z.$scrollAnimation||Z.session.setScrollLeft(u.data-Z.scrollMargin.left)}),this.$scrollDecorator=new w(this.scrollBarV,this),this.$scrollDecorator.$updateDecorators()):(this.scrollBarV=new s(this.container,this),this.scrollBarH=new n(this.container,this),this.scrollBarV.addEventListener("scroll",function(u){Z.$scrollAnimation||Z.session.setScrollTop(u.data-Z.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(u){Z.$scrollAnimation||Z.session.setScrollLeft(u.data-Z.scrollMargin.left)}))},P.prototype.$addResizeObserver=function(){var B;window.ResizeObserver&&!this.$resizeObserver&&((B=this).$resizeTimer=h.delayedCall(function(){B.destroyed||B.onResize()},50),this.$resizeObserver=new window.ResizeObserver(function(v){var u=v[0].contentRect.width,v=v[0].contentRect.height;1<Math.abs(B.$size.width-u)||1<Math.abs(B.$size.height-v)?B.$resizeTimer.delay():B.$resizeTimer.cancel()}),this.$resizeObserver.observe(this.container))},P);function P(v,Z){var u=this,v=(this.container=v||m.createElement("div"),m.addCssClass(this.container,"ace_editor"),m.HI_DPI&&m.addCssClass(this.container,"ace_hidpi"),this.setTheme(Z),a.get("useStrictCSP")==null&&a.set("useStrictCSP",!1),this.$gutter=m.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=m.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=m.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new l(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new t(this.content),this.$textLayer=new r(this.content));this.canvas=v.element,this.$markerFront=new t(this.content),this.$cursorLayer=new e(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new s(this.container,this),this.scrollBarH=new n(this.container,this),this.scrollBarV.on("scroll",function(N){u.$scrollAnimation||u.session.setScrollTop(N.data-u.scrollMargin.top)}),this.scrollBarH.on("scroll",function(N){u.$scrollAnimation||u.session.setScrollLeft(N.data-u.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new d(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.on("changeCharacterSize",function(N){u.updateCharacterSize(),u.onResize(!0,u.gutterWidth,u.$size.width,u.$size.height),u._signal("changeCharacterSize",N)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!x.isIOS,this.$loop=new c(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),this.$addResizeObserver(),a.resetOptions(this),a._signal("renderer",this)}$.prototype.CHANGE_CURSOR=1,$.prototype.CHANGE_MARKER=2,$.prototype.CHANGE_GUTTER=4,$.prototype.CHANGE_SCROLL=8,$.prototype.CHANGE_LINES=16,$.prototype.CHANGE_TEXT=32,$.prototype.CHANGE_SIZE=64,$.prototype.CHANGE_MARKER_BACK=128,$.prototype.CHANGE_MARKER_FRONT=256,$.prototype.CHANGE_FULL=512,$.prototype.CHANGE_H_SCROLL=1024,$.prototype.$changes=0,$.prototype.$padding=null,$.prototype.$frozen=!1,$.prototype.STEPS=8,I.implement($.prototype,C),a.defineOptions($.prototype,"renderer",{useResizeObserver:{set:function(B){!B&&this.$resizeObserver?(this.$resizeObserver.disconnect(),this.$resizeTimer.cancel(),this.$resizeTimer=this.$resizeObserver=null):B&&!this.$resizeObserver&&this.$addResizeObserver()}},animatedScroll:{initialValue:!1},showInvisibles:{set:function(B){this.$textLayer.setShowInvisibles(B)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(B){typeof B=="number"&&(this.$printMarginColumn=B),this.$showPrintMargin=!!B,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(B){this.$gutter.style.display=B?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},useSvgGutterIcons:{set:function(B){this.$gutterLayer.$useSvgGutterIcons=B},initialValue:!1},showFoldedAnnotations:{set:function(B){this.$gutterLayer.$showFoldedAnnotations=B},initialValue:!1},fadeFoldWidgets:{set:function(B){m.setCssClass(this.$gutter,"ace_fade-fold-widgets",B)},initialValue:!1},showFoldWidgets:{set:function(B){this.$gutterLayer.setShowFoldWidgets(B),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(B){this.$textLayer.setDisplayIndentGuides(B)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightIndentGuides:{set:function(B){this.$textLayer.setHighlightIndentGuides(B)==1?this.$textLayer.$highlightIndentGuide():this.$textLayer.$clearActiveIndentGuide(this.$textLayer.$lines.cells)},initialValue:!0},highlightGutterLine:{set:function(B){this.$gutterLayer.setHighlightGutterLine(B),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(B){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(B){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(B){typeof B=="number"&&(B+="px"),this.container.style.fontSize=B,this.updateFontSize()},initialValue:12},fontFamily:{set:function(B){this.container.style.fontFamily=B,this.updateFontSize()}},maxLines:{set:function(B){this.updateFull()}},minLines:{set:function(B){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(B){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(B){this.$scrollPastEnd!=(B=+B||0)&&(this.$scrollPastEnd=B,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(B){this.$gutterLayer.$fixedWidth=!!B,this.$loop.schedule(this.CHANGE_GUTTER)}},customScrollbar:{set:function(B){this.$updateCustomScrollbar(B)},initialValue:!1},theme:{set:function(B){this.setTheme(B)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!x.isMobile&&!x.isIE}}),f.VirtualRenderer=$}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(A,f,T){var I=A("../lib/oop"),m=A("../lib/net"),h=A("../lib/event_emitter").EventEmitter,a=A("../config");function l(r){var e;return typeof Worker>"u"?{postMessage:function(){},terminate:function(){}}:a.get("loadWorkerFromBlob")?(e=function(n){n="importScripts('"+m.qualifyURL(n)+"');";try{return new Blob([n],{type:"application/javascript"})}catch{var s=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return s.append(n),s.getBlob("application/javascript")}}(r),e=(window.URL||window.webkitURL).createObjectURL(e),new Worker(e)):new Worker(r)}function t(r){r.postMessage||(r=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=r,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){I.implement(this,h),this.$createWorkerFromOldConfig=function(r,e,n,s,o){var i,c;return A.nameToUrl&&!A.toUrl&&(A.toUrl=A.nameToUrl),a.get("packaged")||!A.toUrl?s=s||a.moduleUrl(e,"worker"):(i=this.$normalizePath,s=s||i(A.toUrl("ace/worker/worker.js",null,"_")),c={},r.forEach(function(d){c[d]=i(A.toUrl(d,null,"_").replace(/(\.js)?(\?.*)?$/,""))})),this.$worker=l(s),o&&this.send("importScripts",o),this.$worker.postMessage({init:!0,tlns:c,module:e,classname:n}),this.$worker},this.onMessage=function(r){var e=r.data;switch(e.type){case"event":this._signal(e.name,{data:e.data});break;case"call":var n=this.callbacks[e.id];n&&(n(e.data),delete this.callbacks[e.id]);break;case"error":this.reportError(e.data);break;case"log":window.console&&console.log&&console.log.apply(console,e.data)}},this.reportError=function(r){window.console&&console.error&&console.error(r)},this.$normalizePath=function(r){return m.qualifyURL(r)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(r,e){this.$worker.postMessage({command:r,args:e})},this.call=function(r,e,n){var s;n&&(s=this.callbackId++,this.callbacks[s]=n,e.push(s)),this.send(r,e)},this.emit=function(r,e){try{e.data&&e.data.err&&(e.data.err={message:e.data.err.message,stack:e.data.err.stack,code:e.data.err.code}),this.$worker&&this.$worker.postMessage({event:r,data:{data:e.data}})}catch(n){console.error(n.stack)}},this.attachToDocument=function(r){this.$doc&&this.terminate(),this.$doc=r,this.call("setValue",[r.getValue()]),r.on("change",this.changeListener,!0)},this.changeListener=function(r){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),r.action=="insert"?this.deltaQueue.push(r.start,r.lines):this.deltaQueue.push(r.start,r.end)},this.$sendDeltaQueue=function(){var r=this.deltaQueue;r&&(this.deltaQueue=null,50<r.length&&r.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:r}))}}).call(t.prototype),f.UIWorkerClient=function(r,e,n){var s=null,o=!1,i=Object.create(h),c=[],d=new t({messageBuffer:c,terminate:function(){},postMessage:function(p){c.push(p),s&&(o?setTimeout(C):C())}}),C=(d.setEmitSync=function(p){o=p},function(){var p=c.shift();p.command?s[p.command].apply(s,p.args):p.event&&i._signal(p.event,p.data)});return i.postMessage=function(p){d.onMessage({data:p})},i.callback=function(p,w){this.postMessage({type:"call",id:w,data:p})},i.emit=function(p,w){this.postMessage({type:"event",name:p,data:w})},a.loadModule(["worker",e],function(p){for(s=new p[n](i);c.length;)C()}),d},f.WorkerClient=t,f.createWorker=l}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(h,f,T){var I=h("./range").Range,m=h("./lib/event_emitter").EventEmitter,h=h("./lib/oop"),a=(l.prototype.setup=function(){var t=this,r=this.doc,e=this.session,n=(this.selectionBefore=e.selection.toJSON(),e.selection.inMultiSelectMode&&e.selection.toSingleRange(),this.pos=r.createAnchor(this.$pos.row,this.$pos.column),this.pos);n.$insertRight=!0,n.detach(),n.markerId=e.addMarker(new I(n.row,n.column,n.row,n.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(s){s=r.createAnchor(s.row,s.column),s.$insertRight=!0,s.detach(),t.others.push(s)}),e.setUndoSelect(!1)},l.prototype.showOtherMarkers=function(){var t,r;this.othersActive||(t=this.session,(r=this).othersActive=!0,this.others.forEach(function(e){e.markerId=t.addMarker(new I(e.row,e.column,e.row,e.column+r.length),r.othersClass,null,!1)}))},l.prototype.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var t=0;t<this.others.length;t++)this.session.removeMarker(this.others[t].markerId)}},l.prototype.onUpdate=function(t){if(this.$updating)return this.updateAnchors(t);var r=t;if(r.start.row===r.end.row&&r.start.row===this.pos.row){this.$updating=!0;var e=t.action==="insert"?r.end.column-r.start.column:r.start.column-r.end.column,n=r.start.column>=this.pos.column&&r.start.column<=this.pos.column+this.length+1,s=r.start.column-this.pos.column;if(this.updateAnchors(t),n&&(this.length+=e),n&&!this.session.$fromUndo){if(t.action==="insert")for(var o=this.others.length-1;0<=o;o--){var i={row:(c=this.others[o]).row,column:c.column+s};this.doc.insertMergedLines(i,t.lines)}else if(t.action==="remove")for(o=this.others.length-1;0<=o;o--){var c,i={row:(c=this.others[o]).row,column:c.column+s};this.doc.remove(new I(i.row,i.column,i.row,i.column-e))}}this.$updating=!1,this.updateMarkers()}},l.prototype.updateAnchors=function(t){this.pos.onChange(t);for(var r=this.others.length;r--;)this.others[r].onChange(t);this.updateMarkers()},l.prototype.updateMarkers=function(){if(!this.$updating){var t=this,r=this.session,e=function(s,o){r.removeMarker(s.markerId),s.markerId=r.addMarker(new I(s.row,s.column,s.row,s.column+t.length),o,null,!1)};e(this.pos,this.mainClass);for(var n=this.others.length;n--;)e(this.others[n],this.othersClass)}},l.prototype.onCursorChange=function(t){var r;!this.$updating&&this.session&&((r=this.session.selection.getCursor()).row===this.pos.row&&r.column>=this.pos.column&&r.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",t)):(this.hideOtherMarkers(),this._emit("cursorLeave",t)))},l.prototype.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.off("change",this.$onUpdate),this.session.selection.off("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},l.prototype.cancel=function(){if(this.$undoStackDepth!==-1){for(var t=this.session.getUndoManager(),r=(t.$undoStack||t.$undostack).length-this.$undoStackDepth,e=0;e<r;e++)t.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}},l);function l(t,c,e,n,s,o){var i=this,c=(this.length=c,this.session=t,this.doc=t.getDocument(),this.mainClass=s,this.othersClass=o,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate,!0),this.$others=n,this.$onCursorChange=function(){setTimeout(function(){i.onCursorChange()})},this.$pos=e,t.getUndoManager().$undoStack||t.getUndoManager().$undostack||{length:-1});this.$undoStackDepth=c.length,this.setup(),t.selection.on("changeCursor",this.$onCursorChange)}h.implement(a.prototype,m),f.PlaceHolder=a}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(A,f,T){var I=A("../lib/event"),m=A("../lib/useragent");function h(a,l){return a.row==l.row&&a.column==l.column}f.onMouseDown=function(a){var l=a.domEvent,t=l.altKey,r=l.shiftKey,e=l.ctrlKey,n=a.getAccelKey(),s=a.getButton();if(e&&m.isMac&&(s=l.button),a.editor.inMultiSelectMode&&s==2)a.editor.textInput.onContextMenu(a.domEvent);else if(e||t||n){if(s===0){var o,i,c,d,C,p,w,x,$=a.editor,P=$.selection,B=$.inMultiSelectMode,Z=a.getDocumentPosition(),u=P.getCursor(),u=a.inSelection()||P.isEmpty()&&h(Z,u),v=a.x,N=a.y,y=$.session,_=$.renderer.pixelToScreenCoordinates(v,N),W=_;if($.$mouseHandler.$enableJumpToDef)e&&t||n&&t?o=r?"block":"add":t&&$.$blockSelectEnabled&&(o="block");else if(n&&!t){if(o="add",!B&&r)return}else t&&$.$blockSelectEnabled&&(o="block");if(o&&m.isMac&&l.ctrlKey&&$.$mouseHandler.cancelContextMenu(),o=="add")!B&&u||(B||(i=P.toOrientedRange(),$.addSelectionMarker(i)),c=P.rangeList.rangeAtPoint(Z),$.inVirtualSelectionMode=!0,r&&(c=null,i=P.ranges[0]||i,$.removeSelectionMarker(i)),$.once("mouseup",function(){var F=P.toOrientedRange();c&&F.isEmpty()&&h(c.cursor,F.cursor)?P.substractPoint(F.cursor):(r?P.substractPoint(i.cursor):i&&($.removeSelectionMarker(i),P.addRange(i)),P.addRange(F)),$.inVirtualSelectionMode=!1}));else if(o=="block")return a.stop(),$.inVirtualSelectionMode=!0,C=[],p=function(){var F=$.renderer.pixelToScreenCoordinates(v,N),Y=y.screenToDocumentPosition(F.row,F.column,F.offsetX);h(W,F)&&h(Y,P.lead)||(W=F,$.selection.moveToPosition(Y),$.renderer.scrollCursorIntoView(),$.removeSelectionMarkers(C),C=P.rectangularRangeBlock(W,_),$.$mouseHandler.$clickSelection&&C.length==1&&C[0].isEmpty()&&(C[0]=$.$mouseHandler.$clickSelection.clone()),C.forEach($.addSelectionMarker,$),$.updateSelectionMarkers())},B&&!n?P.toSingleRange():!B&&n&&(d=P.toOrientedRange(),$.addSelectionMarker(d)),r?_=y.documentToScreenPosition(P.lead):P.moveToPosition(Z),W={row:-1,column:-1},w=p,I.capture($.container,function(F){v=F.clientX,N=F.clientY},function(F){p(),clearInterval(x),$.removeSelectionMarkers(C),C.length||(C=[P.toOrientedRange()]),d&&($.removeSelectionMarker(d),P.toSingleRange(d));for(var Y=0;Y<C.length;Y++)P.addRange(C[Y]);$.inVirtualSelectionMode=!1,$.$mouseHandler.$clickSelection=null}),x=setInterval(function(){w()},20),a.preventDefault()}}else s===0&&a.editor.inMultiSelectMode&&a.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(A,f,T){f.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(I){I.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(I){I.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(I){I.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(I){I.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(I){I.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(I){I.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(I){I.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(I){I.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"toggleSplitSelectionIntoLines",description:"Split selection into lines",exec:function(I){1<I.multiSelect.rangeCount?I.multiSelect.joinSelections():I.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(I){I.multiSelect.splitIntoLines()},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(I){I.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(I){I.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],f.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(I){I.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(I){return I&&I.inMultiSelectMode}}],A=A("../keyboard/hash_handler").HashHandler,f.keyboardHandler=new A(f.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(A,f,T){var I=A("./range_list").RangeList,m=A("./range").Range,h=A("./selection").Selection,a=A("./mouse/multi_select_handler").onMouseDown,l=A("./lib/event"),t=A("./lib/lang"),r=A("./commands/multi_select_commands");f.commands=r.defaultCommands.concat(r.multiSelectCommands);var e=new(A("./search")).Search,n=A("./edit_session").EditSession,n=((function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(n.prototype),(function(){this.ranges=null,this.rangeList=null,this.addRange=function(o,i){if(o){if(!this.inMultiSelectMode&&this.rangeCount===0){var c=this.toOrientedRange();if(this.rangeList.add(c),this.rangeList.add(o),this.rangeList.ranges.length!=2)return this.rangeList.removeAll(),i||this.fromOrientedRange(o);this.rangeList.removeAll(),this.rangeList.add(c),this.$onAddRange(c)}return o.cursor||(o.cursor=o.end),c=this.rangeList.add(o),this.$onAddRange(o),c.length&&this.$onRemoveRange(c),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),i||this.fromOrientedRange(o)}},this.toSingleRange=function(o){o=o||this.ranges[0];var i=this.rangeList.removeAll();i.length&&this.$onRemoveRange(i),o&&this.fromOrientedRange(o)},this.substractPoint=function(o){if(o=this.rangeList.substractPoint(o),o)return this.$onRemoveRange(o),o[0]},this.mergeOverlappingRanges=function(){var o=this.rangeList.merge();o.length&&this.$onRemoveRange(o)},this.$onAddRange=function(o){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(o),this._signal("addRange",{range:o})},this.$onRemoveRange=function(o){var i;this.rangeCount=this.rangeList.ranges.length,this.rangeCount==1&&this.inMultiSelectMode&&(i=this.rangeList.ranges.pop(),o.push(i),this.rangeCount=0);for(var c=o.length;c--;){var d=this.ranges.indexOf(o[c]);this.ranges.splice(d,1)}this._signal("removeRange",{ranges:o}),this.rangeCount===0&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(i=i||this.ranges[0])&&!i.isEqual(this.getRange())&&this.fromOrientedRange(i)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new I,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){for(var o=this.ranges.length?this.ranges:[this.getRange()],i=[],c=0;c<o.length;c++){var d=o[c],C=d.start.row,p=d.end.row;if(C===p)i.push(d.clone());else{for(i.push(new m(C,d.start.column,C,this.session.getLine(C).length));++C<p;)i.push(this.getLineRange(C,!0));i.push(new m(p,0,p,d.end.column))}c!=0||this.isBackwards()||(i=i.reverse())}for(this.toSingleRange(),c=i.length;c--;)this.addRange(i[c])},this.joinSelections=function(){var i=this.rangeList.ranges,o=i[i.length-1],i=m.fromPoints(i[0].start,o.end);this.toSingleRange(),this.setSelectionRange(i,o.cursor==o.start)},this.toggleBlockSelection=function(){var o,i;1<this.rangeCount?(i=(o=this.rangeList.ranges)[o.length-1],o=m.fromPoints(o[0].start,i.end),this.toSingleRange(),this.setSelectionRange(o,i.cursor==i.start)):(o=this.session.documentToScreenPosition(this.cursor),i=this.session.documentToScreenPosition(this.anchor),this.rectangularRangeBlock(o,i).forEach(this.addRange,this))},this.rectangularRangeBlock=function(o,i,c){var d,C,p,w,x,$,P,B=[],Z=o.column<i.column,u=(w=(Z?(d=o.column,C=i.column,p=o.offsetX,i):(d=i.column,C=o.column,p=i.offsetX,o)).offsetX,o.row<i.row);$=(u?(x=o.row,i):(x=i.row,o)).row,d<0&&(d=0),(x=x<0?0:x)==$&&(c=!0);for(var v,N,y=x;y<=$;y++){var _=m.fromPoints(this.session.screenToDocumentPosition(y,d,p),this.session.screenToDocumentPosition(y,C,w));if(_.isEmpty()){if(P&&(v=_.end,N=P,v.row==N.row)&&v.column==N.column)break;P=_.end}_.cursor=Z?_.start:_.end,B.push(_)}if(u&&B.reverse(),!c){for(var W=B.length-1;B[W].isEmpty()&&0<W;)W--;if(0<W)for(var F=0;B[F].isEmpty();)F++;for(var Y=W;F<=Y;Y--)B[Y].isEmpty()&&B.splice(Y,1)}return B}}).call(h.prototype),A("./editor").Editor);function s(o){var i,c;function d(C){c&&(i.renderer.setMouseCursor(""),c=!1)}o.$multiselectOnSessionChange||(o.$onAddRange=o.$onAddRange.bind(o),o.$onRemoveRange=o.$onRemoveRange.bind(o),o.$onMultiSelect=o.$onMultiSelect.bind(o),o.$onSingleSelect=o.$onSingleSelect.bind(o),o.$multiselectOnSessionChange=f.onSessionChange.bind(o),o.$checkMultiselectChange=o.$checkMultiselectChange.bind(o),o.$multiselectOnSessionChange(o),o.on("changeSession",o.$multiselectOnSessionChange),o.on("mousedown",a),o.commands.addCommands(r.defaultCommands),(i=o).textInput&&(o=i.textInput.getElement(),c=!1,l.addListener(o,"keydown",function(C){C=C.keyCode==18&&!(C.ctrlKey||C.shiftKey||C.metaKey),i.$blockSelectEnabled&&C?c||(i.renderer.setMouseCursor("crosshair"),c=!0):c&&d()},i),l.addListener(o,"keyup",d,i),l.addListener(o,"blur",d,i)))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(o){o.cursor||(o.cursor=o.end);var i=this.getSelectionStyle();return o.marker=this.session.addMarker(o,"ace_selection",i),this.session.$selectionMarkers.push(o),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,o},this.removeSelectionMarker=function(o){o.marker&&(this.session.removeMarker(o.marker),(o=this.session.$selectionMarkers.indexOf(o))!=-1&&this.session.$selectionMarkers.splice(o,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length)},this.removeSelectionMarkers=function(o){for(var i=this.session.$selectionMarkers,c=o.length;c--;){var d=o[c];d.marker&&(this.session.removeMarker(d.marker),(d=i.indexOf(d))!=-1)&&i.splice(d,1)}this.session.selectionMarkerCount=i.length},this.$onAddRange=function(o){this.addSelectionMarker(o.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(o){this.removeSelectionMarkers(o.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(o){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(r.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(o){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(r.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(o){var i,c=o.command,d=o.editor;if(d.multiSelect)return c.multiSelectAction?i=c.multiSelectAction=="forEach"?d.forEachSelection(c,o.args):c.multiSelectAction=="forEachLine"?d.forEachSelection(c,o.args,!0):c.multiSelectAction=="single"?(d.exitMultiSelectMode(),c.exec(d,o.args||{})):c.multiSelectAction(d,o.args||{}):(i=c.exec(d,o.args||{}),d.multiSelect.addRange(d.multiSelect.toOrientedRange()),d.multiSelect.mergeOverlappingRanges()),i},this.forEachSelection=function(o,i,c){if(!this.inVirtualSelectionMode){var d,$=c&&c.keepOrder,C=c==1||c&&c.$byLines,p=this.session,c=this.selection,w=c.rangeList,x=($?c:w).ranges;if(!x.length)return o.exec?o.exec(this,i||{}):o(this,i||{});var $=c._eventRegistry,P=(c._eventRegistry={},new h(p));this.inVirtualSelectionMode=!0;for(var B=x.length;B--;){if(C)for(;0<B&&x[B].start.row==x[B-1].end.row;)B--;P.fromOrientedRange(x[B]),P.index=B,this.selection=p.selection=P;var Z=o.exec?o.exec(this,i||{}):o(this,i||{});d||Z===void 0||(d=Z),P.toOrientedRange(x[B])}return P.detach(),this.selection=p.selection=c,this.inVirtualSelectionMode=!1,c._eventRegistry=$,c.mergeOverlappingRanges(),c.ranges[0]&&c.fromOrientedRange(c.ranges[0]),w=this.renderer.$scrollAnimation,this.onCursorChange(),this.onSelectionChange(),w&&w.from==w.to&&this.renderer.animateScrolling(w.from),d}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var o="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var i=this.multiSelect.rangeList.ranges,c=[],d=0;d<i.length;d++)c.push(this.session.getTextRange(i[d]));var C=this.session.getDocument().getNewLineCharacter();(o=c.join(C)).length==(c.length-1)*C.length&&(o="")}else this.selection.isEmpty()||(o=this.session.getTextRange(this.getSelectionRange()));return o},this.$checkMultiselectChange=function(o,i){var c;this.inMultiSelectMode&&!this.inVirtualSelectionMode&&(c=this.multiSelect.ranges[0],this.multiSelect.isEmpty()&&i==this.multiSelect.anchor||((c=i==this.multiSelect.anchor?c.cursor==c.start?c.end:c.start:c.cursor).row!=i.row||this.session.$clipPositionToDocument(c.row,c.column).column!=i.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()))},this.findAll=function(o,i,c){(i=i||{}).needle=o||i.needle,i.needle==null&&(d=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange(),i.needle=this.session.getTextRange(d)),this.$search.set(i);var d,C=this.$search.findAll(this.session);if(!C.length)return 0;var p=this.multiSelect;c||p.toSingleRange(C[0]);for(var w=C.length;w--;)p.addRange(C[w],!0);return d&&p.rangeList.rangeAtPoint(d.start)&&p.addRange(d,!0),C.length},this.selectMoreLines=function(o,i){var c,d,C,p=this.selection.toOrientedRange(),w=p.cursor==p.end,x=this.session.documentToScreenPosition(p.cursor),$=(this.selection.$desiredColumn&&(x.column=this.selection.$desiredColumn),this.session.screenToDocumentPosition(x.row+o,x.column));o=p.isEmpty()?$:(c=this.session.documentToScreenPosition(w?p.end:p.start),this.session.screenToDocumentPosition(c.row+o,c.column)),w?(d=m.fromPoints($,o)).cursor=d.start:(d=m.fromPoints(o,$)).cursor=d.end,d.desiredColumn=x.column,this.selection.inMultiSelectMode?i&&(C=p.cursor):this.selection.addRange(p),this.selection.addRange(d),C&&this.selection.substractPoint(C)},this.transposeSelections=function(o){for(var i=this.session,c=i.multiSelect,d=c.ranges,C=d.length;C--;)(w=d[C]).isEmpty()&&(x=i.getWordRange(w.start.row,w.start.column),w.start.row=x.start.row,w.start.column=x.start.column,w.end.row=x.end.row,w.end.column=x.end.column);c.mergeOverlappingRanges();for(var p=[],C=d.length;C--;){var w=d[C];p.unshift(i.getTextRange(w))}for(o<0?p.unshift(p.pop()):p.push(p.shift()),C=d.length;C--;){var x=(w=d[C]).clone();i.replace(w,p[C]),w.start.row=x.start.row,w.start.column=x.start.column}c.fromOrientedRange(c.ranges[0])},this.selectMore=function(o,i,c){var d,C=this.session,p=C.multiSelect.toOrientedRange();p.isEmpty()&&((p=C.getWordRange(p.start.row,p.start.column)).cursor=o==-1?p.start:p.end,this.multiSelect.addRange(p),c)||(c=C.getTextRange(p),C=C,c=c,d=o,e.$options.wrap=!0,e.$options.needle=c,e.$options.backwards=d==-1,(c=e.find(C))&&(c.cursor=o==-1?c.start:c.end,this.session.unfold(c),this.multiSelect.addRange(c),this.renderer.scrollCursorIntoView(null,.5)),i&&this.multiSelect.substractPoint(p.cursor))},this.alignCursors=function(){var o=this.session,i=o.multiSelect,c=i.ranges,d=-1,C=c.filter(function(v){if(v.cursor.row==d)return!0;d=v.cursor.row});if(c.length&&C.length!=c.length-1){C.forEach(function(v){i.substractPoint(v.cursor)});var p=0,w=1/0,x=c.map(function(N){var N=N.cursor,y=o.getLine(N.row).substr(N.column).search(/\S/g);return N.column>p&&(p=N.column),(y=y==-1?0:y)<w&&(w=y),y});c.forEach(function(v,W){var y=v.cursor,_=p-y.column,W=x[W]-w;W<_?o.insert(y,t.stringRepeat(" ",_-W)):o.remove(new m(y.row,y.column,y.row,y.column-_+W)),v.start.column=v.end.column=p,v.start.row=v.end.row=y.row,v.cursor=v.end}),i.fromOrientedRange(c[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var C=this.selection.getRange(),$=C.start.row,P=C.end.row,c=$==P;if(c){for(var B,Z=this.session.getLength();B=this.session.getLine(P),/[=:]/.test(B)&&++P<Z;);for(;B=this.session.getLine($),/[=:]/.test(B)&&0<--$;);$<0&&($=0),Z<=P&&(P=Z-1)}var u=this.session.removeFullLines($,P),u=this.$reAlignText(u,c);this.session.insert({row:$,column:0},u.join(`
`)+`
`),c||(C.start.column=0,C.end.column=u[u.length-1].length),this.selection.setRange(C)}},this.$reAlignText=function(o,i){var c,d,C,p=!0,w=!0;return o.map(function(P){var B=P.match(/(\s*)(.*?)(\s*)([=:].*)/);return B?(c==null?(c=B[1].length,d=B[2].length,C=B[3].length):(c+d+C!=B[1].length+B[2].length+B[3].length&&(w=!1),c!=B[1].length&&(p=!1),c>B[1].length&&(c=B[1].length),d<B[2].length&&(d=B[2].length),C>B[3].length&&(C=B[3].length)),B):[P]}).map(i?$:p?w?function(P){return P[2]?x(c+d-P[2].length)+P[2]+x(C)+P[4].replace(/^([=:])\s+/,"$1 "):P[0]}:$:function(P){return P[2]?x(c)+P[2]+x(C)+P[4].replace(/^([=:])\s+/,"$1 "):P[0]});function x(P){return t.stringRepeat(" ",P)}function $(P){return P[2]?x(c)+P[2]+x(d-P[2].length+C)+P[4].replace(/^([=:])\s+/,"$1 "):P[0]}}}).call(n.prototype),f.onSessionChange=function(c){var i=c.session,c=(i&&!i.multiSelect&&(i.$selectionMarkers=[],i.selection.$initRangeList(),i.multiSelect=i.selection),this.multiSelect=i&&i.multiSelect,c.oldSession);c&&(c.multiSelect.off("addRange",this.$onAddRange),c.multiSelect.off("removeRange",this.$onRemoveRange),c.multiSelect.off("multiSelect",this.$onMultiSelect),c.multiSelect.off("singleSelect",this.$onSingleSelect),c.multiSelect.lead.off("change",this.$checkMultiselectChange),c.multiSelect.anchor.off("change",this.$checkMultiselectChange)),i&&(i.multiSelect.on("addRange",this.$onAddRange),i.multiSelect.on("removeRange",this.$onRemoveRange),i.multiSelect.on("multiSelect",this.$onMultiSelect),i.multiSelect.on("singleSelect",this.$onSingleSelect),i.multiSelect.lead.on("change",this.$checkMultiselectChange),i.multiSelect.anchor.on("change",this.$checkMultiselectChange)),i&&this.inMultiSelectMode!=i.selection.inMultiSelectMode&&(i.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},f.MultiSelect=s,A("./config").defineOptions(n.prototype,"editor",{enableMultiselect:{set:function(o){s(this),o?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",a)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",a))},value:!0},enableBlockSelect:{set:function(o){this.$blockSelectEnabled=o},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(m,f,T){var I=m("../../range").Range,m=f.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(h,a,l){return h=h.getLine(l),this.foldingStartMarker.test(h)?"start":a=="markbeginend"&&this.foldingStopMarker&&this.foldingStopMarker.test(h)?"end":""},this.getFoldWidgetRange=function(h,a,l){return null},this.indentationBlock=function(h,a,l){var t=/\S/,r=h.getLine(a),e=r.search(t);if(e!=-1){for(var n,l=l||r.length,s=h.getLength(),r=a,o=a;++a<s;){var i=h.getLine(a).search(t);if(i!=-1){if(i<=e&&(i=h.getTokenAt(a,0),!i||i.type!=="string"))break;o=a}}return r<o?(n=h.getLine(o).length,new I(r,l,o,n)):void 0}},this.openingBracketBlock=function(h,a,l,t,r){if(l={row:l,column:t+1},t=h.$findClosingBracket(a,l,r),t)return(a=(a=h.foldWidgets[t.row])==null?h.getFoldWidget(t.row):a)=="start"&&t.row>l.row&&(t.row--,t.column=h.getLine(t.row).length),I.fromPoints(l,t)},this.closingBracketBlock=function(h,a,l,t,r){if(l={row:l,column:t},t=h.$findOpeningBracket(a,l),t)return t.column++,l.column--,I.fromPoints(t,l)}}).call(m.prototype)}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range","ace/config"],function(A,f,T){var I=A("../line_widgets").LineWidgets,m=A("../lib/dom"),h=A("../range").Range,a=A("../config").nls;function l(t,r,e){var n=t.getAnnotations().sort(h.comparePoints);if(n.length){var s=function(c,d,C){for(var p=0,w=c.length-1;p<=w;){var x=p+w>>1,$=C(d,c[x]);if(0<$)p=1+x;else{if(!($<0))return x;w=x-1}}return-(p+1)}(n,{row:r,column:-1},h.comparePoints),o=((s=s<0?-s-1:s)>=n.length?s=0<e?0:n.length-1:s===0&&e<0&&(s=n.length-1),n[s]);if(o&&e){if(o.row===r){for(;(o=n[s+=e])&&o.row===r;);if(!o)return n.slice()}var i=[];for(r=o.row;i[e<0?"unshift":"push"](o),(o=n[s+=e])&&o.row==r;);return i.length&&i}}}f.showErrorMarker=function(t,d){var e,n=t.session,s=(n.widgetManager||(n.widgetManager=new I(n),n.widgetManager.attach(t)),t.getCursorPosition()),c=s.row,C=n.widgetManager.getWidgetsAtRow(c).filter(function(p){return p.type=="errorMarker"})[0],c=(C?C.destroy():c-=d,l(n,c,d));if(c)d=c[0],s.column=(d.pos&&typeof d.column!="number"?d.pos.sc:d.column)||0,s.row=d.row,e=t.renderer.$gutterLayer.$annotations[s.row];else{if(C)return;e={text:[a("Looks good!")],className:"ace_ok"}}t.session.unfold(s.row),t.selection.moveToPosition(s);function o(p,w,x){if(w===0&&(x==="esc"||x==="return"))return i.destroy(),{command:"null"}}var i={row:s.row,fixedWidth:!0,coverGutter:!0,el:m.createElement("div"),type:"errorMarker"},c=i.el.appendChild(m.createElement("div")),d=i.el.appendChild(m.createElement("div")),C=(d.className="error_widget_arrow "+e.className,t.renderer.$cursorLayer.getPixelPosition(s).left);d.style.left=C+t.renderer.gutterWidth-5+"px",i.el.className="error_widget_wrapper",c.className="error_widget "+e.className,c.innerHTML=e.text.join("<br>"),c.appendChild(m.createElement("div")),i.destroy=function(){t.$mouseHandler.isMousePressed||(t.keyBinding.removeKeyboardHandler(o),n.widgetManager.removeLineWidget(i),t.off("changeSelection",i.destroy),t.off("changeSession",i.destroy),t.off("mouseup",i.destroy),t.off("change",i.destroy))},t.keyBinding.addKeyboardHandler(o),t.on("changeSelection",i.destroy),t.on("changeSession",i.destroy),t.on("mouseup",i.destroy),t.on("change",i.destroy),t.session.widgetManager.addLineWidget(i),i.el.onmousedown=t.focus.bind(t),t.renderer.scrollCursorIntoView(null,.5,{bottom:i.el.offsetHeight})},m.importCssString(`
    .error_widget_wrapper {
        background: inherit;
        color: inherit;
        border:none
    }
    .error_widget {
        border-top: solid 2px;
        border-bottom: solid 2px;
        margin: 5px 0;
        padding: 10px 40px;
        white-space: pre-wrap;
    }
    .error_widget.ace_error, .error_widget_arrow.ace_error{
        border-color: #ff5a5a
    }
    .error_widget.ace_warning, .error_widget_arrow.ace_warning{
        border-color: #F1D817
    }
    .error_widget.ace_info, .error_widget_arrow.ace_info{
        border-color: #5a5a5a
    }
    .error_widget.ace_ok, .error_widget_arrow.ace_ok{
        border-color: #5aaa5a
    }
    .error_widget_arrow {
        position: absolute;
        border: solid 5px;
        border-top-color: transparent!important;
        border-right-color: transparent!important;
        border-left-color: transparent!important;
        top: -5px;
    }
`,"error_marker.css",!1)}),ace.define("ace/ace",["require","exports","module","ace/lib/dom","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config","ace/loader_build"],function(A,f,T){A("./loader_build")(f);var I=A("./lib/dom"),m=A("./range").Range,h=A("./editor").Editor,a=A("./edit_session").EditSession,l=A("./undomanager").UndoManager,t=A("./virtual_renderer").VirtualRenderer;A("./worker/worker_client"),A("./keyboard/hash_handler"),A("./placeholder"),A("./multi_select"),A("./mode/folding/fold_mode"),A("./theme/textmate"),A("./ext/error_marker"),f.config=A("./config"),f.edit=function(r,e){if(typeof r=="string"){var n=r;if(!(r=document.getElementById(n)))throw new Error("ace.edit can't find div #"+n)}var s,o;return r&&r.env&&r.env.editor instanceof h?r.env.editor:(n="",r&&/input|textarea/i.test(r.tagName)?(n=(s=r).value,r=I.createElement("pre"),s.parentNode.replaceChild(r,s)):r&&(n=r.textContent,r.innerHTML=""),n=f.createEditSession(n),r=new h(new t(r),n,e),o={document:n,editor:r,onResize:r.resize.bind(r,null)},s&&(o.textarea=s),r.on("destroy",function(){o.editor.container.env=null}),r.container.env=r.env=o,r)},f.createEditSession=function(r,e){return r=new a(r,e),r.setUndoManager(new l),r},f.Range=m,f.Editor=h,f.EditSession=a,f.UndoManager=l,f.VirtualRenderer=t,f.version=f.config.version}),ace.require(["ace/ace"],function(A){for(var f in A&&(A.config.init(!0),A.define=ace.define),window.ace||(window.ace=A),A)A.hasOwnProperty(f)&&(window.ace[f]=A[f]);window.ace.default=window.ace,ce&&(ce.exports=window.ace)})},4317:function(ce,g,D){ce=D.nmd(ce),ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(U,k,M){var r=U("./lib/dom"),K=U("./lib/oop"),j=U("./lib/event_emitter").EventEmitter,X=U("./lib/lang"),G=U("./range").Range,L=U("./range_list").RangeList,A=U("./keyboard/hash_handler").HashHandler,f=U("./tokenizer").Tokenizer,T=U("./clipboard"),I={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,n,s){return e=e.session.getTextRange(),s?e.replace(/\n\r?([ \t]*\S)/g,`
`+s+"$1"):e},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return T.getText&&T.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){return e=e.session.$mode||{},e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(e){return e=e.session.$mode||{},e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:m.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:m.bind(null,{year:"2-digit"}),CURRENT_MONTH:m.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:m.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:m.bind(null,{month:"short"}),CURRENT_DATE:m.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:m.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:m.bind(null,{weekday:"short"}),CURRENT_HOUR:m.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:m.bind(null,{minute:"2-digit"}),CURRENT_SECOND:m.bind(null,{second:"2-digit"})};function m(e){return e=new Date().toLocaleString("en-us",e),e.length==1?"0"+e:e}I.SELECTED_TEXT=I.SELECTION;function h(){this.snippetMap={},this.snippetNameMap={}}(function(){K.implement(this,j),this.getTokenizer=function(){return h.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function n(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function s(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var o={regex:"/("+s("/")+"+)/",onMatch:function(i,c,d){return d=d[0],d.fmtString=!0,d.guard=i.slice(1,-1),d.flag=""},next:"formatString"};return h.$tokenizer=new f({start:[{regex:/\\./,onMatch:function(i,c,d){var C=i[1];return[i=C=="}"&&d.length||"`$\\".indexOf(C)!=-1?C:i]}},{regex:/}/,onMatch:function(i,c,d){return[d.length?d.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:n},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,c,d){return i=n(i.substr(1)),d.unshift(i[0]),i},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+s("\\|")+"*\\|",onMatch:function(i,c,d){return i=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(C){return C.length==2?C[1]:"\0"}).split("\0").map(function(C){return{value:C}}),[(d[0].choices=i)[0]]},next:"start"},o,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,c,d){return d.length&&d[0].expectElse?(d[0].expectElse=!1,d[0].ifEnd={elseEnd:d[0]},[d[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,c,d){var C=i[1];return C=="}"&&d.length||"`$\\".indexOf(C)!=-1?i=C:C=="n"?i=`
`:C=="t"?i="	":"ulULE".indexOf(C)!=-1&&(i={changeCase:C,local:"a"<C}),[i]}},{regex:"/\\w*}",onMatch:function(i,c,d){return d=d.shift(),d&&(d.flag=i.slice(1,-1)),this.next=d&&d.tabstopId?"start":"",[d||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,c,d){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,c,d){return i={text:i.slice(2)},d.unshift(i),[i]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,c,d){return d=d.shift(),this.next=d&&d.tabstopId?"start":"",[d||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,c,d){return d[0].formatFunction=i.slice(2,-1),[d.shift()]},next:"formatString"},o,{regex:/:[\?\-+]?/,onMatch:function(i,c,d){i[1]=="+"&&(d[0].ifEnd=d[0]),i[1]=="?"&&(d[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(n,s){return this.getTokenizer().getLineTokens(n,s).tokens.map(function(o){return o.value||o})},this.getVariableValue=function(n,s,o){var i;return/^\d+$/.test(s)?(this.variables.__||{})[s]||"":/^[A-Z]\d+$/.test(s)?(this.variables[s[0]+"__"]||{})[s.substr(1)]||"":(s=s.replace(/^TM_/,""),!this.variables.hasOwnProperty(s)||(i=typeof(i=this.variables[s])=="function"?this.variables[s](n,s,o):i)==null?"":i)},this.variables=I,this.tmStrFormat=function(n,s,o){var i,c,d,C;return s.fmt?(i=s.flag||"",c=s.guard,c=new RegExp(c,i.replace(/[^gim]/g,"")),d=typeof s.fmt=="string"?this.tokenizeTmSnippet(s.fmt,"formatString"):s.fmt,C=this,n.replace(c,function(){for(var p=C.variables.__,w=(C.variables.__=[].slice.call(arguments),C.resolveVariables(d,o)),x="E",$=0;$<w.length;$++){var P,B=w[$];typeof B=="object"?(w[$]="",B.changeCase&&B.local?(P=w[$+1])&&typeof P=="string"&&(B.changeCase=="u"?w[$]=P[0].toUpperCase():w[$]=P[0].toLowerCase(),w[$+1]=P.substr(1)):B.changeCase&&(x=B.changeCase)):x=="U"?w[$]=B.toUpperCase():x=="L"&&(w[$]=B.toLowerCase())}return C.variables.__=p,w.join("")})):n},this.tmFormatFunction=function(n,s,o){return s.formatFunction=="upcase"?n.toUpperCase():s.formatFunction=="downcase"?n.toLowerCase():n},this.resolveVariables=function(n,s){for(var o=[],i="",c=!0,d=0;d<n.length;d++){var C,p=n[d];typeof p=="string"?(o.push(p),p==`
`?(c=!0,i=""):c&&(i=/^\t*/.exec(p)[0],c=/\S/.test(p))):p&&(c=!1,p.fmtString&&((C=n.indexOf(p,d+1))==-1&&(C=n.length),p.fmt=n.slice(d+1,C),d=C),p.text?(C=this.getVariableValue(s,p.text,i)+"",p.fmtString&&(C=this.tmStrFormat(C,p,s)),(C=p.formatFunction?this.tmFormatFunction(C,p,s):C)&&!p.ifEnd?(o.push(C),w(p)):!C&&p.ifEnd&&w(p.ifEnd)):p.elseEnd?w(p.elseEnd):p.tabstopId==null&&p.changeCase==null||o.push(p))}function w(x){x=n.indexOf(x,d+1),x!=-1&&(d=x)}return o};function e(n,s,o){o===void 0&&(o={});for(var i=n.getCursorPosition(),c=n.session.getLine(i.row),d=n.session.getTabString(),C=c.match(/^\s*/)[0],p=(i.column<C.length&&(C=C.slice(0,i.column)),s=s.replace(/\r/g,""),this.tokenizeTmSnippet(s)),w=(p=(p=this.resolveVariables(p,n)).map(function(_){return _!=`
`||o.excludeExtraIndent?typeof _=="string"?_.replace(/\t/g,d):_:_+C}),[]),x=(p.forEach(function(_,W){var F,Y,Q;typeof _=="object"&&(Q=_.tabstopId,(F=w[Q])||((F=w[Q]=[]).index=Q,F.value="",F.parents={}),F.indexOf(_)===-1)&&(_.choices&&!F.choices&&(F.choices=_.choices),F.push(_),(Y=p.indexOf(_,W+1))!==-1)&&((Q=p.slice(W+1,Y)).some(function(z){return typeof z=="object"})&&!F.value?F.value=Q:!Q.length||F.value&&typeof F.value=="string"||(F.value=Q.join("")))}),w.forEach(function(_){_.length=0}),{}),$=0;$<p.length;$++){var P,B,Z,u=p[$];typeof u=="object"&&(Z=u.tabstopId,P=w[Z],B=p.indexOf(u,$+1),x[Z]?x[Z]===u&&(delete x[Z],Object.keys(x).forEach(function(_){P.parents[_]=!0})):(x[Z]=u,typeof(Z=P.value)!="string"?Z=function(_){for(var W=[],F=0;F<_.length;F++){if(typeof(Y=_[F])=="object"){if(x[Y.tabstopId])continue;var Y=W[_.lastIndexOf(Y,F-1)]||{tabstopId:Y.tabstopId}}W[F]=Y}return W}(Z):u.fmt&&(Z=this.tmStrFormat(Z,u,n)),p.splice.apply(p,[$+1,Math.max(0,B-$)].concat(Z,u)),P.indexOf(u)===-1&&P.push(u)))}var v=0,N=0,y="";return p.forEach(function(_){var W;typeof _=="string"?(1<(W=_.split(`
`)).length?(N=W[W.length-1].length,v+=W.length-1):N+=_.length,y+=_):_&&(_.start?_.end={row:v,column:N}:_.start={row:v,column:N})}),{text:y,tabstops:w,tokens:p}}this.getDisplayTextForSnippet=function(n,s){return e.call(this,n,s).text},this.insertSnippetForSelection=function(p,i,d){var i=e.call(this,p,i,d=d===void 0?{}:d),c=p.getSelectionRange(),d=(d.range&&d.range.compareRange(c)===0&&(c=d.range),p.session.replace(c,i.text)),C=new a(p),p=p.inVirtualSelectionMode&&p.selection.index;C.addTabstops(i.tabstops,c.start,d,p)},this.insertSnippet=function(n,s,o){var i=this;if(!(o=o===void 0?{}:o).range||o.range instanceof G||(o.range=G.fromPoints(o.range.start,o.range.end)),n.inVirtualSelectionMode)return i.insertSnippetForSelection(n,s,o);n.forEachSelection(function(){i.insertSnippetForSelection(n,s,o)},null,{keepOrder:!0}),n.tabstopManager&&n.tabstopManager.tabNext()},this.$getScope=function(n){var s,o=n.session.$mode.$id||"";return(o=o.split("/").pop())!=="html"&&o!=="php"||(o!=="php"||n.session.$mode.inlinePhp||(o="html"),s=n.getCursorPosition(),(n=typeof(n=n.session.getState(s.row))=="object"?n[0]:n).substring&&(n.substring(0,3)=="js-"?o="javascript":n.substring(0,4)=="css-"?o="css":n.substring(0,4)=="php-"&&(o="php"))),o},this.getActiveScopes=function(s){var s=this.$getScope(s),o=[s],i=this.snippetMap;return i[s]&&i[s].includeScopes&&o.push.apply(o,i[s].includeScopes),o.push("_"),o},this.expandWithTab=function(n,s){var o=this,i=n.forEachSelection(function(){return o.expandSnippetForSelection(n,s)},null,{keepOrder:!0});return i&&n.tabstopManager&&n.tabstopManager.tabNext(),i},this.expandSnippetForSelection=function(n,s){var o,i=n.getCursorPosition(),c=n.session.getLine(i.row),d=c.substring(0,i.column),C=c.substr(i.column),p=this.snippetMap;return this.getActiveScopes(n).some(function(w){return w=p[w],!!(o=w?this.findMatchingSnippet(w,d,C):o)},this),!!o&&(s&&s.dryRun||(n.session.doc.removeInLine(i.row,i.column-o.replaceBefore.length,i.column+o.replaceAfter.length),this.variables.M__=o.matchBefore,this.variables.T__=o.matchAfter,this.insertSnippetForSelection(n,o.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(n,s,o){for(var i=n.length;i--;){var c=n[i];if((!c.startRe||c.startRe.test(s))&&(!c.endRe||c.endRe.test(o))&&(c.startRe||c.endRe))return c.matchBefore=c.startRe?c.startRe.exec(s):[""],c.matchAfter=c.endRe?c.endRe.exec(o):[""],c.replaceBefore=c.triggerRe?c.triggerRe.exec(s)[0]:"",c.replaceAfter=c.endTriggerRe?c.endTriggerRe.exec(o)[0]:"",c}},this.snippetMap={},this.snippetNameMap={},this.register=function(n,s){var o=this.snippetMap,i=this.snippetNameMap,c=this;function d(w){return(w=w&&!/^\^?\(.*\)\$?$|^\\b$/.test(w)?"(?:"+w+")":w)||""}function C(w,x,$){return w=d(w),x=d(x),$?(w=x+w)&&w[w.length-1]!="$"&&(w+="$"):(w+=x)&&w[0]!="^"&&(w="^"+w),new RegExp(w)}function p(w){w.scope||(w.scope=s||"_"),s=w.scope,o[s]||(o[s]=[],i[s]={});var x,$=i[s];w.name&&((x=$[w.name])&&c.unregister(x),$[w.name]=w),o[s].push(w),w.prefix&&(w.tabTrigger=w.prefix),!w.content&&w.body&&(w.content=Array.isArray(w.body)?w.body.join(`
`):w.body),w.tabTrigger&&!w.trigger&&(!w.guard&&/^\w/.test(w.tabTrigger)&&(w.guard="\\b"),w.trigger=X.escapeRegExp(w.tabTrigger)),(w.trigger||w.guard||w.endTrigger||w.endGuard)&&(w.startRe=C(w.trigger,w.guard,!0),w.triggerRe=new RegExp(w.trigger),w.endRe=C(w.endTrigger,w.endGuard,!0),w.endTriggerRe=new RegExp(w.endTrigger))}n=n||[],Array.isArray(n)?n.forEach(p):Object.keys(n).forEach(function(w){p(n[w])}),this._signal("registerSnippets",{scope:s})},this.unregister=function(n,s){var o=this.snippetMap,i=this.snippetNameMap;function c(d){var C=i[d.scope||s];C&&C[d.name]&&(delete C[d.name],0<=(d=(C=o[d.scope||s])&&C.indexOf(d)))&&C.splice(d,1)}n.content?c(n):Array.isArray(n)&&n.forEach(c)},this.parseSnippetFile=function(n){n=n.replace(/\r/g,"");for(var s,o,i,c=[],d={},C=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;o=C.exec(n);){if(o[1])try{d=JSON.parse(o[1]),c.push(d)}catch{}o[4]?(d.content=o[4].replace(/^\t/gm,""),c.push(d),d={}):(s=o[2],o=o[3],s=="regex"?(d.guard=(i=/\/((?:[^\/\\]|\\.)*)|$/g).exec(o)[1],d.trigger=i.exec(o)[1],d.endTrigger=i.exec(o)[1],d.endGuard=i.exec(o)[1]):s=="snippet"?(d.tabTrigger=o.match(/^\S*/)[0],d.name||(d.name=o)):s&&(d[s]=o))}return c},this.getSnippetByName=function(n,s){var o,i=this.snippetNameMap;return this.getActiveScopes(s).some(function(c){return c=i[c],!!(o=c?c[n]:o)},this),o}}).call(h.prototype);var a=function(e){if(e.tabstopManager)return e.tabstopManager;(e.tabstopManager=this).$onChange=this.onChange.bind(this),this.$onChangeSelection=X.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)},l=((function(){this.attach=function(e){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(e){for(var n=e.action[0]=="r",s=this.selectedTabstop||{},o=s.parents||{},i=(this.tabstops||[]).slice(),c=0;c<i.length;c++){var d=i[c],C=d==s||o[d.index];if(d.rangeList.$bias=C?0:1,e.action=="remove"&&d!==s)for(var C=d.parents&&d.parents[s.index],p=(p=d.rangeList.pointIndex(e.start,C))<0?-p-1:p+1,C=d.rangeList.pointIndex(e.end,C),w=d.rangeList.ranges.slice(p,C<0?-C-1:C-1),x=0;x<w.length;x++)this.removeRange(w[x]);d.rangeList.$onChange(e)}var $=this.editor.session;this.$inChange||!n||$.getLength()!=1||$.getValue()||this.detach()},this.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var n=this.editor.session,s=n.getTextRange(e.firstNonLinked),o=0;o<e.length;o++){var i,c=e[o];c.linked&&(i=c.original,i=k.snippetManager.tmStrFormat(s,i,this.editor),n.replace(c,i))}this.$inChange=!1}},this.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,n=this.editor.selection.anchor,s=this.editor.selection.isEmpty(),o=0;o<this.ranges.length;o++)if(!this.ranges[o].linked){var i=this.ranges[o].contains(e.row,e.column),c=s||this.ranges[o].contains(n.row,n.column);if(i&&c)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(s){var n=this.tabstops.length,s=this.index+(s||1),s=Math.min(Math.max(s,1),n);this.selectTabstop(s=s==n?0:s),s===0&&this.detach()},this.selectTabstop=function(e){this.$openTabstops=null;var n=this.tabstops[this.index];if(n&&this.addTabstopMarkers(n),this.index=e,(n=this.tabstops[this.index])&&n.length){if(e=(this.selectedTabstop=n).firstNonLinked||n,n.choices&&(e.cursor=e.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(e);else{var s=this.editor.multiSelect;s.toSingleRange(e);for(var o=0;o<n.length;o++)n.hasLinkedRanges&&n[o].linked||s.addRange(n[o].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(e,n,s){var o=this.useLink||!this.editor.getOption("enableMultiselect");this.$openTabstops||(this.$openTabstops=[]),e[0]||(s=G.fromPoints(s,s),t(s.start,n),t(s.end,n),e[0]=[s],e[0].index=0);var i=[this.index+1,0],c=this.ranges;e.forEach(function(d,C){for(var p=this.$openTabstops[C]||d,w=0;w<d.length;w++){var x=d[w],$=G.fromPoints(x.start,x.end||x.start);l($.start,n),l($.end,n),$.original=x,$.tabstop=p,c.push($),p!=d?p.unshift($):p[w]=$,x.fmtString||p.firstNonLinked&&o?($.linked=!0,p.hasLinkedRanges=!0):p.firstNonLinked||(p.firstNonLinked=$)}p.firstNonLinked||(p.hasLinkedRanges=!1),p===d&&(i.push(p),this.$openTabstops[C]=p),this.addTabstopMarkers(p),p.rangeList=p.rangeList||new L,p.rangeList.$bias=0,p.rangeList.addList(p)},this),2<i.length&&(this.tabstops.length&&i.push(i.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,i))},this.addTabstopMarkers=function(e){var n=this.editor.session;e.forEach(function(s){s.markerId||(s.markerId=n.addMarker(s,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(e){var n=this.editor.session;e.forEach(function(s){n.removeMarker(s.markerId),s.markerId=null})},this.removeRange=function(e){var n=e.tabstop.indexOf(e);n!=-1&&e.tabstop.splice(n,1),(n=this.ranges.indexOf(e))!=-1&&this.ranges.splice(n,1),(n=e.tabstop.rangeList.ranges.indexOf(e))!=-1&&e.tabstop.splice(n,1),this.editor.session.removeMarker(e.markerId),e.tabstop.length||((n=this.tabstops.indexOf(e.tabstop))!=-1&&this.tabstops.splice(n,1),this.tabstops.length)||this.detach()},this.keyboardHandler=new A,this.keyboardHandler.bindKeys({Tab:function(e){k.snippetManager&&k.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}})}).call(a.prototype),function(e,n){e.row==0&&(e.column+=n.column),e.row+=n.row}),t=function(e,n){e.row==n.row&&(e.column-=n.column),e.row-=n.row},r=(r.importCssString(`
.ace_snippet-marker {
    -moz-box-sizing: border-box;
    box-sizing: border-box;
    background: rgba(194, 193, 208, 0.09);
    border: 1px dotted rgba(211, 208, 235, 0.62);
    position: absolute;
}`,"snippets.css",!1),k.snippetManager=new h,U("./editor").Editor);(function(){this.insertSnippet=function(e,n){return k.snippetManager.insertSnippet(this,e,n)},this.expandSnippet=function(e){return k.snippetManager.expandWithTab(this,e)}}).call(r.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config"],function(U,k,M){function K(h){return"suggest-aria-id:".concat(h)}function j(h){return(h=new G(h)).$maxLines=4,(h=new L(h)).setHighlightActiveLine(!1),h.setShowPrintMargin(!1),h.renderer.setShowGutter(!1),h.renderer.setHighlightGutterLine(!1),h.$mouseHandler.$focusTimeout=0,h.$highlightTagPending=!0,h}function X(h){function a(){}function l(){o(-1)}var t,r=I.createElement("div"),e=new j(r),n=(h&&h.appendChild(r),r.style.display="none",e.renderer.content.style.cursor="default",e.renderer.setStyle("ace_autocomplete"),e.renderer.container.setAttribute("role","listbox"),e.renderer.container.setAttribute("aria-label",m("Autocomplete suggestions")),e.setOption("displayIndentGuides",!1),e.setOption("dragDelay",150),e.focus=a,e.$isFocused=!0,e.renderer.$cursorLayer.restartTimer=a,e.renderer.$cursorLayer.element.style.opacity=0,e.renderer.$maxLines=8,e.renderer.$keepTextAreaAtCursor=!1,e.setHighlightActiveLine(!1),e.session.highlight(""),e.session.$searchHighlight.clazz="ace_highlight-marker",e.on("mousedown",function(i){var c=i.getDocumentPosition();e.selection.moveToPosition(c),s.start.row=s.end.row=c.row,i.stop()}),new A(-1,0,-1,1/0)),s=new A(-1,0,-1,1/0),o=(s.id=e.session.addMarker(s,"ace_active-line","fullLine"),e.setSelectOnHover=function(i){i?n.id&&(e.session.removeMarker(n.id),n.id=null):n.id=e.session.addMarker(n,"ace_line-hover","fullLine")},e.setSelectOnHover(!1),e.on("mousemove",function(i){var c;t?t.x==i.x&&t.y==i.y||((t=i).scrollTop=e.renderer.scrollTop,c=t.getDocumentPosition().row,n.start.row!=c&&(n.id||e.setRow(c),o(c))):t=i}),e.renderer.on("beforeRender",function(){var i;t&&n.start.row!=-1&&(t.$pos=null,i=t.getDocumentPosition().row,n.id||e.setRow(i),o(i,!0))}),e.renderer.on("afterRender",function(){var i=e.getRow(),c=e.renderer.$textLayer,d=c.element.childNodes[i-c.config.firstRow],C=document.activeElement;d!==c.selectedNode&&c.selectedNode&&(I.removeCssClass(c.selectedNode,"ace_selected"),C.removeAttribute("aria-activedescendant"),c.selectedNode.removeAttribute("id")),(c.selectedNode=d)&&(I.addCssClass(d,"ace_selected"),c=K(i),d.id=c,e.renderer.container.setAttribute("aria-activedescendant",c),C.setAttribute("aria-activedescendant",c),d.setAttribute("role","option"),d.setAttribute("aria-label",e.getData(i).value),d.setAttribute("aria-setsize",e.data.length),d.setAttribute("aria-posinset",i))}),function(i,c){i!==n.start.row&&(n.start.row=n.end.row=i,c||e.session._emit("changeBackMarker"),e._emit("changeHoverMarker"))});return e.getHoveredRow=function(){return n.start.row},f.addListener(e.container,"mouseout",l),e.on("hide",l),e.on("changeSelection",l),e.session.doc.getLength=function(){return e.data.length},e.session.doc.getLine=function(i){return i=e.data[i],typeof i=="string"?i:i&&i.value||""},(h=e.session.bgTokenizer).$tokenizeRow=function(i){var c=e.data[i],d=[];if(c){for(var C,p,w=(c=typeof c=="string"?{value:c}:c).caption||c.value||c.name,x=w.toLowerCase(),$=(e.filterText||"").toLowerCase(),P=0,B=0,Z=0;Z<=$.length;Z++)Z!=B&&(c.matchMask&1<<Z||Z==$.length)&&(C=$.slice(B,Z),B=Z,(p=x.indexOf(C,P))!=-1)&&(u(w.slice(P,p),""),P=p+C.length,u(w.slice(p,P),"completion-highlight"));u(w.slice(P,w.length),""),c.meta&&d.push({type:"completion-meta",value:c.meta}),c.message&&d.push({type:"completion-message",value:c.message})}return d;function u(v,N){v&&d.push({type:(c.className||"")+(N||""),value:v})}},h.$updateOnChange=a,h.start=a,e.session.$computeWidth=function(){return this.screenWidth=0},e.isOpen=!1,e.isTopdown=!1,e.autoSelect=!0,e.filterText="",e.data=[],e.setData=function(i,c){e.filterText=c||"",e.setValue(T.stringRepeat(`
`,i.length),-1),e.data=i||[],e.setRow(0)},e.getData=function(i){return e.data[i]},e.getRow=function(){return s.start.row},e.setRow=function(i){i=Math.max(this.autoSelect?0:-1,Math.min(this.data.length,i)),s.start.row!=i&&(e.selection.clearSelection(),s.start.row=s.end.row=i||0,e.session._emit("changeBackMarker"),e.moveCursorTo(i||0,0),e.isOpen)&&e._signal("select")},e.on("changeSelection",function(){e.isOpen&&e.setRow(e.selection.lead.row),e.renderer.scrollCursorIntoView()}),e.hide=function(){this.container.style.display="none",e.anchorPos=null,e.anchor=null,e.isOpen&&(e.isOpen=!1,this._signal("hide"))},e.tryShow=function(i,c,d,C){if(C||!e.isOpen||!e.anchorPos||!e.anchor||e.anchorPos.top!==i.top||e.anchorPos.left!==i.left||e.anchor!==d){var p=this.container,w=window.innerHeight,x=window.innerWidth,$=this.renderer,P=$.$maxLines*c*1.4,B={top:0,bottom:0,left:0},Z=w-i.top-3*this.$borderSize-c,u=i.top-3*this.$borderSize,c=((d=d||(u<=Z||P<=Z?"bottom":"top"))==="top"?(B.bottom=i.top-this.$borderSize,B.top=B.bottom-P):d==="bottom"&&(B.top=i.top+c+this.$borderSize,B.bottom=B.top+P),0<=B.top&&B.bottom<=w);if(!C&&!c)return!1;$.$maxPixelHeight=c?null:d==="top"?u:Z,d==="top"?(p.style.top="",p.style.bottom=w-B.bottom+"px",e.isTopdown=!1):(p.style.top=B.top+"px",p.style.bottom="",e.isTopdown=!0),p.style.display="",P=i.left,P+p.offsetWidth>x&&(P=x-p.offsetWidth),p.style.left=P+"px",p.style.right="",e.isOpen||(e.isOpen=!0,this._signal("show"),t=null),e.anchorPos=i,e.anchor=d}return!0},e.show=function(i,c,d){this.tryShow(i,c,d?"bottom":void 0,!0)},e.goTo=function(i){var c=this.getRow(),d=this.session.getLength()-1;switch(i){case"up":c=c<=0?d:c-1;break;case"down":c=d<=c?-1:c+1;break;case"start":c=0;break;case"end":c=d}this.setRow(c)},e.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},e.$imageSize=0,e.$borderSize=1,e}var G=U("../virtual_renderer").VirtualRenderer,L=U("../editor").Editor,A=U("../range").Range,f=U("../lib/event"),T=U("../lib/lang"),I=U("../lib/dom"),m=U("../config").nls;I.importCssString(`
.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {
    background-color: #CAD6FA;
    z-index: 1;
}
.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {
    background-color: #3a674e;
}
.ace_editor.ace_autocomplete .ace_line-hover {
    border: 1px solid #abbffe;
    margin-top: -1px;
    background: rgba(233,233,253,0.4);
    position: absolute;
    z-index: 2;
}
.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {
    border: 1px solid rgba(109, 150, 13, 0.8);
    background: rgba(58, 103, 78, 0.62);
}
.ace_completion-meta {
    opacity: 0.5;
    margin: 0 0.9em;
}
.ace_completion-message {
    color: blue;
}
.ace_editor.ace_autocomplete .ace_completion-highlight{
    color: #2d69c7;
}
.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{
    color: #93ca12;
}
.ace_editor.ace_autocomplete {
    width: 300px;
    z-index: 200000;
    border: 1px lightgray solid;
    position: fixed;
    box-shadow: 2px 3px 5px rgba(0,0,0,.2);
    line-height: 1.4;
    background: #fefefe;
    color: #111;
}
.ace_dark.ace_editor.ace_autocomplete {
    border: 1px #484747 solid;
    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);
    line-height: 1.4;
    background: #25282c;
    color: #c1c1c1;
}
.ace_autocomplete_right .ace_text-layer  {
    width: calc(100% - 8px);
}
.ace_autocomplete_right .ace_line {
    display: flex;
}
.ace_autocomplete_right .ace_completion-meta {
    flex: 1;
    text-align: right;
}
`,"autocompletion.css",!1),k.AcePopup=X,k.$singleLineEditor=j,k.getAriaId=K}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets"],function(U,k,M){var K=U("../snippets").snippetManager;function j(){this.editor=null}j.prototype.show=function(X,G,L){return L=L||"",X&&this.editor&&this.editor!==X&&(this.hide(),this.editor=null),!(!X||!G||!(G=G.snippet?K.getDisplayTextForSnippet(X,G.snippet):G.value)||!G.startsWith(L)||(this.editor=X,(G=G.slice(L.length))===""?X.removeGhostText():X.setGhostText(G),0))},j.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},j.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},j.prototype.destroy=function(){this.hide(),this.editor=null},k.AceInline=j}),ace.define("ace/autocomplete/util",["require","exports","module"],function(U,k,M){k.parForEach=function(j,X,G){var L=0,A=j.length;A===0&&G();for(var f=0;f<A;f++)X(j[f],function(T,I){++L===A&&G(T,I)})};var K=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;k.retrievePrecedingIdentifier=function(j,X,G){G=G||K;for(var L=[],A=X-1;0<=A&&G.test(j[A]);A--)L.push(j[A]);return L.reverse().join("")},k.retrieveFollowingIdentifier=function(j,X,G){G=G||K;for(var L=[],A=X;A<j.length&&G.test(j[A]);A++)L.push(j[A]);return L},k.getCompletionPrefix=function(j){var X,G=j.getCursorPosition(),L=j.session.getLine(G.row);return j.completers.forEach((function(A){A.identifierRegexps&&A.identifierRegexps.forEach((function(f){!X&&f&&(X=this.retrievePrecedingIdentifier(L,G.column,f))}).bind(this))}).bind(this)),X||this.retrievePrecedingIdentifier(L,G.column)}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config"],function(U,k,M){function K(n,s){s.completer&&s.completer.destroy()}var j=U("./keyboard/hash_handler").HashHandler,X=U("./autocomplete/popup").AcePopup,G=U("./autocomplete/inline").AceInline,L=U("./autocomplete/popup").getAriaId,A=U("./autocomplete/util"),f=U("./lib/lang"),T=U("./lib/dom"),I=U("./snippets").snippetManager,m=U("./config"),h=(a.prototype.$init=function(){return this.popup=new X(document.body||document.documentElement),this.popup.on("click",(function(n){this.insertMatch(),n.stop()}).bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupChange.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},a.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new G,this.inlineRenderer},a.prototype.getPopup=function(){return this.popup||this.$init()},a.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip()},a.prototype.$onPopupChange=function(n){var s;this.inlineRenderer&&this.inlineEnabled&&(n=n?null:this.popup.getData(this.popup.getRow()),s=A.getCompletionPrefix(this.editor),this.inlineRenderer.show(this.editor,n,s)||this.inlineRenderer.hide(),this.$updatePopupPosition()),this.tooltipTimer.call(null,null)},a.prototype.$updatePopupPosition=function(){var n=this.editor,s=n.renderer,o=s.layerConfig.lineHeight,i=s.$cursorLayer.getPixelPosition(this.base,!0),c=(i.left-=this.popup.getTextLeftOffset(),n.container.getBoundingClientRect()),c=(i.top+=c.top-s.layerConfig.offset,i.left+=c.left-n.renderer.scrollLeft,i.left+=s.gutterWidth,{top:i.top,left:i.left});s.$ghostText&&s.$ghostTextWidget&&this.base.row===s.$ghostText.position.row&&(c.top+=s.$ghostTextWidget.el.offsetHeight),this.popup.tryShow(c,o,"bottom")||this.popup.tryShow(i,o,"top")||this.popup.show(i,o)},a.prototype.openPopup=function(n,s,o){this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:L(this.popup.getRow()),inline:this.inlineEnabled}),n.keyBinding.addKeyboardHandler(this.keyboardHandler),this.popup.setRow(this.autoSelect?0:-1),o?s||this.detach():(this.popup.setTheme(n.getTheme()),this.popup.setFontSize(n.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel()},a.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null},a.prototype.changeListener=function(n){var s=this.editor.selection.lead;(s.row!=this.base.row||s.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},a.prototype.blurListener=function(n){var s=document.activeElement,o=this.editor.textInput.getElement(),i=n.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(n.relatedTarget),c=this.popup&&this.popup.container;s==o||s.parentNode==c||i||s==this.tooltipNode||n.relatedTarget==o||this.detach()},a.prototype.mousedownListener=function(n){this.detach()},a.prototype.mousewheelListener=function(n){this.detach()},a.prototype.goTo=function(n){this.popup.goTo(n)},a.prototype.insertMatch=function(n,s){var o;return!!(n=n||this.popup.getData(this.popup.getRow()))&&(o=this.completions,n=this.getCompletionProvider().insertMatch(this.editor,n,o.filterText,s),this.completions==o&&this.detach(),n)},a.prototype.showPopup=function(n,s){this.editor&&this.detach(),this.activated=!0,(this.editor=n).completer!=this&&(n.completer&&n.completer.detach(),n.completer=this),n.on("changeSelection",this.changeListener),n.on("blur",this.blurListener),n.on("mousedown",this.mousedownListener),n.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,s)},a.prototype.getCompletionProvider=function(){return this.completionProvider||(this.completionProvider=new l),this.completionProvider},a.prototype.gatherCompletions=function(n,s){return this.getCompletionProvider().gatherCompletions(n,s)},a.prototype.updateCompletions=function(n,s){var o,i;return n&&this.base&&this.completions?(o=this.editor.getCursorPosition(),(i=this.editor.session.getTextRange({start:this.base,end:o}))==this.completions.filterText?void 0:(this.completions.setFilter(i),this.completions.filtered.length&&(this.completions.filtered.length!=1||this.completions.filtered[0].value!=i||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,i,n):this.detach())):s&&s.matches?(o=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(o.row,o.column),this.base.$insertRight=!0,this.completions=new r(s.matches),this.openPopup(this.editor,"",n)):(s=this.editor.getSession(),o=this.editor.getCursorPosition(),i=A.getCompletionPrefix(this.editor),this.base=s.doc.createAnchor(o.row,o.column-i.length),this.base.$insertRight=!0,s={exactMatch:this.exactMatch},void this.getCompletionProvider().provideCompletions(this.editor,s,(function(c,d,C){var p=d.filtered,w=A.getCompletionPrefix(this.editor);if(C){if(!p.length)return this.detach();if(p.length==1&&p[0].value==w&&!p[0].snippet)return this.detach();if(this.autoInsert&&p.length==1)return this.insertMatch(p[0])}this.completions=d,this.openPopup(this.editor,w,n)}).bind(this)))},a.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},a.prototype.updateDocTooltip=function(){var n=this.popup,s=n.data,o=s&&(s[n.getHoveredRow()]||s[n.getRow()]),i=null;if(!o||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var c=this.editor.completers.length,d=0;d<c;d++){var C=this.editor.completers[d];if(C.getDocTooltip&&o.completerId===C.id){i=C.getDocTooltip(o);break}}if(!(i=typeof(i=i||typeof o=="string"?i:o)=="string"?{docText:i}:i)||!i.docHTML&&!i.docText)return this.hideDocTooltip();this.showDocTooltip(i)},a.prototype.showDocTooltip=function(o){this.tooltipNode||(this.tooltipNode=T.createElement("div"),this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this));var s=this.editor.renderer.theme,s=(this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(s.isDark?"ace_dark ":"")+(s.cssClass||""),this.tooltipNode),o=(o.docHTML?s.innerHTML=o.docHTML:o.docText&&(s.textContent=o.docText),s.parentNode||document.body.appendChild(s),this.popup),i=o.container.getBoundingClientRect();s.style.top=o.container.style.top,s.style.bottom=o.container.style.bottom,s.style.display="block",window.innerWidth-i.right<320?i.left<320?(o.isTopdown?s.style.top=i.bottom+"px":s.style.top=o.container.offsetTop-s.offsetHeight+"px",s.style.left=i.left+"px",s.style.right="",s.style.bottom=""):(s.style.right=window.innerWidth-i.left+"px",s.style.left=""):(s.style.left=i.right+1+"px",s.style.right="")},a.prototype.hideDocTooltip=function(){var n;this.tooltipTimer.cancel(),this.tooltipNode&&(n=this.tooltipNode,this.editor.isFocused()||document.activeElement!=n||this.editor.focus(),this.tooltipNode=null,n.parentNode)&&n.parentNode.removeChild(n)},a.prototype.onTooltipClick=function(n){for(var s=n.target;s&&s!=this.tooltipNode;){if(s.nodeName=="A"&&s.href){s.rel="noreferrer",s.target="_blank";break}s=s.parentNode}},a.prototype.destroy=function(){var n;this.detach(),this.popup&&(this.popup.destroy(),n=this.popup.container)&&n.parentNode&&n.parentNode.removeChild(n),this.editor&&this.editor.completer==this&&(this.editor.off("destroy",K),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},a);function a(){this.autoInsert=!1,this.autoSelect=!0,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new j,this.keyboardHandler.bindKeys(this.commands),this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.changeTimer=f.delayedCall((function(){this.updateCompletions(!0)}).bind(this)),this.tooltipTimer=f.delayedCall(this.updateDocTooltip.bind(this),50)}h.prototype.commands={Up:function(n){n.completer.goTo("up")},Down:function(n){n.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(n){n.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(n){n.completer.goTo("end")},Esc:function(n){n.completer.detach()},Return:function(n){return n.completer.insertMatch()},"Shift-Return":function(n){n.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(n){var s=n.completer.insertMatch();if(s||n.tabstopManager)return s;n.completer.goTo("down")},PageUp:function(n){n.completer.popup.gotoPageUp()},PageDown:function(n){n.completer.popup.gotoPageDown()}},h.for=function(n){return n.completer instanceof h||(n.completer&&(n.completer.destroy(),n.completer=null),m.get("sharedPopups")?(h.$sharedInstance||(h.$sharedInstance=new h),n.completer=h.$sharedInstance):(n.completer=new h,n.once("destroy",K))),n.completer},h.startCommand={name:"startAutocomplete",exec:function(n,s){var o=h.for(n);o.autoInsert=!1,o.autoSelect=!0,o.showPopup(n,s),o.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"},t.prototype.insertByIndex=function(n,s,o){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(n,this.completions.filtered[s],o)},t.prototype.insertMatch=function(n,s,o){if(!s)return!1;if(n.startOperation({command:{name:"insertMatch"}}),s.completer&&s.completer.insertMatch)s.completer.insertMatch(n,s);else{if(!this.completions)return!1;if(this.completions.filterText)for(var i,c=n.selection.getAllRanges?n.selection.getAllRanges():[n.getSelectionRange()],d=0;i=c[d];d++)i.start.column-=this.completions.filterText.length,n.session.remove(i);s.snippet?I.insertSnippet(n,s.snippet,{range:s.range}):this.$insertString(n,s),s.command&&s.command==="startAutocomplete"&&n.execCommand(s.command)}return n.endOperation(),!0},t.prototype.$insertString=function(n,s){var o=s.value||s;if(s.range){if(n.inVirtualSelectionMode)return n.session.replace(s.range,o);n.forEachSelection(function(){var i=n.getSelectionRange();s.range.compareRange(i)===0?n.session.replace(s.range,o):n.insert(o)},null,{keepOrder:!0})}else n.execCommand("insertstring",o)},t.prototype.gatherCompletions=function(n,s){var o=n.getSession(),i=n.getCursorPosition(),c=A.getCompletionPrefix(n),d=[],C=n.completers.length;return n.completers.forEach(function(p,w){p.getCompletions(n,o,i,c,function(x,$){!x&&$&&(d=d.concat($)),s(null,{prefix:A.getCompletionPrefix(n),matches:d,finished:--C==0})})}),!0},t.prototype.provideCompletions=function(n,s,o){var i=(function(C){var p=C.prefix,w=C.matches;this.completions=new r(w),s.exactMatch&&(this.completions.exactMatch=!0),s.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(p),(C.finished||this.completions.filtered.length)&&o(null,this.completions,C.finished)}).bind(this),c=!0,d=null;this.gatherCompletions(n,(function(C,p){this.active&&(C&&(o(C,[],!0),this.detach()),p.prefix.indexOf(p.prefix)===0)&&(c?d=p:i(p))}).bind(this)),c=!1,d&&(n=d,d=null,i(n))},t.prototype.detach=function(){this.active=!1};var l=t;function t(){this.active=!0}e.prototype.setFilter=function(n){s=n.length>this.filterText&&n.lastIndexOf(this.filterText,0)===0?this.filtered:this.all,this.filterText=n,s=(s=this.filterCompletions(s,this.filterText)).sort(function(i,c){return c.exactMatch-i.exactMatch||c.$score-i.$score||(i.caption||i.value).localeCompare(c.caption||c.value)});var s,o=null;s=s.filter(function(i){return i=i.snippet||i.caption||i.value,i!==o&&(o=i,!0)}),this.filtered=s},e.prototype.filterCompletions=function(n,s){var o=[],i=s.toUpperCase(),c=s.toLowerCase();e:for(var d,C=0;d=n[C];C++){var p=!this.ignoreCaption&&d.caption||d.value||d.snippet;if(p){var w=-1,x=0,$=0;if(this.exactMatch){if(s!==p.substr(0,s.length))continue}else{var P=p.toLowerCase().indexOf(c);if(-1<P)$=P;else for(var B=0;B<s.length;B++){var Z=p.indexOf(c[B],w+1),u=p.indexOf(i[B],w+1);if((Z=0<=Z&&(u<0||Z<u)?Z:u)<0)continue e;0<(u=Z-w-1)&&(w===-1&&($+=10),$+=u,x|=1<<B),w=Z}}d.matchMask=x,d.exactMatch=$?0:1,d.$score=(d.score||0)-$,o.push(d)}}return o};var r=e;function e(n,s){this.all=n,this.filtered=n,this.filterText=s||"",this.exactMatch=!1,this.ignoreCaption=!1}k.Autocomplete=h,k.CompletionProvider=l,k.FilteredList=r}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(U,k,M){var K=U("../range").Range,j=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;function X(G,L){var A=G.getTextRange(K.fromPoints({row:0,column:0},L)).split(j).length-1,f=G.getValue().split(j),T=Object.create(null),I=f[A];return f.forEach(function(m,h){m&&m!==I&&(h=Math.abs(A-h),h=f.length-h,T[m]?T[m]=Math.max(h,T[m]):T[m]=h)}),T}k.getCompletions=function(G,L,A,f,T){var I=X(L,A);T(null,Object.keys(I).map(function(m){return{caption:m,value:m,score:I[m],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(U,k,M){function K(r,e){a(e.session.$mode)}function j(r){var e=r.editor,n=e.completer&&e.completer.activated;r.command.name==="backspace"?n&&!f.getCompletionPrefix(e)&&e.completer.detach():r.command.name==="insertstring"&&f.getCompletionPrefix(e)&&!n&&((r=G.for(e)).autoInsert=!1,r.showPopup(e))}var X=U("../snippets").snippetManager,G=U("../autocomplete").Autocomplete,L=U("../config"),A=U("../lib/lang"),f=U("../autocomplete/util"),t=U("../autocomplete/text_completer"),T={getCompletions:function(r,e,n,s,o){if(e.$mode.completer)return e.$mode.completer.getCompletions(r,e,n,s,o);r=r.session.getState(n.row),o(null,e.$mode.getCompletions(r,e,n,s).map(function(i){return i.completerId=T.id,i}))},id:"keywordCompleter"},I={getCompletions:function(r,c,n,s,o){var i=[],c=c.getTokenAt(n.row,n.column),d=(c&&c.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?i.push("html-tag"):i=X.getActiveScopes(r),X.snippetMap),C=[];i.forEach(function(p){for(var w=d[p]||[],x=w.length;x--;){var $=w[x],P=$.name||$.tabTrigger;P&&C.push({caption:P,snippet:$.content,meta:$.tabTrigger&&!$.name?$.tabTrigger+"⇥ ":"snippet",completerId:I.id})}},this),o(null,C)},getDocTooltip:function(r){var e;r.snippet&&!r.docHTML&&(r.docHTML=["<b>",A.escapeHTML(r.caption),"</b>","<hr></hr>",A.escapeHTML((r=r.snippet,e={},r.replace(/\${(\d+)(:(.*?))?}/g,function(n,s,o,i){return e[s]=i||""}).replace(/\$(\d+?)/g,function(n,s){return e[s]})))].join(""))},id:"snippetCompleter"},m=[I,t,T],h=(k.setCompleters=function(r){m.length=0,r&&m.push.apply(m,r)},k.addCompleter=function(r){m.push(r)},k.textCompleter=t,k.keyWordCompleter=T,k.snippetCompleter=I,{name:"expandSnippet",exec:function(r){return X.expandWithTab(r)},bindKey:"Tab"}),a=function(r){(r=typeof r=="string"?L.$modes[r]:r)&&(X.files||(X.files={}),l(r.$id,r.snippetFileId),r.modes)&&r.modes.forEach(a)},l=function(r,e){e&&r&&!X.files[r]&&(X.files[r]={},L.loadModule(e,function(n){n&&(!(X.files[r]=n).snippets&&n.snippetText&&(n.snippets=X.parseSnippetFile(n.snippetText)),X.register(n.snippets||[],n.scope),n.includeScopes)&&(X.snippetMap[n.scope].includeScopes=n.includeScopes,n.includeScopes.forEach(function(s){a("ace/mode/"+s)}))}))},t=U("../editor").Editor;U("../config").defineOptions(t.prototype,"editor",{enableBasicAutocompletion:{set:function(r){r?(this.completers||(this.completers=Array.isArray(r)?r:m),this.commands.addCommand(G.startCommand)):this.commands.removeCommand(G.startCommand)},value:!1},enableLiveAutocompletion:{set:function(r){r?(this.completers||(this.completers=Array.isArray(r)?r:m),this.commands.on("afterExec",j)):this.commands.removeListener("afterExec",j)},value:!1},enableSnippets:{set:function(r){r?(this.commands.addCommand(h),this.on("changeMode",K),K(0,this)):(this.commands.removeCommand(h),this.off("changeMode",K))},value:!1}})}),ace.require(["ace/ext/language_tools"],function(U){ce&&(ce.exports=U)})},3330:function(ce,g,D){ce=D.nmd(ce),ace.define("ace/ext/searchbox.css",["require","exports","module"],function(U,k,M){M.exports=`

/* ------------------------------------------------------------------------------------------
 * Editor Search Form
 * --------------------------------------------------------------------------------------- */
.ace_search {
    background-color: #ddd;
    color: #666;
    border: 1px solid #cbcbcb;
    border-top: 0 none;
    overflow: hidden;
    margin: 0;
    padding: 4px 6px 0 4px;
    position: absolute;
    top: 0;
    z-index: 99;
    white-space: normal;
}
.ace_search.left {
    border-left: 0 none;
    border-radius: 0px 0px 5px 0px;
    left: 0;
}
.ace_search.right {
    border-radius: 0px 0px 0px 5px;
    border-right: 0 none;
    right: 0;
}

.ace_search_form, .ace_replace_form {
    margin: 0 20px 4px 0;
    overflow: hidden;
    line-height: 1.9;
}
.ace_replace_form {
    margin-right: 0;
}
.ace_search_form.ace_nomatch {
    outline: 1px solid red;
}

.ace_search_field {
    border-radius: 3px 0 0 3px;
    background-color: white;
    color: black;
    border: 1px solid #cbcbcb;
    border-right: 0 none;
    outline: 0;
    padding: 0;
    font-size: inherit;
    margin: 0;
    line-height: inherit;
    padding: 0 6px;
    min-width: 17em;
    vertical-align: top;
    min-height: 1.8em;
    box-sizing: content-box;
}
.ace_searchbtn {
    border: 1px solid #cbcbcb;
    line-height: inherit;
    display: inline-block;
    padding: 0 6px;
    background: #fff;
    border-right: 0 none;
    border-left: 1px solid #dcdcdc;
    cursor: pointer;
    margin: 0;
    position: relative;
    color: #666;
}
.ace_searchbtn:last-child {
    border-radius: 0 3px 3px 0;
    border-right: 1px solid #cbcbcb;
}
.ace_searchbtn:disabled {
    background: none;
    cursor: default;
}
.ace_searchbtn:hover {
    background-color: #eef1f6;
}
.ace_searchbtn.prev, .ace_searchbtn.next {
     padding: 0px 0.7em
}
.ace_searchbtn.prev:after, .ace_searchbtn.next:after {
     content: "";
     border: solid 2px #888;
     width: 0.5em;
     height: 0.5em;
     border-width:  2px 0 0 2px;
     display:inline-block;
     transform: rotate(-45deg);
}
.ace_searchbtn.next:after {
     border-width: 0 2px 2px 0 ;
}
.ace_searchbtn_close {
    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;
    border-radius: 50%;
    border: 0 none;
    color: #656565;
    cursor: pointer;
    font: 16px/16px Arial;
    padding: 0;
    height: 14px;
    width: 14px;
    top: 9px;
    right: 7px;
    position: absolute;
}
.ace_searchbtn_close:hover {
    background-color: #656565;
    background-position: 50% 100%;
    color: white;
}

.ace_button {
    margin-left: 2px;
    cursor: pointer;
    -webkit-user-select: none;
    -moz-user-select: none;
    -o-user-select: none;
    -ms-user-select: none;
    user-select: none;
    overflow: hidden;
    opacity: 0.7;
    border: 1px solid rgba(100,100,100,0.23);
    padding: 1px;
    box-sizing:    border-box!important;
    color: black;
}

.ace_button:hover {
    background-color: #eee;
    opacity:1;
}
.ace_button:active {
    background-color: #ddd;
}

.ace_button.checked {
    border-color: #3399ff;
    opacity:1;
}

.ace_search_options{
    margin-bottom: 3px;
    text-align: right;
    -webkit-user-select: none;
    -moz-user-select: none;
    -o-user-select: none;
    -ms-user-select: none;
    user-select: none;
    clear: both;
}

.ace_search_counter {
    float: left;
    font-family: arial;
    padding: 0 8px;
}`}),ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/ext/searchbox.css","ace/keyboard/hash_handler","ace/lib/keys","ace/config"],function(U,k,M){var K=U("../lib/dom"),j=U("../lib/lang"),X=U("../lib/event"),G=U("./searchbox.css"),L=U("../keyboard/hash_handler").HashHandler,A=U("../lib/keys"),f=U("../config").nls,T=(K.importCssString(G,"ace_searchbox",!1),I.prototype.setEditor=function(m){m.searchBox=this,m.renderer.scroller.appendChild(this.element),this.editor=m},I.prototype.setSession=function(m){this.searchRange=null,this.$syncOptions(!0)},I.prototype.$initElements=function(m){this.searchBox=m.querySelector(".ace_search_form"),this.replaceBox=m.querySelector(".ace_replace_form"),this.searchOption=m.querySelector("[action=searchInSelection]"),this.replaceOption=m.querySelector("[action=toggleReplace]"),this.regExpOption=m.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=m.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=m.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=m.querySelector(".ace_search_counter")},I.prototype.$init=function(){var m=this.element,h=(this.$initElements(m),this);X.addListener(m,"mousedown",function(a){setTimeout(function(){h.activeInput.focus()},0),X.stopPropagation(a)}),X.addListener(m,"click",function(a){var l=(a.target||a.srcElement).getAttribute("action");l&&h[l]?h[l]():h.$searchBarKb.commands[l]&&h.$searchBarKb.commands[l].exec(h),X.stopPropagation(a)}),X.addCommandKeyListener(m,function(a,l,t){t=A.keyCodeToString(t),l=h.$searchBarKb.findKeyCommand(l,t),l&&l.exec&&(l.exec(h),X.stopEvent(a))}),this.$onChange=j.delayedCall(function(){h.find(!1,!1)}),X.addListener(this.searchInput,"input",function(){h.$onChange.schedule(20)}),X.addListener(this.searchInput,"focus",function(){h.activeInput=h.searchInput,h.searchInput.value&&h.highlight()}),X.addListener(this.replaceInput,"focus",function(){h.activeInput=h.replaceInput,h.searchInput.value&&h.highlight()})},I.prototype.setSearchRange=function(m){(this.searchRange=m)?this.searchRangeMarker=this.editor.session.addMarker(m,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},I.prototype.$syncOptions=function(m){K.setCssClass(this.replaceOption,"checked",this.searchRange),K.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",K.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),K.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),K.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var h=this.editor.getReadOnly();this.replaceOption.style.display=h?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!h?"":"none",this.find(!1,!1,m)},I.prototype.highlight=function(m){this.editor.session.highlight(m||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},I.prototype.find=function(m,h,a){m=!this.editor.find(this.searchInput.value,{skipCurrent:m,backwards:h,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:a,range:this.searchRange})&&this.searchInput.value,K.setCssClass(this.searchBox,"ace_nomatch",m),this.editor._emit("findSearchBox",{match:!m}),this.highlight(),this.updateCounter()},I.prototype.updateCounter=function(){var m=this.editor,h=m.$search.$options.re,a=0,l=0;if(h){var t,r,e=this.searchRange?m.session.getTextRange(this.searchRange):m.getValue(),n=m.session.doc.positionToIndex(m.selection.anchor);for(this.searchRange&&(n-=m.session.doc.positionToIndex(this.searchRange.start)),h.lastIndex=0;(r=h.exec(e))&&((t=r.index)<=n&&l++,!(999<++a))&&(r[0]||(h.lastIndex=t+=1,!(t>=e.length))););}this.searchCounter.textContent=f("$0 of $1",[l,999<a?"999+":a])},I.prototype.findNext=function(){this.find(!0,!1)},I.prototype.findPrev=function(){this.find(!0,!0)},I.prototype.findAll=function(){var m=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;K.setCssClass(this.searchBox,"ace_nomatch",m),this.editor._emit("findSearchBox",{match:!m}),this.highlight(),this.hide()},I.prototype.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},I.prototype.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},I.prototype.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},I.prototype.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},I.prototype.show=function(m,h){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=h,m&&(this.searchInput.value=m),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},I.prototype.isFocused=function(){var m=document.activeElement;return m==this.searchInput||m==this.replaceInput},I);function I(m,h,a){var l=K.createElement("div");K.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:f("Search for"),spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"​"],["span",{action:"findNext",class:"ace_searchbtn next"},"​"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},f("All")]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:f("Replace with"),spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},f("Replace")],["span",{action:"replaceAll",class:"ace_searchbtn"},f("All")]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:f("Toggle Replace mode"),style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:f("RegExp Search")},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:f("CaseSensitive Search")},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:f("Whole Word Search")},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:f("Search In Selection")},"S"]]],l),this.element=l.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(m),K.importCssString(G,"ace_searchbox",m.container)}U=new L,U.bindKeys({"Ctrl-f|Command-f":function(m){var h=m.isReplace=!m.isReplace;m.replaceBox.style.display=h?"":"none",m.replaceOption.checked=!1,m.$syncOptions(),m.searchInput.focus()},"Ctrl-H|Command-Option-F":function(m){m.editor.getReadOnly()||(m.replaceOption.checked=!0,m.$syncOptions(),m.replaceInput.focus())},"Ctrl-G|Command-G":function(m){m.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(m){m.findPrev()},esc:function(m){setTimeout(function(){m.hide()})},Return:function(m){m.activeInput==m.replaceInput&&m.replace(),m.findNext()},"Shift-Return":function(m){m.activeInput==m.replaceInput&&m.replace(),m.findPrev()},"Alt-Return":function(m){m.activeInput==m.replaceInput&&m.replaceAll(),m.findAll()},Tab:function(m){(m.activeInput==m.replaceInput?m.searchInput:m.replaceInput).focus()}}),U.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(m){m.regExpOption.checked=!m.regExpOption.checked,m.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(m){m.caseSensitiveOption.checked=!m.caseSensitiveOption.checked,m.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(m){m.wholeWordOption.checked=!m.wholeWordOption.checked,m.$syncOptions()}},{name:"toggleReplace",exec:function(m){m.replaceOption.checked=!m.replaceOption.checked,m.$syncOptions()}},{name:"searchInSelection",exec:function(m){m.searchOption.checked=!m.searchRange,m.setSearchRange(m.searchOption.checked&&m.editor.getSelectionRange()),m.$syncOptions()}}]),L=new L([{bindKey:"Esc",name:"closeSearchBar",exec:function(m){m.searchBox.hide()}}]),T.prototype.$searchBarKb=U,T.prototype.$closeSearchBarKb=L,k.SearchBox=T,k.Search=function(m,h){(m.searchBox||new T(m)).show(m.session.getTextRange(),h)}}),ace.require(["ace/ext/searchbox"],function(U){ce&&(ce.exports=U)})},4091:function(ce,g,D){ce=D.nmd(ce),ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(X,k,M){function K(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"punctuation.operator",regex:/[,]/},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var j=X("../lib/oop"),X=X("./text_highlight_rules").TextHighlightRules;j.inherits(K,X),k.JsonHighlightRules=K}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(U,k,M){function K(){}var j=U("../range").Range;(function(){this.checkOutdent=function(X,G){return!!/^\s+$/.test(X)&&/^\s*\}/.test(G)},this.autoOutdent=function(X,G){var L,A=X.getLine(G).match(/^(\s*\})/);return A&&(A=A[1].length,L=X.findMatchingBracket({row:G,column:A}))&&L.row!=G?(L=this.$getIndent(X.getLine(L.row)),void X.replace(new j(G,0,G,A-1),L)):0},this.$getIndent=function(X){return X.match(/^\s*/)[0]}}).call(K.prototype),k.MatchingBraceOutdent=K}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(X,G,M){var K=X("../../lib/oop"),j=X("../../range").Range,X=X("./fold_mode").FoldMode,G=G.FoldMode=function(L){L&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+L.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+L.end)))};K.inherits(G,X),(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(L,A,f){var T=L.getLine(f);return!this.singleLineBlockCommentRe.test(T)||this.startRegionRe.test(T)||this.tripleStarBlockCommentRe.test(T)?!(L=this._getFoldWidgetBase(L,A,f))&&this.startRegionRe.test(T)?"start":L:""},this.getFoldWidgetRange=function(L,A,f,T){var I,m,h,a=L.getLine(f);return this.startRegionRe.test(a)?this.getCommentRegionBlock(L,a,f):(m=a.match(this.foldingStartMarker))?(h=m.index,m[1]?this.openingBracketBlock(L,m[1],f,h):((I=L.getCommentFoldRange(f,h+m[0].length,1))&&!I.isMultiLine()&&(T?I=this.getSectionRange(L,f):A!="all"&&(I=null)),I)):A!=="markbegin"&&(m=a.match(this.foldingStopMarker))?(h=m.index+m[0].length,m[1]?this.closingBracketBlock(L,m[1],f,h):L.getCommentFoldRange(f,h,-1)):void 0},this.getSectionRange=function(L,A){for(var f=(a=L.getLine(A)).search(/\S/),T=A,I=a.length,m=A+=1,h=L.getLength();++A<h;){var a,l=(a=L.getLine(A)).search(/\S/);if(l!==-1){if(l<f)break;var t=this.getFoldWidgetRange(L,"all",A);if(t){if(t.start.row<=T)break;if(t.isMultiLine())A=t.end.row;else if(f==l)break}m=A}}return new j(T,I,m,L.getLine(m).length)},this.getCommentRegionBlock=function(L,A,f){for(var T=A.search(/\s*$/),I=L.getLength(),m=f,h=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++f<I;){A=L.getLine(f);var l=h.exec(A);if(l&&(l[1]?a--:a++,!a))break}if(m<f)return new j(m,T,f,A.length)}}).call(G.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(U,k,M){function K(){this.HighlightRules=G,this.$outdent=new L,this.$behaviour=new A,this.foldingRules=new f}var j=U("../lib/oop"),X=U("./text").Mode,G=U("./json_highlight_rules").JsonHighlightRules,L=U("./matching_brace_outdent").MatchingBraceOutdent,A=U("./behaviour/cstyle").CstyleBehaviour,f=U("./folding/cstyle").FoldMode,T=U("../worker/worker_client").WorkerClient;j.inherits(K,X),(function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(I,m,h){var a=this.$getIndent(m);return I=="start"&&m.match(/^.*[\{\(\[]\s*$/)&&(a+=h),a},this.checkOutdent=function(I,m,h){return this.$outdent.checkOutdent(m,h)},this.autoOutdent=function(I,m,h){this.$outdent.autoOutdent(m,h)},this.createWorker=function(I){var m=new T(["ace"],"ace/mode/json_worker","JsonWorker");return m.attachToDocument(I.getDocument()),m.on("annotate",function(h){I.setAnnotations(h.data)}),m.on("terminate",function(){I.clearAnnotations()}),m},this.$id="ace/mode/json"}).call(K.prototype),k.Mode=K}),ace.require(["ace/mode/json"],function(U){ce&&(ce.exports=U)})},8903:function(f,g,D){var U=D(5689),k=D(3969),M=D(5255),K=D(4293),j=D(3508),X=D(3368),G=D(742),L=D(9394),A=D(3724),f=((f.exports=h).prototype.validate=function(o,i){var c;if(typeof o=="string"){if(!(c=this.getSchema(o)))throw new Error('no schema with key or ref "'+o+'"')}else o=this._addSchema(o),c=o.validate||this._compile(o);return o=c(i),c.$async!==!0&&(this.errors=c.errors),o},h.prototype.compile=function(o,i){return o=this._addSchema(o,void 0,i),o.validate||this._compile(o)},h.prototype.addSchema=function(o,i,c,d){if(Array.isArray(o))for(var C=0;C<o.length;C++)this.addSchema(o[C],void 0,c,d);else{var p=this._getId(o);if(p!==void 0&&typeof p!="string")throw new Error("schema id must be string");n(this,i=k.normalizeId(i||p)),this._schemas[i]=this._addSchema(o,c,d,!0)}return this},h.prototype.addMetaSchema=function(o,i,c){return this.addSchema(o,i,c,!0),this},h.prototype.validateSchema=function(o,i){var c=o.$schema;if(c!==void 0&&typeof c!="string")throw new Error("$schema must be a string");if(!(c=c||this._opts.defaultMeta||function(d){var C=d._opts.meta;return d._opts.defaultMeta=typeof C=="object"?d._getId(C)||C:d.getSchema(T)?T:void 0,d._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);if(c=this.validate(c,o),!c&&i){if(o="schema is invalid: "+this.errorsText(),this._opts.validateSchema!="log")throw new Error(o);this.logger.error(o)}return c},h.prototype.getSchema=function(o){var i=a(this,o);switch(typeof i){case"object":return i.validate||this._compile(i);case"string":return this.getSchema(i);case"undefined":return function(c,d){var C=k.schema.call(c,{schema:{}},d);{var p,w,x;if(C)return p=C.schema,w=C.root,C=C.baseId,x=U.call(c,p,w,void 0,C),c._fragments[d]=new K({ref:d,fragment:!0,schema:p,root:w,baseId:C,validate:x}),x}}(this,o)}},h.prototype.removeSchema=function(o){if(o instanceof RegExp)l(this,this._schemas,o),l(this,this._refs,o);else switch(typeof o){case"undefined":return l(this,this._schemas),l(this,this._refs),this._cache.clear(),this;case"string":var i=a(this,o);return i&&this._cache.del(i.cacheKey),delete this._schemas[o],delete this._refs[o],this;case"object":i=this._opts.serialize,i=i?i(o):o,i=(this._cache.del(i),this._getId(o)),i&&(i=k.normalizeId(i),delete this._schemas[i],delete this._refs[i])}return this},h.prototype.addFormat=function(o,i){return typeof i=="string"&&(i=new RegExp(i)),this._formats[o]=i,this},h.prototype.errorsText=function(o,i){if(!(o=o||this.errors))return"No errors";for(var c=(i=i||{}).separator===void 0?", ":i.separator,d=i.dataVar===void 0?"data":i.dataVar,C="",p=0;p<o.length;p++){var w=o[p];w&&(C+=d+w.dataPath+" "+w.message+c)}return C.slice(0,-c.length)},h.prototype._addSchema=function(o,x,c,d){if(typeof o!="object"&&typeof o!="boolean")throw new Error("schema should be object or boolean");var C=this._opts.serialize,C=C?C(o):o,p=this._cache.get(C);if(p)return p;d=d||this._opts.addUsedSchema!==!1,p=k.normalizeId(this._getId(o)),p&&d&&n(this,p);var w,x=this._opts.validateSchema!==!1&&!x;x&&!(w=p&&p==k.normalizeId(o.$schema))&&this.validateSchema(o,!0);var $=k.ids.call(this,o),$=new K({id:p,schema:o,localRefs:$,cacheKey:C,meta:c});return p[0]!="#"&&d&&(this._refs[p]=$),this._cache.put(C,$),x&&w&&this.validateSchema(o,!0),$},h.prototype._compile=function(o,i){if(o.compiling)return(o.validate=C).schema=o.schema,C.errors=null,C.root=i||C,o.schema.$async===!0&&(C.$async=!0),C;var c,d;o.compiling=!0,o.meta&&(c=this._opts,this._opts=this._metaOpts);try{d=U.call(this,o.schema,i,o.localRefs)}catch(p){throw delete o.validate,p}finally{o.compiling=!1,o.meta&&(this._opts=c)}return o.validate=d,o.refs=d.refs,o.refVal=d.refVal,o.root=d.root,d;function C(){var p=o.validate,w=p.apply(this,arguments);return C.errors=p.errors,w}},h.prototype.compileAsync=D(9677),D(7931)),f=(h.prototype.addKeyword=f.add,h.prototype.getKeyword=f.get,h.prototype.removeKeyword=f.remove,h.prototype.validateKeyword=f.validate,D(5359)),T=(h.ValidationError=f.Validation,h.MissingRefError=f.MissingRef,h.$dataMetaSchema=L,"http://json-schema.org/draft-07/schema"),I=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],m=["/properties"];function h(o){if(!(this instanceof h))return new h(o);o=this._opts=A.copy(o)||{};var P=this,i=P._opts.logger;if(i===!1)P.logger={log:s,warn:s,error:s};else{if(!(typeof(i=i===void 0?console:i)=="object"&&i.log&&i.warn&&i.error))throw new Error("logger must implement log, warn and error methods");P.logger=i}if(this._schemas={},this._refs={},this._fragments={},this._formats=X(o.format),this._cache=o.cache||new M,this._loadingSchemas={},this._compilations=[],this.RULES=G(),this._getId=function(v){switch(v.schemaId){case"auto":return e;case"id":return t;default:return r}}(o),o.loopRequired=o.loopRequired||1/0,o.errorDataPath=="property"&&(o._errorDataPathProperty=!0),o.serialize===void 0&&(o.serialize=j),this._metaOpts=function(v){for(var N=A.copy(v._opts),y=0;y<I.length;y++)delete N[I[y]];return N}(this),o.formats){var c,d=this;for(c in d._opts.formats){var C=d._opts.formats[c];d.addFormat(c,C)}}if(o.keywords){var p,w=this;for(p in w._opts.keywords){var x=w._opts.keywords[p];w.addKeyword(p,x)}}var $,P=this,B=(P._opts.$data&&($=D(894),P.addMetaSchema($,$.$id,!0)),P._opts.meta!==!1&&($=D(6680),P._opts.$data&&($=L($,m)),P.addMetaSchema($,T,!0),P._refs["http://json-schema.org/schema"]=T),typeof o.meta=="object"&&this.addMetaSchema(o.meta),o.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),this),Z=B._opts.schemas;if(Z)if(Array.isArray(Z))B.addSchema(Z);else for(var u in Z)B.addSchema(Z[u],u)}function a(o,i){return i=k.normalizeId(i),o._schemas[i]||o._refs[i]||o._fragments[i]}function l(o,i,c){for(var d in i){var C=i[d];C.meta||c&&!c.test(d)||(o._cache.del(C.cacheKey),delete i[d])}}function t(o){return o.$id&&this.logger.warn("schema $id ignored",o.$id),o.id}function r(o){return o.id&&this.logger.warn("schema id ignored",o.id),o.$id}function e(o){if(o.$id&&o.id&&o.$id!=o.id)throw new Error("schema $id is different from id");return o.$id||o.id}function n(o,i){if(o._schemas[i]||o._refs[i])throw new Error('schema with key or id "'+i+'" already exists')}function s(){}},5255:function(ce){ce=ce.exports=function(){this._cache={}},ce.prototype.put=function(g,D){this._cache[g]=D},ce.prototype.get=function(g){return this._cache[g]},ce.prototype.del=function(g){delete this._cache[g]},ce.prototype.clear=function(){this._cache={}}},9677:function(ce,g,D){var U=D(5359).MissingRef;function k(M,K,j){var X=this;if(typeof this._opts.loadSchema!="function")throw new Error("options.loadSchema should be a function");typeof K=="function"&&(j=K,K=void 0);var G=L(M).then(function(){var A=X._addSchema(M,void 0,K);return A.validate||function f(T){try{return X._compile(T)}catch(m){if(m instanceof U)return I(m);throw m}function I(m){var h=m.missingSchema;if(l(h))throw new Error("Schema "+h+" is loaded but "+m.missingRef+" cannot be resolved");return m=X._loadingSchemas[h],m||(m=X._loadingSchemas[h]=X._opts.loadSchema(h)).then(a,a),m.then(function(t){if(!l(h))return L(t).then(function(){l(h)||X.addSchema(t,h,void 0,K)})}).then(function(){return f(T)});function a(){delete X._loadingSchemas[h]}function l(t){return X._refs[t]||X._schemas[t]}}}(A)});return j&&G.then(function(A){j(null,A)},j),G;function L(A){return A=A.$schema,A&&!X.getSchema(A)?k.call(X,{$ref:A},!0):Promise.resolve()}}ce.exports=k},5359:function(ce,g,D){var U=D(3969);function k(K,j,X){this.message=X||k.message(K,j),this.missingRef=U.url(K,j),this.missingSchema=U.normalizeId(U.fullPath(this.missingRef))}function M(K){return K.prototype=Object.create(Error.prototype),K.prototype.constructor=K}ce.exports={Validation:M(function(K){this.message="validation failed",this.errors=K,this.ajv=this.validation=!0}),MissingRef:M(k)},k.message=function(K,j){return"can't resolve reference "+j+" from id "+K}},3368:function(ce,g,j){var U=j(3724),k=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,M=[0,31,28,31,30,31,30,31,31,30,31,30,31],K=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i,j=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,X=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,G=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,L=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,A=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,f=/^(?:\/(?:[^~/]|~0|~1)*)*$/,T=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,I=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function m(n){return U.copy(m[n=n=="full"?"full":"fast"])}function h(i){var s,o,i=i.match(k);return!!i&&(s=+i[1],o=+i[2],i=+i[3],1<=o)&&o<=12&&1<=i&&i<=(o!=2||(i=s)%4!=0||i%100==0&&i%400!=0?M[o]:29)}function a(d,s){var o,i,c,d=d.match(K);return!!d&&(o=d[1],i=d[2],c=d[3],d=d[5],o<=23&&i<=59&&c<=59||o==23&&i==59&&c==60)&&(!s||d)}(ce.exports=m).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":G,url:L,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:j,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:e,uuid:A,"json-pointer":f,"json-pointer-uri-fragment":T,"relative-json-pointer":I},m.full={date:h,time:a,"date-time":function(n){return n=n.split(l),n.length==2&&h(n[0])&&a(n[1],!0)},uri:function(n){return t.test(n)&&X.test(n)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":G,url:L,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:j,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:e,uuid:A,"json-pointer":f,"json-pointer-uri-fragment":T,"relative-json-pointer":I};var l=/t|\s/i,t=/\/|:/,r=/[^\\]\\Z/;function e(n){if(r.test(n))return!1;try{return new RegExp(n),!0}catch{return!1}}},5689:function(ce,g,D){var U=D(3969),k=D(3724),M=D(5359),K=D(3508),j=D(1869),X=k.ucs2length,G=D(2303),L=M.Validation;function A(l,t,r,e){var n=this,s=this._opts,o=[void 0],i={},c=[],d={},C=[],p={},w=[],x=(t=t||{schema:l,refVal:o,refs:i},(function(z,te,E){var H=f.call(this,z,te,E);return 0<=H?{index:H,compiling:!0}:(H=this._compilations.length,this._compilations[H]={schema:z,root:te,baseId:E},{index:H,compiling:!1})}).call(this,l,t,e)),$=this._compilations[x.index];if(x.compiling)return $.callValidate=v;var P=this._formats,B=this.RULES;try{var Z=N(l,t,r,e),u=($.validate=Z,$.callValidate);return u&&(u.schema=Z.schema,u.errors=null,u.refs=Z.refs,u.refVal=Z.refVal,u.root=Z.root,u.$async=Z.$async,s.sourceCode)&&(u.source=Z.source),Z}finally{(function(z,te,E){z=f.call(this,z,te,E),0<=z&&this._compilations.splice(z,1)}).call(this,l,t,e)}function v(){var z=$.validate,te=z.apply(this,arguments);return v.errors=z.errors,te}function N(z,te,E,H){var V=!te||te.schema==z;if(te.schema!=t.schema)return A.call(n,z,te,E,H);E=z.$async===!0,H=j({isTop:!0,schema:z,isRoot:V,baseId:H,root:te,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:M.MissingRef,RULES:B,validate:j,util:k,resolve:U,resolveRef:y,usePattern:F,useDefault:Y,useCustomRule:Q,opts:s,formats:P,logger:n.logger,self:n}),H=a(o,m)+a(c,T)+a(C,I)+a(w,h)+H,s.processCode&&(H=s.processCode(H,z));try{var b=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",H)(n,B,P,t,o,C,w,G,X,L);o[0]=b}catch(S){throw n.logger.error("Error compiling schema, function code:",H),S}return b.schema=z,b.errors=null,b.refs=i,b.refVal=o,b.root=V?b:te,E&&(b.$async=!0),s.sourceCode===!0&&(b.source={code:H,patterns:c,defaults:C}),b}function y(z,te,S){te=U.url(z,te);var H=i[te];if(H!==void 0)return W(V=o[H],b="refVal["+H+"]");if(!S&&t.refs&&(H=t.refs[te],H!==void 0))return W(V=t.refVal[H],b=_(te,V));var V,b=_(te),S=U.call(n,N,t,te);if((S=S===void 0&&(H=r&&r[te])?U.inlineRef(H,s.inlineRefs)?H:A.call(n,H,t,r,z):S)!==void 0)return V=S,H=i[H=te],o[H]=V,W(S,b);delete i[te]}function _(z,te){var E=o.length;return o[E]=te,"refVal"+(i[z]=E)}function W(z,te){return typeof z=="object"||typeof z=="boolean"?{code:te,schema:z,inline:!0}:{code:te,$async:z&&!!z.$async}}function F(z){var te=d[z];return te===void 0&&(te=d[z]=c.length,c[te]=z),"pattern"+te}function Y(z){switch(typeof z){case"boolean":case"number":return""+z;case"string":return k.toQuotedString(z);case"object":var te,E;return z===null?"null":(te=K(z),(E=p[te])===void 0&&(E=p[te]=C.length,C[E]=z),"default"+E)}}function Q(z,te,E,H){if(n._opts.validateSchema!==!1){var b=z.definition.dependencies;if(b&&!b.every(function(J){return Object.prototype.hasOwnProperty.call(E,J)}))throw new Error("parent schema must have all required keywords: "+b.join(","));if(b=z.definition.validateSchema,b&&!b(te)){if(b="keyword schema is invalid: "+n.errorsText(b.errors),n._opts.validateSchema!="log")throw new Error(b);n.logger.error(b)}}var V,b=z.definition.compile,S=z.definition.inline,R=z.definition.macro;if(b)V=b.call(n,te,E,H);else if(R)V=R.call(n,te,E,H),s.validateSchema!==!1&&n.validateSchema(V,!0);else if(S)V=S.call(n,H,z.keyword,te,E);else if(!(V=z.definition.validate))return;if(V===void 0)throw new Error('custom keyword "'+z.keyword+'"failed to compile');return b=w.length,{code:"customRule"+b,validate:w[b]=V}}}function f(l,t,r){for(var e=0;e<this._compilations.length;e++){var n=this._compilations[e];if(n.schema==l&&n.root==t&&n.baseId==r)return e}return-1}function T(l,t){return"var pattern"+l+" = new RegExp("+k.toQuotedString(t[l])+");"}function I(l){return"var default"+l+" = defaults["+l+"];"}function m(l,t){return t[l]===void 0?"":"var refVal"+l+" = refVal["+l+"];"}function h(l){return"var customRule"+l+" = customRules["+l+"];"}function a(l,t){if(!l.length)return"";for(var r="",e=0;e<l.length;e++)r+=t(e,l);return r}ce.exports=A},3969:function(ce,g,D){var U=D(7533),k=D(2303),M=D(3724),K=D(4293),j=D(500);function X(t,r,e){var n,s,o,i=this._refs[e];if(typeof i=="string"){if(!this._refs[i])return X.call(this,t,r,i);i=this._refs[i]}return(i=i||this._schemas[e])instanceof K?T(i.schema,this._opts.inlineRefs)?i.schema:i.validate||this._compile(i):((i=G.call(this,r,e))&&(n=i.schema,r=i.root,o=i.baseId),n instanceof K?s=n.validate||t.call(this,n.schema,r,void 0,o):n!==void 0&&(s=T(n,this._opts.inlineRefs)?n:t.call(this,n,r,void 0,o)),s)}function G(t,r){var e=U.parse(r),n=m(e),s=I(this._getId(t.schema));if(Object.keys(t.schema).length===0||n!==s){var n=a(n),o=this._refs[n];if(typeof o=="string")return(function(c,d,C){d=G.call(this,c,d);{var p,w;if(d)return p=d.schema,w=d.baseId,c=d.root,(d=this._getId(p))&&(w=l(w,d)),A.call(this,C,w,p,c)}}).call(this,t,o,e);if(o instanceof K)o.validate||this._compile(o);else{if(!((o=this._schemas[n])instanceof K))return;if(o.validate||this._compile(o),n==a(r))return{schema:o,root:t,baseId:s}}if(!(t=o).schema)return;s=I(this._getId(t.schema))}return A.call(this,e,s,t.schema,t)}(ce.exports=X).normalizeId=a,X.fullPath=I,X.url=l,X.ids=function(t){var r=a(this._getId(t)),e={"":r},n={"":I(r,!1)},s={},o=this;return j(t,{allKeys:!0},function(i,c,d,C,p,w,x){if(c!==""){var $=o._getId(i),P=e[C],C=n[C]+"/"+p;if(x!==void 0&&(C+="/"+(typeof x=="number"?x:M.escapeFragment(x))),typeof $=="string"){if($=P=a(P?U.resolve(P,$):$),p=o._refs[$],(p=typeof p=="string"?o._refs[p]:p)&&p.schema){if(!k(i,p.schema))throw new Error('id "'+$+'" resolves to more than one schema')}else if($!=a(C))if($[0]=="#"){if(s[$]&&!k(i,s[$]))throw new Error('id "'+$+'" resolves to more than one schema');s[$]=i}else o._refs[$]=C}e[c]=P,n[c]=C}}),s},X.inlineRef=T,X.schema=G;var L=M.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function A(t,r,e,n){if(t.fragment=t.fragment||"",t.fragment.slice(0,1)=="/"){for(var s=t.fragment.split("/"),o=1;o<s.length;o++){var i=s[o];if(i){if((e=e[i=M.unescapeFragment(i)])===void 0)break;L[i]||((i=this._getId(e))&&(r=l(r,i)),e.$ref&&(i=l(r,e.$ref),i=G.call(this,n,i))&&(e=i.schema,n=i.root,r=i.baseId))}}return e!==void 0&&e!==n.schema?{schema:e,root:n,baseId:r}:void 0}}var f=M.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function T(t,r){return r!==!1&&(r===void 0||r===!0?function e(n){var s;if(Array.isArray(n)){for(var o=0;o<n.length;o++)if(typeof(s=n[o])=="object"&&!e(s))return!1}else for(var i in n)if(i=="$ref"||typeof(s=n[i])=="object"&&!e(s))return!1;return!0}(t):r?function e(n){var s,o=0;if(Array.isArray(n)){for(var i=0;i<n.length;i++)if(typeof(s=n[i])=="object"&&(o+=e(s)),o==1/0)return 1/0}else for(var c in n){if(c=="$ref")return 1/0;if(f[c])o++;else if(typeof(s=n[c])=="object"&&(o+=e(s)+1),o==1/0)return 1/0}return o}(t)<=r:void 0)}function I(t,r){return r!==!1&&(t=a(t)),m(U.parse(t))}function m(t){return U.serialize(t).split("#")[0]+"#"}var h=/#\/?$/;function a(t){return t?t.replace(h,""):""}function l(t,r){return r=a(r),U.resolve(t,r)}},742:function(ce,g,D){var U=D(9646),k=D(3724).toHash;ce.exports=function(){var M=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],K=["type","$comment"];return M.all=k(K),M.types=k(["number","integer","string","array","object","boolean","null"]),M.forEach(function(j){j.rules=j.rules.map(function(X){var G,L;return typeof X=="object"&&(L=X[G=Object.keys(X)[0]],X=G,L.forEach(function(A){K.push(A),M.all[A]=!0})),K.push(X),M.all[X]={keyword:X,code:U[X],implements:L}}),M.all.$comment={keyword:"$comment",code:U.$comment},j.type&&(M.types[j.type]=j)}),M.keywords=k(K.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),M.custom={},M}},4293:function(ce,g,D){var U=D(3724);ce.exports=function(k){U.copy(k,this)}},6887:function(ce){ce.exports=function(g){for(var D,U=0,k=g.length,M=0;M<k;)U++,55296<=(D=g.charCodeAt(M++))&&D<=56319&&M<k&&(64512&g.charCodeAt(M))==56320&&M++;return U}},3724:function(ce,g,D){function U(h,a,l,t){var r=t?" !== ":" === ",e=t?" || ":" && ",n=t?"!":"",s=t?"":"!";switch(h){case"null":return a+r+"null";case"array":return n+"Array.isArray("+a+")";case"object":return"("+n+a+e+"typeof "+a+r+'"object"'+e+s+"Array.isArray("+a+"))";case"integer":return"(typeof "+a+r+'"number"'+e+s+"("+a+" % 1)"+e+a+r+a+(l?e+n+"isFinite("+a+")":"")+")";case"number":return"(typeof "+a+r+'"'+h+'"'+(l?e+n+"isFinite("+a+")":"")+")";default:return"typeof "+a+r+'"'+h+'"'}}ce.exports={copy:function(h,a){for(var l in a=a||{},h)a[l]=h[l];return a},checkDataType:U,checkDataTypes:function(h,a,l){{if(h.length===1)return U(h[0],a,l,!0);var t,r="",h=M(h);for(t in h.array&&h.object&&(r=h.null?"(":"(!"+a+" || ",r+="typeof "+a+' !== "object")',delete h.null,delete h.array,delete h.object),h.number&&delete h.integer,h)r+=(r?" && ":"")+U(t,a,l,!0);return r}},coerceToTypes:function(h,a){{if(!Array.isArray(a))return k[a]?[a]:h==="array"&&a==="array"?["array"]:void 0;for(var l=[],t=0;t<a.length;t++){var r=a[t];(k[r]||h==="array"&&r==="array")&&(l[l.length]=r)}return l.length?l:void 0}},toHash:M,getProperty:X,escapeQuotes:G,equal:D(2303),ucs2length:D(6887),varOccurences:function(h,a){return a+="[^0-9]",h=h.match(new RegExp(a,"g")),h?h.length:0},varReplace:function(h,a,l){return a+="([^0-9])",l=l.replace(/\$/g,"$$$$"),h.replace(new RegExp(a,"g"),l+"$1")},schemaHasRules:function(h,a){if(typeof h=="boolean")return!h;for(var l in h)if(a[l])return!0},schemaHasRulesExcept:function(h,a,l){if(typeof h=="boolean")return!h&&l!="not";for(var t in h)if(t!=l&&a[t])return!0},schemaUnknownRules:function(h,a){if(typeof h!="boolean"){for(var l in h)if(!a[l])return l}},toQuotedString:L,getPathExpr:function(h,a,l,t){return T(h,l?"'/' + "+a+(t?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):t?"'[' + "+a+" + ']'":"'[\\'' + "+a+" + '\\']'")},getPath:function(h,a,l){return l=L(l?"/"+I(a):X(a)),T(h,l)},getData:function(h,a,l){var t,r,e;if(h==="")return"rootData";if(h[0]=="/"){if(!A.test(h))throw new Error("Invalid JSON-pointer: "+h);t=h,r="rootData"}else{if(!(e=h.match(f)))throw new Error("Invalid JSON-pointer: "+h);if(h=+e[1],(t=e[2])=="#"){if(a<=h)throw new Error("Cannot access property/index "+h+" levels up, current level is "+a);return l[a-h]}if(a<h)throw new Error("Cannot access data "+h+" levels up, current level is "+a);if(r="data"+(a-h||""),!t)return r}for(var n=r,s=t.split("/"),o=0;o<s.length;o++){var i=s[o];i&&(r+=X(m(i)),n+=" && "+r)}return n},unescapeFragment:function(h){return m(decodeURIComponent(h))},unescapeJsonPointer:m,escapeFragment:function(h){return encodeURIComponent(I(h))},escapeJsonPointer:I};var k=M(["string","number","integer","boolean","null"]);function M(h){for(var a={},l=0;l<h.length;l++)a[h[l]]=!0;return a}var K=/^[a-z$_][a-z$_0-9]*$/i,j=/'|\\/g;function X(h){return typeof h=="number"?"["+h+"]":K.test(h)?"."+h:"['"+G(h)+"']"}function G(h){return h.replace(j,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function L(h){return"'"+G(h)+"'"}var A=/^\/(?:[^~]|~0|~1)*$/,f=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function T(h,a){return h=='""'?a:(h+" + "+a).replace(/([^\\])' \+ '/g,"$1")}function I(h){return h.replace(/~/g,"~0").replace(/\//g,"~1")}function m(h){return h.replace(/~1/g,"/").replace(/~0/g,"~")}},9394:function(ce){var g=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];ce.exports=function(D,U){for(var k=0;k<U.length;k++){D=JSON.parse(JSON.stringify(D));for(var M=U[k].split("/"),K=D,j=1;j<M.length;j++)K=K[M[j]];for(j=0;j<g.length;j++){var X=g[j],G=K[X];G&&(K[X]={anyOf:[G,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]})}}return D}},5868:function(ce,g,D){D=D(6680),ce.exports={$id:"https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:D.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:D.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},1796:function(ce){ce.exports=function(g,D,U){var k,M,K,j,X,G=" ",L=g.level,A=g.dataLevel,f=g.schema[D],T=g.schemaPath+g.util.getProperty(D),I=g.errSchemaPath+"/"+D,m=!g.opts.allErrors,h="data"+(A||""),a=g.opts.$data&&f&&f.$data,l=a?(G+=" var schema"+L+" = "+g.util.getData(f.$data,A,g.dataPathArr)+"; ","schema"+L):f,t=D=="maximum",r=t?"exclusiveMaximum":"exclusiveMinimum",e=g.schema[r],n=g.opts.$data&&e&&e.$data,s=t?"<":">",o=t?">":"<",i=void 0;if(!a&&typeof f!="number"&&f!==void 0)throw new Error(D+" must be number");if(!n&&e!==void 0&&typeof e!="number"&&typeof e!="boolean")throw new Error(r+" must be number or boolean");n?(A=g.util.getData(e.$data,A,g.dataPathArr),K="exclIsNumber"+L,j="' + "+(X="op"+L)+" + '",i=r,(c=c||[]).push(G=G+(" var schemaExcl"+L+" = "+A+"; ")+(" var "+(k="exclusive"+L)+"; var "+(M="exclType"+L)+" = typeof "+(A="schemaExcl"+L)+"; if ("+M+" != 'boolean' && "+M+" != 'undefined' && "+M+" != 'number') { ")),G="",g.createErrors!==!1?(G+=" { keyword: '"+(i||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(I)+" , params: {} ",g.opts.messages!==!1&&(G+=" , message: '"+r+" should be boolean' "),g.opts.verbose&&(G+=" , schema: validate.schema"+T+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+h+" "),G+=" } "):G+=" {} ",d=G,G=c.pop(),!g.compositeRule&&m?g.async?G+=" throw new ValidationError(["+d+"]); ":G+=" validate.errors = ["+d+"]; return false; ":G+=" var err = "+d+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+=" } else if ( ",a&&(G+=" ("+l+" !== undefined && typeof "+l+" != 'number') || "),G+=" "+M+" == 'number' ? ( ("+k+" = "+l+" === undefined || "+A+" "+s+"= "+l+") ? "+h+" "+o+"= "+A+" : "+h+" "+o+" "+l+" ) : ( ("+k+" = "+A+" === true) ? "+h+" "+o+"= "+l+" : "+h+" "+o+" "+l+" ) || "+h+" !== "+h+") { var op"+L+" = "+k+" ? '"+s+"' : '"+s+"='; ",f===void 0&&(I=g.errSchemaPath+"/"+(i=r),l=A,a=n)):(j=s,(K=typeof e=="number")&&a?(X="'"+j+"'",G+=" if ( ",a&&(G+=" ("+l+" !== undefined && typeof "+l+" != 'number') || "),G+=" ( "+l+" === undefined || "+e+" "+s+"= "+l+" ? "+h+" "+o+"= "+e+" : "+h+" "+o+" "+l+" ) || "+h+" !== "+h+") { "):(K&&f===void 0?(k=!0,I=g.errSchemaPath+"/"+(i=r),l=e,o+="="):(K&&(l=Math[t?"min":"max"](e,f)),e===(!K||l)?(k=!0,I=g.errSchemaPath+"/"+(i=r),o+="="):(k=!1,j+="=")),X="'"+j+"'",G+=" if ( ",a&&(G+=" ("+l+" !== undefined && typeof "+l+" != 'number') || "),G+=" "+h+" "+o+" "+l+" || "+h+" !== "+h+") { ")),i=i||D,(c=c||[]).push(G),G="",g.createErrors!==!1?(G+=" { keyword: '"+(i||"_limit")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(I)+" , params: { comparison: "+X+", limit: "+l+", exclusive: "+k+" } ",g.opts.messages!==!1&&(G=G+" , message: 'should be "+j+" "+(a?"' + "+l:l+"'")),g.opts.verbose&&(G=(G+=" , schema:  ")+(a?"validate.schema"+T:""+f)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+h+" "),G+=" } "):G+=" {} ";var c,d=G;return G=c.pop(),!g.compositeRule&&m?g.async?G+=" throw new ValidationError(["+d+"]); ":G+=" validate.errors = ["+d+"]; return false; ":G+=" var err = "+d+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+=" } ",m&&(G+=" else { "),G}},2407:function(ce){ce.exports=function(g,D,U){var k,M=" ",K=g.level,T=g.dataLevel,j=g.schema[D],X=g.schemaPath+g.util.getProperty(D),G=g.errSchemaPath+"/"+D,L=!g.opts.allErrors,A="data"+(T||""),f=g.opts.$data&&j&&j.$data,T=f?(M+=" var schema"+K+" = "+g.util.getData(j.$data,T,g.dataPathArr)+"; ","schema"+K):j;if(f||typeof j=="number")return M+="if ( ",f&&(M+=" ("+T+" !== undefined && typeof "+T+" != 'number') || "),(K=[]).push(M+=" "+A+".length "+((k=D)=="maxItems"?">":"<")+" "+T+") { "),M="",g.createErrors!==!1?(M+=" { keyword: '"+(k||"_limitItems")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { limit: "+T+" } ",g.opts.messages!==!1&&(M=(M=(M+=" , message: 'should NOT have ")+(D=="maxItems"?"more":"fewer")+" than ")+(f?"' + "+T+" + '":""+j)+" items' "),g.opts.verbose&&(M=(M+=" , schema:  ")+(f?"validate.schema"+X:""+j)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),M+=" } "):M+=" {} ",k=M,M=K.pop(),!g.compositeRule&&L?g.async?M+=" throw new ValidationError(["+k+"]); ":M+=" validate.errors = ["+k+"]; return false; ":M+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M+="} ",L&&(M+=" else { "),M;throw new Error(D+" must be number")}},1250:function(ce){ce.exports=function(g,D,U){var k,M=" ",K=g.level,T=g.dataLevel,j=g.schema[D],X=g.schemaPath+g.util.getProperty(D),G=g.errSchemaPath+"/"+D,L=!g.opts.allErrors,A="data"+(T||""),f=g.opts.$data&&j&&j.$data,T=f?(M+=" var schema"+K+" = "+g.util.getData(j.$data,T,g.dataPathArr)+"; ","schema"+K):j;if(f||typeof j=="number")return M+="if ( ",f&&(M+=" ("+T+" !== undefined && typeof "+T+" != 'number') || "),g.opts.unicode===!1?M+=" "+A+".length ":M+=" ucs2length("+A+") ",(K=[]).push(M+=" "+((k=D)=="maxLength"?">":"<")+" "+T+") { "),M="",g.createErrors!==!1?(M+=" { keyword: '"+(k||"_limitLength")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { limit: "+T+" } ",g.opts.messages!==!1&&(M=(M=(M+=" , message: 'should NOT be ")+(D=="maxLength"?"longer":"shorter")+" than ")+(f?"' + "+T+" + '":""+j)+" characters' "),g.opts.verbose&&(M=(M+=" , schema:  ")+(f?"validate.schema"+X:""+j)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),M+=" } "):M+=" {} ",k=M,M=K.pop(),!g.compositeRule&&L?g.async?M+=" throw new ValidationError(["+k+"]); ":M+=" validate.errors = ["+k+"]; return false; ":M+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M+="} ",L&&(M+=" else { "),M;throw new Error(D+" must be number")}},2596:function(ce){ce.exports=function(g,D,U){var k,M=" ",K=g.level,T=g.dataLevel,j=g.schema[D],X=g.schemaPath+g.util.getProperty(D),G=g.errSchemaPath+"/"+D,L=!g.opts.allErrors,A="data"+(T||""),f=g.opts.$data&&j&&j.$data,T=f?(M+=" var schema"+K+" = "+g.util.getData(j.$data,T,g.dataPathArr)+"; ","schema"+K):j;if(f||typeof j=="number")return M+="if ( ",f&&(M+=" ("+T+" !== undefined && typeof "+T+" != 'number') || "),(K=[]).push(M+=" Object.keys("+A+").length "+((k=D)=="maxProperties"?">":"<")+" "+T+") { "),M="",g.createErrors!==!1?(M+=" { keyword: '"+(k||"_limitProperties")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { limit: "+T+" } ",g.opts.messages!==!1&&(M=(M=(M+=" , message: 'should NOT have ")+(D=="maxProperties"?"more":"fewer")+" than ")+(f?"' + "+T+" + '":""+j)+" properties' "),g.opts.verbose&&(M=(M+=" , schema:  ")+(f?"validate.schema"+X:""+j)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),M+=" } "):M+=" {} ",k=M,M=K.pop(),!g.compositeRule&&L?g.async?M+=" throw new ValidationError(["+k+"]); ":M+=" validate.errors = ["+k+"]; return false; ":M+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M+="} ",L&&(M+=" else { "),M;throw new Error(D+" must be number")}},9486:function(ce){ce.exports=function(g,D,U){var k=" ",M=g.schema[D],K=g.schemaPath+g.util.getProperty(D),j=g.errSchemaPath+"/"+D,X=!g.opts.allErrors,G=g.util.copy(g),L="",A=(G.level++,"valid"+G.level),f=G.baseId,T=!0,I=M;if(I)for(var m,h=-1,a=I.length-1;h<a;)m=I[h+=1],(g.opts.strictKeywords?typeof m=="object"&&0<Object.keys(m).length||m===!1:g.util.schemaHasRules(m,g.RULES.all))&&(T=!1,G.schema=m,G.schemaPath=K+"["+h+"]",G.errSchemaPath=j+"/"+h,k+="  "+g.validate(G)+" ",G.baseId=f,X)&&(k+=" if ("+A+") { ",L+="}");return X&&(k+=T?" if (true) { ":" "+L.slice(0,-1)+" "),k}},5347:function(ce){ce.exports=function(g,X,U){var k=" ",A=g.level,G=g.dataLevel,M=g.schema[X],K=g.schemaPath+g.util.getProperty(X),j=g.errSchemaPath+"/"+X,X=!g.opts.allErrors,G="data"+(G||""),L="valid"+A,A="errs__"+A,f=g.util.copy(g),T="",I=(f.level++,"valid"+f.level);if(M.every(function(e){return g.opts.strictKeywords?typeof e=="object"&&0<Object.keys(e).length||e===!1:g.util.schemaHasRules(e,g.RULES.all)})){var m=f.baseId,h=(k+=" var "+A+" = errors; var "+L+" = false;  ",g.compositeRule),a=(g.compositeRule=f.compositeRule=!0,M);if(a)for(var l,t=-1,r=a.length-1;t<r;)l=a[t+=1],f.schema=l,f.schemaPath=K+"["+t+"]",f.errSchemaPath=j+"/"+t,k+="  "+g.validate(f)+" ",f.baseId=m,k+=" "+L+" = "+L+" || "+I+"; if (!"+L+") { ",T+="}";g.compositeRule=f.compositeRule=h,k+=" "+T+" if (!"+L+") {   var err =   ",g.createErrors!==!1?(k+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(j)+" , params: {} ",g.opts.messages!==!1&&(k+=" , message: 'should match some schema in anyOf' "),g.opts.verbose&&(k+=" , schema: validate.schema"+K+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+G+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&X&&(g.async?k+=" throw new ValidationError(vErrors); ":k+=" validate.errors = vErrors; return false; "),k+=" } else {  errors = "+A+"; if (vErrors !== null) { if ("+A+") vErrors.length = "+A+"; else vErrors = null; } ",g.opts.allErrors&&(k+=" } ")}else X&&(k+=" if (true) { ");return k}},923:function(ce){ce.exports=function(g,M,U){var k=" ",K=g.schema[M],M=g.errSchemaPath+"/"+M,K=(g.opts.allErrors,g.util.toQuotedString(K));return g.opts.$comment===!0?k+=" console.log("+K+");":typeof g.opts.$comment=="function"&&(k+=" self._opts.$comment("+K+", "+g.util.toQuotedString(M)+", validate.root.schema);"),k}},2617:function(ce){ce.exports=function(g,K,U){var T=" ",k=g.level,f=g.dataLevel,A=g.schema[K],M=g.schemaPath+g.util.getProperty(K),K=g.errSchemaPath+"/"+K,j=!g.opts.allErrors,X="data"+(f||""),G="valid"+k,L=g.opts.$data&&A&&A.$data,A=(L&&(T+=" var schema"+k+" = "+g.util.getData(A.$data,f,g.dataPathArr)+"; "),L||(T+=" var schema"+k+" = validate.schema"+M+";"),[]),f=(A.push(T+="var "+G+" = equal("+X+", schema"+k+"); if (!"+G+") {   "),T="",g.createErrors!==!1?(T+=" { keyword: 'const' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(K)+" , params: { allowedValue: schema"+k+" } ",g.opts.messages!==!1&&(T+=" , message: 'should be equal to constant' "),g.opts.verbose&&(T+=" , schema: validate.schema"+M+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+X+" "),T+=" } "):T+=" {} ",T),T=A.pop();return!g.compositeRule&&j?g.async?T+=" throw new ValidationError(["+f+"]); ":T+=" validate.errors = ["+f+"]; return false; ":T+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",T+=" }",j&&(T+=" else { "),T}},2119:function(ce){ce.exports=function(g,K,U){var l=" ",h=g.level,X=g.dataLevel,k=g.schema[K],M=g.schemaPath+g.util.getProperty(K),K=g.errSchemaPath+"/"+K,j=!g.opts.allErrors,X="data"+(X||""),G="valid"+h,L="errs__"+h,A=g.util.copy(g),f=(A.level++,"valid"+A.level),h="i"+h,T=A.dataLevel=g.dataLevel+1,I="data"+T,a=g.baseId,m=g.opts.strictKeywords?typeof k=="object"&&0<Object.keys(k).length||k===!1:g.util.schemaHasRules(k,g.RULES.all),h=(l+="var "+L+" = errors;var "+G+";",m?(G=g.compositeRule,g.compositeRule=A.compositeRule=!0,A.schema=k,A.schemaPath=M,A.errSchemaPath=K,l+=" var "+f+" = false; for (var "+h+" = 0; "+h+" < "+X+".length; "+h+"++) { ",A.errorPath=g.util.getPathExpr(g.errorPath,h,g.opts.jsonPointers,!0),k=X+"["+h+"]",A.dataPathArr[T]=h,T=g.validate(A),A.baseId=a,g.util.varOccurences(T,I)<2?l+=" "+g.util.varReplace(T,I,k)+" ":l+=" var "+I+" = "+k+"; "+T+" ",l+=" if ("+f+") break; }  ",g.compositeRule=A.compositeRule=G,l+="  if (!"+f+") {"):l+=" if ("+X+".length == 0) {",[]),a=(h.push(l),l="",g.createErrors!==!1?(l+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(K)+" , params: {} ",g.opts.messages!==!1&&(l+=" , message: 'should contain a valid item' "),g.opts.verbose&&(l+=" , schema: validate.schema"+M+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+X+" "),l+=" } "):l+=" {} ",l),l=h.pop();return!g.compositeRule&&j?g.async?l+=" throw new ValidationError(["+a+"]); ":l+=" validate.errors = ["+a+"]; return false; ":l+=" var err = "+a+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l+=" } else { ",m&&(l+="  errors = "+L+"; if (vErrors !== null) { if ("+L+") vErrors.length = "+L+"; else vErrors = null; } "),g.opts.allErrors&&(l+=" } "),l}},1793:function(ce){ce.exports=function(g,C,U){var k,M,K,j=" ",X=g.level,G=g.dataLevel,p=g.schema[C],L=g.schemaPath+g.util.getProperty(C),A=g.errSchemaPath+"/"+C,f=!g.opts.allErrors,T="data"+(G||""),I="valid"+X,m="errs__"+X,h=g.opts.$data&&p&&p.$data,a=h?(j+=" var schema"+X+" = "+g.util.getData(p.$data,G,g.dataPathArr)+"; ","schema"+X):p,l="definition"+X,t=this.definition,r="";if(h&&t.$data){var e="keywordValidate"+X,n=t.validateSchema;j+=" var "+l+" = RULES.custom['"+C+"'].definition; var "+e+" = "+l+".validate;"}else{if(!(c=g.useCustomRule(this,p,g.schema,g)))return;a="validate.schema"+L,e=c.code,k=t.compile,M=t.inline,K=t.macro}var s,o,i,c,d,C=e+".errors",p="i"+X,w="ruleErr"+X,x=t.async;if(x&&!g.async)throw new Error("async keyword in sync schema");return M||K||(j+=C+" = null;"),j+="var "+m+" = errors;var "+I+";",h&&t.$data&&(r+="}",j+=" if ("+a+" === undefined) { "+I+" = true; } else { ",n)&&(r+="}",j+=" "+I+" = "+l+".validateSchema("+a+"); if ("+I+") { "),M?t.statements?j+=" "+c.validate+" ":j+=" "+I+" = "+c.validate+"; ":K?(r="",(h=g.util.copy(g)).level++,s="valid"+h.level,h.schema=c.validate,h.schemaPath="",n=g.compositeRule,g.compositeRule=h.compositeRule=!0,l=g.validate(h).replace(/validate\.schema/g,e),g.compositeRule=h.compositeRule=n,j+=" "+l):((d=d||[]).push(j),j="",j+="  "+e+".call( ",g.opts.passContext?j+="this":j+="self",k||t.schema===!1?j+=" , "+T+" ":j+=" , "+a+" , "+T+" , validate.schema"+g.schemaPath+" ",j+=" , (dataPath || '')",g.errorPath!='""'&&(j+=" + "+g.errorPath),c=j+=" , "+(o=G?"data"+(G-1||""):"parentData")+" , "+(i=G?g.dataPathArr[G]:"parentDataProperty")+" , rootData )  ",j=d.pop(),t.errors===!1?(j+=" "+I+" = ",x&&(j+="await "),j+=c+"; "):j+=x?" var "+(C="customErrors"+X)+" = null; try { "+I+" = await "+c+"; } catch (e) { "+I+" = false; if (e instanceof ValidationError) "+C+" = e.errors; else throw e; } ":" "+C+" = null; "+I+" = "+c+"; "),t.modifying&&(j+=" if ("+o+") "+T+" = "+o+"["+i+"];"),j+=""+r,t.valid?f&&(j+=" if (true) { "):(j+=" if ( ",t.valid===void 0?j=j+" !"+(K?""+s:I):j+=" "+!t.valid+" ",h=this.keyword,(d=d||[]).push(j+=") { "),(d=d||[]).push(j=""),j="",g.createErrors!==!1?(j+=" { keyword: '"+(h||"custom")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(A)+" , params: { keyword: '"+this.keyword+"' } ",g.opts.messages!==!1&&(j+=` , message: 'should pass "`+this.keyword+`" keyword validation' `),g.opts.verbose&&(j+=" , schema: validate.schema"+L+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+T+" "),j+=" } "):j+=" {} ",n=j,j=d.pop(),!g.compositeRule&&f?g.async?j+=" throw new ValidationError(["+n+"]); ":j+=" validate.errors = ["+n+"]; return false; ":j+=" var err = "+n+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l=j,j=d.pop(),M?t.errors?t.errors!="full"&&(j+="  for (var "+p+"="+m+"; "+p+"<errors; "+p+"++) { var "+w+" = vErrors["+p+"]; if ("+w+".dataPath === undefined) "+w+".dataPath = (dataPath || '') + "+g.errorPath+"; if ("+w+".schemaPath === undefined) { "+w+'.schemaPath = "'+A+'"; } ',g.opts.verbose&&(j+=" "+w+".schema = "+a+"; "+w+".data = "+T+"; "),j+=" } "):t.errors===!1?j+=" "+l+" ":(j+=" if ("+m+" == errors) { "+l+" } else {  for (var "+p+"="+m+"; "+p+"<errors; "+p+"++) { var "+w+" = vErrors["+p+"]; if ("+w+".dataPath === undefined) "+w+".dataPath = (dataPath || '') + "+g.errorPath+"; if ("+w+".schemaPath === undefined) { "+w+'.schemaPath = "'+A+'"; } ',g.opts.verbose&&(j+=" "+w+".schema = "+a+"; "+w+".data = "+T+"; "),j+=" } } "):K?(j+="   var err =   ",g.createErrors!==!1?(j+=" { keyword: '"+(h||"custom")+"' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(A)+" , params: { keyword: '"+this.keyword+"' } ",g.opts.messages!==!1&&(j+=` , message: 'should pass "`+this.keyword+`" keyword validation' `),g.opts.verbose&&(j+=" , schema: validate.schema"+L+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+T+" "),j+=" } "):j+=" {} ",j+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&f&&(g.async?j+=" throw new ValidationError(vErrors); ":j+=" validate.errors = vErrors; return false; ")):t.errors===!1?j+=" "+l+" ":(j+=" if (Array.isArray("+C+")) { if (vErrors === null) vErrors = "+C+"; else vErrors = vErrors.concat("+C+"); errors = vErrors.length;  for (var "+p+"="+m+"; "+p+"<errors; "+p+"++) { var "+w+" = vErrors["+p+"]; if ("+w+".dataPath === undefined) "+w+".dataPath = (dataPath || '') + "+g.errorPath+";  "+w+'.schemaPath = "'+A+'";  ',g.opts.verbose&&(j+=" "+w+".schema = "+a+"; "+w+".data = "+T+"; "),j+=" } } else { "+l+" } "),j+=" } ",f&&(j+=" else { ")),j}},9115:function(ce){ce.exports=function(g,T,U){var k,M=" ",K=g.level,j=g.dataLevel,X=g.schema[T],G=g.schemaPath+g.util.getProperty(T),L=g.errSchemaPath+"/"+T,A=!g.opts.allErrors,f="data"+(j||""),T="errs__"+K,I=g.util.copy(g),m="",h=(I.level++,"valid"+I.level),a={},l={},t=g.opts.ownProperties;for(P in X)P!="__proto__"&&(Z=X[P],(k=Array.isArray(Z)?l:a)[P]=Z);var r=g.errorPath;for(P in M=M+("var "+T+" = errors;")+("var missing"+K+";"),l)if((k=l[P]).length){if(M+=" if ( "+f+g.util.getProperty(P)+" !== undefined ",t&&(M+=" && Object.prototype.hasOwnProperty.call("+f+", '"+g.util.escapeQuotes(P)+"') "),A){M+=" && ( ";var e=k;if(e)for(var n=-1,s=e.length-1;n<s;)C=e[n+=1],n&&(M+=" || "),M+=" ( ( "+($=f+(x=g.util.getProperty(C)))+" === undefined ",t&&(M+=" || ! Object.prototype.hasOwnProperty.call("+f+", '"+g.util.escapeQuotes(C)+"') "),M+=") && (missing"+K+" = "+g.util.toQuotedString(g.opts.jsonPointers?C:x)+") ) ";M+=")) {  ";var c="missing"+K,o="' + "+c+" + '",i=(g.opts._errorDataPathProperty&&(g.errorPath=g.opts.jsonPointers?g.util.getPathExpr(r,c,!0):r+" + "+c),i||[]),c=(i.push(M),M="",g.createErrors!==!1?(M+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(L)+" , params: { property: '"+g.util.escapeQuotes(P)+"', missingProperty: '"+o+"', depsCount: "+k.length+", deps: '"+g.util.escapeQuotes(k.length==1?k[0]:k.join(", "))+"' } ",g.opts.messages!==!1&&(M+=" , message: 'should have ",k.length==1?M+="property "+g.util.escapeQuotes(k[0]):M+="properties "+g.util.escapeQuotes(k.join(", ")),M+=" when property "+g.util.escapeQuotes(P)+" is present' "),g.opts.verbose&&(M+=" , schema: validate.schema"+G+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+f+" "),M+=" } "):M+=" {} ",M),M=i.pop();!g.compositeRule&&A?g.async?M+=" throw new ValidationError(["+c+"]); ":M+=" validate.errors = ["+c+"]; return false; ":M+=" var err = "+c+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{M+=" ) { ";var d=k;if(d)for(var C,p=-1,w=d.length-1;p<w;){C=d[p+=1];var x=g.util.getProperty(C),o=g.util.escapeQuotes(C),$=f+x;g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPath(r,C,g.opts.jsonPointers)),M+=" if ( "+$+" === undefined ",t&&(M+=" || ! Object.prototype.hasOwnProperty.call("+f+", '"+g.util.escapeQuotes(C)+"') "),M+=") {  var err =   ",g.createErrors!==!1?(M+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(L)+" , params: { property: '"+g.util.escapeQuotes(P)+"', missingProperty: '"+o+"', depsCount: "+k.length+", deps: '"+g.util.escapeQuotes(k.length==1?k[0]:k.join(", "))+"' } ",g.opts.messages!==!1&&(M+=" , message: 'should have ",k.length==1?M+="property "+g.util.escapeQuotes(k[0]):M+="properties "+g.util.escapeQuotes(k.join(", ")),M+=" when property "+g.util.escapeQuotes(P)+" is present' "),g.opts.verbose&&(M+=" , schema: validate.schema"+G+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+f+" "),M+=" } "):M+=" {} ",M+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}M+=" }   ",A&&(m+="}",M+=" else { ")}g.errorPath=r;var P,B=I.baseId;for(P in a){var Z=a[P];(g.opts.strictKeywords?typeof Z=="object"&&0<Object.keys(Z).length||Z===!1:g.util.schemaHasRules(Z,g.RULES.all))&&(M+=" "+h+" = true; if ( "+f+g.util.getProperty(P)+" !== undefined ",t&&(M+=" && Object.prototype.hasOwnProperty.call("+f+", '"+g.util.escapeQuotes(P)+"') "),M+=") { ",I.schema=Z,I.schemaPath=G+g.util.getProperty(P),I.errSchemaPath=L+"/"+g.util.escapeFragment(P),M+="  "+g.validate(I)+" ",I.baseId=B,M+=" }  ",A)&&(M+=" if ("+h+") { ",m+="}")}return A&&(M+="   "+m+" if ("+T+" == errors) {"),M}},9317:function(ce){ce.exports=function(g,K,U){var T=" ",k=g.level,A=g.dataLevel,f=g.schema[K],M=g.schemaPath+g.util.getProperty(K),K=g.errSchemaPath+"/"+K,j=!g.opts.allErrors,X="data"+(A||""),G="valid"+k,L=g.opts.$data&&f&&f.$data,f=(L&&(T+=" var schema"+k+" = "+g.util.getData(f.$data,A,g.dataPathArr)+"; "),"i"+k),A="schema"+k,A=(L||(T+=" var "+A+" = validate.schema"+M+";"),T+="var "+G+";",L&&(T+=" if (schema"+k+" === undefined) "+G+" = true; else if (!Array.isArray(schema"+k+")) "+G+" = false; else {"),T+=G+" = false;for (var "+f+"=0; "+f+"<"+A+".length; "+f+"++) if (equal("+X+", "+A+"["+f+"])) { "+G+" = true; break; }",L&&(T+="  }  "),[]),f=(A.push(T+=" if (!"+G+") {   "),T="",g.createErrors!==!1?(T+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(K)+" , params: { allowedValues: schema"+k+" } ",g.opts.messages!==!1&&(T+=" , message: 'should be equal to one of the allowed values' "),g.opts.verbose&&(T+=" , schema: validate.schema"+M+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+X+" "),T+=" } "):T+=" {} ",T),T=A.pop();return!g.compositeRule&&j?g.async?T+=" throw new ValidationError(["+f+"]); ":T+=" validate.errors = ["+f+"]; return false; ":T+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",T+=" }",j&&(T+=" else { "),T}},8327:function(ce){ce.exports=function(g,G,U){var k=" ",M=g.level,K=g.dataLevel,j=g.schema[G],X=g.schemaPath+g.util.getProperty(G),G=g.errSchemaPath+"/"+G,L=!g.opts.allErrors,A="data"+(K||"");if(g.opts.format===!1)L&&(k+=" if (true) { ");else{var f,T=g.opts.$data&&j&&j.$data,K=T?(k+=" var schema"+M+" = "+g.util.getData(j.$data,K,g.dataPathArr)+"; ","schema"+M):j,I=g.opts.unknownFormats,m=Array.isArray(I);if(T)k+=" var "+(f="format"+M)+" = formats["+K+"]; var "+(h="isObject"+M)+" = typeof "+f+" == 'object' && !("+f+" instanceof RegExp) && "+f+".validate; var "+(l="formatType"+M)+" = "+h+" && "+f+".type || 'string'; if ("+h+") { ",g.async&&(k+=" var async"+M+" = "+f+".async; "),k+=" "+f+" = "+f+".validate; } if (  ",T&&(k+=" ("+K+" !== undefined && typeof "+K+" != 'string') || "),k+=" (",I!="ignore"&&(k+=" ("+K+" && !"+f+" ",m&&(k+=" && self._opts.unknownFormats.indexOf("+K+") == -1 "),k+=") || "),k+=" ("+f+" && "+l+" == '"+U+"' && !(typeof "+f+" == 'function' ? ",g.async?k+=" (async"+M+" ? await "+f+"("+A+") : "+f+"("+A+")) ":k+=" "+f+"("+A+") ",k+=" : "+f+".test("+A+"))))) {";else{if(!(f=g.formats[j])){if(I=="ignore")return g.logger.warn('unknown format "'+j+'" ignored in schema at path "'+g.errSchemaPath+'"'),L&&(k+=" if (true) { "),k;if(m&&0<=I.indexOf(j))return L&&(k+=" if (true) { "),k;throw new Error('unknown format "'+j+'" is used in schema at path "'+g.errSchemaPath+'"')}var h,a,l=(h=typeof f=="object"&&!(f instanceof RegExp)&&f.validate)&&f.type||"string";if(h&&(a=f.async===!0,f=f.validate),l!=U)return L&&(k+=" if (true) { "),k;if(a){if(!g.async)throw new Error("async format in sync schema");k+=" if (!(await "+(t="formats"+g.util.getProperty(j)+".validate")+"("+A+"))) { "}else{k+=" if (! ";var t="formats"+g.util.getProperty(j);h&&(t+=".validate"),k=k+(typeof f=="function"?" "+t+"("+A+") ":" "+t+".test("+A+") ")+") { "}}M=[],m=(M.push(k),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'format' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { format:  ")+(T?""+K:""+g.util.toQuotedString(j))+"  } ",g.opts.messages!==!1&&(k=(k+=` , message: 'should match format "`)+(T?"' + "+K+" + '":""+g.util.escapeQuotes(j))+`"' `),g.opts.verbose&&(k=(k=(k+=" , schema:  ")+(T?"validate.schema"+X:""+g.util.toQuotedString(j)))+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),k+=" } "):k+=" {} ",k),k=M.pop(),!g.compositeRule&&L?g.async?k+=" throw new ValidationError(["+m+"]); ":k+=" validate.errors = ["+m+"]; return false; ":k+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } ",L&&(k+=" else { ")}return k}},5926:function(ce){ce.exports=function(g,G,U){var k,M=" ",K=g.level,A=g.dataLevel,j=g.schema[G],X=g.schemaPath+g.util.getProperty(G),G=g.errSchemaPath+"/"+G,L=!g.opts.allErrors,A="data"+(A||""),f="valid"+K,T="errs__"+K,I=g.util.copy(g),m=(I.level++,"valid"+I.level),h=g.schema.then,a=g.schema.else,h=h!==void 0&&(g.opts.strictKeywords?typeof h=="object"&&0<Object.keys(h).length||h===!1:g.util.schemaHasRules(h,g.RULES.all)),a=a!==void 0&&(g.opts.strictKeywords?typeof a=="object"&&0<Object.keys(a).length||a===!1:g.util.schemaHasRules(a,g.RULES.all)),l=I.baseId;return h||a?(I.createErrors=!1,I.schema=j,I.schemaPath=X,I.errSchemaPath=G,M+=" var "+T+" = errors; var "+f+" = true;  ",j=g.compositeRule,g.compositeRule=I.compositeRule=!0,M+="  "+g.validate(I)+" ",I.baseId=l,I.createErrors=!0,M+="  errors = "+T+"; if (vErrors !== null) { if ("+T+") vErrors.length = "+T+"; else vErrors = null; }  ",g.compositeRule=I.compositeRule=j,h?(M+=" if ("+m+") {  ",I.schema=g.schema.then,I.schemaPath=g.schemaPath+".then",I.errSchemaPath=g.errSchemaPath+"/then",M+="  "+g.validate(I)+" ",I.baseId=l,M+=" "+f+" = "+m+"; ",h&&a?M+=" var "+(k="ifClause"+K)+" = 'then'; ":k="'then'",M+=" } ",a&&(M+=" else { ")):M+=" if (!"+m+") { ",a&&(I.schema=g.schema.else,I.schemaPath=g.schemaPath+".else",I.errSchemaPath=g.errSchemaPath+"/else",M+="  "+g.validate(I)+" ",I.baseId=l,M+=" "+f+" = "+m+"; ",h&&a?M+=" var "+(k="ifClause"+K)+" = 'else'; ":k="'else'",M+=" } "),M+=" if (!"+f+") {   var err =   ",g.createErrors!==!1?(M+=" { keyword: 'if' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { failingKeyword: "+k+" } ",g.opts.messages!==!1&&(M+=` , message: 'should match "' + `+k+` + '" schema' `),g.opts.verbose&&(M+=" , schema: validate.schema"+X+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),M+=" } "):M+=" {} ",M+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&L&&(g.async?M+=" throw new ValidationError(vErrors); ":M+=" validate.errors = vErrors; return false; "),M+=" }   ",L&&(M+=" else { ")):L&&(M+=" if (true) { "),M}},9646:function(ce,g,D){ce.exports={$ref:D(2331),allOf:D(9486),anyOf:D(5347),$comment:D(923),const:D(2617),contains:D(2119),dependencies:D(9115),enum:D(9317),format:D(8327),if:D(5926),items:D(392),maximum:D(1796),minimum:D(1796),maxItems:D(2407),minItems:D(2407),maxLength:D(1250),minLength:D(1250),maxProperties:D(2596),minProperties:D(2596),multipleOf:D(6039),not:D(7946),oneOf:D(9344),pattern:D(9737),properties:D(2537),propertyNames:D(2127),required:D(1204),uniqueItems:D(1985),validate:D(1869)}},392:function(ce){ce.exports=function(g,L,U){var k=" ",m=g.level,A=g.dataLevel,M=g.schema[L],K=g.schemaPath+g.util.getProperty(L),j=g.errSchemaPath+"/"+L,X=!g.opts.allErrors,G="data"+(A||""),L="valid"+m,A="errs__"+m,f=g.util.copy(g),T="",I=(f.level++,"valid"+f.level),m="i"+m,h=f.dataLevel=g.dataLevel+1,a="data"+h,l=g.baseId;if(k+="var "+A+" = errors;var "+L+";",Array.isArray(M)){var t,r,e=g.schema.additionalItems,n=(e===!1&&(k+=" "+L+" = "+G+".length <= "+M.length+"; ",t=j,j=g.errSchemaPath+"/additionalItems",(r=r||[]).push(k+="  if (!"+L+") {   "),k="",g.createErrors!==!1?(k+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(j)+" , params: { limit: "+M.length+" } ",g.opts.messages!==!1&&(k+=" , message: 'should NOT have more than "+M.length+" items' "),g.opts.verbose&&(k+=" , schema: false , parentSchema: validate.schema"+g.schemaPath+" , data: "+G+" "),k+=" } "):k+=" {} ",L=k,k=r.pop(),!g.compositeRule&&X?g.async?k+=" throw new ValidationError(["+L+"]); ":k+=" validate.errors = ["+L+"]; return false; ":k+=" var err = "+L+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } ",j=t,X)&&(T+="}",k+=" else { "),M);if(n)for(var s=-1,o=n.length-1;s<o;){var i,c,d=n[s+=1];(g.opts.strictKeywords?typeof d=="object"&&0<Object.keys(d).length||d===!1:g.util.schemaHasRules(d,g.RULES.all))&&(k+=" "+I+" = true; if ("+G+".length > "+s+") { ",i=G+"["+s+"]",f.schema=d,f.schemaPath=K+"["+s+"]",f.errSchemaPath=j+"/"+s,f.errorPath=g.util.getPathExpr(g.errorPath,s,g.opts.jsonPointers,!0),f.dataPathArr[h]=s,c=g.validate(f),f.baseId=l,g.util.varOccurences(c,a)<2?k+=" "+g.util.varReplace(c,a,i)+" ":k+=" var "+a+" = "+i+"; "+c+" ",k+=" }  ",X)&&(k+=" if ("+I+") { ",T+="}")}typeof e=="object"&&(g.opts.strictKeywords?typeof e=="object"&&0<Object.keys(e).length||e===!1:g.util.schemaHasRules(e,g.RULES.all))&&(f.schema=e,f.schemaPath=g.schemaPath+".additionalItems",f.errSchemaPath=g.errSchemaPath+"/additionalItems",k+=" "+I+" = true; if ("+G+".length > "+M.length+") {  for (var "+m+" = "+M.length+"; "+m+" < "+G+".length; "+m+"++) { ",f.errorPath=g.util.getPathExpr(g.errorPath,m,g.opts.jsonPointers,!0),i=G+"["+m+"]",f.dataPathArr[h]=m,c=g.validate(f),f.baseId=l,g.util.varOccurences(c,a)<2?k+=" "+g.util.varReplace(c,a,i)+" ":k+=" var "+a+" = "+i+"; "+c+" ",X&&(k+=" if (!"+I+") break; "),k+=" } }  ",X)&&(k+=" if ("+I+") { ",T+="}")}else(g.opts.strictKeywords?typeof M=="object"&&0<Object.keys(M).length||M===!1:g.util.schemaHasRules(M,g.RULES.all))&&(f.schema=M,f.schemaPath=K,f.errSchemaPath=j,k+="  for (var "+m+" = 0; "+m+" < "+G+".length; "+m+"++) { ",f.errorPath=g.util.getPathExpr(g.errorPath,m,g.opts.jsonPointers,!0),i=G+"["+m+"]",f.dataPathArr[h]=m,c=g.validate(f),f.baseId=l,g.util.varOccurences(c,a)<2?k+=" "+g.util.varReplace(c,a,i)+" ":k+=" var "+a+" = "+i+"; "+c+" ",X&&(k+=" if (!"+I+") break; "),k+=" }");return X&&(k+=" "+T+" if ("+A+" == errors) {"),k}},6039:function(ce){ce.exports=function(g,D,U){var k=" ",M=g.level,f=g.dataLevel,K=g.schema[D],j=g.schemaPath+g.util.getProperty(D),X=g.errSchemaPath+"/"+D,G=!g.opts.allErrors,L="data"+(f||""),A=g.opts.$data&&K&&K.$data,f=A?(k+=" var schema"+M+" = "+g.util.getData(K.$data,f,g.dataPathArr)+"; ","schema"+M):K;if(!A&&typeof K!="number")throw new Error(D+" must be number");return k+="var division"+M+";if (",A&&(k+=" "+f+" !== undefined && ( typeof "+f+" != 'number' || "),k+=" (division"+M+" = "+L+" / "+f+", ",g.opts.multipleOfPrecision?k+=" Math.abs(Math.round(division"+M+") - division"+M+") > 1e-"+g.opts.multipleOfPrecision+" ":k+=" division"+M+" !== parseInt(division"+M+") ",k+=" ) ",A&&(k+="  )  "),D=[],D.push(k+=" ) {   "),k="",g.createErrors!==!1?(k+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(X)+" , params: { multipleOf: "+f+" } ",g.opts.messages!==!1&&(k=k+" , message: 'should be multiple of "+(A?"' + "+f:f+"'")),g.opts.verbose&&(k=(k+=" , schema:  ")+(A?"validate.schema"+j:""+K)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",M=k,k=D.pop(),!g.compositeRule&&G?g.async?k+=" throw new ValidationError(["+M+"]); ":k+=" validate.errors = ["+M+"]; return false; ":k+=" var err = "+M+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+="} ",G&&(k+=" else { "),k}},7946:function(ce){ce.exports=function(g,G,U){var k,M,K=" ",f=g.level,A=g.dataLevel,j=g.schema[G],X=g.schemaPath+g.util.getProperty(G),G=g.errSchemaPath+"/"+G,L=!g.opts.allErrors,A="data"+(A||""),f="errs__"+f,T=g.util.copy(g),I=(T.level++,"valid"+T.level);return(g.opts.strictKeywords?typeof j=="object"&&0<Object.keys(j).length||j===!1:g.util.schemaHasRules(j,g.RULES.all))?(T.schema=j,T.schemaPath=X,T.errSchemaPath=G,K+=" var "+f+" = errors;  ",j=g.compositeRule,g.compositeRule=T.compositeRule=!0,T.createErrors=!1,T.opts.allErrors&&(M=T.opts.allErrors,T.opts.allErrors=!1),K+=" "+g.validate(T)+" ",T.createErrors=!0,M&&(T.opts.allErrors=M),g.compositeRule=T.compositeRule=j,(k=k||[]).push(K+=" if ("+I+") {   "),K="",g.createErrors!==!1?(K+=" { keyword: 'not' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: {} ",g.opts.messages!==!1&&(K+=" , message: 'should NOT be valid' "),g.opts.verbose&&(K+=" , schema: validate.schema"+X+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),K+=" } "):K+=" {} ",M=K,K=k.pop(),!g.compositeRule&&L?g.async?K+=" throw new ValidationError(["+M+"]); ":K+=" validate.errors = ["+M+"]; return false; ":K+=" var err = "+M+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",K+=" } else {  errors = "+f+"; if (vErrors !== null) { if ("+f+") vErrors.length = "+f+"; else vErrors = null; } ",g.opts.allErrors&&(K+=" } ")):(K+="  var err =   ",g.createErrors!==!1?(K+=" { keyword: 'not' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: {} ",g.opts.messages!==!1&&(K+=" , message: 'should NOT be valid' "),g.opts.verbose&&(K+=" , schema: validate.schema"+X+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),K+=" } "):K+=" {} ",K+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",L&&(K+=" if (false) { ")),K}},9344:function(ce){ce.exports=function(g,X,U){var k=" ",l=g.level,G=g.dataLevel,M=g.schema[X],K=g.schemaPath+g.util.getProperty(X),j=g.errSchemaPath+"/"+X,X=!g.opts.allErrors,G="data"+(G||""),L="valid"+l,A="errs__"+l,f=g.util.copy(g),T="",I=(f.level++,"valid"+f.level),m=f.baseId,h="prevValid"+l,a="passingSchemas"+l,l=(k+="var "+A+" = errors , "+h+" = false , "+L+" = false , "+a+" = null; ",g.compositeRule),t=(g.compositeRule=f.compositeRule=!0,M);if(t)for(var r,e=-1,n=t.length-1;e<n;)r=t[e+=1],(g.opts.strictKeywords?typeof r=="object"&&0<Object.keys(r).length||r===!1:g.util.schemaHasRules(r,g.RULES.all))?(f.schema=r,f.schemaPath=K+"["+e+"]",f.errSchemaPath=j+"/"+e,k+="  "+g.validate(f)+" ",f.baseId=m):k+=" var "+I+" = true; ",e&&(k+=" if ("+I+" && "+h+") { "+L+" = false; "+a+" = ["+a+", "+e+"]; } else { ",T+="}"),k+=" if ("+I+") { "+L+" = "+h+" = true; "+a+" = "+e+"; }";return g.compositeRule=f.compositeRule=l,k+=T+"if (!"+L+") {   var err =   ",g.createErrors!==!1?(k+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(j)+" , params: { passingSchemas: "+a+" } ",g.opts.messages!==!1&&(k+=" , message: 'should match exactly one schema in oneOf' "),g.opts.verbose&&(k+=" , schema: validate.schema"+K+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+G+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&X&&(g.async?k+=" throw new ValidationError(vErrors); ":k+=" validate.errors = vErrors; return false; "),k+="} else {  errors = "+A+"; if (vErrors !== null) { if ("+A+") vErrors.length = "+A+"; else vErrors = null; }",g.opts.allErrors&&(k+=" } "),k}},9737:function(ce){ce.exports=function(g,K,U){var T=" ",f=g.level,L=g.dataLevel,k=g.schema[K],M=g.schemaPath+g.util.getProperty(K),K=g.errSchemaPath+"/"+K,j=!g.opts.allErrors,X="data"+(L||""),G=g.opts.$data&&k&&k.$data,L=G?(T+=" var schema"+f+" = "+g.util.getData(k.$data,L,g.dataPathArr)+"; ","schema"+f):k,f=G?"(new RegExp("+L+"))":g.usePattern(k),A=(T+="if ( ",G&&(T+=" ("+L+" !== undefined && typeof "+L+" != 'string') || "),[]),f=(A.push(T+=" !"+f+".test("+X+") ) {   "),T="",g.createErrors!==!1?(T=(T+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(K)+" , params: { pattern:  ")+(G?""+L:""+g.util.toQuotedString(k))+"  } ",g.opts.messages!==!1&&(T=(T+=` , message: 'should match pattern "`)+(G?"' + "+L+" + '":""+g.util.escapeQuotes(k))+`"' `),g.opts.verbose&&(T=(T=(T+=" , schema:  ")+(G?"validate.schema"+M:""+g.util.toQuotedString(k)))+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+X+" "),T+=" } "):T+=" {} ",T),T=A.pop();return!g.compositeRule&&j?g.async?T+=" throw new ValidationError(["+f+"]); ":T+=" validate.errors = ["+f+"]; return false; ":T+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",T+="} ",j&&(T+=" else { "),T}},2537:function(ce){ce.exports=function(g,f,U){var k,M=" ",K=g.level,e=g.dataLevel,j=g.schema[f],X=g.schemaPath+g.util.getProperty(f),G=g.errSchemaPath+"/"+f,L=!g.opts.allErrors,A="data"+(e||""),f="errs__"+K,T=g.util.copy(g),I="",m=(T.level++,"valid"+T.level),h="key"+K,a="idx"+K,l=T.dataLevel=g.dataLevel+1,t="data"+l,r="dataProperties"+K,e=Object.keys(j||{}).filter(P),n=g.schema.patternProperties||{},s=Object.keys(n).filter(P),o=g.schema.additionalProperties,i=e.length||s.length,c=o===!1,d=typeof o=="object"&&Object.keys(o).length,C=g.opts.removeAdditional,p=c||d||C,w=g.opts.ownProperties,x=g.baseId,$=g.schema.required;function P(xe){return xe!=="__proto__"}if($&&(!g.opts.$data||!$.$data)&&$.length<g.opts.loopRequired&&(k=g.util.toHash($)),M+="var "+f+" = errors;var "+m+" = true;",w&&(M+=" var "+r+" = undefined;"),p){if(M+=w?" "+r+" = "+r+" || Object.keys("+A+"); for (var "+a+"=0; "+a+"<"+r+".length; "+a+"++) { var "+h+" = "+r+"["+a+"]; ":" for (var "+h+" in "+A+") { ",i){if(M+=" var isAdditional"+K+" = !(false ",e.length)if(8<e.length)M+=" || validate.schema"+X+".hasOwnProperty("+h+") ";else{var B=e;if(B)for(var Z=-1,u=B.length-1;Z<u;)F=B[Z+=1],M+=" || "+h+" == "+g.util.toQuotedString(F)+" "}if(s.length){var v=s;if(v)for(var N=-1,y=v.length-1;N<y;)J=v[N+=1],M+=" || "+g.usePattern(J)+".test("+h+") "}M+=" ); if (isAdditional"+K+") { "}C=="all"?M+=" delete "+A+"["+h+"]; ":(E=g.errorPath,$="' + "+h+" + '",g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPathExpr(g.errorPath,h,g.opts.jsonPointers)),c?C?M+=" delete "+A+"["+h+"]; ":(H=G,G=g.errSchemaPath+"/additionalProperties",(b=b||[]).push(M+=" "+m+" = false; "),M="",g.createErrors!==!1?(M+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { additionalProperty: '"+$+"' } ",g.opts.messages!==!1&&(M+=" , message: '",g.opts._errorDataPathProperty?M+="is an invalid additional property":M+="should NOT have additional properties",M+="' "),g.opts.verbose&&(M+=" , schema: false , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),M+=" } "):M+=" {} ",S=M,M=b.pop(),!g.compositeRule&&L?g.async?M+=" throw new ValidationError(["+S+"]); ":M+=" validate.errors = ["+S+"]; return false; ":M+=" var err = "+S+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G=H,L&&(M+=" break; ")):d&&(C=="failing"?(M+=" var "+f+" = errors;  ",p=g.compositeRule,g.compositeRule=T.compositeRule=!0,T.schema=o,T.schemaPath=g.schemaPath+".additionalProperties",T.errSchemaPath=g.errSchemaPath+"/additionalProperties",T.errorPath=g.opts._errorDataPathProperty?g.errorPath:g.util.getPathExpr(g.errorPath,h,g.opts.jsonPointers),me=A+"["+h+"]",T.dataPathArr[l]=h,ye=g.validate(T),T.baseId=x,g.util.varOccurences(ye,t)<2?M+=" "+g.util.varReplace(ye,t,me)+" ":M+=" var "+t+" = "+me+"; "+ye+" ",M+=" if (!"+m+") { errors = "+f+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+A+"["+h+"]; }  ",g.compositeRule=T.compositeRule=p):(T.schema=o,T.schemaPath=g.schemaPath+".additionalProperties",T.errSchemaPath=g.errSchemaPath+"/additionalProperties",T.errorPath=g.opts._errorDataPathProperty?g.errorPath:g.util.getPathExpr(g.errorPath,h,g.opts.jsonPointers),me=A+"["+h+"]",T.dataPathArr[l]=h,ye=g.validate(T),T.baseId=x,g.util.varOccurences(ye,t)<2?M+=" "+g.util.varReplace(ye,t,me)+" ":M+=" var "+t+" = "+me+"; "+ye+" ",L&&(M+=" if (!"+m+") break; "))),g.errorPath=E),i&&(M+=" } "),M+=" }  ",L&&(M+=" if ("+m+") { ",I+="}")}var _=g.opts.useDefaults&&!g.compositeRule;if(e.length){var W=e;if(W)for(var F,Y=-1,Q=W.length-1;Y<Q;){var z,te,E,H,V,b,S,R=j[F=W[Y+=1]];(g.opts.strictKeywords?typeof R=="object"&&0<Object.keys(R).length||R===!1:g.util.schemaHasRules(R,g.RULES.all))&&(me=A+(V=g.util.getProperty(F)),z=_&&R.default!==void 0,T.schema=R,T.schemaPath=X+V,T.errSchemaPath=G+"/"+g.util.escapeFragment(F),T.errorPath=g.util.getPath(g.errorPath,F,g.opts.jsonPointers),T.dataPathArr[l]=g.util.toQuotedString(F),ye=g.validate(T),T.baseId=x,g.util.varOccurences(ye,t)<2?(ye=g.util.varReplace(ye,t,me),te=me):M+=" var "+(te=t)+" = "+me+"; ",z?M+=" "+ye+" ":(k&&k[F]?(M+=" if ( "+te+" === undefined ",w&&(M+=" || ! Object.prototype.hasOwnProperty.call("+A+", '"+g.util.escapeQuotes(F)+"') "),M+=") { "+m+" = false; ",E=g.errorPath,H=G,V=g.util.escapeQuotes(F),g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPath(E,F,g.opts.jsonPointers)),G=g.errSchemaPath+"/required",(b=b||[]).push(M),M="",g.createErrors!==!1?(M+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { missingProperty: '"+V+"' } ",g.opts.messages!==!1&&(M+=" , message: '",g.opts._errorDataPathProperty?M+="is a required property":M+="should have required property \\'"+V+"\\'",M+="' "),g.opts.verbose&&(M+=" , schema: validate.schema"+X+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),M+=" } "):M+=" {} ",S=M,M=b.pop(),!g.compositeRule&&L?g.async?M+=" throw new ValidationError(["+S+"]); ":M+=" validate.errors = ["+S+"]; return false; ":M+=" var err = "+S+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G=H,g.errorPath=E,M+=" } else { "):L?(M+=" if ( "+te+" === undefined ",w&&(M+=" || ! Object.prototype.hasOwnProperty.call("+A+", '"+g.util.escapeQuotes(F)+"') "),M+=") { "+m+" = true; } else { "):(M+=" if ("+te+" !== undefined ",w&&(M+=" &&   Object.prototype.hasOwnProperty.call("+A+", '"+g.util.escapeQuotes(F)+"') "),M+=" ) { "),M+=" "+ye+" } ")),L&&(M+=" if ("+m+") { ",I+="}")}}if(s.length){var O=s;if(O)for(var J,re=-1,pe=O.length-1;re<pe;){var me,ye,R=n[J=O[re+=1]];(g.opts.strictKeywords?typeof R=="object"&&0<Object.keys(R).length||R===!1:g.util.schemaHasRules(R,g.RULES.all))&&(T.schema=R,T.schemaPath=g.schemaPath+".patternProperties"+g.util.getProperty(J),T.errSchemaPath=g.errSchemaPath+"/patternProperties/"+g.util.escapeFragment(J),M=(M+=w?" "+r+" = "+r+" || Object.keys("+A+"); for (var "+a+"=0; "+a+"<"+r+".length; "+a+"++) { var "+h+" = "+r+"["+a+"]; ":" for (var "+h+" in "+A+") { ")+" if ("+g.usePattern(J)+".test("+h+")) { ",T.errorPath=g.util.getPathExpr(g.errorPath,h,g.opts.jsonPointers),me=A+"["+h+"]",T.dataPathArr[l]=h,ye=g.validate(T),T.baseId=x,g.util.varOccurences(ye,t)<2?M+=" "+g.util.varReplace(ye,t,me)+" ":M+=" var "+t+" = "+me+"; "+ye+" ",L&&(M+=" if (!"+m+") break; "),M+=" } ",L&&(M+=" else "+m+" = true; "),M+=" }  ",L)&&(M+=" if ("+m+") { ",I+="}")}}return L&&(M+=" "+I+" if ("+f+" == errors) {"),M}},2127:function(ce){ce.exports=function(g,m,U){var k,M,K,j,X,G,L,A=" ",f=g.level,a=g.dataLevel,T=g.schema[m],I=g.schemaPath+g.util.getProperty(m),m=g.errSchemaPath+"/"+m,h=!g.opts.allErrors,a="data"+(a||""),l="errs__"+f,t=g.util.copy(g),r=(t.level++,"valid"+t.level);return A+="var "+l+" = errors;",(g.opts.strictKeywords?typeof T=="object"&&0<Object.keys(T).length||T===!1:g.util.schemaHasRules(T,g.RULES.all))&&(t.schema=T,t.schemaPath=I,t.errSchemaPath=m,T="idx"+f,M="i"+f,K="' + "+(k="key"+f)+" + '",j="data"+(t.dataLevel=g.dataLevel+1),L="dataProperties"+f,G=g.opts.ownProperties,X=g.baseId,G&&(A+=" var "+L+" = undefined; "),A=A+(G?" "+L+" = "+L+" || Object.keys("+a+"); for (var "+T+"=0; "+T+"<"+L+".length; "+T+"++) { var "+k+" = "+L+"["+T+"]; ":" for (var "+k+" in "+a+") { ")+" var startErrs"+f+" = errors; ",G=k,L=g.compositeRule,g.compositeRule=t.compositeRule=!0,T=g.validate(t),t.baseId=X,g.util.varOccurences(T,j)<2?A+=" "+g.util.varReplace(T,j,G)+" ":A+=" var "+j+" = "+G+"; "+T+" ",g.compositeRule=t.compositeRule=L,A+=" if (!"+r+") { for (var "+M+"=startErrs"+f+"; "+M+"<errors; "+M+"++) { vErrors["+M+"].propertyName = "+k+"; }   var err =   ",g.createErrors!==!1?(A+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(m)+" , params: { propertyName: '"+K+"' } ",g.opts.messages!==!1&&(A+=" , message: 'property name \\'"+K+"\\' is invalid' "),g.opts.verbose&&(A+=" , schema: validate.schema"+I+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+a+" "),A+=" } "):A+=" {} ",A+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!g.compositeRule&&h&&(g.async?A+=" throw new ValidationError(vErrors); ":A+=" validate.errors = vErrors; return false; "),h&&(A+=" break; "),A+=" } }"),h&&(A+="  if ("+l+" == errors) {"),A}},2331:function(ce){ce.exports=function(g,G,U){var k,M,K=" ",f=g.level,j=g.dataLevel,X=g.schema[G],G=g.errSchemaPath+"/"+G,L=!g.opts.allErrors,A="data"+(j||""),f="valid"+f;if(X=="#"||X=="#/")M=g.isRoot?(k=g.async,"validate"):(k=g.root.schema.$async===!0,"root.refVal[0]");else{var T=g.resolveRef(g.baseId,X,g.isRoot);if(T===void 0){var I=g.MissingRefError.message(g.baseId,X);if(g.opts.missingRefs=="fail")g.logger.error(I),(m=m||[]).push(K),K="",g.createErrors!==!1?(K+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { ref: '"+g.util.escapeQuotes(X)+"' } ",g.opts.messages!==!1&&(K+=" , message: 'can\\'t resolve reference "+g.util.escapeQuotes(X)+"' "),g.opts.verbose&&(K+=" , schema: "+g.util.toQuotedString(X)+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),K+=" } "):K+=" {} ",G=K,K=m.pop(),!g.compositeRule&&L?g.async?K+=" throw new ValidationError(["+G+"]); ":K+=" validate.errors = ["+G+"]; return false; ":K+=" var err = "+G+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",L&&(K+=" if (false) { ");else{if(g.opts.missingRefs!="ignore")throw new g.MissingRefError(g.baseId,X,I);g.logger.warn(I),L&&(K+=" if (true) { ")}}else T.inline?((G=g.util.copy(g)).level++,I="valid"+G.level,G.schema=T.schema,G.schemaPath="",G.errSchemaPath=X,K+=" "+g.validate(G).replace(/validate\.schema/g,T.code)+" ",L&&(K+=" if ("+I+") { ")):(k=T.$async===!0||g.async&&T.$async!==!1,M=T.code)}if(M){(m=m||[]).push(K),K="",g.opts.passContext?K+=" "+M+".call(this, ":K+=" "+M+"( ",K+=" "+A+", (dataPath || '')",g.errorPath!='""'&&(K+=" + "+g.errorPath);var m,X=j?"data"+(j-1||""):"parentData",G=K+=" , "+X+" , "+(j?g.dataPathArr[j]:"parentDataProperty")+", rootData)  ";if(K=m.pop(),k){if(!g.async)throw new Error("async schema referenced by sync schema");L&&(K+=" var "+f+"; "),K+=" try { await "+G+"; ",L&&(K+=" "+f+" = true; "),K+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",L&&(K+=" "+f+" = false; "),K+=" } ",L&&(K+=" if ("+f+") { ")}else K+=" if (!"+G+") { if (vErrors === null) vErrors = "+M+".errors; else vErrors = vErrors.concat("+M+".errors); errors = vErrors.length; } ",L&&(K+=" else { ")}return K}},1204:function(ce){ce.exports=function(g,G,U){var k=" ",M=g.level,T=g.dataLevel,K=g.schema[G],j=g.schemaPath+g.util.getProperty(G),X=g.errSchemaPath+"/"+G,G=!g.opts.allErrors,L="data"+(T||""),A="valid"+M,f=g.opts.$data&&K&&K.$data,T=(f&&(k+=" var schema"+M+" = "+g.util.getData(K.$data,T,g.dataPathArr)+"; "),"schema"+M);if(!f)if(K.length<g.opts.loopRequired&&g.schema.properties&&Object.keys(g.schema.properties).length){var I=[],m=K;if(m)for(var h=-1,a=m.length-1;h<a;){var l=m[h+=1],t=g.schema.properties[l];t&&(g.opts.strictKeywords?typeof t=="object"&&0<Object.keys(t).length||t===!1:g.util.schemaHasRules(t,g.RULES.all))||(I[I.length]=l)}}else I=K;if(f||I.length){var r=g.errorPath,K=f||I.length>=g.opts.loopRequired,e=g.opts.ownProperties;if(G){if(k+=" var missing"+M+"; ",K){f||(k+=" var "+T+" = validate.schema"+j+"; ");var n="' + "+(C="schema"+M+"["+(i="i"+M)+"]")+" + '";g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPathExpr(r,C,g.opts.jsonPointers)),k+=" var "+A+" = true; ",f&&(k+=" if (schema"+M+" === undefined) "+A+" = true; else if (!Array.isArray(schema"+M+")) "+A+" = false; else {"),k+=" for (var "+i+" = 0; "+i+" < "+T+".length; "+i+"++) { "+A+" = "+L+"["+T+"["+i+"]] !== undefined ",e&&(k+=" &&   Object.prototype.hasOwnProperty.call("+L+", "+T+"["+i+"]) "),k+="; if (!"+A+") break; } ",f&&(k+="  }  "),(d=d||[]).push(k+="  if (!"+A+") {   "),k="",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(X)+" , params: { missingProperty: '"+n+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+n+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+j+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ";var s=k,k=d.pop()}else{k+=" if ( ";var o=I;if(o)for(var i=-1,c=o.length-1;i<c;)w=o[i+=1],i&&(k+=" || "),k+=" ( ( "+(B=L+(P=g.util.getProperty(w)))+" === undefined ",e&&(k+=" || ! Object.prototype.hasOwnProperty.call("+L+", '"+g.util.escapeQuotes(w)+"') "),k+=") && (missing"+M+" = "+g.util.toQuotedString(g.opts.jsonPointers?w:P)+") ) ";k+=") {  ",n="' + "+(C="missing"+M)+" + '",g.opts._errorDataPathProperty&&(g.errorPath=g.opts.jsonPointers?g.util.getPathExpr(r,C,!0):r+" + "+C),(d=d||[]).push(k),k="",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(X)+" , params: { missingProperty: '"+n+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+n+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+j+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ";var d,s=k;k=d.pop()}!g.compositeRule&&G?g.async?k+=" throw new ValidationError(["+s+"]); ":k+=" validate.errors = ["+s+"]; return false; ":k+=" var err = "+s+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } else { "}else if(K){f||(k+=" var "+T+" = validate.schema"+j+"; ");var C,n="' + "+(C="schema"+M+"["+(i="i"+M)+"]")+" + '";g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPathExpr(r,C,g.opts.jsonPointers)),f&&(k+=" if ("+T+" && !Array.isArray("+T+")) {  var err =   ",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(X)+" , params: { missingProperty: '"+n+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+n+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+j+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+T+" !== undefined) { "),k+=" for (var "+i+" = 0; "+i+" < "+T+".length; "+i+"++) { if ("+L+"["+T+"["+i+"]] === undefined ",e&&(k+=" || ! Object.prototype.hasOwnProperty.call("+L+", "+T+"["+i+"]) "),k+=") {  var err =   ",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(X)+" , params: { missingProperty: '"+n+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+n+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+j+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",f&&(k+="  }  ")}else{var p=I;if(p)for(var w,x=-1,$=p.length-1;x<$;){w=p[x+=1];var P=g.util.getProperty(w),n=g.util.escapeQuotes(w),B=L+P;g.opts._errorDataPathProperty&&(g.errorPath=g.util.getPath(r,w,g.opts.jsonPointers)),k+=" if ( "+B+" === undefined ",e&&(k+=" || ! Object.prototype.hasOwnProperty.call("+L+", '"+g.util.escapeQuotes(w)+"') "),k+=") {  var err =   ",g.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(X)+" , params: { missingProperty: '"+n+"' } ",g.opts.messages!==!1&&(k+=" , message: '",g.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+n+"\\'",k+="' "),g.opts.verbose&&(k+=" , schema: validate.schema"+j+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+L+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}g.errorPath=r}else G&&(k+=" if (true) {");return k}},1985:function(ce){ce.exports=function(g,G,U){var k,M=" ",K=g.level,I=g.dataLevel,j=g.schema[G],X=g.schemaPath+g.util.getProperty(G),G=g.errSchemaPath+"/"+G,L=!g.opts.allErrors,A="data"+(I||""),f="valid"+K,T=g.opts.$data&&j&&j.$data,I=T?(M+=" var schema"+K+" = "+g.util.getData(j.$data,I,g.dataPathArr)+"; ","schema"+K):j;return(j||T)&&g.opts.uniqueItems!==!1?(T&&(M+=" var "+f+"; if ("+I+" === false || "+I+" === undefined) "+f+" = true; else if (typeof "+I+" != 'boolean') "+f+" = false; else { "),M+=" var i = "+A+".length , "+f+" = true , j; if (i > 1) { ",K=g.schema.items&&g.schema.items.type,I=Array.isArray(K),!K||K=="object"||K=="array"||I&&(0<=K.indexOf("object")||0<=K.indexOf("array"))?M+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+A+"[i], "+A+"[j])) { "+f+" = false; break outer; } } } ":(M=(M+=" var itemIndices = {}, item; for (;i--;) { var item = "+A+"[i]; ")+" if ("+g.util["checkDataType"+(I?"s":"")](K,"item",g.opts.strictNumbers,!0)+") continue; ",I&&(M+=` if (typeof item == 'string') item = '"' + item; `),M+=" if (typeof itemIndices[item] == 'number') { "+f+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "),M+=" } ",T&&(M+="  }  "),(k=k||[]).push(M+=" if (!"+f+") {   "),M="",g.createErrors!==!1?(M+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(G)+" , params: { i: i, j: j } ",g.opts.messages!==!1&&(M+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),g.opts.verbose&&(M=(M+=" , schema:  ")+(T?"validate.schema"+X:""+j)+"         , parentSchema: validate.schema"+g.schemaPath+" , data: "+A+" "),M+=" } "):M+=" {} ",K=M,M=k.pop(),!g.compositeRule&&L?g.async?M+=" throw new ValidationError(["+K+"]); ":M+=" validate.errors = ["+K+"]; return false; ":M+=" var err = "+K+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",M+=" } ",L&&(M+=" else { ")):L&&(M+=" if (true) { "),M}},1869:function(ce){ce.exports=function(g,D,U){var k="",M=g.schema.$async===!0,K=g.util.schemaHasRulesExcept(g.schema,g.RULES.all,"$ref"),j=g.self._getId(g.schema);if(g.opts.strictKeywords){var X=g.util.schemaUnknownRules(g.schema,g.RULES.keywords);if(X){if(X="unknown keyword: "+X,g.opts.strictKeywords!=="log")throw new Error(X);g.logger.warn(X)}}if(g.isTop&&(k+=" var validate = ",M&&(g.async=!0,k+="async "),k+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",j)&&(g.opts.sourceCode||g.opts.processCode)&&(k+=" /*# sourceURL="+j+" */ "),typeof g.schema=="boolean"||!K&&!g.schema.$ref)L=g.level,A=g.dataLevel,B=g.schema[D="false schema"],n=g.schemaPath+g.util.getProperty(D),s=g.errSchemaPath+"/"+D,m=!g.opts.allErrors,f="data"+(A||""),I="valid"+L,g.schema===!1?(g.isTop?m=!0:k+=" var "+I+" = false; ",(Y=Y||[]).push(k),k="",g.createErrors!==!1?(k+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: {} ",g.opts.messages!==!1&&(k+=" , message: 'boolean schema is false' "),g.opts.verbose&&(k+=" , schema: false , parentSchema: validate.schema"+g.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ",w=k,k=Y.pop(),!g.compositeRule&&m?g.async?k+=" throw new ValidationError(["+w+"]); ":k+=" validate.errors = ["+w+"]; return false; ":k+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "):g.isTop?k+=M?" return data; ":" validate.errors = null; return true; ":k+=" var "+I+" = true; ",g.isTop&&(k+=" }; return validate; ");else{if(g.isTop){var G=g.isTop,L=g.level=0,A=g.dataLevel=0,f="data";if(g.rootId=g.resolve.fullPath(g.self._getId(g.root.schema)),g.baseId=g.baseId||g.rootId,delete g.isTop,g.dataPathArr=[""],g.schema.default!==void 0&&g.opts.useDefaults&&g.opts.strictDefaults){var T="default is ignored in the schema root";if(g.opts.strictDefaults!=="log")throw new Error(T);g.logger.warn(T)}k=(k+=" var vErrors = null; ")+" var errors = 0;      if (rootData === undefined) rootData = data; "}else{if(L=g.level,f="data"+((A=g.dataLevel)||""),j&&(g.baseId=g.resolve.url(g.baseId,j)),M&&!g.async)throw new Error("async schema in sync schema");k+=" var errs_"+L+" = errors;"}var I="valid"+L,m=!g.opts.allErrors,h="",a="",l=g.schema.type,t=Array.isArray(l);if(l&&g.opts.nullable&&g.schema.nullable===!0&&(t?l.indexOf("null")==-1&&(l=l.concat("null")):l!="null"&&(l=[l,"null"],t=!0)),t&&l.length==1&&(l=l[0],t=!1),g.schema.$ref&&K){if(g.opts.extendRefs=="fail")throw new Error('$ref: validation keywords used in schema at path "'+g.errSchemaPath+'" (see option extendRefs)');g.opts.extendRefs!==!0&&(K=!1,g.logger.warn('$ref: keywords ignored in schema at path "'+g.errSchemaPath+'"'))}if(g.schema.$comment&&g.opts.$comment&&(k+=" "+g.RULES.all.$comment.code(g,"$comment")),l){g.opts.coerceTypes&&(r=g.util.coerceToTypes(g.opts.coerceTypes,l));var r,e=g.RULES.types[l];if(r||t||e===!0||e&&!H(e)){var n=g.schemaPath+".type",s=g.errSchemaPath+"/type",n=g.schemaPath+".type",s=g.errSchemaPath+"/type";if(k+=" if ("+g.util[t?"checkDataTypes":"checkDataType"](l,f,g.opts.strictNumbers,!0)+") { ",r){var o="dataType"+L,i="coerced"+L,c=(k+=" var "+o+" = typeof "+f+"; var "+i+" = undefined; ",g.opts.coerceTypes=="array"&&(k+=" if ("+o+" == 'object' && Array.isArray("+f+") && "+f+".length == 1) { "+f+" = "+f+"[0]; "+o+" = typeof "+f+"; if ("+g.util.checkDataType(g.schema.type,f,g.opts.strictNumbers)+") "+i+" = "+f+"; } "),k+=" if ("+i+" !== undefined) ; ",r);if(c)for(var d,C=-1,p=c.length-1;C<p;)(d=c[C+=1])=="string"?k+=" else if ("+o+" == 'number' || "+o+" == 'boolean') "+i+" = '' + "+f+"; else if ("+f+" === null) "+i+" = ''; ":d=="number"||d=="integer"?(k+=" else if ("+o+" == 'boolean' || "+f+" === null || ("+o+" == 'string' && "+f+" && "+f+" == +"+f+" ",d=="integer"&&(k+=" && !("+f+" % 1)"),k+=")) "+i+" = +"+f+"; "):d=="boolean"?k+=" else if ("+f+" === 'false' || "+f+" === 0 || "+f+" === null) "+i+" = false; else if ("+f+" === 'true' || "+f+" === 1) "+i+" = true; ":d=="null"?k+=" else if ("+f+" === '' || "+f+" === 0 || "+f+" === false) "+i+" = null; ":g.opts.coerceTypes=="array"&&d=="array"&&(k+=" else if ("+o+" == 'string' || "+o+" == 'number' || "+o+" == 'boolean' || "+f+" == null) "+i+" = ["+f+"]; ");(Y=Y||[]).push(k+=" else {   "),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: { type: '")+(t?""+l.join(","):""+l)+"' } ",g.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(t?""+l.join(","):""+l)+"' "),g.opts.verbose&&(k+=" , schema: validate.schema"+n+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ";var w=k,X=(k=Y.pop(),!g.compositeRule&&m?g.async?k+=" throw new ValidationError(["+w+"]); ":k+=" validate.errors = ["+w+"]; return false; ":k+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",A?"data"+(A-1||""):"parentData");k=k+(" } if ("+i+" !== undefined) {  ")+(" "+f+" = "+i+"; "),A||(k+="if ("+X+" !== undefined)"),k+=" "+X+"["+(A?g.dataPathArr[A]:"parentDataProperty")+"] = "+i+"; } "}else w=((Y=Y||[]).push(k),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: { type: '")+(t?""+l.join(","):""+l)+"' } ",g.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(t?""+l.join(","):""+l)+"' "),g.opts.verbose&&(k+=" , schema: validate.schema"+n+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ",k),k=Y.pop(),!g.compositeRule&&m?g.async?k+=" throw new ValidationError(["+w+"]); ":k+=" validate.errors = ["+w+"]; return false; ":k+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";k+=" } "}}if(g.schema.$ref&&!K)k+=" "+g.RULES.all.$ref.code(g,"$ref")+" ",m&&(k=(k+=" } if (errors === ")+(G?"0":"errs_"+L)+") { ",a+="}");else{var x=g.RULES;if(x){for(var $=-1,P=x.length-1;$<P;)if(H(e=x[$+=1])){if(e.type&&(k+=" if ("+g.util.checkDataType(e.type,f,g.opts.strictNumbers)+") { "),g.opts.useDefaults){if(e.type=="object"&&g.schema.properties){var B=g.schema.properties,Z=Object.keys(B);if(Z){for(var u,v=-1,N=Z.length-1;v<N;)if((W=B[u=Z[v+=1]]).default!==void 0){var y=f+g.util.getProperty(u);if(g.compositeRule){if(g.opts.strictDefaults){if(T="default is ignored for: "+y,g.opts.strictDefaults!=="log")throw new Error(T);g.logger.warn(T)}}else k+=" if ("+y+" === undefined ",g.opts.useDefaults=="empty"&&(k+=" || "+y+" === null || "+y+" === '' "),k+=" ) "+y+" = ",g.opts.useDefaults=="shared"?k+=" "+g.useDefault(W.default)+" ":k+=" "+JSON.stringify(W.default)+" ",k+="; "}}}else if(e.type=="array"&&Array.isArray(g.schema.items)){var _=g.schema.items;if(_){for(var W,C=-1,F=_.length-1;C<F;)if((W=_[C+=1]).default!==void 0)if(y=f+"["+C+"]",g.compositeRule){if(g.opts.strictDefaults){if(T="default is ignored for: "+y,g.opts.strictDefaults!=="log")throw new Error(T);g.logger.warn(T)}}else k+=" if ("+y+" === undefined ",g.opts.useDefaults=="empty"&&(k+=" || "+y+" === null || "+y+" === '' "),k+=" ) "+y+" = ",g.opts.useDefaults=="shared"?k+=" "+g.useDefault(W.default)+" ":k+=" "+JSON.stringify(W.default)+" ",k+="; "}}}var Y,Q=e.rules;if(Q)for(var z,te=-1,E=Q.length-1;te<E;)V(z=Q[te+=1])&&(z=z.code(g,z.keyword,e.type))&&(k+=" "+z+" ",m)&&(h+="}");m&&(k+=" "+h+" ",h=""),e.type&&(k+=" } ",l)&&l===e.type&&!r&&(k+=" else { ",n=g.schemaPath+".type",s=g.errSchemaPath+"/type",(Y=Y||[]).push(k),k="",g.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+g.errorPath+" , schemaPath: "+g.util.toQuotedString(s)+" , params: { type: '")+(t?""+l.join(","):""+l)+"' } ",g.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(t?""+l.join(","):""+l)+"' "),g.opts.verbose&&(k+=" , schema: validate.schema"+n+" , parentSchema: validate.schema"+g.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ",w=k,k=Y.pop(),!g.compositeRule&&m?g.async?k+=" throw new ValidationError(["+w+"]); ":k+=" validate.errors = ["+w+"]; return false; ":k+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } "),m&&(k=(k+=" if (errors === ")+(G?"0":"errs_"+L)+") { ",a+="}")}}}m&&(k+=" "+a+" "),G?k=k+(M?" if (errors === 0) return data;            else throw new ValidationError(vErrors); ":" validate.errors = vErrors;  return errors === 0;       ")+" }; return validate;":k+=" var "+I+" = errors === errs_"+L+";"}return k;function H(b){for(var S=b.rules,R=0;R<S.length;R++)if(V(S[R]))return 1}function V(b){return g.schema[b.keyword]!==void 0||b.implements&&function(S){for(var R=S.implements,O=0;O<R.length;O++)if(g.schema[R[O]]!==void 0)return 1}(b)}}},7931:function(ce,g,D){var U=/^[a-z_$][a-z0-9_$-]*$/i,k=D(1793),M=D(5868);function K(j,X){K.errors=null;var G=this._validateKeyword=this._validateKeyword||this.compile(M,!0);if(G(j))return!0;if(K.errors=G.errors,X)throw new Error("custom keyword definition is invalid: "+this.errorsText(G.errors));return!1}ce.exports={add:function(j,X){var G=this.RULES;if(G.keywords[j])throw new Error("Keyword "+j+" is already defined");if(!U.test(j))throw new Error("Keyword "+j+" is not a valid identifier");if(X){this.validateKeyword(X,!0);var L=X.type;if(Array.isArray(L))for(var A=0;A<L.length;A++)T(j,L[A],X);else T(j,L,X);var f=X.metaSchema;f&&(X.$data&&this._opts.$data&&(f={anyOf:[f,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]}),X.validateSchema=this.compile(f,!0))}function T(I,m,h){for(var a,l=0;l<G.length;l++){var t=G[l];if(t.type==m){a=t;break}}a||G.push(a={type:m,rules:[]}),h={keyword:I,definition:h,custom:!0,code:k,implements:h.implements},a.rules.push(h),G.custom[I]=h}return G.keywords[j]=G.all[j]=!0,this},get:function(j){var X=this.RULES.custom[j];return X?X.definition:this.RULES.keywords[j]||!1},remove:function(j){var X=this.RULES;delete X.keywords[j],delete X.all[j],delete X.custom[j];for(var G=0;G<X.length;G++)for(var L=X[G].rules,A=0;A<L.length;A++)if(L[A].keyword==j){L.splice(A,1);break}return this},validate:K}},2303:function(ce){ce.exports=function g(D,U){if(D===U)return!0;if(D&&U&&typeof D=="object"&&typeof U=="object"){if(D.constructor!==U.constructor)return!1;var k,M,K;if(Array.isArray(D)){if((k=D.length)!=U.length)return!1;for(M=k;M--!=0;)if(!g(D[M],U[M]))return!1}else{if(D.constructor===RegExp)return D.source===U.source&&D.flags===U.flags;if(D.valueOf!==Object.prototype.valueOf)return D.valueOf()===U.valueOf();if(D.toString!==Object.prototype.toString)return D.toString()===U.toString();if((k=(K=Object.keys(D)).length)!==Object.keys(U).length)return!1;for(M=k;M--!=0;)if(!Object.prototype.hasOwnProperty.call(U,K[M]))return!1;for(M=k;M--!=0;){var j=K[M];if(!g(D[j],U[j]))return!1}}return!0}return D!=D&&U!=U}},3508:function(ce){ce.exports=function(g,D){var U,k=typeof(D=typeof(D=D||{})=="function"?{cmp:D}:D).cycles=="boolean"&&D.cycles,M=D.cmp&&(U=D.cmp,function(j){return function(X,G){return X={key:X,value:j[X]},G={key:G,value:j[G]},U(X,G)}}),K=[];return function j(X){if((X=X&&X.toJSON&&typeof X.toJSON=="function"?X.toJSON():X)!==void 0){if(typeof X=="number")return isFinite(X)?""+X:"null";if(typeof X!="object")return JSON.stringify(X);if(Array.isArray(X)){for(A="[",f=0;f<X.length;f++)f&&(A+=","),A+=j(X[f])||"null";return A+"]"}if(X===null)return"null";if(K.indexOf(X)!==-1){if(k)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}for(var G=K.push(X)-1,L=Object.keys(X).sort(M&&M(X)),A="",f=0;f<L.length;f++){var T=L[f],I=j(X[T]);I&&(A&&(A+=","),A+=JSON.stringify(T)+":"+I)}return K.splice(G,1),"{"+A+"}"}}(g)}},233:function(ce){ce.exports=function g(L,A){function k(l){return g.insensitive&&(""+l).toLowerCase()||""+l}var M,K,m=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,I=/(^[ ]*|[ ]*$)/g,j=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,X=/^0x[0-9a-f]+$/i,G=/^0/,L=k(L).replace(I,"")||"",A=k(A).replace(I,"")||"",f=L.replace(m,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),T=A.replace(m,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),I=parseInt(L.match(X),16)||f.length!==1&&L.match(j)&&Date.parse(L),m=parseInt(A.match(X),16)||I&&A.match(j)&&Date.parse(A)||null;if(m){if(I<m)return-1;if(m<I)return 1}for(var h=0,a=Math.max(f.length,T.length);h<a;h++){if(M=!(f[h]||"").match(G)&&parseFloat(f[h])||f[h]||0,K=!(T[h]||"").match(G)&&parseFloat(T[h])||T[h]||0,isNaN(M)!==isNaN(K))return isNaN(M)?1:-1;if(typeof M!=typeof K&&(M+="",K+=""),M<K)return-1;if(K<M)return 1}return 0}},5156:function(ce,g){(function(D){function U(u){return u!==null&&Object.prototype.toString.call(u)==="[object Array]"}function k(u){return u!==null&&Object.prototype.toString.call(u)==="[object Object]"}function M(u,v){if(u!==v){if(Object.prototype.toString.call(u)!==Object.prototype.toString.call(v))return!1;if(U(u)===!0){if(u.length!==v.length)return!1;for(var N=0;N<u.length;N++)if(M(u[N],v[N])===!1)return!1}else{if(k(u)!==!0)return!1;var y,_,W={};for(y in u)if(hasOwnProperty.call(u,y)){if(M(u[y],v[y])===!1)return!1;W[y]=!0}for(_ in v)if(hasOwnProperty.call(v,_)&&W[_]!==!0)return!1}}return!0}function K(u){if(u===""||u===!1||u===null||U(u)&&u.length===0)return!0;if(k(u)){for(var v in u)if(u.hasOwnProperty(v))return!1;return!0}return!1}var j=typeof String.prototype.trimLeft=="function"?function(u){return u.trimLeft()}:function(u){return u.match(/^\s*(.*)/)[1]},X={0:"number",1:"any",2:"string",3:"array",4:"object",5:"boolean",6:"expression",7:"null",8:"Array<number>",9:"Array<string>"},G="UnquotedIdentifier",L="QuotedIdentifier",A="Rbracket",f="Rparen",T="Comma",I="Colon",m="Rbrace",h="Number",a="Current",l="Expref",t="Pipe",r="Flatten",e="Star",n="Filter",s="Lbrace",o="Lbracket",i="Lparen",c="Literal",d={".":"Dot","*":e,",":T,":":I,"{":s,"}":m,"]":A,"(":i,")":f,"@":a},C={"<":!0,">":!0,"=":!0,"!":!0},p={" ":!0,"	":!0,"\n":!0};function w(u){return"0"<=u&&u<="9"||u==="-"}function x(){}x.prototype={tokenize:function(u){var v,N,y=[];for(this._current=0;this._current<u.length;)if("a"<=(W=u[this._current])&&W<="z"||"A"<=W&&W<="Z"||W==="_")_=this._current,v=this._consumeUnquotedIdentifier(u),y.push({type:G,value:v,start:_});else if(d[u[this._current]]!==void 0)y.push({type:d[u[this._current]],value:u[this._current],start:this._current}),this._current++;else if(w(u[this._current]))N=this._consumeNumber(u),y.push(N);else if(u[this._current]==="[")N=this._consumeLBracket(u),y.push(N);else if(u[this._current]==='"')_=this._current,v=this._consumeQuotedIdentifier(u),y.push({type:L,value:v,start:_});else if(u[this._current]==="'")_=this._current,v=this._consumeRawStringLiteral(u),y.push({type:c,value:v,start:_});else if(u[this._current]==="`"){var _=this._current,W=this._consumeLiteral(u);y.push({type:c,value:W,start:_})}else if(C[u[this._current]]!==void 0)y.push(this._consumeOperator(u));else if(p[u[this._current]]!==void 0)this._current++;else if(u[this._current]==="&")_=this._current,this._current++,u[this._current]==="&"?(this._current++,y.push({type:"And",value:"&&",start:_})):y.push({type:l,value:"&",start:_});else{if(u[this._current]!=="|")throw(W=new Error("Unknown character:"+u[this._current])).name="LexerError",W;_=this._current,this._current++,u[this._current]==="|"?(this._current++,y.push({type:"Or",value:"||",start:_})):y.push({type:t,value:"|",start:_})}return y},_consumeUnquotedIdentifier:function(u){var v,N=this._current;for(this._current++;this._current<u.length&&("a"<=(v=u[this._current])&&v<="z"||"A"<=v&&v<="Z"||"0"<=v&&v<="9"||v==="_");)this._current++;return u.slice(N,this._current)},_consumeQuotedIdentifier:function(u){for(var v=this._current,N=(this._current++,u.length);u[this._current]!=='"'&&this._current<N;){var y=this._current;u[y]!=="\\"||u[y+1]!=="\\"&&u[y+1]!=='"'?y++:y+=2,this._current=y}return this._current++,JSON.parse(u.slice(v,this._current))},_consumeRawStringLiteral:function(u){for(var v=this._current,N=(this._current++,u.length);u[this._current]!=="'"&&this._current<N;){var y=this._current;u[y]!=="\\"||u[y+1]!=="\\"&&u[y+1]!=="'"?y++:y+=2,this._current=y}return this._current++,u.slice(v+1,this._current-1).replace("\\'","'")},_consumeNumber:function(u){for(var v=this._current,N=(this._current++,u.length);w(u[this._current])&&this._current<N;)this._current++;var y=parseInt(u.slice(v,this._current));return{type:h,value:y,start:v}},_consumeLBracket:function(u){var v=this._current;return this._current++,u[this._current]==="?"?(this._current++,{type:n,value:"[?",start:v}):u[this._current]==="]"?(this._current++,{type:r,value:"[]",start:v}):{type:o,value:"[",start:v}},_consumeOperator:function(u){var v=this._current,N=u[v];return this._current++,N==="!"?u[this._current]==="="?(this._current++,{type:"NE",value:"!=",start:v}):{type:"Not",value:"!",start:v}:N==="<"?u[this._current]==="="?(this._current++,{type:"LTE",value:"<=",start:v}):{type:"LT",value:"<",start:v}:N===">"?u[this._current]==="="?(this._current++,{type:"GTE",value:">=",start:v}):{type:"GT",value:">",start:v}:N==="="&&u[this._current]==="="?(this._current++,{type:"EQ",value:"==",start:v}):void 0},_consumeLiteral:function(u){this._current++;for(var v=this._current,N=u.length;u[this._current]!=="`"&&this._current<N;){var y=this._current;u[y]!=="\\"||u[y+1]!=="\\"&&u[y+1]!=="`"?y++:y+=2,this._current=y}return v=(v=j(u.slice(v,this._current))).replace("\\`","`"),v=this._looksLikeJSON(v)?JSON.parse(v):JSON.parse('"'+v+'"'),this._current++,v},_looksLikeJSON:function(u){if(u==="")return!1;if(0<='[{"'.indexOf(u[0])||0<=["true","false","null"].indexOf(u))return!0;if(!(0<="-0123456789".indexOf(u[0])))return!1;try{return JSON.parse(u),!0}catch{return!1}}};var $={};function P(){}function B(u){this.runtime=u}function Z(u){this._interpreter=u,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}$.EOF=0,$[G]=0,$[L]=0,$[A]=0,$[f]=0,$[T]=0,$[m]=0,$[h]=0,$[a]=0,$[l]=0,$.Pipe=1,$.Or=2,$.And=3,$.EQ=5,$.GT=5,$.LT=5,$.GTE=5,$.LTE=5,$.NE=5,$[r]=9,$.Star=20,$[n]=21,$.Dot=40,$.Not=45,$[s]=50,$[o]=55,$[i]=60,P.prototype={parse:function(N){this._loadTokens(N),this.index=0;var v,N=this.expression(0);if(this._lookahead(0)!=="EOF")throw v=this._lookaheadToken(0),(v=new Error("Unexpected token type: "+v.type+", value: "+v.value)).name="ParserError",v;return N},_loadTokens:function(u){var v=new x().tokenize(u);v.push({type:"EOF",value:"",start:u.length}),this.tokens=v},expression:function(u){for(var v=this._lookaheadToken(0),N=(this._advance(),this.nud(v)),y=this._lookahead(0);u<$[y];)this._advance(),N=this.led(y,N),y=this._lookahead(0);return N},_lookahead:function(u){return this.tokens[this.index+u].type},_lookaheadToken:function(u){return this.tokens[this.index+u]},_advance:function(){this.index++},nud:function(u){var v,N;switch(u.type){case c:return{type:"Literal",value:u.value};case G:return{type:"Field",name:u.value};case L:var y={type:"Field",name:u.value};if(this._lookahead(0)===i)throw new Error("Quoted identifier not allowed for function names.");return y;case"Not":return{type:"NotExpression",children:[v=this.expression($.Not)]};case e:return v=null,{type:"ValueProjection",children:[{type:"Identity"},v=this._lookahead(0)===A?{type:"Identity"}:this._parseProjectionRHS($.Star)]};case n:return this.led(u.type,{type:"Identity"});case s:return this._parseMultiselectHash();case r:return{type:"Projection",children:[{type:r,children:[{type:"Identity"}]},v=this._parseProjectionRHS($.Flatten)]};case o:return this._lookahead(0)===h||this._lookahead(0)===I?(v=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},v)):this._lookahead(0)===e&&this._lookahead(1)===A?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},v=this._parseProjectionRHS($.Star)]}):this._parseMultiselectList();case a:return{type:a};case l:return{type:"ExpressionReference",children:[N=this.expression($.Expref)]};case i:for(var _=[];this._lookahead(0)!==f;)this._lookahead(0)===a?(N={type:a},this._advance()):N=this.expression(0),_.push(N);return this._match(f),_[0];default:this._errorToken(u)}},led:function(u,v){var N;switch(u){case"Dot":var y=$.Dot;return this._lookahead(0)!==e?{type:"Subexpression",children:[v,N=this._parseDotRHS(y)]}:(this._advance(),{type:"ValueProjection",children:[v,N=this._parseProjectionRHS(y)]});case t:return N=this.expression($.Pipe),{type:t,children:[v,N]};case"Or":return{type:"OrExpression",children:[v,N=this.expression($.Or)]};case"And":return{type:"AndExpression",children:[v,N=this.expression($.And)]};case i:for(var _,y=v.name,W=[];this._lookahead(0)!==f;)this._lookahead(0)===a?(_={type:a},this._advance()):_=this.expression(0),this._lookahead(0)===T&&this._match(T),W.push(_);return this._match(f),{type:"Function",name:y,children:W};case n:return y=this.expression(0),this._match(A),{type:"FilterProjection",children:[v,N=this._lookahead(0)===r?{type:"Identity"}:this._parseProjectionRHS($.Filter),y]};case r:return{type:"Projection",children:[{type:r,children:[v]},this._parseProjectionRHS($.Flatten)]};case"EQ":case"NE":case"GT":case"GTE":case"LT":case"LTE":return this._parseComparator(v,u);case o:return y=this._lookaheadToken(0),y.type===h||y.type===I?(N=this._parseIndexExpression(),this._projectIfSlice(v,N)):(this._match(e),this._match(A),{type:"Projection",children:[v,N=this._parseProjectionRHS($.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(u){var v;if(this._lookahead(0)!==u)throw v=this._lookaheadToken(0),(u=new Error("Expected "+u+", got: "+v.type)).name="ParserError",u;this._advance()},_errorToken:function(u){throw u=new Error("Invalid token ("+u.type+'): "'+u.value+'"'),u.name="ParserError",u},_parseIndexExpression:function(){var u;return this._lookahead(0)===I||this._lookahead(1)===I?this._parseSliceExpression():(u={type:"Index",value:this._lookaheadToken(0).value},this._advance(),this._match(A),u)},_projectIfSlice:function(u,v){return u={type:"IndexExpression",children:[u,v]},v.type==="Slice"?{type:"Projection",children:[u,this._parseProjectionRHS($.Star)]}:u},_parseSliceExpression:function(){for(var u,v=[null,null,null],N=0,y=this._lookahead(0);y!==A&&N<3;){if(y===I)N++;else{if(y!==h)throw u=this._lookahead(0),(u=new Error("Syntax error, unexpected token: "+u.value+"("+u.type+")")).name="Parsererror",u;v[N]=this._lookaheadToken(0).value}this._advance(),y=this._lookahead(0)}return this._match(A),{type:"Slice",children:v}},_parseComparator:function(u,v){return{type:"Comparator",name:v,children:[u,this.expression($[v])]}},_parseDotRHS:function(u){var v=this._lookahead(0);return 0<=[G,L,e].indexOf(v)?this.expression(u):v===o?(this._match(o),this._parseMultiselectList()):v===s?(this._match(s),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(u){var v,N;if($[this._lookahead(0)]<10)v={type:"Identity"};else if(this._lookahead(0)===o)v=this.expression(u);else if(this._lookahead(0)===n)v=this.expression(u);else{if(this._lookahead(0)!=="Dot")throw N=this._lookaheadToken(0),(N=new Error("Sytanx error, unexpected token: "+N.value+"("+N.type+")")).name="ParserError",N;this._match("Dot"),v=this._parseDotRHS(u)}return v},_parseMultiselectList:function(){for(var u=[];this._lookahead(0)!==A;){var v=this.expression(0);if(u.push(v),this._lookahead(0)===T&&(this._match(T),this._lookahead(0)===A))throw new Error("Unexpected token Rbracket")}return this._match(A),{type:"MultiSelectList",children:u}},_parseMultiselectHash:function(){for(var u,v,N=[],y=[G,L];;){if(u=this._lookaheadToken(0),y.indexOf(u.type)<0)throw new Error("Expecting an identifier token, got: "+u.type);if(u=u.value,this._advance(),this._match(I),v=this.expression(0),N.push({type:"KeyValuePair",name:u,value:v}),this._lookahead(0)===T)this._match(T);else if(this._lookahead(0)===m){this._match(m);break}}return{type:"MultiSelectHash",children:N}}},B.prototype={search:function(u,v){return this.visit(u,v)},visit:function(u,v){var N,y,_,W,F,Y;switch(u.type){case"Field":return v!==null&&k(v)?(Q=v[u.name])===void 0?null:Q:null;case"Subexpression":for(H=this.visit(u.children[0],v),R=1;R<u.children.length;R++)if((H=this.visit(u.children[1],H))===null)return null;return H;case"IndexExpression":return F=this.visit(u.children[0],v),this.visit(u.children[1],F);case"Index":return U(v)?(H=v[Q=(Q=u.value)<0?v.length+Q:Q])===void 0?null:H:null;case"Slice":if(!U(v))return null;var Q=u.children.slice(0),Q=this.computeSliceParams(v.length,Q),z=Q[0],te=Q[1],E=Q[2],H=[];if(0<E)for(R=z;R<te;R+=E)H.push(v[R]);else for(R=z;te<R;R+=E)H.push(v[R]);return H;case"Projection":var V=this.visit(u.children[0],v);if(!U(V))return null;for(b=[],R=0;R<V.length;R++)(y=this.visit(u.children[1],V[R]))!==null&&b.push(y);return b;case"ValueProjection":if(!k(V=this.visit(u.children[0],v)))return null;for(var b=[],S=function(xe){for(var Ie=Object.keys(xe),we=[],Ae=0;Ae<Ie.length;Ae++)we.push(xe[Ie[Ae]]);return we}(V),R=0;R<S.length;R++)(y=this.visit(u.children[1],S[R]))!==null&&b.push(y);return b;case"FilterProjection":if(!U(V=this.visit(u.children[0],v)))return null;var O=[],J=[];for(R=0;R<V.length;R++)K(N=this.visit(u.children[2],V[R]))||O.push(V[R]);for(var re=0;re<O.length;re++)(y=this.visit(u.children[1],O[re]))!==null&&J.push(y);return J;case"Comparator":switch(_=this.visit(u.children[0],v),W=this.visit(u.children[1],v),u.name){case"EQ":H=M(_,W);break;case"NE":H=!M(_,W);break;case"GT":H=W<_;break;case"GTE":H=W<=_;break;case"LT":H=_<W;break;case"LTE":H=_<=W;break;default:throw new Error("Unknown comparator: "+u.name)}return H;case r:var pe=this.visit(u.children[0],v);if(!U(pe))return null;var me=[];for(R=0;R<pe.length;R++)U(y=pe[R])?me.push.apply(me,y):me.push(y);return me;case"Identity":return v;case"MultiSelectList":if(v===null)return null;for(b=[],R=0;R<u.children.length;R++)b.push(this.visit(u.children[R],v));return b;case"MultiSelectHash":if(v===null)return null;for(b={},R=0;R<u.children.length;R++)b[(Y=u.children[R]).name]=this.visit(Y.value,v);return b;case"OrExpression":return N=K(N=this.visit(u.children[0],v))?this.visit(u.children[1],v):N;case"AndExpression":return K(_=this.visit(u.children[0],v))===!0?_:this.visit(u.children[1],v);case"NotExpression":return K(_=this.visit(u.children[0],v));case"Literal":return u.value;case t:return F=this.visit(u.children[0],v),this.visit(u.children[1],F);case a:return v;case"Function":var ye=[];for(R=0;R<u.children.length;R++)ye.push(this.visit(u.children[R],v));return this.runtime.callFunction(u.name,ye);case"ExpressionReference":return Q=u.children[0],Q.jmespathType=l,Q;default:throw new Error("Unknown node type: "+u.type)}},computeSliceParams:function(u,N){var W=N[0],F=N[1],N=N[2],y=[null,null,null];if(N===null)N=1;else if(N===0)throw(_=new Error("Invalid slice, step cannot be 0")).name="RuntimeError",_;var _=N<0,W=W===null?_?u-1:0:this.capSliceRange(u,W,N),F=F===null?_?-1:u:this.capSliceRange(u,F,N);return y[0]=W,y[1]=F,y[2]=N,y},capSliceRange:function(u,v,N){return v<0?(v+=u)<0&&(v=N<0?-1:0):u<=v&&(v=N<0?u-1:u),v}},Z.prototype={callFunction:function(u,v){var N=this.functionTable[u];if(N===void 0)throw new Error("Unknown function: "+u+"()");return this._validateArgs(u,v,N._signature),N._func.call(this,v)},_validateArgs:function(u,v,N){var y;if(N[N.length-1].variadic){if(v.length<N.length)throw y=N.length===1?" argument":" arguments",new Error("ArgumentError: "+u+"() takes at least"+N.length+y+" but received "+v.length)}else if(v.length!==N.length)throw y=N.length===1?" argument":" arguments",new Error("ArgumentError: "+u+"() takes "+N.length+y+" but received "+v.length);for(var _=0;_<N.length;_++){for(var W,F=!1,Y=N[_].types,Q=this._getTypeName(v[_]),z=0;z<Y.length;z++)if(this._typeMatches(Q,Y[z],v[_])){F=!0;break}if(!F)throw W=Y.map(function(te){return X[te]}).join(","),new Error("TypeError: "+u+"() expected argument "+(_+1)+" to be type "+W+" but received type "+X[Q]+" instead.")}},_typeMatches:function(u,v,N){if(v===1)return!0;if(v!==9&&v!==8&&v!==3)return u===v;if(v===3)return u===3;if(u===3){var y;v===8?y=0:v===9&&(y=2);for(var _=0;_<N.length;_++)if(!this._typeMatches(this._getTypeName(N[_]),y,N[_]))return!1;return!0}},_getTypeName:function(u){switch(Object.prototype.toString.call(u)){case"[object String]":return 2;case"[object Number]":return 0;case"[object Array]":return 3;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return u.jmespathType===l?6:4}},_functionStartsWith:function(u){return u[0].lastIndexOf(u[1])===0},_functionEndsWith:function(N){var v=N[0],N=N[1];return v.indexOf(N,v.length-N.length)!==-1},_functionReverse:function(u){var v;if(this._getTypeName(u[0])!==2)return(v=u[0].slice(0)).reverse(),v;for(var N=u[0],y="",_=N.length-1;0<=_;_--)y+=N[_];return y},_functionAbs:function(u){return Math.abs(u[0])},_functionCeil:function(u){return Math.ceil(u[0])},_functionAvg:function(u){for(var v=0,N=u[0],y=0;y<N.length;y++)v+=N[y];return v/N.length},_functionContains:function(u){return 0<=u[0].indexOf(u[1])},_functionFloor:function(u){return Math.floor(u[0])},_functionLength:function(u){return(k(u[0])?Object.keys(u[0]):u[0]).length},_functionMap:function(u){for(var v=[],N=this._interpreter,y=u[0],_=u[1],W=0;W<_.length;W++)v.push(N.visit(y,_[W]));return v},_functionMerge:function(u){for(var v={},N=0;N<u.length;N++){var y,_=u[N];for(y in _)v[y]=_[y]}return v},_functionMax:function(u){if(0<u[0].length){if(this._getTypeName(u[0][0])===0)return Math.max.apply(Math,u[0]);for(var v=u[0],N=v[0],y=1;y<v.length;y++)N.localeCompare(v[y])<0&&(N=v[y]);return N}return null},_functionMin:function(u){if(0<u[0].length){if(this._getTypeName(u[0][0])===0)return Math.min.apply(Math,u[0]);for(var v=u[0],N=v[0],y=1;y<v.length;y++)v[y].localeCompare(N)<0&&(N=v[y]);return N}return null},_functionSum:function(u){for(var v=0,N=u[0],y=0;y<N.length;y++)v+=N[y];return v},_functionType:function(u){switch(this._getTypeName(u[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},_functionKeys:function(u){return Object.keys(u[0])},_functionValues:function(u){for(var v=u[0],N=Object.keys(v),y=[],_=0;_<N.length;_++)y.push(v[N[_]]);return y},_functionJoin:function(u){var v=u[0];return u[1].join(v)},_functionToArray:function(u){return this._getTypeName(u[0])===3?u[0]:[u[0]]},_functionToString:function(u){return this._getTypeName(u[0])===2?u[0]:JSON.stringify(u[0])},_functionToNumber:function(u){var v=this._getTypeName(u[0]);return v===0?u[0]:v!==2||(v=+u[0],isNaN(v))?null:v},_functionNotNull:function(u){for(var v=0;v<u.length;v++)if(this._getTypeName(u[v])!==7)return u[v];return null},_functionSort:function(u){return u=u[0].slice(0),u.sort(),u},_functionSortBy:function(u){var v=u[0].slice(0);if(v.length!==0){var N=this._interpreter,y=u[1],_=this._getTypeName(N.visit(y,v[0]));if([0,2].indexOf(_)<0)throw new Error("TypeError");for(var W=this,F=[],Y=0;Y<v.length;Y++)F.push([Y,v[Y]]);F.sort(function(z,te){var E=N.visit(y,z[1]),H=N.visit(y,te[1]);if(W._getTypeName(E)!==_)throw new Error("TypeError: expected "+_+", received "+W._getTypeName(E));if(W._getTypeName(H)!==_)throw new Error("TypeError: expected "+_+", received "+W._getTypeName(H));return H<E?1:E<H?-1:z[0]-te[0]});for(var Q=0;Q<F.length;Q++)v[Q]=F[Q][1]}return v},_functionMaxBy:function(u){for(var v,N,y=u[1],_=u[0],W=this.createKeyFunction(y,[0,2]),F=-1/0,Y=0;Y<_.length;Y++)F<(N=W(_[Y]))&&(F=N,v=_[Y]);return v},_functionMinBy:function(u){for(var v,N,y=u[1],_=u[0],W=this.createKeyFunction(y,[0,2]),F=1/0,Y=0;Y<_.length;Y++)(N=W(_[Y]))<F&&(F=N,v=_[Y]);return v},createKeyFunction:function(u,v){var N=this,y=this._interpreter;return function(F){var W,F=y.visit(u,F);if(v.indexOf(N._getTypeName(F))<0)throw W="TypeError: expected one of "+v+", received "+N._getTypeName(F),new Error(W);return F}}},D.tokenize=function(u){return new x().tokenize(u)},D.compile=function(u){return new P().parse(u)},D.search=function(u,v){var N=new P,y=new B(_=new Z),_=(_._interpreter=y,N.parse(v));return y.search(_,u)},D.strictDeepEqual=M})(g)},500:function(ce){var g=ce.exports=function(U,k,M){typeof k=="function"&&(M=k,k={}),function K(j,X,G,L,A,f,T,I,m,h){if(L&&typeof L=="object"&&!Array.isArray(L)){for(var a in X(L,A,f,T,I,m,h),L){var l=L[a];if(Array.isArray(l)){if(a in g.arrayKeywords)for(var t=0;t<l.length;t++)K(j,X,G,l[t],A+"/"+a+"/"+t,f,A,a,L,t)}else if(a in g.propsKeywords){if(l&&typeof l=="object")for(var r in l)K(j,X,G,l[r],A+"/"+a+"/"+D(r),f,A,a,L,r)}else(a in g.keywords||j.allKeys&&!(a in g.skipKeywords))&&K(j,X,G,l,A+"/"+a,f,A,a,L)}G(L,A,f,T,I,m,h)}}(k,typeof(M=k.cb||M)=="function"?M:M.pre||function(){},M.post||function(){},U,"",U)};function D(U){return U.replace(/~/g,"~0").replace(/\//g,"~1")}g.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},g.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},g.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},g.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},7026:function(ce,g){var D={b:"\b",f:"\f",n:`
`,r:"\r",t:"	",'"':'"',"/":"/","\\":"\\"},U="a".charCodeAt(),k=(g.parse=function(h,a,l){var t={},r=0,e=0,n=0,s=l&&l.bigint&&typeof BigInt<"u";return{data:o("",!0),pointers:t};function o(v,N){i(),x(v,"value");var y,_=C();switch(_){case"t":d("rue"),y=!0;break;case"f":d("alse"),y=!1;break;case"n":d("ull"),y=null;break;case'"':y=c();break;case"[":y=function(W){i();var F=[],Y=0;if(C()!="]")for(p();;){F.push(o(W+"/"+Y)),i();var Q=C();if(Q=="]")break;Q!=","&&Z(),i(),Y++}return F}(v);break;case"{":y=function(W){i();var F={};if(C()!="}")for(p();;){var z=P(),Y=(C()!='"'&&Z(),c()),Q=W+"/"+m(Y),z=($(Q,"key",z),x(Q,"keyEnd"),i(),C()!=":"&&Z(),i(),F[Y]=o(Q),i(),C());if(z=="}")break;z!=","&&Z(),i()}return F}(v);break;default:p(),0<="-0123456789".indexOf(_)?y=function(){var W="",F=!0;h[n]=="-"&&(W+=C()),W+=(h[n]=="0"?C:w)(),h[n]=="."&&(W+=C()+w(),F=!1),h[n]!="e"&&h[n]!="E"||(W+=C(),h[n]!="+"&&h[n]!="-"||(W+=C()),W+=w(),F=!1);var Y=+W;return s&&F&&(Y>Number.MAX_SAFE_INTEGER||Y<Number.MIN_SAFE_INTEGER)?BigInt(W):Y}():B()}return x(v,"valueEnd"),i(),N&&n<h.length&&B(),y}function i(){e:for(;n<h.length;){switch(h[n]){case" ":e++;break;case"	":e+=4;break;case"\r":e=0;break;case`
`:e=0,r++;break;default:break e}n++}}function c(){for(var v,N="";(v=C())!='"';)v=="\\"?(v=C())in D?N+=D[v]:v=="u"?N+=function(){for(var y=4,_=0;y--;){_<<=4;var W=C().toLowerCase();"a"<=W&&W<="f"?_+=W.charCodeAt()-U+10:"0"<=W&&W<="9"?_+=+W:Z()}return String.fromCharCode(_)}():Z():N+=v;return N}function d(v){for(var N=0;N<v.length;N++)C()!==v[N]&&Z()}function C(){u();var v=h[n];return n++,e++,v}function p(){n--,e--}function w(){for(var v="";"0"<=h[n]&&h[n]<="9";)v+=C();if(v.length)return v;u(),B()}function x(v,N){$(v,N,P())}function $(v,N,y){t[v]=t[v]||{},t[v][N]=y}function P(){return{line:r,column:e,pos:n}}function B(){throw new SyntaxError("Unexpected token "+h[n]+" in JSON at position "+n)}function Z(){p(),B()}function u(){if(n>=h.length)throw new SyntaxError("Unexpected end of JSON input")}},g.stringify=function(h,a,l){if(M(h)){var t=0;switch(typeof(e=typeof l=="object"?l.space:l)){case"number":var r=10<e?10:e<0?0:Math.floor(e),e=r&&B(r," "),n=r,s=r;break;case"string":e=e.slice(0,10);for(var o=s=n=0;o<e.length;o++){switch(e[o]){case" ":s++;break;case"	":s+=4;break;case"\r":s=0;break;case`
`:s=0,t++;break;default:throw new Error("whitespace characters not allowed in JSON")}n++}break;default:e=void 0}var i="",c={},d=0,C=0,p=0,w=l&&l.es6&&typeof Map=="function";return function Z(u,v,N){switch(P(N,"value"),typeof u){case"number":case"bigint":case"boolean":x(""+u);break;case"string":x(f(u));break;case"object":u===null?x("null"):typeof u.toJSON=="function"?x(f(u.toJSON())):Array.isArray(u)?y():w?u.constructor.BYTES_PER_ELEMENT?y():u instanceof Map?W():u instanceof Set?W(!0):_():_()}P(N,"valueEnd");function y(){if(u.length){x("[");for(var F=v+1,Y=0;Y<u.length;Y++){Y&&x(","),$(F);var Q=M(u[Y])?u[Y]:null,z=N+"/"+Y;Z(Q,F,z)}$(v),x("]")}else x("[]")}function _(){var F=Object.keys(u);if(F.length){x("{");for(var Y=v+1,Q=0;Q<F.length;Q++){var z,te=F[Q],E=u[te];M(E)&&(Q&&x(","),z=N+"/"+m(te),$(Y),P(z,"key"),x(f(te)),P(z,"keyEnd"),x(":"),e&&x(" "),Z(E,Y,z))}$(v),x("}")}else x("{}")}function W(F){if(u.size){x("{");for(var Y=v+1,Q=!0,z=u.entries(),te=z.next();!te.done;){var E,V=te.value,H=V[0],V=!!F||V[1];M(V)&&(Q||x(","),Q=!1,E=N+"/"+m(H),$(Y),P(E,"key"),x(f(H)),P(E,"keyEnd"),x(":"),e&&x(" "),Z(V,Y,E)),te=z.next()}$(v),x("}")}else x("{}")}}(h,0,""),{json:i,pointers:c}}function x(Z){C+=Z.length,p+=Z.length,i+=Z}function $(Z){if(e){for(i+=`
`+B(Z,e),d++,C=0;Z--;)t?(d+=t,C=s):C+=s,p+=n;p+=1}}function P(Z,u){c[Z]=c[Z]||{},c[Z][u]={line:d,column:C,pos:p}}function B(Z,u){return Array(Z+1).join(u)}},["number","bigint","boolean","string","object"]);function M(h){return 0<=k.indexOf(typeof h)}var K=/"|\\/g,j=/[\b]/g,X=/\f/g,G=/\n/g,L=/\r/g,A=/\t/g;function f(h){return'"'+(h=h.replace(K,"\\$&").replace(X,"\\f").replace(j,"\\b").replace(G,"\\n").replace(L,"\\r").replace(A,"\\t"))+'"'}var T=/~/g,I=/\//g;function m(h){return h.replace(T,"~0").replace(I,"~1")}},483:function(ce,g){var D,U;(function(){U=[],(U=typeof(D=function(){function k(l){return typeof Node=="object"?l instanceof Node:l&&typeof l=="object"&&typeof l.nodeType=="number"}function M(l){return typeof l=="string"}function K(){var l=[];return{watch:l.push.bind(l),trigger:function(t,r){for(var e=!0,n={detail:r,preventDefault:function(){e=!1}},s=0;s<l.length;s++)l[s](t,n);return e}}}function j(l){return window.getComputedStyle(l).display==="none"}function X(l){this.elem=l}function G(l,t){return X.make(l("parent")).clazz("pico-overlay").clazz(l("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(l("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){l("overlayClose",!0)&&t()})}X.make=function(l,t){typeof l=="string"&&(l=document.querySelector(l));var r=document.createElement(t||"div");return(l||document.body).appendChild(r),new X(r)},X.prototype={child:function(l){return X.make(this.elem,l)},stylize:function(l){l=l||{},typeof l.opacity<"u"&&(l.filter="alpha(opacity="+l.opacity*100+")");for(var t in l)l.hasOwnProperty(t)&&(this.elem.style[t]=l[t]);return this},clazz:function(l){return this.elem.className+=" "+l,this},html:function(l){return k(l)?this.elem.appendChild(l):this.elem.innerHTML=l,this},onClick:function(l){return this.elem.addEventListener("click",l),this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(l,t){return t!==void 0&&this.elem.setAttribute(l,t),this},anyAncestor:function(l){for(var t=this.elem;t;){if(l(new X(t)))return!0;t=t.parentNode}return!1},isVisible:function(){return!j(this.elem)}};var L=1;function A(l,t){var r=l("width","auto");typeof r=="number"&&(r=""+r+"px");var e=l("modalId","pico-"+L++),n=X.make(l("parent")).clazz("pico-content").clazz(l("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:r,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(l("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(l("content")).attr("id",e).attr("role","dialog").attr("aria-labelledby",l("ariaLabelledBy")).attr("aria-describedby",l("ariaDescribedBy",e)).onClick(function(s){var o=new X(s.target).anyAncestor(function(i){return/\bpico-close\b/.test(i.elem.className)});o&&t()});return n}function f(l,t){if(t("closeButton",!0))return l.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function T(l){return function(){return l().elem}}var I=K(),m=K();function h(l,t){function r(i,c){var d=i.msMatchesSelector||i.webkitMatchesSelector||i.matches;return d.call(i,c)}function e(i){return j(i)||r(i,":disabled")||i.hasAttribute("contenteditable")?!1:i.hasAttribute("tabindex")||r(i,"input,select,textarea,button,a[href],area[href],iframe")}function n(i){for(var c=i.getElementsByTagName("*"),d=0;d<c.length;d++)if(e(c[d]))return c[d]}function s(i){for(var c=i.getElementsByTagName("*"),d=c.length;d--;)if(e(c[d]))return c[d]}var o;l.beforeShow(function(){o=document.activeElement}),l.afterShow(function(){if(t()){var c=n(l.modalElem());c&&c.focus()}}),l.afterClose(function(){t()&&o&&o.focus(),o=null}),m.watch(function(c){if(t()&&l.isVisible()){var d=n(l.modalElem()),C=s(l.modalElem()),p=c.shiftKey?d:C;p===document.activeElement&&((c.shiftKey?C:d).focus(),c.preventDefault())}})}function a(l,t){var r,e=new X(document.body);l.beforeShow(function(){r=e.elem.style.overflow,t()&&e.stylize({overflow:"hidden"})}),l.afterClose(function(){e.stylize({overflow:r})})}return document.documentElement.addEventListener("keydown",function(t){var r=t.which||t.keyCode;r===27?I.trigger():r===9&&m.trigger(t)}),function(t){(M(t)||k(t))&&(t={content:t});var r=K(),e=K(),n=K(),s=K(),o=K();function i(Z,u){var v=t[Z];return typeof v=="function"&&(v=v(u)),v===void 0?u:v}var c=B.bind(window,"modal"),d=B.bind(window,"overlay"),C=B.bind(window,"close"),p;function w(Z){d().hide(),c().hide(),o.trigger(p,Z)}function x(Z){s.trigger(p,Z)&&w(Z)}function $(Z){return function(){return Z.apply(this,arguments),p}}var P;function B(Z,u){if(!P){var v=A(i,x);P={modal:v,overlay:G(i,x),close:f(v,i)},r.trigger(p,u)}return P[Z]}return p={modalElem:T(c),closeElem:T(C),overlayElem:T(d),buildDom:$(B.bind(null,null)),isVisible:function(){return!!(P&&c&&c().isVisible())},show:function(Z){return e.trigger(p,Z)&&(d().show(),C(),c().show(),n.trigger(p,Z)),this},close:$(x),forceClose:$(w),destroy:function(){c().destroy(),d().destroy(),d=c=C=void 0},options:function(Z){Object.keys(Z).map(function(u){t[u]=Z[u]})},afterCreate:$(r.watch),beforeShow:$(e.watch),afterShow:$(n.watch),beforeClose:$(s.watch),afterClose:$(o.watch)},h(p,i.bind(null,"focus",!0)),a(p,i.bind(null,"bodyOverflow",!0)),I.watch(function(){i("escCloses",!0)&&p.isVisible()&&p.close()}),p}})=="function"?D.apply(g,U):D)!==void 0&&(ce.exports=U)})()},7533:function(ce,g){/** @license URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */(function(D){function U(){for(var se=arguments.length,q=Array(se),oe=0;oe<se;oe++)q[oe]=arguments[oe];if(q.length>1){q[0]=q[0].slice(0,-1);for(var de=q.length-1,ue=1;ue<de;++ue)q[ue]=q[ue].slice(1,-1);return q[de]=q[de].slice(1),q.join("")}else return q[0]}function k(se){return"(?:"+se+")"}function M(se){return se===void 0?"undefined":se===null?"null":Object.prototype.toString.call(se).split(" ").pop().split("]").shift().toLowerCase()}function K(se){return se.toUpperCase()}function j(se){return se!=null?se instanceof Array?se:typeof se.length!="number"||se.split||se.setInterval||se.call?[se]:Array.prototype.slice.call(se):[]}function X(se,q){var oe=se;if(q)for(var de in q)oe[de]=q[de];return oe}function G(se){var q="[A-Za-z]",oe="[0-9]",de=U(oe,"[A-Fa-f]"),ue=k(k("%[EFef]"+de+"%"+de+de+"%"+de+de)+"|"+k("%[89A-Fa-f]"+de+"%"+de+de)+"|"+k("%"+de+de)),Te="[\\:\\/\\?\\#\\[\\]\\@]",$e="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",Ge=U(Te,$e),Pe=se?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",Ze=se?"[\\uE000-\\uF8FF]":"[]",He=U(q,oe,"[\\-\\.\\_\\~]",Pe);k(q+U(q,oe,"[\\+\\-\\.]")+"*"),k(k(ue+"|"+U(He,$e,"[\\:]"))+"*");var Ve=k(k("25[0-5]")+"|"+k("2[0-4]"+oe)+"|"+k("1"+oe+oe)+"|"+k("0?[1-9]"+oe)+"|0?0?"+oe),Ke=k(Ve+"\\."+Ve+"\\."+Ve+"\\."+Ve),Me=k(de+"{1,4}"),Oe=k(k(Me+"\\:"+Me)+"|"+Ke),je=k(k(Me+"\\:")+"{6}"+Oe),De=k("\\:\\:"+k(Me+"\\:")+"{5}"+Oe),tt=k(k(Me)+"?\\:\\:"+k(Me+"\\:")+"{4}"+Oe),Ue=k(k(k(Me+"\\:")+"{0,1}"+Me)+"?\\:\\:"+k(Me+"\\:")+"{3}"+Oe),Qe=k(k(k(Me+"\\:")+"{0,2}"+Me)+"?\\:\\:"+k(Me+"\\:")+"{2}"+Oe),ot=k(k(k(Me+"\\:")+"{0,3}"+Me)+"?\\:\\:"+Me+"\\:"+Oe),nt=k(k(k(Me+"\\:")+"{0,4}"+Me)+"?\\:\\:"+Oe),Je=k(k(k(Me+"\\:")+"{0,5}"+Me)+"?\\:\\:"+Me),qe=k(k(k(Me+"\\:")+"{0,6}"+Me)+"?\\:\\:"),it=k([je,De,tt,Ue,Qe,ot,nt,Je,qe].join("|")),et=k(k(He+"|"+ue)+"+");k("[vV]"+de+"+\\."+U(He,$e,"[\\:]")+"+"),k(k(ue+"|"+U(He,$e))+"*");var rt=k(ue+"|"+U(He,$e,"[\\:\\@]"));return k(k(ue+"|"+U(He,$e,"[\\@]"))+"+"),k(k(rt+"|"+U("[\\/\\?]",Ze))+"*"),{NOT_SCHEME:new RegExp(U("[^]",q,oe,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(U("[^\\%\\:]",He,$e),"g"),NOT_HOST:new RegExp(U("[^\\%\\[\\]\\:]",He,$e),"g"),NOT_PATH:new RegExp(U("[^\\%\\/\\:\\@]",He,$e),"g"),NOT_PATH_NOSCHEME:new RegExp(U("[^\\%\\/\\@]",He,$e),"g"),NOT_QUERY:new RegExp(U("[^\\%]",He,$e,"[\\:\\@\\/\\?]",Ze),"g"),NOT_FRAGMENT:new RegExp(U("[^\\%]",He,$e,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(U("[^]",He,$e),"g"),UNRESERVED:new RegExp(He,"g"),OTHER_CHARS:new RegExp(U("[^\\%]",He,Ge),"g"),PCT_ENCODED:new RegExp(ue,"g"),IPV4ADDRESS:new RegExp("^("+Ke+")$"),IPV6ADDRESS:new RegExp("^\\[?("+it+")"+k(k("\\%25|\\%(?!"+de+"{2})")+"("+et+")")+"?\\]?$")}}var L=G(!1),A=G(!0),f=function(){function se(q,oe){var de=[],ue=!0,Te=!1,$e=void 0;try{for(var Ge=q[Symbol.iterator](),Pe;!(ue=(Pe=Ge.next()).done)&&(de.push(Pe.value),!(oe&&de.length===oe));ue=!0);}catch(Ze){Te=!0,$e=Ze}finally{try{!ue&&Ge.return&&Ge.return()}finally{if(Te)throw $e}}return de}return function(q,oe){if(Array.isArray(q))return q;if(Symbol.iterator in Object(q))return se(q,oe);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),T=function(se){if(Array.isArray(se)){for(var q=0,oe=Array(se.length);q<se.length;q++)oe[q]=se[q];return oe}else return Array.from(se)},I=2147483647,m=36,h=1,a=26,l=38,t=700,r=72,e=128,n="-",s=/^xn--/,o=/[^\0-\x7E]/,i=/[\x2E\u3002\uFF0E\uFF61]/g,c={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},d=m-h,C=Math.floor,p=String.fromCharCode;function w(se){throw new RangeError(c[se])}function x(se,q){for(var oe=[],de=se.length;de--;)oe[de]=q(se[de]);return oe}function $(se,q){var oe=se.split("@"),de="";oe.length>1&&(de=oe[0]+"@",se=oe[1]),se=se.replace(i,".");var ue=se.split("."),Te=x(ue,q).join(".");return de+Te}function P(se){for(var q=[],oe=0,de=se.length;oe<de;){var ue=se.charCodeAt(oe++);if(ue>=55296&&ue<=56319&&oe<de){var Te=se.charCodeAt(oe++);(Te&64512)==56320?q.push(((ue&1023)<<10)+(Te&1023)+65536):(q.push(ue),oe--)}else q.push(ue)}return q}var B=function(q){return q-48<10?q-22:q-65<26?q-65:q-97<26?q-97:m},Z=function(q,oe){return q+22+75*(q<26)-((oe!=0)<<5)},u=function(q,oe,de){var ue=0;for(q=de?C(q/t):q>>1,q+=C(q/oe);q>d*a>>1;ue+=m)q=C(q/d);return C(ue+(d+1)*q/(q+l))},v=function(q){var oe=[],de=q.length,ue=0,Te=e,$e=r,Ge=q.lastIndexOf(n);Ge<0&&(Ge=0);for(var Pe=0;Pe<Ge;++Pe)q.charCodeAt(Pe)>=128&&w("not-basic"),oe.push(q.charCodeAt(Pe));for(var Ze=Ge>0?Ge+1:0;Ze<de;){for(var He=ue,Ve=1,Ke=m;;Ke+=m){Ze>=de&&w("invalid-input");var Me=B(q.charCodeAt(Ze++));(Me>=m||Me>C((I-ue)/Ve))&&w("overflow"),ue+=Me*Ve;var Oe=Ke<=$e?h:Ke>=$e+a?a:Ke-$e;if(Me<Oe)break;var je=m-Oe;Ve>C(I/je)&&w("overflow"),Ve*=je}var De=oe.length+1;$e=u(ue-He,De,He==0),C(ue/De)>I-Te&&w("overflow"),Te+=C(ue/De),ue%=De,oe.splice(ue++,0,Te)}return String.fromCodePoint.apply(String,oe)},N=function(q){var oe=[];q=P(q);var de=q.length,ue=e,Te=0,$e=r,Ge=!0,Pe=!1,Ze=void 0;try{for(var He=q[Symbol.iterator](),Ve;!(Ge=(Ve=He.next()).done);Ge=!0){var Ke=Ve.value;Ke<128&&oe.push(p(Ke))}}catch(st){Pe=!0,Ze=st}finally{try{!Ge&&He.return&&He.return()}finally{if(Pe)throw Ze}}var Me=oe.length,Oe=Me;for(Me&&oe.push(n);Oe<de;){var je=I,De=!0,tt=!1,Ue=void 0;try{for(var Qe=q[Symbol.iterator](),ot;!(De=(ot=Qe.next()).done);De=!0){var nt=ot.value;nt>=ue&&nt<je&&(je=nt)}}catch(st){tt=!0,Ue=st}finally{try{!De&&Qe.return&&Qe.return()}finally{if(tt)throw Ue}}var Je=Oe+1;je-ue>C((I-Te)/Je)&&w("overflow"),Te+=(je-ue)*Je,ue=je;var qe=!0,it=!1,et=void 0;try{for(var rt=q[Symbol.iterator](),ut;!(qe=(ut=rt.next()).done);qe=!0){var gt=ut.value;if(gt<ue&&++Te>I&&w("overflow"),gt==ue){for(var lt=Te,ct=m;;ct+=m){var ht=ct<=$e?h:ct>=$e+a?a:ct-$e;if(lt<ht)break;var pt=lt-ht,mt=m-ht;oe.push(p(Z(ht+pt%mt,0))),lt=C(pt/mt)}oe.push(p(Z(lt,0))),$e=u(Te,Je,Oe==Me),Te=0,++Oe}}}catch(st){it=!0,et=st}finally{try{!qe&&rt.return&&rt.return()}finally{if(it)throw et}}++Te,++ue}return oe.join("")},y={version:"2.1.0",ucs2:{decode:P,encode:function(q){return String.fromCodePoint.apply(String,T(q))}},decode:v,encode:N,toASCII:function(q){return $(q,function(oe){return o.test(oe)?"xn--"+N(oe):oe})},toUnicode:function(q){return $(q,function(oe){return s.test(oe)?v(oe.slice(4).toLowerCase()):oe})}},_={};function W(se){var q=se.charCodeAt(0),oe=void 0;return q<16?oe="%0"+q.toString(16).toUpperCase():q<128?oe="%"+q.toString(16).toUpperCase():q<2048?oe="%"+(q>>6|192).toString(16).toUpperCase()+"%"+(q&63|128).toString(16).toUpperCase():oe="%"+(q>>12|224).toString(16).toUpperCase()+"%"+(q>>6&63|128).toString(16).toUpperCase()+"%"+(q&63|128).toString(16).toUpperCase(),oe}function F(se){for(var q="",oe=0,de=se.length;oe<de;){var ue=parseInt(se.substr(oe+1,2),16);if(ue<128)q+=String.fromCharCode(ue),oe+=3;else if(ue>=194&&ue<224){if(de-oe>=6){var Te=parseInt(se.substr(oe+4,2),16);q+=String.fromCharCode((ue&31)<<6|Te&63)}else q+=se.substr(oe,6);oe+=6}else if(ue>=224){if(de-oe>=9){var $e=parseInt(se.substr(oe+4,2),16),Ge=parseInt(se.substr(oe+7,2),16);q+=String.fromCharCode((ue&15)<<12|($e&63)<<6|Ge&63)}else q+=se.substr(oe,9);oe+=9}else q+=se.substr(oe,3),oe+=3}return q}function Y(se,q){function oe(de){var ue=F(de);return ue.match(q.UNRESERVED)?ue:de}return se.scheme&&(se.scheme=String(se.scheme).replace(q.PCT_ENCODED,oe).toLowerCase().replace(q.NOT_SCHEME,"")),se.userinfo!==void 0&&(se.userinfo=String(se.userinfo).replace(q.PCT_ENCODED,oe).replace(q.NOT_USERINFO,W).replace(q.PCT_ENCODED,K)),se.host!==void 0&&(se.host=String(se.host).replace(q.PCT_ENCODED,oe).toLowerCase().replace(q.NOT_HOST,W).replace(q.PCT_ENCODED,K)),se.path!==void 0&&(se.path=String(se.path).replace(q.PCT_ENCODED,oe).replace(se.scheme?q.NOT_PATH:q.NOT_PATH_NOSCHEME,W).replace(q.PCT_ENCODED,K)),se.query!==void 0&&(se.query=String(se.query).replace(q.PCT_ENCODED,oe).replace(q.NOT_QUERY,W).replace(q.PCT_ENCODED,K)),se.fragment!==void 0&&(se.fragment=String(se.fragment).replace(q.PCT_ENCODED,oe).replace(q.NOT_FRAGMENT,W).replace(q.PCT_ENCODED,K)),se}function Q(se){return se.replace(/^0*(.*)/,"$1")||"0"}function z(se,q){var oe=se.match(q.IPV4ADDRESS)||[],de=f(oe,2),ue=de[1];return ue?ue.split(".").map(Q).join("."):se}function te(se,q){var oe=se.match(q.IPV6ADDRESS)||[],de=f(oe,3),ue=de[1],Te=de[2];if(ue){for(var $e=ue.toLowerCase().split("::").reverse(),Ge=f($e,2),Pe=Ge[0],Ze=Ge[1],He=Ze?Ze.split(":").map(Q):[],Ve=Pe.split(":").map(Q),Ke=q.IPV4ADDRESS.test(Ve[Ve.length-1]),Me=Ke?7:8,Oe=Ve.length-Me,je=Array(Me),De=0;De<Me;++De)je[De]=He[De]||Ve[Oe+De]||"";Ke&&(je[Me-1]=z(je[Me-1],q));var tt=je.reduce(function(Je,qe,it){if(!qe||qe==="0"){var et=Je[Je.length-1];et&&et.index+et.length===it?et.length++:Je.push({index:it,length:1})}return Je},[]),Ue=tt.sort(function(Je,qe){return qe.length-Je.length})[0],Qe=void 0;if(Ue&&Ue.length>1){var ot=je.slice(0,Ue.index),nt=je.slice(Ue.index+Ue.length);Qe=ot.join(":")+"::"+nt.join(":")}else Qe=je.join(":");return Te&&(Qe+="%"+Te),Qe}else return se}var E=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,H="".match(/(){0}/)[1]===void 0;function V(se){var q=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},oe={},de=q.iri!==!1?A:L;q.reference==="suffix"&&(se=(q.scheme?q.scheme+":":"")+"//"+se);var ue=se.match(E);if(ue){H?(oe.scheme=ue[1],oe.userinfo=ue[3],oe.host=ue[4],oe.port=parseInt(ue[5],10),oe.path=ue[6]||"",oe.query=ue[7],oe.fragment=ue[8],isNaN(oe.port)&&(oe.port=ue[5])):(oe.scheme=ue[1]||void 0,oe.userinfo=se.indexOf("@")!==-1?ue[3]:void 0,oe.host=se.indexOf("//")!==-1?ue[4]:void 0,oe.port=parseInt(ue[5],10),oe.path=ue[6]||"",oe.query=se.indexOf("?")!==-1?ue[7]:void 0,oe.fragment=se.indexOf("#")!==-1?ue[8]:void 0,isNaN(oe.port)&&(oe.port=se.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?ue[4]:void 0)),oe.host&&(oe.host=te(z(oe.host,de),de)),oe.scheme===void 0&&oe.userinfo===void 0&&oe.host===void 0&&oe.port===void 0&&!oe.path&&oe.query===void 0?oe.reference="same-document":oe.scheme===void 0?oe.reference="relative":oe.fragment===void 0?oe.reference="absolute":oe.reference="uri",q.reference&&q.reference!=="suffix"&&q.reference!==oe.reference&&(oe.error=oe.error||"URI is not a "+q.reference+" reference.");var Te=_[(q.scheme||oe.scheme||"").toLowerCase()];if(!q.unicodeSupport&&(!Te||!Te.unicodeSupport)){if(oe.host&&(q.domainHost||Te&&Te.domainHost))try{oe.host=y.toASCII(oe.host.replace(de.PCT_ENCODED,F).toLowerCase())}catch($e){oe.error=oe.error||"Host's domain name can not be converted to ASCII via punycode: "+$e}Y(oe,L)}else Y(oe,de);Te&&Te.parse&&Te.parse(oe,q)}else oe.error=oe.error||"URI can not be parsed.";return oe}function b(se,q){var oe=q.iri!==!1?A:L,de=[];return se.userinfo!==void 0&&(de.push(se.userinfo),de.push("@")),se.host!==void 0&&de.push(te(z(String(se.host),oe),oe).replace(oe.IPV6ADDRESS,function(ue,Te,$e){return"["+Te+($e?"%25"+$e:"")+"]"})),(typeof se.port=="number"||typeof se.port=="string")&&(de.push(":"),de.push(String(se.port))),de.length?de.join(""):void 0}var S=/^\.\.?\//,R=/^\/\.(\/|$)/,O=/^\/\.\.(\/|$)/,J=/^\/?(?:.|\n)*?(?=\/|$)/;function re(se){for(var q=[];se.length;)if(se.match(S))se=se.replace(S,"");else if(se.match(R))se=se.replace(R,"/");else if(se.match(O))se=se.replace(O,"/"),q.pop();else if(se==="."||se==="..")se="";else{var oe=se.match(J);if(oe){var de=oe[0];se=se.slice(de.length),q.push(de)}else throw new Error("Unexpected dot segment condition")}return q.join("")}function pe(se){var q=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},oe=q.iri?A:L,de=[],ue=_[(q.scheme||se.scheme||"").toLowerCase()];if(ue&&ue.serialize&&ue.serialize(se,q),se.host&&!oe.IPV6ADDRESS.test(se.host)){if(q.domainHost||ue&&ue.domainHost)try{se.host=q.iri?y.toUnicode(se.host):y.toASCII(se.host.replace(oe.PCT_ENCODED,F).toLowerCase())}catch(Ge){se.error=se.error||"Host's domain name can not be converted to "+(q.iri?"Unicode":"ASCII")+" via punycode: "+Ge}}Y(se,oe),q.reference!=="suffix"&&se.scheme&&(de.push(se.scheme),de.push(":"));var Te=b(se,q);if(Te!==void 0&&(q.reference!=="suffix"&&de.push("//"),de.push(Te),se.path&&se.path.charAt(0)!=="/"&&de.push("/")),se.path!==void 0){var $e=se.path;!q.absolutePath&&(!ue||!ue.absolutePath)&&($e=re($e)),Te===void 0&&($e=$e.replace(/^\/\//,"/%2F")),de.push($e)}return se.query!==void 0&&(de.push("?"),de.push(se.query)),se.fragment!==void 0&&(de.push("#"),de.push(se.fragment)),de.join("")}function me(se,q){var oe=arguments.length>2&&arguments[2]!==void 0?arguments[2]:{},de=arguments[3],ue={};return de||(se=V(pe(se,oe),oe),q=V(pe(q,oe),oe)),oe=oe||{},!oe.tolerant&&q.scheme?(ue.scheme=q.scheme,ue.userinfo=q.userinfo,ue.host=q.host,ue.port=q.port,ue.path=re(q.path||""),ue.query=q.query):(q.userinfo!==void 0||q.host!==void 0||q.port!==void 0?(ue.userinfo=q.userinfo,ue.host=q.host,ue.port=q.port,ue.path=re(q.path||""),ue.query=q.query):(q.path?(q.path.charAt(0)==="/"?ue.path=re(q.path):((se.userinfo!==void 0||se.host!==void 0||se.port!==void 0)&&!se.path?ue.path="/"+q.path:se.path?ue.path=se.path.slice(0,se.path.lastIndexOf("/")+1)+q.path:ue.path=q.path,ue.path=re(ue.path)),ue.query=q.query):(ue.path=se.path,q.query!==void 0?ue.query=q.query:ue.query=se.query),ue.userinfo=se.userinfo,ue.host=se.host,ue.port=se.port),ue.scheme=se.scheme),ue.fragment=q.fragment,ue}function ye(se,q,oe){var de=X({scheme:"null"},oe);return pe(me(V(se,de),V(q,de),de,!0),de)}function xe(se,q){return typeof se=="string"?se=pe(V(se,q),q):M(se)==="object"&&(se=V(pe(se,q),q)),se}function Ie(se,q,oe){return typeof se=="string"?se=pe(V(se,oe),oe):M(se)==="object"&&(se=pe(se,oe)),typeof q=="string"?q=pe(V(q,oe),oe):M(q)==="object"&&(q=pe(q,oe)),se===q}function we(se,q){return se&&se.toString().replace(!q||!q.iri?L.ESCAPE:A.ESCAPE,W)}function Ae(se,q){return se&&se.toString().replace(!q||!q.iri?L.PCT_ENCODED:A.PCT_ENCODED,F)}var _e={scheme:"http",domainHost:!0,parse:function(q,oe){return q.host||(q.error=q.error||"HTTP URIs must have a host."),q},serialize:function(q,oe){var de=String(q.scheme).toLowerCase()==="https";return(q.port===(de?443:80)||q.port==="")&&(q.port=void 0),q.path||(q.path="/"),q}},We={scheme:"https",domainHost:_e.domainHost,parse:_e.parse,serialize:_e.serialize};function ke(se){return typeof se.secure=="boolean"?se.secure:String(se.scheme).toLowerCase()==="wss"}var le={scheme:"ws",domainHost:!0,parse:function(q,oe){var de=q;return de.secure=ke(de),de.resourceName=(de.path||"/")+(de.query?"?"+de.query:""),de.path=void 0,de.query=void 0,de},serialize:function(q,oe){if((q.port===(ke(q)?443:80)||q.port==="")&&(q.port=void 0),typeof q.secure=="boolean"&&(q.scheme=q.secure?"wss":"ws",q.secure=void 0),q.resourceName){var de=q.resourceName.split("?"),ue=f(de,2),Te=ue[0],$e=ue[1];q.path=Te&&Te!=="/"?Te:void 0,q.query=$e,q.resourceName=void 0}return q.fragment=void 0,q}},fe={scheme:"wss",domainHost:le.domainHost,parse:le.parse,serialize:le.serialize},be={},ve="[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]",ne="[0-9A-Fa-f]",ie=k(k("%[EFef]"+ne+"%"+ne+ne+"%"+ne+ne)+"|"+k("%[89A-Fa-f]"+ne+"%"+ne+ne)+"|"+k("%"+ne+ne)),ge="[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]",Se=U("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),Le="[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]",Be=new RegExp(ve,"g"),ee=new RegExp(ie,"g"),ae=new RegExp(U("[^]",ge,"[\\.]",'[\\"]',Se),"g"),he=new RegExp(U("[^]",ve,Le),"g"),Ce=he;function Re(se){var q=F(se);return q.match(Be)?q:se}var Ee={scheme:"mailto",parse:function(q,oe){var de=q,ue=de.to=de.path?de.path.split(","):[];if(de.path=void 0,de.query){for(var Te=!1,$e={},Ge=de.query.split("&"),Pe=0,Ze=Ge.length;Pe<Ze;++Pe){var He=Ge[Pe].split("=");switch(He[0]){case"to":for(var Ve=He[1].split(","),Ke=0,Me=Ve.length;Ke<Me;++Ke)ue.push(Ve[Ke]);break;case"subject":de.subject=Ae(He[1],oe);break;case"body":de.body=Ae(He[1],oe);break;default:Te=!0,$e[Ae(He[0],oe)]=Ae(He[1],oe);break}}Te&&(de.headers=$e)}de.query=void 0;for(var Oe=0,je=ue.length;Oe<je;++Oe){var De=ue[Oe].split("@");if(De[0]=Ae(De[0]),oe.unicodeSupport)De[1]=Ae(De[1],oe).toLowerCase();else try{De[1]=y.toASCII(Ae(De[1],oe).toLowerCase())}catch(tt){de.error=de.error||"Email address's domain name can not be converted to ASCII via punycode: "+tt}ue[Oe]=De.join("@")}return de},serialize:function(q,oe){var de=q,ue=j(q.to);if(ue){for(var Te=0,$e=ue.length;Te<$e;++Te){var Ge=String(ue[Te]),Pe=Ge.lastIndexOf("@"),Ze=Ge.slice(0,Pe).replace(ee,Re).replace(ee,K).replace(ae,W),He=Ge.slice(Pe+1);try{He=oe.iri?y.toUnicode(He):y.toASCII(Ae(He,oe).toLowerCase())}catch(Oe){de.error=de.error||"Email address's domain name can not be converted to "+(oe.iri?"Unicode":"ASCII")+" via punycode: "+Oe}ue[Te]=Ze+"@"+He}de.path=ue.join(",")}var Ve=q.headers=q.headers||{};q.subject&&(Ve.subject=q.subject),q.body&&(Ve.body=q.body);var Ke=[];for(var Me in Ve)Ve[Me]!==be[Me]&&Ke.push(Me.replace(ee,Re).replace(ee,K).replace(he,W)+"="+Ve[Me].replace(ee,Re).replace(ee,K).replace(Ce,W));return Ke.length&&(de.query=Ke.join("&")),de}},Ne=/^([^\:]+)\:(.*)/,Fe={scheme:"urn",parse:function(q,oe){var de=q.path&&q.path.match(Ne),ue=q;if(de){var Te=oe.scheme||ue.scheme||"urn",$e=de[1].toLowerCase(),Ge=de[2],Pe=Te+":"+(oe.nid||$e),Ze=_[Pe];ue.nid=$e,ue.nss=Ge,ue.path=void 0,Ze&&(ue=Ze.parse(ue,oe))}else ue.error=ue.error||"URN can not be parsed.";return ue},serialize:function(q,oe){var de=oe.scheme||q.scheme||"urn",ue=q.nid,Te=de+":"+(oe.nid||ue),$e=_[Te];$e&&(q=$e.serialize(q,oe));var Ge=q,Pe=q.nss;return Ge.path=(ue||oe.nid)+":"+Pe,Ge}},ze=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,Xe={scheme:"urn:uuid",parse:function(q,oe){var de=q;return de.uuid=de.nss,de.nss=void 0,!oe.tolerant&&(!de.uuid||!de.uuid.match(ze))&&(de.error=de.error||"UUID is not valid."),de},serialize:function(q,oe){var de=q;return de.nss=(q.uuid||"").toLowerCase(),de}};_[_e.scheme]=_e,_[We.scheme]=We,_[le.scheme]=le,_[fe.scheme]=fe,_[Ee.scheme]=Ee,_[Fe.scheme]=Fe,_[Xe.scheme]=Xe,D.SCHEMES=_,D.pctEncChar=W,D.pctDecChars=F,D.parse=V,D.removeDotSegments=re,D.serialize=pe,D.resolveComponents=me,D.resolve=ye,D.normalize=xe,D.equal=Ie,D.escapeComponent=we,D.unescapeComponent=Ae,Object.defineProperty(D,"__esModule",{value:!0})})(g)},4049:function(ce){ce.exports=function(){var g=function(r,e){if(!(r instanceof e))throw new TypeError("Cannot call a class as a function")},D=function(){function r(e,n){for(var s=0;s<n.length;s++){var o=n[s];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}return function(e,n,s){return n&&r(e.prototype,n),s&&r(e,s),e}}(),U=function(){function r(e,n){var s=[],o=!0,i=!1,c=void 0;try{for(var d=e[Symbol.iterator](),C;!(o=(C=d.next()).done)&&(s.push(C.value),!(n&&s.length===n));o=!0);}catch(p){i=!0,c=p}finally{try{!o&&d.return&&d.return()}finally{if(i)throw c}}return s}return function(e,n){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return r(e,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),k=(String.prototype.startsWith=String.prototype.startsWith||function(r){return this.indexOf(r)===0},String.prototype.padStart=String.prototype.padStart||function(r,e){for(var n=this;n.length<r;)n=e+n;return n},{cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"});function M(r){var e=arguments.length>1&&arguments[1]!==void 0?arguments[1]:1,n=e>0?r.toFixed(e).replace(/0+$/,"").replace(/\.$/,""):r.toString();return n||"0"}var K=function(){function r(e,n,s,o){g(this,r);var i=this;function c(C){if(C.startsWith("hsl")){var p=C.match(/([\-\d\.e]+)/g).map(Number),w=U(p,4),x=w[0],$=w[1],P=w[2],B=w[3];B===void 0&&(B=1),x/=360,$/=100,P/=100,i.hsla=[x,$,P,B]}else if(C.startsWith("rgb")){var Z=C.match(/([\-\d\.e]+)/g).map(Number),u=U(Z,4),v=u[0],N=u[1],y=u[2],_=u[3];_===void 0&&(_=1),i.rgba=[v,N,y,_]}else C.startsWith("#")?i.rgba=r.hexToRgb(C):i.rgba=r.nameToRgb(C)||r.hexToRgb(C)}if(e!==void 0)if(Array.isArray(e))this.rgba=e;else if(s===void 0){var d=e&&""+e;d&&c(d.toLowerCase())}else this.rgba=[e,n,s,o===void 0?1:o]}return D(r,[{key:"printRGB",value:function(n){var s=n?this.rgba:this.rgba.slice(0,3),o=s.map(function(i,c){return M(i,c===3?3:0)});return n?"rgba("+o+")":"rgb("+o+")"}},{key:"printHSL",value:function(n){var s=[360,100,100,1],o=["","%","%",""],i=n?this.hsla:this.hsla.slice(0,3),c=i.map(function(d,C){return M(d*s[C],C===3?3:1)+o[C]});return n?"hsla("+c+")":"hsl("+c+")"}},{key:"printHex",value:function(n){var s=this.hex;return n?s:s.substring(0,7)}},{key:"rgba",get:function(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=r.hslToRgb(this._hsla)},set:function(n){n.length===3&&(n[3]=1),this._rgba=n,this._hsla=null}},{key:"rgbString",get:function(){return this.printRGB()}},{key:"rgbaString",get:function(){return this.printRGB(!0)}},{key:"hsla",get:function(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=r.rgbToHsl(this._rgba)},set:function(n){n.length===3&&(n[3]=1),this._hsla=n,this._rgba=null}},{key:"hslString",get:function(){return this.printHSL()}},{key:"hslaString",get:function(){return this.printHSL(!0)}},{key:"hex",get:function(){var n=this.rgba,s=n.map(function(o,i){return i<3?o.toString(16):Math.round(o*255).toString(16)});return"#"+s.map(function(o){return o.padStart(2,"0")}).join("")},set:function(n){this.rgba=r.hexToRgb(n)}}],[{key:"hexToRgb",value:function(n){var s=(n.startsWith("#")?n.slice(1):n).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!s.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+n);var o=s.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(i){return parseInt(i,16)});return o[3]=o[3]/255,o}},{key:"nameToRgb",value:function(n){var s=n.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght","L").replace("rk","D").slice(-5,4),o=k[s];return o===void 0?o:r.hexToRgb(o.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function(n){var s=U(n,4),o=s[0],i=s[1],c=s[2],d=s[3];o/=255,i/=255,c/=255;var C=Math.max(o,i,c),p=Math.min(o,i,c),w=void 0,x=void 0,$=(C+p)/2;if(C===p)w=x=0;else{var P=C-p;switch(x=$>.5?P/(2-C-p):P/(C+p),C){case o:w=(i-c)/P+(i<c?6:0);break;case i:w=(c-o)/P+2;break;case c:w=(o-i)/P+4;break}w/=6}return[w,x,$,d]}},{key:"hslToRgb",value:function(n){var s=U(n,4),o=s[0],i=s[1],c=s[2],d=s[3],C=void 0,p=void 0,w=void 0;if(i===0)C=p=w=c;else{var x=function(u,v,N){return N<0&&(N+=1),N>1&&(N-=1),N<.16666666666666666?u+(v-u)*6*N:N<.5?v:N<.6666666666666666?u+(v-u)*(.6666666666666666-N)*6:u},$=c<.5?c*(1+i):c+i-c*i,P=2*c-$;C=x(P,$,o+1/3),p=x(P,$,o),w=x(P,$,o-1/3)}var B=[C*255,p*255,w*255].map(Math.round);return B[3]=d,B}}]),r}(),j=function(){function r(){g(this,r),this._events=[]}return D(r,[{key:"add",value:function(n,s,o){n.addEventListener(s,o,!1),this._events.push({target:n,type:s,handler:o})}},{key:"remove",value:function(n,s,o){this._events=this._events.filter(function(i){var c=!0;return n&&n!==i.target&&(c=!1),s&&s!==i.type&&(c=!1),o&&o!==i.handler&&(c=!1),c&&r._doRemove(i.target,i.type,i.handler),!c})}},{key:"destroy",value:function(){this._events.forEach(function(n){return r._doRemove(n.target,n.type,n.handler)}),this._events=[]}}],[{key:"_doRemove",value:function(n,s,o){n.removeEventListener(s,o,!1)}}]),r}();function X(r){var e=document.createElement("div");return e.innerHTML=r,e.firstElementChild}function G(r,e,n){var s=!1;function o(C,p,w){return Math.max(p,Math.min(C,w))}function i(C,p,w){if(w&&(s=!0),!!s){C.preventDefault();var x=e.getBoundingClientRect(),$=x.width,P=x.height,B=p.clientX,Z=p.clientY,u=o(B-x.left,0,$),v=o(Z-x.top,0,P);n(u/$,v/P)}}function c(C,p){var w=C.buttons===void 0?C.which:C.buttons;w===1?i(C,C,p):s=!1}function d(C,p){C.touches.length===1?i(C,C.touches[0],p):s=!1}r.add(e,"mousedown",function(C){c(C,!0)}),r.add(e,"touchstart",function(C){d(C,!0)}),r.add(window,"mousemove",c),r.add(e,"touchmove",d),r.add(window,"mouseup",function(C){s=!1}),r.add(e,"touchend",function(C){s=!1}),r.add(e,"touchcancel",function(C){s=!1})}var L=`linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0 / 2em 2em,
                   linear-gradient(45deg, lightgrey 25%,       white 25%,       white 75%, lightgrey 75%) 1em 1em / 2em 2em`,A=360,f="keydown",T="mousedown",I="focusin";function m(r,e){return(e||document).querySelector(r)}function h(r){r.preventDefault(),r.stopPropagation()}function a(r,e,n,s,o){r.add(e,f,function(i){n.indexOf(i.key)>=0&&(o&&h(i),s(i))})}var l=function(){function r(e){g(this,r),this.settings={popup:"right",layout:"default",alpha:!0,editor:!0,editorFormat:"hex",cancelButton:!1,defaultColor:"#0cf"},this._events=new j,this.onChange=null,this.onDone=null,this.onOpen=null,this.onClose=null,this.setOptions(e)}return D(r,[{key:"setOptions",value:function(n){var s=this;if(!n)return;var o=this.settings;function i(p,w,x){for(var $ in p)x&&x.indexOf($)>=0||(w[$]=p[$])}if(n instanceof HTMLElement)o.parent=n;else{o.parent&&n.parent&&o.parent!==n.parent&&(this._events.remove(o.parent),this._popupInited=!1),i(n,o),n.onChange&&(this.onChange=n.onChange),n.onDone&&(this.onDone=n.onDone),n.onOpen&&(this.onOpen=n.onOpen),n.onClose&&(this.onClose=n.onClose);var c=n.color||n.colour;c&&this._setColor(c)}var d=o.parent;if(d&&o.popup&&!this._popupInited){var C=function(w){return s.openHandler(w)};this._events.add(d,"click",C),a(this._events,d,[" ","Spacebar","Enter"],C),this._popupInited=!0}else n.parent&&!o.popup&&this.show()}},{key:"openHandler",value:function(n){if(this.show()){n&&n.preventDefault(),this.settings.parent.style.pointerEvents="none";var s=n&&n.type===f?this._domEdit:this.domElement;setTimeout(function(){return s.focus()},100),this.onOpen&&this.onOpen(this.colour)}}},{key:"closeHandler",value:function(n){var s=n&&n.type,o=!1;if(!n)o=!0;else if(s===T||s===I){var i=(this.__containedEvent||0)+100;n.timeStamp>i&&(o=!0)}else h(n),o=!0;o&&this.hide()&&(this.settings.parent.style.pointerEvents="",s!==T&&this.settings.parent.focus(),this.onClose&&this.onClose(this.colour))}},{key:"movePopup",value:function(n,s){this.closeHandler(),this.setOptions(n),s&&this.openHandler()}},{key:"setColor",value:function(n,s){this._setColor(n,{silent:s})}},{key:"_setColor",value:function(n,s){if(typeof n=="string"&&(n=n.trim()),!!n){s=s||{};var o=void 0;try{o=new K(n)}catch(c){if(s.failSilently)return;throw c}if(!this.settings.alpha){var i=o.hsla;i[3]=1,o.hsla=i}this.colour=this.color=o,this._setHSLA(null,null,null,null,s)}}},{key:"setColour",value:function(n,s){this.setColor(n,s)}},{key:"show",value:function(){var n=this.settings.parent;if(!n)return!1;if(this.domElement){var s=this._toggleDOM(!0);return this._setPosition(),s}var o=this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>',i=X(o);return this.domElement=i,this._domH=m(".picker_hue",i),this._domSL=m(".picker_sl",i),this._domA=m(".picker_alpha",i),this._domEdit=m(".picker_editor input",i),this._domSample=m(".picker_sample",i),this._domOkay=m(".picker_done button",i),this._domCancel=m(".picker_cancel button",i),i.classList.add("layout_"+this.settings.layout),this.settings.alpha||i.classList.add("no_alpha"),this.settings.editor||i.classList.add("no_editor"),this.settings.cancelButton||i.classList.add("no_cancel"),this._ifPopup(function(){return i.classList.add("popup")}),this._setPosition(),this.colour?this._updateUI():this._setColor(this.settings.defaultColor),this._bindEvents(),!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"destroy",value:function(){this._events.destroy(),this.domElement&&this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function(){var n=this,s=this,o=this.domElement,i=this._events;function c(p,w,x){i.add(p,w,x)}c(o,"click",function(p){return p.preventDefault()}),G(i,this._domH,function(p,w){return s._setHSLA(p)}),G(i,this._domSL,function(p,w){return s._setHSLA(null,p,1-w)}),this.settings.alpha&&G(i,this._domA,function(p,w){return s._setHSLA(null,null,null,1-w)});var d=this._domEdit;c(d,"input",function(p){s._setColor(this.value,{fromEditor:!0,failSilently:!0})}),c(d,"focus",function(p){var w=this;w.selectionStart===w.selectionEnd&&w.select()}),this._ifPopup(function(){var p=function($){return n.closeHandler($)};c(window,T,p),c(window,I,p),a(i,o,["Esc","Escape"],p);var w=function($){n.__containedEvent=$.timeStamp};c(o,T,w),c(o,I,w),c(n._domCancel,"click",p)});var C=function(w){n._ifPopup(function(){return n.closeHandler(w)}),n.onDone&&n.onDone(n.colour)};c(this._domOkay,"click",C),a(i,o,["Enter"],C)}},{key:"_setPosition",value:function(){var n=this.settings.parent,s=this.domElement;n!==s.parentNode&&n.appendChild(s),this._ifPopup(function(o){getComputedStyle(n).position==="static"&&(n.style.position="relative");var i=o===!0?"popup_right":"popup_"+o;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(c){c===i?s.classList.add(c):s.classList.remove(c)}),s.classList.add(i)})}},{key:"_setHSLA",value:function(n,s,o,i,c){c=c||{};var d=this.colour,C=d.hsla;[n,s,o,i].forEach(function(p,w){(p||p===0)&&(C[w]=p)}),d.hsla=C,this._updateUI(c),this.onChange&&!c.silent&&this.onChange(d)}},{key:"_updateUI",value:function(n){if(!this.domElement)return;n=n||{};var s=this.colour,o=s.hsla,i="hsl("+o[0]*A+", 100%, 50%)",c=s.hslString,d=s.hslaString,C=this._domH,p=this._domSL,w=this._domA,x=m(".picker_selector",C),$=m(".picker_selector",p),P=m(".picker_selector",w);function B(F,Y,Q){Y.style.left=Q*100+"%"}function Z(F,Y,Q){Y.style.top=Q*100+"%"}B(C,x,o[0]),this._domSL.style.backgroundColor=this._domH.style.color=i,B(p,$,o[1]),Z(p,$,1-o[2]),p.style.color=c,Z(w,P,1-o[3]);var u=c,v=u.replace("hsl","hsla").replace(")",", 0)"),N="linear-gradient("+[u,v]+")";if(this._domA.style.background=N+", "+L,!n.fromEditor){var y=this.settings.editorFormat,_=this.settings.alpha,W=void 0;switch(y){case"rgb":W=s.printRGB(_);break;case"hsl":W=s.printHSL(_);break;default:W=s.printHex(_)}this._domEdit.value=W}this._domSample.style.color=d}},{key:"_ifPopup",value:function(n,s){this.settings.parent&&this.settings.popup?n&&n(this.settings.popup):s&&s()}},{key:"_toggleDOM",value:function(n){var s=this.domElement;if(!s)return!1;var o=n?"":"none",i=s.style.display!==o;return i&&(s.style.display=o),i}}]),r}(),t=document.createElement("style");return t.textContent='.picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:flex;flex-flow:row wrap;justify-content:space-between;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:"";display:block;width:100%;height:0;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{flex:1 1 auto}.layout_default .picker_sl::before{content:"";display:block;padding-bottom:100%}.layout_default .picker_editor{order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{order:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px #1e90ff}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:#f5f5f5;background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:#fff}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid #fff;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:linear-gradient(180deg, white, rgba(255, 255, 255, 0) 50%),linear-gradient(0deg, black, rgba(0, 0, 0, 0) 50%),linear-gradient(90deg, #808080, rgba(128, 128, 128, 0))}.picker_alpha,.picker_sample{position:relative;background:linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0/2em 2em,linear-gradient(45deg, lightgrey 25%, white 25%, white 75%, lightgrey 75%) 1em 1em/2em 2em;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:"";position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:"";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}',document.documentElement.firstElementChild.appendChild(t),l.StyleElement=t,l}()},1262:function(ce,g,D){function U(ne){return(U=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(ie){return typeof ie}:function(ie){return ie&&typeof Symbol=="function"&&ie.constructor===Symbol&&ie!==Symbol.prototype?"symbol":typeof ie})(ne)}function k(ne){var ie=j();return function(){var ge,Se=G(ne),Se=(ge=ie?(ge=G(this).constructor,Reflect.construct(Se,arguments,ge)):Se.apply(this,arguments),this);if(ge&&(U(ge)==="object"||typeof ge=="function"))return ge;if(ge!==void 0)throw new TypeError("Derived constructors may only return object or undefined");if(Se!==void 0)return Se;throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}}function M(ne){var ie=typeof Map=="function"?new Map:void 0;return function(ge){if(ge===null||Function.toString.call(ge).indexOf("[native code]")===-1)return ge;if(typeof ge!="function")throw new TypeError("Super expression must either be null or a function");if(ie!==void 0){if(ie.has(ge))return ie.get(ge);ie.set(ge,Se)}function Se(){return K(ge,arguments,G(this).constructor)}return Se.prototype=Object.create(ge.prototype,{constructor:{value:Se,enumerable:!1,writable:!0,configurable:!0}}),X(Se,ge)}(ne)}function K(ne,ie,ge){return(K=j()?Reflect.construct.bind():function(Se,Le,Be){var ee=[null];return ee.push.apply(ee,Le),Le=new(Function.bind.apply(Se,ee)),Be&&X(Le,Be.prototype),Le}).apply(null,arguments)}function j(){if(typeof Reflect>"u"||!Reflect.construct||Reflect.construct.sham)return!1;if(typeof Proxy=="function")return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){})),!0}catch{return!1}}function X(ne,ie){return(X=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(ge,Se){return ge.__proto__=Se,ge})(ne,ie)}function G(ne){return(G=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(ie){return ie.__proto__||Object.getPrototypeOf(ie)})(ne)}D.d(g,{K:function(){return ve}});var L=function(ne){var ie=Se;if(typeof ne!="function"&&ne!==null)throw new TypeError("Super expression must either be null or a function");ie.prototype=Object.create(ne&&ne.prototype,{constructor:{value:ie,writable:!0,configurable:!0}}),Object.defineProperty(ie,"prototype",{writable:!1}),ne&&X(ie,ne);var ge=k(Se);function Se(Le,Be){if(this instanceof Se)return(Le=ge.call(this,Le+" at position "+Be)).position=Be,Le;throw new TypeError("Cannot call a class as a function")}return ie=Se,Object.defineProperty(ie,"prototype",{writable:!1}),ie}(M(Error)),A=92,f=47,T=42,I=123,m=125,h=91,a=93,l=40,t=41,r=32,e=10,n=9,s=13,o=8,i=12,c=34,d=43,C=45,p=39,w=48,x=49,$=57,P=44,B=46,Z=58,u=59,v=65,N=97,y=69,_=101,W=70,F=102,Y=160,Q=8192,z=8202,te=8239,E=8287,H=12288,V=8220,b=8221,S=8216,R=8217,O=96,J=180;function re(ne){return w<=ne&&ne<=$||v<=ne&&ne<=W||N<=ne&&ne<=F}function pe(ne){return w<=ne&&ne<=$}var me=/^[,:[\]{}()\n]$/;function ye(ne){return xe.test(ne)||ne&&we(ne.charCodeAt(0))}var xe=/^[[{\w-]$/;function Ie(ne){return ne===r||ne===e||ne===n||ne===s}function we(ne){return Ae(ne)||We(ne)}function Ae(ne){return ne===c||ne===V||ne===b}function _e(ne){return ne===c}function We(ne){return ne===p||ne===S||ne===R||ne===O||ne===J}function ke(ne,ie,ge){return ge=2<arguments.length&&ge!==void 0&&ge,ie=ne.lastIndexOf(ie),ie!==-1?ne.substring(0,ie)+(ge?"":ne.substring(ie+1)):ne}function le(ne,ie){var ge=ne.length;if(!Ie(ne.charCodeAt(ge-1)))return ne+ie;for(;Ie(ne.charCodeAt(ge-1));)ge--;return ne.substring(0,ge)+ie+ne.substring(ge)}var fe={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","	":"\\t"},be={'"':'"',"\\":"\\","/":"/",b:"\b",f:"\f",n:`
`,r:"\r",t:"	"};function ve(ne){var ie=0,ge="";if(!ee())throw new L("Unexpected end of json string",ne.length);var Se=Ce(P);if(Se&&ae(),ye(ne[ie])&&/[,\n][ \t\r]*$/.test(ge)){Se||(ge=le(ge,","));for(var Le=!0,Be=!0;Be;)Le?Le=!1:Ce(P)||(ge=le(ge,",")),Be=ee();Be||(ge=ke(ge,",")),ge=`[
`.concat(ge,`
]`)}else Se&&(ge=ke(ge,","));if(ie>=ne.length)return ge;throw new L("Unexpected character "+JSON.stringify(ne[ie]),ie);function ee(){ae();var q=function(){if(ne.charCodeAt(ie)!==I)return!1;ge+="{",ie++,ae();for(var oe=!0;ie<ne.length&&ne.charCodeAt(ie)!==m;){if(oe?oe=!1:(Ce(P)||(ge=le(ge,",")),ae()),!(Ee()||Fe())){ne.charCodeAt(ie)===m||ne.charCodeAt(ie)===I||ne.charCodeAt(ie)===a||ne.charCodeAt(ie)===h||ne[ie]===void 0?ge=ke(ge,","):function(){throw new L("Object key expected",ie)}();break}ae();var de=Ce(Z);de||(ye(ne[ie])?ge=le(ge,":"):se()),ee()||(de?function(){throw new L("Object value expected",ie)}:se)()}return ne.charCodeAt(ie)===m?(ge+="}",ie++):ge=le(ge,"}"),!0}()||function(){if(ne.charCodeAt(ie)!==h)return!1;ge+="[",ie++,ae();for(var oe=!0;ie<ne.length&&ne.charCodeAt(ie)!==a;)if(oe?oe=!1:Ce(P)||(ge=le(ge,",")),!ee()){ge=ke(ge,",");break}return ne.charCodeAt(ie)===a?(ge+="]",ie++):ge=le(ge,"]"),!0}()||Ee()||function(){var oe=ie;if(ne.charCodeAt(ie)===C&&(ie++,Xe(oe)))return!0;if(ne.charCodeAt(ie)===w)ie++;else if(function(de){return x<=de&&de<=$}(ne.charCodeAt(ie)))for(ie++;pe(ne.charCodeAt(ie));)ie++;if(ne.charCodeAt(ie)===B){if(ie++,Xe(oe))return!0;for(;pe(ne.charCodeAt(ie));)ie++}if(ne.charCodeAt(ie)===_||ne.charCodeAt(ie)===y){if(ie++,ne.charCodeAt(ie)!==C&&ne.charCodeAt(ie)!==d||ie++,Xe(oe))return!0;for(;pe(ne.charCodeAt(ie));)ie++}return oe<ie?(ge+=ne.slice(oe,ie),!0):!1}()||Ne("true","true")||Ne("false","false")||Ne("null","null")||Ne("True","true")||Ne("False","false")||Ne("None","null")||Fe();return ae(),q}function ae(){for(he();function(){if(ne.charCodeAt(ie)===f&&ne.charCodeAt(ie+1)===T){for(;ie<ne.length&&!function(q,oe){return q[oe]==="*"&&q[oe+1]==="/"}(ne,ie);)ie++;ie+=2}else{if(ne.charCodeAt(ie)!==f||ne.charCodeAt(ie+1)!==f)return!1;for(;ie<ne.length&&ne.charCodeAt(ie)!==e;)ie++}return!0}()&&he(););}function he(){for(var q,oe,de="";(q=Ie(ne.charCodeAt(ie)))||(oe=ne.charCodeAt(ie))===Y||Q<=oe&&oe<=z||oe===te||oe===E||oe===H;)de+=q?ne[ie]:" ",ie++;return 0<de.length&&(ge+=de,!0)}function Ce(q){return ne.charCodeAt(ie)===q&&(ge+=ne[ie],ie++,!0)}function Re(){return q=A,ne.charCodeAt(ie)===q&&(ie++,!0);var q}function Ee(){var q,oe=ne.charCodeAt(ie)===A;if(oe&&(ie++,oe=!0),we(ne.charCodeAt(ie))){var de=We(ne.charCodeAt(ie))?We:_e(ne.charCodeAt(ie))?_e:Ae;for(ge+='"',ie++;ie<ne.length&&!de(ne.charCodeAt(ie));){if(ne.charCodeAt(ie)===A){var ue=ne[ie+1];if(be[ue]!==void 0)ge+=ne.slice(ie,ie+2),ie+=2;else if(ue==="u"){if(!(re(ne.charCodeAt(ie+2))&&re(ne.charCodeAt(ie+3))&&re(ne.charCodeAt(ie+4))&&re(ne.charCodeAt(ie+5)))){$e=Te=void 0;for(var Te=ie,$e=Te+2;/\w/.test(ne[$e]);)$e++;throw Te=ne.slice(Te,$e),new L('Invalid unicode character "'.concat(Te,'"'),ie)}ge+=ne.slice(ie,ie+6),ie+=6}else ge+=ue,ie+=2}else{if(Te=ne[ie],ue=ne.charCodeAt(ie),ue===c&&ne.charCodeAt(ie-1)!==A)ge+="\\"+Te;else if((q=ue)===e||q===s||q===n||q===o||q===i)ge+=fe[Te];else{if(!(32<=(q=ue)&&q<=1114111))throw new L("Invalid character "+JSON.stringify(Te),ie);ge+=Te}ie++}oe&&Re()}for(we(ne.charCodeAt(ie))?(ne.charCodeAt(ie),ge+='"',ie++):ge+='"',ae();ne.charCodeAt(ie)===d;){ie++,ae();var Ge=(ge=ke(ge,'"',!0)).length;Ee(),ge=function(Pe,Ze,He){return Pe.substring(0,Ze)+Pe.substring(Ze+He)}(ge,Ge,1)}return!0}return!1}function Ne(q,oe){return ne.slice(ie,ie+q.length)===q&&(ge+=oe,ie+=q.length,!0)}function Fe(){for(var q,oe=ie;ie<ne.length&&(q=ne[ie],!(me.test(q)||q&&we(q.charCodeAt(0))));)ie++;if(oe<ie){if(ne.charCodeAt(ie)===l)ie++,ee(),ne.charCodeAt(ie)===t&&(ie++,ne.charCodeAt(ie)===u)&&ie++;else{for(;Ie(ne.charCodeAt(ie-1))&&0<ie;)ie--;oe=ne.slice(oe,ie),ge+=JSON.stringify(oe)}return!0}}function ze(q){if(!pe(ne.charCodeAt(ie)))throw q=ne.slice(q,ie),new L("Invalid number '".concat(q,"', expecting a digit ").concat(ne[ie]?"but got '".concat(ne[ie],"'"):"but reached end of input"),2)}function Xe(q){if(ie>=ne.length)return ge+=ne.slice(q,ie)+"0",1;ze(q)}function se(){throw new L("Colon expected",ie)}}},894:function(ce){ce.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}')},7171:function(ce){ce.exports=JSON.parse('{"id":"http://json-schema.org/draft-04/schema#","$schema":"http://json-schema.org/draft-04/schema#","description":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"positiveInteger":{"type":"integer","minimum":0},"positiveIntegerDefault0":{"allOf":[{"$ref":"#/definitions/positiveInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"minItems":1,"uniqueItems":true}},"type":"object","properties":{"id":{"type":"string"},"$schema":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"multipleOf":{"type":"number","minimum":0,"exclusiveMinimum":true},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"boolean","default":false},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"boolean","default":false},"maxLength":{"$ref":"#/definitions/positiveInteger"},"minLength":{"$ref":"#/definitions/positiveIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/positiveInteger"},"minItems":{"$ref":"#/definitions/positiveIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"maxProperties":{"$ref":"#/definitions/positiveInteger"},"minProperties":{"$ref":"#/definitions/positiveIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"dependencies":{"exclusiveMaximum":["maximum"],"exclusiveMinimum":["minimum"]},"default":{}}')},6273:function(ce){ce.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","addi